#include "basic.h"
#include "basicdlg.h"

BasicDialog::BasicDialog( wxWindow *parent,
                          wxWindowID id,
                          const wxString &title,
                          const wxPoint &position,
                          const wxSize& size,
                          long style
                        ) : wxDialog( parent, id, title, position, size, style )
{
  wxString theTextData = "";
  wxString info = "System information\n"
                  "------------------\n\n"; 
  char mem[100];
  
  wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );

  theTextData.append("Thou art, indeed, just O Lord if I contend with Thee.\n"
                     "But sir: what I plead is just.\n"
                     "Why do sinner's ways prosper?\n"
                     "And why does disappointment all I endeavour end?\n"
                     "Wert Thou my enemy, O Thou my friend,\n"
                     "How wouldst Thou defeat and thwart me.\n\n"
                    ); 

  // create text ctrl with minimal size 150 x 100
  dialogText = new wxTextCtrl( this, -1,
                               theTextData,
                               wxDefaultPosition,
                               wxSize(150, 100),
                               wxTE_MULTILINE
                             );
    
  dialogText->SetBackgroundColour(wxColour(0,0,0));
  dialogText->SetForegroundColour(wxColour(255,255,255));
  info.append(wxGetOsDescription()); 	info.append("\n");
  info.append(wxGetHomeDir()); 		info.append("\n");
  sprintf(mem,"Free memory %ld  bytes", wxGetFreeMemory());
  info.append(mem); 			info.append("\n");
  info.append(wxNow());			info.append("\n");
//  info.append(wxGetFullHostName());	info.append("\n");

  dialogText->AppendText(info);
  
  topsizer->Add( dialogText, 
                 1,                // make vertically stretchable
                 wxEXPAND | wxALL, // horizontally stretchable and make border all around
                 10                // set border width to 10
               );

  wxBoxSizer *button_sizer = new wxBoxSizer( wxHORIZONTAL );

  button_sizer->Add
   ( new wxButton( this, wxID_OK, "OK" ),
     0,                                    // make horizontally unstretchable
     wxALL,                                // make border all around (implicit top alignment)
     10 );                                 // set border width to 10

  button_sizer->Add(
     new wxButton( this, wxID_CANCEL, "Cancel" ),
     0,           // make horizontally unstretchable
     wxALL,       // make border all around (implicit top alignment)
     10 );        // set border width to 10

  topsizer->Add(
     button_sizer,
     0,                // make vertically unstretchable
     wxALIGN_CENTER ); // no border and centre horizontally

  topsizer->Add(
  	new wxStaticText( this, -1, "A static text control\nLine two", wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE),
  	0,
  	wxALL,
  	10
  );
  SetAutoLayout( TRUE );     // tell dialog to use sizer
  SetSizer( topsizer );      // actually set the sizer

  topsizer->Fit( this );            // set size to minimum size as calculated by the sizer
  topsizer->SetSizeHints( this );   // set size hints to honour mininum size
  
}
  
bool BasicDialog::Validate()
{
    return TRUE;
}
  
void BasicDialog::OnOk(wxCommandEvent &event)
{
  event.Skip();
}

BEGIN_EVENT_TABLE(BasicDialog,wxDialog)
    EVT_BUTTON( wxID_OK, BasicDialog::OnOk )
END_EVENT_TABLE()

