#include "basic.h"

IMPLEMENT_APP(BasicApplication)

bool BasicApplication::OnInit()
{ BasicFrame
   * frame
     = new BasicFrame( wxString(TITLE) +
                       wxString(ABOUT),
                       50, 50, 450, 300
                     );
  frame->Show(TRUE);
  SetTopWindow(frame);
  return TRUE;	
}

enum
{ BASIC_EXIT    =   wxID_HIGHEST + 1,
  BASIC_OPEN,
  BASIC_SAVE,
  BASIC_SAVE_AS,
  BASIC_FONT,
  BASIC_DIR,
  BASIC_ABOUT,
  BASIC_HELP
};

BEGIN_EVENT_TABLE (BasicFrame, wxFrame)
  EVT_MENU ( BASIC_EXIT, BasicFrame::OnExit)
  EVT_MENU ( BASIC_OPEN, BasicFrame::OnOpenFile)
  EVT_MENU ( BASIC_SAVE, BasicFrame::OnSave)
  EVT_MENU ( BASIC_SAVE_AS,	BasicFrame::OnSaveAs)
  EVT_MENU ( BASIC_FONT, BasicFrame::OnChooseFont)
  EVT_MENU ( BASIC_DIR, BasicFrame::OnChooseDir)
  EVT_MENU ( BASIC_ABOUT, BasicFrame::OnAbout)
  EVT_MENU ( BASIC_HELP, BasicFrame::OnHelp)
END_EVENT_TABLE()

BasicFrame::BasicFrame
             (const wxChar *title,
              int xpos, int ypos,
              int width, int height)
             : wxFrame( (wxFrame *) NULL, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  fileMenu = (wxMenu *)	NULL;
  editMenu = (wxMenu *) NULL;
  helpMenu = (wxMenu *)	NULL;
  currentFilename = "";
  CreateStatusBar(3);
  
  theText = new wxTextCtrl
  		( this,
  		  -1,
  		  wxEmptyString,
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  fileMenu = new wxMenu;
  fileMenu->Append(BASIC_OPEN,"&Open file...");
  fileMenu->Append(BASIC_SAVE,"&Save file");
  fileMenu->Append(BASIC_SAVE_AS,"S&ave file as...");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_DIR,"&Change directory...");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_EXIT,"E&xit");

  editMenu = new wxMenu;
  editMenu->Append(BASIC_FONT, "Choose font");
  
  helpMenu = new wxMenu;
  helpMenu->Append(BASIC_HELP,		"Help");
  helpMenu->Append(BASIC_ABOUT,		"About");
  
  menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, "&File");
  menuBar->Append(editMenu, "&Edit");
  menuBar->Append(helpMenu, "&Help");
  SetMenuBar(menuBar);
  currentPath = wxGetCwd();
  wxSetWorkingDirectory(currentPath);
}

BasicFrame::~BasicFrame()
{

}

void BasicFrame::OnChooseDir(wxCommandEvent & event)
{  	wxDirDialog
   	*d = new   wxDirDialog
   				(this,
               	 "Choose a directory",
               	 GetCurrentPath(),
               	 0,
               	 wxDefaultPosition
               	);
	if (d->ShowModal() ==  wxID_OK)
	 {SetCurrentPath(d->GetPath()); 	
     }
}

void BasicFrame::OnOpenFile(wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,
                          "Open file",
                          GetCurrentPath(),
                          "",
                          FILETYPES,
                          wxOPEN,
                          wxDefaultPosition);

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      theText->LoadFile(openFileDialog->GetFilename());
      SetStatusText(GetCurrentFilename(), 0);
      SetStatusText(openFileDialog->GetDirectory(),1);
    }
}

void BasicFrame::OnSaveAs (wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,
                          "Save file as",
                          GetCurrentPath(),
                          "",
                          FILETYPES,
                          wxSAVE,
                          wxDefaultPosition);

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      if ( SaveCurrentFile() )
       { SetStatusText(GetCurrentFilename(), 0);
         SetStatusText(openFileDialog->GetDirectory(),1);
       }
    }
}

void BasicFrame::OnHelp(wxCommandEvent & event)
{

}

void BasicFrame::OnExit     (wxCommandEvent & event)
{ wxString msg = "Warning: the text has changed"
                 "\nSelect OK to ignore changes for\n";

  msg.Append(GetCurrentFilename());
  if ( theText->IsModified() )
   { wxMessageDialog
      warnDialog ( this,
                   msg,    
                   "File changed",
                   wxICON_HAND | wxOK | wxCANCEL);
     if (warnDialog.ShowModal() == wxID_OK)
      Close(TRUE);
   }
  else Close(TRUE); 
}

void BasicFrame::OnSave     (wxCommandEvent & event)
{
  SaveCurrentFile();
}

wxString BasicFrame::GetCurrentFilename()
{
 return currentFilename;
}

void BasicFrame::SetCurrentFilename(wxString n)
{
 currentFilename = n;
}

wxString BasicFrame::GetCurrentPath()
{
 return currentPath;
}

void BasicFrame::SetCurrentPath(wxString n)
{
 currentPath = n;
}

bool BasicFrame::SaveCurrentFile()
{ wxString s = GetCurrentFilename();
	
  if (s.Length() > 0)
   if ( theText->SaveFile(s) )
    return true;
   else
    { wxMessageDialog
       warnDialog ( this,
                    "Unable to save file.",    
                    "File changed",
                    wxOK | wxCANCEL
                  );
      return false;
    }
   else
    return false;
}

void BasicFrame::OnChooseFont(wxCommandEvent & event)
{ wxFontData fontData;
  wxFont     theFont;
  wxColour	 colour;
  
  theFont = theText->GetFont();
  fontData.SetInitialFont(theFont);
  colour = theText->GetForegroundColour();
  fontData.SetColour(colour);
  fontData.SetShowHelp(true);
  wxFontDialog *dialog = new wxFontDialog(this, &fontData);
  if (dialog->ShowModal() == wxID_OK)
   { fontData = dialog->GetFontData();
     theFont = 	fontData.GetChosenFont();
     theText->SetFont(theFont);
     theText->SetForegroundColour(fontData.GetColour());
   }
}

void BasicFrame::OnAbout(wxCommandEvent & event)
{  
  BasicDialog
   aboutDialog ( this,
                 -1,
                 "Your very own dialog",
                 wxPoint(100,100),
                 wxSize(200,200)
               );
  if (aboutDialog.ShowModal() != wxID_OK)
   theText->AppendText("The about box was cancelled.\n");
  else
   theText->AppendText(aboutDialog.GetText());
}

BasicDialog::BasicDialog
 ( wxWindow *parent, wxWindowID id,
   const wxString &title,
   const wxPoint &position, const wxSize& size,
   long style
 ) :
 wxDialog( parent, id, title, position, size, style)
{
  wxString dimensions = "", s;
  wxPoint p;
  wxSize  sz;
  
  sz.SetWidth(size.GetWidth() - 20);    //set size of text control
  sz.SetHeight(size.GetHeight() - 70);
  
  p.x = 6; p.y = 2; 					//set x y position for text control
  s.Printf(" x = %d y = %d\n", p.x, p.y);
  dimensions.append(s);
  s.Printf( " width = %d height = %d\n",
            sz.GetWidth(), sz.GetHeight());
  dimensions.append(s);
  dimensions.append(AUTHOR);

  dialogText = new wxTextCtrl
  		( this,
  		  -1,
  		  dimensions,
  		  p,
  		  sz,
  		  wxTE_MULTILINE
  		);

  p.y += sz.GetHeight() + 10; //set y position for the OK button
  wxButton * b = new wxButton( this, wxID_OK,     "OK",     p, wxDefaultSize);
  p.x += 110;	
  wxButton * c = new wxButton( this, wxID_CANCEL, "Cancel", p, wxDefaultSize);
}

BEGIN_EVENT_TABLE(BasicDialog, wxDialog)
    EVT_BUTTON( wxID_OK, BasicDialog::OnOk )
END_EVENT_TABLE()

void BasicDialog::OnOk(wxCommandEvent &event)
{
    event.Skip();
}

wxString BasicDialog::GetText()
{
	return dialogText->GetValue();
}



