#ifndef BASIC_H
#define BASIC_H

#include <wx/wx.h>
#include <fstream>
#include <string>
#include <wx/filedlg.h>
#include <wx/fontdlg.h>
#include <wx/printdlg.h>

static const wxChar *TITLE     = _T("wxWindows Basic steps - step 6: ");
static const wxChar *AUTHOR    = _T("\nDB 2001");
static const wxChar *ABOUT     = _T("Using the font dialog");
static const wxChar *FILETYPES = _T( "Text files|*.txt|"
                                     "C/C++ source files|*.cpp;*.cc;*.c|"
                                     "C/C++ header files|*.hpp;*.h|"
                                     "Make files|Mak*;mak*|"
                                     "Java files|*java|"
                                     "Hypertext markup files|*html;*htm;*HTML;*HTM|"
                                     "All files|*.*"
                                   );

class BasicApplication : public wxApp
{
  public:
	virtual bool OnInit();
};

class BasicFrame : public wxFrame
{
  public:
	BasicFrame( const wxChar *title, int xpos, int ypos, int width, int height);
	~BasicFrame();

    wxTextCtrl *theText;
	wxMenuBar  *menuBar;
	wxMenu     *fileMenu, *editMenu, *helpMenu;

	void OnOpenFile		(wxCommandEvent & event);
    void OnSave			(wxCommandEvent & event);
    void OnSaveAs		(wxCommandEvent & event);
	void OnExit     	(wxCommandEvent & event);
	void OnAbout    	(wxCommandEvent & event);
	void OnHelp	    	(wxCommandEvent & event);
	void OnChooseFont	(wxCommandEvent & event);
	void OnChooseDir	(wxCommandEvent & event);
    wxString GetCurrentFilename();
	void SetCurrentFilename(wxString);
	bool SaveCurrentFile();
	void SetCurrentPath(wxString);
    wxString GetCurrentPath();
	
  private:
	wxString currentFilename;
	wxString currentPath;

  DECLARE_EVENT_TABLE()
};

enum
{ BASIC_EXIT    =   wxID_HIGHEST + 1,
  BASIC_OPEN,
  BASIC_SAVE,
  BASIC_SAVE_AS,
  BASIC_FONT,
  BASIC_DIR,
  BASIC_ABOUT,
  BASIC_HELP
};

#endif

