#include "basic.h"

IMPLEMENT_APP(BasicApplication)

bool BasicApplication::OnInit()
{
  BasicFrame * frame = new BasicFrame(wxString(TITLE) + wxString(ABOUT), 50, 50, 450, 300);
  frame->Show(TRUE);
  SetTopWindow(frame);
  return TRUE;	
}

BEGIN_EVENT_TABLE (BasicFrame, wxFrame)
  EVT_MENU ( BASIC_EXIT,  	BasicFrame::OnExit)
  EVT_MENU ( BASIC_OPEN,    BasicFrame::OnOpenFile)
  EVT_MENU ( BASIC_SAVE,	BasicFrame::OnSave)
  EVT_MENU ( BASIC_SAVE_AS,	BasicFrame::OnSaveAs)
  EVT_MENU ( BASIC_FONT, 	BasicFrame::OnChooseFont)
  EVT_MENU ( BASIC_ABOUT, 	BasicFrame::OnAbout)
  EVT_MENU ( BASIC_HELP, 	BasicFrame::OnHelp)
END_EVENT_TABLE()

BasicFrame::BasicFrame
             (const wxChar *title, int xpos, int ypos, int width, int height)
             : wxFrame( (wxFrame *) NULL, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  fileMenu = (wxMenu *)	NULL;
  editMenu = (wxMenu *) NULL;
  helpMenu = (wxMenu *)	NULL;
  currentFilename = "";
  CreateStatusBar(3);
  
  theText = new wxTextCtrl
  		( this,
  		  -1,
  		  wxEmptyString,
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  fileMenu = new wxMenu;
  fileMenu->Append(BASIC_OPEN,"&Open file...");
  fileMenu->Append(BASIC_SAVE,"&Save file");
  fileMenu->Append(BASIC_SAVE_AS,"S&ave file as...");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_EXIT,"E&xit");

  editMenu = new wxMenu;
  editMenu->Append(BASIC_FONT, "Choose font");
  
  helpMenu = new wxMenu;
  helpMenu->Append(BASIC_HELP,		"Help");
  helpMenu->Append(BASIC_ABOUT,		"About");
  
  menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, "&File");
  menuBar->Append(editMenu, "&Edit");
  menuBar->Append(helpMenu, "&Help");
  SetMenuBar(menuBar);
}

BasicFrame::~BasicFrame()
{

}

void BasicFrame::OnOpenFile(wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,
                          "Open file",
                          "",
                          "",
                          FILETYPES,
                          wxOPEN,
                          wxDefaultPosition);

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      theText->LoadFile(openFileDialog->GetFilename());
      SetStatusText(GetCurrentFilename(), 0);
      SetStatusText(openFileDialog->GetDirectory(),1);
    }
}

void BasicFrame::OnSaveAs (wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,              	//parent window
                          "Save file as",   	//title of dialog
                          "",                	//default dir
                          "",                	//default file
                          FILETYPES,		//wildcard
                          wxSAVE,              	//style  
                          wxDefaultPosition);	//position (NYI*)

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      if ( SaveCurrentFile() )
       { SetStatusText(GetCurrentFilename(), 0);
         SetStatusText(openFileDialog->GetDirectory(),1);
       }
    }
}

void BasicFrame::OnAbout(wxCommandEvent & event)
{ wxString t = TITLE;

  t.append( AUTHOR );
  
  wxMessageDialog
   aboutDialog ( this, t, ABOUT, wxOK);
  aboutDialog.ShowModal();
}

void BasicFrame::OnHelp(wxCommandEvent & event)
{

}

void BasicFrame::OnExit     (wxCommandEvent & event)
{ wxString msg = "Warning: the text has changed"
                 "\nSelect OK to ignore changes for\n";

  msg.Append(GetCurrentFilename());
  if ( theText->IsModified() )
   { wxMessageDialog
      warnDialog ( this,
                   msg,    
                   "File changed",
                   wxICON_HAND | wxOK | wxCANCEL);
     if (warnDialog.ShowModal() == wxID_OK)
      Close(TRUE);
   }
  else Close(TRUE); 
}

void BasicFrame::OnSave     (wxCommandEvent & event)
{
  SaveCurrentFile();
}

wxString BasicFrame::GetCurrentFilename()
{
 return currentFilename;
}

void BasicFrame::SetCurrentFilename(wxString n)
{
 currentFilename = n;
}

bool BasicFrame::SaveCurrentFile()
{ wxString s = GetCurrentFilename();
	
  if (s.Length() > 0)
   if ( theText->SaveFile(s) )
    return true;
   else
    { wxMessageDialog
       warnDialog ( this,
                    "Unable to save file.",    
                    "File changed",
                    wxOK | wxCANCEL
                  );
      return false;
    }
   else
    return false;
}

void BasicFrame::OnChooseFont(wxCommandEvent & event)
{ wxFontData fontData;
  wxFont     theFont;
  wxColour	 colour;
  
  theFont = theText->GetFont();
  fontData.SetInitialFont(theFont);
  colour = theText->GetForegroundColour();
  fontData.SetColour(colour);
  fontData.SetShowHelp(true);
  wxFontDialog *dialog = new wxFontDialog(this, &fontData);
  if (dialog->ShowModal() == wxID_OK)
   { fontData = dialog->GetFontData();
     theFont = 	fontData.GetChosenFont();
     theText->SetFont(theFont);
     theText->SetForegroundColour(fontData.GetColour());
   }
}

