#ifndef BASIC_H
#define BASIC_H

#include <wx/wx.h>
#include <fstream>
#include <string>
#include <wx/filedlg.h>
#include <wx/fontdlg.h>
#include <wx/colour.h>
#include <wx/sizer.h>

static const wxChar *TITLE  = _T("wxWindows Basic steps - step 6: ");
static const wxChar *AUTHOR = _T("\nDB 2001");
static const wxChar *ABOUT = _T("Layout - Using a dialog box with sizers");
static const wxChar *FILETYPES = _T( "Text files|*.txt|"
                                     "C/C++ source files|*.cpp;*.cc;*.c|"
                                     "C/C++ header files|*.hpp;*.h|"
                                     "Make files|Mak*;mak*|"
                                     "Java files|*java|"
                                     "Hypertext markup files|*html;*htm;*HTML;*HTM|"
                                     "All files|*.*"
                                   );

class BasicApplication : public wxApp
{
  public:
	virtual bool OnInit();
        wxString appTitle;
};

class BasicFrame : public wxFrame
{
  public:
	BasicFrame( const wxChar *title, int xpos, int ypos, int width, int height);
	~BasicFrame();

    wxTextCtrl *theText;
	wxMenuBar  *menuBar;
	wxMenu     *fileMenu, *editMenu, *helpMenu;

	void OnOpenFileNative 	(wxCommandEvent & event);
    void OnSave		        (wxCommandEvent & event);
    void OnSaveAs		    (wxCommandEvent & event);
	void OnExit     	    (wxCommandEvent & event);
	void OnAbout    	    (wxCommandEvent & event);
	void OnAboutNew    	    (wxCommandEvent & event);
	void OnHelp	    	    (wxCommandEvent & event);
	void OnChooseFont	    (wxCommandEvent & event);
    wxString GetCurrentFilename();
	void SetCurrentFilename(wxString);
	bool SaveCurrentFile();
	
  private:
	wxString currentFilename;
 	wxColour colour;
	wxFont   font;
	size_t   fontSize;

  DECLARE_EVENT_TABLE()
};

enum
{ BASIC_EXIT    	=   1,
  BASIC_OPEN_NATIVE	= 100,
  BASIC_SAVE,
  BASIC_SAVE_AS,
  BASIC_FONT		= 150,
  BASIC_ABOUT		= 200,
  BASIC_ABOUTNEW,
  BASIC_HELP
};

BEGIN_EVENT_TABLE (BasicFrame, wxFrame)
  EVT_MENU ( BASIC_EXIT,  	BasicFrame::OnExit)
  EVT_MENU ( BASIC_OPEN_NATIVE, BasicFrame::OnOpenFileNative)
  EVT_MENU ( BASIC_SAVE,	BasicFrame::OnSave)
  EVT_MENU ( BASIC_SAVE_AS,	BasicFrame::OnSaveAs)
  EVT_MENU ( BASIC_FONT, 	BasicFrame::OnChooseFont)
  EVT_MENU ( BASIC_ABOUT, 	BasicFrame::OnAbout)
  EVT_MENU ( BASIC_ABOUTNEW, 	BasicFrame::OnAboutNew)
  EVT_MENU ( BASIC_HELP, 	BasicFrame::OnHelp)
END_EVENT_TABLE()

class BasicDialog: public wxDialog
{
public:
    BasicDialog( wxWindow *parent,
                 wxWindowID id,
                 const wxString &title,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 long style = wxDEFAULT_DIALOG_STYLE );
    
    virtual bool Validate();
    wxTextCtrl * dialogText;
    
private:
    void OnOk( wxCommandEvent &event );

private:
    DECLARE_EVENT_TABLE()
};


#endif

