#include "basic.h"

IMPLEMENT_APP(BasicApplication)

bool BasicApplication::OnInit()
{
  appTitle = TITLE;
  appTitle.Append(ABOUT);
  BasicFrame * frame = new BasicFrame(appTitle, 50, 50, 450, 300);
  frame->Show(TRUE);
  SetTopWindow(frame);
  return TRUE;	
}

BasicFrame::BasicFrame
             (const wxChar *title, int xpos, int ypos, int width, int height)
             : wxFrame( (wxFrame *) NULL, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  fileMenu = (wxMenu *)	NULL;
  editMenu = (wxMenu *) NULL;
  helpMenu = (wxMenu *)	NULL;
  currentFilename = "";
  CreateStatusBar(3);
  
  theText = new wxTextCtrl
  		( this,
  		  -1,
  		  wxEmptyString,
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  fileMenu = new wxMenu;
  fileMenu->Append(BASIC_OPEN_NATIVE,  	"&Open file...");
  fileMenu->Append(BASIC_SAVE,  	    "&Save file");
  fileMenu->Append(BASIC_SAVE_AS,  	    "S&ave file as...");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_EXIT,  	    "E&xit");

  editMenu = new wxMenu;
  editMenu->Append(BASIC_FONT, "Choose font");
  
  helpMenu = new wxMenu;
  helpMenu->Append(BASIC_HELP,		"Help");
  helpMenu->Append(BASIC_ABOUT,		"About");
  helpMenu->Append(BASIC_ABOUTNEW,	"About new");
  
  menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, "&File");
  menuBar->Append(editMenu, "&Edit");
  menuBar->Append(helpMenu, "&Help");
  SetMenuBar(menuBar);
  
}

BasicFrame::~BasicFrame()
{

}

void BasicFrame::OnOpenFileNative (wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,                 //parent window
                          "Open file",   	    //title of dialog
                          "",                   //default dir
                          "",                   //default file
                          FILETYPES,		    //wildcard
                          wxOPEN,               //style  
                          wxDefaultPosition);   //position (NYI*)

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      theText->LoadFile(openFileDialog->GetFilename());
      this->SetStatusText(GetCurrentFilename(), 0);
      this->SetStatusText(openFileDialog->GetDirectory(),1);
    }
}

void BasicFrame::OnSaveAs (wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,              	//parent window
                          "Save file as",   	//title of dialog
                          "",                	//default dir
                          "",                	//default file
                          FILETYPES,		    //wildcard
                          wxSAVE,              	//style  
                          wxDefaultPosition);	//position (NYI*)

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      if ( SaveCurrentFile() )
       { this->SetStatusText(GetCurrentFilename(), 0);
         this->SetStatusText(openFileDialog->GetDirectory(),1);
       }
    }
}

void BasicFrame::OnAbout    (wxCommandEvent & event)
{ wxString t = TITLE;

  t.append( AUTHOR );
  
  wxMessageDialog
   aboutDialog ( this, t, ABOUT, wxOK);
  aboutDialog.ShowModal();
}

void BasicFrame::OnHelp    (wxCommandEvent & event)
{

}

void BasicFrame::OnExit     (wxCommandEvent & event)
{ wxString msg = "Warning: the text has changed"
                 "\nSelect OK to ignore changes for\n";

  msg.Append(GetCurrentFilename());
  if ( theText->IsModified() )
   { wxMessageDialog
      warnDialog ( this,
                   msg,    
                   "File changed",
                   wxICON_HAND | wxOK | wxCANCEL);
     if (warnDialog.ShowModal() == wxID_OK)
      Close(TRUE);
   }
  else Close(TRUE); 
}

void BasicFrame::OnSave     (wxCommandEvent & event)
{
  SaveCurrentFile();
}

wxString BasicFrame::GetCurrentFilename()
{
 return currentFilename;
}

void BasicFrame::SetCurrentFilename(wxString n)
{
 currentFilename = n;
}

bool BasicFrame::SaveCurrentFile()
{ wxString s = GetCurrentFilename();
	
  if (s.Length() > 0)
   if ( theText->SaveFile(s) )
    return true;
   else
    { wxMessageDialog
       warnDialog ( this,
                    "Unable to save file.",    
                    "File changed",
                    wxOK | wxCANCEL
                  );
      return false;
    }
   else
    return false;
}

void BasicFrame::OnChooseFont(wxCommandEvent & event)
{ wxFontData fontData;
  wxFont     theFont = theText->GetFont();

  colour = theText->GetForegroundColour();
  fontData.SetColour(colour);
  fontData.SetInitialFont(theFont);
  fontData.SetShowHelp(true);
  wxFontDialog *dialog = new wxFontDialog(this, &fontData);
  if (dialog->ShowModal() == wxID_OK)
   { fontData = dialog->GetFontData();
     theFont = 	fontData.GetChosenFont();
     theText->SetFont(theFont);
     theText->SetForegroundColour(fontData.GetColour());
   }
  dialog->Destroy();
   
}

void BasicFrame::OnAboutNew  (wxCommandEvent & event)
{  
  BasicDialog
   aboutDialog ( this, -1,
                 this->GetTitle(),
                 wxPoint(100,100),
                 wxSize(250, 300),
                 wxRESIZE_BORDER |  wxDEFAULT_DIALOG_STYLE 
               );
  aboutDialog.ShowModal();
}

BEGIN_EVENT_TABLE(BasicDialog,wxDialog)
    EVT_BUTTON( wxID_OK, BasicDialog::OnOk )
END_EVENT_TABLE()
  
BasicDialog::BasicDialog( wxWindow *parent,
                          wxWindowID id,
                          const wxString &title,
                          const wxPoint &position,
                          const wxSize& size,
                          long style
                        ) : wxDialog( parent, id, title, position, size, style )
{
  wxString theTextData = "";
  wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );

  theTextData.append("Thou art, indeed, just O Lord if I contend with Thee.\n"
                     "But sir: what I plead is just.\n"
                     "Why do sinner's ways prosper?\n"
                     "And why does disappointment all I endeavour end?\n"
                     "Wert Thou my enemy, O Thou my friend,\n"
                     "How wouldst Thou defeat and thwart me.\n\n"
                    ); 

  // create text ctrl with minimal size 150 x 100
  dialogText = new wxTextCtrl( this, -1,
                               theTextData,
                               wxDefaultPosition,
                               wxSize(150, 100),
                               wxTE_MULTILINE
                             );
    
  dialogText->SetBackgroundColour(wxColour(0,0,0));
  dialogText->SetForegroundColour(wxColour(255,255,255));

  topsizer->Add( dialogText, 
                 1,                // make vertically stretchable
                 wxEXPAND | wxALL, // horizontally stretchable and make border all around
                 10                // set border width to 10
               );

  wxBoxSizer *button_sizer = new wxBoxSizer( wxHORIZONTAL );

  button_sizer->Add
   ( new wxButton( this, wxID_OK, "OK" ),
     0,                                    // make horizontally unstretchable
     wxALL,                                // make border all around (implicit top alignment)
     10 );                                 // set border width to 10

  button_sizer->Add(
     new wxButton( this, wxID_CANCEL, "Cancel" ),
     0,           // make horizontally unstretchable
     wxALL,       // make border all around (implicit top alignment)
     10 );        // set border width to 10

  topsizer->Add(
     button_sizer,
     0,                // make vertically unstretchable
     wxALIGN_CENTER ); // no border and centre horizontally

  SetAutoLayout( TRUE );     // tell dialog to use sizer
  SetSizer( topsizer );      // actually set the sizer

  topsizer->Fit( this );            // set size to minimum size as calculated by the sizer
  topsizer->SetSizeHints( this );   // set size hints to honour mininum size
  
}
  
bool BasicDialog::Validate()
{
    return TRUE;
}
  
void BasicDialog::OnOk(wxCommandEvent &event)
{
  event.Skip();
}


