#include "basic.h"

IMPLEMENT_APP(BasicApplication)

bool BasicApplication::OnInit()
{
  BasicFrame
   *frame = new BasicFrame(TITLE, 50, 50, 450, 300);

  frame->Show(TRUE);
  SetTopWindow(frame);
  return TRUE;	
}

BasicFrame::BasicFrame
             (const wxChar *title, int xpos, int ypos,
              int width, int height)
             : wxFrame( (wxFrame *) NULL, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  fileMenu = (wxMenu *)	NULL;
  
  theText = new wxTextCtrl
  		( this,
  		  -1,
  		  wxString("This is a text control\n\n"
  		           "The text control supports basic"
  		           " text editing operations\n" 
  		           "along with copy, cut, paste,"
  		           " delete, select all and undo.\n\n" 
  		           "Right click on the control to"
  		           " see the pop-up menu.\n" 
  		          ),
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  fileMenu = new wxMenu;
  fileMenu->Append(BASIC_OPEN,  "&Open file");
  fileMenu->Append(BASIC_ABOUT, "&About");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_EXIT,  "E&xit");

  menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, "&File");
  SetMenuBar(menuBar);
  CreateStatusBar(3);  
}

BasicFrame::~BasicFrame()
{

}

BEGIN_EVENT_TABLE (BasicFrame, wxFrame)
  EVT_MENU ( BASIC_EXIT,  BasicFrame::OnExit)
  EVT_MENU ( BASIC_ABOUT, BasicFrame::OnAbout)
  EVT_MENU ( BASIC_OPEN,  BasicFrame::OnOpenFile)
  EVT_SIZE (              BasicFrame::OnSize)
END_EVENT_TABLE()

void BasicFrame::OnOpenFile (wxCommandEvent & event)
{
  theText->LoadFile("data.txt");
}


void BasicFrame::OnSize(wxSizeEvent & event)
{ int width, height;
  wxString s;
  
  GetSize(&width, &height);
  s.Printf(" %d %d", width, height);
  s = TITLE + s;
  SetTitle(s);
  event.Skip();
}

void BasicFrame::OnAbout    (wxCommandEvent & event)
{ wxString t = TITLE;

  t.append( _T("\nDB 2001"));
  
  wxMessageDialog
   aboutDialog ( this, t, "About Basic", wxOK | wxCANCEL);
  aboutDialog.ShowModal();
}

void BasicFrame::OnExit     (wxCommandEvent & event)
{
  Close(TRUE);
}