#include "basic.h"
#include "basicframe.h"
#include "mainframe.h"

extern MainFrame * parentFrame;

BasicFrame::BasicFrame
             (	wxWindow * parent,
             	const wxChar *title, int xpos, int ypos, int width, int height)
             : wxFrame( parent, -1, title,
                        wxPoint(xpos, ypos),
                        wxSize(width, height))
{
  theText  = (wxTextCtrl *) NULL;
  menuBar  = (wxMenuBar *) NULL;
  fileMenu = (wxMenu *)	NULL;
  editMenu = (wxMenu *) NULL;
  helpMenu = (wxMenu *)	NULL;
  p = parent;
  
  currentFilename = "";
  CreateStatusBar(3);
  
  theText = new wxTextCtrl
  		( this,
  		  -1,
  		  wxEmptyString,
  		  wxDefaultPosition,
  		  wxDefaultSize,
  		  wxTE_MULTILINE
  		);

  fileMenu = new wxMenu;
  fileMenu->Append(BASIC_OPEN_NATIVE,  	"&Open file...");
  fileMenu->Append(BASIC_SAVE,  		"&Save file");
  fileMenu->Append(BASIC_SAVE_AS,  		"S&ave file as...");
  fileMenu->AppendSeparator();
  fileMenu->Append(BASIC_EXIT,  		"E&xit");

  editMenu = new wxMenu;
  editMenu->Append(BASIC_FONT, "Choose font");
  
  helpMenu = new wxMenu;
  helpMenu->Append(BASIC_HELP,		"Help");
  
  menuBar = new wxMenuBar;
  menuBar->Append(fileMenu, "&File");
  menuBar->Append(editMenu, "&Edit");
  menuBar->Append(helpMenu, "&Help");
  SetMenuBar(menuBar);
  ((MainFrame*)p)->theText->AppendText("\nWelcome\n\n");
  wxString x;
  x.Printf(_T("Parent Id is %d, this Id is %d"), p->GetId(), this->GetId());
  theText->AppendText(x);
  ((MainFrame*)GetParent())->ChildMessage(x);
}

BasicFrame::~BasicFrame()
{

}

void BasicFrame::OnOpenFileNative (wxCommandEvent & event)
{  wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,             //parent window
                          "Open file",   	//title of dialog
                          "",               //default dir
                          "",               //default file
                          FILETYPES,		//wildcard
                          wxOPEN,           //style  
                          wxDefaultPosition);	//position (NYI*)

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      theText->LoadFile(openFileDialog->GetFilename());
      this->SetStatusText(GetCurrentFilename(), 0);
      this->SetStatusText(openFileDialog->GetDirectory(),1);
      parentFrame->ChildMessage("\n"+ GetCurrentFilename() + "\n");
      ((MainFrame*)GetParent())->theText->AppendText("hello\n");
    }
}

void BasicFrame::OnSaveAs (wxCommandEvent & event)
{ wxFileDialog
   * openFileDialog =
       new wxFileDialog ( this,             //parent window
                          "Save file as",   //title of dialog
                          "",               //default dir
                          "",               //default file
                          FILETYPES,		//wildcard
                          wxSAVE,           //style  
                          wxDefaultPosition);	//position (NYI*)

   if (openFileDialog->ShowModal() == wxID_OK)
    { SetCurrentFilename(openFileDialog->GetFilename());	
      if ( SaveCurrentFile() )
       { this->SetStatusText(GetCurrentFilename(), 0);
         this->SetStatusText(openFileDialog->GetDirectory(),1);
       }
    }
}

void BasicFrame::OnHelp (wxCommandEvent & event)
{

}

void BasicFrame::OnExit   (wxCommandEvent & event)
{
	Close();
}


void BasicFrame::OnCloseWindow	(wxCloseEvent& event)
{ wxString msg = "Close Warning: the text has changed"
                 "\nSelect OK to ignore changes for\n";

  msg.Append(GetCurrentFilename());
  if ( theText->IsModified() )
   { wxMessageDialog
      warnDialog ( this,
                   msg,    
                   "File changed",
                   wxICON_HAND | wxOK | wxCANCEL);
     if (warnDialog.ShowModal() == wxID_OK)
      this->Destroy();
   }
  else
   { this->Destroy(); }
}

void BasicFrame::OnSave     (wxCommandEvent & event)
{
  SaveCurrentFile();
}

wxString BasicFrame::GetCurrentFilename()
{
 return currentFilename;
}

void BasicFrame::SetCurrentFilename(wxString n)
{
 currentFilename = n;
}

bool BasicFrame::SaveCurrentFile()
{ wxString s = GetCurrentFilename();
	
  if (s.Length() > 0)
   if ( theText->SaveFile(s) )
    return true;
   else
    { wxMessageDialog
       warnDialog ( this,
                    "Unable to save file.",    
                    "File changed",
                    wxOK | wxCANCEL
                  );
      return false;
    }
   else
    return false;
}

void BasicFrame::OnChooseFont(wxCommandEvent & event)
{ wxFontData fontData;
  wxFont     theFont = theText->GetFont();

  colour = theText->GetForegroundColour();
  fontData.SetColour(colour);
  fontData.SetInitialFont(theFont);
  fontData.SetShowHelp(true);
  wxFontDialog *dialog = new wxFontDialog(this, &fontData);
  if (dialog->ShowModal() == wxID_OK)
   { fontData = dialog->GetFontData();
     theFont = 	fontData.GetChosenFont();
     theText->SetFont(theFont);
     theText->SetForegroundColour(fontData.GetColour());
   }
  dialog->Destroy();
   
}


BEGIN_EVENT_TABLE (BasicFrame, wxFrame)
  EVT_MENU ( BASIC_EXIT,  		BasicFrame::OnExit)
  EVT_MENU ( BASIC_OPEN_NATIVE, BasicFrame::OnOpenFileNative)
  EVT_MENU ( BASIC_SAVE,		BasicFrame::OnSave)
  EVT_MENU ( BASIC_SAVE_AS,		BasicFrame::OnSaveAs)
  EVT_MENU ( BASIC_FONT, 		BasicFrame::OnChooseFont)
  EVT_MENU ( BASIC_HELP, 		BasicFrame::OnHelp)
  EVT_CLOSE(                    BasicFrame::OnCloseWindow)
END_EVENT_TABLE()
