/***************************************************************************
                          tripletplot.cpp  -  description
                             -------------------
    begin                : Tue Oct 24 2000
    copyright            : (C) 2000 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>

#include <qpointarray.h>
#include <qpainter.h>

#include "tripletplot.h"

TripletPlot::TripletPlot(SetiLoc* loc, QWidget *parent, const char *name ) : SetiGraph(loc, true, false, parent,name)
{
// Make the array large enough.
tripletData.resize(512);

// connect the SetiLoc signal to the new triplet slot of this widget.
location = loc;
connect(location, SIGNAL(newTriplet(TripletScore)), this, SLOT(showNewTripletData(TripletScore)));

QString title;
title = i18n("Top Triplet for %1 (right-click for options)").arg(loc->description());
setCaption(title);
setBackgroundColor(black);
resize(350, 200);
setMinimumSize(150, 100);

//setPlotMode(SetiGraph::Lines);
setYScale(1.2);

// prepare data for display
showNewTripletData(location->tripletScore());

}

TripletPlot::~TripletPlot()
{
}

/////////////////////////////////////////////////////////////////////////////
void TripletPlot::paintEvent(QPaintEvent* e)
{
QPainter p;

SetiGraph::paintEvent(e);
p.begin(this);
p.translate(0, rect().bottom());

QBrush bru;
bru.setStyle(SolidPattern);
bru.setColor(green);
QPen pen;
pen.setColor(green);
p.setPen(pen);
p.setBrush(bru);

drawPulseMarker(triplet.tpotind0_0, &p);
drawPulseMarker(triplet.tpotind1_0, &p);
drawPulseMarker(triplet.tpotind2_0, &p);

p.end();
}

/////////////////////////////////////////////////////////////////////////////
void TripletPlot::showNewTripletData(TripletScore score)
{
  triplet = score;
	// convert ints to doubles
	for(int i=0;i<512;i++) tripletData[i] = (double)triplet.data[i];	
	setCurve(tripletData);
	
  // generate the info text
  QString it;
  it.sprintf("power : %f\n"
             "mean   : %f\n"
             "period: %f\n",
             triplet.power,
             triplet.mean,
             triplet.period);
  setInfoText(it);

	repaint();
}

/////////////////////////////////////////////////////////////////////////////
void TripletPlot::drawPulseMarker(int index, QPainter* p)
{
int x = (int)((2*index+1.5)*width())/arraySize();
int y = -(int)((1.02*height())/yScale());
int w = width()/(2*arraySize())+1;
int l = (int)((0.08*height())/yScale());

QPointArray a;
a.setPoints(3, x,y, x-w,y-l, x+w,y-l);
p->drawPolygon(a);
}

#include "tripletplot.moc"
