/***************************************************************************
                          csvdatabase.cpp  -  description
                             -------------------
    begin                : Thu Dec 16 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtextstream.h>
#include "csvdatabase.h"

CSVDataBase::CSVDataBase(const char *file)
{
definitionLine = "";
defentries.setAutoDelete(true);
currententries.setAutoDelete(true);
currentLineNr = -2;
currentLineColumns = 0;
setName(file);
}

CSVDataBase::~CSVDataBase()
{
}

int CSVDataBase::readItems(const char* linestr, QStrList* strlist)
{
QString item("");
char buffer[256], tmp[256];

strlist->clear();

int idx1(0), idx2(0);
while(linestr[idx2] != 0)
	{
	while(linestr[idx2] != ',' && linestr[idx2] != 0) idx2++;
	if(idx2-idx1 < 256)
		{
  	strncpy(buffer, &linestr[idx1], idx2-idx1);
	  buffer[idx2-idx1] = 0;
		if(buffer[0] == '\"' && buffer[strlen(buffer)-1] == '\"')
			{ // string is embedded in "..." -> strip them
			strncpy(tmp, &buffer[1], strlen(buffer)-2);
			tmp[strlen(buffer)-2] = 0;
			strcpy(buffer, tmp);
			}
	  strlist->append((const char*)buffer);
	  }
	else
		{
		strlist->append("invalid size");
		}
	if(linestr[idx2] == 0) break; // end of line reached
	idx1 = idx2+1;				// skip past comma
	idx2 = idx1;
	}

return( strlist->count() );
}

QString CSVDataBase::readItem(int column, int line)
{
QString ret("");

readCurrentLine(line);
if(column < currentLineColumns) ret = currententries.at(column);

return( ret );
}

QString CSVDataBase::readItem(const char *identifier, int line)
{
if(definitionLine.isEmpty()) readDefinitionLine();

readCurrentLine(line);

return( readItem(identifier, (const char *)currentLine) );
}

QString CSVDataBase::readItem(const char *identifier, const char *linestr)
{
QString item, retit;
int i(0);
bool notfound(true);

if(!definitionLine.isEmpty())
	{ // string is not empty
	const char* entry;
	for(entry=defentries.first();entry != 0;entry = defentries.next())
		{
		if(strcmp(entry, identifier) == 0) {notfound = false; break;}
		}		
	}

retit = "";
if(!currentLine.isEmpty() && notfound == false)
	{
	i = defentries.at();
	if(i < currentLineColumns) retit = currententries.at(i);
	}

return( retit );
}		

QString CSVDataBase::readLine(int line)
{
QString linestr;

if( isOpen() && isReadable() )
	{
	this->at(0);
	QTextStream t( this );
	for(int i=0; i<=line-1; i++) t.readLine();
	linestr = t.readLine();
	}

return( linestr );
}

QString CSVDataBase::readNextLine()
{
QString linestr;

if( isOpen() && isReadable() )
	{
	QTextStream t( this );
	linestr = t.readLine();
	}

return( linestr );
}

int CSVDataBase::readDefinitionLine()
{
definitionLine = readLine(0);
columns = readItems((const char*)definitionLine, &defentries);

currentLineNr = -2;

return(columns);
}

int CSVDataBase::readCurrentLine(int line)
{
if(line == currentLineNr+1)
	currentLine = readNextLine();
else if(line != currentLineNr)
	currentLine = readLine(line);

if(line != currentLineNr)
	{
	currentLineColumns = readItems((const char*)currentLine, &currententries);
	}

currentLineNr = line;

return(currentLineColumns);
}

/** Returns the number of columns. */
int CSVDataBase::columnCount()
{
if(definitionLine.isEmpty()) readDefinitionLine();

return(columns);
}
