/***************************************************************************
                          completedwulist.h  -  description
                             -------------------
    begin                : Tue Nov 23 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COMPLETEDWULIST_H
#define COMPLETEDWULIST_H

#include <qlistview.h>
#include <qpixmap.h>

class KIconLoader;
class QSplitter;
class SetiLoc;
class SkyMap;
class popListView;

/**
  *@author Gordon Machel
  */
class TotalListViewItem : public QListViewItem
{
public:
	TotalListViewItem(QListView* parent);
	TotalListViewItem(QListView* parent, QListViewItem* after);
	~TotalListViewItem();

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class SumListViewItem : public QListViewItem
{
public:
	SumListViewItem(QListView* parent);
	SumListViewItem(QListView* parent, QListViewItem* after);
	~SumListViewItem();

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class SigSumItem : public QListViewItem
{
public:
	SigSumItem(QListView* parent);
	SigSumItem(QListView* parent, QListViewItem* after);
	~SigSumItem();

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class WUListViewItem : public QListViewItem
{
public:
	WUListViewItem(QListView* parent);
	~WUListViewItem();
  /**  */
  virtual QString key(int column, bool ascending) const;

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class SigListViewItem : public QListViewItem
{
public:
	SigListViewItem(QListView* parent);
	~SigListViewItem();
  /**  */
  virtual QString key(int column, bool ascending) const;

protected:
	virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align);
};

class CompletedWUList : public QWidget
{
Q_OBJECT

struct TableColumn	{
										QString text;
										int     width;
										int     alignment;
										};

public:
	CompletedWUList(QPixmap *starmap, QWidget *parent=0, const char *name=0);
	~CompletedWUList();

public slots:
	void refreshTreeList();
  /**  */
  void refreshList(SetiLoc* loc);

protected:
	void resizeEvent(QResizeEvent *e);
	void createList(popListView* list, TableColumn *tc, int nrcol);
	void fillWUList(SetiLoc *loc);
	void fillTotalList();
	/** creates new or activate old skymap window
	 *	@return pointer to skymap window 
	 */
	SkyMap* openSkymapWindow();
	/** adds all logged WUs of a specific SETI location to the skymap
	 *	@param pointer to SetiLoc location
	 */
	void addLoggedWU(SetiLoc *loc);
	/** adds all logged WUs of all SETI locations to the skymap */
	void addAllLoggedWU();
  /** Fills the signal summary list with values. */
  void fillSigSumList();
  /** Fills the signal list with values. */
  void fillSigList(SetiLoc* loc);
  /**  */
	enum popupIds {ShowSkymap, ReloadLocations};

protected slots:
	void slotSelect(QListViewItem *item);
  /** processes the commands from the right-click popup menu */
  void handleTreeListPopupCommand(int id);
  /** handles right-click mouse clicks in WU list */
  void handleWUListPopupCommand(int id);
  /**  */
  void toggleSorting(int column);
  /**  */


protected: // Protected attributes
  /** The global widget of this tab. All list views below are
    * children of this widget.
    */
	QSplitter*   splitview;
	/** The tree list at the left. Always visible. */
	popListView* treelist;
	/** */
	popListView* cwuList[4];
	enum ListId {WUSummary, WUList, SignalSummary, SignalList};
	/** Determines which list is currently shown. */
	int currentView;
  bool sortorder;
	KIconLoader *icons;
	QPixmap folder_icon;
	QPixmap dish_icon;
	QPixmap *sm;

signals:
  void workUnitLogged();
};

#endif
