/************************************************************************
 * kcreateinst - part of kinst package - rpmdepdlg.cpp                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "rpmdepdlg.h"

#ifndef MIN_WIDTH
#define MIN_WIDTH 400
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 150
#endif

// MOC
#include "rpmdepdlg.moc"

kcreateinstRPMDepDlg::kcreateinstRPMDepDlg(QWidget *parent,
					       const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - RPM Dependencies Setup"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create params
  origparams = new tParams;
  newparams = new tParams;

  // Create add_button
  add_button = new QPushButton(this);
  add_button->setText(_i18n("Add"));
  add_button->show();
  connect(add_button, SIGNAL(clicked()), SLOT(add_pressed()));

  // Create remove_button
  remove_button = new QPushButton(this);
  remove_button->setText(_i18n("Remove"));
  remove_button->show();
  connect(remove_button, SIGNAL(clicked()), SLOT(remove_pressed()));

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));
}

void kcreateinstRPMDepDlg::resizeEvent(QResizeEvent*)
{
  // Resize cancel_button
  cancel_button->setGeometry(width()-100,
			     height()-35,
			     90,
			     30);

  // Resize ok button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize add_button
  add_button->setGeometry(ok_button->x()+ok_button->width()+10,
			  ok_button->y(),
			  (width()-ok_button->width()-
			   cancel_button->width()-50)/2,
			  30);

  // Resize remove_button
  remove_button->setGeometry(add_button->x()+ok_button->width()+10,
			     add_button->y(),
			     (width()-ok_button->width()-
			      cancel_button->width()-50)/2,
			     30);
}

void kcreateinstRPMDepDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void kcreateinstRPMDepDlg::setOptions(tParams* actprefs)
{
  /*qstrcpy(origparams->KIFOptions.CheckPriorFile,
	  actprefs->KIFOptions.CheckPriorFile);
  qstrcpy(origparams->KIFOptions.CheckPriorRPM,
	  actprefs->KIFOptions.CheckPriorRPM);
  qstrcpy(newparams->KIFOptions.CheckPriorFile,
	  actprefs->KIFOptions.CheckPriorFile);
  qstrcpy(newparams->KIFOptions.CheckPriorRPM,
	  actprefs->KIFOptions.CheckPriorRPM);

  filedet_edit->setText(newparams->KIFOptions.CheckPriorFile);
  rpmdet_edit->setText(newparams->KIFOptions.CheckPriorRPM);

  show();

  qstrcpy(actprefs->KIFOptions.CheckPriorFile,
	  origparams->KIFOptions.CheckPriorFile);
  qstrcpy(actprefs->KIFOptions.CheckPriorRPM,
	  origparams->KIFOptions.CheckPriorRPM);
  */
}

void kcreateinstRPMDepDlg::add_pressed()
{
}

void kcreateinstRPMDepDlg::remove_pressed()
{
}

void kcreateinstRPMDepDlg::ok_pressed()
{
  /*qstrncpy(newparams->KIFOptions.CheckPriorFile, filedet_edit->text(), 1024);
  qstrncpy(newparams->KIFOptions.CheckPriorRPM, rpmdet_edit->text(), 1024);

  qstrcpy(origparams->KIFOptions.CheckPriorFile,
	  newparams->KIFOptions.CheckPriorFile);
  qstrcpy(origparams->KIFOptions.CheckPriorRPM,
  newparams->KIFOptions.CheckPriorRPM);*/

  hide();
}

void kcreateinstRPMDepDlg::cancel_pressed()
{
  hide();
}

