/************************************************************************
 * kcreateinst - part of kinst package - multipack.h                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _MULTIPACK_H
#define _MULTIPACK_H

#include "tparams.h"
#include "tgzview.h"
#include "tgzcompose.h"
#include "locale.h"
#include "stringfunc.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlcdnumber.h>
#include <qvalidator.h>
#include <qmessagebox.h>

#include <kfiledialog.h>

class tMultiPackDlg:public QDialog
{
  Q_OBJECT
 private:
  int actpackage;
  tParams* params;
  tParams* origparams;
  QIntValidator* versionval;
  QFrame* Separation;
  QFrame* Separation2;
  QFrame* actpackage_frame;
  QLabel* in_label;
  QLabel* out_label;
  QLabel* programname_label;
  QLabel* sourcefilename_label;
  QLabel* checkpriorfile_label;
  QLabel* checkpriorrpm_label;
  QLabel* iconfile_label;
  QLabel* execbinary_label;
  QLabel* kdelnkadditions_label;
  QLabel* preinstallscript_label;
  QLabel* doneinstallscript_label;
  QLabel* librarydir_label;
  QLabel* version_label;
  QLineEdit* programname_edit;
  QLineEdit* sourcefilename_edit;
  QLineEdit* checkpriorfile_edit;
  QLineEdit* checkpriorrpm_edit;
  QLineEdit* iconfile_edit;
  QLineEdit* execbinary_edit;
  QLineEdit* kdelnkadditions_edit;
  QLineEdit* preinstallscript_edit;
  QLineEdit* doneinstallscript_edit;
  QLineEdit* librarydir_edit;
  QLineEdit* versionmaj_edit;
  QLineEdit* versionmin_edit;
  QLineEdit* versionrel_edit;
  QLCDNumber* actpackage_lcd;
  QPushButton* sourcefilename_button;
  QPushButton* iconfile_button;
  QPushButton* execbinary_button;
  QPushButton* kdelnkadditions_button;
  QPushButton* preinstallscript_button;
  QPushButton* doneinstallscript_button;
  QPushButton* librarydir_button;
  QPushButton* compose_button;
  QPushButton* next_button;
  QPushButton* back_button;
  QPushButton* ok_button;
  QPushButton* cancel_button;
  QPushButton* help_button;
  KFileDialog* FileSelector;
  tTGZViewDlg* TGZViewer;
  tTGZComposeDlg* TGZComposeDlg;
 private slots:
  void Browse1Pressed();
  void Browse2Pressed();
  void Browse3Pressed();
  void Browse4Pressed();
  void Browse5Pressed();
  void Browse6Pressed();
  void Browse7Pressed();
  void compose_pressed();
  void next_pressed();
  void back_pressed();
  void ok_pressed();
  void cancel_pressed();
  void help_pressed();
 protected:
  void resizeEvent(QResizeEvent*);
  void closeEvent(QCloseEvent *e);
 public:
  void showdlg(tParams* given_params);
  tMultiPackDlg(QWidget *parent, const char *name);
};

#endif

