/************************************************************************
 * kcreateinst - part of kinst package - gui.cpp                        *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "gui.h"

#ifndef MAIN_WINDOW_WIDTH
#define MAIN_WINDOW_WIDTH 640
#endif

#ifndef MAIN_WINDOW_HEIGHT
#define MAIN_WINDOW_HEIGHT 475
#endif

#ifndef OPEN_TEXT_CMD
#define OPEN_TEXT_CMD "kedit "
#endif

#ifndef OPEN_GFX_CMD
#define OPEN_GFX_CMD "kview "
#endif

// MOC einbinden
#include "gui.moc"

// Include pictures
#include "kcreateinst.xpm"
#include "exit.xpm"
#include "start.xpm"
#include "filenew.xpm"
#include "fileopen.xpm"
#include "filesave.xpm"

tYesNoDlg::tYesNoDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  setMinimumSize(320, 100);
  resize(320, 100);

  text_label = new QLabel(this);
  text_label->setText("");
  text_label->setAlignment(AlignVCenter | AlignHCenter);
  text_label->show();

  yes_button = new QPushButton(this);
  yes_button->setText(_i18n("Yes"));
  yes_button->show();
  connect(yes_button, SIGNAL(clicked()), this, SLOT(YesPressed()));
  
  no_button = new QPushButton(this);
  no_button->setText(_i18n("No"));
  no_button->show();
  connect(no_button, SIGNAL(clicked()), this, SLOT(NoPressed()));

  i = 0;
}

void tYesNoDlg::resizeEvent(QResizeEvent*)
{
  yes_button->setGeometry(10,
			  height()-35,
			  90,
			  30);

  no_button->setGeometry(width()-100,
			 height()-35,
			 90,
			 30);

  text_label->setGeometry(10,
			  5,
			  width()-20,
			  height()-yes_button->height()-15);
}

void tYesNoDlg::YesPressed()
{
  i = 1;
  hide();
}

void tYesNoDlg::NoPressed()
{
  i = 0;
  hide();
}

int tYesNoDlg::getYesNo(QString text_to_display)
{
  i = 0;

  text = text_to_display;

  text_label->setText(text);

  show();

  return(i);
}

kcreateinstMainWidget::kcreateinstMainWidget():KMainWindow()
{
  QString string;
  QFont font;

  // General Window Properties
  setCaption("");
  MainWindowCaption = "";
  resize(MAIN_WINDOW_WIDTH, MAIN_WINDOW_HEIGHT);

  // Create params
  params = new tParams;
  params->targetpath = "";
  params->onefilepack = 0;
  params->selfextracting = 0;
  strcpy(params->KIFOptions.CheckPriorFile, "");
  strcpy(params->KIFOptions.CheckPriorRPM, "");

  // Create config
  config = KGlobal::config();
  config->setGroup("Locations");
  params->kipackpath = config->readEntry("kipackpath", "");
  params->selfextractpath = config->readEntry("selfextractpath", "");
  params->kinstpath = config->readEntry("kinstpath", "");
  params->kinstlocalepath = config->readEntry("kinstlocalepath", "");
  params->scriptpath = config->readEntry("scriptpath", "");

  // Create ToolBar pixmaps
  new_picture = new QPixmap(filenew_xpm);
  open_picture = new QPixmap(fileopen_xpm);
  save_picture = new QPixmap(filesave_xpm);
  exit_picture = new QPixmap(exit_xpm);
  start_picture = new QPixmap(start_xpm);

  // Create File Selection Dialog
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
				 false);
  FileSelector->hide();

  // Create Preferences Dialog
  preferences_dlg = new kcreateinstPreferences(this, "prefs");
  preferences_dlg->hide();

  // Create Create Dialog
  create_dlg = new kcreateinstCreateDlg(this, "create");
  create_dlg->hide();

  // Create Previous Installation Detector Dialog
  previnst_dlg = new kcreateinstPrevInstDlg(this, "previnst");
  previnst_dlg->hide();

  // Create Post Installation Script Builder
  scriptbuild_dlg = new kcreateinstScriptBuild(this, "scriptbuild");
  scriptbuild_dlg->hide();

  // Create NewProject_YesNoDlg
  NewProject_YesNoDlg = new tYesNoDlg(this, "newprojectyesno");
  NewProject_YesNoDlg->hide();

  // Create StatusBar
  statusBar()->insertItem(_i18n("Ready."), 0, 1);
  statusBar()->setItemAlignment(0, AlignLeft|AlignVCenter);
  statusBar()->show();

  // Create FileMenu
  filemenu = new QPopupMenu();
  filemenu->insertItem(SmallIcon("filenew"), _i18n("&New"), this,
		       SLOT(NewProject()));
  filemenu->setItemEnabled(0, true);
  filemenu->insertItem(SmallIcon("fileopen"), _i18n("&Open..."), this,
		       SLOT(LoadPressed()));
  filemenu->setItemEnabled(1, true);
  filemenu->insertSeparator();
  filemenu->insertItem(SmallIcon("filesave"), _i18n("&Save"), this,
		       SLOT(SavePressed()));
  filemenu->setItemEnabled(3, true);
  filemenu->insertItem(_i18n("Save &As..."), this, SLOT(SaveAsPressed()));
  filemenu->setItemEnabled(4, true);
  filemenu->insertSeparator();
  filemenu->insertItem(SmallIcon("exit"), _i18n("&Quit"), kapp, SLOT(quit()));

  // Create OptionsMenu
  optionsmenu = new QPopupMenu();
  optionsmenu->insertItem(_i18n("&Preferences..."), this,
			  SLOT(PreferencesDlgOpened()));

  // Create ScriptMenu
  scriptmenu = new QPopupMenu();
  scriptmenu->insertItem(_i18n("&Pre Installation Script..."));
  scriptmenu->setItemEnabled(0, false);
  scriptmenu->insertItem(_i18n("&After Installation Script..."), this,
			 SLOT(scriptbuildshow()));
  scriptmenu->setItemEnabled(1, true);

  // Create MultiPackageMenu
  multipackagemenu = new QPopupMenu();
  multipackagemenu->insertItem(_i18n("&Additional Packages..."), this,
			       SLOT(multipackageshow()));
  multipackagemenu->setItemEnabled(0, true);

  // Create MenuBar
  menuBar()->insertItem(_i18n("&File"), filemenu);
  menuBar()->insertItem(_i18n("&Options"), optionsmenu);
  menuBar()->insertItem(_i18n("&Scripts"), scriptmenu);
  menuBar()->insertItem(_i18n("&MultiPackage"), multipackagemenu);
  menuBar()->insertSeparator();
  string = "kcreateinst (";
  string += PACKAGE;
  string += ") - ";
  string += VERSION;
  string += _i18n("\n\nCopyright (C) 2000  Steffen Sobiech\n\n");
  string += _i18n("This program underlies the GPL and comes with\n");
  string += _i18n("ABSOLUTELY NO WARRANTY.\n");
  menuBar()->insertItem(_i18n("&Help"), helpMenu(string, false));
  menuBar()->show();

  // Create ToolBar
  toolBar(0)->insertButton(MainBarIcon("filenew"), 1, true, _i18n("New"));
  toolBar(0)->addConnection(1, SIGNAL(clicked()), this, SLOT(NewProject()));
  toolBar(0)->insertButton(MainBarIcon("fileopen"), 2, true, _i18n("Open"));
  toolBar(0)->addConnection(2, SIGNAL(clicked()), this, SLOT(LoadPressed()));
  toolBar(0)->insertButton(MainBarIcon("filesave"), 3, true, _i18n("Save"));
  toolBar(0)->addConnection(3, SIGNAL(clicked()), this, SLOT(SavePressed()));
  toolBar(0)->insertButton(*start_picture, 4, true, _i18n("Start Creation"));
  toolBar(0)->addConnection(4, SIGNAL(clicked()), this, SLOT(CreatePressed()));
  toolBar(0)->insertButton(MainBarIcon("exit"), 5, true, _i18n("Exit"));
  toolBar(0)->addConnection(5, SIGNAL(clicked()), kapp, SLOT(quit()));
  toolBar(0)->show();

  // Create MainView
  mainview = new QWidget(this);
  mainview->setMinimumWidth(MAIN_WINDOW_WIDTH);
  mainview->setMinimumHeight(MAIN_WINDOW_HEIGHT);
  setCentralWidget(mainview);

  // Create kinst_picture and label
  kinst_picture = new QPixmap(kcreateinst_xpm);
  kinst_picture_label = new QLabel(mainview);
  kinst_picture_label->setAlignment(AlignCenter);
  kinst_picture_label->setPixmap(*kinst_picture);
  kinst_picture_label->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  kinst_picture_label->setLineWidth(2);
  kinst_picture_label->setMargin(0);
  kinst_picture_label->show();

  // Create create_button
  create_button = new QPushButton(mainview);
  create_button->setText(_i18n("Create !"));
  create_button->show();
  connect(create_button, SIGNAL(clicked()), SLOT(CreatePressed()));

  // Create sourcefile_label
  sourcefile_label = new QLabel(mainview);
  sourcefile_label->setText(_i18n("Source File Package"));
  sourcefile_label->show();

  // Create sourcefile_edit
  sourcefile_edit = new QLineEdit(mainview);
  sourcefile_edit->setText("");
  sourcefile_edit->show();

  // Create sourcefile_button
  sourcefile_button = new QPushButton(mainview);
  sourcefile_button->setText(_i18n("Browse"));
  sourcefile_button->show();
  connect(sourcefile_button, SIGNAL(clicked()), SLOT(Browse1Pressed()));

  // Create sourcefile_create_button
  sourcefile_create_button = new QPushButton(mainview);
  sourcefile_create_button->setPixmap(*start_picture);
  sourcefile_create_button->show();
  connect(sourcefile_create_button, SIGNAL(clicked()),
	  SLOT(sourcefile_create_button_pressed()));
  QToolTip::add(sourcefile_create_button, _i18n("Compose TGZ"));

  // Create readmefile_label
  readmefile_label = new QLabel(mainview);
  readmefile_label->setText(_i18n("Readme File"));
  readmefile_label->show();

  // Create readmefile_edit
  readmefile_edit = new QLineEdit(mainview);
  readmefile_edit->setText("");
  readmefile_edit->show();

  // Create readmefile_button
  readmefile_button = new QPushButton(mainview);
  readmefile_button->setText(_i18n("Browse"));
  readmefile_button->show();
  connect(readmefile_button, SIGNAL(clicked()), SLOT(Browse2Pressed()));

  // Create readmefile_edit_button
  readmefile_edit_button = new QPushButton(mainview);
  readmefile_edit_button->setPixmap(*open_picture);
  readmefile_edit_button->show();
  connect(readmefile_edit_button, SIGNAL(clicked()),
	  SLOT(readmefile_edit_button_pressed()));
  QToolTip::add(readmefile_edit_button, _i18n("Edit README file"));

  // Create graphicsfile_label
  graphicsfile_label = new QLabel(mainview);
  graphicsfile_label->setText(_i18n("Graphics File"));
  graphicsfile_label->show();

  // Create graphicsfile_edit
  graphicsfile_edit = new QLineEdit(mainview);
  graphicsfile_edit->setText("");
  graphicsfile_edit->show();

  // Create graphicsfile_button
  graphicsfile_button = new QPushButton(mainview);
  graphicsfile_button->setText(_i18n("Browse"));
  readmefile_button->show();
  connect(graphicsfile_button, SIGNAL(clicked()), SLOT(Browse3Pressed()));

  // Create graphicsfile_edit_button
  graphicsfile_edit_button = new QPushButton(mainview);
  graphicsfile_edit_button->setPixmap(*open_picture);
  graphicsfile_edit_button->show();
  connect(graphicsfile_edit_button, SIGNAL(clicked()),
	  SLOT(graphicsfile_edit_button_pressed()));
  QToolTip::add(graphicsfile_edit_button, _i18n("Edit GRAPHICS file"));

  // Create preinstallscript_label
  preinstallscript_label = new QLabel(mainview);
  preinstallscript_label->setText(_i18n("Pre-Install Script"));
  preinstallscript_label->show();

  // Create preinstallscript_edit
  preinstallscript_edit = new QLineEdit(mainview);
  preinstallscript_edit->setText("");
  preinstallscript_edit->show();

  // Create preinstallscript_button
  preinstallscript_button = new QPushButton(mainview);
  preinstallscript_button->setText(_i18n("Browse"));
  preinstallscript_button->show();
  connect(preinstallscript_button, SIGNAL(clicked()), SLOT(Browse4Pressed()));

  // Create preinstallscript_edit_button
  preinstallscript_edit_button = new QPushButton(mainview);
  preinstallscript_edit_button->setPixmap(*open_picture);
  preinstallscript_edit_button->show();
  connect(preinstallscript_edit_button, SIGNAL(clicked()),
	  SLOT(preinstallscript_edit_button_pressed()));
  QToolTip::add(preinstallscript_edit_button,
		_i18n("Edit pre-install-script file"));

  // Create defaultmenuentry_label
  defaultmenuentry_label = new QLabel(mainview);
  defaultmenuentry_label->setText(_i18n("Default Menu Folder"));
  defaultmenuentry_label->show();

  // Create defaultmenuentry_edit
  defaultmenuentry_edit = new QLineEdit(mainview);
  defaultmenuentry_edit->setText("");
  defaultmenuentry_edit->show();

  // Create defaultinstallpath_label
  defaultinstallpath_label = new QLabel(mainview);
  defaultinstallpath_label->setText(_i18n("Default Install Path"));
  defaultmenuentry_label->show();

  // Create defaultinstallpath_edit
  defaultinstallpath_edit = new QLineEdit(mainview);
  defaultinstallpath_edit->setText("");
  defaultinstallpath_edit->show();

  // Create url_label
  url_label = new QLabel(mainview);
  url_label->setText(_i18n("WebSite URL"));
  url_label->show();

  // Create url_edit
  url_edit = new QLineEdit(mainview);
  url_edit->setText("");
  url_edit->show();

  // Create separation
  Separation = new QFrame(mainview);
  Separation->setFrameStyle(QFrame::VLine|QFrame::Sunken);
  Separation->show();

  // Create separation2
  Separation2 = new QFrame(mainview);
  Separation2->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  Separation2->show();

  // Create Col1_Label
  Col1_Label = new QLabel(mainview);
  Col1_Label->setText(_i18n("Outside your package"));
  font.setBold(true);
  font.setPointSize(15);
  Col1_Label->setFont(font);
  Col1_Label->setAlignment(AlignCenter);
  Col1_Label->show();

  // Create Col2_Label
  Col2_Label = new QLabel(mainview);
  Col2_Label->setText(_i18n("Inside your package"));
  font.setBold(true);
  font.setPointSize(15);
  Col2_Label->setFont(font);
  Col2_Label->setAlignment(AlignCenter);
  Col2_Label->show();

  // Create Row2_Label
  Row2_Label = new QLabel(mainview);
  Row2_Label->setText(_i18n("General Options"));
  font.setBold(true);
  font.setPointSize(15);
  Row2_Label->setFont(font);
  Row2_Label->setAlignment(AlignCenter);
  Row2_Label->show();

  // Create exec_label
  exec_label = new QLabel(mainview);
  exec_label->setText(_i18n("Executable"));
  exec_label->show();

  // Create exec_edit
  exec_edit = new QLineEdit(mainview);
  exec_edit->setText("");
  exec_edit->show();

  // Create exec_button
  exec_button = new QPushButton(mainview);
  exec_button->setText(_i18n("Browse"));
  exec_button->show();
  connect(exec_button, SIGNAL(clicked()), SLOT(Browse5Pressed()));

  // Create doneinstallscript_label
  doneinstallscript_label = new QLabel(mainview);
  doneinstallscript_label->setText(_i18n("Done Install Script"));
  doneinstallscript_label->show();

  // Create doneinstallscript_edit
  doneinstallscript_edit = new QLineEdit(mainview);
  doneinstallscript_edit->setText("");
  doneinstallscript_edit->show();

  // Create doneinstallscript_button
  doneinstallscript_button = new QPushButton(mainview);
  doneinstallscript_button->setText(_i18n("Browse"));
  doneinstallscript_button->show();
  connect(doneinstallscript_button, SIGNAL(clicked()), SLOT(Browse6Pressed()));

  // Create icon_label
  icon_label = new QLabel(mainview);
  icon_label->setText(_i18n("Icon"));
  icon_label->show();

  // Create icon_edit
  icon_edit = new QLineEdit(mainview);
  icon_edit->setText("");
  icon_edit->show();

  // Create icon_button
  icon_button = new QPushButton(mainview);
  icon_button->setText(_i18n("Browse"));
  icon_button->show();
  connect(icon_button, SIGNAL(clicked()), SLOT(Browse7Pressed()));

  // Create kdelnkadd_label
  kdelnkadd_label = new QLabel(mainview);
  kdelnkadd_label->setText(_i18n("KDELNK Additions"));
  kdelnkadd_label->show();

  // Create kdelnkadd_button
  kdelnkadd_button = new QPushButton(mainview);
  kdelnkadd_button->setText(_i18n("Browse"));
  kdelnkadd_button->show();
  connect(kdelnkadd_button, SIGNAL(clicked()), SLOT(Browse8Pressed()));

  // Create kdelnkadd_edit
  kdelnkadd_edit = new QLineEdit(mainview);
  kdelnkadd_edit->setText("");
  kdelnkadd_edit->show();

  // Create librarydir_label
  librarydir_label = new QLabel(mainview);
  librarydir_label->setText(_i18n("Shared Libraries Dir"));
  librarydir_label->show();

  // Create librarydir_button
  librarydir_button = new QPushButton(mainview);
  librarydir_button->setText(_i18n("Browse"));
  librarydir_button->show();
  connect(librarydir_button, SIGNAL(clicked()), SLOT(Browse9Pressed()));

  // Create librarydir_edit
  librarydir_edit = new QLineEdit(mainview);
  librarydir_edit->setText("");
  librarydir_edit->show();

  // Create sourcefiletype_group with members
  sourcefiletype_group = new QButtonGroup(mainview);
  sourcefiletype_group->setTitle(_i18n("Source File Type"));
  tgz_radio = new QRadioButton(mainview);
  tgz_radio->setText(_i18n("TGZ"));
  tgz_radio->setChecked(true);
  tgz_radio->show();
  connect(tgz_radio, SIGNAL(clicked()), this, SLOT(tgz_radio_pressed()));
  rpm_radio = new QRadioButton(mainview);
  rpm_radio->setText(_i18n("RPM"));
  rpm_radio->show();
  connect(rpm_radio, SIGNAL(clicked()), this, SLOT(rpm_radio_pressed()));
  deb_radio = new QRadioButton(mainview);
  deb_radio->setText(_i18n("DEB"));
  deb_radio->setEnabled(false);
  deb_radio->show();
  connect(deb_radio, SIGNAL(clicked()), this, SLOT(deb_radio_pressed()));
  sourcefiletype_group->insert(tgz_radio, 1);
  sourcefiletype_group->insert(rpm_radio, 2);
  sourcefiletype_group->insert(deb_radio, 3);
  sourcefiletype_group->show();

  // Create reboot_group with members
  reboot_group = new QButtonGroup(mainview);
  reboot_group->setTitle(_i18n("Recommend Reboot"));
  reboot_yes_radio = new QRadioButton(mainview);
  reboot_yes_radio->setText(_i18n("Yes"));
  reboot_yes_radio->show();
  reboot_no_radio = new QRadioButton(mainview);
  reboot_no_radio->setText(_i18n("No"));
  reboot_no_radio->setChecked(true);
  reboot_no_radio->show();
  reboot_group->insert(reboot_yes_radio, 1);
  reboot_group->insert(reboot_no_radio, 2);
  reboot_group->show();

  // Create relocatable_group with members
  relocatable_group = new QButtonGroup(mainview);
  relocatable_group->setTitle(_i18n("Package Relocatable"));
  relocatable_yes_radio = new QRadioButton(mainview);
  relocatable_yes_radio->setText(_i18n("Yes"));
  relocatable_yes_radio->setChecked(true);
  relocatable_yes_radio->show();
  relocatable_no_radio = new QRadioButton(mainview);
  relocatable_no_radio->setText(_i18n("No"));
  relocatable_no_radio->show();
  relocatable_group->insert(relocatable_yes_radio, 1);
  relocatable_group->insert(relocatable_no_radio, 2);
  relocatable_group->show();

  // Create previnstdetector_button
  previnstdetector_button = new QPushButton(mainview);
  previnstdetector_button->setText(_i18n("Previous Installation Detection"));
  previnstdetector_button->show();
  connect(previnstdetector_button, SIGNAL(clicked()),
	  SLOT(InstDetectPressed()));

  // Create Separation3
  Separation3 = new QFrame(mainview);
  Separation3->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  Separation3->show();

  // Create name_edit
  name_edit = new QLineEdit(mainview);
  name_edit->setText("");
  name_edit->show();

  // Create name_label
  name_label = new QLabel(mainview);
  name_label->setText(_i18n("Program Name"));
  font.setBold(true);
  font.setPointSize(15);
  name_label->setFont(font);
  name_label->setAlignment(AlignCenter);
  name_label->show();

  // Create version_label
  version_label = new QLabel(mainview);
  version_label->setText(_i18n("Version"));
  font.setBold(true);
  font.setPointSize(15);
  version_label->setFont(font);
  version_label->setAlignment(AlignCenter);
  version_label->show();

  // Version input range validator
  versionval = new QIntValidator(this);
  versionval->setRange(0, 127);

  // Create versionmaj_edit
  versionmaj_edit = new QLineEdit(mainview);
  versionmaj_edit->setText("");
  versionmaj_edit->setValidator(versionval);
  versionmaj_edit->setMaxLength(3);
  versionmaj_edit->show();

  // Create versionmin_edit
  versionmin_edit = new QLineEdit(mainview);
  versionmin_edit->setText("");
  versionmin_edit->setValidator(versionval);
  versionmin_edit->setMaxLength(3);
  versionmin_edit->show();

  // Create versionrel_edit
  versionrel_edit = new QLineEdit(mainview);
  versionrel_edit->setText("");
  versionrel_edit->setValidator(versionval);
  versionrel_edit->setMaxLength(3);
  versionrel_edit->show();

  // Create KDNDDropZones
  /*
  sourcefile_dnd = new KDNDDropZone(sourcefile_edit, DndText);
  connect(sourcefile_dnd, SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(sourcefile_dnd_drop()));
  readmefile_dnd = new KDNDDropZone(readmefile_edit, DndText);
  connect(readmefile_dnd, SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(readmefile_dnd_drop()));
  graphicsfile_dnd = new KDNDDropZone(graphicsfile_edit, DndText);
  connect(graphicsfile_dnd, SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(graphicsfile_dnd_drop()));
  preinstallscript_dnd = new KDNDDropZone(preinstallscript_edit, DndText);
  connect(preinstallscript_dnd, SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(preinstallscript_dnd_drop()));
  defaultinstallpath_dnd = new KDNDDropZone(defaultinstallpath_edit, DndText);
  connect(defaultinstallpath_dnd, SIGNAL(dropAction(KDNDDropZone*)),
	  SLOT(defaultinstallpath_dnd_drop()));
  url_dnd = new KDNDDropZone(url_edit, DndURL);
  connect(url_dnd, SIGNAL(dropAction(KDNDDropZone*)), SLOT(url_dnd_drop()));
  */

  // Create TGZViewDlg
  TGZViewDlg = new tTGZViewDlg(this, "TGZViewDlg");
  TGZViewDlg->hide();

  // Create MultiPackDlg
  MultiPackDlg = new tMultiPackDlg(this, "MultiPackDlg");
  MultiPackDlg->hide();

  // Create RPMDepDlg
  RPMDepDlg = new kcreateinstRPMDepDlg(this, "RPMDepDlg");
  RPMDepDlg->hide();

  // Init ActProject
  ActProject = "";
}

void kcreateinstMainWidget::resizeEvent(QResizeEvent*)
{
  // Resize statusbar
  statusBar()->setGeometry(statusBar()->x(), statusBar()->y(),
			   width(), statusBar()->height());
  // Resize separation
  Separation->setGeometry((mainview->width()/2)-45,
			  10,
			  3,
			  360);

  // Resize kinst_picture and label
  kinst_picture_label->setGeometry(mainview->width()-88,
				   10,
				   84,
				   262);

  // Resize separation2
  Separation2->setGeometry(5,
			   Separation->y()+Separation->height()+5,
			   mainview->width()-kinst_picture_label->width()-13,
			   3);

  // Resize create_button
  create_button->setGeometry(mainview->width()-88,
			     mainview->height()-95,
			     84,
			     84);

  // Resize sourcefile_label
  sourcefile_label->setGeometry(5,
				45,
				Separation->x()-10,
				15);

  // Resize sourcefile_edit
  sourcefile_edit->setGeometry(5,
			       62,
			       Separation->x()-105,
			       20);

  // Resize sourcefile_button
  sourcefile_button->setGeometry(sourcefile_edit->x()+
				 sourcefile_edit->width()+5,
				 sourcefile_edit->y()-2,
				 60,
				 24);

  // Resize soourcefile_create_button
  sourcefile_create_button->setGeometry(sourcefile_button->x()+
					sourcefile_button->width()+5,
					sourcefile_edit->y()-2,
					25,
					24);

  // Resize readmefile_label
  readmefile_label->setGeometry(5,
				92,
				Separation->x()-10,
				15);

  // Resize readmefile_edit
  readmefile_edit->setGeometry(5,
			       109,
			       Separation->x()-105,
			       20);

  // Resize readmefile_button
  readmefile_button->setGeometry(readmefile_edit->x()+
				 readmefile_edit->width()+5,
				 readmefile_edit->y()-2,
				 60,
				 24);

  // Resize readmefile_edit_button
  readmefile_edit_button->setGeometry(readmefile_button->x()+
				      readmefile_button->width()+5,
				      readmefile_edit->y()-2,
				      25,
				      24);

  // Resize graphicsfile_label
  graphicsfile_label->setGeometry(5,
				  139,
				  Separation->x()-10,
				  15);

  // Resize graphicsfile_edit
  graphicsfile_edit->setGeometry(5,
				 156,
				 Separation->x()-105,
				 20);

  // Resize graphicsfile_button
  graphicsfile_button->setGeometry(graphicsfile_edit->x()+
				   graphicsfile_edit->width()+5,
				   graphicsfile_edit->y()-2,
				   60,
				   24);

  // Resize graphicsfile_edit_button
  graphicsfile_edit_button->setGeometry(graphicsfile_button->x()+
					graphicsfile_button->width()+5,
					graphicsfile_edit->y()-2,
					25,
					24);

  // Resize preinstallscript_label
  preinstallscript_label->setGeometry(5,
				      186,
				      Separation->x()-10,
				      15);

  // Resize preinstallscript_edit
  preinstallscript_edit->setGeometry(5,
				     203,
				     Separation->x()-105,
				     20);

  // Resize preinstallscript_button
  preinstallscript_button->setGeometry(preinstallscript_edit->x()+
				       preinstallscript_edit->width()+5,
				       preinstallscript_edit->y()-2,
				       60,
				       24);

  // Resize preinstallscript_edit_button
  preinstallscript_edit_button->setGeometry(preinstallscript_button->x()+
					    preinstallscript_button->width()+5,
					    preinstallscript_edit->y()-2,
					    25,
					    24);

  // Resize defaultmenuentry_label
  defaultmenuentry_label->setGeometry(5,
				      233,
				      Separation->x()-10,
				      15);

  // Resize defaultmenuentry_edit
  defaultmenuentry_edit->setGeometry(5,
				     250,
				     Separation->x()-75,
				     20);

  // Resize defaultinstallpath_label
  defaultinstallpath_label->setGeometry(5,
					280,
					Separation->x()-10,
					15);

  // Resize defaultinstallpath_edit
  defaultinstallpath_edit->setGeometry(5,
				       297,
				       Separation->x()-75,
				       20);

  // Resize url_label
  url_label->setGeometry(5,
			 327,
			 Separation->x()-10,
			 15);

  // Resize url_edit
  url_edit->setGeometry(5,
			344,
			Separation->x()-75,
			20);

  // Resize Col1_Label
  Col1_Label->setGeometry(5,
			  10,
			  Separation->x()-5,
			  20);

  // Resize Col2_Label
  Col2_Label->setGeometry(Separation->x()+5,
			  10,
			  create_button->x()-Separation->x()-10,
			  20);

  // Resize Row2_Label
  Row2_Label->setGeometry((Separation->x()/2)+30,
			  Separation2->y()+7,
			  Separation->x()-70,
			  20);

  // Resize exec_label
  exec_label->setGeometry(Separation->x()+5,
			  45,
			  mainview->width()-
			  Separation->x()-kinst_picture_label->width()-78,
			  15);

  // Resize exec_edit
  exec_edit->setGeometry(Separation->x()+5,
			 62,
			 mainview->width()-
			 Separation->x()-kinst_picture_label->width()-78,
			 20);

  // Resize doneinstallscript_label
  doneinstallscript_label->setGeometry(Separation->x()+5,
				       92,
				       mainview->width()-
				       Separation->x()-
				       kinst_picture_label->width()-78,
				       15);

  // Resize doneinstallscript_edit
  doneinstallscript_edit->setGeometry(Separation->x()+5,
				      109,
				      mainview->width()-
				      Separation->x()-
				      kinst_picture_label->width()-78,
				      20);

  // Resize icon_label
  icon_label->setGeometry(Separation->x()+5,
			  139,
			  mainview->width()-
			  Separation->x()-kinst_picture_label->width()-78,
			  15);

  // Resize icon_edit
  icon_edit->setGeometry(Separation->x()+5,
			 156,
			 mainview->width()-
			 Separation->x()-kinst_picture_label->width()-78,
			 20);

  // Resize kdelnkadd_label
  kdelnkadd_label->setGeometry(Separation->x()+5,
			       186,
			       mainview->width()-
			       Separation->x()-kinst_picture_label->width()-78,
			       15);

  // Resize kdelnkadd_edit
  kdelnkadd_edit->setGeometry(Separation->x()+5,
			      203,
			      mainview->width()-
			      Separation->x()-kinst_picture_label->width()-78,
			      20);

  // Resize librarydir_label
  librarydir_label->setGeometry(Separation->x()+5,
				233,
				mainview->width()-
				Separation->x()-
				kinst_picture_label->width()-78,
				15);

  // Resize librarydir_edit
  librarydir_edit->setGeometry(Separation->x()+5,
			       250,
			       mainview->width()-
			       Separation->x()-kinst_picture_label->width()-78,
			       20);

  // Resize sourcefiletype_group and members
  sourcefiletype_group->setGeometry(5,
  				    Separation2->y()+50,
				    Separation->x()-110,
				    45);
  
  tgz_radio->setGeometry(sourcefiletype_group->x()+5,
			 sourcefiletype_group->y()+20,
			 (sourcefiletype_group->width()-20)/3,
			 15);

  rpm_radio->setGeometry(tgz_radio->x()+tgz_radio->width()+5,
			 sourcefiletype_group->y()+20,
			 (sourcefiletype_group->width()-20)/3,
			 15);

  deb_radio->setGeometry(rpm_radio->x()+rpm_radio->width()+5,
			 sourcefiletype_group->y()+20,
			 (sourcefiletype_group->width()-20)/3,
			 15);

  // Resize reboot_group and members
  reboot_group->setGeometry(5,
			    Separation2->y()+5,
			    Row2_Label->x()-10,
			    45);
  
  reboot_yes_radio->setGeometry(reboot_group->x()+5,
				reboot_group->y()+20,
				(reboot_group->width()-20)/2,
				15);

  reboot_no_radio->setGeometry(reboot_yes_radio->x()+
			       reboot_yes_radio->width()+5,
			       reboot_group->y()+20,
			       (reboot_group->width()-20)/2,
			       15);

  // Resize relocatable_group and members
  relocatable_group->setGeometry(Row2_Label->width()+Row2_Label->x()+5,
				 Separation2->y()+5,
				 kinst_picture_label->x()-
				 Row2_Label->x()-Row2_Label->width()-9,
				 45);
  
  relocatable_yes_radio->setGeometry(relocatable_group->x()+5,
				     relocatable_group->y()+20,
				     (relocatable_group->width()-20)/2,
				     15);

  relocatable_no_radio->setGeometry(relocatable_yes_radio->x()+
				    relocatable_yes_radio->width()+5,
				    relocatable_group->y()+20,
				    (relocatable_group->width()-20)/2,
				    15);

  // Resize previnstdetector_button
  previnstdetector_button->setGeometry(sourcefiletype_group->x()+
				       sourcefiletype_group->width()+5,
				       Separation2->y()+59,
				       /*(mainview->width()-
				       sourcefiletype_group->width()-
				       kinst_picture_label->width()-19)/2,*/
				       previnstdetector_button->
				       sizeHint().width(),
				       35);

  // Resize exec_button
  exec_button->setGeometry(exec_edit->x()+exec_edit->width()+5,
			   exec_edit->y()-2,
			   60,
			   24);

  // Resize doneinstallscript_button
  doneinstallscript_button->setGeometry(doneinstallscript_edit->x()+
					doneinstallscript_edit->width()+5,
					doneinstallscript_edit->y()-2,
					60,
					24);

  // Resize icon_button
  icon_button->setGeometry(icon_edit->x()+icon_edit->width()+5,
			   icon_edit->y()-2,
			   60,
			   24);

  // Resize kdelnkadd_button
  kdelnkadd_button->setGeometry(kdelnkadd_edit->x()+kdelnkadd_edit->width()+5,
				kdelnkadd_edit->y()-2,
				60,
				24);

  // Resize librarydir_button
  librarydir_button->setGeometry(librarydir_edit->x()+
				 librarydir_edit->width()+5,
				 librarydir_edit->y()-2,
				 60,
				 24);

  // Resize separation3
  Separation3->setGeometry(Separation->x()+5,
			   librarydir_edit->y()+librarydir_edit->height()+5,
			   mainview->width()-Separation->x()-10,
			   3);

  // Resize name_label
  name_label->setGeometry(Separation->x()+5,
			  Separation3->y()+10,
			  create_button->x()-Separation->x()-10,
			  20);

  // Resize name_edit
  name_edit->setGeometry(Separation->x()+35,
			 name_label->y()+name_label->height()+15,
			 mainview->width()-
			 Separation->x()-kinst_picture_label->width()-78,
			 20);

  // Resize version_label
  version_label->setGeometry(name_edit->x()+name_edit->width()+5,
			     name_label->y(),
			     mainview->width()-
			     Separation->x()-name_edit->width()-45,
			     20);

  // Resize versionmaj_edit
  versionmaj_edit->setGeometry(version_label->x(),
			       name_edit->y(),
			       (version_label->width()-10)/3,
			       20);

  // Resize versionmin_edit
  versionmin_edit->setGeometry(versionmaj_edit->x()+versionmaj_edit->width()+5,
			       name_edit->y(),
			       (version_label->width()-10)/3,
			       20);

  // Resize versionrel_edit
  versionrel_edit->setGeometry(versionmin_edit->x()+versionmin_edit->width()+5,
			       name_edit->y(),
			       (version_label->width()-10)/3,
			       20);
}

void kcreateinstMainWidget::PreferencesDlgOpened()
{
  preferences_dlg->getPrefs(params);
  config->setGroup("Locations");
  config->writeEntry("kipackpath", params->kipackpath);
  config->writeEntry("selfextractpath", params->selfextractpath);
  config->writeEntry("kinstpath", params->kinstpath);
  config->writeEntry("kinstlocalepath", params->kinstlocalepath);
  config->writeEntry("scriptpath", params->scriptpath);
  config->sync();
}

void kcreateinstMainWidget::CreatePressed()
{
  int startit;
  create_dlg->getCreatePrefs(params, &startit);
  if(startit)
    {
      statusBar()->changeItem(_i18n("Creating Package..."), 0);
      kapp->processEvents();

      qstrcpy(params->KIFOptions.ProgramName, name_edit->text());
      if(tgz_radio->isChecked())
	{
	  qstrcpy(params->KIFOptions.SourceFileType, "tgz");
	  strcpy(params->KIFOptions.CheckPriorRPM, "");
	  // strcpy(params->KIFOptions.CheckPriorDEB, "");
	}
      if(rpm_radio->isChecked())
	{
	  qstrcpy(params->KIFOptions.SourceFileType, "rpm");
	  strcpy(params->KIFOptions.CheckPriorFile, "");
	  // strcpy(params->KIFOptions.CheckPriorDEB, "");
	}
      if(deb_radio->isChecked())
	{
	  qstrcpy(params->KIFOptions.SourceFileType, "deb");
	  strcpy(params->KIFOptions.CheckPriorRPM, "");
	  strcpy(params->KIFOptions.CheckPriorFile, "");
	}
      qstrcpy(params->KIFOptions.SourceFile, sourcefile_edit->text());
      qstrcpy(params->KIFOptions.ReadMeFile, readmefile_edit->text());
      qstrcpy(params->KIFOptions.GraphicsFile, graphicsfile_edit->text());
      qstrcpy(params->KIFOptions.IconFile, icon_edit->text());
      qstrcpy(params->KIFOptions.ExecBinary, exec_edit->text());
      qstrcpy(params->KIFOptions.KDELNKAdditions, kdelnkadd_edit->text());
      qstrcpy(params->KIFOptions.DefaultInstallPath,
	      defaultinstallpath_edit->text());
      if(relocatable_yes_radio->isChecked())
	qstrcpy(params->KIFOptions.RelocatablePackage, "YES");
      if(relocatable_no_radio->isChecked())
	qstrcpy(params->KIFOptions.RelocatablePackage, "NO");
      if(reboot_yes_radio->isChecked())
	qstrcpy(params->KIFOptions.RecommendReboot, "YES");
      if(reboot_no_radio->isChecked())
	qstrcpy(params->KIFOptions.RecommendReboot, "NO");
      qstrcpy(params->KIFOptions.DefaultMenuEntry,
	      defaultmenuentry_edit->text());
      qstrcpy(params->KIFOptions.PreInstallScript,
	      preinstallscript_edit->text());
      qstrcpy(params->KIFOptions.DoneInstallScript,
	      doneinstallscript_edit->text());

      switch(CreateInstallation(params))
	{
	case 0: QMessageBox::warning(this, "kcreateinst",
				     _i18n("General failure"));
	  break;
	case 1: QMessageBox::information(this, "kcreateinst",
					 _i18n("Operation successful"));
	  break;
	case 2: QMessageBox::information(this, "kcreateinst",
					 _i18n("I/O error while opening/creating KIF file"));
	  break;
	case 3: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting source package file"));
	  break;
	case 4: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting readme file"));
	  break;
	case 5: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting graphics file"));
	  break;
	case 6: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting pre-install script"));
	  break;
	case 7: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while creating one-file package"));
	  break;
	case 8: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting locale data"));
	  break;
	case 9: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while collecting kinst program"));
	  break;
	case 10: QMessageBox::information(this, "kcreateinst",
					  _i18n("Error while preparing KIP file"));
	  break;
	case 11: QMessageBox::information(this, "kcreateinst",
					  _i18n("Error while creating sfx installer"));
	  break;
	case 12: QMessageBox::information(this, "kcreateinst",
					  _i18n("Error while marking sfx-installer executable"));
	  break;
	case 13: QMessageBox::information(this, "kcreateinst",
					 _i18n("Error while creating target directory"));
	  break;
	default: QMessageBox::warning(this, "kcreateinst",
				      _i18n("Unknown general error"));
	}

      statusBar()->changeItem(_i18n("Ready."), 0);
    }
}

void kcreateinstMainWidget::Browse1Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.SourceFile, String, 1024);
      sourcefile_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstMainWidget::Browse2Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.ReadMeFile, String, 1024);
      readmefile_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstMainWidget::Browse3Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.GraphicsFile, String, 1024);
      graphicsfile_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstMainWidget::Browse4Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.PreInstallScript, String, 1024);
      preinstallscript_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstMainWidget::Browse5Pressed()
{
  QString String;
  String = TGZViewDlg->getFilePath(sourcefile_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.ExecBinary, String, 1024);
      exec_edit->setText(String);
    }

  TGZViewDlg->hide();
}

void kcreateinstMainWidget::Browse6Pressed()
{
  QString String;
  String = TGZViewDlg->getFilePath(sourcefile_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.DoneInstallScript, String, 1024);
      doneinstallscript_edit->setText(String);
    }

  TGZViewDlg->hide();
}

void kcreateinstMainWidget::Browse7Pressed()
{
  QString String;
  String = TGZViewDlg->getFilePath(sourcefile_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.IconFile, String, 1024);
      icon_edit->setText(String);
    }

  TGZViewDlg->hide();
}

void kcreateinstMainWidget::Browse8Pressed()
{
  QString String;
  String = TGZViewDlg->getFilePath(sourcefile_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.KDELNKAdditions, String, 1024);
      kdelnkadd_edit->setText(String);
    }

  TGZViewDlg->hide();
}

void kcreateinstMainWidget::Browse9Pressed()
{
  QString String;
  String = TGZViewDlg->getFilePath(sourcefile_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.LibraryDir, String, 1024);
      librarydir_edit->setText(String);
    }

  TGZViewDlg->hide();
}

void kcreateinstMainWidget::LoadPressed()
{
  QString String;
  char cptr_version[4];
  int i;

  i = 0;

  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Load project file"));

  if(qstrlen(String) > 0) i = LoadParams(params, String);
  else return;

  switch(i)
    {
    case 0: QMessageBox::warning(this, _i18n("kcreateinst - Load Project"),
				 _i18n("General failure"));
    break;
    case 1: break;
    case 2: QMessageBox::information(this, _i18n("kcreateinst - Load Project"),
				     _i18n("I/O error while opening file"));
    break;
    case 3: QMessageBox::information(this, _i18n("kcreateinst - Load Project"),
				     _i18n("I/O error while reading file"));
    break;
    case 4: QMessageBox::information(this, _i18n("kcreateinst - Load Project"),
				     _i18n("Wrong project file version"));
    break;
    break;
    default: QMessageBox::warning(this, _i18n("kcreateinst - Load Project"),
				  _i18n("Unknown general error"));
    }

  if(i != 1) return;

  ActProject = String;
  MainWindowCaption = ActProject;
  setCaption(MainWindowCaption);

  name_edit->setText(params->KIFOptions.ProgramName);
  if(strcasecmp(params->KIFOptions.SourceFileType, "TGZ") == 0)
    tgz_radio->setChecked(true);
  if(strcasecmp(params->KIFOptions.SourceFileType, "RPM") == 0)
    rpm_radio->setChecked(true);
  // if(strcasecmp(params->KIFOptions.SourceFileType, "DEB") == 0)
  //   deb_radio->setChecked(true);
  sourcefile_edit->setText(params->KIFOptions.SourceFile);
  readmefile_edit->setText(params->KIFOptions.ReadMeFile);
  graphicsfile_edit->setText(params->KIFOptions.GraphicsFile);
  icon_edit->setText(params->KIFOptions.IconFile);
  exec_edit->setText(params->KIFOptions.ExecBinary);
  kdelnkadd_edit->setText(params->KIFOptions.KDELNKAdditions);
  librarydir_edit->setText(params->KIFOptions.LibraryDir);
  url_edit->setText(params->KIFOptions.URL);
  defaultinstallpath_edit->setText(params->KIFOptions.DefaultInstallPath);
  if(strcasecmp(params->KIFOptions.RelocatablePackage, "YES") == 0)
    {
      relocatable_yes_radio->setChecked(true);
      relocatable_no_radio->setChecked(false);
    }
  if(strcasecmp(params->KIFOptions.RelocatablePackage, "NO") == 0)
    {
      relocatable_no_radio->setChecked(true);
      relocatable_yes_radio->setChecked(false);
    }
  if(strcasecmp(params->KIFOptions.RecommendReboot, "YES") == 0)
    {
      reboot_yes_radio->setChecked(true);
      reboot_no_radio->setChecked(false);
    }
  if(strcasecmp(params->KIFOptions.RecommendReboot, "NO") == 0)
    {
      reboot_no_radio->setChecked(true);
      reboot_yes_radio->setChecked(false);
    }
  defaultmenuentry_edit->setText(params->KIFOptions.DefaultMenuEntry);
  preinstallscript_edit->setText(params->KIFOptions.PreInstallScript);
  doneinstallscript_edit->setText(params->KIFOptions.DoneInstallScript);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMaj);
  versionmaj_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMin);
  versionmin_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionRel);
  versionrel_edit->setText(cptr_version);

  FileSelector->hide();
}

void kcreateinstMainWidget::SaveAsPressed()
{
  QString String;
  int i;

  i = 0;

  String = FileSelector->getSaveFileName(getenv("HOME"),
					 "*", mainview,
					 _i18n("Save project file"));

  qstrcpy(params->KIFOptions.ProgramName, name_edit->text());
  if(tgz_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "tgz");
      strcpy(params->KIFOptions.CheckPriorRPM, "");
      // strcpy(params->KIFOptions.CheckPriorDEB, "");
    }
  if(rpm_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "rpm");
      strcpy(params->KIFOptions.CheckPriorFile, "");
      // strcpy(params->KIFOptions.CheckPriorDEB, "");
    }
  if(deb_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "deb");
      strcpy(params->KIFOptions.CheckPriorRPM, "");
      strcpy(params->KIFOptions.CheckPriorFile, "");
    }
  qstrcpy(params->KIFOptions.SourceFile, sourcefile_edit->text());
  qstrcpy(params->KIFOptions.ReadMeFile, readmefile_edit->text());
  qstrcpy(params->KIFOptions.GraphicsFile, graphicsfile_edit->text());
  qstrcpy(params->KIFOptions.IconFile, icon_edit->text());
  qstrcpy(params->KIFOptions.ExecBinary, exec_edit->text());
  qstrcpy(params->KIFOptions.KDELNKAdditions, kdelnkadd_edit->text());
  qstrcpy(params->KIFOptions.LibraryDir, librarydir_edit->text());
  qstrcpy(params->KIFOptions.URL, url_edit->text());
  qstrcpy(params->KIFOptions.DefaultInstallPath,
	  defaultinstallpath_edit->text());
  if(relocatable_yes_radio->isChecked())
    qstrcpy(params->KIFOptions.RelocatablePackage, "YES");
  if(relocatable_no_radio->isChecked())
    qstrcpy(params->KIFOptions.RelocatablePackage, "NO");
  if(reboot_yes_radio->isChecked())
    qstrcpy(params->KIFOptions.RecommendReboot, "YES");
  if(reboot_no_radio->isChecked())
    qstrcpy(params->KIFOptions.RecommendReboot, "NO");
  qstrcpy(params->KIFOptions.DefaultMenuEntry,
	  defaultmenuentry_edit->text());
  qstrcpy(params->KIFOptions.PreInstallScript,
	  preinstallscript_edit->text());
  qstrcpy(params->KIFOptions.DoneInstallScript,
	  doneinstallscript_edit->text());
  params->KIFOptions.VersionMaj = atoi(versionmaj_edit->text());
  params->KIFOptions.VersionMin = atoi(versionmin_edit->text());
  params->KIFOptions.VersionRel = atoi(versionrel_edit->text());

  if(qstrlen(String) > 0) i = SaveParams(params, String);
  else return;

  switch(i)
    {
    case 0: QMessageBox::warning(this, _i18n("kcreateinst - Save Project"),
				 _i18n("General failure"));
    break;
    case 1: break;
    case 2: QMessageBox::information(this, _i18n("kcreateinst - Save Project"),
				     _i18n("I/O error while creating/opening file"));
    break;
    case 3: QMessageBox::information(this, _i18n("kcreateinst - Save Project"),
				     _i18n("I/O error while writing to file"));
    break;
    default: QMessageBox::warning(this, _i18n("kcreateinst - Save Project"),
				  _i18n("Unknown general error"));
    }

  ActProject = String;
  MainWindowCaption = ActProject;
  setCaption(MainWindowCaption);

  FileSelector->hide();
}

void kcreateinstMainWidget::SavePressed()
{
  int i;

  if(ActProject == "")
    {
      SaveAsPressed();
      return;
    }

  i = 0;

  qstrcpy(params->KIFOptions.ProgramName, name_edit->text());
  if(tgz_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "tgz");
      strcpy(params->KIFOptions.CheckPriorRPM, "");
      // strcpy(params->KIFOptions.CheckPriorDEB, "");
    }
  if(rpm_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "rpm");
      strcpy(params->KIFOptions.CheckPriorFile, "");
      // strcpy(params->KIFOptions.CheckPriorDEB, "");
    }
  if(deb_radio->isChecked())
    {
      qstrcpy(params->KIFOptions.SourceFileType, "deb");
      strcpy(params->KIFOptions.CheckPriorRPM, "");
      strcpy(params->KIFOptions.CheckPriorFile, "");
    }
  qstrcpy(params->KIFOptions.SourceFile, sourcefile_edit->text());
  qstrcpy(params->KIFOptions.ReadMeFile, readmefile_edit->text());
  qstrcpy(params->KIFOptions.GraphicsFile, graphicsfile_edit->text());
  qstrcpy(params->KIFOptions.IconFile, icon_edit->text());
  qstrcpy(params->KIFOptions.ExecBinary, exec_edit->text());
  qstrcpy(params->KIFOptions.KDELNKAdditions, kdelnkadd_edit->text());
  qstrcpy(params->KIFOptions.LibraryDir, librarydir_edit->text());
  qstrcpy(params->KIFOptions.URL, url_edit->text());
  qstrcpy(params->KIFOptions.DefaultInstallPath,
	  defaultinstallpath_edit->text());
  if(relocatable_yes_radio->isChecked())
    qstrcpy(params->KIFOptions.RelocatablePackage, "YES");
  if(relocatable_no_radio->isChecked())
    qstrcpy(params->KIFOptions.RelocatablePackage, "NO");
  if(reboot_yes_radio->isChecked())
    qstrcpy(params->KIFOptions.RecommendReboot, "YES");
  if(reboot_no_radio->isChecked())
    qstrcpy(params->KIFOptions.RecommendReboot, "NO");
  qstrcpy(params->KIFOptions.DefaultMenuEntry,
	  defaultmenuentry_edit->text());
  qstrcpy(params->KIFOptions.PreInstallScript,
	  preinstallscript_edit->text());
  qstrcpy(params->KIFOptions.DoneInstallScript,
	  doneinstallscript_edit->text());
  params->KIFOptions.VersionMaj = atoi(versionmaj_edit->text());
  params->KIFOptions.VersionMin = atoi(versionmin_edit->text());
  params->KIFOptions.VersionRel = atoi(versionrel_edit->text());

  if(qstrlen(ActProject) > 0) i = SaveParams(params, ActProject);
  else return;

  switch(i)
    {
    case 0: QMessageBox::warning(this, _i18n("kcreateinst - Save Project"),
				 _i18n("General failure"));
    break;
    case 1: break;
    case 2: QMessageBox::information(this, _i18n("kcreateinst - Save Project"),
				     _i18n("I/O error while creating/opening file"));
    break;
    case 3: QMessageBox::information(this, _i18n("kcreateinst - Save Project"),
				     _i18n("I/O error while writing to file"));
    break;
    default: QMessageBox::warning(this, _i18n("kcreateinst - Save Project"),
				  _i18n("Unknown general error"));
    }

  FileSelector->hide();
}

void kcreateinstMainWidget::InstDetectPressed()
{
  previnst_dlg->getDetectionPrefs(params);
}

void kcreateinstMainWidget::NewProject()
{
  int i;

  if(!NewProject_YesNoDlg->getYesNo(_i18n("Are you sure?"))) return;

  name_edit->setText("");
  sourcefile_edit->setText("");
  readmefile_edit->setText("");
  graphicsfile_edit->setText("");
  icon_edit->setText("");
  exec_edit->setText("");
  kdelnkadd_edit->setText("");
  librarydir_edit->setText("");
  defaultinstallpath_edit->setText("");
  defaultmenuentry_edit->setText("");
  preinstallscript_edit->setText("");
  doneinstallscript_edit->setText("");
  librarydir_edit->setText("");
  url_edit->setText("");
  versionmaj_edit->setText("");
  versionmin_edit->setText("");
  versionrel_edit->setText("");
  strcpy(params->KIFOptions.CheckPriorFile, "");
  strcpy(params->KIFOptions.CheckPriorRPM, "");

  for(i = 0;i < MAX_ADDITIONAL_PACKAGES;i++)
    {
      strcpy(params->KIFOptions.ProgramName2[i], "");
      strcpy(params->KIFOptions.CheckPriorFile2[i], "");
      strcpy(params->KIFOptions.CheckPriorRPM2[i], "");
      strcpy(params->KIFOptions.SourceFile2[i], "");
      strcpy(params->KIFOptions.IconFile2[i], "");
      strcpy(params->KIFOptions.ExecBinary2[i], "");
      strcpy(params->KIFOptions.KDELNKAdditions2[i], "");
      strcpy(params->KIFOptions.PreInstallScript2[i], "");
      strcpy(params->KIFOptions.DoneInstallScript2[i], "");
      strcpy(params->KIFOptions.LibraryDir2[i], "");
      params->KIFOptions.VersionMaj2[i] = 0;
      params->KIFOptions.VersionMin2[i] = 0;
      params->KIFOptions.VersionRel2[i] = 0;
    }

  ActProject = "";
  MainWindowCaption = "";
  setCaption(MainWindowCaption);
}

void kcreateinstMainWidget::tgz_radio_pressed()
{
  if(tgz_radio->isChecked())
    {
      exec_button->setEnabled(true);
      doneinstallscript_button->setEnabled(true);
      icon_button->setEnabled(true);
      kdelnkadd_button->setEnabled(true);
      librarydir_button->setEnabled(true);
    }
}

void kcreateinstMainWidget::rpm_radio_pressed()
{
  if(rpm_radio->isChecked())
    {
      exec_button->setEnabled(false);
      doneinstallscript_button->setEnabled(false);
      icon_button->setEnabled(false);
      kdelnkadd_button->setEnabled(false);
      librarydir_button->setEnabled(false);
    }
}

void kcreateinstMainWidget::deb_radio_pressed()
{
  if(deb_radio->isChecked())
    {
      exec_button->setEnabled(false);
      doneinstallscript_button->setEnabled(false);
      icon_button->setEnabled(false);
      kdelnkadd_button->setEnabled(false);
      librarydir_button->setEnabled(false);
    }
}

void kcreateinstMainWidget::scriptbuildshow()
{
  qstrcpy(params->KIFOptions.ProgramName, name_edit->text());
  qstrcpy(params->KIFOptions.SourceFile, sourcefile_edit->text());
  if(tgz_radio->isChecked()) qstrcpy(params->KIFOptions.SourceFileType, "tgz");
  if(rpm_radio->isChecked()) qstrcpy(params->KIFOptions.SourceFileType, "rpm");
  if(deb_radio->isChecked()) qstrcpy(params->KIFOptions.SourceFileType, "deb");

  scriptbuild_dlg->setParams(params);
  scriptbuild_dlg->show();
}

void kcreateinstMainWidget::sourcefile_dnd_drop()
{
  QString DNDData;
  QString FillData;
  long int i;

  // DNDData = sourcefile_dnd->getData();
  FillData = "";

  if((DNDData[0] == 'f') && (DNDData[1] == 'i') && (DNDData[2] == 'l') &&
     (DNDData[3] == 'e') && (DNDData[4] == ':'))
    {
      i = 5;
      while(DNDData[i] != 0)
	{
	  FillData += DNDData[i];
	  i++;
	}
      FillData += (char) 0;
      sourcefile_edit->setText(FillData);
    }
}

void kcreateinstMainWidget::readmefile_dnd_drop()
{
  QString DNDData;
  QString FillData;
  long int i;

  // DNDData = readmefile_dnd->getData();
  FillData = "";

  if((DNDData[0] == 'f') && (DNDData[1] == 'i') && (DNDData[2] == 'l') &&
     (DNDData[3] == 'e') && (DNDData[4] == ':'))
    {
      i = 5;
      while(DNDData[i] != 0)
	{
	  FillData += DNDData[i];
	  i++;
	}
      FillData += (char) 0;
      readmefile_edit->setText(FillData);
    }
}

void kcreateinstMainWidget::graphicsfile_dnd_drop()
{
  QString DNDData;
  QString FillData;
  long int i;

  // DNDData = graphicsfile_dnd->getData();
  FillData = "";

  if((DNDData[0] == 'f') && (DNDData[1] == 'i') && (DNDData[2] == 'l') &&
     (DNDData[3] == 'e') && (DNDData[4] == ':'))
    {
      i = 5;
      while(DNDData[i] != 0)
	{
	  FillData += DNDData[i];
	  i++;
	}
      FillData += (char) 0;
      graphicsfile_edit->setText(FillData);
    }
}

void kcreateinstMainWidget::preinstallscript_dnd_drop()
{
  QString DNDData;
  QString FillData;
  long int i;

  // DNDData = preinstallscript_dnd->getData();
  FillData = "";

  if((DNDData[0] == 'f') && (DNDData[1] == 'i') && (DNDData[2] == 'l') &&
     (DNDData[3] == 'e') && (DNDData[4] == ':'))
    {
      i = 5;
      while(DNDData[i] != 0)
	{
	  FillData += DNDData[i];
	  i++;
	}
      FillData += (char) 0;
      preinstallscript_edit->setText(FillData);
    }
}

void kcreateinstMainWidget::defaultinstallpath_dnd_drop()
{
  QString DNDData;
  QString FillData;
  long int i;

  // DNDData = defaultinstallpath_dnd->getData();
  FillData = "";

  if((DNDData[0] == 'f') && (DNDData[1] == 'i') && (DNDData[2] == 'l') &&
     (DNDData[3] == 'e') && (DNDData[4] == ':'))
    {
      i = 5;
      while(DNDData[i] != 0)
	{
	  FillData += DNDData[i];
	  i++;
	}
      FillData += (char) 0;
      defaultinstallpath_edit->setText(FillData);
    }
}

void kcreateinstMainWidget::url_dnd_drop()
{
  // url_edit->setText(url_dnd->getData());
}

void kcreateinstMainWidget::sourcefile_create_button_pressed()
{
  QString newTGZ;

  // Create TGZComposeDlg
  TGZComposeDlg = new tTGZComposeDlg(this, "TGZComposeDlg");
  TGZComposeDlg->hide();

  newTGZ = TGZComposeDlg->ComposeTGZ();

  delete TGZComposeDlg;

  if(qstrlen(newTGZ) > 0)
    {
      sourcefile_edit->setText(newTGZ);
      qstrncpy(params->KIFOptions.SourceFile, newTGZ, 1024);
    }
}

void kcreateinstMainWidget::readmefile_edit_button_pressed()
{
  QString command;
  int err;

  command = OPEN_TEXT_CMD;
  command += readmefile_edit->text();
  command += " &";

  err = system(command);

  if((err == -1) || (err == 127))
    QMessageBox::warning(this, "kcreateinst",
			 _i18n("Could not open README file."));
}

void kcreateinstMainWidget::graphicsfile_edit_button_pressed()
{
  QString command;
  int err;

  command = OPEN_GFX_CMD;
  command += graphicsfile_edit->text();
  command += " &";

  err = system(command);

  if((err == -1) || (err == 127))
    QMessageBox::warning(this, "kcreateinst",
			 _i18n("Could not open graphics file."));
}

void kcreateinstMainWidget::preinstallscript_edit_button_pressed()
{
  QString command;
  int err;

  command = OPEN_TEXT_CMD;
  command += preinstallscript_edit->text();
  command += " &";

  err = system(command);

  if((err == -1) || (err == 127))
    QMessageBox::warning(this, "kcreateinst",
			 _i18n("Could not open pre-install-script via kedit."));
}

void kcreateinstMainWidget::multipackageshow()
{
  MultiPackDlg->showdlg(params);
}
