/************************************************************************
 * kinst - KDE Application Installer - libraries.h                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _LIBRARIES_H
#define _LIBRARIES_H

#include <qdir.h>

#include "locale.h"
#include "readfile.h"

#define LDCONF "/etc/ld.so.conf"

class tInstSharedLibraries
{
 protected:
  QFileInfoList* ActList;
  QFileInfoList* LibSearchList;
  QFileInfo* ActFi;
  QFileInfo* LibSearchFi;
  char lastmatch[FILENAME_MAX];
  char tosearch[FILENAME_MAX];
  QDir* ActDir;
  QDir* LibSearchDir;

 public:
  // Checks version of next needed library
  // returns :
  // 0 - version is not OK
  // 1 - version is OK
  // 2 - all libraries processed
  // 3 - to search library not found
  // 4 - library not found
  int CheckNextLibrary(char* searchname);

  // (Re-)starts the search for the libs in found in directory
  // 0 - general failure
  // 1 - success
  int RestartLibDir(char* directory);

  // Installs a library
  // 0 - general failure
  // 1 - success
  int InstallLibrary(char* filename, char* dir);

  tInstSharedLibraries();
  ~tInstSharedLibraries();
};

#endif
