/************************************************************************
 * kinst - KDE Application Installer - kdeconfig.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <libgen.h>
#include <qdir.h>
#include <qstring.h>
#include <ksimpleconfig.h>
#include <qmessagebox.h>
#include <kstddirs.h>

#include "kdeconfig.h"
#include "stringfunc.h"
#include "locale.h"

#ifndef EOL
#define EOL 10
#endif

tKDEConfig::tKDEConfig()
{
  options = new tKIFOptions;

  KDELNKfile = NULL;
}

tKDEConfig::~tKDEConfig()
{
  delete options;
}

void tKDEConfig::setOptions(tKIFOptions* newoptions)
{
  *options = *newoptions;
}

bool tKDEConfig::DeLocalized(const char* dir, const char* localized,
			     QString* delocalized)
{
  QString filename;
  QString string;
  QDir d(dir);
  const QFileInfoList* list = d.entryInfoList();
  QFileInfoListIterator it(*list);
  QFileInfo* fi;
  KSimpleConfig* config;
  bool result;

#ifdef _DEBUG_
  printf("kdeconfig:  DeLocalized: in: %s\n", dir);
#endif

  d.setFilter(QDir::Dirs);

  filename = dir;
  filename += "/.directory";
  config = new KSimpleConfig(filename, true);
  config->setDesktopGroup();
  *delocalized = 
    config->readEntry("Name"); // KDE automatically localizes here
  delete config;
  if(qstrcmp(localized, *delocalized) == 0)
    {
      result = true;
      *delocalized = dir;
    }
  else result = false;

  while( (fi=it.current()) )
    {
      if(d.isReadable() && (result == false)
	 && (qstrcmp(fi->fileName().data(), "."))
	 && (qstrcmp(fi->fileName().data(), ".."))
	 && (fi->isDir()))
	{
	  string = dir;
	  string += "/";
	  string += fi->fileName().data();
	  result = DeLocalized(string, localized, delocalized);
	}
      ++it;
    }

  return(result);
}

int tKDEConfig::DetermineKDELNK(int extnr)
{
  QString KDELNKPath;
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];
  QString kde_appsdir;

  kde_appsdir = getenv("KDEDIR");
  if(qstrlen(kde_appsdir) == 0) return(0);
  kde_appsdir += "/share/applnk";

  if(extnr < 0)
    {
      strncpy(ProgramName, options->ProgramName, KIFOPTIONS_FIELD_LENGTH);
    }
  else
    {
      strncpy(ProgramName, options->ProgramName2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
    }

  if(DeLocalized(kde_appsdir, options->DefaultMenuEntry,
		 &KDELNKPath) == false)
    {
      KDELNKPath = kde_appsdir;
      KDELNKPath += "/";
      KDELNKPath += options->DefaultMenuEntry;
      KDELNKPath += "/";
      KDELNKPath += ProgramName;
      KDELNKPath += ".desktop";
    }
  else
    {
      KDELNKPath += "/";
      KDELNKPath += ProgramName;
      KDELNKPath += ".desktop";
    }

#ifdef _DEBUG_
  char KDELNKPath2[FILENAME_MAX];
  qstrncpy(KDELNKPath2, KDELNKPath, FILENAME_MAX);
  printf("KDE Entry filename : %s\n", KDELNKPath2);
#endif

  KDELNKfilename = KDELNKPath;

  return(1);
}

int tKDEConfig::OpenKDELNK()
{
  char KDELNKfilename2[FILENAME_MAX];

  qstrncpy(KDELNKfilename2, KDELNKfilename, FILENAME_MAX);

  mkdir(dirname(KDELNKfilename2), 0755);

  if(KDELNKfile == NULL)
    KDELNKfile = fopen(KDELNKfilename, "r"); else return(2);
  if(KDELNKfile != NULL)
    {
      fclose(KDELNKfile);
      return(3);
    }

  KDELNKfile = fopen(KDELNKfilename, "w+");
  if(KDELNKfile == NULL) return(0);

  return(1);
}

int tKDEConfig::WriteKDELNK(int extnr)
{
  char copy;
  char towrite[2048];
  char* extensionfilename;
  FILE* extensionfile;
  int err;
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];
  char IconFile[KIFOPTIONS_FIELD_LENGTH];
  char ExecBinary[KIFOPTIONS_FIELD_LENGTH];
  char KDELNKAdditions[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    {
      strncpy(ProgramName, options->ProgramName, KIFOPTIONS_FIELD_LENGTH);
      strncpy(IconFile, options->IconFile, KIFOPTIONS_FIELD_LENGTH);
      strncpy(ExecBinary, options->ExecBinary, KIFOPTIONS_FIELD_LENGTH);
      strncpy(KDELNKAdditions, options->KDELNKAdditions,
	      KIFOPTIONS_FIELD_LENGTH);
    }
  else
    {
      strncpy(ProgramName, options->ProgramName2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(IconFile, options->IconFile2[extnr], KIFOPTIONS_FIELD_LENGTH);
      strncpy(ExecBinary, options->ExecBinary2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(KDELNKAdditions, options->KDELNKAdditions2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
    }

  err = 1;

  if(KDELNKfile == NULL) return(4);

#ifdef _DEBUG_
#ifndef _SHOW_
  // #define _SHOW_
#endif
#endif

  strcpy(towrite, "[Desktop Entry]");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  strcpy(towrite, "Type=Application");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  strcpy(towrite, "Icon=");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);

  strncpy(towrite, options->DefaultInstallPath, 2048);
  if(options->
     DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
    _strncat(towrite, "/", 2048);
  _strncat(towrite, IconFile, 2048);
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  strcpy(towrite, "Exec=");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);

  strcpy(towrite, options->DefaultInstallPath);
  if(options->
     DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
    _strncat(towrite, "/", 2048);
  _strncat(towrite, ExecBinary, 2048);
  _strncat(towrite, " \%f", 2048);
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  strcpy(towrite, "Name=");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);

  strcpy(towrite, ProgramName);
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  strcpy(towrite, "Path=");
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);

  strcpy(towrite, options->DefaultInstallPath);
#ifdef _SHOW_
  printf("kdeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, KDELNKfile);
  err = fputc(EOL, KDELNKfile);

  if(err < 0) return(2);

  // Add custom extensions out of an
  // extension file from the installed distribution

  if(strlen(KDELNKAdditions) > 0)
    {
      extensionfilename = towrite;
      strcpy(extensionfilename, options->DefaultInstallPath);
      if(options->
        DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
      _strncat(extensionfilename, "/", 2048);
      _strncat(extensionfilename, KDELNKAdditions, 2048);

#ifdef _DEBUG_
      printf("kdeconfig: Adding %s\n", extensionfilename);
#endif

      extensionfile = fopen(extensionfilename, "r");

      if(extensionfile == NULL) return(5);

      while(!feof(extensionfile))
        {
          copy = fgetc(extensionfile);
          err = fputc(copy, KDELNKfile);
        }

      if(extensionfile != NULL) fclose(extensionfile);

      if(err < 1) return(2);
    }

  return(1);
}

void tKDEConfig::CloseKDELNK()
{
  if (!(KDELNKfile == NULL)) fclose(KDELNKfile);

  KDELNKfile = NULL;
}

void tKDEConfig::RestartPanel() // obsolete, as kicker watches the dirs
{
  /*
  char String[1024];

  strcpy(String, "/bin/sh -c \"kwmcom kpanel:restart\"");
  system(String);
  */
}

