/***************************************************************************
    File                 : ExportSpreadsheetDialog.h
    Project              : LabPlot
    Description          : export spreadsheet dialog
    --------------------------------------------------------------------
    Copyright            : (C) 2014 by Alexander Semke (alexander.semke@web.de)

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor,                    *
 *   Boston, MA  02110-1301  USA                                           *
 *                                                                         *
 ***************************************************************************/

#ifndef EXPORTSPREADSHEETDIALOG_H
#define EXPORTSPREADSHEETDIALOG_H

#include <KDialog>
#include "ui_exportspreadsheetwidget.h"
#include "commonfrontend/spreadsheet/SpreadsheetView.h"

class ExportSpreadsheetDialog: public KDialog{
  Q_OBJECT

  public:
	explicit ExportSpreadsheetDialog(QWidget*);
	QString path() const;
	void setFileName(const QString&);
	bool exportHeader() const;
	QString separator() const;

  private:
	QWidget* mainWidget;
	Ui::ExportSpreadsheetWidget ui;

  private slots:
	void slotButtonClicked(int);
	void okClicked();
	void toggleOptions();
	void selectFile();
	void formatChanged(int);
	void fileNameChanged(const QString&);
};

#endif
