/* MediaViewTracker.c generated by valac 0.36.6, the Vala compiler
 * generated from MediaViewTracker.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define CORE_TYPE_TRACKER (core_tracker_get_type ())
#define CORE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER, CoreTracker))
#define CORE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_TRACKER, CoreTrackerClass))
#define CORE_IS_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER))
#define CORE_IS_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_TRACKER))
#define CORE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_TRACKER, CoreTrackerClass))

typedef struct _CoreTracker CoreTracker;
typedef struct _CoreTrackerClass CoreTrackerClass;
typedef struct _CoreTrackerPrivate CoreTrackerPrivate;

#define CORE_TYPE_VIEW_TRACKER (core_view_tracker_get_type ())
#define CORE_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTracker))
#define CORE_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))
#define CORE_IS_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_VIEW_TRACKER))
#define CORE_IS_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_VIEW_TRACKER))
#define CORE_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))

typedef struct _CoreViewTracker CoreViewTracker;
typedef struct _CoreViewTrackerClass CoreViewTrackerClass;
typedef struct _CoreViewTrackerPrivate CoreViewTrackerPrivate;

#define TYPE_MEDIA_VIEW_TRACKER (media_view_tracker_get_type ())
#define MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker))
#define MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))
#define IS_MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIEW_TRACKER))
#define IS_MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIEW_TRACKER))
#define MEDIA_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))

typedef struct _MediaViewTracker MediaViewTracker;
typedef struct _MediaViewTrackerClass MediaViewTrackerClass;
typedef struct _MediaViewTrackerPrivate MediaViewTrackerPrivate;

#define TYPE_MEDIA_ACCUMULATOR (media_accumulator_get_type ())
#define MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulator))
#define MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))
#define IS_MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ACCUMULATOR))
#define IS_MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_ACCUMULATOR))
#define MEDIA_ACCUMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))

typedef struct _MediaAccumulator MediaAccumulator;
typedef struct _MediaAccumulatorClass MediaAccumulatorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CORE_TYPE_TRACKER_ACCUMULATOR (core_tracker_accumulator_get_type ())
#define CORE_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator))
#define CORE_IS_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR))
#define CORE_TRACKER_ACCUMULATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulatorIface))

typedef struct _CoreTrackerAccumulator CoreTrackerAccumulator;
typedef struct _CoreTrackerAccumulatorIface CoreTrackerAccumulatorIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _MediaAccumulatorPrivate MediaAccumulatorPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CoreTracker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CoreTrackerPrivate * priv;
};

struct _CoreTrackerClass {
	GTypeClass parent_class;
	void (*finalize) (CoreTracker *self);
	void (*updated) (CoreTracker* self);
};

struct _CoreViewTracker {
	CoreTracker parent_instance;
	CoreViewTrackerPrivate * priv;
};

struct _CoreViewTrackerClass {
	CoreTrackerClass parent_class;
};

struct _MediaViewTracker {
	CoreViewTracker parent_instance;
	MediaViewTrackerPrivate * priv;
	MediaAccumulator* all;
	MediaAccumulator* visible;
	MediaAccumulator* selected;
};

struct _MediaViewTrackerClass {
	CoreViewTrackerClass parent_class;
};

struct _CoreTrackerAccumulatorIface {
	GTypeInterface parent_iface;
	gboolean (*include) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*uninclude) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*altered) (CoreTrackerAccumulator* self, DataObject* object, Alteration* alteration);
};

struct _MediaAccumulator {
	GObject parent_instance;
	MediaAccumulatorPrivate * priv;
	gint total;
	gint photos;
	gint videos;
	gint raw;
	gint flagged;
};

struct _MediaAccumulatorClass {
	GObjectClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};


static gpointer media_view_tracker_parent_class = NULL;
static gpointer media_accumulator_parent_class = NULL;
static CoreTrackerAccumulatorIface * media_accumulator_core_tracker_accumulator_parent_iface = NULL;

gpointer core_tracker_ref (gpointer instance);
void core_tracker_unref (gpointer instance);
GParamSpec* core_param_spec_tracker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void core_value_set_tracker (GValue* value, gpointer v_object);
void core_value_take_tracker (GValue* value, gpointer v_object);
gpointer core_value_get_tracker (const GValue* value);
GType core_tracker_get_type (void) G_GNUC_CONST;
GType core_view_tracker_get_type (void) G_GNUC_CONST;
GType media_view_tracker_get_type (void) G_GNUC_CONST;
GType media_accumulator_get_type (void) G_GNUC_CONST;
enum  {
	MEDIA_VIEW_TRACKER_DUMMY_PROPERTY
};
MediaAccumulator* media_accumulator_new (void);
MediaAccumulator* media_accumulator_construct (GType object_type);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
MediaViewTracker* media_view_tracker_new (ViewCollection* collection);
MediaViewTracker* media_view_tracker_construct (GType object_type, ViewCollection* collection);
CoreViewTracker* core_view_tracker_new (ViewCollection* collection);
CoreViewTracker* core_view_tracker_construct (GType object_type, ViewCollection* collection);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType core_tracker_accumulator_get_type (void) G_GNUC_CONST;
void core_view_tracker_start (CoreViewTracker* self, CoreTrackerAccumulator* all, CoreTrackerAccumulator* visible, CoreTrackerAccumulator* selected);
static void media_view_tracker_finalize (CoreTracker * obj);
enum  {
	MEDIA_ACCUMULATOR_DUMMY_PROPERTY
};
static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base, DataObject* object);
GType data_source_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
DataSource* data_view_get_source (DataView* self);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base, DataObject* object);
gchar* data_object_to_string (DataObject* self);
gchar* media_accumulator_to_string (MediaAccumulator* self);
GType video_get_type (void) G_GNUC_CONST;
static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base, DataObject* object, Alteration* alteration);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
static void media_accumulator_finalize (GObject * obj);


MediaViewTracker* media_view_tracker_construct (GType object_type, ViewCollection* collection) {
	MediaViewTracker* self = NULL;
	ViewCollection* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
	MediaAccumulator* _tmp3_;
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (collection), NULL);
#line 13 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = collection;
#line 13 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = (MediaViewTracker*) core_view_tracker_construct (object_type, _tmp0_);
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = self->all;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->visible;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = self->selected;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	core_view_tracker_start (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_VIEW_TRACKER, CoreViewTracker), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator));
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self;
#line 365 "MediaViewTracker.c"
}


MediaViewTracker* media_view_tracker_new (ViewCollection* collection) {
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return media_view_tracker_construct (TYPE_MEDIA_VIEW_TRACKER, collection);
#line 372 "MediaViewTracker.c"
}


static void media_view_tracker_class_init (MediaViewTrackerClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_view_tracker_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	((CoreTrackerClass *) klass)->finalize = media_view_tracker_finalize;
#line 381 "MediaViewTracker.c"
}


static void media_view_tracker_instance_init (MediaViewTracker * self) {
	MediaAccumulator* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = media_accumulator_new ();
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->all = _tmp0_;
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = media_accumulator_new ();
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->visible = _tmp1_;
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = media_accumulator_new ();
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->selected = _tmp2_;
#line 401 "MediaViewTracker.c"
}


static void media_view_tracker_finalize (CoreTracker * obj) {
	MediaViewTracker * self;
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker);
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->all);
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->visible);
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->selected);
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	CORE_TRACKER_CLASS (media_view_tracker_parent_class)->finalize (obj);
#line 417 "MediaViewTracker.c"
}


GType media_view_tracker_get_type (void) {
	static volatile gsize media_view_tracker_type_id__volatile = 0;
	if (g_once_init_enter (&media_view_tracker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaViewTracker), 0, (GInstanceInitFunc) media_view_tracker_instance_init, NULL };
		GType media_view_tracker_type_id;
		media_view_tracker_type_id = g_type_register_static (CORE_TYPE_VIEW_TRACKER, "MediaViewTracker", &g_define_type_info, 0);
		g_once_init_leave (&media_view_tracker_type_id__volatile, media_view_tracker_type_id);
	}
	return media_view_tracker_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self ? g_object_ref (self) : NULL;
#line 436 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base, DataObject* object) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_;
	DataSource* _tmp1_;
	gint _tmp2_;
	Photo* photo = NULL;
	DataSource* _tmp3_;
	Photo* _tmp4_;
	Photo* _tmp5_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp14_;
	Flaggable* _tmp15_;
	gboolean _tmp16_ = FALSE;
	Flaggable* _tmp17_;
#line 26 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 26 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = object;
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	source = _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->total;
#line 29 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = _tmp2_ + 1;
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = source;
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_PHOTO) ? ((Photo*) _tmp3_) : NULL);
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	photo = _tmp4_;
#line 32 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp5_ = photo;
#line 32 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp5_ != NULL) {
#line 480 "MediaViewTracker.c"
		Photo* _tmp6_;
		PhotoFileFormat _tmp7_;
		Photo* _tmp9_;
		PhotoFileFormat _tmp10_;
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp6_ = photo;
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp7_ = photo_get_master_file_format (_tmp6_);
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp7_ == PHOTO_FILE_FORMAT_RAW) {
#line 491 "MediaViewTracker.c"
			gint _tmp8_;
#line 34 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp8_ = self->raw;
#line 34 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->raw = _tmp8_ + 1;
#line 497 "MediaViewTracker.c"
		}
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp9_ = photo;
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = photo_get_master_file_format (_tmp9_);
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp10_ != PHOTO_FILE_FORMAT_RAW) {
#line 505 "MediaViewTracker.c"
			gint _tmp11_;
#line 38 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp11_ = self->photos;
#line 38 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->photos = _tmp11_ + 1;
#line 511 "MediaViewTracker.c"
		}
	} else {
		DataSource* _tmp12_;
#line 40 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp12_ = source;
#line 40 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_VIDEO_SOURCE)) {
#line 519 "MediaViewTracker.c"
			gint _tmp13_;
#line 41 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp13_ = self->videos;
#line 41 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->videos = _tmp13_ + 1;
#line 525 "MediaViewTracker.c"
		}
	}
#line 44 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp14_ = source;
#line 44 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp14_) : NULL);
#line 44 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp15_;
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp17_ = flaggable;
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp17_ != NULL) {
#line 538 "MediaViewTracker.c"
		Flaggable* _tmp18_;
		gboolean _tmp19_;
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp18_ = flaggable;
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp19_ = flaggable_is_flagged (_tmp18_);
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp16_ = _tmp19_;
#line 547 "MediaViewTracker.c"
	} else {
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp16_ = FALSE;
#line 551 "MediaViewTracker.c"
	}
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp16_) {
#line 555 "MediaViewTracker.c"
		gint _tmp20_;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp20_ = self->flagged;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp20_ + 1;
#line 561 "MediaViewTracker.c"
	}
#line 49 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 49 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 49 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (photo);
#line 49 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (source);
#line 49 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 573 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base, DataObject* object) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_;
	DataSource* _tmp1_;
	gint _tmp2_;
	gint _tmp12_;
	Photo* photo = NULL;
	DataSource* _tmp13_;
	Photo* _tmp14_;
	Photo* _tmp15_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp27_;
	Flaggable* _tmp28_;
	gboolean _tmp29_ = FALSE;
	Flaggable* _tmp30_;
#line 52 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 52 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 53 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = object;
#line 53 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 53 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	source = _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->total;
#line 55 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp2_ < 1) {
#line 608 "MediaViewTracker.c"
		DataObject* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GType _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp3_ = object;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp4_ = data_object_to_string (_tmp3_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp5_ = _tmp4_;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp6_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp7_ = g_type_name (_tmp6_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp8_ = media_accumulator_to_string (self);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp9_ = _tmp8_;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = g_strdup_printf ("Tried to remove DataObject %s from empty %s (%s)", _tmp5_, _tmp7_, _tmp9_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp11_ = _tmp10_;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		g_warning ("MediaViewTracker.vala:56: %s", _tmp11_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp11_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp9_);
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp5_);
#line 58 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 58 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (source);
#line 58 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 650 "MediaViewTracker.c"
	}
#line 60 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp12_ = self->total;
#line 60 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = _tmp12_ - 1;
#line 62 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp13_ = source;
#line 62 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_PHOTO) ? ((Photo*) _tmp13_) : NULL);
#line 62 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	photo = _tmp14_;
#line 63 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp15_ = photo;
#line 63 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp15_ != NULL) {
#line 666 "MediaViewTracker.c"
		Photo* _tmp16_;
		PhotoFileFormat _tmp17_;
		Photo* _tmp20_;
		PhotoFileFormat _tmp21_;
#line 64 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp16_ = photo;
#line 64 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp17_ = photo_get_master_file_format (_tmp16_);
#line 64 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp17_ == PHOTO_FILE_FORMAT_RAW) {
#line 677 "MediaViewTracker.c"
			gint _tmp18_;
			gint _tmp19_;
#line 65 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp18_ = self->raw;
#line 65 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp18_ > 0, "raw > 0");
#line 66 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp19_ = self->raw;
#line 66 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->raw = _tmp19_ - 1;
#line 688 "MediaViewTracker.c"
		}
#line 69 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp20_ = photo;
#line 69 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp21_ = photo_get_master_file_format (_tmp20_);
#line 69 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp21_ != PHOTO_FILE_FORMAT_RAW) {
#line 696 "MediaViewTracker.c"
			gint _tmp22_;
			gint _tmp23_;
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp22_ = self->photos;
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp22_ > 0, "photos > 0");
#line 71 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp23_ = self->photos;
#line 71 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->photos = _tmp23_ - 1;
#line 707 "MediaViewTracker.c"
		}
	} else {
		DataSource* _tmp24_;
#line 73 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp24_ = source;
#line 73 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, TYPE_VIDEO)) {
#line 715 "MediaViewTracker.c"
			gint _tmp25_;
			gint _tmp26_;
#line 74 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp25_ = self->videos;
#line 74 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp25_ > 0, "videos > 0");
#line 75 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp26_ = self->videos;
#line 75 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->videos = _tmp26_ - 1;
#line 726 "MediaViewTracker.c"
		}
	}
#line 78 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp27_ = source;
#line 78 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp27_) : NULL);
#line 78 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp28_;
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp30_ = flaggable;
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp30_ != NULL) {
#line 739 "MediaViewTracker.c"
		Flaggable* _tmp31_;
		gboolean _tmp32_;
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp31_ = flaggable;
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp32_ = flaggable_is_flagged (_tmp31_);
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp29_ = _tmp32_;
#line 748 "MediaViewTracker.c"
	} else {
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp29_ = FALSE;
#line 752 "MediaViewTracker.c"
	}
#line 79 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp29_) {
#line 756 "MediaViewTracker.c"
		gint _tmp33_;
		gint _tmp34_;
#line 80 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp33_ = self->flagged;
#line 80 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_vala_assert (_tmp33_ > 0, "flagged > 0");
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp34_ = self->flagged;
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp34_ - 1;
#line 767 "MediaViewTracker.c"
	}
#line 85 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 85 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 85 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (photo);
#line 85 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (source);
#line 85 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 779 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base, DataObject* object, Alteration* alteration) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	Alteration* _tmp0_;
	gboolean _tmp1_;
	Flaggable* flaggable = NULL;
	DataObject* _tmp2_;
	DataSource* _tmp3_;
	Flaggable* _tmp4_;
	Flaggable* _tmp5_;
	Flaggable* _tmp6_;
	gboolean _tmp7_;
#line 88 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 88 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 88 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 91 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = alteration;
#line 91 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "flagged");
#line 91 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (!_tmp1_) {
#line 92 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 92 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 811 "MediaViewTracker.c"
	}
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = object;
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView));
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp3_) : NULL;
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp4_ == NULL) {
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (_tmp3_);
#line 823 "MediaViewTracker.c"
	}
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp4_;
#line 95 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp5_ = flaggable;
#line 95 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp5_ == NULL) {
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (flaggable);
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 837 "MediaViewTracker.c"
	}
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp6_ = flaggable;
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp7_ = flaggable_is_flagged (_tmp6_);
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp7_) {
#line 845 "MediaViewTracker.c"
		gint _tmp8_;
#line 99 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp8_ = self->flagged;
#line 99 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp8_ + 1;
#line 851 "MediaViewTracker.c"
	} else {
		gint _tmp9_;
		gint _tmp10_;
#line 101 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp9_ = self->flagged;
#line 101 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_vala_assert (_tmp9_ > 0, "flagged > 0");
#line 102 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = self->flagged;
#line 102 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp10_ - 1;
#line 863 "MediaViewTracker.c"
	}
#line 105 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 105 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 105 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 871 "MediaViewTracker.c"
}


gchar* media_accumulator_to_string (MediaAccumulator* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
#line 108 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_MEDIA_ACCUMULATOR (self), NULL);
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = self->photos;
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = self->videos;
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->raw;
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = self->flagged;
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = g_strdup_printf ("%d photos/%d videos/%d raw/%d flagged", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = _tmp4_;
#line 109 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 898 "MediaViewTracker.c"
}


MediaAccumulator* media_accumulator_construct (GType object_type) {
	MediaAccumulator * self = NULL;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = (MediaAccumulator*) g_object_new (object_type, NULL);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self;
#line 908 "MediaViewTracker.c"
}


MediaAccumulator* media_accumulator_new (void) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return media_accumulator_construct (TYPE_MEDIA_ACCUMULATOR);
#line 915 "MediaViewTracker.c"
}


static void media_accumulator_class_init (MediaAccumulatorClass * klass) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_accumulator_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	G_OBJECT_CLASS (klass)->finalize = media_accumulator_finalize;
#line 924 "MediaViewTracker.c"
}


static void media_accumulator_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_accumulator_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->include = (gboolean (*) (CoreTrackerAccumulator *, DataObject*)) media_accumulator_real_include;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->uninclude = (gboolean (*) (CoreTrackerAccumulator *, DataObject*)) media_accumulator_real_uninclude;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->altered = (gboolean (*) (CoreTrackerAccumulator *, DataObject*, Alteration*)) media_accumulator_real_altered;
#line 937 "MediaViewTracker.c"
}


static void media_accumulator_instance_init (MediaAccumulator * self) {
#line 20 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = 0;
#line 21 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->photos = 0;
#line 22 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->videos = 0;
#line 23 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->raw = 0;
#line 24 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->flagged = 0;
#line 952 "MediaViewTracker.c"
}


static void media_accumulator_finalize (GObject * obj) {
	MediaAccumulator * self;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	G_OBJECT_CLASS (media_accumulator_parent_class)->finalize (obj);
#line 962 "MediaViewTracker.c"
}


GType media_accumulator_get_type (void) {
	static volatile gsize media_accumulator_type_id__volatile = 0;
	if (g_once_init_enter (&media_accumulator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaAccumulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_accumulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaAccumulator), 0, (GInstanceInitFunc) media_accumulator_instance_init, NULL };
		static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) media_accumulator_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType media_accumulator_type_id;
		media_accumulator_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaAccumulator", &g_define_type_info, 0);
		g_type_add_interface_static (media_accumulator_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
		g_once_init_leave (&media_accumulator_type_id__volatile, media_accumulator_type_id);
	}
	return media_accumulator_type_id__volatile;
}



