/* Resources.c generated by valac 0.36.6, the Vala compiler
 * generated from Resources.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* defined by ./configure or Makefile and included by gcc -D*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <locale.h>
#include <langinfo.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RATING (rating_get_type ())

#define TYPE_RATING_FILTER (rating_filter_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	RATING_FILTER_NO_FILTER = 0,
	RATING_FILTER_REJECTED_OR_HIGHER = 1,
	RATING_FILTER_UNRATED_OR_HIGHER = 2,
	RATING_FILTER_ONE_OR_HIGHER = 3,
	RATING_FILTER_TWO_OR_HIGHER = 4,
	RATING_FILTER_THREE_OR_HIGHER = 5,
	RATING_FILTER_FOUR_OR_HIGHER = 6,
	RATING_FILTER_FIVE_OR_HIGHER = 7,
	RATING_FILTER_REJECTED_ONLY = 8,
	RATING_FILTER_UNRATED_ONLY = 9,
	RATING_FILTER_ONE_ONLY = 10,
	RATING_FILTER_TWO_ONLY = 11,
	RATING_FILTER_THREE_ONLY = 12,
	RATING_FILTER_FOUR_ONLY = 13,
	RATING_FILTER_FIVE_ONLY = 14
} RatingFilter;

typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;


extern gchar* resources_RATE_ONE_LABEL;
extern gchar* resources_RATE_TWO_LABEL;
extern gchar* resources_RATE_THREE_LABEL;
extern gchar* resources_RATE_FOUR_LABEL;
extern gchar* resources_RATE_FIVE_LABEL;
extern gchar* resources_RATE_ONE_MENU;
extern gchar* resources_RATE_TWO_MENU;
extern gchar* resources_RATE_THREE_MENU;
extern gchar* resources_RATE_FOUR_MENU;
extern gchar* resources_RATE_FIVE_MENU;
extern gchar* resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
extern gchar* resources_RATE_ONE_PROGRESS;
extern gchar* resources_RATE_TWO_PROGRESS;
extern gchar* resources_RATE_THREE_PROGRESS;
extern gchar* resources_RATE_FOUR_PROGRESS;
extern gchar* resources_RATE_FIVE_PROGRESS;
extern gchar* resources_RATE_ONE_TOOLTIP;
extern gchar* resources_RATE_TWO_TOOLTIP;
extern gchar* resources_RATE_THREE_TOOLTIP;
extern gchar* resources_RATE_FOUR_TOOLTIP;
extern gchar* resources_RATE_FIVE_TOOLTIP;
extern gchar* resources_DISPLAY_ONE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_TWO_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_THREE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_FOUR_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_FIVE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_ONE_OR_HIGHER_LABEL;
extern gchar* resources_DISPLAY_TWO_OR_HIGHER_LABEL;
extern gchar* resources_DISPLAY_THREE_OR_HIGHER_LABEL;
extern gchar* resources_DISPLAY_FOUR_OR_HIGHER_LABEL;
extern gchar* resources_DISPLAY_FIVE_OR_HIGHER_LABEL;
gchar* resources_RATE_ONE_MENU = NULL;
gchar* resources_RATE_ONE_LABEL = NULL;
gchar* resources_RATE_ONE_TOOLTIP = NULL;
gchar* resources_RATE_ONE_PROGRESS = NULL;
gchar* resources_RATE_TWO_MENU = NULL;
gchar* resources_RATE_TWO_LABEL = NULL;
gchar* resources_RATE_TWO_TOOLTIP = NULL;
gchar* resources_RATE_TWO_PROGRESS = NULL;
gchar* resources_RATE_THREE_MENU = NULL;
gchar* resources_RATE_THREE_LABEL = NULL;
gchar* resources_RATE_THREE_TOOLTIP = NULL;
gchar* resources_RATE_THREE_PROGRESS = NULL;
gchar* resources_RATE_FOUR_MENU = NULL;
gchar* resources_RATE_FOUR_LABEL = NULL;
gchar* resources_RATE_FOUR_TOOLTIP = NULL;
gchar* resources_RATE_FOUR_PROGRESS = NULL;
gchar* resources_RATE_FIVE_MENU = NULL;
gchar* resources_RATE_FIVE_LABEL = NULL;
gchar* resources_RATE_FIVE_TOOLTIP = NULL;
gchar* resources_RATE_FIVE_PROGRESS = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_MENU = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_LABEL = NULL;
gchar* resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP = NULL;
extern GeeHashMap* resources_icon_cache;
GeeHashMap* resources_icon_cache = NULL;
extern GeeHashMap* resources_scaled_icon_cache;
GeeHashMap* resources_scaled_icon_cache = NULL;
extern gchar* resources_HH_MM_FORMAT_STRING;
gchar* resources_HH_MM_FORMAT_STRING = NULL;
extern gchar* resources_HH_MM_SS_FORMAT_STRING;
gchar* resources_HH_MM_SS_FORMAT_STRING = NULL;
extern gchar* resources_LONG_DATE_FORMAT_STRING;
gchar* resources_LONG_DATE_FORMAT_STRING = NULL;
extern gchar* resources_START_MULTIDAY_DATE_FORMAT_STRING;
gchar* resources_START_MULTIDAY_DATE_FORMAT_STRING = NULL;
extern gchar* resources_END_MULTIDAY_DATE_FORMAT_STRING;
gchar* resources_END_MULTIDAY_DATE_FORMAT_STRING = NULL;
extern gchar* resources_START_MULTIMONTH_DATE_FORMAT_STRING;
gchar* resources_START_MULTIMONTH_DATE_FORMAT_STRING = NULL;
extern gchar* resources_END_MULTIMONTH_DATE_FORMAT_STRING;
gchar* resources_END_MULTIMONTH_DATE_FORMAT_STRING = NULL;
extern gchar* resources_lc_measurement;
gchar* resources_lc_measurement = NULL;
extern ResourcesUnitSystem resources_unit_system;
ResourcesUnitSystem resources_unit_system = RESOURCES_UNIT_SYSTEM_UNKNOWN;
extern GdkPixbuf* resources_noninterpretable_badge_pixbuf;
GdkPixbuf* resources_noninterpretable_badge_pixbuf = NULL;
extern GeeMap* resources_providers;
GeeMap* resources_providers = NULL;

#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_LIBRARY_ROLE _ ("Photo Manager")
#define RESOURCES_APP_DIRECT_ROLE _ ("Photo Viewer")
#define RESOURCES_APP_VERSION _VERSION
#define RESOURCES_GIT_VERSION _GIT_VERSION
#define RESOURCES_COPYRIGHT _ ("Copyright 2016 Software Freedom Conservancy Inc.")
#define RESOURCES_APP_GETTEXT_PACKAGE GETTEXT_PACKAGE
#define RESOURCES_HOME_URL "https://wiki.gnome.org/Apps/Shotwell"
#define RESOURCES_FAQ_URL "https://wiki.gnome.org/Apps/Shotwell/FAQ"
#define RESOURCES_BUG_DB_URL "https://wiki.gnome.org/Apps/Shotwell/ReportingABug"
#define RESOURCES_DIR_PATTERN_URI_SYSWIDE "help:shotwell/other-files"
#define RESOURCES_LIB _LIB
#define RESOURCES_LIBEXECDIR _LIBEXECDIR
#define RESOURCES_PREFIX _PREFIX
#define RESOURCES_TRANSIENT_WINDOW_OPACITY 0.90
#define RESOURCES_DEFAULT_ICON_SCALE 24
#define RESOURCES_LICENSE "\n" \
"Shotwell is free software; you can redistribute it and/or modify it un" \
"der the \n" \
"terms of the GNU Lesser General Public License as published by the Fre" \
"e \n" \
"Software Foundation; either version 2.1 of the License, or (at your op" \
"tion) \n" \
"any later version.\n" \
"\n" \
"Shotwell is distributed in the hope that it will be useful, but WITHOU" \
"T \n" \
"ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or " \
"FITNESS\n" \
"FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License f" \
"or \n" \
"more details.\n" \
"\n" \
"You should have received a copy of the GNU Lesser General Public Licen" \
"se \n" \
"along with Shotwell; if not, write to the Free Software Foundation, In" \
"c., \n" \
"51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA\n"
#define RESOURCES_CLOCKWISE "object-rotate-right"
#define RESOURCES_COUNTERCLOCKWISE "object-rotate-left"
#define RESOURCES_HFLIP "object-flip-horizontal"
#define RESOURCES_VFLIP "object-flip-vertical"
#define RESOURCES_CROP "shotwell-crop"
#define RESOURCES_STRAIGHTEN "shotwell-straighten"
#define RESOURCES_REDEYE "shotwell-redeye"
#define RESOURCES_ADJUST "image-adjust"
#define RESOURCES_PIN_TOOLBAR "shotwell-pin-toolbar"
#define RESOURCES_MAKE_PRIMARY "shotwell-make-primary"
#define RESOURCES_IMPORT "import"
#define RESOURCES_IMPORT_ALL "import-all"
#define RESOURCES_ENHANCE "shotwell-auto-enhance"
#define RESOURCES_CROP_PIVOT_RETICLE "shotwell-crop-pivot-reticle"
#define RESOURCES_PUBLISH "applications-internet"
#define RESOURCES_MERGE "shotwell-merge-events"
#define RESOURCES_GO_NEXT "go-next"
#define RESOURCES_GO_PREVIOUS "go-previous"
#define RESOURCES_ICON_ABOUT_LOGO "about-aachen.jpg"
#define RESOURCES_ICON_GENERIC_PLUGIN "generic-plugin.png"
#define RESOURCES_ICON_SLIDESHOW_EXTENSION_POINT "slideshow-extension-point"
#define RESOURCES_ICON_RATING_REJECTED "rejected.svg"
#define RESOURCES_ICON_RATING_ONE "one-star.svg"
#define RESOURCES_ICON_RATING_TWO "two-stars.svg"
#define RESOURCES_ICON_RATING_THREE "three-stars.svg"
#define RESOURCES_ICON_RATING_FOUR "four-stars.svg"
#define RESOURCES_ICON_RATING_FIVE "five-stars.svg"
#define RESOURCES_ICON_FILTER_REJECTED_OR_BETTER "all-rejected.png"
#define RESOURCES_ICON_FILTER_REJECTED_OR_BETTER_FIXED_SIZE 32
#define RESOURCES_ICON_FILTER_UNRATED_OR_BETTER "shotwell-16.png"
#define RESOURCES_ICON_FILTER_UNRATED_OR_BETTER_FIXED_SIZE 16
#define RESOURCES_ICON_FILTER_ONE_OR_BETTER "one-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_TWO_OR_BETTER "two-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_THREE_OR_BETTER "three-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_FOUR_OR_BETTER "four-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_FIVE "five-star-filter.svg"
#define RESOURCES_ICON_ZOOM_IN "zoom-in.png"
#define RESOURCES_ICON_ZOOM_OUT "zoom-out.png"
#define RESOURCES_ICON_ZOOM_SCALE 16
#define RESOURCES_ICON_CAMERAS "camera-photo"
#define RESOURCES_ICON_EVENTS "multiple-events"
#define RESOURCES_ICON_ONE_EVENT "one-event"
#define RESOURCES_ICON_NO_EVENT "no-event"
#define RESOURCES_ICON_ONE_TAG "one-tag"
#define RESOURCES_ICON_TAGS "multiple-tags"
#define RESOURCES_ICON_FOLDER "folder"
#define RESOURCES_ICON_FOLDER_DOCUMENTS "folder-documents"
#define RESOURCES_ICON_IMPORTING "go-down"
#define RESOURCES_ICON_LAST_IMPORT "document-open-recent"
#define RESOURCES_ICON_MISSING_FILES "process-stop"
#define RESOURCES_ICON_PHOTOS "shotwell"
#define RESOURCES_ICON_SINGLE_PHOTO "image-x-generic"
#define RESOURCES_ICON_FILTER_PHOTOS "filter-photos"
#define RESOURCES_ICON_FILTER_PHOTOS_DISABLED "filter-photos-disabled"
#define RESOURCES_ICON_FILTER_VIDEOS "filter-videos"
#define RESOURCES_ICON_FILTER_VIDEOS_DISABLED "filter-videos-disabled"
#define RESOURCES_ICON_FILTER_RAW "filter-raw"
#define RESOURCES_ICON_FILTER_RAW_DISABLED "filter-raw-disabled"
#define RESOURCES_ICON_FILTER_FLAGGED "filter-flagged"
#define RESOURCES_ICON_FILTER_FLAGGED_DISABLED "filter-flagged-disabled"
#define RESOURCES_ICON_TRASH_EMPTY "user-trash"
#define RESOURCES_ICON_TRASH_FULL "user-trash-full"
#define RESOURCES_ICON_VIDEOS_PAGE "videos-page"
#define RESOURCES_ICON_FLAGGED_PAGE "flag-page"
#define RESOURCES_ICON_FLAGGED_TRINKET "flag-trinket.png"
#define RESOURCES_ROTATE_CW_MENU _ ("Rotate _Right")
#define RESOURCES_ROTATE_CW_LABEL _ ("Rotate")
#define RESOURCES_ROTATE_CW_FULL_LABEL _ ("Rotate Right")
#define RESOURCES_ROTATE_CW_TOOLTIP _ ("Rotate the photos right (press Ctrl to rotate left)")
#define RESOURCES_ROTATE_CCW_MENU _ ("Rotate _Left")
#define RESOURCES_ROTATE_CCW_LABEL _ ("Rotate")
#define RESOURCES_ROTATE_CCW_FULL_LABEL _ ("Rotate Left")
#define RESOURCES_ROTATE_CCW_TOOLTIP _ ("Rotate the photos left")
#define RESOURCES_HFLIP_MENU _ ("Flip Hori_zontally")
#define RESOURCES_HFLIP_LABEL _ ("Flip Horizontally")
#define RESOURCES_VFLIP_MENU _ ("Flip Verti_cally")
#define RESOURCES_VFLIP_LABEL _ ("Flip Vertically")
#define RESOURCES_ABOUT_LABEL _ ("_About")
#define RESOURCES_APPLY_LABEL _ ("_Apply")
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_DELETE_LABEL _ ("_Delete")
#define RESOURCES_EDIT_LABEL _ ("_Edit")
#define RESOURCES_FORWARD_LABEL _ ("_Forward")
#define RESOURCES_FULLSCREEN_LABEL _ ("Fulls_creen")
#define RESOURCES_HELP_LABEL _ ("_Help")
#define RESOURCES_LEAVE_FULLSCREEN_LABEL _ ("Leave _Fullscreen")
#define RESOURCES_NEW_LABEL _ ("_New")
#define RESOURCES_NEXT_LABEL _ ("_Next")
#define RESOURCES_OK_LABEL _ ("_OK")
#define RESOURCES_PLAY_LABEL _ ("_Play")
#define RESOURCES_PREFERENCES_LABEL _ ("_Preferences")
#define RESOURCES_PREVIOUS_LABEL _ ("_Previous")
#define RESOURCES_PRINT_LABEL _ ("_Print")
#define RESOURCES_QUIT_LABEL _ ("_Quit")
#define RESOURCES_REFRESH_LABEL _ ("_Refresh")
#define RESOURCES_REMOVE_LABEL _ ("_Remove")
#define RESOURCES_REVERT_TO_SAVED_LABEL _ ("_Revert")
#define RESOURCES_SAVE_LABEL _ ("_Save")
#define RESOURCES_SAVE_AS_LABEL _ ("Save _As")
#define RESOURCES_SORT_ASCENDING_LABEL _ ("Sort _Ascending")
#define RESOURCES_SORT_DESCENDING_LABEL _ ("Sort _Descending")
#define RESOURCES_STOP_LABEL _ ("_Stop")
#define RESOURCES_UNDELETE_LABEL _ ("_Undelete")
#define RESOURCES_ZOOM_100_LABEL _ ("_Normal Size")
#define RESOURCES_ZOOM_FIT_LABEL _ ("Best _Fit")
#define RESOURCES_ZOOM_IN_LABEL _ ("Zoom _In")
#define RESOURCES_ZOOM_OUT_LABEL _ ("Zoom _Out")
#define RESOURCES_ENHANCE_MENU _ ("_Enhance")
#define RESOURCES_ENHANCE_LABEL _ ("Enhance")
#define RESOURCES_ENHANCE_TOOLTIP _ ("Automatically improve the photo’s appearance")
#define RESOURCES_COPY_ADJUSTMENTS_MENU _ ("_Copy Color Adjustments")
#define RESOURCES_COPY_ADJUSTMENTS_LABEL _ ("Copy Color Adjustments")
#define RESOURCES_COPY_ADJUSTMENTS_TOOLTIP _ ("Copy the color adjustments applied to the photo")
#define RESOURCES_PASTE_ADJUSTMENTS_MENU _ ("_Paste Color Adjustments")
#define RESOURCES_PASTE_ADJUSTMENTS_LABEL _ ("Paste Color Adjustments")
#define RESOURCES_PASTE_ADJUSTMENTS_TOOLTIP _ ("Apply copied color adjustments to the selected photos")
#define RESOURCES_CROP_MENU _ ("_Crop")
#define RESOURCES_CROP_LABEL _ ("Crop")
#define RESOURCES_CROP_TOOLTIP _ ("Crop the photo’s size")
#define RESOURCES_STRAIGHTEN_MENU _ ("_Straighten")
#define RESOURCES_STRAIGHTEN_LABEL _ ("Straighten")
#define RESOURCES_STRAIGHTEN_TOOLTIP _ ("Straighten the photo")
#define RESOURCES_RED_EYE_MENU _ ("_Red-eye")
#define RESOURCES_RED_EYE_LABEL _ ("Red-eye")
#define RESOURCES_RED_EYE_TOOLTIP _ ("Reduce or eliminate any red-eye effects in the photo")
#define RESOURCES_ADJUST_MENU _ ("_Adjust")
#define RESOURCES_ADJUST_LABEL _ ("Adjust")
#define RESOURCES_ADJUST_TOOLTIP _ ("Adjust the photo’s color and tone")
#define RESOURCES_REVERT_MENU _ ("Re_vert to Original")
#define RESOURCES_REVERT_LABEL _ ("Revert to Original")
#define RESOURCES_REVERT_EDITABLE_MENU _ ("Revert External E_dits")
#define RESOURCES_REVERT_EDITABLE_TOOLTIP _ ("Revert to the master photo")
#define RESOURCES_SET_BACKGROUND_MENU _ ("Set as _Desktop Background")
#define RESOURCES_SET_BACKGROUND_TOOLTIP _ ("Set selected image to be the new desktop background")
#define RESOURCES_SET_BACKGROUND_SLIDESHOW_MENU _ ("Set as _Desktop Slideshow…")
#define RESOURCES_UNDO_MENU _ ("_Undo")
#define RESOURCES_UNDO_LABEL _ ("Undo")
#define RESOURCES_REDO_MENU _ ("_Redo")
#define RESOURCES_REDO_LABEL _ ("Redo")
#define RESOURCES_RENAME_EVENT_MENU _ ("Re_name Event…")
#define RESOURCES_RENAME_EVENT_LABEL _ ("Rename Event")
#define RESOURCES_MAKE_KEY_PHOTO_MENU _ ("Make _Key Photo for Event")
#define RESOURCES_MAKE_KEY_PHOTO_LABEL _ ("Make Key Photo for Event")
#define RESOURCES_NEW_EVENT_MENU _ ("_New Event")
#define RESOURCES_NEW_EVENT_LABEL _ ("New Event")
#define RESOURCES_SET_PHOTO_EVENT_LABEL _ ("Move Photos")
#define RESOURCES_SET_PHOTO_EVENT_TOOLTIP _ ("Move photos to an event")
#define RESOURCES_MERGE_MENU _ ("_Merge Events")
#define RESOURCES_MERGE_LABEL _ ("Merge")
#define RESOURCES_MERGE_TOOLTIP _ ("Combine events into a single event")
#define RESOURCES_RATING_MENU _ ("_Set Rating")
#define RESOURCES_RATING_LABEL _ ("Set Rating")
#define RESOURCES_RATING_TOOLTIP _ ("Change the rating of your photo")
#define RESOURCES_INCREASE_RATING_MENU _ ("_Increase")
#define RESOURCES_INCREASE_RATING_LABEL _ ("Increase Rating")
#define RESOURCES_DECREASE_RATING_MENU _ ("_Decrease")
#define RESOURCES_DECREASE_RATING_LABEL _ ("Decrease Rating")
#define RESOURCES_RATE_UNRATED_MENU _ ("_Unrated")
#define RESOURCES_RATE_UNRATED_COMBO_BOX _ ("Unrated")
#define RESOURCES_RATE_UNRATED_LABEL _ ("Rate Unrated")
#define RESOURCES_RATE_UNRATED_PROGRESS _ ("Setting as unrated")
#define RESOURCES_RATE_UNRATED_TOOLTIP _ ("Remove any ratings")
#define RESOURCES_RATE_REJECTED_MENU _ ("_Rejected")
#define RESOURCES_RATE_REJECTED_COMBO_BOX _ ("Rejected")
#define RESOURCES_RATE_REJECTED_LABEL _ ("Rate Rejected")
#define RESOURCES_RATE_REJECTED_PROGRESS _ ("Setting as rejected")
#define RESOURCES_RATE_REJECTED_TOOLTIP _ ("Set rating to rejected")
#define RESOURCES_DISPLAY_REJECTED_ONLY_MENU _ ("Rejected _Only")
#define RESOURCES_DISPLAY_REJECTED_ONLY_LABEL _ ("Rejected Only")
#define RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP _ ("Show only rejected photos")
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_MENU _ ("All + _Rejected")
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP NC_ ("Tooltip", "Show all photos, including rejected")
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_MENU _ ("_All Photos")
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP _ ("Show all photos")
#define RESOURCES_VIEW_RATINGS_MENU _ ("_Ratings")
#define RESOURCES_VIEW_RATINGS_TOOLTIP _ ("Display each photo’s rating")
#define RESOURCES_FILTER_PHOTOS_MENU _ ("_Filter Photos")
#define RESOURCES_FILTER_PHOTOS_LABEL _ ("Filter Photos")
#define RESOURCES_FILTER_PHOTOS_TOOLTIP _ ("Limit the number of photos displayed based on a filter")
#define RESOURCES_DUPLICATE_PHOTO_MENU _ ("_Duplicate")
#define RESOURCES_DUPLICATE_PHOTO_LABEL _ ("Duplicate")
#define RESOURCES_DUPLICATE_PHOTO_TOOLTIP _ ("Make a duplicate of the photo")
#define RESOURCES_EXPORT_MENU _ ("_Export…")
#define RESOURCES_PRINT_MENU _ ("_Print…")
#define RESOURCES_PUBLISH_MENU _ ("Pu_blish…")
#define RESOURCES_PUBLISH_LABEL _ ("Publish")
#define RESOURCES_PUBLISH_TOOLTIP _ ("Publish to various websites")
#define RESOURCES_EDIT_TITLE_MENU _ ("Edit _Title…")
#define RESOURCES_EDIT_TITLE_LABEL NC_ ("Button Label", "Edit Title")
#define RESOURCES_EDIT_COMMENT_MENU _ ("Edit _Comment…")
#define RESOURCES_EDIT_COMMENT_LABEL _ ("Edit Comment")
#define RESOURCES_EDIT_EVENT_COMMENT_MENU _ ("Edit Event _Comment…")
#define RESOURCES_EDIT_EVENT_COMMENT_LABEL _ ("Edit Event Comment")
#define RESOURCES_ADJUST_DATE_TIME_MENU _ ("_Adjust Date and Time…")
#define RESOURCES_ADJUST_DATE_TIME_LABEL _ ("Adjust Date and Time")
#define RESOURCES_ADD_TAGS_MENU _ ("Add _Tags…")
#define RESOURCES_ADD_TAGS_CONTEXT_MENU _ ("_Add Tags…")
#define RESOURCES_ADD_TAGS_TITLE NC_ ("Dialog Title", "Add Tags")
#define RESOURCES_PREFERENCES_MENU _ ("_Preferences")
#define RESOURCES_EXTERNAL_EDIT_MENU _ ("Open With E_xternal Editor")
#define RESOURCES_EXTERNAL_EDIT_RAW_MENU _ ("Open With RA_W Editor")
#define RESOURCES_SEND_TO_MENU _ ("Send _To…")
#define RESOURCES_SEND_TO_CONTEXT_MENU _ ("Send T_o…")
#define RESOURCES_FIND_MENU _ ("_Find…")
#define RESOURCES_FIND_LABEL _ ("Find")
#define RESOURCES_FIND_TOOLTIP _ ("Find an image by typing text that appears in its name or tags")
#define RESOURCES_FLAG_MENU _ ("_Flag")
#define RESOURCES_UNFLAG_MENU _ ("Un_flag")
gchar* resources_launch_editor_failed (GError* err);
gchar* resources_add_tags_label (gchar** names, int names_length1);
gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
gchar* resources_delete_tag_menu (const gchar* name);
gchar* resources_delete_tag_label (const gchar* name);
#define RESOURCES_DELETE_TAG_TITLE _ ("Delete Tag")
#define RESOURCES_DELETE_TAG_SIDEBAR_MENU _ ("_Delete")
#define RESOURCES_NEW_CHILD_TAG_SIDEBAR_MENU _ ("_New")
gchar* resources_rename_tag_menu (const gchar* name);
gchar* resources_rename_tag_label (const gchar* old_name, const gchar* new_name);
#define RESOURCES_RENAME_TAG_SIDEBAR_MENU _ ("_Rename…")
#define RESOURCES_MODIFY_TAGS_MENU _ ("Modif_y Tags…")
#define RESOURCES_MODIFY_TAGS_LABEL _ ("Modify Tags")
gchar* resources_tag_photos_label (const gchar* name, gint count);
gchar* resources_tag_photos_tooltip (const gchar* name, gint count);
gchar* resources_untag_photos_menu (const gchar* name, gint count);
gchar* resources_untag_photos_label (const gchar* name, gint count);
gchar* resources_rename_tag_exists_message (const gchar* name);
gchar* resources_rename_search_exists_message (const gchar* name);
#define RESOURCES_DEFAULT_SAVED_SEARCH_NAME _ ("Saved Search")
#define RESOURCES_DELETE_SAVED_SEARCH_DIALOG_TITLE _ ("Delete Search")
#define RESOURCES_DELETE_SEARCH_MENU _ ("_Delete")
#define RESOURCES_EDIT_SEARCH_MENU _ ("_Edit…")
#define RESOURCES_RENAME_SEARCH_MENU _ ("Re_name…")
gchar* resources_rename_search_label (const gchar* old_name, const gchar* new_name);
gchar* resources_delete_search_label (const gchar* name);
GType rating_get_type (void) G_GNUC_CONST;
const gchar* resources_rating_label (Rating rating);
const gchar* resources_rating_combo_box (Rating rating);
GType rating_filter_get_type (void) G_GNUC_CONST;
gchar* resources_get_rating_filter_tooltip (RatingFilter filter);
gchar* resources_rating_progress (Rating rating);
gchar* resources_get_stars (Rating rating);
GdkPixbuf* resources_get_rating_trinket (Rating rating, gint scale);
GdkPixbuf* resources_get_icon (const gchar* name, gint scale);
void resources_generate_rating_strings (void);
#define RESOURCES_DELETE_PHOTOS_MENU _ ("_Delete")
#define RESOURCES_DELETE_FROM_TRASH_TOOLTIP _ ("Remove the selected photos from the trash")
#define RESOURCES_DELETE_FROM_LIBRARY_TOOLTIP _ ("Remove the selected photos from the library")
#define RESOURCES_RESTORE_PHOTOS_MENU _ ("_Restore")
#define RESOURCES_RESTORE_PHOTOS_TOOLTIP _ ("Move the selected photos back into the library")
#define RESOURCES_JUMP_TO_FILE_MENU _ ("Show in File Mana_ger")
#define RESOURCES_JUMP_TO_FILE_TOOLTIP _ ("Open the selected photo’s directory in the file manager")
gchar* resources_jump_to_file_failed (GError* err);
#define RESOURCES_REMOVE_FROM_LIBRARY_MENU _ ("R_emove From Library")
#define RESOURCES_MOVE_TO_TRASH_MENU _ ("_Move to Trash")
#define RESOURCES_SELECT_ALL_MENU _ ("Select _All")
#define RESOURCES_SELECT_ALL_TOOLTIP _ ("Select all items")
void resources_init (void);
GtkIconTheme* resources_get_icon_theme_engine (void);
void resources_terminate (void);
void resources_fetch_lc_time_format (void);
GType resources_unit_system_get_type (void) G_GNUC_CONST;
ResourcesUnitSystem resources_get_default_measurement_unit (void);
static gboolean _vala_string_array_contains (const gchar* * stack, int stack_length, const gchar* needle);
gchar* resources_get_hh_mm_format_string (void);
gchar* resources_get_hh_mm_ss_format_string (void);
gchar* resources_get_long_date_format_string (void);
gchar* resources_get_start_multiday_span_format_string (void);
gchar* resources_get_end_multiday_span_format_string (void);
gchar* resources_get_start_multimonth_span_format_string (void);
gchar* resources_get_end_multimonth_span_format_string (void);
gchar* resources_get_ui (const gchar* filename);
#define RESOURCES_NONINTERPRETABLE_BADGE_FILE "noninterpretable-video.png"
GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
GdkPixbuf* resources_load_icon (const gchar* name, gint scale);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
gchar* resources_get_help_path (void);
GFile* app_dirs_get_exec_dir (void);
void resources_launch_help (GdkScreen* screen, const gchar* anchor, GError** error);
void sys_show_uri (GdkScreen* screen, const gchar* uri, GError** error);
gchar* resources_to_css_color (GdkRGBA* color);
#define RESOURCES_ALL_DATA -1
void resources_style_widget (GtkWidget* widget, const gchar* stylesheet);
gint resources_use_header_bar (void);
#define RESOURCES_CUSTOM_CSS "LibraryWindow .pane-separator {\n" \
"               background-color: @borders;\n" \
"            }\n" \
"            SearchFilterToolbar {\n" \
"               border-width: 0 0 1px 0;\n" \
"               border-style: solid;\n" \
"               border-color: @borders;\n" \
"            }"
#define RESOURCES_ONIMAGE_FONT_COLOR "#000000"
#define RESOURCES_ONIMAGE_FONT_BACKGROUND "rgba(255,255,255,0.5)"
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* RESOURCES_AUTHORS[6] = {"Jim Nelson <jim@yorba.org>", "Lucas Beeler <lucas@yorba.org>", "Allison Barlow <allison@yorba.org>", "Eric Gregory <eric@yorba.org>", "Clinton Rogers <clinton@yorba.org>", NULL};
const gint RESOURCES_rating_thresholds[6] = {0, 1, 25, 50, 75, 99};
const gchar* RESOURCES_IMPERIAL_COUNTRIES[4] = {"unm_US", "es_US", "en_US", "yi_US"};

gchar* resources_launch_editor_failed (GError* err) {
	gchar* result = NULL;
	GError* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 336 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = err;
#line 336 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = _tmp0_->message;
#line 336 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (_ ("Unable to launch editor: %s"), _tmp1_);
#line 336 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 336 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 495 "Resources.c"
}


gchar* resources_add_tags_label (gchar** names, int names_length1) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 340 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = names;
#line 340 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0__length1 = names_length1;
#line 340 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0__length1 == 1) {
#line 509 "Resources.c"
		gchar** _tmp1_;
		gint _tmp1__length1;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1_ = names;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1__length1 = names_length1;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = _tmp1_[0];
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp3_ = hierarchical_tag_utilities_get_basename (_tmp2_);
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp4_ = _tmp3_;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp5_ = g_strdup_printf (_ ("Add Tag “%s”"), _tmp4_);
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = _tmp5_;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp4_);
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		result = _tmp6_;
#line 341 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 537 "Resources.c"
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
#line 342 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = names;
#line 342 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7__length1 = names_length1;
#line 342 "/home/jens/Source/shotwell/src/Resources.vala"
		if (_tmp7__length1 == 2) {
#line 547 "Resources.c"
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8_ = names;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8__length1 = names_length1;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp9_ = _tmp8_[0];
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp10_ = hierarchical_tag_utilities_get_basename (_tmp9_);
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp11_ = _tmp10_;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp12_ = names;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp12__length1 = names_length1;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp13_ = _tmp12_[1];
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp14_ = hierarchical_tag_utilities_get_basename (_tmp13_);
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp15_ = _tmp14_;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp16_ = g_strdup_printf (_ ("Add Tags “%s” and “%s”"), _tmp11_, _tmp15_);
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp17_ = _tmp16_;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (_tmp15_);
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (_tmp11_);
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp17_;
#line 344 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 592 "Resources.c"
		} else {
			gchar* _tmp18_;
#line 349 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp18_ = g_strdup (C_ ("UndoRedo menu entry", "Add Tags"));
#line 349 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp18_;
#line 349 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 601 "Resources.c"
		}
	}
}


gchar* resources_delete_tag_menu (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 353 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 354 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 354 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("_Delete Tag “%s”"), _tmp0_);
#line 354 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 354 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 621 "Resources.c"
}


gchar* resources_delete_tag_label (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 357 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 358 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 358 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("Delete Tag “%s”"), _tmp0_);
#line 358 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 358 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 639 "Resources.c"
}


gchar* resources_rename_tag_menu (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 366 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 367 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 367 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("Re_name Tag “%s”…"), _tmp0_);
#line 367 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 367 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 657 "Resources.c"
}


gchar* resources_rename_tag_label (const gchar* old_name, const gchar* new_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 370 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (old_name != NULL, NULL);
#line 370 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (new_name != NULL, NULL);
#line 371 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = old_name;
#line 371 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = new_name;
#line 371 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (_ ("Rename Tag “%s” to “%s”"), _tmp0_, _tmp1_);
#line 371 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 371 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 680 "Resources.c"
}


gchar* resources_tag_photos_label (const gchar* name, gint count) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 379 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 380 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = count;
#line 380 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = name;
#line 380 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (ngettext ("Tag Photo as “%s”", "Tag Photos as “%s”", (gulong) _tmp0_), _tmp1_);
#line 380 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 380 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 701 "Resources.c"
}


gchar* resources_tag_photos_tooltip (const gchar* name, gint count) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 385 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 386 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = count;
#line 386 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = name;
#line 386 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (ngettext ("Tag the selected photo as “%s”", "Tag the selected photos as “%s”", (gulong) _tmp0_), _tmp1_);
#line 386 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 386 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 722 "Resources.c"
}


gchar* resources_untag_photos_menu (const gchar* name, gint count) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 391 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 392 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = count;
#line 392 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = name;
#line 392 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (ngettext ("Remove Tag “%s” From _Photo", "Remove Tag “%s” From _Photos", (gulong) _tmp0_), _tmp1_);
#line 392 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 392 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 743 "Resources.c"
}


gchar* resources_untag_photos_label (const gchar* name, gint count) {
	gchar* result = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 397 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 398 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = count;
#line 398 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = name;
#line 398 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (ngettext ("Remove Tag “%s” From Photo", "Remove Tag “%s” From Photos", (gulong) _tmp0_), _tmp1_);
#line 398 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 398 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 764 "Resources.c"
}


gchar* resources_rename_tag_exists_message (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 403 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 404 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 404 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("Unable to rename tag to “%s” because the tag already exists."), _tmp0_);
#line 404 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 404 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 782 "Resources.c"
}


gchar* resources_rename_search_exists_message (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 407 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 408 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 408 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("Unable to rename search to “%s” because the search already exists."), _tmp0_);
#line 408 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 408 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 800 "Resources.c"
}


gchar* resources_rename_search_label (const gchar* old_name, const gchar* new_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 419 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (old_name != NULL, NULL);
#line 419 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (new_name != NULL, NULL);
#line 420 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = old_name;
#line 420 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = new_name;
#line 420 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (_ ("Rename Search “%s” to “%s”"), _tmp0_, _tmp1_);
#line 420 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 420 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 823 "Resources.c"
}


gchar* resources_delete_search_label (const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 423 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 424 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = name;
#line 424 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf (_ ("Delete Search “%s”"), _tmp0_);
#line 424 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 424 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 841 "Resources.c"
}


const gchar* resources_rating_label (Rating rating) {
	const gchar* result = NULL;
	Rating _tmp0_;
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = rating;
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_REJECTED:
#line 854 "Resources.c"
		{
#line 430 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_REJECTED_LABEL;
#line 430 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 860 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_UNRATED:
#line 864 "Resources.c"
		{
#line 432 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_UNRATED_LABEL;
#line 432 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 870 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_ONE:
#line 874 "Resources.c"
		{
			const gchar* _tmp1_;
#line 434 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = resources_RATE_ONE_LABEL;
#line 434 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp1_;
#line 434 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 883 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_TWO:
#line 887 "Resources.c"
		{
			const gchar* _tmp2_;
#line 436 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = resources_RATE_TWO_LABEL;
#line 436 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp2_;
#line 436 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 896 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_THREE:
#line 900 "Resources.c"
		{
			const gchar* _tmp3_;
#line 438 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = resources_RATE_THREE_LABEL;
#line 438 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp3_;
#line 438 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 909 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FOUR:
#line 913 "Resources.c"
		{
			const gchar* _tmp4_;
#line 440 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = resources_RATE_FOUR_LABEL;
#line 440 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp4_;
#line 440 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 922 "Resources.c"
		}
#line 428 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FIVE:
#line 926 "Resources.c"
		{
			const gchar* _tmp5_;
#line 442 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = resources_RATE_FIVE_LABEL;
#line 442 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp5_;
#line 442 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 935 "Resources.c"
		}
		default:
		{
#line 444 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_UNRATED_LABEL;
#line 444 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 943 "Resources.c"
		}
	}
}


const gchar* resources_rating_combo_box (Rating rating) {
	const gchar* result = NULL;
	Rating _tmp0_;
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = rating;
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_REJECTED:
#line 958 "Resources.c"
		{
#line 451 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_REJECTED_COMBO_BOX;
#line 451 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 964 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_UNRATED:
#line 968 "Resources.c"
		{
#line 453 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_UNRATED_COMBO_BOX;
#line 453 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 974 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_ONE:
#line 978 "Resources.c"
		{
			const gchar* _tmp1_;
#line 455 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = resources_RATE_ONE_MENU;
#line 455 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp1_;
#line 455 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 987 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_TWO:
#line 991 "Resources.c"
		{
			const gchar* _tmp2_;
#line 457 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = resources_RATE_TWO_MENU;
#line 457 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp2_;
#line 457 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1000 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_THREE:
#line 1004 "Resources.c"
		{
			const gchar* _tmp3_;
#line 459 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = resources_RATE_THREE_MENU;
#line 459 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp3_;
#line 459 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1013 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FOUR:
#line 1017 "Resources.c"
		{
			const gchar* _tmp4_;
#line 461 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = resources_RATE_FOUR_MENU;
#line 461 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp4_;
#line 461 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1026 "Resources.c"
		}
#line 449 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FIVE:
#line 1030 "Resources.c"
		{
			const gchar* _tmp5_;
#line 463 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = resources_RATE_FIVE_MENU;
#line 463 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp5_;
#line 463 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1039 "Resources.c"
		}
		default:
		{
#line 465 "/home/jens/Source/shotwell/src/Resources.vala"
			result = RESOURCES_RATE_UNRATED_MENU;
#line 465 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1047 "Resources.c"
		}
	}
}


gchar* resources_get_rating_filter_tooltip (RatingFilter filter) {
	gchar* result = NULL;
	RatingFilter _tmp0_;
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = filter;
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_REJECTED_OR_HIGHER:
#line 1062 "Resources.c"
		{
			gchar* _tmp1_;
#line 472 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = g_strdup (RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP);
#line 472 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp1_;
#line 472 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1071 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_ONE_OR_HIGHER:
#line 1075 "Resources.c"
		{
			const gchar* _tmp2_;
			gchar* _tmp3_;
#line 475 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
#line 475 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 475 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp3_;
#line 475 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1087 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_TWO_OR_HIGHER:
#line 1091 "Resources.c"
		{
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 478 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
#line 478 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 478 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp5_;
#line 478 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1103 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_THREE_OR_HIGHER:
#line 1107 "Resources.c"
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
#line 481 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp6_ = resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
#line 481 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 481 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp7_;
#line 481 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1119 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_FOUR_OR_HIGHER:
#line 1123 "Resources.c"
		{
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 484 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8_ = resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
#line 484 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 484 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp9_;
#line 484 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1135 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_FIVE_ONLY:
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_FIVE_OR_HIGHER:
#line 1141 "Resources.c"
		{
			const gchar* _tmp10_;
			gchar* _tmp11_;
#line 488 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp10_ = resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
#line 488 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 488 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp11_;
#line 488 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1153 "Resources.c"
		}
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_REJECTED_ONLY:
#line 1157 "Resources.c"
		{
			gchar* _tmp12_;
#line 491 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp12_ = g_strdup (RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP);
#line 491 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp12_;
#line 491 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1166 "Resources.c"
		}
		default:
#line 470 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FILTER_UNRATED_OR_HIGHER:
#line 1171 "Resources.c"
		{
			gchar* _tmp13_;
#line 495 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp13_ = g_strdup (RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP);
#line 495 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp13_;
#line 495 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1180 "Resources.c"
		}
	}
}


gchar* resources_rating_progress (Rating rating) {
	gchar* result = NULL;
	Rating _tmp0_;
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = rating;
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_REJECTED:
#line 1195 "Resources.c"
		{
			gchar* _tmp1_;
#line 502 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = g_strdup (RESOURCES_RATE_REJECTED_PROGRESS);
#line 502 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp1_;
#line 502 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1204 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_UNRATED:
#line 1208 "Resources.c"
		{
			gchar* _tmp2_;
#line 504 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = g_strdup (RESOURCES_RATE_UNRATED_PROGRESS);
#line 504 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp2_;
#line 504 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1217 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_ONE:
#line 1221 "Resources.c"
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
#line 506 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = resources_RATE_ONE_PROGRESS;
#line 506 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 506 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp4_;
#line 506 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1233 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_TWO:
#line 1237 "Resources.c"
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 508 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = resources_RATE_TWO_PROGRESS;
#line 508 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 508 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp6_;
#line 508 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1249 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_THREE:
#line 1253 "Resources.c"
		{
			const gchar* _tmp7_;
			gchar* _tmp8_;
#line 510 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp7_ = resources_RATE_THREE_PROGRESS;
#line 510 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8_ = g_strdup (_tmp7_);
#line 510 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp8_;
#line 510 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1265 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FOUR:
#line 1269 "Resources.c"
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
#line 512 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp9_ = resources_RATE_FOUR_PROGRESS;
#line 512 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 512 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp10_;
#line 512 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1281 "Resources.c"
		}
#line 500 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FIVE:
#line 1285 "Resources.c"
		{
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 514 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp11_ = resources_RATE_FIVE_PROGRESS;
#line 514 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 514 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp12_;
#line 514 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1297 "Resources.c"
		}
		default:
		{
			gchar* _tmp13_;
#line 516 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp13_ = g_strdup (RESOURCES_RATE_UNRATED_PROGRESS);
#line 516 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp13_;
#line 516 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1308 "Resources.c"
		}
	}
}


gchar* resources_get_stars (Rating rating) {
	gchar* result = NULL;
	Rating _tmp0_;
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = rating;
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_ONE:
#line 1323 "Resources.c"
		{
			gchar* _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = g_strdup ("\xE2\x98\x85");
#line 525 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1332 "Resources.c"
		}
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_TWO:
#line 1336 "Resources.c"
		{
			gchar* _tmp2_;
#line 527 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85");
#line 527 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp2_;
#line 527 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1345 "Resources.c"
		}
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_THREE:
#line 1349 "Resources.c"
		{
			gchar* _tmp3_;
#line 529 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
#line 529 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp3_;
#line 529 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1358 "Resources.c"
		}
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FOUR:
#line 1362 "Resources.c"
		{
			gchar* _tmp4_;
#line 531 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
#line 531 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp4_;
#line 531 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1371 "Resources.c"
		}
#line 523 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FIVE:
#line 1375 "Resources.c"
		{
			gchar* _tmp5_;
#line 533 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = g_strdup ("\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85\xE2\x98\x85");
#line 533 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp5_;
#line 533 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1384 "Resources.c"
		}
		default:
		{
			gchar* _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp6_ = g_strdup ("");
#line 535 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1395 "Resources.c"
		}
	}
}


GdkPixbuf* resources_get_rating_trinket (Rating rating, gint scale) {
	GdkPixbuf* result = NULL;
	Rating _tmp0_;
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = rating;
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
	switch (_tmp0_) {
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_REJECTED:
#line 1410 "Resources.c"
		{
			gint _tmp1_;
			GdkPixbuf* _tmp2_;
#line 542 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = scale;
#line 542 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = resources_get_icon (RESOURCES_ICON_RATING_REJECTED, _tmp1_);
#line 542 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp2_;
#line 542 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1422 "Resources.c"
		}
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_ONE:
#line 1426 "Resources.c"
		{
			gint _tmp3_;
			GdkPixbuf* _tmp4_;
#line 545 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = scale;
#line 545 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = resources_get_icon (RESOURCES_ICON_RATING_ONE, _tmp3_);
#line 545 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp4_;
#line 545 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1438 "Resources.c"
		}
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_TWO:
#line 1442 "Resources.c"
		{
			gint _tmp5_;
			GdkPixbuf* _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = scale;
#line 547 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp6_ = resources_get_icon (RESOURCES_ICON_RATING_TWO, _tmp5_ * 2);
#line 547 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1454 "Resources.c"
		}
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_THREE:
#line 1458 "Resources.c"
		{
			gint _tmp7_;
			GdkPixbuf* _tmp8_;
#line 549 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp7_ = scale;
#line 549 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8_ = resources_get_icon (RESOURCES_ICON_RATING_THREE, _tmp7_ * 3);
#line 549 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp8_;
#line 549 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1470 "Resources.c"
		}
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FOUR:
#line 1474 "Resources.c"
		{
			gint _tmp9_;
			GdkPixbuf* _tmp10_;
#line 551 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp9_ = scale;
#line 551 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp10_ = resources_get_icon (RESOURCES_ICON_RATING_FOUR, _tmp9_ * 4);
#line 551 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp10_;
#line 551 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1486 "Resources.c"
		}
#line 540 "/home/jens/Source/shotwell/src/Resources.vala"
		case RATING_FIVE:
#line 1490 "Resources.c"
		{
			gint _tmp11_;
			GdkPixbuf* _tmp12_;
#line 553 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp11_ = scale;
#line 553 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp12_ = resources_get_icon (RESOURCES_ICON_RATING_FIVE, _tmp11_ * 5);
#line 553 "/home/jens/Source/shotwell/src/Resources.vala"
			result = _tmp12_;
#line 553 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1502 "Resources.c"
		}
		default:
		{
#line 555 "/home/jens/Source/shotwell/src/Resources.vala"
			result = NULL;
#line 555 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 1510 "Resources.c"
		}
	}
}


void resources_generate_rating_strings (void) {
	gchar* menu_base = NULL;
	gchar* _tmp0_;
	gchar* label_base = NULL;
	gchar* _tmp1_;
	gchar* tooltip_base = NULL;
	gchar* _tmp2_;
	gchar* progress_base = NULL;
	gchar* _tmp3_;
	gchar* display_rating_menu_base = NULL;
	gchar* _tmp4_;
	gchar* display_rating_label_base = NULL;
	gchar* _tmp5_;
	gchar* display_rating_tooltip_base = NULL;
	gchar* _tmp6_;
	gchar* display_rating_or_higher_menu_base = NULL;
	gchar* _tmp7_;
	gchar* display_rating_or_higher_label_base = NULL;
	gchar* _tmp8_;
	gchar* display_rating_or_higher_tooltip_base = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
#line 560 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = g_strdup ("%s");
#line 560 "/home/jens/Source/shotwell/src/Resources.vala"
	menu_base = _tmp0_;
#line 561 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup (_ ("Rate %s"));
#line 561 "/home/jens/Source/shotwell/src/Resources.vala"
	label_base = _tmp1_;
#line 562 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_ ("Set rating to %s"));
#line 562 "/home/jens/Source/shotwell/src/Resources.vala"
	tooltip_base = _tmp2_;
#line 563 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = g_strdup (_ ("Setting rating to %s"));
#line 563 "/home/jens/Source/shotwell/src/Resources.vala"
	progress_base = _tmp3_;
#line 564 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = g_strdup ("%s");
#line 564 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_menu_base = _tmp4_;
#line 565 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp5_ = g_strdup (_ ("Display %s"));
#line 565 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_label_base = _tmp5_;
#line 566 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp6_ = g_strdup (_ ("Only show photos with a rating of %s"));
#line 566 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_tooltip_base = _tmp6_;
#line 567 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp7_ = g_strdup (_ ("%s or Better"));
#line 567 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_or_higher_menu_base = _tmp7_;
#line 568 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp8_ = g_strdup (_ ("Display %s or Better"));
#line 568 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_or_higher_label_base = _tmp8_;
#line 569 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp9_ = g_strdup (_ ("Only show photos with a rating of %s or better"));
#line 569 "/home/jens/Source/shotwell/src/Resources.vala"
	display_rating_or_higher_tooltip_base = _tmp9_;
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = resources_get_stars (RATING_ONE);
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp11_ = _tmp10_;
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp12_ = g_strdup_printf (menu_base, _tmp11_);
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_ONE_MENU);
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_ONE_MENU = _tmp12_;
#line 571 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp11_);
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp13_ = resources_get_stars (RATING_TWO);
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp14_ = _tmp13_;
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp15_ = g_strdup_printf (menu_base, _tmp14_);
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_TWO_MENU);
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_TWO_MENU = _tmp15_;
#line 572 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp14_);
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp16_ = resources_get_stars (RATING_THREE);
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp17_ = _tmp16_;
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp18_ = g_strdup_printf (menu_base, _tmp17_);
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_THREE_MENU);
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_THREE_MENU = _tmp18_;
#line 573 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp17_);
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp19_ = resources_get_stars (RATING_FOUR);
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp20_ = _tmp19_;
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp21_ = g_strdup_printf (menu_base, _tmp20_);
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FOUR_MENU);
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FOUR_MENU = _tmp21_;
#line 574 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp20_);
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp22_ = resources_get_stars (RATING_FIVE);
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp23_ = _tmp22_;
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp24_ = g_strdup_printf (menu_base, _tmp23_);
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FIVE_MENU);
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FIVE_MENU = _tmp24_;
#line 575 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp23_);
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp25_ = resources_get_stars (RATING_ONE);
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp26_ = _tmp25_;
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp27_ = g_strdup_printf (label_base, _tmp26_);
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_ONE_LABEL);
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_ONE_LABEL = _tmp27_;
#line 577 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp26_);
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp28_ = resources_get_stars (RATING_TWO);
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp29_ = _tmp28_;
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp30_ = g_strdup_printf (label_base, _tmp29_);
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_TWO_LABEL);
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_TWO_LABEL = _tmp30_;
#line 578 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp29_);
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp31_ = resources_get_stars (RATING_THREE);
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp32_ = _tmp31_;
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp33_ = g_strdup_printf (label_base, _tmp32_);
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_THREE_LABEL);
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_THREE_LABEL = _tmp33_;
#line 579 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp32_);
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp34_ = resources_get_stars (RATING_FOUR);
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp35_ = _tmp34_;
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp36_ = g_strdup_printf (label_base, _tmp35_);
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FOUR_LABEL);
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FOUR_LABEL = _tmp36_;
#line 580 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp35_);
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp37_ = resources_get_stars (RATING_FIVE);
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp38_ = _tmp37_;
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp39_ = g_strdup_printf (label_base, _tmp38_);
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FIVE_LABEL);
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FIVE_LABEL = _tmp39_;
#line 581 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp38_);
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp40_ = resources_get_stars (RATING_ONE);
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp41_ = _tmp40_;
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp42_ = g_strdup_printf (tooltip_base, _tmp41_);
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_ONE_TOOLTIP);
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_ONE_TOOLTIP = _tmp42_;
#line 583 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp41_);
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp43_ = resources_get_stars (RATING_TWO);
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp44_ = _tmp43_;
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp45_ = g_strdup_printf (tooltip_base, _tmp44_);
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_TWO_TOOLTIP);
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_TWO_TOOLTIP = _tmp45_;
#line 584 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp44_);
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp46_ = resources_get_stars (RATING_THREE);
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp47_ = _tmp46_;
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp48_ = g_strdup_printf (tooltip_base, _tmp47_);
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_THREE_TOOLTIP);
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_THREE_TOOLTIP = _tmp48_;
#line 585 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp47_);
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp49_ = resources_get_stars (RATING_FOUR);
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp50_ = _tmp49_;
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp51_ = g_strdup_printf (tooltip_base, _tmp50_);
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FOUR_TOOLTIP);
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FOUR_TOOLTIP = _tmp51_;
#line 586 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp50_);
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp52_ = resources_get_stars (RATING_FIVE);
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp53_ = _tmp52_;
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp54_ = g_strdup_printf (tooltip_base, _tmp53_);
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FIVE_TOOLTIP);
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FIVE_TOOLTIP = _tmp54_;
#line 587 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp53_);
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp55_ = resources_get_stars (RATING_ONE);
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp56_ = _tmp55_;
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp57_ = g_strdup_printf (progress_base, _tmp56_);
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_ONE_PROGRESS);
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_ONE_PROGRESS = _tmp57_;
#line 589 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp56_);
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp58_ = resources_get_stars (RATING_TWO);
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp59_ = _tmp58_;
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp60_ = g_strdup_printf (progress_base, _tmp59_);
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_TWO_PROGRESS);
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_TWO_PROGRESS = _tmp60_;
#line 590 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp59_);
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp61_ = resources_get_stars (RATING_THREE);
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp62_ = _tmp61_;
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp63_ = g_strdup_printf (progress_base, _tmp62_);
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_THREE_PROGRESS);
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_THREE_PROGRESS = _tmp63_;
#line 591 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp62_);
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp64_ = resources_get_stars (RATING_FOUR);
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp65_ = _tmp64_;
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp66_ = g_strdup_printf (progress_base, _tmp65_);
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FOUR_PROGRESS);
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FOUR_PROGRESS = _tmp66_;
#line 592 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp65_);
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp67_ = resources_get_stars (RATING_FIVE);
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp68_ = _tmp67_;
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp69_ = g_strdup_printf (progress_base, _tmp68_);
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_RATE_FIVE_PROGRESS);
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_RATE_FIVE_PROGRESS = _tmp69_;
#line 593 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp68_);
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp70_ = resources_get_stars (RATING_ONE);
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp71_ = _tmp70_;
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp72_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp71_);
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_MENU);
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_ONE_OR_HIGHER_MENU = _tmp72_;
#line 595 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp71_);
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp73_ = resources_get_stars (RATING_TWO);
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp74_ = _tmp73_;
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp75_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp74_);
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_MENU);
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_TWO_OR_HIGHER_MENU = _tmp75_;
#line 596 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp74_);
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp76_ = resources_get_stars (RATING_THREE);
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp77_ = _tmp76_;
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp78_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp77_);
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_MENU);
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_THREE_OR_HIGHER_MENU = _tmp78_;
#line 597 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp77_);
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp79_ = resources_get_stars (RATING_FOUR);
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp80_ = _tmp79_;
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp81_ = g_strdup_printf (display_rating_or_higher_menu_base, _tmp80_);
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_MENU);
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FOUR_OR_HIGHER_MENU = _tmp81_;
#line 598 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp80_);
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp82_ = resources_get_stars (RATING_FIVE);
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp83_ = _tmp82_;
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp84_ = g_strdup_printf (display_rating_menu_base, _tmp83_);
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_MENU);
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FIVE_OR_HIGHER_MENU = _tmp84_;
#line 599 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp83_);
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp85_ = resources_get_stars (RATING_ONE);
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp86_ = _tmp85_;
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp87_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp86_);
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_LABEL);
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_ONE_OR_HIGHER_LABEL = _tmp87_;
#line 601 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp86_);
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp88_ = resources_get_stars (RATING_TWO);
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp89_ = _tmp88_;
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp90_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp89_);
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_LABEL);
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_TWO_OR_HIGHER_LABEL = _tmp90_;
#line 602 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp89_);
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp91_ = resources_get_stars (RATING_THREE);
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp92_ = _tmp91_;
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp93_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp92_);
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_LABEL);
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_THREE_OR_HIGHER_LABEL = _tmp93_;
#line 603 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp92_);
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp94_ = resources_get_stars (RATING_FOUR);
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp95_ = _tmp94_;
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp96_ = g_strdup_printf (display_rating_or_higher_label_base, _tmp95_);
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_LABEL);
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FOUR_OR_HIGHER_LABEL = _tmp96_;
#line 604 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp95_);
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp97_ = resources_get_stars (RATING_FIVE);
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp98_ = _tmp97_;
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp99_ = g_strdup_printf (display_rating_label_base, _tmp98_);
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_LABEL);
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FIVE_OR_HIGHER_LABEL = _tmp99_;
#line 605 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp98_);
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp100_ = resources_get_stars (RATING_ONE);
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp101_ = _tmp100_;
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp102_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp101_);
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP);
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP = _tmp102_;
#line 607 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp101_);
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp103_ = resources_get_stars (RATING_TWO);
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp104_ = _tmp103_;
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp105_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp104_);
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP);
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP = _tmp105_;
#line 608 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp104_);
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp106_ = resources_get_stars (RATING_THREE);
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp107_ = _tmp106_;
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp108_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp107_);
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP);
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP = _tmp108_;
#line 609 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp107_);
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp109_ = resources_get_stars (RATING_FOUR);
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp110_ = _tmp109_;
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp111_ = g_strdup_printf (display_rating_or_higher_tooltip_base, _tmp110_);
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP);
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP = _tmp111_;
#line 610 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp110_);
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp112_ = resources_get_stars (RATING_FIVE);
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp113_ = _tmp112_;
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp114_ = g_strdup_printf (display_rating_tooltip_base, _tmp113_);
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP);
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP = _tmp114_;
#line 611 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp113_);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_or_higher_tooltip_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_or_higher_label_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_or_higher_menu_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_tooltip_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_label_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (display_rating_menu_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (progress_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (tooltip_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (label_base);
#line 559 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (menu_base);
#line 2122 "Resources.c"
}


gchar* resources_jump_to_file_failed (GError* err) {
	gchar* result = NULL;
	GError* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 670 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = err;
#line 670 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = _tmp0_->message;
#line 670 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup_printf (_ ("Unable to open in file manager: %s"), _tmp1_);
#line 670 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 670 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2141 "Resources.c"
}


void resources_init (void) {
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
#line 692 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_get_icon_theme_engine ();
#line 692 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = _tmp0_;
#line 692 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (_tmp1_);
#line 694 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_generate_rating_strings ();
#line 2156 "Resources.c"
}


void resources_terminate (void) {
}


/**
     * @brief Helper for getting a format string that matches the
     * user's LC_TIME settings from the system.  This is intended 
     * to help support the use case where a user wants the text 
     * from one locale, but the timestamp format of another.
     * 
     * Stolen wholesale from code written for Geary by Jim Nelson
     * and from Marcel Stimberg's original patch to Shotwell to 
     * try to fix this; both are graciously thanked for their help.
     */
void resources_fetch_lc_time_format (void) {
	gchar* old_language = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* old_messages = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* lc_time = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp19_;
#line 713 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = g_getenv ("LANGUAGE");
#line 713 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 713 "/home/jens/Source/shotwell/src/Resources.vala"
	old_language = _tmp1_;
#line 714 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = old_language;
#line 714 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp2_ != NULL) {
#line 715 "/home/jens/Source/shotwell/src/Resources.vala"
		g_unsetenv ("LANGUAGE");
#line 2208 "Resources.c"
	}
#line 719 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = setlocale (LC_MESSAGES, NULL);
#line 719 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 719 "/home/jens/Source/shotwell/src/Resources.vala"
	old_messages = _tmp4_;
#line 720 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp5_ = setlocale (LC_TIME, NULL);
#line 720 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 720 "/home/jens/Source/shotwell/src/Resources.vala"
	lc_time = _tmp6_;
#line 722 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp7_ = lc_time;
#line 722 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp7_ != NULL) {
#line 2226 "Resources.c"
		const gchar* _tmp8_;
#line 723 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp8_ = lc_time;
#line 723 "/home/jens/Source/shotwell/src/Resources.vala"
		setlocale (LC_MESSAGES, _tmp8_);
#line 2232 "Resources.c"
	}
#line 730 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp9_ = g_strdup ("%X");
#line 730 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_HH_MM_FORMAT_STRING);
#line 730 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_HH_MM_FORMAT_STRING = _tmp9_;
#line 735 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = nl_langinfo (T_FMT);
#line 735 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 735 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_HH_MM_SS_FORMAT_STRING);
#line 735 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_HH_MM_SS_FORMAT_STRING = _tmp11_;
#line 739 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp12_ = g_strdup (_ ("%a %b %d, %Y"));
#line 739 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_LONG_DATE_FORMAT_STRING);
#line 739 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_LONG_DATE_FORMAT_STRING = _tmp12_;
#line 744 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp13_ = g_strdup (C_ ("MultidayFormat", "%a %b %d"));
#line 744 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_START_MULTIDAY_DATE_FORMAT_STRING);
#line 744 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_START_MULTIDAY_DATE_FORMAT_STRING = _tmp13_;
#line 749 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp14_ = g_strdup (C_ ("MultidayFormat", "%d, %Y"));
#line 749 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_END_MULTIDAY_DATE_FORMAT_STRING);
#line 749 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_END_MULTIDAY_DATE_FORMAT_STRING = _tmp14_;
#line 754 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp15_ = g_strdup (C_ ("MultimonthFormat", "%a %b %d"));
#line 754 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_START_MULTIMONTH_DATE_FORMAT_STRING);
#line 754 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_START_MULTIMONTH_DATE_FORMAT_STRING = _tmp15_;
#line 759 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp16_ = g_strdup (C_ ("MultimonthFormat", "%a %b %d, %Y"));
#line 759 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_END_MULTIMONTH_DATE_FORMAT_STRING);
#line 759 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_END_MULTIMONTH_DATE_FORMAT_STRING = _tmp16_;
#line 762 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp17_ = old_messages;
#line 762 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp17_ != NULL) {
#line 2282 "Resources.c"
		const gchar* _tmp18_;
#line 763 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp18_ = old_messages;
#line 763 "/home/jens/Source/shotwell/src/Resources.vala"
		setlocale (LC_MESSAGES, _tmp18_);
#line 2288 "Resources.c"
	}
#line 766 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp19_ = old_language;
#line 766 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp19_ != NULL) {
#line 2294 "Resources.c"
		const gchar* _tmp20_;
#line 767 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp20_ = old_language;
#line 767 "/home/jens/Source/shotwell/src/Resources.vala"
		g_setenv ("LANGUAGE", _tmp20_, TRUE);
#line 2300 "Resources.c"
	}
#line 710 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (lc_time);
#line 710 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (old_messages);
#line 710 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (old_language);
#line 2308 "Resources.c"
}


GType resources_unit_system_get_type (void) {
	static volatile gsize resources_unit_system_type_id__volatile = 0;
	if (g_once_init_enter (&resources_unit_system_type_id__volatile)) {
		static const GEnumValue values[] = {{RESOURCES_UNIT_SYSTEM_IMPERIAL, "RESOURCES_UNIT_SYSTEM_IMPERIAL", "imperial"}, {RESOURCES_UNIT_SYSTEM_METRIC, "RESOURCES_UNIT_SYSTEM_METRIC", "metric"}, {RESOURCES_UNIT_SYSTEM_UNKNOWN, "RESOURCES_UNIT_SYSTEM_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType resources_unit_system_type_id;
		resources_unit_system_type_id = g_enum_register_static ("ResourcesUnitSystem", values);
		g_once_init_leave (&resources_unit_system_type_id__volatile, resources_unit_system_type_id);
	}
	return resources_unit_system_type_id__volatile;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1041 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1044 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1044 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2345 "Resources.c"
		gchar* _tmp4_;
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2353 "Resources.c"
	} else {
#line 1047 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = -1;
#line 1047 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2359 "Resources.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2383 "Resources.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2391 "Resources.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2403 "Resources.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2427 "Resources.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2433 "Resources.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2437 "Resources.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2441 "Resources.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2453 "Resources.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2463 "Resources.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2469 "Resources.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2483 "Resources.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2493 "Resources.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2499 "Resources.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2508 "Resources.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 2528 "Resources.c"
}


static gboolean _vala_string_array_contains (const gchar* * stack, int stack_length, const gchar* needle) {
	int i;
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
	for (i = 0; i < stack_length; i++) {
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
			return TRUE;
#line 2540 "Resources.c"
		}
	}
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
	return FALSE;
#line 2545 "Resources.c"
}


ResourcesUnitSystem resources_get_default_measurement_unit (void) {
	ResourcesUnitSystem result = 0;
	ResourcesUnitSystem _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gint index = 0;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp15_;
	ResourcesUnitSystem _tmp16_;
#line 783 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_unit_system;
#line 783 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ != RESOURCES_UNIT_SYSTEM_UNKNOWN) {
#line 2565 "Resources.c"
		ResourcesUnitSystem _tmp1_;
#line 784 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1_ = resources_unit_system;
#line 784 "/home/jens/Source/shotwell/src/Resources.vala"
		result = _tmp1_;
#line 784 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 2573 "Resources.c"
	}
#line 787 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_getenv ("LC_MEASUREMENT");
#line 787 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 787 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (resources_lc_measurement);
#line 787 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_lc_measurement = _tmp3_;
#line 788 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = resources_lc_measurement;
#line 788 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp4_ == NULL) {
#line 2587 "Resources.c"
		gchar** _tmp5_;
		gchar** _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 789 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = _tmp5_ = g_get_language_names ();
#line 789 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = _tmp6_[0];
#line 789 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 789 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (resources_lc_measurement);
#line 789 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_lc_measurement = _tmp8_;
#line 2602 "Resources.c"
	}
#line 792 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp9_ = resources_lc_measurement;
#line 792 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
#line 792 "/home/jens/Source/shotwell/src/Resources.vala"
	index = _tmp10_;
#line 793 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp11_ = index;
#line 793 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp11_ > 0) {
#line 2614 "Resources.c"
		const gchar* _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
#line 794 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp12_ = resources_lc_measurement;
#line 794 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp13_ = index;
#line 794 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14_ = string_substring (_tmp12_, (glong) 0, (glong) _tmp13_);
#line 794 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (resources_lc_measurement);
#line 794 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_lc_measurement = _tmp14_;
#line 2628 "Resources.c"
	}
#line 797 "/home/jens/Source/shotwell/src/Resources.vala"
	resources_unit_system = RESOURCES_UNIT_SYSTEM_METRIC;
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp15_ = resources_lc_measurement;
#line 798 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_vala_string_array_contains (RESOURCES_IMPERIAL_COUNTRIES, G_N_ELEMENTS (RESOURCES_IMPERIAL_COUNTRIES), _tmp15_)) {
#line 799 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_unit_system = RESOURCES_UNIT_SYSTEM_IMPERIAL;
#line 2638 "Resources.c"
	}
#line 802 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp16_ = resources_unit_system;
#line 802 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp16_;
#line 802 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2646 "Resources.c"
}


/**
     * @brief Returns a precached format string that matches the
     * user's LC_TIME settings.  
     */
gchar* resources_get_hh_mm_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 810 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_HH_MM_FORMAT_STRING;
#line 810 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 811 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2665 "Resources.c"
	}
#line 814 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_HH_MM_FORMAT_STRING;
#line 814 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 814 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 814 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2675 "Resources.c"
}


gchar* resources_get_hh_mm_ss_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 818 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_HH_MM_SS_FORMAT_STRING;
#line 818 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 819 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2690 "Resources.c"
	}
#line 822 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_HH_MM_SS_FORMAT_STRING;
#line 822 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 822 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 822 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2700 "Resources.c"
}


gchar* resources_get_long_date_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 826 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_LONG_DATE_FORMAT_STRING;
#line 826 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 827 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2715 "Resources.c"
	}
#line 830 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_LONG_DATE_FORMAT_STRING;
#line 830 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 830 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 830 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2725 "Resources.c"
}


gchar* resources_get_start_multiday_span_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 834 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_START_MULTIDAY_DATE_FORMAT_STRING;
#line 834 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 835 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2740 "Resources.c"
	}
#line 838 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_START_MULTIDAY_DATE_FORMAT_STRING;
#line 838 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 838 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 838 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2750 "Resources.c"
}


gchar* resources_get_end_multiday_span_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 842 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_END_MULTIDAY_DATE_FORMAT_STRING;
#line 842 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 843 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2765 "Resources.c"
	}
#line 846 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_END_MULTIDAY_DATE_FORMAT_STRING;
#line 846 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 846 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 846 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2775 "Resources.c"
}


gchar* resources_get_start_multimonth_span_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 850 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_START_MULTIMONTH_DATE_FORMAT_STRING;
#line 850 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 851 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2790 "Resources.c"
	}
#line 854 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_START_MULTIMONTH_DATE_FORMAT_STRING;
#line 854 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 854 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 854 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2800 "Resources.c"
}


gchar* resources_get_end_multimonth_span_format_string (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 858 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_END_MULTIMONTH_DATE_FORMAT_STRING;
#line 858 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 859 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_fetch_lc_time_format ();
#line 2815 "Resources.c"
	}
#line 862 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = resources_END_MULTIMONTH_DATE_FORMAT_STRING;
#line 862 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 862 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 862 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2825 "Resources.c"
}


gchar* resources_get_ui (const gchar* filename) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 865 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 866 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = filename;
#line 866 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = g_strdup_printf ("/org/gnome/Shotwell/ui/%s", _tmp0_);
#line 866 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp1_;
#line 866 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2843 "Resources.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 882 "/home/jens/Source/shotwell/src/Resources.vala"
	return self ? g_object_ref (self) : NULL;
#line 2850 "Resources.c"
}


GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	GError * _inner_error_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_noninterpretable_badge_pixbuf;
#line 873 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 2864 "Resources.c"
		{
			gchar* path = NULL;
			gchar* _tmp1_;
			GdkPixbuf* _tmp2_ = NULL;
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
#line 875 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp1_ = g_strdup ("/org/gnome/Shotwell/icons/" RESOURCES_NONINTERPRETABLE_BADGE_FILE);
#line 875 "/home/jens/Source/shotwell/src/Resources.vala"
			path = _tmp1_;
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = path;
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = gdk_pixbuf_new_from_resource (_tmp3_, &_inner_error_);
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = _tmp4_;
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
				_g_free0 (path);
#line 2886 "Resources.c"
				goto __catch438_g_error;
			}
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = _tmp2_;
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp2_ = NULL;
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_object_unref0 (resources_noninterpretable_badge_pixbuf);
#line 876 "/home/jens/Source/shotwell/src/Resources.vala"
			resources_noninterpretable_badge_pixbuf = _tmp5_;
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_object_unref0 (_tmp2_);
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (path);
#line 2901 "Resources.c"
		}
		goto __finally438;
		__catch438_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp6_;
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			err = _inner_error_;
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			_inner_error_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp6_ = err->message;
#line 878 "/home/jens/Source/shotwell/src/Resources.vala"
			g_error ("Resources.vala:878: VideoReader can't load noninterpretable badge imag" \
"e: %s", _tmp6_);
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_error_free0 (err);
#line 2918 "Resources.c"
		}
		__finally438:
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			g_clear_error (&_inner_error_);
#line 874 "/home/jens/Source/shotwell/src/Resources.vala"
			return NULL;
#line 2929 "Resources.c"
		}
	}
#line 882 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp7_ = resources_noninterpretable_badge_pixbuf;
#line 882 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 882 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp8_;
#line 882 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2940 "Resources.c"
}


GtkIconTheme* resources_get_icon_theme_engine (void) {
	GtkIconTheme* result = NULL;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
#line 886 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 886 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 886 "/home/jens/Source/shotwell/src/Resources.vala"
	icon_theme = _tmp1_;
#line 887 "/home/jens/Source/shotwell/src/Resources.vala"
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Shotwell/icons");
#line 889 "/home/jens/Source/shotwell/src/Resources.vala"
	result = icon_theme;
#line 889 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 2961 "Resources.c"
}


GdkPixbuf* resources_get_icon (const gchar* name, gint scale) {
	GdkPixbuf* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp10_;
	GdkPixbuf* pixbuf = NULL;
	GeeHashMap* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_;
	GdkPixbuf* _tmp15_;
	gint _tmp22_;
	GdkPixbuf* scaled_pixbuf = NULL;
	GdkPixbuf* _tmp23_;
	gint _tmp24_;
	GdkPixbuf* _tmp25_;
	GeeHashMap* _tmp26_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GdkPixbuf* _tmp33_;
#line 894 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 895 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_scaled_icon_cache;
#line 895 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ != NULL) {
#line 2992 "Resources.c"
		gchar* scaled_name = NULL;
		const gchar* _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_;
#line 896 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1_ = name;
#line 896 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = scale;
#line 896 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp3_ = g_strdup_printf ("%s-%d", _tmp1_, _tmp2_);
#line 896 "/home/jens/Source/shotwell/src/Resources.vala"
		scaled_name = _tmp3_;
#line 897 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp4_ = resources_scaled_icon_cache;
#line 897 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp5_ = scaled_name;
#line 897 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_);
#line 897 "/home/jens/Source/shotwell/src/Resources.vala"
		if (_tmp6_) {
#line 3016 "Resources.c"
			GeeHashMap* _tmp7_;
			const gchar* _tmp8_;
			gpointer _tmp9_;
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp7_ = resources_scaled_icon_cache;
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp8_ = scaled_name;
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			result = (GdkPixbuf*) _tmp9_;
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (scaled_name);
#line 898 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 3032 "Resources.c"
		}
#line 895 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (scaled_name);
#line 3036 "Resources.c"
	}
#line 903 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = resources_icon_cache;
#line 903 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp10_ == NULL) {
#line 3042 "Resources.c"
		GeeHashMap* _tmp11_;
#line 904 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 904 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (resources_icon_cache);
#line 904 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_icon_cache = _tmp11_;
#line 3050 "Resources.c"
	}
#line 907 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp12_ = resources_icon_cache;
#line 907 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp13_ = name;
#line 907 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
#line 907 "/home/jens/Source/shotwell/src/Resources.vala"
	pixbuf = (GdkPixbuf*) _tmp14_;
#line 908 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp15_ = pixbuf;
#line 908 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp15_ == NULL) {
#line 3064 "Resources.c"
		const gchar* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		GdkPixbuf* _tmp21_;
#line 909 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp16_ = name;
#line 909 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp17_ = resources_load_icon (_tmp16_, 0);
#line 909 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (pixbuf);
#line 909 "/home/jens/Source/shotwell/src/Resources.vala"
		pixbuf = _tmp17_;
#line 910 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp18_ = pixbuf;
#line 910 "/home/jens/Source/shotwell/src/Resources.vala"
		if (_tmp18_ == NULL) {
#line 911 "/home/jens/Source/shotwell/src/Resources.vala"
			result = NULL;
#line 911 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_object_unref0 (pixbuf);
#line 911 "/home/jens/Source/shotwell/src/Resources.vala"
			return result;
#line 3089 "Resources.c"
		}
#line 913 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp19_ = resources_icon_cache;
#line 913 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp20_ = name;
#line 913 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp21_ = pixbuf;
#line 913 "/home/jens/Source/shotwell/src/Resources.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_, _tmp21_);
#line 3099 "Resources.c"
	}
#line 916 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp22_ = scale;
#line 916 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp22_ <= 0) {
#line 917 "/home/jens/Source/shotwell/src/Resources.vala"
		result = pixbuf;
#line 917 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 3109 "Resources.c"
	}
#line 919 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp23_ = pixbuf;
#line 919 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp24_ = scale;
#line 919 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp25_ = scale_pixbuf (_tmp23_, _tmp24_, GDK_INTERP_BILINEAR, FALSE);
#line 919 "/home/jens/Source/shotwell/src/Resources.vala"
	scaled_pixbuf = _tmp25_;
#line 921 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp26_ = resources_scaled_icon_cache;
#line 921 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp26_ == NULL) {
#line 3123 "Resources.c"
		GeeHashMap* _tmp27_;
#line 922 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp27_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 922 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (resources_scaled_icon_cache);
#line 922 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_scaled_icon_cache = _tmp27_;
#line 3131 "Resources.c"
	}
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp28_ = resources_scaled_icon_cache;
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp29_ = name;
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp30_ = scale;
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp31_ = g_strdup_printf ("%s-%d", _tmp29_, _tmp30_);
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp32_ = _tmp31_;
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp33_ = scaled_pixbuf;
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp32_, _tmp33_);
#line 924 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp32_);
#line 926 "/home/jens/Source/shotwell/src/Resources.vala"
	result = scaled_pixbuf;
#line 926 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (pixbuf);
#line 926 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 3155 "Resources.c"
}


GdkPixbuf* resources_load_icon (const gchar* name, gint scale) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_ = NULL;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 930 "/home/jens/Source/shotwell/src/Resources.vala"
	pixbuf = NULL;
#line 3170 "Resources.c"
	{
		gchar* path = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 932 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp0_ = name;
#line 932 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1_ = g_strdup_printf ("/org/gnome/Shotwell/icons/%s", _tmp0_);
#line 932 "/home/jens/Source/shotwell/src/Resources.vala"
		path = _tmp1_;
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp3_ = gdk_pixbuf_new_from_resource (path, &_inner_error_);
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = _tmp3_;
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (path);
#line 3192 "Resources.c"
			goto __catch439_g_error;
		}
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp4_ = _tmp2_;
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = NULL;
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (pixbuf);
#line 933 "/home/jens/Source/shotwell/src/Resources.vala"
		pixbuf = _tmp4_;
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp2_);
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (path);
#line 3207 "Resources.c"
	}
	goto __finally439;
	__catch439_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		err = _inner_error_;
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		_inner_error_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp5_ = name;
#line 935 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = err;
#line 935 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = _tmp6_->message;
#line 935 "/home/jens/Source/shotwell/src/Resources.vala"
		g_critical ("Resources.vala:935: Unable to load icon %s: %s", _tmp5_, _tmp7_);
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_error_free0 (err);
#line 3230 "Resources.c"
	}
	__finally439:
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (pixbuf);
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		g_clear_error (&_inner_error_);
#line 931 "/home/jens/Source/shotwell/src/Resources.vala"
		return NULL;
#line 3243 "Resources.c"
	}
#line 938 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp8_ = pixbuf;
#line 938 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp8_ == NULL) {
#line 939 "/home/jens/Source/shotwell/src/Resources.vala"
		result = NULL;
#line 939 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (pixbuf);
#line 939 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 3255 "Resources.c"
	}
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = scale;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp10_ > 0) {
#line 3261 "Resources.c"
		GdkPixbuf* _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp11_ = pixbuf;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp12_ = scale;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp13_ = scale_pixbuf (_tmp11_, _tmp12_, GDK_INTERP_BILINEAR, FALSE);
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp9_);
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp9_ = _tmp13_;
#line 3275 "Resources.c"
	} else {
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14_ = pixbuf;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp9_);
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp9_ = _tmp15_;
#line 3287 "Resources.c"
	}
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp9_;
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (pixbuf);
#line 941 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 3295 "Resources.c"
}


gchar* resources_get_help_path (void) {
	gchar* result = NULL;
	GFile* dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GFile* help_dir = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* help_index = NULL;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gboolean _tmp18_;
#line 951 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = app_dirs_get_exec_dir ();
#line 951 "/home/jens/Source/shotwell/src/Resources.vala"
	dir = _tmp0_;
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = dir;
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = _tmp2_;
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = g_str_has_suffix (_tmp3_, "src");
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp5_ = _tmp4_;
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (_tmp3_);
#line 953 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp5_) {
#line 3337 "Resources.c"
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = dir;
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = g_file_get_parent (_tmp6_);
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp8_ = _tmp7_;
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp9_ = g_file_get_parent (_tmp8_);
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (dir);
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		dir = _tmp9_;
#line 954 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp8_);
#line 3356 "Resources.c"
	}
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp10_ = dir;
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp11_ = g_file_get_child (_tmp10_, "help");
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp12_ = _tmp11_;
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp13_ = g_file_get_child (_tmp12_, "C");
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp14_ = _tmp13_;
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (_tmp12_);
#line 957 "/home/jens/Source/shotwell/src/Resources.vala"
	help_dir = _tmp14_;
#line 958 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp15_ = help_dir;
#line 958 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp16_ = g_file_get_child (_tmp15_, "index.page");
#line 958 "/home/jens/Source/shotwell/src/Resources.vala"
	help_index = _tmp16_;
#line 960 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp17_ = help_index;
#line 960 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp18_ = g_file_query_exists (_tmp17_, NULL);
#line 960 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp18_) {
#line 3384 "Resources.c"
		gchar* help_path = NULL;
		GFile* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gboolean _tmp22_;
#line 963 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp19_ = help_dir;
#line 963 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp20_ = g_file_get_path (_tmp19_);
#line 963 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (help_path);
#line 963 "/home/jens/Source/shotwell/src/Resources.vala"
		help_path = _tmp20_;
#line 965 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp21_ = help_path;
#line 965 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp22_ = g_str_has_suffix (_tmp21_, "/");
#line 965 "/home/jens/Source/shotwell/src/Resources.vala"
		if (!_tmp22_) {
#line 3404 "Resources.c"
			const gchar* _tmp23_;
			gchar* _tmp24_;
#line 966 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp23_ = help_path;
#line 966 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp24_ = g_strconcat (_tmp23_, "/", NULL);
#line 966 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 966 "/home/jens/Source/shotwell/src/Resources.vala"
			help_path = _tmp24_;
#line 3415 "Resources.c"
		}
#line 969 "/home/jens/Source/shotwell/src/Resources.vala"
		result = help_path;
#line 969 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (help_index);
#line 969 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (help_dir);
#line 969 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (dir);
#line 969 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 3427 "Resources.c"
	}
#line 975 "/home/jens/Source/shotwell/src/Resources.vala"
	result = NULL;
#line 975 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (help_index);
#line 975 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (help_dir);
#line 975 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (dir);
#line 975 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 3439 "Resources.c"
}


void resources_launch_help (GdkScreen* screen, const gchar* anchor, GError** error) {
	gchar* help_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp27_;
	GError * _inner_error_ = NULL;
#line 978 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_if_fail (GDK_IS_SCREEN (screen));
#line 979 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_get_help_path ();
#line 979 "/home/jens/Source/shotwell/src/Resources.vala"
	help_path = _tmp0_;
#line 981 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = help_path;
#line 981 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp1_ != NULL) {
#line 3459 "Resources.c"
		const gchar* _tmp2_;
		gchar** argv = NULL;
		gchar** _tmp6_;
		gint argv_length1;
		gint _argv_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		GPid pid = 0;
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		GPid _tmp22_ = 0;
		gboolean _tmp23_;
		gboolean _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
#line 985 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = anchor;
#line 985 "/home/jens/Source/shotwell/src/Resources.vala"
		if (_tmp2_ != NULL) {
#line 3495 "Resources.c"
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 986 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp3_ = help_path;
#line 986 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp4_ = anchor;
#line 986 "/home/jens/Source/shotwell/src/Resources.vala"
			_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
#line 986 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 986 "/home/jens/Source/shotwell/src/Resources.vala"
			help_path = _tmp5_;
#line 3509 "Resources.c"
		}
#line 989 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = g_new0 (gchar*, 3 + 1);
#line 989 "/home/jens/Source/shotwell/src/Resources.vala"
		argv = _tmp6_;
#line 989 "/home/jens/Source/shotwell/src/Resources.vala"
		argv_length1 = 3;
#line 989 "/home/jens/Source/shotwell/src/Resources.vala"
		_argv_size_ = argv_length1;
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = argv;
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7__length1 = argv_length1;
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp8_ = g_strdup ("yelp");
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp7_[0]);
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_[0] = _tmp8_;
#line 990 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp9_ = _tmp7_[0];
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp10_ = argv;
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp10__length1 = argv_length1;
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp11_ = help_path;
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp10_[1]);
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp10_[1] = _tmp12_;
#line 991 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp13_ = _tmp10_[1];
#line 992 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14_ = argv;
#line 992 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14__length1 = argv_length1;
#line 992 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp14_[2]);
#line 992 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14_[2] = NULL;
#line 992 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp15_ = _tmp14_[2];
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp17_ = app_dirs_get_exec_dir ();
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp18_ = _tmp17_;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp20_ = _tmp19_;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp21_ = argv;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp21__length1 = argv_length1;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp23_ = g_spawn_async (_tmp20_, _tmp21_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp22_, &_inner_error_);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		pid = _tmp22_;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp24_ = _tmp23_;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp20_);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp18_);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp16_ = _tmp24_;
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
			g_propagate_error (error, _inner_error_);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
			return;
#line 3589 "Resources.c"
		}
#line 995 "/home/jens/Source/shotwell/src/Resources.vala"
		if (_tmp16_) {
#line 997 "/home/jens/Source/shotwell/src/Resources.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 997 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 997 "/home/jens/Source/shotwell/src/Resources.vala"
			return;
#line 3599 "Resources.c"
		}
#line 1000 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp25_ = argv;
#line 1000 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp25__length1 = argv_length1;
#line 1000 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp26_ = _tmp25_[0];
#line 1000 "/home/jens/Source/shotwell/src/Resources.vala"
		g_warning ("Resources.vala:1000: Unable to launch %s", _tmp26_);
#line 981 "/home/jens/Source/shotwell/src/Resources.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 3611 "Resources.c"
	}
#line 1004 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp27_ = anchor;
#line 1004 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp27_ != NULL) {
#line 3617 "Resources.c"
		GdkScreen* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp28_ = screen;
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp29_ = anchor;
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp30_ = g_strconcat ("help:shotwell", _tmp29_, NULL);
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp31_ = _tmp30_;
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		sys_show_uri (_tmp28_, _tmp31_, &_inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_free0 (_tmp31_);
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
			g_propagate_error (error, _inner_error_);
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 1005 "/home/jens/Source/shotwell/src/Resources.vala"
			return;
#line 3642 "Resources.c"
		}
	} else {
		GdkScreen* _tmp32_;
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp32_ = screen;
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
		sys_show_uri (_tmp32_, "help:shotwell", &_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
			g_propagate_error (error, _inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
			_g_free0 (help_path);
#line 1007 "/home/jens/Source/shotwell/src/Resources.vala"
			return;
#line 3658 "Resources.c"
		}
	}
#line 978 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_free0 (help_path);
#line 3663 "Resources.c"
}


gchar* resources_to_css_color (GdkRGBA* color) {
	gchar* result = NULL;
	gint r = 0;
	GdkRGBA _tmp0_;
	gdouble _tmp1_;
	gint g = 0;
	GdkRGBA _tmp2_;
	gdouble _tmp3_;
	gint b = 0;
	GdkRGBA _tmp4_;
	gdouble _tmp5_;
	gchar* _tmp6_;
#line 1011 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 1012 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = *color;
#line 1012 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = _tmp0_.red;
#line 1012 "/home/jens/Source/shotwell/src/Resources.vala"
	r = (gint) (_tmp1_ * 255);
#line 1013 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = *color;
#line 1013 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = _tmp2_.green;
#line 1013 "/home/jens/Source/shotwell/src/Resources.vala"
	g = (gint) (_tmp3_ * 255);
#line 1014 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = *color;
#line 1014 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp5_ = _tmp4_.blue;
#line 1014 "/home/jens/Source/shotwell/src/Resources.vala"
	b = (gint) (_tmp5_ * 255);
#line 1016 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp6_ = g_strdup_printf ("rgb(%d, %d, %d)", r, g, b);
#line 1016 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp6_;
#line 1016 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 3705 "Resources.c"
}


void resources_style_widget (GtkWidget* widget, const gchar* stylesheet) {
	GeeMap* _tmp0_;
	GeeMap* _tmp2_;
	GtkWidget* _tmp3_;
	gboolean _tmp4_;
	GtkCssProvider* styler = NULL;
	GtkCssProvider* _tmp11_;
	GtkWidget* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkCssProvider* _tmp19_;
	GeeMap* _tmp20_;
	GtkWidget* _tmp21_;
	GtkCssProvider* _tmp22_;
	GError * _inner_error_ = NULL;
#line 1023 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 1023 "/home/jens/Source/shotwell/src/Resources.vala"
	g_return_if_fail (stylesheet != NULL);
#line 1024 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = resources_providers;
#line 1024 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ == NULL) {
#line 3731 "Resources.c"
		GeeHashMap* _tmp1_;
#line 1025 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp1_ = gee_hash_map_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GTK_TYPE_CSS_PROVIDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1025 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (resources_providers);
#line 1025 "/home/jens/Source/shotwell/src/Resources.vala"
		resources_providers = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
#line 3739 "Resources.c"
	}
#line 1027 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp2_ = resources_providers;
#line 1027 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = widget;
#line 1027 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
#line 1027 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp4_) {
#line 3749 "Resources.c"
		GtkWidget* _tmp5_;
		GtkStyleContext* _tmp6_;
		GeeMap* _tmp7_;
		GtkWidget* _tmp8_;
		gpointer _tmp9_;
		GtkCssProvider* _tmp10_;
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp5_ = widget;
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp6_ = gtk_widget_get_style_context (_tmp5_);
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp7_ = resources_providers;
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp8_ = widget;
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp9_ = gee_map_get (_tmp7_, _tmp8_);
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp10_ = (GtkCssProvider*) _tmp9_;
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		gtk_style_context_remove_provider (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider));
#line 1028 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (_tmp10_);
#line 3772 "Resources.c"
	}
#line 1030 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp11_ = gtk_css_provider_new ();
#line 1030 "/home/jens/Source/shotwell/src/Resources.vala"
	styler = _tmp11_;
#line 3778 "Resources.c"
	{
		GtkCssProvider* _tmp12_;
		const gchar* _tmp13_;
#line 1033 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp12_ = styler;
#line 1033 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp13_ = stylesheet;
#line 1033 "/home/jens/Source/shotwell/src/Resources.vala"
		gtk_css_provider_load_from_data (_tmp12_, _tmp13_, (gssize) RESOURCES_ALL_DATA, &_inner_error_);
#line 1033 "/home/jens/Source/shotwell/src/Resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3790 "Resources.c"
			goto __catch440_g_error;
		}
	}
	goto __finally440;
	__catch440_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		e = _inner_error_;
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		_inner_error_ = NULL;
#line 1035 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp14_ = stylesheet;
#line 1035 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp15_ = e;
#line 1035 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp16_ = _tmp15_->message;
#line 1035 "/home/jens/Source/shotwell/src/Resources.vala"
		g_warning ("Resources.vala:1035: couldn't parse widget stylesheet '%s': %s", _tmp14_, _tmp16_);
#line 1039 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_error_free0 (e);
#line 1039 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (styler);
#line 1039 "/home/jens/Source/shotwell/src/Resources.vala"
		return;
#line 3819 "Resources.c"
	}
	__finally440:
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		_g_object_unref0 (styler);
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		g_clear_error (&_inner_error_);
#line 1032 "/home/jens/Source/shotwell/src/Resources.vala"
		return;
#line 3832 "Resources.c"
	}
#line 1042 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp17_ = widget;
#line 1042 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp18_ = gtk_widget_get_style_context (_tmp17_);
#line 1042 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp19_ = styler;
#line 1042 "/home/jens/Source/shotwell/src/Resources.vala"
	gtk_style_context_add_provider (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_STYLE_PROVIDER, GtkStyleProvider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 1045 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp20_ = resources_providers;
#line 1045 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp21_ = widget;
#line 1045 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp22_ = styler;
#line 1045 "/home/jens/Source/shotwell/src/Resources.vala"
	gee_map_set (_tmp20_, _tmp21_, _tmp22_);
#line 1023 "/home/jens/Source/shotwell/src/Resources.vala"
	_g_object_unref0 (styler);
#line 3852 "Resources.c"
}


gint resources_use_header_bar (void) {
	gint result = 0;
	const gchar* _tmp0_;
	gboolean use_header = FALSE;
	GtkSettings* _tmp1_;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
#line 1049 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp0_ = g_getenv ("SHOTWELL_USE_HEADERBARS");
#line 1049 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp0_ != NULL) {
#line 1050 "/home/jens/Source/shotwell/src/Resources.vala"
		result = 0;
#line 1050 "/home/jens/Source/shotwell/src/Resources.vala"
		return result;
#line 3871 "Resources.c"
	}
#line 1054 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp1_ = gtk_settings_get_default ();
#line 1054 "/home/jens/Source/shotwell/src/Resources.vala"
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "gtk-dialogs-use-header", &use_header, NULL);
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
	_tmp3_ = use_header;
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
	if (_tmp3_) {
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = 1;
#line 3883 "Resources.c"
	} else {
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
		_tmp2_ = 0;
#line 3887 "Resources.c"
	}
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
	result = _tmp2_;
#line 1056 "/home/jens/Source/shotwell/src/Resources.vala"
	return result;
#line 3893 "Resources.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



