/* ColorTransformation.c generated by valac 0.36.6, the Vala compiler
 * generated from ColorTransformation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_RGB_ANALYTIC_PIXEL (rgb_analytic_pixel_get_type ())
typedef struct _RGBAnalyticPixel RGBAnalyticPixel;

#define TYPE_HSV_ANALYTIC_PIXEL (hsv_analytic_pixel_get_type ())
typedef struct _HSVAnalyticPixel HSVAnalyticPixel;

#define TYPE_COMPOSITION_MODE (composition_mode_get_type ())

#define TYPE_PIXEL_FORMAT (pixel_format_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_TYPE (pixel_transformation_type_get_type ())

#define TYPE_PIXEL_TRANSFORMATION_BUNDLE (pixel_transformation_bundle_get_type ())
#define PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle))
#define PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))
#define IS_PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define IS_PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))

typedef struct _PixelTransformationBundle PixelTransformationBundle;
typedef struct _PixelTransformationBundleClass PixelTransformationBundleClass;
typedef struct _PixelTransformationBundlePrivate PixelTransformationBundlePrivate;

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))

#define TYPE_HSV_TRANSFORMATION (hsv_transformation_get_type ())
#define HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformation))
#define HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))
#define IS_HSV_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSV_TRANSFORMATION))
#define IS_HSV_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSV_TRANSFORMATION))
#define HSV_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSV_TRANSFORMATION, HSVTransformationClass))

typedef struct _HSVTransformation HSVTransformation;
typedef struct _HSVTransformationClass HSVTransformationClass;

#define TYPE_EXPANSION_TRANSFORMATION (expansion_transformation_get_type ())
#define EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation))
#define EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))
#define IS_EXPANSION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPANSION_TRANSFORMATION))
#define IS_EXPANSION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPANSION_TRANSFORMATION))
#define EXPANSION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationClass))

typedef struct _ExpansionTransformation ExpansionTransformation;
typedef struct _ExpansionTransformationClass ExpansionTransformationClass;
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define TYPE_SHADOW_DETAIL_TRANSFORMATION (shadow_detail_transformation_get_type ())
#define SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation))
#define SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))
#define IS_SHADOW_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define IS_SHADOW_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHADOW_DETAIL_TRANSFORMATION))
#define SHADOW_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationClass))

typedef struct _ShadowDetailTransformation ShadowDetailTransformation;
typedef struct _ShadowDetailTransformationClass ShadowDetailTransformationClass;

#define TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION (highlight_detail_transformation_get_type ())
#define HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define IS_HIGHLIGHT_DETAIL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION))
#define HIGHLIGHT_DETAIL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationClass))

typedef struct _HighlightDetailTransformation HighlightDetailTransformation;
typedef struct _HighlightDetailTransformationClass HighlightDetailTransformationClass;

#define TYPE_RGB_TRANSFORMATION (rgb_transformation_get_type ())
#define RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformation))
#define RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))
#define IS_RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_TRANSFORMATION))
#define IS_RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_TRANSFORMATION))
#define RGB_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))

typedef struct _RGBTransformation RGBTransformation;
typedef struct _RGBTransformationClass RGBTransformationClass;

#define TYPE_TEMPERATURE_TRANSFORMATION (temperature_transformation_get_type ())
#define TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation))
#define TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))
#define IS_TEMPERATURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPERATURE_TRANSFORMATION))
#define IS_TEMPERATURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPERATURE_TRANSFORMATION))
#define TEMPERATURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationClass))

typedef struct _TemperatureTransformation TemperatureTransformation;
typedef struct _TemperatureTransformationClass TemperatureTransformationClass;

#define TYPE_TINT_TRANSFORMATION (tint_transformation_get_type ())
#define TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TINT_TRANSFORMATION, TintTransformation))
#define TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TINT_TRANSFORMATION, TintTransformationClass))
#define IS_TINT_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TINT_TRANSFORMATION))
#define IS_TINT_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TINT_TRANSFORMATION))
#define TINT_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TINT_TRANSFORMATION, TintTransformationClass))

typedef struct _TintTransformation TintTransformation;
typedef struct _TintTransformationClass TintTransformationClass;

#define TYPE_SATURATION_TRANSFORMATION (saturation_transformation_get_type ())
#define SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformation))
#define SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))
#define IS_SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SATURATION_TRANSFORMATION))
#define IS_SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SATURATION_TRANSFORMATION))
#define SATURATION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))

typedef struct _SaturationTransformation SaturationTransformation;
typedef struct _SaturationTransformationClass SaturationTransformationClass;

#define TYPE_EXPOSURE_TRANSFORMATION (exposure_transformation_get_type ())
#define EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation))
#define EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))
#define IS_EXPOSURE_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPOSURE_TRANSFORMATION))
#define IS_EXPOSURE_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPOSURE_TRANSFORMATION))
#define EXPOSURE_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationClass))

typedef struct _ExposureTransformation ExposureTransformation;
typedef struct _ExposureTransformationClass ExposureTransformationClass;

#define TYPE_CONTRAST_TRANSFORMATION (contrast_transformation_get_type ())
#define CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation))
#define CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))
#define IS_CONTRAST_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTRAST_TRANSFORMATION))
#define IS_CONTRAST_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTRAST_TRANSFORMATION))
#define CONTRAST_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationClass))

typedef struct _ContrastTransformation ContrastTransformation;
typedef struct _ContrastTransformationClass ContrastTransformationClass;

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
typedef struct _ParamSpecPixelTransformationBundle ParamSpecPixelTransformationBundle;
typedef struct _PixelTransformationPrivate PixelTransformationPrivate;
typedef struct _ParamSpecPixelTransformation ParamSpecPixelTransformation;
typedef struct _RGBTransformationPrivate RGBTransformationPrivate;
typedef struct _HSVTransformationPrivate HSVTransformationPrivate;
typedef struct _TintTransformationPrivate TintTransformationPrivate;
typedef struct _TemperatureTransformationPrivate TemperatureTransformationPrivate;
typedef struct _SaturationTransformationPrivate SaturationTransformationPrivate;
typedef struct _ExposureTransformationPrivate ExposureTransformationPrivate;
typedef struct _ContrastTransformationPrivate ContrastTransformationPrivate;
typedef struct _PixelTransformerPrivate PixelTransformerPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _ParamSpecPixelTransformer ParamSpecPixelTransformer;

#define TYPE_RGB_HISTOGRAM (rgb_histogram_get_type ())
#define RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM, RGBHistogram))
#define RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM, RGBHistogramClass))
#define IS_RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM))
#define IS_RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM))
#define RGB_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM, RGBHistogramClass))

typedef struct _RGBHistogram RGBHistogram;
typedef struct _RGBHistogramClass RGBHistogramClass;
typedef struct _RGBHistogramPrivate RGBHistogramPrivate;
typedef struct _ParamSpecRGBHistogram ParamSpecRGBHistogram;

#define TYPE_INTENSITY_HISTOGRAM (intensity_histogram_get_type ())
#define INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogram))
#define INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))
#define IS_INTENSITY_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INTENSITY_HISTOGRAM))
#define IS_INTENSITY_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INTENSITY_HISTOGRAM))
#define INTENSITY_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramClass))

typedef struct _IntensityHistogram IntensityHistogram;
typedef struct _IntensityHistogramClass IntensityHistogramClass;
typedef struct _IntensityHistogramPrivate IntensityHistogramPrivate;
typedef struct _ParamSpecIntensityHistogram ParamSpecIntensityHistogram;
typedef struct _ExpansionTransformationPrivate ExpansionTransformationPrivate;
typedef struct _ShadowDetailTransformationPrivate ShadowDetailTransformationPrivate;

#define TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION (hermite_gamma_approximation_function_get_type ())
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define IS_HERMITE_GAMMA_APPROXIMATION_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION))
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionClass))

typedef struct _HermiteGammaApproximationFunction HermiteGammaApproximationFunction;
typedef struct _HermiteGammaApproximationFunctionClass HermiteGammaApproximationFunctionClass;
#define _hermite_gamma_approximation_function_unref0(var) ((var == NULL) ? NULL : (var = (hermite_gamma_approximation_function_unref (var), NULL)))
typedef struct _HermiteGammaApproximationFunctionPrivate HermiteGammaApproximationFunctionPrivate;
typedef struct _ParamSpecHermiteGammaApproximationFunction ParamSpecHermiteGammaApproximationFunction;
typedef struct _HighlightDetailTransformationPrivate HighlightDetailTransformationPrivate;
#define _intensity_histogram_unref0(var) ((var == NULL) ? NULL : (var = (intensity_histogram_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RGBAnalyticPixel {
	gfloat red;
	gfloat green;
	gfloat blue;
};

struct _HSVAnalyticPixel {
	gfloat hue;
	gfloat saturation;
	gfloat light_value;
};

typedef enum  {
	COMPOSITION_MODE_NONE,
	COMPOSITION_MODE_RGB_MATRIX,
	COMPOSITION_MODE_HSV_LOOKUP
} CompositionMode;

typedef enum  {
	PIXEL_FORMAT_RGB,
	PIXEL_FORMAT_HSV
} PixelFormat;

typedef enum  {
	PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION,
	PIXEL_TRANSFORMATION_TYPE_SHADOWS,
	PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS,
	PIXEL_TRANSFORMATION_TYPE_TEMPERATURE,
	PIXEL_TRANSFORMATION_TYPE_TINT,
	PIXEL_TRANSFORMATION_TYPE_SATURATION,
	PIXEL_TRANSFORMATION_TYPE_EXPOSURE,
	PIXEL_TRANSFORMATION_TYPE_CONTRAST
} PixelTransformationType;

struct _PixelTransformationBundle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationBundlePrivate * priv;
};

struct _PixelTransformationBundleClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformationBundle *self);
};

struct _PixelTransformationBundlePrivate {
	GeeHashMap* map;
};

struct _ParamSpecPixelTransformationBundle {
	GParamSpec parent_instance;
};

struct _PixelTransformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformationPrivate * priv;
};

struct _PixelTransformationClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformation *self);
	CompositionMode (*get_composition_mode) (PixelTransformation* self);
	void (*compose_with) (PixelTransformation* self, PixelTransformation* other);
	gboolean (*is_identity) (PixelTransformation* self);
	void (*transform_pixel_hsv) (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
	void (*transform_pixel_rgb) (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
	gchar* (*to_string) (PixelTransformation* self);
	PixelTransformation* (*copy) (PixelTransformation* self);
};

struct _PixelTransformationPrivate {
	PixelTransformationType type;
	PixelFormat preferred_format;
};

struct _ParamSpecPixelTransformation {
	GParamSpec parent_instance;
};

struct _RGBTransformation {
	PixelTransformation parent_instance;
	RGBTransformationPrivate * priv;
	gfloat* matrix_entries;
	gint matrix_entries_length1;
	gboolean identity;
};

struct _RGBTransformationClass {
	PixelTransformationClass parent_class;
};

struct _HSVTransformation {
	PixelTransformation parent_instance;
	HSVTransformationPrivate * priv;
	gfloat remap_table[256];
};

struct _HSVTransformationClass {
	PixelTransformationClass parent_class;
};

struct _TintTransformation {
	RGBTransformation parent_instance;
	TintTransformationPrivate * priv;
};

struct _TintTransformationClass {
	RGBTransformationClass parent_class;
};

struct _TintTransformationPrivate {
	gfloat parameter;
};

struct _TemperatureTransformation {
	RGBTransformation parent_instance;
	TemperatureTransformationPrivate * priv;
};

struct _TemperatureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _TemperatureTransformationPrivate {
	gfloat parameter;
};

struct _SaturationTransformation {
	RGBTransformation parent_instance;
	SaturationTransformationPrivate * priv;
};

struct _SaturationTransformationClass {
	RGBTransformationClass parent_class;
};

struct _SaturationTransformationPrivate {
	gfloat parameter;
};

struct _ExposureTransformation {
	RGBTransformation parent_instance;
	ExposureTransformationPrivate * priv;
};

struct _ExposureTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ExposureTransformationPrivate {
	gfloat parameter;
};

struct _ContrastTransformation {
	RGBTransformation parent_instance;
	ContrastTransformationPrivate * priv;
};

struct _ContrastTransformationClass {
	RGBTransformationClass parent_class;
};

struct _ContrastTransformationPrivate {
	gfloat parameter;
};

struct _PixelTransformer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixelTransformerPrivate * priv;
	PixelTransformation** optimized_transformations;
	gint optimized_transformations_length1;
	gint optimized_slots_used;
};

struct _PixelTransformerClass {
	GTypeClass parent_class;
	void (*finalize) (PixelTransformer *self);
};

struct _PixelTransformerPrivate {
	GeeArrayList* transformations;
};

struct _Block1Data {
	int _ref_count_;
	PixelTransformer* self;
	gint dest_width;
	gint dest_num_channels;
	gint dest_rowstride;
	guchar* dest_pixels;
	gint dest_pixels_length1;
	gint _dest_pixels_size_;
	gfloat* cache;
	gint cache_length1;
	gint _cache_size_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	guint row;
	guint slice_height;
};

struct _Block3Data {
	int _ref_count_;
	PixelTransformer* self;
	gint n_channels;
	gint rowstride;
	gint rowbytes;
	guchar* source_pixels;
	gint source_pixels_length1;
	gint _source_pixels_size_;
	guchar* dest_pixels;
	gint dest_pixels_length1;
	gint _dest_pixels_size_;
	GCancellable* cancellable;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	guint row;
	guint slice_height;
};

struct _ParamSpecPixelTransformer {
	GParamSpec parent_instance;
};

struct _RGBHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RGBHistogramPrivate * priv;
};

struct _RGBHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (RGBHistogram *self);
};

struct _RGBHistogramPrivate {
	gint* red_counts;
	gint red_counts_length1;
	gint _red_counts_size_;
	gint* green_counts;
	gint green_counts_length1;
	gint _green_counts_size_;
	gint* blue_counts;
	gint blue_counts_length1;
	gint _blue_counts_size_;
	gint* qualitative_red_counts;
	gint qualitative_red_counts_length1;
	gint _qualitative_red_counts_size_;
	gint* qualitative_green_counts;
	gint qualitative_green_counts_length1;
	gint _qualitative_green_counts_size_;
	gint* qualitative_blue_counts;
	gint qualitative_blue_counts_length1;
	gint _qualitative_blue_counts_size_;
	GdkPixbuf* graphic;
};

struct _ParamSpecRGBHistogram {
	GParamSpec parent_instance;
};

struct _IntensityHistogram {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IntensityHistogramPrivate * priv;
};

struct _IntensityHistogramClass {
	GTypeClass parent_class;
	void (*finalize) (IntensityHistogram *self);
};

struct _IntensityHistogramPrivate {
	gint* counts;
	gint counts_length1;
	gint _counts_size_;
	gfloat* probabilities;
	gint probabilities_length1;
	gint _probabilities_size_;
	gfloat* cumulative_probabilities;
	gint cumulative_probabilities_length1;
	gint _cumulative_probabilities_size_;
};

struct _ParamSpecIntensityHistogram {
	GParamSpec parent_instance;
};

struct _ExpansionTransformation {
	HSVTransformation parent_instance;
	ExpansionTransformationPrivate * priv;
};

struct _ExpansionTransformationClass {
	HSVTransformationClass parent_class;
};

struct _ExpansionTransformationPrivate {
	gint low_kink;
	gint high_kink;
};

struct _ShadowDetailTransformation {
	HSVTransformation parent_instance;
	ShadowDetailTransformationPrivate * priv;
};

struct _ShadowDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _ShadowDetailTransformationPrivate {
	gfloat intensity;
};

struct _HermiteGammaApproximationFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HermiteGammaApproximationFunctionPrivate * priv;
};

struct _HermiteGammaApproximationFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (HermiteGammaApproximationFunction *self);
};

struct _HermiteGammaApproximationFunctionPrivate {
	gfloat x_scale;
	gfloat nonzero_interval_upper;
};

struct _ParamSpecHermiteGammaApproximationFunction {
	GParamSpec parent_instance;
};

struct _HighlightDetailTransformation {
	HSVTransformation parent_instance;
	HighlightDetailTransformationPrivate * priv;
};

struct _HighlightDetailTransformationClass {
	HSVTransformationClass parent_class;
};

struct _HighlightDetailTransformationPrivate {
	gfloat intensity;
};


static gpointer pixel_transformation_bundle_parent_class = NULL;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments;
static PixelTransformationBundle* pixel_transformation_bundle_copied_color_adjustments = NULL;
static gpointer pixel_transformation_parent_class = NULL;
static gpointer rgb_transformation_parent_class = NULL;
static gpointer hsv_transformation_parent_class = NULL;
static gpointer tint_transformation_parent_class = NULL;
static gpointer temperature_transformation_parent_class = NULL;
static gpointer saturation_transformation_parent_class = NULL;
static gpointer exposure_transformation_parent_class = NULL;
static gpointer contrast_transformation_parent_class = NULL;
static gpointer pixel_transformer_parent_class = NULL;
static gpointer rgb_histogram_parent_class = NULL;
static gpointer intensity_histogram_parent_class = NULL;
static gpointer expansion_transformation_parent_class = NULL;
static gpointer shadow_detail_transformation_parent_class = NULL;
static gpointer hermite_gamma_approximation_function_parent_class = NULL;
static gpointer highlight_detail_transformation_parent_class = NULL;

GType rgb_analytic_pixel_get_type (void) G_GNUC_CONST;
RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self);
void rgb_analytic_pixel_free (RGBAnalyticPixel* self);
#define RGB_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
void rgb_analytic_pixel_init (RGBAnalyticPixel *self);
void rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self, gfloat red, gfloat green, gfloat blue);
void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self, guchar red_quantized, guchar green_quantized, guchar blue_quantized);
GType hsv_analytic_pixel_get_type (void) G_GNUC_CONST;
HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self);
void hsv_analytic_pixel_free (HSVAnalyticPixel* self);
void rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* hsv_pixel);
void hsv_analytic_pixel_to_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* result);
guchar rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self);
guchar rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self);
gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self, RGBAnalyticPixel* rhs);
guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self);
void rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* result);
void hsv_analytic_pixel_init_from_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* p);
#define HSV_ANALYTIC_PIXEL_INV_255 (1.0f / 255.0f)
void hsv_analytic_pixel_init (HSVAnalyticPixel *self);
void hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self, gfloat hue, gfloat saturation, gfloat light_value);
void hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self, guchar hue_quantized, guchar saturation_quantized, guchar light_value_quantized);
gboolean hsv_analytic_pixel_equals (HSVAnalyticPixel *self, HSVAnalyticPixel* rhs);
guint hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self);
GType composition_mode_get_type (void) G_GNUC_CONST;
GType pixel_format_get_type (void) G_GNUC_CONST;
GType pixel_transformation_type_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_bundle_ref (gpointer instance);
void pixel_transformation_bundle_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object);
void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation_bundle (const GValue* value);
GType pixel_transformation_bundle_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation (GValue* value, gpointer v_object);
void value_take_pixel_transformation (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
#define PIXEL_TRANSFORMATION_BUNDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundlePrivate))
enum  {
	PIXEL_TRANSFORMATION_BUNDLE_DUMMY_PROPERTY
};
PixelTransformationBundle* pixel_transformation_bundle_new (void);
PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type);
PixelTransformationBundle* pixel_transformation_bundle_get_copied_color_adjustments (void);
void pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments);
gboolean pixel_transformation_bundle_has_copied_color_adjustments (void);
void pixel_transformation_bundle_set (PixelTransformationBundle* self, PixelTransformation* transformation);
PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self);
void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self);
ExpansionTransformation* expansion_transformation_new_from_extrema (gint black_point, gint white_point);
ExpansionTransformation* expansion_transformation_construct_from_extrema (GType object_type, gint black_point, gint white_point);
GType hsv_transformation_get_type (void) G_GNUC_CONST;
GType expansion_transformation_get_type (void) G_GNUC_CONST;
ShadowDetailTransformation* shadow_detail_transformation_new (gfloat user_intensity);
ShadowDetailTransformation* shadow_detail_transformation_construct (GType object_type, gfloat user_intensity);
GType shadow_detail_transformation_get_type (void) G_GNUC_CONST;
HighlightDetailTransformation* highlight_detail_transformation_new (gfloat user_intensity);
HighlightDetailTransformation* highlight_detail_transformation_construct (GType object_type, gfloat user_intensity);
GType highlight_detail_transformation_get_type (void) G_GNUC_CONST;
TemperatureTransformation* temperature_transformation_new (gfloat client_parameter);
TemperatureTransformation* temperature_transformation_construct (GType object_type, gfloat client_parameter);
GType rgb_transformation_get_type (void) G_GNUC_CONST;
GType temperature_transformation_get_type (void) G_GNUC_CONST;
TintTransformation* tint_transformation_new (gfloat client_param);
TintTransformation* tint_transformation_construct (GType object_type, gfloat client_param);
GType tint_transformation_get_type (void) G_GNUC_CONST;
SaturationTransformation* saturation_transformation_new (gfloat client_parameter);
SaturationTransformation* saturation_transformation_construct (GType object_type, gfloat client_parameter);
GType saturation_transformation_get_type (void) G_GNUC_CONST;
ExposureTransformation* exposure_transformation_new (gfloat client_parameter);
ExposureTransformation* exposure_transformation_construct (GType object_type, gfloat client_parameter);
GType exposure_transformation_get_type (void) G_GNUC_CONST;
ContrastTransformation* contrast_transformation_new (gfloat client_parameter);
ContrastTransformation* contrast_transformation_construct (GType object_type, gfloat client_parameter);
GType contrast_transformation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store);
gchar* key_value_map_get_string (KeyValueMap* self, const gchar* key, const gchar* def);
ExpansionTransformation* expansion_transformation_new_from_string (const gchar* encoded_transformation);
ExpansionTransformation* expansion_transformation_construct_from_string (GType object_type, const gchar* encoded_transformation);
gfloat key_value_map_get_float (KeyValueMap* self, const gchar* key, gfloat def);
KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type, const gchar* group);
PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type);
void key_value_map_set_string (KeyValueMap* self, const gchar* key, const gchar* value);
gchar* pixel_transformation_to_string (PixelTransformation* self);
void key_value_map_set_float (KeyValueMap* self, const gchar* key, gfloat value);
gfloat shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self);
gfloat highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self);
gfloat temperature_transformation_get_parameter (TemperatureTransformation* self);
gfloat tint_transformation_get_parameter (TintTransformation* self);
gfloat saturation_transformation_get_parameter (SaturationTransformation* self);
gfloat exposure_transformation_get_parameter (ExposureTransformation* self);
gfloat contrast_transformation_get_parameter (ContrastTransformation* self);
gint pixel_transformation_bundle_get_count (PixelTransformationBundle* self);
GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self);
gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self);
gboolean pixel_transformation_is_identity (PixelTransformation* self);
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformer (GValue* value, gpointer v_object);
void value_take_pixel_transformer (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self);
PixelTransformer* pixel_transformer_new (void);
PixelTransformer* pixel_transformer_construct (GType object_type);
void pixel_transformer_attach_transformation (PixelTransformer* self, PixelTransformation* trans);
PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self);
static void pixel_transformation_bundle_finalize (PixelTransformationBundle * obj);
#define PIXEL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMATION, PixelTransformationPrivate))
enum  {
	PIXEL_TRANSFORMATION_DUMMY_PROPERTY
};
PixelTransformation* pixel_transformation_construct (GType object_type, PixelTransformationType type, PixelFormat preferred_format);
PixelFormat pixel_transformation_get_preferred_format (PixelTransformation* self);
CompositionMode pixel_transformation_get_composition_mode (PixelTransformation* self);
static CompositionMode pixel_transformation_real_get_composition_mode (PixelTransformation* self);
void pixel_transformation_compose_with (PixelTransformation* self, PixelTransformation* other);
static void pixel_transformation_real_compose_with (PixelTransformation* self, PixelTransformation* other);
static gboolean pixel_transformation_real_is_identity (PixelTransformation* self);
void pixel_transformation_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
static void pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
void pixel_transformation_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static void pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static gchar* pixel_transformation_real_to_string (PixelTransformation* self);
PixelTransformation* pixel_transformation_copy (PixelTransformation* self);
static PixelTransformation* pixel_transformation_real_copy (PixelTransformation* self);
static void pixel_transformation_finalize (PixelTransformation * obj);
enum  {
	RGB_TRANSFORMATION_DUMMY_PROPERTY
};
#define RGB_TRANSFORMATION_MATRIX_SIZE 16
RGBTransformation* rgb_transformation_new (PixelTransformationType type);
RGBTransformation* rgb_transformation_construct (GType object_type, PixelTransformationType type);
static CompositionMode rgb_transformation_real_get_composition_mode (PixelTransformation* base);
static void rgb_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other);
static void rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* p, HSVAnalyticPixel* result);
static void rgb_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static gboolean rgb_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* rgb_transformation_real_copy (PixelTransformation* base);
static void rgb_transformation_finalize (PixelTransformation * obj);
enum  {
	HSV_TRANSFORMATION_DUMMY_PROPERTY
};
HSVTransformation* hsv_transformation_construct (GType object_type, PixelTransformationType type);
static CompositionMode hsv_transformation_real_get_composition_mode (PixelTransformation* base);
static void hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
static void hsv_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other);
static void hsv_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result);
static void hsv_transformation_finalize (PixelTransformation * obj);
#define TINT_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TINT_TRANSFORMATION, TintTransformationPrivate))
enum  {
	TINT_TRANSFORMATION_DUMMY_PROPERTY
};
#define TINT_TRANSFORMATION_INTENSITY_FACTOR 0.25f
#define TINT_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TINT_TRANSFORMATION_MAX_PARAMETER 16.0f
static void tint_transformation_finalize (PixelTransformation * obj);
#define TEMPERATURE_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformationPrivate))
enum  {
	TEMPERATURE_TRANSFORMATION_DUMMY_PROPERTY
};
#define TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR 0.33f
#define TEMPERATURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define TEMPERATURE_TRANSFORMATION_MAX_PARAMETER 16.0f
static void temperature_transformation_finalize (PixelTransformation * obj);
#define SATURATION_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationPrivate))
enum  {
	SATURATION_TRANSFORMATION_DUMMY_PROPERTY
};
#define SATURATION_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define SATURATION_TRANSFORMATION_MAX_PARAMETER 16.0f
static void saturation_transformation_finalize (PixelTransformation * obj);
#define EXPOSURE_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformationPrivate))
enum  {
	EXPOSURE_TRANSFORMATION_DUMMY_PROPERTY
};
#define EXPOSURE_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define EXPOSURE_TRANSFORMATION_MAX_PARAMETER 16.0f
static void exposure_transformation_finalize (PixelTransformation * obj);
#define CONTRAST_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTRAST_TRANSFORMATION, ContrastTransformationPrivate))
enum  {
	CONTRAST_TRANSFORMATION_DUMMY_PROPERTY
};
#define CONTRAST_TRANSFORMATION_MIN_PARAMETER (-16.0f)
#define CONTRAST_TRANSFORMATION_MAX_PARAMETER 16.0f
#define CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT 0.5f
static void contrast_transformation_finalize (PixelTransformation * obj);
#define PIXEL_TRANSFORMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXEL_TRANSFORMER, PixelTransformerPrivate))
enum  {
	PIXEL_TRANSFORMER_DUMMY_PROPERTY
};
PixelTransformer* pixel_transformer_copy (PixelTransformer* self);
static void pixel_transformer_build_optimized_transformations (PixelTransformer* self);
void pixel_transformer_apply_transformations (PixelTransformer* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result);
void pixel_transformer_detach_transformation (PixelTransformer* self, PixelTransformation* victim);
void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans);
void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable);
void pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self, GdkPixbuf* source, GdkPixbuf* dest, GCancellable* cancellable, gint jobs);
void pixel_transformer_transform_from_fp (PixelTransformer* self, gfloat** fp_pixel_cache, int* fp_pixel_cache_length1, GdkPixbuf* dest);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void* _____lambda5_ (Block2Data* _data2_);
static gpointer ______lambda5__gthread_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void* _____lambda4_ (Block4Data* _data4_);
void pixel_transformer_apply_transformation (PixelTransformer* self, guint row, gint rowstride, gint rowbytes, gint n_channels, guchar* source_pixels, int source_pixels_length1, guchar* dest_pixels, int dest_pixels_length1);
static gpointer ______lambda4__gthread_func (gpointer self);
static void pixel_transformer_finalize (PixelTransformer * obj);
gpointer rgb_histogram_ref (gpointer instance);
void rgb_histogram_unref (gpointer instance);
GParamSpec* param_spec_rgb_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_rgb_histogram (GValue* value, gpointer v_object);
void value_take_rgb_histogram (GValue* value, gpointer v_object);
gpointer value_get_rgb_histogram (const GValue* value);
GType rgb_histogram_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RGB_HISTOGRAM, RGBHistogramPrivate))
enum  {
	RGB_HISTOGRAM_DUMMY_PROPERTY
};
#define RGB_HISTOGRAM_MARKED_BACKGROUND ((guchar) 30)
#define RGB_HISTOGRAM_MARKED_FOREGROUND ((guchar) 210)
#define RGB_HISTOGRAM_UNMARKED_BACKGROUND ((guchar) 120)
#define RGB_HISTOGRAM_GRAPHIC_WIDTH 256
#define RGB_HISTOGRAM_GRAPHIC_HEIGHT 100
RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf);
RGBHistogram* rgb_histogram_construct (GType object_type, GdkPixbuf* pixbuf);
static gint rgb_histogram_correct_snap_to_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i);
static gint rgb_histogram_correct_snap_from_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i);
static void rgb_histogram_smooth_extrema (RGBHistogram* self, gint** count_data, int* count_data_length1);
static void rgb_histogram_prepare_qualitative_counts (RGBHistogram* self);
GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self);
static void rgb_histogram_finalize (RGBHistogram * obj);
gpointer intensity_histogram_ref (gpointer instance);
void intensity_histogram_unref (gpointer instance);
GParamSpec* param_spec_intensity_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_intensity_histogram (GValue* value, gpointer v_object);
void value_take_intensity_histogram (GValue* value, gpointer v_object);
gpointer value_get_intensity_histogram (const GValue* value);
GType intensity_histogram_get_type (void) G_GNUC_CONST;
#define INTENSITY_HISTOGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INTENSITY_HISTOGRAM, IntensityHistogramPrivate))
enum  {
	INTENSITY_HISTOGRAM_DUMMY_PROPERTY
};
IntensityHistogram* intensity_histogram_new (GdkPixbuf* pixbuf);
IntensityHistogram* intensity_histogram_construct (GType object_type, GdkPixbuf* pixbuf);
gfloat intensity_histogram_get_cumulative_probability (IntensityHistogram* self, gint level);
static void intensity_histogram_finalize (IntensityHistogram * obj);
#define EXPANSION_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformationPrivate))
enum  {
	EXPANSION_TRANSFORMATION_DUMMY_PROPERTY
};
#define EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS 0.02f
#define EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS 0.02f
ExpansionTransformation* expansion_transformation_new (IntensityHistogram* histogram);
ExpansionTransformation* expansion_transformation_construct (GType object_type, IntensityHistogram* histogram);
static void expansion_transformation_build_remap_table (ExpansionTransformation* self);
static gchar* expansion_transformation_real_to_string (PixelTransformation* base);
gint expansion_transformation_get_white_point (ExpansionTransformation* self);
gint expansion_transformation_get_black_point (ExpansionTransformation* self);
static gboolean expansion_transformation_real_is_identity (PixelTransformation* base);
static PixelTransformation* expansion_transformation_real_copy (PixelTransformation* base);
static void expansion_transformation_finalize (PixelTransformation * obj);
#define SHADOW_DETAIL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformationPrivate))
enum  {
	SHADOW_DETAIL_TRANSFORMATION_DUMMY_PROPERTY
};
#define SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define SHADOW_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define SHADOW_DETAIL_TRANSFORMATION_MIN_PARAMETER 0.0f
#define SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER 32.0f
gpointer hermite_gamma_approximation_function_ref (gpointer instance);
void hermite_gamma_approximation_function_unref (gpointer instance);
GParamSpec* param_spec_hermite_gamma_approximation_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hermite_gamma_approximation_function (GValue* value, gpointer v_object);
void value_take_hermite_gamma_approximation_function (GValue* value, gpointer v_object);
gpointer value_get_hermite_gamma_approximation_function (const GValue* value);
GType hermite_gamma_approximation_function_get_type (void) G_GNUC_CONST;
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_new (gfloat user_interval_upper);
HermiteGammaApproximationFunction* hermite_gamma_approximation_function_construct (GType object_type, gfloat user_interval_upper);
gfloat hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self, gfloat x);
static PixelTransformation* shadow_detail_transformation_real_copy (PixelTransformation* base);
static gboolean shadow_detail_transformation_real_is_identity (PixelTransformation* base);
static void shadow_detail_transformation_finalize (PixelTransformation * obj);
#define HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunctionPrivate))
enum  {
	HERMITE_GAMMA_APPROXIMATION_FUNCTION_DUMMY_PROPERTY
};
static void hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction * obj);
#define HIGHLIGHT_DETAIL_TRANSFORMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformationPrivate))
enum  {
	HIGHLIGHT_DETAIL_TRANSFORMATION_DUMMY_PROPERTY
};
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT 0.5f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_TONAL_WIDTH 0.1f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH 1.0f
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER (-32.0f)
#define HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_PARAMETER 0.0f
static PixelTransformation* highlight_detail_transformation_real_copy (PixelTransformation* base);
static gboolean highlight_detail_transformation_real_is_identity (PixelTransformation* base);
static void highlight_detail_transformation_finalize (PixelTransformation * obj);
#define AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY 8
#define AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY 100
#define AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE (AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY - AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY)
#define AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS 0.02f
#define AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL 0.4f
#define AUTO_ENHANCE_EMPIRICAL_DARK 30
PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gfloat rgb_lookup_table[256] = {0.0f / 255.0f, 1.0f / 255.0f, 2.0f / 255.0f, 3.0f / 255.0f, 4.0f / 255.0f, 5.0f / 255.0f, 6.0f / 255.0f, 7.0f / 255.0f, 8.0f / 255.0f, 9.0f / 255.0f, 10.0f / 255.0f, 11.0f / 255.0f, 12.0f / 255.0f, 13.0f / 255.0f, 14.0f / 255.0f, 15.0f / 255.0f, 16.0f / 255.0f, 17.0f / 255.0f, 18.0f / 255.0f, 19.0f / 255.0f, 20.0f / 255.0f, 21.0f / 255.0f, 22.0f / 255.0f, 23.0f / 255.0f, 24.0f / 255.0f, 25.0f / 255.0f, 26.0f / 255.0f, 27.0f / 255.0f, 28.0f / 255.0f, 29.0f / 255.0f, 30.0f / 255.0f, 31.0f / 255.0f, 32.0f / 255.0f, 33.0f / 255.0f, 34.0f / 255.0f, 35.0f / 255.0f, 36.0f / 255.0f, 37.0f / 255.0f, 38.0f / 255.0f, 39.0f / 255.0f, 40.0f / 255.0f, 41.0f / 255.0f, 42.0f / 255.0f, 43.0f / 255.0f, 44.0f / 255.0f, 45.0f / 255.0f, 46.0f / 255.0f, 47.0f / 255.0f, 48.0f / 255.0f, 49.0f / 255.0f, 50.0f / 255.0f, 51.0f / 255.0f, 52.0f / 255.0f, 53.0f / 255.0f, 54.0f / 255.0f, 55.0f / 255.0f, 56.0f / 255.0f, 57.0f / 255.0f, 58.0f / 255.0f, 59.0f / 255.0f, 60.0f / 255.0f, 61.0f / 255.0f, 62.0f / 255.0f, 63.0f / 255.0f, 64.0f / 255.0f, 65.0f / 255.0f, 66.0f / 255.0f, 67.0f / 255.0f, 68.0f / 255.0f, 69.0f / 255.0f, 70.0f / 255.0f, 71.0f / 255.0f, 72.0f / 255.0f, 73.0f / 255.0f, 74.0f / 255.0f, 75.0f / 255.0f, 76.0f / 255.0f, 77.0f / 255.0f, 78.0f / 255.0f, 79.0f / 255.0f, 80.0f / 255.0f, 81.0f / 255.0f, 82.0f / 255.0f, 83.0f / 255.0f, 84.0f / 255.0f, 85.0f / 255.0f, 86.0f / 255.0f, 87.0f / 255.0f, 88.0f / 255.0f, 89.0f / 255.0f, 90.0f / 255.0f, 91.0f / 255.0f, 92.0f / 255.0f, 93.0f / 255.0f, 94.0f / 255.0f, 95.0f / 255.0f, 96.0f / 255.0f, 97.0f / 255.0f, 98.0f / 255.0f, 99.0f / 255.0f, 100.0f / 255.0f, 101.0f / 255.0f, 102.0f / 255.0f, 103.0f / 255.0f, 104.0f / 255.0f, 105.0f / 255.0f, 106.0f / 255.0f, 107.0f / 255.0f, 108.0f / 255.0f, 109.0f / 255.0f, 110.0f / 255.0f, 111.0f / 255.0f, 112.0f / 255.0f, 113.0f / 255.0f, 114.0f / 255.0f, 115.0f / 255.0f, 116.0f / 255.0f, 117.0f / 255.0f, 118.0f / 255.0f, 119.0f / 255.0f, 120.0f / 255.0f, 121.0f / 255.0f, 122.0f / 255.0f, 123.0f / 255.0f, 124.0f / 255.0f, 125.0f / 255.0f, 126.0f / 255.0f, 127.0f / 255.0f, 128.0f / 255.0f, 129.0f / 255.0f, 130.0f / 255.0f, 131.0f / 255.0f, 132.0f / 255.0f, 133.0f / 255.0f, 134.0f / 255.0f, 135.0f / 255.0f, 136.0f / 255.0f, 137.0f / 255.0f, 138.0f / 255.0f, 139.0f / 255.0f, 140.0f / 255.0f, 141.0f / 255.0f, 142.0f / 255.0f, 143.0f / 255.0f, 144.0f / 255.0f, 145.0f / 255.0f, 146.0f / 255.0f, 147.0f / 255.0f, 148.0f / 255.0f, 149.0f / 255.0f, 150.0f / 255.0f, 151.0f / 255.0f, 152.0f / 255.0f, 153.0f / 255.0f, 154.0f / 255.0f, 155.0f / 255.0f, 156.0f / 255.0f, 157.0f / 255.0f, 158.0f / 255.0f, 159.0f / 255.0f, 160.0f / 255.0f, 161.0f / 255.0f, 162.0f / 255.0f, 163.0f / 255.0f, 164.0f / 255.0f, 165.0f / 255.0f, 166.0f / 255.0f, 167.0f / 255.0f, 168.0f / 255.0f, 169.0f / 255.0f, 170.0f / 255.0f, 171.0f / 255.0f, 172.0f / 255.0f, 173.0f / 255.0f, 174.0f / 255.0f, 175.0f / 255.0f, 176.0f / 255.0f, 177.0f / 255.0f, 178.0f / 255.0f, 179.0f / 255.0f, 180.0f / 255.0f, 181.0f / 255.0f, 182.0f / 255.0f, 183.0f / 255.0f, 184.0f / 255.0f, 185.0f / 255.0f, 186.0f / 255.0f, 187.0f / 255.0f, 188.0f / 255.0f, 189.0f / 255.0f, 190.0f / 255.0f, 191.0f / 255.0f, 192.0f / 255.0f, 193.0f / 255.0f, 194.0f / 255.0f, 195.0f / 255.0f, 196.0f / 255.0f, 197.0f / 255.0f, 198.0f / 255.0f, 199.0f / 255.0f, 200.0f / 255.0f, 201.0f / 255.0f, 202.0f / 255.0f, 203.0f / 255.0f, 204.0f / 255.0f, 205.0f / 255.0f, 206.0f / 255.0f, 207.0f / 255.0f, 208.0f / 255.0f, 209.0f / 255.0f, 210.0f / 255.0f, 211.0f / 255.0f, 212.0f / 255.0f, 213.0f / 255.0f, 214.0f / 255.0f, 215.0f / 255.0f, 216.0f / 255.0f, 217.0f / 255.0f, 218.0f / 255.0f, 219.0f / 255.0f, 220.0f / 255.0f, 221.0f / 255.0f, 222.0f / 255.0f, 223.0f / 255.0f, 224.0f / 255.0f, 225.0f / 255.0f, 226.0f / 255.0f, 227.0f / 255.0f, 228.0f / 255.0f, 229.0f / 255.0f, 230.0f / 255.0f, 231.0f / 255.0f, 232.0f / 255.0f, 233.0f / 255.0f, 234.0f / 255.0f, 235.0f / 255.0f, 236.0f / 255.0f, 237.0f / 255.0f, 238.0f / 255.0f, 239.0f / 255.0f, 240.0f / 255.0f, 241.0f / 255.0f, 242.0f / 255.0f, 243.0f / 255.0f, 244.0f / 255.0f, 245.0f / 255.0f, 246.0f / 255.0f, 247.0f / 255.0f, 248.0f / 255.0f, 249.0f / 255.0f, 250.0f / 255.0f, 251.0f / 255.0f, 252.0f / 255.0f, 253.0f / 255.0f, 254.0f / 255.0f, 255.0f / 255.0f};

void rgb_analytic_pixel_init (RGBAnalyticPixel *self) {
#line 14 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 15 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = 0.0f;
#line 16 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = 0.0f;
#line 17 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = 0.0f;
#line 965 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_components (RGBAnalyticPixel *self, gfloat red, gfloat green, gfloat blue) {
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
#line 20 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = red;
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 22 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = green;
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0.0f, 1.0f);
#line 23 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = _tmp3_;
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = blue;
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 24 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = _tmp5_;
#line 996 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self, guchar red_quantized, guchar green_quantized, guchar blue_quantized) {
	guchar _tmp0_;
	gfloat _tmp1_;
	guchar _tmp2_;
	gfloat _tmp3_;
	guchar _tmp4_;
	gfloat _tmp5_;
#line 27 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 29 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = red_quantized;
#line 29 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = rgb_lookup_table[_tmp0_];
#line 29 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = _tmp1_;
#line 30 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = green_quantized;
#line 30 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = rgb_lookup_table[_tmp2_];
#line 30 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = _tmp3_;
#line 31 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = blue_quantized;
#line 31 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = rgb_lookup_table[_tmp4_];
#line 31 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = _tmp5_;
#line 1027 "ColorTransformation.c"
}


void rgb_analytic_pixel_init_from_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* hsv_pixel) {
	RGBAnalyticPixel from_hsv = {0};
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_;
	gfloat _tmp2_;
	RGBAnalyticPixel _tmp3_;
	gfloat _tmp4_;
	RGBAnalyticPixel _tmp5_;
	gfloat _tmp6_;
#line 34 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (RGBAnalyticPixel));
#line 35 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (hsv_pixel, &_tmp0_);
#line 35 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	from_hsv = _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = from_hsv;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_.red;
#line 36 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).red = _tmp2_;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = from_hsv;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_.green;
#line 37 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).green = _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = from_hsv;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_.blue;
#line 38 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).blue = _tmp6_;
#line 1064 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_red (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_;
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).red;
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 42 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1077 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_green (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).green;
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 46 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1090 "ColorTransformation.c"
}


guchar rgb_analytic_pixel_quantized_blue (RGBAnalyticPixel *self) {
	guchar result = '\0';
	gfloat _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).blue;
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (guchar) (_tmp0_ * 255.0f);
#line 50 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1103 "ColorTransformation.c"
}


gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self, RGBAnalyticPixel* rhs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat _tmp2_;
	RGBAnalyticPixel* _tmp3_;
	gfloat _tmp4_;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).red;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = (*_tmp3_).red;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ == _tmp4_) {
#line 1122 "ColorTransformation.c"
		gfloat _tmp5_;
		RGBAnalyticPixel* _tmp6_;
		gfloat _tmp7_;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = (*self).green;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = (*_tmp6_).green;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 1134 "ColorTransformation.c"
	} else {
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 1138 "ColorTransformation.c"
	}
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 1142 "ColorTransformation.c"
		gfloat _tmp8_;
		RGBAnalyticPixel* _tmp9_;
		gfloat _tmp10_;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = (*self).blue;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = rhs;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = (*_tmp9_).blue;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 1154 "ColorTransformation.c"
	} else {
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 1158 "ColorTransformation.c"
	}
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1164 "ColorTransformation.c"
}


guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self) {
	guint result = 0U;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).red;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = (*self).green;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).blue;
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = ((((guint) (_tmp0_ * 255.0f)) << 16) + (((guint) (_tmp1_ * 255.0f)) << 8)) + ((guint) (_tmp2_ * 255.0f));
#line 58 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1183 "ColorTransformation.c"
}


void rgb_analytic_pixel_to_hsv (RGBAnalyticPixel *self, HSVAnalyticPixel* result) {
	HSVAnalyticPixel _tmp0_ = {0};
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_init_from_rgb (&_tmp0_, &(*self));
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 1195 "ColorTransformation.c"
}


RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self) {
	RGBAnalyticPixel* dup;
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dup = g_new0 (RGBAnalyticPixel, 1);
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memcpy (dup, self, sizeof (RGBAnalyticPixel));
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return dup;
#line 1207 "ColorTransformation.c"
}


void rgb_analytic_pixel_free (RGBAnalyticPixel* self) {
#line 7 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_free (self);
#line 1214 "ColorTransformation.c"
}


GType rgb_analytic_pixel_get_type (void) {
	static volatile gsize rgb_analytic_pixel_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_analytic_pixel_type_id__volatile)) {
		GType rgb_analytic_pixel_type_id;
		rgb_analytic_pixel_type_id = g_boxed_type_register_static ("RGBAnalyticPixel", (GBoxedCopyFunc) rgb_analytic_pixel_dup, (GBoxedFreeFunc) rgb_analytic_pixel_free);
		g_once_init_leave (&rgb_analytic_pixel_type_id__volatile, rgb_analytic_pixel_type_id);
	}
	return rgb_analytic_pixel_type_id__volatile;
}


void hsv_analytic_pixel_init (HSVAnalyticPixel *self) {
#line 74 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 75 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = 0.0f;
#line 76 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = 0.0f;
#line 77 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = 0.0f;
#line 1238 "ColorTransformation.c"
}


void hsv_analytic_pixel_init_from_components (HSVAnalyticPixel *self, gfloat hue, gfloat saturation, gfloat light_value) {
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
#line 80 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = hue;
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 82 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = saturation;
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0.0f, 1.0f);
#line 83 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = _tmp3_;
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = light_value;
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = CLAMP (_tmp4_, 0.0f, 1.0f);
#line 84 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = _tmp5_;
#line 1269 "ColorTransformation.c"
}


void hsv_analytic_pixel_init_from_quantized_components (HSVAnalyticPixel *self, guchar hue_quantized, guchar saturation_quantized, guchar light_value_quantized) {
	guchar _tmp0_;
	gfloat _tmp1_;
	guchar _tmp2_;
	gfloat _tmp3_;
	guchar _tmp4_;
	gfloat _tmp5_;
#line 87 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memset (self, 0, sizeof (HSVAnalyticPixel));
#line 89 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = hue_quantized;
#line 89 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = rgb_lookup_table[_tmp0_];
#line 89 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).hue = _tmp1_;
#line 90 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = saturation_quantized;
#line 90 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = rgb_lookup_table[_tmp2_];
#line 90 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).saturation = _tmp3_;
#line 91 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = light_value_quantized;
#line 91 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = rgb_lookup_table[_tmp4_];
#line 91 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	(*self).light_value = _tmp5_;
#line 1300 "ColorTransformation.c"
}


gboolean hsv_analytic_pixel_equals (HSVAnalyticPixel *self, HSVAnalyticPixel* rhs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat _tmp2_;
	HSVAnalyticPixel _tmp3_;
	gfloat _tmp4_;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).hue;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = *rhs;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_.hue;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ == _tmp4_) {
#line 1319 "ColorTransformation.c"
		gfloat _tmp5_;
		HSVAnalyticPixel _tmp6_;
		gfloat _tmp7_;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = (*self).saturation;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = *rhs;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp6_.saturation;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 1331 "ColorTransformation.c"
	} else {
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 1335 "ColorTransformation.c"
	}
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 1339 "ColorTransformation.c"
		gfloat _tmp8_;
		HSVAnalyticPixel _tmp9_;
		gfloat _tmp10_;
#line 100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = (*self).light_value;
#line 100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = *rhs;
#line 100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp9_.light_value;
#line 100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp8_ == _tmp10_;
#line 1351 "ColorTransformation.c"
	} else {
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 1355 "ColorTransformation.c"
	}
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 99 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1361 "ColorTransformation.c"
}


guint hsv_analytic_pixel_hash_code (HSVAnalyticPixel *self) {
	guint result = 0U;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 104 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = (*self).hue;
#line 104 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = (*self).saturation;
#line 104 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = (*self).light_value;
#line 104 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = ((((guint) (_tmp0_ * 255.0f)) << 16) + (((guint) (_tmp1_ * 255.0f)) << 8)) + ((guint) (_tmp2_ * 255.0f));
#line 104 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1380 "ColorTransformation.c"
}


HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self) {
	HSVAnalyticPixel* dup;
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dup = g_new0 (HSVAnalyticPixel, 1);
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	memcpy (dup, self, sizeof (HSVAnalyticPixel));
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return dup;
#line 1392 "ColorTransformation.c"
}


void hsv_analytic_pixel_free (HSVAnalyticPixel* self) {
#line 67 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_free (self);
#line 1399 "ColorTransformation.c"
}


GType hsv_analytic_pixel_get_type (void) {
	static volatile gsize hsv_analytic_pixel_type_id__volatile = 0;
	if (g_once_init_enter (&hsv_analytic_pixel_type_id__volatile)) {
		GType hsv_analytic_pixel_type_id;
		hsv_analytic_pixel_type_id = g_boxed_type_register_static ("HSVAnalyticPixel", (GBoxedCopyFunc) hsv_analytic_pixel_dup, (GBoxedFreeFunc) hsv_analytic_pixel_free);
		g_once_init_leave (&hsv_analytic_pixel_type_id__volatile, hsv_analytic_pixel_type_id);
	}
	return hsv_analytic_pixel_type_id__volatile;
}


GType composition_mode_get_type (void) {
	static volatile gsize composition_mode_type_id__volatile = 0;
	if (g_once_init_enter (&composition_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPOSITION_MODE_NONE, "COMPOSITION_MODE_NONE", "none"}, {COMPOSITION_MODE_RGB_MATRIX, "COMPOSITION_MODE_RGB_MATRIX", "rgb-matrix"}, {COMPOSITION_MODE_HSV_LOOKUP, "COMPOSITION_MODE_HSV_LOOKUP", "hsv-lookup"}, {0, NULL, NULL}};
		GType composition_mode_type_id;
		composition_mode_type_id = g_enum_register_static ("CompositionMode", values);
		g_once_init_leave (&composition_mode_type_id__volatile, composition_mode_type_id);
	}
	return composition_mode_type_id__volatile;
}


GType pixel_format_get_type (void) {
	static volatile gsize pixel_format_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_format_type_id__volatile)) {
		static const GEnumValue values[] = {{PIXEL_FORMAT_RGB, "PIXEL_FORMAT_RGB", "rgb"}, {PIXEL_FORMAT_HSV, "PIXEL_FORMAT_HSV", "hsv"}, {0, NULL, NULL}};
		GType pixel_format_type_id;
		pixel_format_type_id = g_enum_register_static ("PixelFormat", values);
		g_once_init_leave (&pixel_format_type_id__volatile, pixel_format_type_id);
	}
	return pixel_format_type_id__volatile;
}


GType pixel_transformation_type_get_type (void) {
	static volatile gsize pixel_transformation_type_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION, "PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION", "tone-expansion"}, {PIXEL_TRANSFORMATION_TYPE_SHADOWS, "PIXEL_TRANSFORMATION_TYPE_SHADOWS", "shadows"}, {PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS, "PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS", "highlights"}, {PIXEL_TRANSFORMATION_TYPE_TEMPERATURE, "PIXEL_TRANSFORMATION_TYPE_TEMPERATURE", "temperature"}, {PIXEL_TRANSFORMATION_TYPE_TINT, "PIXEL_TRANSFORMATION_TYPE_TINT", "tint"}, {PIXEL_TRANSFORMATION_TYPE_SATURATION, "PIXEL_TRANSFORMATION_TYPE_SATURATION", "saturation"}, {PIXEL_TRANSFORMATION_TYPE_EXPOSURE, "PIXEL_TRANSFORMATION_TYPE_EXPOSURE", "exposure"}, {PIXEL_TRANSFORMATION_TYPE_CONTRAST, "PIXEL_TRANSFORMATION_TYPE_CONTRAST", "contrast"}, {0, NULL, NULL}};
		GType pixel_transformation_type_type_id;
		pixel_transformation_type_type_id = g_enum_register_static ("PixelTransformationType", values);
		g_once_init_leave (&pixel_transformation_type_type_id__volatile, pixel_transformation_type_type_id);
	}
	return pixel_transformation_type_type_id__volatile;
}


PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type) {
	PixelTransformationBundle* self = NULL;
#line 137 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformationBundle*) g_type_create_instance (object_type);
#line 137 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 1456 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_new (void) {
#line 137 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return pixel_transformation_bundle_construct (TYPE_PIXEL_TRANSFORMATION_BUNDLE);
#line 1463 "ColorTransformation.c"
}


static gpointer _pixel_transformation_bundle_ref0 (gpointer self) {
#line 141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? pixel_transformation_bundle_ref (self) : NULL;
#line 1470 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_get_copied_color_adjustments (void) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
#line 141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _pixel_transformation_bundle_ref0 (_tmp0_);
#line 141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1486 "ColorTransformation.c"
}


void pixel_transformation_bundle_set_copied_color_adjustments (PixelTransformationBundle* adjustments) {
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = adjustments;
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _pixel_transformation_bundle_ref0 (_tmp0_);
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_bundle_unref0 (pixel_transformation_bundle_copied_color_adjustments);
#line 145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_copied_color_adjustments = _tmp1_;
#line 1501 "ColorTransformation.c"
}


gboolean pixel_transformation_bundle_has_copied_color_adjustments (void) {
	gboolean result = FALSE;
	PixelTransformationBundle* _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_copied_color_adjustments;
#line 149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ != NULL;
#line 149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1514 "ColorTransformation.c"
}


void pixel_transformation_bundle_set (PixelTransformationBundle* self, PixelTransformation* transformation) {
	GeeHashMap* _tmp0_;
	PixelTransformation* _tmp1_;
	PixelTransformationType _tmp2_;
	PixelTransformation* _tmp3_;
#line 153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = transformation;
#line 153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixel_transformation_get_transformation_type (_tmp1_);
#line 153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = transformation;
#line 153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) ((gint) _tmp2_)), _tmp3_);
#line 1533 "ColorTransformation.c"
}


void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self) {
	ExpansionTransformation* _tmp0_;
	ExpansionTransformation* _tmp1_;
	ShadowDetailTransformation* _tmp2_;
	ShadowDetailTransformation* _tmp3_;
	HighlightDetailTransformation* _tmp4_;
	HighlightDetailTransformation* _tmp5_;
	TemperatureTransformation* _tmp6_;
	TemperatureTransformation* _tmp7_;
	TintTransformation* _tmp8_;
	TintTransformation* _tmp9_;
	SaturationTransformation* _tmp10_;
	SaturationTransformation* _tmp11_;
	ExposureTransformation* _tmp12_;
	ExposureTransformation* _tmp13_;
	ContrastTransformation* _tmp14_;
	ContrastTransformation* _tmp15_;
#line 157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = expansion_transformation_new_from_extrema (0, 255);
#line 157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_;
#line 157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp1_);
#line 158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = shadow_detail_transformation_new (0.0f);
#line 158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_;
#line 158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp3_);
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = highlight_detail_transformation_new (0.0f);
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_;
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp5_);
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = temperature_transformation_new (0.0f);
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_;
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 160 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp7_);
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = tint_transformation_new (0.0f);
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = _tmp8_;
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 161 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp9_);
#line 162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = saturation_transformation_new (0.0f);
#line 162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_;
#line 162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 162 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp11_);
#line 163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = exposure_transformation_new (0.0f);
#line 163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_;
#line 163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp13_);
#line 164 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = contrast_transformation_new (0.0f);
#line 164 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_;
#line 164 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 164 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp15_);
#line 1618 "ColorTransformation.c"
}


void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store) {
	gchar* expansion_params_encoded = NULL;
	KeyValueMap* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	KeyValueMap* _tmp8_;
	gfloat _tmp9_;
	ShadowDetailTransformation* _tmp10_;
	ShadowDetailTransformation* _tmp11_;
	KeyValueMap* _tmp12_;
	gfloat _tmp13_;
	HighlightDetailTransformation* _tmp14_;
	HighlightDetailTransformation* _tmp15_;
	KeyValueMap* _tmp16_;
	gfloat _tmp17_;
	TemperatureTransformation* _tmp18_;
	TemperatureTransformation* _tmp19_;
	KeyValueMap* _tmp20_;
	gfloat _tmp21_;
	TintTransformation* _tmp22_;
	TintTransformation* _tmp23_;
	KeyValueMap* _tmp24_;
	gfloat _tmp25_;
	SaturationTransformation* _tmp26_;
	SaturationTransformation* _tmp27_;
	KeyValueMap* _tmp28_;
	gfloat _tmp29_;
	ExposureTransformation* _tmp30_;
	ExposureTransformation* _tmp31_;
	KeyValueMap* _tmp32_;
	gfloat _tmp33_;
	ContrastTransformation* _tmp34_;
	ContrastTransformation* _tmp35_;
#line 168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = store;
#line 168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = key_value_map_get_string (_tmp0_, "expansion", "-");
#line 168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_params_encoded = _tmp1_;
#line 169 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = expansion_params_encoded;
#line 169 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_strcmp0 (_tmp2_, "-") == 0) {
#line 1665 "ColorTransformation.c"
		ExpansionTransformation* _tmp3_;
		ExpansionTransformation* _tmp4_;
#line 170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = expansion_transformation_new_from_extrema (0, 255);
#line 170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 170 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp4_);
#line 1676 "ColorTransformation.c"
	} else {
		const gchar* _tmp5_;
		ExpansionTransformation* _tmp6_;
		ExpansionTransformation* _tmp7_;
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = expansion_params_encoded;
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = expansion_transformation_new_from_string (_tmp5_);
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp6_;
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 172 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp7_);
#line 1691 "ColorTransformation.c"
	}
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = store;
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = key_value_map_get_float (_tmp8_, "shadows", 0.0f);
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = shadow_detail_transformation_new (_tmp9_);
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_;
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp11_);
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = store;
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = key_value_map_get_float (_tmp12_, "highlights", 0.0f);
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = highlight_detail_transformation_new (_tmp13_);
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_;
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp15_);
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = store;
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = key_value_map_get_float (_tmp16_, "temperature", 0.0f);
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = temperature_transformation_new (_tmp17_);
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = _tmp18_;
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 176 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp19_);
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = store;
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = key_value_map_get_float (_tmp20_, "tint", 0.0f);
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = tint_transformation_new (_tmp21_);
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_;
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 177 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp23_);
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = store;
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = key_value_map_get_float (_tmp24_, "saturation", 0.0f);
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = saturation_transformation_new (_tmp25_);
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = _tmp26_;
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 178 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp27_);
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = store;
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = key_value_map_get_float (_tmp28_, "exposure", 0.0f);
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = exposure_transformation_new (_tmp29_);
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = _tmp30_;
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp31_);
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = store;
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = key_value_map_get_float (_tmp32_, "contrast", 0.0f);
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = contrast_transformation_new (_tmp33_);
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_;
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 180 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp35_);
#line 167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (expansion_params_encoded);
#line 1779 "ColorTransformation.c"
}


KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group) {
	KeyValueMap* result = NULL;
	KeyValueMap* store = NULL;
	const gchar* _tmp0_;
	KeyValueMap* _tmp1_;
	ExpansionTransformation* new_expansion_trans = NULL;
	PixelTransformation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ShadowDetailTransformation* new_shadows_trans = NULL;
	PixelTransformation* _tmp5_;
	gfloat _tmp6_;
	HighlightDetailTransformation* new_highlight_trans = NULL;
	PixelTransformation* _tmp7_;
	gfloat _tmp8_;
	TemperatureTransformation* new_temp_trans = NULL;
	PixelTransformation* _tmp9_;
	gfloat _tmp10_;
	TintTransformation* new_tint_trans = NULL;
	PixelTransformation* _tmp11_;
	gfloat _tmp12_;
	SaturationTransformation* new_sat_trans = NULL;
	PixelTransformation* _tmp13_;
	gfloat _tmp14_;
	ExposureTransformation* new_exposure_trans = NULL;
	PixelTransformation* _tmp15_;
	gfloat _tmp16_;
	ContrastTransformation* new_contrast_trans = NULL;
	PixelTransformation* _tmp17_;
	gfloat _tmp18_;
#line 184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = group;
#line 184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = key_value_map_new (_tmp0_);
#line 184 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	store = _tmp1_;
#line 186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_expansion_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 188 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_expansion_trans != NULL, "new_expansion_trans != null");
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = pixel_transformation_to_string (G_TYPE_CHECK_INSTANCE_CAST (new_expansion_trans, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_;
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_string (store, "expansion", _tmp4_);
#line 189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp4_);
#line 191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
#line 191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_shadows_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 193 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_shadows_trans != NULL, "new_shadows_trans != null");
#line 194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = shadow_detail_transformation_get_parameter (new_shadows_trans);
#line 194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "shadows", _tmp6_);
#line 196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
#line 196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_highlight_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 198 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_highlight_trans != NULL, "new_highlight_trans != null");
#line 199 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = highlight_detail_transformation_get_parameter (new_highlight_trans);
#line 199 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "highlights", _tmp8_);
#line 201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
#line 201 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_temp_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
#line 203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_temp_trans != NULL, "new_temp_trans != null");
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = temperature_transformation_get_parameter (new_temp_trans);
#line 204 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "temperature", _tmp10_);
#line 206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_TINT);
#line 206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_tint_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TINT_TRANSFORMATION, TintTransformation);
#line 208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_tint_trans != NULL, "new_tint_trans != null");
#line 209 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = tint_transformation_get_parameter (new_tint_trans);
#line 209 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "tint", _tmp12_);
#line 211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_SATURATION);
#line 211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_sat_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
#line 213 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_sat_trans != NULL, "new_sat_trans != null");
#line 214 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = saturation_transformation_get_parameter (new_sat_trans);
#line 214 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "saturation", _tmp14_);
#line 216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
#line 216 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_exposure_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
#line 218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_exposure_trans != NULL, "new_exposure_trans != null");
#line 219 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = exposure_transformation_get_parameter (new_exposure_trans);
#line 219 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "exposure", _tmp16_);
#line 221 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = pixel_transformation_bundle_get_transformation (self, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
#line 221 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	new_contrast_trans = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
#line 223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (new_contrast_trans != NULL, "new_contrast_trans != null");
#line 224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = contrast_transformation_get_parameter (new_contrast_trans);
#line 224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	key_value_map_set_float (store, "contrast", _tmp18_);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = store;
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_contrast_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_exposure_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_sat_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_tint_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_temp_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_highlight_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_shadows_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (new_expansion_trans);
#line 226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1923 "ColorTransformation.c"
}


gint pixel_transformation_bundle_get_count (PixelTransformationBundle* self) {
	gint result = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp2_;
#line 230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1942 "ColorTransformation.c"
}


PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type) {
	PixelTransformation* result = NULL;
	GeeHashMap* _tmp0_;
	PixelTransformationType _tmp1_;
	gpointer _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = type;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) ((gint) _tmp1_)));
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = (PixelTransformation*) _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1961 "ColorTransformation.c"
}


GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self) {
	GeeIterable* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
#line 238 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->map;
#line 238 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 238 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
#line 238 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 1980 "ColorTransformation.c"
}


gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self) {
	gboolean result = FALSE;
	{
		GeeIterator* _adjustment_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterable* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = pixel_transformation_bundle_get_transformations (self);
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = _tmp2_;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp1_);
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_adjustment_it = _tmp3_;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2006 "ColorTransformation.c"
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			PixelTransformation* adjustment = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			PixelTransformation* _tmp8_;
			gboolean _tmp9_;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = _adjustment_it;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp5_) {
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2022 "ColorTransformation.c"
			}
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = _adjustment_it;
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			adjustment = (PixelTransformation*) _tmp7_;
#line 243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = adjustment;
#line 243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = pixel_transformation_is_identity (_tmp8_);
#line 243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp9_) {
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				result = FALSE;
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (adjustment);
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_object_unref0 (_adjustment_it);
#line 244 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				return result;
#line 2044 "ColorTransformation.c"
			}
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (adjustment);
#line 2048 "ColorTransformation.c"
		}
#line 242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_adjustment_it);
#line 2052 "ColorTransformation.c"
	}
#line 247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = TRUE;
#line 247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2058 "ColorTransformation.c"
}


PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self) {
	PixelTransformer* result = NULL;
	PixelTransformer* transformer = NULL;
	PixelTransformer* _tmp0_;
#line 251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformer_new ();
#line 251 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	transformer = _tmp0_;
#line 2070 "ColorTransformation.c"
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_;
		GeeIterable* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _tmp1_;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp2_);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_it = _tmp4_;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2091 "ColorTransformation.c"
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PixelTransformer* _tmp9_;
			PixelTransformation* _tmp10_;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = _transformation_it;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp6_) {
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2107 "ColorTransformation.c"
			}
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_it;
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp8_;
#line 253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = transformer;
#line 253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = transformation;
#line 253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			pixel_transformer_attach_transformation (_tmp9_, _tmp10_);
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 2123 "ColorTransformation.c"
		}
#line 252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_it);
#line 2127 "ColorTransformation.c"
	}
#line 255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = transformer;
#line 255 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2133 "ColorTransformation.c"
}


PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* bundle = NULL;
	PixelTransformationBundle* _tmp0_;
#line 259 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 259 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	bundle = _tmp0_;
#line 2145 "ColorTransformation.c"
	{
		GeeIterator* _transformation_it = NULL;
		GeeIterable* _tmp1_;
		GeeIterable* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = pixel_transformation_bundle_get_transformations (self);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _tmp1_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = _tmp3_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_tmp2_);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_it = _tmp4_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 2166 "ColorTransformation.c"
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			PixelTransformation* transformation = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PixelTransformationBundle* _tmp9_;
			PixelTransformation* _tmp10_;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = _transformation_it;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp6_) {
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 2182 "ColorTransformation.c"
			}
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_it;
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp8_;
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = bundle;
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = transformation;
#line 261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			pixel_transformation_bundle_set (_tmp9_, _tmp10_);
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 2198 "ColorTransformation.c"
		}
#line 260 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_it);
#line 2202 "ColorTransformation.c"
	}
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = bundle;
#line 263 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2208 "ColorTransformation.c"
}


static void value_pixel_transformation_bundle_init (GValue* value) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 2215 "ColorTransformation.c"
}


static void value_pixel_transformation_bundle_free_value (GValue* value) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (value->data[0].v_pointer);
#line 2224 "ColorTransformation.c"
	}
}


static void value_pixel_transformation_bundle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformation_bundle_ref (src_value->data[0].v_pointer);
#line 2234 "ColorTransformation.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2238 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformation_bundle_peek_pointer (const GValue* value) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2246 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_bundle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 2253 "ColorTransformation.c"
		PixelTransformationBundle * object;
		object = collect_values[0].v_pointer;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2260 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2264 "ColorTransformation.c"
		}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformation_bundle_ref (object);
#line 2268 "ColorTransformation.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2272 "ColorTransformation.c"
	}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2276 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_bundle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformationBundle ** object_p;
	object_p = collect_values[0].v_pointer;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2287 "ColorTransformation.c"
	}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 2293 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 2297 "ColorTransformation.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformation_bundle_ref (value->data[0].v_pointer);
#line 2301 "ColorTransformation.c"
	}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2305 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformationBundle* spec;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 2319 "ColorTransformation.c"
}


gpointer value_get_pixel_transformation_bundle (const GValue* value) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2328 "ColorTransformation.c"
}


void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object) {
	PixelTransformationBundle * old;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_ref (value->data[0].v_pointer);
#line 2348 "ColorTransformation.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2352 "ColorTransformation.c"
	}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (old);
#line 2358 "ColorTransformation.c"
	}
}


void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object) {
	PixelTransformationBundle * old;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 2377 "ColorTransformation.c"
	} else {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2381 "ColorTransformation.c"
	}
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_unref (old);
#line 2387 "ColorTransformation.c"
	}
}


static void pixel_transformation_bundle_class_init (PixelTransformationBundleClass * klass) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_parent_class = g_type_class_peek_parent (klass);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationBundleClass *) klass)->finalize = pixel_transformation_bundle_finalize;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformationBundlePrivate));
#line 2399 "ColorTransformation.c"
}


static void pixel_transformation_bundle_instance_init (PixelTransformationBundle * self) {
	void* _tmp0_;
	GDestroyNotify _tmp1_;
	GeeHashDataFunc _tmp2_;
	void* _tmp3_;
	GDestroyNotify _tmp4_;
	GeeEqualDataFunc _tmp5_;
	GeeHashMap* _tmp6_;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMATION_BUNDLE_GET_PRIVATE (self);
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gee_functions_get_hash_func_for (G_TYPE_INT, &_tmp0_, &_tmp1_);
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = gee_functions_get_equal_func_for (G_TYPE_INT, &_tmp3_, &_tmp4_);
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, _tmp2_, _tmp0_, _tmp1_, _tmp5_, _tmp3_, _tmp4_, NULL, NULL, NULL);
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->map = _tmp6_;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 2423 "ColorTransformation.c"
}


static void pixel_transformation_bundle_finalize (PixelTransformationBundle * obj) {
	PixelTransformationBundle * self;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 134 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->map);
#line 2435 "ColorTransformation.c"
}


GType pixel_transformation_bundle_get_type (void) {
	static volatile gsize pixel_transformation_bundle_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_bundle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_bundle_init, value_pixel_transformation_bundle_free_value, value_pixel_transformation_bundle_copy_value, value_pixel_transformation_bundle_peek_pointer, "p", value_pixel_transformation_bundle_collect_value, "p", value_pixel_transformation_bundle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationBundleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_bundle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformationBundle), 0, (GInstanceInitFunc) pixel_transformation_bundle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformation_bundle_type_id;
		pixel_transformation_bundle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformationBundle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixel_transformation_bundle_type_id__volatile, pixel_transformation_bundle_type_id);
	}
	return pixel_transformation_bundle_type_id__volatile;
}


gpointer pixel_transformation_bundle_ref (gpointer instance) {
	PixelTransformationBundle * self;
	self = instance;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 2460 "ColorTransformation.c"
}


void pixel_transformation_bundle_unref (gpointer instance) {
	PixelTransformationBundle * self;
	self = instance;
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS (self)->finalize (self);
#line 131 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2473 "ColorTransformation.c"
	}
}


PixelTransformation* pixel_transformation_construct (GType object_type, PixelTransformationType type, PixelFormat preferred_format) {
	PixelTransformation* self = NULL;
	PixelTransformationType _tmp0_;
	PixelFormat _tmp1_;
#line 271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformation*) g_type_create_instance (object_type);
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->type = _tmp0_;
#line 274 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = preferred_format;
#line 274 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->preferred_format = _tmp1_;
#line 271 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 2494 "ColorTransformation.c"
}


PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self) {
	PixelTransformationType result = 0;
	PixelTransformationType _tmp0_;
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->type;
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 278 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2507 "ColorTransformation.c"
}


PixelFormat pixel_transformation_get_preferred_format (PixelTransformation* self) {
	PixelFormat result = 0;
	PixelFormat _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->preferred_format;
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2520 "ColorTransformation.c"
}


static CompositionMode pixel_transformation_real_get_composition_mode (PixelTransformation* self) {
	CompositionMode result = 0;
#line 286 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = COMPOSITION_MODE_NONE;
#line 286 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2530 "ColorTransformation.c"
}


CompositionMode pixel_transformation_get_composition_mode (PixelTransformation* self) {
#line 285 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->get_composition_mode (self);
#line 2537 "ColorTransformation.c"
}


static void pixel_transformation_real_compose_with (PixelTransformation* self, PixelTransformation* other) {
#line 290 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_error ("ColorTransformation.vala:290: %s", "PixelTransformation: compose_with( ): this type of pixel " "transformation doesn't support composition.");
#line 2544 "ColorTransformation.c"
}


void pixel_transformation_compose_with (PixelTransformation* self, PixelTransformation* other) {
#line 289 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->compose_with (self, other);
#line 2551 "ColorTransformation.c"
}


static gboolean pixel_transformation_real_is_identity (PixelTransformation* self) {
	gboolean result = FALSE;
#line 295 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = TRUE;
#line 295 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2561 "ColorTransformation.c"
}


gboolean pixel_transformation_is_identity (PixelTransformation* self) {
#line 294 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->is_identity (self);
#line 2568 "ColorTransformation.c"
}


static void pixel_transformation_real_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
	HSVAnalyticPixel _tmp0_;
#line 299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 2580 "ColorTransformation.c"
}


void pixel_transformation_transform_pixel_hsv (PixelTransformation* self, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
#line 298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->transform_pixel_hsv (self, p, result);
#line 2587 "ColorTransformation.c"
}


static void pixel_transformation_real_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	RGBAnalyticPixel _tmp0_;
#line 303 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *p;
#line 303 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp0_;
#line 303 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 2599 "ColorTransformation.c"
}


void pixel_transformation_transform_pixel_rgb (PixelTransformation* self, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
#line 302 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_GET_CLASS (self)->transform_pixel_rgb (self, p, result);
#line 2606 "ColorTransformation.c"
}


static gchar* pixel_transformation_real_to_string (PixelTransformation* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
#line 307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_strdup ("PixelTransformation");
#line 307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 307 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2619 "ColorTransformation.c"
}


gchar* pixel_transformation_to_string (PixelTransformation* self) {
#line 306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->to_string (self);
#line 2626 "ColorTransformation.c"
}


static PixelTransformation* pixel_transformation_real_copy (PixelTransformation* self) {
#line 310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_critical ("Type `%s' does not implement abstract method `pixel_transformation_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2635 "ColorTransformation.c"
}


PixelTransformation* pixel_transformation_copy (PixelTransformation* self) {
#line 310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return PIXEL_TRANSFORMATION_GET_CLASS (self)->copy (self);
#line 2642 "ColorTransformation.c"
}


static void value_pixel_transformation_init (GValue* value) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 2649 "ColorTransformation.c"
}


static void value_pixel_transformation_free_value (GValue* value) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (value->data[0].v_pointer);
#line 2658 "ColorTransformation.c"
	}
}


static void value_pixel_transformation_copy_value (const GValue* src_value, GValue* dest_value) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformation_ref (src_value->data[0].v_pointer);
#line 2668 "ColorTransformation.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2672 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformation_peek_pointer (const GValue* value) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2680 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 2687 "ColorTransformation.c"
		PixelTransformation * object;
		object = collect_values[0].v_pointer;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2694 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2698 "ColorTransformation.c"
		}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformation_ref (object);
#line 2702 "ColorTransformation.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2706 "ColorTransformation.c"
	}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2710 "ColorTransformation.c"
}


static gchar* value_pixel_transformation_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformation ** object_p;
	object_p = collect_values[0].v_pointer;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2721 "ColorTransformation.c"
	}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 2727 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 2731 "ColorTransformation.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformation_ref (value->data[0].v_pointer);
#line 2735 "ColorTransformation.c"
	}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 2739 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformation* spec;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMATION), NULL);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 2753 "ColorTransformation.c"
}


gpointer value_get_pixel_transformation (const GValue* value) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION), NULL);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 2762 "ColorTransformation.c"
}


void value_set_pixel_transformation (GValue* value, gpointer v_object) {
	PixelTransformation * old;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_ref (value->data[0].v_pointer);
#line 2782 "ColorTransformation.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2786 "ColorTransformation.c"
	}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (old);
#line 2792 "ColorTransformation.c"
	}
}


void value_take_pixel_transformation (GValue* value, gpointer v_object) {
	PixelTransformation * old;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMATION));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMATION));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 2811 "ColorTransformation.c"
	} else {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 2815 "ColorTransformation.c"
	}
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_unref (old);
#line 2821 "ColorTransformation.c"
	}
}


static void pixel_transformation_class_init (PixelTransformationClass * klass) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_parent_class = g_type_class_peek_parent (klass);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = pixel_transformation_finalize;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformationPrivate));
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation *)) pixel_transformation_real_get_composition_mode;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation *, PixelTransformation*)) pixel_transformation_real_compose_with;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation *)) pixel_transformation_real_is_identity;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation *, HSVAnalyticPixel*, HSVAnalyticPixel*)) pixel_transformation_real_transform_pixel_hsv;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation *, RGBAnalyticPixel*, RGBAnalyticPixel*)) pixel_transformation_real_transform_pixel_rgb;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->to_string = (gchar* (*) (PixelTransformation *)) pixel_transformation_real_to_string;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation *)) pixel_transformation_real_copy;
#line 2847 "ColorTransformation.c"
}


static void pixel_transformation_instance_init (PixelTransformation * self) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMATION_GET_PRIVATE (self);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 2856 "ColorTransformation.c"
}


static void pixel_transformation_finalize (PixelTransformation * obj) {
	PixelTransformation * self;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 2866 "ColorTransformation.c"
}


GType pixel_transformation_get_type (void) {
	static volatile gsize pixel_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformation_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformation_init, value_pixel_transformation_free_value, value_pixel_transformation_copy_value, value_pixel_transformation_peek_pointer, "p", value_pixel_transformation_collect_value, "p", value_pixel_transformation_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformation), 0, (GInstanceInitFunc) pixel_transformation_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformation_type_id;
		pixel_transformation_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformation", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&pixel_transformation_type_id__volatile, pixel_transformation_type_id);
	}
	return pixel_transformation_type_id__volatile;
}


gpointer pixel_transformation_ref (gpointer instance) {
	PixelTransformation * self;
	self = instance;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 2891 "ColorTransformation.c"
}


void pixel_transformation_unref (gpointer instance) {
	PixelTransformation * self;
	self = instance;
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMATION_GET_CLASS (self)->finalize (self);
#line 267 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2904 "ColorTransformation.c"
	}
}


RGBTransformation* rgb_transformation_construct (GType object_type, PixelTransformationType type) {
	RGBTransformation* self = NULL;
	PixelTransformationType _tmp0_;
	gfloat* _tmp1_;
#line 323 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 323 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (RGBTransformation*) pixel_transformation_construct (object_type, _tmp0_, PIXEL_FORMAT_RGB);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gfloat, 16);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[0] = 1.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[1] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[2] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[3] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[4] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[5] = 1.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[6] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[7] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[8] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[9] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[10] = 1.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[11] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[12] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[13] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[14] = 0.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[15] = 1.0f;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = _tmp1_;
#line 329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries_length1 = 16;
#line 322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 2959 "ColorTransformation.c"
}


RGBTransformation* rgb_transformation_new (PixelTransformationType type) {
#line 322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return rgb_transformation_construct (TYPE_RGB_TRANSFORMATION, type);
#line 2966 "ColorTransformation.c"
}


static CompositionMode rgb_transformation_real_get_composition_mode (PixelTransformation* base) {
	RGBTransformation * self;
	CompositionMode result = 0;
#line 336 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = COMPOSITION_MODE_RGB_MATRIX;
#line 337 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 2979 "ColorTransformation.c"
}


static gpointer _pixel_transformation_ref0 (gpointer self) {
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? pixel_transformation_ref (self) : NULL;
#line 2986 "ColorTransformation.c"
}


static void rgb_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other) {
	RGBTransformation * self;
	PixelTransformation* _tmp0_;
	CompositionMode _tmp1_;
	RGBTransformation* transform = NULL;
	PixelTransformation* _tmp2_;
	RGBTransformation* _tmp3_;
	gfloat* result_matrix_entries = NULL;
	gfloat* _tmp4_;
	gint result_matrix_entries_length1;
	gint _result_matrix_entries_size_;
	gfloat* _tmp5_;
	gint _tmp5__length1;
	RGBTransformation* _tmp6_;
	gfloat* _tmp7_;
	gint _tmp7__length1;
	gfloat _tmp8_;
	gfloat* _tmp9_;
	gint _tmp9__length1;
	gfloat _tmp10_;
	RGBTransformation* _tmp11_;
	gfloat* _tmp12_;
	gint _tmp12__length1;
	gfloat _tmp13_;
	gfloat* _tmp14_;
	gint _tmp14__length1;
	gfloat _tmp15_;
	RGBTransformation* _tmp16_;
	gfloat* _tmp17_;
	gint _tmp17__length1;
	gfloat _tmp18_;
	gfloat* _tmp19_;
	gint _tmp19__length1;
	gfloat _tmp20_;
	RGBTransformation* _tmp21_;
	gfloat* _tmp22_;
	gint _tmp22__length1;
	gfloat _tmp23_;
	gfloat* _tmp24_;
	gint _tmp24__length1;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gfloat* _tmp27_;
	gint _tmp27__length1;
	RGBTransformation* _tmp28_;
	gfloat* _tmp29_;
	gint _tmp29__length1;
	gfloat _tmp30_;
	gfloat* _tmp31_;
	gint _tmp31__length1;
	gfloat _tmp32_;
	RGBTransformation* _tmp33_;
	gfloat* _tmp34_;
	gint _tmp34__length1;
	gfloat _tmp35_;
	gfloat* _tmp36_;
	gint _tmp36__length1;
	gfloat _tmp37_;
	RGBTransformation* _tmp38_;
	gfloat* _tmp39_;
	gint _tmp39__length1;
	gfloat _tmp40_;
	gfloat* _tmp41_;
	gint _tmp41__length1;
	gfloat _tmp42_;
	RGBTransformation* _tmp43_;
	gfloat* _tmp44_;
	gint _tmp44__length1;
	gfloat _tmp45_;
	gfloat* _tmp46_;
	gint _tmp46__length1;
	gfloat _tmp47_;
	gfloat _tmp48_;
	gfloat* _tmp49_;
	gint _tmp49__length1;
	RGBTransformation* _tmp50_;
	gfloat* _tmp51_;
	gint _tmp51__length1;
	gfloat _tmp52_;
	gfloat* _tmp53_;
	gint _tmp53__length1;
	gfloat _tmp54_;
	RGBTransformation* _tmp55_;
	gfloat* _tmp56_;
	gint _tmp56__length1;
	gfloat _tmp57_;
	gfloat* _tmp58_;
	gint _tmp58__length1;
	gfloat _tmp59_;
	RGBTransformation* _tmp60_;
	gfloat* _tmp61_;
	gint _tmp61__length1;
	gfloat _tmp62_;
	gfloat* _tmp63_;
	gint _tmp63__length1;
	gfloat _tmp64_;
	RGBTransformation* _tmp65_;
	gfloat* _tmp66_;
	gint _tmp66__length1;
	gfloat _tmp67_;
	gfloat* _tmp68_;
	gint _tmp68__length1;
	gfloat _tmp69_;
	gfloat _tmp70_;
	gfloat* _tmp71_;
	gint _tmp71__length1;
	RGBTransformation* _tmp72_;
	gfloat* _tmp73_;
	gint _tmp73__length1;
	gfloat _tmp74_;
	gfloat* _tmp75_;
	gint _tmp75__length1;
	gfloat _tmp76_;
	RGBTransformation* _tmp77_;
	gfloat* _tmp78_;
	gint _tmp78__length1;
	gfloat _tmp79_;
	gfloat* _tmp80_;
	gint _tmp80__length1;
	gfloat _tmp81_;
	RGBTransformation* _tmp82_;
	gfloat* _tmp83_;
	gint _tmp83__length1;
	gfloat _tmp84_;
	gfloat* _tmp85_;
	gint _tmp85__length1;
	gfloat _tmp86_;
	RGBTransformation* _tmp87_;
	gfloat* _tmp88_;
	gint _tmp88__length1;
	gfloat _tmp89_;
	gfloat* _tmp90_;
	gint _tmp90__length1;
	gfloat _tmp91_;
	gfloat _tmp92_;
	gfloat* _tmp93_;
	gint _tmp93__length1;
	RGBTransformation* _tmp94_;
	gfloat* _tmp95_;
	gint _tmp95__length1;
	gfloat _tmp96_;
	gfloat* _tmp97_;
	gint _tmp97__length1;
	gfloat _tmp98_;
	RGBTransformation* _tmp99_;
	gfloat* _tmp100_;
	gint _tmp100__length1;
	gfloat _tmp101_;
	gfloat* _tmp102_;
	gint _tmp102__length1;
	gfloat _tmp103_;
	RGBTransformation* _tmp104_;
	gfloat* _tmp105_;
	gint _tmp105__length1;
	gfloat _tmp106_;
	gfloat* _tmp107_;
	gint _tmp107__length1;
	gfloat _tmp108_;
	RGBTransformation* _tmp109_;
	gfloat* _tmp110_;
	gint _tmp110__length1;
	gfloat _tmp111_;
	gfloat* _tmp112_;
	gint _tmp112__length1;
	gfloat _tmp113_;
	gfloat _tmp114_;
	gfloat* _tmp115_;
	gint _tmp115__length1;
	RGBTransformation* _tmp116_;
	gfloat* _tmp117_;
	gint _tmp117__length1;
	gfloat _tmp118_;
	gfloat* _tmp119_;
	gint _tmp119__length1;
	gfloat _tmp120_;
	RGBTransformation* _tmp121_;
	gfloat* _tmp122_;
	gint _tmp122__length1;
	gfloat _tmp123_;
	gfloat* _tmp124_;
	gint _tmp124__length1;
	gfloat _tmp125_;
	RGBTransformation* _tmp126_;
	gfloat* _tmp127_;
	gint _tmp127__length1;
	gfloat _tmp128_;
	gfloat* _tmp129_;
	gint _tmp129__length1;
	gfloat _tmp130_;
	RGBTransformation* _tmp131_;
	gfloat* _tmp132_;
	gint _tmp132__length1;
	gfloat _tmp133_;
	gfloat* _tmp134_;
	gint _tmp134__length1;
	gfloat _tmp135_;
	gfloat _tmp136_;
	gfloat* _tmp137_;
	gint _tmp137__length1;
	RGBTransformation* _tmp138_;
	gfloat* _tmp139_;
	gint _tmp139__length1;
	gfloat _tmp140_;
	gfloat* _tmp141_;
	gint _tmp141__length1;
	gfloat _tmp142_;
	RGBTransformation* _tmp143_;
	gfloat* _tmp144_;
	gint _tmp144__length1;
	gfloat _tmp145_;
	gfloat* _tmp146_;
	gint _tmp146__length1;
	gfloat _tmp147_;
	RGBTransformation* _tmp148_;
	gfloat* _tmp149_;
	gint _tmp149__length1;
	gfloat _tmp150_;
	gfloat* _tmp151_;
	gint _tmp151__length1;
	gfloat _tmp152_;
	RGBTransformation* _tmp153_;
	gfloat* _tmp154_;
	gint _tmp154__length1;
	gfloat _tmp155_;
	gfloat* _tmp156_;
	gint _tmp156__length1;
	gfloat _tmp157_;
	gfloat _tmp158_;
	gfloat* _tmp159_;
	gint _tmp159__length1;
	RGBTransformation* _tmp160_;
	gfloat* _tmp161_;
	gint _tmp161__length1;
	gfloat _tmp162_;
	gfloat* _tmp163_;
	gint _tmp163__length1;
	gfloat _tmp164_;
	RGBTransformation* _tmp165_;
	gfloat* _tmp166_;
	gint _tmp166__length1;
	gfloat _tmp167_;
	gfloat* _tmp168_;
	gint _tmp168__length1;
	gfloat _tmp169_;
	RGBTransformation* _tmp170_;
	gfloat* _tmp171_;
	gint _tmp171__length1;
	gfloat _tmp172_;
	gfloat* _tmp173_;
	gint _tmp173__length1;
	gfloat _tmp174_;
	RGBTransformation* _tmp175_;
	gfloat* _tmp176_;
	gint _tmp176__length1;
	gfloat _tmp177_;
	gfloat* _tmp178_;
	gint _tmp178__length1;
	gfloat _tmp179_;
	gfloat _tmp180_;
	gfloat* _tmp181_;
	gint _tmp181__length1;
	RGBTransformation* _tmp182_;
	gfloat* _tmp183_;
	gint _tmp183__length1;
	gfloat _tmp184_;
	gfloat* _tmp185_;
	gint _tmp185__length1;
	gfloat _tmp186_;
	RGBTransformation* _tmp187_;
	gfloat* _tmp188_;
	gint _tmp188__length1;
	gfloat _tmp189_;
	gfloat* _tmp190_;
	gint _tmp190__length1;
	gfloat _tmp191_;
	RGBTransformation* _tmp192_;
	gfloat* _tmp193_;
	gint _tmp193__length1;
	gfloat _tmp194_;
	gfloat* _tmp195_;
	gint _tmp195__length1;
	gfloat _tmp196_;
	RGBTransformation* _tmp197_;
	gfloat* _tmp198_;
	gint _tmp198__length1;
	gfloat _tmp199_;
	gfloat* _tmp200_;
	gint _tmp200__length1;
	gfloat _tmp201_;
	gfloat _tmp202_;
	gfloat* _tmp203_;
	gint _tmp203__length1;
	RGBTransformation* _tmp204_;
	gfloat* _tmp205_;
	gint _tmp205__length1;
	gfloat _tmp206_;
	gfloat* _tmp207_;
	gint _tmp207__length1;
	gfloat _tmp208_;
	RGBTransformation* _tmp209_;
	gfloat* _tmp210_;
	gint _tmp210__length1;
	gfloat _tmp211_;
	gfloat* _tmp212_;
	gint _tmp212__length1;
	gfloat _tmp213_;
	RGBTransformation* _tmp214_;
	gfloat* _tmp215_;
	gint _tmp215__length1;
	gfloat _tmp216_;
	gfloat* _tmp217_;
	gint _tmp217__length1;
	gfloat _tmp218_;
	RGBTransformation* _tmp219_;
	gfloat* _tmp220_;
	gint _tmp220__length1;
	gfloat _tmp221_;
	gfloat* _tmp222_;
	gint _tmp222__length1;
	gfloat _tmp223_;
	gfloat _tmp224_;
	gfloat* _tmp225_;
	gint _tmp225__length1;
	RGBTransformation* _tmp226_;
	gfloat* _tmp227_;
	gint _tmp227__length1;
	gfloat _tmp228_;
	gfloat* _tmp229_;
	gint _tmp229__length1;
	gfloat _tmp230_;
	RGBTransformation* _tmp231_;
	gfloat* _tmp232_;
	gint _tmp232__length1;
	gfloat _tmp233_;
	gfloat* _tmp234_;
	gint _tmp234__length1;
	gfloat _tmp235_;
	RGBTransformation* _tmp236_;
	gfloat* _tmp237_;
	gint _tmp237__length1;
	gfloat _tmp238_;
	gfloat* _tmp239_;
	gint _tmp239__length1;
	gfloat _tmp240_;
	RGBTransformation* _tmp241_;
	gfloat* _tmp242_;
	gint _tmp242__length1;
	gfloat _tmp243_;
	gfloat* _tmp244_;
	gint _tmp244__length1;
	gfloat _tmp245_;
	gfloat _tmp246_;
	gfloat* _tmp247_;
	gint _tmp247__length1;
	RGBTransformation* _tmp248_;
	gfloat* _tmp249_;
	gint _tmp249__length1;
	gfloat _tmp250_;
	gfloat* _tmp251_;
	gint _tmp251__length1;
	gfloat _tmp252_;
	RGBTransformation* _tmp253_;
	gfloat* _tmp254_;
	gint _tmp254__length1;
	gfloat _tmp255_;
	gfloat* _tmp256_;
	gint _tmp256__length1;
	gfloat _tmp257_;
	RGBTransformation* _tmp258_;
	gfloat* _tmp259_;
	gint _tmp259__length1;
	gfloat _tmp260_;
	gfloat* _tmp261_;
	gint _tmp261__length1;
	gfloat _tmp262_;
	RGBTransformation* _tmp263_;
	gfloat* _tmp264_;
	gint _tmp264__length1;
	gfloat _tmp265_;
	gfloat* _tmp266_;
	gint _tmp266__length1;
	gfloat _tmp267_;
	gfloat _tmp268_;
	gfloat* _tmp269_;
	gint _tmp269__length1;
	RGBTransformation* _tmp270_;
	gfloat* _tmp271_;
	gint _tmp271__length1;
	gfloat _tmp272_;
	gfloat* _tmp273_;
	gint _tmp273__length1;
	gfloat _tmp274_;
	RGBTransformation* _tmp275_;
	gfloat* _tmp276_;
	gint _tmp276__length1;
	gfloat _tmp277_;
	gfloat* _tmp278_;
	gint _tmp278__length1;
	gfloat _tmp279_;
	RGBTransformation* _tmp280_;
	gfloat* _tmp281_;
	gint _tmp281__length1;
	gfloat _tmp282_;
	gfloat* _tmp283_;
	gint _tmp283__length1;
	gfloat _tmp284_;
	RGBTransformation* _tmp285_;
	gfloat* _tmp286_;
	gint _tmp286__length1;
	gfloat _tmp287_;
	gfloat* _tmp288_;
	gint _tmp288__length1;
	gfloat _tmp289_;
	gfloat _tmp290_;
	gfloat* _tmp291_;
	gint _tmp291__length1;
	RGBTransformation* _tmp292_;
	gfloat* _tmp293_;
	gint _tmp293__length1;
	gfloat _tmp294_;
	gfloat* _tmp295_;
	gint _tmp295__length1;
	gfloat _tmp296_;
	RGBTransformation* _tmp297_;
	gfloat* _tmp298_;
	gint _tmp298__length1;
	gfloat _tmp299_;
	gfloat* _tmp300_;
	gint _tmp300__length1;
	gfloat _tmp301_;
	RGBTransformation* _tmp302_;
	gfloat* _tmp303_;
	gint _tmp303__length1;
	gfloat _tmp304_;
	gfloat* _tmp305_;
	gint _tmp305__length1;
	gfloat _tmp306_;
	RGBTransformation* _tmp307_;
	gfloat* _tmp308_;
	gint _tmp308__length1;
	gfloat _tmp309_;
	gfloat* _tmp310_;
	gint _tmp310__length1;
	gfloat _tmp311_;
	gfloat _tmp312_;
	gfloat* _tmp313_;
	gint _tmp313__length1;
	RGBTransformation* _tmp314_;
	gfloat* _tmp315_;
	gint _tmp315__length1;
	gfloat _tmp316_;
	gfloat* _tmp317_;
	gint _tmp317__length1;
	gfloat _tmp318_;
	RGBTransformation* _tmp319_;
	gfloat* _tmp320_;
	gint _tmp320__length1;
	gfloat _tmp321_;
	gfloat* _tmp322_;
	gint _tmp322__length1;
	gfloat _tmp323_;
	RGBTransformation* _tmp324_;
	gfloat* _tmp325_;
	gint _tmp325__length1;
	gfloat _tmp326_;
	gfloat* _tmp327_;
	gint _tmp327__length1;
	gfloat _tmp328_;
	RGBTransformation* _tmp329_;
	gfloat* _tmp330_;
	gint _tmp330__length1;
	gfloat _tmp331_;
	gfloat* _tmp332_;
	gint _tmp332__length1;
	gfloat _tmp333_;
	gfloat _tmp334_;
	gfloat* _tmp335_;
	gint _tmp335__length1;
	RGBTransformation* _tmp336_;
	gfloat* _tmp337_;
	gint _tmp337__length1;
	gfloat _tmp338_;
	gfloat* _tmp339_;
	gint _tmp339__length1;
	gfloat _tmp340_;
	RGBTransformation* _tmp341_;
	gfloat* _tmp342_;
	gint _tmp342__length1;
	gfloat _tmp343_;
	gfloat* _tmp344_;
	gint _tmp344__length1;
	gfloat _tmp345_;
	RGBTransformation* _tmp346_;
	gfloat* _tmp347_;
	gint _tmp347__length1;
	gfloat _tmp348_;
	gfloat* _tmp349_;
	gint _tmp349__length1;
	gfloat _tmp350_;
	RGBTransformation* _tmp351_;
	gfloat* _tmp352_;
	gint _tmp352__length1;
	gfloat _tmp353_;
	gfloat* _tmp354_;
	gint _tmp354__length1;
	gfloat _tmp355_;
	gfloat _tmp356_;
	gboolean _tmp366_ = FALSE;
	gboolean _tmp367_;
#line 340 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = other;
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixel_transformation_get_composition_mode (_tmp0_);
#line 341 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_ != COMPOSITION_MODE_RGB_MATRIX) {
#line 342 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:342: %s", "RGBTransformation: compose_with( ): 'other' transformation " "does not support RGB_MATRIX composition mode");
#line 3509 "ColorTransformation.c"
	}
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = other;
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _pixel_transformation_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_RGB_TRANSFORMATION, RGBTransformation));
#line 345 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	transform = _tmp3_;
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = g_new0 (gfloat, 16);
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries = _tmp4_;
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries_length1 = 16;
#line 347 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_matrix_entries_size_ = result_matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = result_matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5__length1 = result_matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = transform;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7__length1 = _tmp6_->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp7_[0];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = self->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9__length1 = self->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = _tmp9_[0];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = transform;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = _tmp11_->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12__length1 = _tmp11_->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_[1];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = self->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14__length1 = self->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_[4];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = transform;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17__length1 = _tmp16_->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = _tmp17_[2];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = self->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19__length1 = self->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = _tmp19_[8];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = transform;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = _tmp21_->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22__length1 = _tmp21_->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_[3];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = self->matrix_entries;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24__length1 = self->matrix_entries_length1;
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = _tmp24_[12];
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_[0] = (((_tmp8_ * _tmp10_) + (_tmp13_ * _tmp15_)) + (_tmp18_ * _tmp20_)) + (_tmp23_ * _tmp25_);
#line 350 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = _tmp5_[0];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = result_matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27__length1 = result_matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = transform;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp28_->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29__length1 = _tmp28_->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = _tmp29_[0];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = self->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31__length1 = self->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = _tmp31_[1];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = transform;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = _tmp33_->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = _tmp33_->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_[1];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36_ = self->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36__length1 = self->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = _tmp36_[5];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = transform;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39_ = _tmp38_->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39__length1 = _tmp38_->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40_ = _tmp39_[2];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = self->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41__length1 = self->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = _tmp41_[9];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = transform;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = _tmp43_->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44__length1 = _tmp43_->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = _tmp44_[3];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = self->matrix_entries;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46__length1 = self->matrix_entries_length1;
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = _tmp46_[13];
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_[1] = (((_tmp30_ * _tmp32_) + (_tmp35_ * _tmp37_)) + (_tmp40_ * _tmp42_)) + (_tmp45_ * _tmp47_);
#line 356 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = _tmp27_[1];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = result_matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49__length1 = result_matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = transform;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51__length1 = _tmp50_->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = _tmp51_[0];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = self->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53__length1 = self->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp53_[2];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = transform;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = _tmp55_->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56__length1 = _tmp55_->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_[1];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = self->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58__length1 = self->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = _tmp58_[6];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = transform;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = _tmp60_->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61__length1 = _tmp60_->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = _tmp61_[2];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = self->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63__length1 = self->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64_ = _tmp63_[10];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp65_ = transform;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66_ = _tmp65_->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66__length1 = _tmp65_->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp67_ = _tmp66_[3];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68_ = self->matrix_entries;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68__length1 = self->matrix_entries_length1;
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp69_ = _tmp68_[14];
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_[2] = (((_tmp52_ * _tmp54_) + (_tmp57_ * _tmp59_)) + (_tmp62_ * _tmp64_)) + (_tmp67_ * _tmp69_);
#line 362 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70_ = _tmp49_[2];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_ = result_matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71__length1 = result_matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp72_ = transform;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_ = _tmp72_->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73__length1 = _tmp72_->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74_ = _tmp73_[0];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75_ = self->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75__length1 = self->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76_ = _tmp75_[3];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp77_ = transform;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78_ = _tmp77_->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78__length1 = _tmp77_->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp79_ = _tmp78_[1];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80_ = self->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80__length1 = self->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp81_ = _tmp80_[7];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82_ = transform;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83_ = _tmp82_->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83__length1 = _tmp82_->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp84_ = _tmp83_[2];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_ = self->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85__length1 = self->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86_ = _tmp85_[11];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = transform;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = _tmp87_->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88__length1 = _tmp87_->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp89_ = _tmp88_[3];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90_ = self->matrix_entries;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90__length1 = self->matrix_entries_length1;
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp91_ = _tmp90_[15];
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_[3] = (((_tmp74_ * _tmp76_) + (_tmp79_ * _tmp81_)) + (_tmp84_ * _tmp86_)) + (_tmp89_ * _tmp91_);
#line 368 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92_ = _tmp71_[3];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_ = result_matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93__length1 = result_matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94_ = transform;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95_ = _tmp94_->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95__length1 = _tmp94_->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp96_ = _tmp95_[4];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_ = self->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97__length1 = self->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98_ = _tmp97_[0];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp99_ = transform;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100_ = _tmp99_->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100__length1 = _tmp99_->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp101_ = _tmp100_[5];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102_ = self->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102__length1 = self->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp103_ = _tmp102_[4];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104_ = transform;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105_ = _tmp104_->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105__length1 = _tmp104_->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106_ = _tmp105_[6];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107_ = self->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107__length1 = self->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp108_ = _tmp107_[8];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp109_ = transform;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp110_ = _tmp109_->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp110__length1 = _tmp109_->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp111_ = _tmp110_[7];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp112_ = self->matrix_entries;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp112__length1 = self->matrix_entries_length1;
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp113_ = _tmp112_[12];
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_[4] = (((_tmp96_ * _tmp98_) + (_tmp101_ * _tmp103_)) + (_tmp106_ * _tmp108_)) + (_tmp111_ * _tmp113_);
#line 375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp114_ = _tmp93_[4];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115_ = result_matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115__length1 = result_matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp116_ = transform;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp117_ = _tmp116_->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp117__length1 = _tmp116_->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp118_ = _tmp117_[4];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp119_ = self->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp119__length1 = self->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp120_ = _tmp119_[1];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp121_ = transform;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122_ = _tmp121_->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122__length1 = _tmp121_->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp123_ = _tmp122_[5];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp124_ = self->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp124__length1 = self->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp125_ = _tmp124_[5];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp126_ = transform;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp127_ = _tmp126_->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp127__length1 = _tmp126_->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp128_ = _tmp127_[6];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp129_ = self->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp129__length1 = self->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp130_ = _tmp129_[9];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp131_ = transform;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp132_ = _tmp131_->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp132__length1 = _tmp131_->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp133_ = _tmp132_[7];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp134_ = self->matrix_entries;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp134__length1 = self->matrix_entries_length1;
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp135_ = _tmp134_[13];
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp115_[5] = (((_tmp118_ * _tmp120_) + (_tmp123_ * _tmp125_)) + (_tmp128_ * _tmp130_)) + (_tmp133_ * _tmp135_);
#line 381 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp136_ = _tmp115_[5];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137_ = result_matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137__length1 = result_matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp138_ = transform;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp139_ = _tmp138_->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp139__length1 = _tmp138_->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp140_ = _tmp139_[4];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp141_ = self->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp141__length1 = self->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp142_ = _tmp141_[2];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp143_ = transform;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp144_ = _tmp143_->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp144__length1 = _tmp143_->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp145_ = _tmp144_[5];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp146_ = self->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp146__length1 = self->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp147_ = _tmp146_[6];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp148_ = transform;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp149_ = _tmp148_->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp149__length1 = _tmp148_->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp150_ = _tmp149_[6];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp151_ = self->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp151__length1 = self->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp152_ = _tmp151_[10];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp153_ = transform;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp154_ = _tmp153_->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp154__length1 = _tmp153_->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp155_ = _tmp154_[7];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp156_ = self->matrix_entries;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp156__length1 = self->matrix_entries_length1;
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp157_ = _tmp156_[14];
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp137_[6] = (((_tmp140_ * _tmp142_) + (_tmp145_ * _tmp147_)) + (_tmp150_ * _tmp152_)) + (_tmp155_ * _tmp157_);
#line 387 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp158_ = _tmp137_[6];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159_ = result_matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159__length1 = result_matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp160_ = transform;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp161_ = _tmp160_->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp161__length1 = _tmp160_->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp162_ = _tmp161_[4];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp163_ = self->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp163__length1 = self->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp164_ = _tmp163_[3];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp165_ = transform;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp166_ = _tmp165_->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp166__length1 = _tmp165_->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp167_ = _tmp166_[5];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp168_ = self->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp168__length1 = self->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp169_ = _tmp168_[7];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp170_ = transform;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp171_ = _tmp170_->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp171__length1 = _tmp170_->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp172_ = _tmp171_[6];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp173_ = self->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp173__length1 = self->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp174_ = _tmp173_[11];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp175_ = transform;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp176_ = _tmp175_->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp176__length1 = _tmp175_->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp177_ = _tmp176_[7];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp178_ = self->matrix_entries;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp178__length1 = self->matrix_entries_length1;
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp179_ = _tmp178_[15];
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp159_[7] = (((_tmp162_ * _tmp164_) + (_tmp167_ * _tmp169_)) + (_tmp172_ * _tmp174_)) + (_tmp177_ * _tmp179_);
#line 393 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp180_ = _tmp159_[7];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181_ = result_matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181__length1 = result_matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp182_ = transform;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp183_ = _tmp182_->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp183__length1 = _tmp182_->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp184_ = _tmp183_[8];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp185_ = self->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp185__length1 = self->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp186_ = _tmp185_[0];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp187_ = transform;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp188_ = _tmp187_->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp188__length1 = _tmp187_->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp189_ = _tmp188_[9];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp190_ = self->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp190__length1 = self->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp191_ = _tmp190_[4];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp192_ = transform;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp193_ = _tmp192_->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp193__length1 = _tmp192_->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp194_ = _tmp193_[10];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp195_ = self->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp195__length1 = self->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp196_ = _tmp195_[8];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp197_ = transform;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp198_ = _tmp197_->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp198__length1 = _tmp197_->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp199_ = _tmp198_[11];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp200_ = self->matrix_entries;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp200__length1 = self->matrix_entries_length1;
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp201_ = _tmp200_[12];
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp181_[8] = (((_tmp184_ * _tmp186_) + (_tmp189_ * _tmp191_)) + (_tmp194_ * _tmp196_)) + (_tmp199_ * _tmp201_);
#line 400 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp202_ = _tmp181_[8];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203_ = result_matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203__length1 = result_matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp204_ = transform;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp205_ = _tmp204_->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp205__length1 = _tmp204_->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp206_ = _tmp205_[8];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp207_ = self->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp207__length1 = self->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp208_ = _tmp207_[1];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp209_ = transform;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp210_ = _tmp209_->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp210__length1 = _tmp209_->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp211_ = _tmp210_[9];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp212_ = self->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp212__length1 = self->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp213_ = _tmp212_[5];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp214_ = transform;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp215_ = _tmp214_->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp215__length1 = _tmp214_->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp216_ = _tmp215_[10];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp217_ = self->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp217__length1 = self->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp218_ = _tmp217_[9];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp219_ = transform;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp220_ = _tmp219_->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp220__length1 = _tmp219_->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp221_ = _tmp220_[11];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp222_ = self->matrix_entries;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp222__length1 = self->matrix_entries_length1;
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp223_ = _tmp222_[13];
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp203_[9] = (((_tmp206_ * _tmp208_) + (_tmp211_ * _tmp213_)) + (_tmp216_ * _tmp218_)) + (_tmp221_ * _tmp223_);
#line 406 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp224_ = _tmp203_[9];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225_ = result_matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225__length1 = result_matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp226_ = transform;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp227_ = _tmp226_->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp227__length1 = _tmp226_->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp228_ = _tmp227_[8];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp229_ = self->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp229__length1 = self->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp230_ = _tmp229_[2];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp231_ = transform;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp232_ = _tmp231_->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp232__length1 = _tmp231_->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp233_ = _tmp232_[9];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp234_ = self->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp234__length1 = self->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp235_ = _tmp234_[6];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp236_ = transform;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp237_ = _tmp236_->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp237__length1 = _tmp236_->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp238_ = _tmp237_[10];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp239_ = self->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp239__length1 = self->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp240_ = _tmp239_[10];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp241_ = transform;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp242_ = _tmp241_->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp242__length1 = _tmp241_->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp243_ = _tmp242_[11];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp244_ = self->matrix_entries;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp244__length1 = self->matrix_entries_length1;
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp245_ = _tmp244_[14];
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp225_[10] = (((_tmp228_ * _tmp230_) + (_tmp233_ * _tmp235_)) + (_tmp238_ * _tmp240_)) + (_tmp243_ * _tmp245_);
#line 412 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp246_ = _tmp225_[10];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247_ = result_matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247__length1 = result_matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp248_ = transform;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp249_ = _tmp248_->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp249__length1 = _tmp248_->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp250_ = _tmp249_[8];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp251_ = self->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp251__length1 = self->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp252_ = _tmp251_[3];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp253_ = transform;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp254_ = _tmp253_->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp254__length1 = _tmp253_->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp255_ = _tmp254_[9];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp256_ = self->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp256__length1 = self->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp257_ = _tmp256_[7];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp258_ = transform;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp259_ = _tmp258_->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp259__length1 = _tmp258_->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp260_ = _tmp259_[10];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp261_ = self->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp261__length1 = self->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp262_ = _tmp261_[11];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp263_ = transform;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp264_ = _tmp263_->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp264__length1 = _tmp263_->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp265_ = _tmp264_[11];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp266_ = self->matrix_entries;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp266__length1 = self->matrix_entries_length1;
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp267_ = _tmp266_[15];
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp247_[11] = (((_tmp250_ * _tmp252_) + (_tmp255_ * _tmp257_)) + (_tmp260_ * _tmp262_)) + (_tmp265_ * _tmp267_);
#line 418 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp268_ = _tmp247_[11];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269_ = result_matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269__length1 = result_matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp270_ = transform;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp271_ = _tmp270_->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp271__length1 = _tmp270_->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp272_ = _tmp271_[12];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp273_ = self->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp273__length1 = self->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp274_ = _tmp273_[0];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp275_ = transform;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp276_ = _tmp275_->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp276__length1 = _tmp275_->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp277_ = _tmp276_[13];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp278_ = self->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp278__length1 = self->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp279_ = _tmp278_[4];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp280_ = transform;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp281_ = _tmp280_->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp281__length1 = _tmp280_->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp282_ = _tmp281_[14];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp283_ = self->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp283__length1 = self->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp284_ = _tmp283_[8];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp285_ = transform;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp286_ = _tmp285_->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp286__length1 = _tmp285_->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp287_ = _tmp286_[15];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp288_ = self->matrix_entries;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp288__length1 = self->matrix_entries_length1;
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp289_ = _tmp288_[12];
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp269_[12] = (((_tmp272_ * _tmp274_) + (_tmp277_ * _tmp279_)) + (_tmp282_ * _tmp284_)) + (_tmp287_ * _tmp289_);
#line 425 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp290_ = _tmp269_[12];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291_ = result_matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291__length1 = result_matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp292_ = transform;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp293_ = _tmp292_->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp293__length1 = _tmp292_->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp294_ = _tmp293_[12];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp295_ = self->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp295__length1 = self->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp296_ = _tmp295_[1];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp297_ = transform;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp298_ = _tmp297_->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp298__length1 = _tmp297_->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp299_ = _tmp298_[13];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp300_ = self->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp300__length1 = self->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp301_ = _tmp300_[5];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp302_ = transform;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp303_ = _tmp302_->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp303__length1 = _tmp302_->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp304_ = _tmp303_[14];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp305_ = self->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp305__length1 = self->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp306_ = _tmp305_[9];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp307_ = transform;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp308_ = _tmp307_->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp308__length1 = _tmp307_->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp309_ = _tmp308_[15];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp310_ = self->matrix_entries;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp310__length1 = self->matrix_entries_length1;
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp311_ = _tmp310_[13];
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp291_[13] = (((_tmp294_ * _tmp296_) + (_tmp299_ * _tmp301_)) + (_tmp304_ * _tmp306_)) + (_tmp309_ * _tmp311_);
#line 431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp312_ = _tmp291_[13];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313_ = result_matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313__length1 = result_matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp314_ = transform;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp315_ = _tmp314_->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp315__length1 = _tmp314_->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp316_ = _tmp315_[12];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp317_ = self->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp317__length1 = self->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp318_ = _tmp317_[2];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp319_ = transform;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp320_ = _tmp319_->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp320__length1 = _tmp319_->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp321_ = _tmp320_[13];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp322_ = self->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp322__length1 = self->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp323_ = _tmp322_[6];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp324_ = transform;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp325_ = _tmp324_->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp325__length1 = _tmp324_->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp326_ = _tmp325_[14];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp327_ = self->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp327__length1 = self->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp328_ = _tmp327_[10];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp329_ = transform;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp330_ = _tmp329_->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp330__length1 = _tmp329_->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp331_ = _tmp330_[15];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp332_ = self->matrix_entries;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp332__length1 = self->matrix_entries_length1;
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp333_ = _tmp332_[14];
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp313_[14] = (((_tmp316_ * _tmp318_) + (_tmp321_ * _tmp323_)) + (_tmp326_ * _tmp328_)) + (_tmp331_ * _tmp333_);
#line 437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp334_ = _tmp313_[14];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335_ = result_matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335__length1 = result_matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp336_ = transform;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp337_ = _tmp336_->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp337__length1 = _tmp336_->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp338_ = _tmp337_[12];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp339_ = self->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp339__length1 = self->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp340_ = _tmp339_[3];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp341_ = transform;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp342_ = _tmp341_->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp342__length1 = _tmp341_->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp343_ = _tmp342_[13];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp344_ = self->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp344__length1 = self->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp345_ = _tmp344_[7];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp346_ = transform;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp347_ = _tmp346_->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp347__length1 = _tmp346_->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp348_ = _tmp347_[14];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp349_ = self->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp349__length1 = self->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp350_ = _tmp349_[11];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp351_ = transform;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp352_ = _tmp351_->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp352__length1 = _tmp351_->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp353_ = _tmp352_[15];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp354_ = self->matrix_entries;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp354__length1 = self->matrix_entries_length1;
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp355_ = _tmp354_[15];
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp335_[15] = (((_tmp338_ * _tmp340_) + (_tmp343_ * _tmp345_)) + (_tmp348_ * _tmp350_)) + (_tmp353_ * _tmp355_);
#line 443 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp356_ = _tmp335_[15];
#line 4549 "ColorTransformation.c"
	{
		gint i = 0;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 4554 "ColorTransformation.c"
		{
			gboolean _tmp357_ = FALSE;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp357_ = TRUE;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 4561 "ColorTransformation.c"
				gint _tmp359_;
				gfloat* _tmp360_;
				gint _tmp360__length1;
				gint _tmp361_;
				gfloat* _tmp362_;
				gint _tmp362__length1;
				gint _tmp363_;
				gfloat _tmp364_;
				gfloat _tmp365_;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp357_) {
#line 4573 "ColorTransformation.c"
					gint _tmp358_;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp358_ = i;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp358_ + 1;
#line 4579 "ColorTransformation.c"
				}
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp357_ = FALSE;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp359_ = i;
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp359_ < RGB_TRANSFORMATION_MATRIX_SIZE)) {
#line 449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 4589 "ColorTransformation.c"
				}
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360_ = self->matrix_entries;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360__length1 = self->matrix_entries_length1;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp361_ = i;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp362_ = result_matrix_entries;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp362__length1 = result_matrix_entries_length1;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp363_ = i;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp364_ = _tmp362_[_tmp363_];
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp360_[_tmp361_] = _tmp364_;
#line 450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp365_ = _tmp360_[_tmp361_];
#line 4609 "ColorTransformation.c"
			}
		}
	}
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp367_ = self->identity;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp367_) {
#line 4617 "ColorTransformation.c"
		RGBTransformation* _tmp368_;
		gboolean _tmp369_;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp368_ = transform;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp369_ = _tmp368_->identity;
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp366_ = _tmp369_;
#line 4626 "ColorTransformation.c"
	} else {
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp366_ = FALSE;
#line 4630 "ColorTransformation.c"
	}
#line 452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->identity = _tmp366_;
#line 340 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result_matrix_entries = (g_free (result_matrix_entries), NULL);
#line 340 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (transform);
#line 4638 "ColorTransformation.c"
}


static void rgb_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* p, HSVAnalyticPixel* result) {
	RGBTransformation * self;
	RGBAnalyticPixel _tmp0_ = {0};
	RGBAnalyticPixel _tmp1_ = {0};
	HSVAnalyticPixel _tmp2_ = {0};
#line 455 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (p, &_tmp0_);
#line 456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_transform_pixel_rgb (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
#line 456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_to_hsv (&_tmp1_, &_tmp2_);
#line 456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp2_;
#line 456 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 4659 "ColorTransformation.c"
}


static gboolean rgb_transformation_real_is_identity (PixelTransformation* base) {
	RGBTransformation * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 461 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 462 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->identity;
#line 462 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 462 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 4675 "ColorTransformation.c"
}


static PixelTransformation* rgb_transformation_real_copy (PixelTransformation* base) {
	RGBTransformation * self;
	PixelTransformation* result = NULL;
	RGBTransformation* _result_ = NULL;
	PixelTransformationType _tmp0_;
	RGBTransformation* _tmp1_;
#line 465 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_get_transformation_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = rgb_transformation_new (_tmp0_);
#line 466 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp1_;
#line 4693 "ColorTransformation.c"
	{
		gint i = 0;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 4698 "ColorTransformation.c"
		{
			gboolean _tmp2_ = FALSE;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp2_ = TRUE;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 4705 "ColorTransformation.c"
				gint _tmp4_;
				RGBTransformation* _tmp5_;
				gfloat* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				gfloat* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				gfloat _tmp10_;
				gfloat _tmp11_;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp2_) {
#line 4718 "ColorTransformation.c"
					gint _tmp3_;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp3_ = i;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp3_ + 1;
#line 4724 "ColorTransformation.c"
				}
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp2_ = FALSE;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = i;
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp4_ < RGB_TRANSFORMATION_MATRIX_SIZE)) {
#line 468 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 4734 "ColorTransformation.c"
				}
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = _result_;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = _tmp5_->matrix_entries;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6__length1 = _tmp5_->matrix_entries_length1;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = self->matrix_entries;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8__length1 = self->matrix_entries_length1;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = i;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_[_tmp7_] = _tmp10_;
#line 469 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = _tmp6_[_tmp7_];
#line 4756 "ColorTransformation.c"
			}
		}
	}
#line 472 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 472 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 4764 "ColorTransformation.c"
}


static void rgb_transformation_class_init (RGBTransformationClass * klass) {
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_transformation_parent_class = g_type_class_peek_parent (klass);
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = rgb_transformation_finalize;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation *)) rgb_transformation_real_get_composition_mode;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation *, PixelTransformation*)) rgb_transformation_real_compose_with;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation *, HSVAnalyticPixel*, HSVAnalyticPixel*)) rgb_transformation_real_transform_pixel_hsv;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation *, RGBAnalyticPixel*, RGBAnalyticPixel*)) rgb_transformation_real_transform_pixel_rgb;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation *)) rgb_transformation_real_is_identity;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation *)) rgb_transformation_real_copy;
#line 4785 "ColorTransformation.c"
}


static void rgb_transformation_instance_init (RGBTransformation * self) {
#line 320 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->identity = TRUE;
#line 4792 "ColorTransformation.c"
}


static void rgb_transformation_finalize (PixelTransformation * obj) {
	RGBTransformation * self;
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_TRANSFORMATION, RGBTransformation);
#line 316 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->matrix_entries = (g_free (self->matrix_entries), NULL);
#line 313 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (rgb_transformation_parent_class)->finalize (obj);
#line 4804 "ColorTransformation.c"
}


GType rgb_transformation_get_type (void) {
	static volatile gsize rgb_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RGBTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBTransformation), 0, (GInstanceInitFunc) rgb_transformation_instance_init, NULL };
		GType rgb_transformation_type_id;
		rgb_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "RGBTransformation", &g_define_type_info, 0);
		g_once_init_leave (&rgb_transformation_type_id__volatile, rgb_transformation_type_id);
	}
	return rgb_transformation_type_id__volatile;
}


HSVTransformation* hsv_transformation_construct (GType object_type, PixelTransformationType type) {
	HSVTransformation* self = NULL;
	PixelTransformationType _tmp0_;
#line 480 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = type;
#line 480 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HSVTransformation*) pixel_transformation_construct (object_type, _tmp0_, PIXEL_FORMAT_HSV);
#line 479 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 4829 "ColorTransformation.c"
}


static CompositionMode hsv_transformation_real_get_composition_mode (PixelTransformation* base) {
	HSVTransformation * self;
	CompositionMode result = 0;
#line 483 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 484 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = COMPOSITION_MODE_HSV_LOOKUP;
#line 484 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 4842 "ColorTransformation.c"
}


static void hsv_transformation_real_transform_pixel_rgb (PixelTransformation* base, RGBAnalyticPixel* p, RGBAnalyticPixel* result) {
	HSVTransformation * self;
	HSVAnalyticPixel _tmp0_ = {0};
	HSVAnalyticPixel _tmp1_ = {0};
	RGBAnalyticPixel _tmp2_ = {0};
#line 487 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_analytic_pixel_to_hsv (p, &_tmp0_);
#line 488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_transform_pixel_hsv (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PIXEL_TRANSFORMATION, PixelTransformation), &_tmp0_, &_tmp1_);
#line 488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_analytic_pixel_to_rgb (&_tmp1_, &_tmp2_);
#line 488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _tmp2_;
#line 488 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 4863 "ColorTransformation.c"
}


static void hsv_transformation_real_compose_with (PixelTransformation* base, PixelTransformation* other) {
	HSVTransformation * self;
	PixelTransformation* _tmp0_;
	CompositionMode _tmp1_;
	HSVTransformation* hsv_trans = NULL;
	PixelTransformation* _tmp2_;
	HSVTransformation* _tmp3_;
#line 491 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 492 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = other;
#line 492 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixel_transformation_get_composition_mode (_tmp0_);
#line 492 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_ != COMPOSITION_MODE_HSV_LOOKUP) {
#line 493 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:493: HSVTransformation: compose_with(): wrong");
#line 4884 "ColorTransformation.c"
	}
#line 496 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = other;
#line 496 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _pixel_transformation_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_HSV_TRANSFORMATION, HSVTransformation));
#line 496 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_trans = _tmp3_;
#line 4892 "ColorTransformation.c"
	{
		gint i = 0;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 4897 "ColorTransformation.c"
		{
			gboolean _tmp4_ = FALSE;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = TRUE;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 4904 "ColorTransformation.c"
				gint _tmp6_;
				gint idx = 0;
				gint _tmp7_;
				gfloat _tmp8_;
				gint _tmp9_;
				HSVTransformation* _tmp10_;
				gint _tmp11_;
				gfloat _tmp12_;
				gfloat _tmp13_;
				gfloat _tmp14_;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp4_) {
#line 4917 "ColorTransformation.c"
					gint _tmp5_;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = i;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp5_ + 1;
#line 4923 "ColorTransformation.c"
				}
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = FALSE;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = i;
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp6_ < 256)) {
#line 500 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 4933 "ColorTransformation.c"
				}
#line 501 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 501 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = self->remap_table[_tmp7_];
#line 501 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				idx = (gint) (_tmp8_ * 255.0f);
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = i;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = hsv_trans;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = idx;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = _tmp10_->remap_table[_tmp11_];
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = CLAMP (_tmp12_, 0.0f, 1.0f);
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				self->remap_table[_tmp9_] = _tmp13_;
#line 502 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = self->remap_table[_tmp9_];
#line 4955 "ColorTransformation.c"
			}
		}
	}
#line 491 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (hsv_trans);
#line 4961 "ColorTransformation.c"
}


static void hsv_transformation_real_transform_pixel_hsv (PixelTransformation* base, HSVAnalyticPixel* pixel, HSVAnalyticPixel* result) {
	HSVTransformation * self;
	gint remap_index = 0;
	HSVAnalyticPixel _tmp0_;
	gfloat _tmp1_;
	HSVAnalyticPixel _result_ = {0};
	HSVAnalyticPixel _tmp2_;
	gfloat _tmp3_;
	HSVAnalyticPixel _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
#line 506 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 507 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *pixel;
#line 507 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _tmp0_.light_value;
#line 507 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	remap_index = (gint) (_tmp1_ * 255.0f);
#line 509 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *pixel;
#line 509 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_ = _tmp2_;
#line 510 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = self->remap_table[remap_index];
#line 510 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp3_;
#line 512 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _result_;
#line 512 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_.light_value;
#line 512 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = CLAMP (_tmp5_, 0.0f, 1.0f);
#line 512 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_result_.light_value = _tmp6_;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	*result = _result_;
#line 514 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return;
#line 5004 "ColorTransformation.c"
}


static void hsv_transformation_class_init (HSVTransformationClass * klass) {
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hsv_transformation_parent_class = g_type_class_peek_parent (klass);
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = hsv_transformation_finalize;
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->get_composition_mode = (CompositionMode (*) (PixelTransformation *)) hsv_transformation_real_get_composition_mode;
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_rgb = (void (*) (PixelTransformation *, RGBAnalyticPixel*, RGBAnalyticPixel*)) hsv_transformation_real_transform_pixel_rgb;
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->compose_with = (void (*) (PixelTransformation *, PixelTransformation*)) hsv_transformation_real_compose_with;
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->transform_pixel_hsv = (void (*) (PixelTransformation *, HSVAnalyticPixel*, HSVAnalyticPixel*)) hsv_transformation_real_transform_pixel_hsv;
#line 5021 "ColorTransformation.c"
}


static void hsv_transformation_instance_init (HSVTransformation * self) {
}


static void hsv_transformation_finalize (PixelTransformation * obj) {
	HSVTransformation * self;
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HSV_TRANSFORMATION, HSVTransformation);
#line 476 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (hsv_transformation_parent_class)->finalize (obj);
#line 5035 "ColorTransformation.c"
}


GType hsv_transformation_get_type (void) {
	static volatile gsize hsv_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&hsv_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HSVTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hsv_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HSVTransformation), 0, (GInstanceInitFunc) hsv_transformation_instance_init, NULL };
		GType hsv_transformation_type_id;
		hsv_transformation_type_id = g_type_register_static (TYPE_PIXEL_TRANSFORMATION, "HSVTransformation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&hsv_transformation_type_id__volatile, hsv_transformation_type_id);
	}
	return hsv_transformation_type_id__volatile;
}


TintTransformation* tint_transformation_construct (GType object_type, gfloat client_param) {
	TintTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 527 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (TintTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TINT);
#line 529 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_param;
#line 529 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, TINT_TRANSFORMATION_MIN_PARAMETER, TINT_TRANSFORMATION_MAX_PARAMETER);
#line 529 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 531 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 531 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5068 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_;
		gfloat _tmp4_;
		gfloat* _tmp5_;
		gint _tmp5__length1;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat* _tmp8_;
		gint _tmp8__length1;
		gfloat _tmp9_;
		gfloat _tmp10_;
		gfloat* _tmp11_;
		gint _tmp11__length1;
		gfloat _tmp12_;
		gfloat _tmp13_;
#line 532 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 532 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / TINT_TRANSFORMATION_MAX_PARAMETER;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 533 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ * TINT_TRANSFORMATION_INTENSITY_FACTOR;
#line 535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[11] -= _tmp6_ / 2;
#line 535 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[11];
#line 536 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 536 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 536 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = adjusted_param;
#line 536 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_[7] += _tmp9_;
#line 536 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp8_[7];
#line 537 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 537 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 537 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = adjusted_param;
#line 537 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_[3] -= _tmp12_ / 2;
#line 537 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp11_[3];
#line 539 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5124 "ColorTransformation.c"
	}
#line 526 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5128 "ColorTransformation.c"
}


TintTransformation* tint_transformation_new (gfloat client_param) {
#line 526 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return tint_transformation_construct (TYPE_TINT_TRANSFORMATION, client_param);
#line 5135 "ColorTransformation.c"
}


gfloat tint_transformation_get_parameter (TintTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 544 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 544 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 544 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5148 "ColorTransformation.c"
}


static void tint_transformation_class_init (TintTransformationClass * klass) {
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	tint_transformation_parent_class = g_type_class_peek_parent (klass);
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = tint_transformation_finalize;
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (TintTransformationPrivate));
#line 5159 "ColorTransformation.c"
}


static void tint_transformation_instance_init (TintTransformation * self) {
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = TINT_TRANSFORMATION_GET_PRIVATE (self);
#line 5166 "ColorTransformation.c"
}


static void tint_transformation_finalize (PixelTransformation * obj) {
	TintTransformation * self;
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TINT_TRANSFORMATION, TintTransformation);
#line 519 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (tint_transformation_parent_class)->finalize (obj);
#line 5176 "ColorTransformation.c"
}


GType tint_transformation_get_type (void) {
	static volatile gsize tint_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&tint_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TintTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tint_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TintTransformation), 0, (GInstanceInitFunc) tint_transformation_instance_init, NULL };
		GType tint_transformation_type_id;
		tint_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TintTransformation", &g_define_type_info, 0);
		g_once_init_leave (&tint_transformation_type_id__volatile, tint_transformation_type_id);
	}
	return tint_transformation_type_id__volatile;
}


TemperatureTransformation* temperature_transformation_construct (GType object_type, gfloat client_parameter) {
	TemperatureTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 556 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (TemperatureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TEMPERATURE);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, TEMPERATURE_TRANSFORMATION_MIN_PARAMETER, TEMPERATURE_TRANSFORMATION_MAX_PARAMETER);
#line 558 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 560 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 560 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5209 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_;
		gfloat _tmp4_;
		gfloat* _tmp5_;
		gint _tmp5__length1;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat* _tmp8_;
		gint _tmp8__length1;
		gfloat _tmp9_;
		gfloat _tmp10_;
		gfloat* _tmp11_;
		gint _tmp11__length1;
		gfloat _tmp12_;
		gfloat _tmp13_;
#line 561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 561 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / TEMPERATURE_TRANSFORMATION_MAX_PARAMETER;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 562 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ * TEMPERATURE_TRANSFORMATION_INTENSITY_FACTOR;
#line 564 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 564 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 564 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 564 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[11] -= _tmp6_;
#line 564 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[11];
#line 565 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 565 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 565 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = adjusted_param;
#line 565 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_[7] += _tmp9_ / 2;
#line 565 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = _tmp8_[7];
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = adjusted_param;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_[3] += _tmp12_ / 2;
#line 566 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp11_[3];
#line 568 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5265 "ColorTransformation.c"
	}
#line 555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5269 "ColorTransformation.c"
}


TemperatureTransformation* temperature_transformation_new (gfloat client_parameter) {
#line 555 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return temperature_transformation_construct (TYPE_TEMPERATURE_TRANSFORMATION, client_parameter);
#line 5276 "ColorTransformation.c"
}


gfloat temperature_transformation_get_parameter (TemperatureTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 573 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 573 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 573 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5289 "ColorTransformation.c"
}


static void temperature_transformation_class_init (TemperatureTransformationClass * klass) {
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temperature_transformation_parent_class = g_type_class_peek_parent (klass);
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = temperature_transformation_finalize;
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (TemperatureTransformationPrivate));
#line 5300 "ColorTransformation.c"
}


static void temperature_transformation_instance_init (TemperatureTransformation * self) {
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = TEMPERATURE_TRANSFORMATION_GET_PRIVATE (self);
#line 5307 "ColorTransformation.c"
}


static void temperature_transformation_finalize (PixelTransformation * obj) {
	TemperatureTransformation * self;
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEMPERATURE_TRANSFORMATION, TemperatureTransformation);
#line 548 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (temperature_transformation_parent_class)->finalize (obj);
#line 5317 "ColorTransformation.c"
}


GType temperature_transformation_get_type (void) {
	static volatile gsize temperature_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&temperature_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemperatureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) temperature_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TemperatureTransformation), 0, (GInstanceInitFunc) temperature_transformation_instance_init, NULL };
		GType temperature_transformation_type_id;
		temperature_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "TemperatureTransformation", &g_define_type_info, 0);
		g_once_init_leave (&temperature_transformation_type_id__volatile, temperature_transformation_type_id);
	}
	return temperature_transformation_type_id__volatile;
}


SaturationTransformation* saturation_transformation_construct (GType object_type, gfloat client_parameter) {
	SaturationTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 584 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (SaturationTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SATURATION);
#line 586 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 586 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, SATURATION_TRANSFORMATION_MIN_PARAMETER, SATURATION_TRANSFORMATION_MAX_PARAMETER);
#line 586 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 588 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 588 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5350 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_;
		gfloat _tmp4_;
		gfloat one_third = 0.0F;
		gfloat* _tmp5_;
		gint _tmp5__length1;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat* _tmp10_;
		gint _tmp10__length1;
		gfloat _tmp11_;
		gfloat _tmp12_;
		gfloat _tmp13_;
		gfloat* _tmp14_;
		gint _tmp14__length1;
		gfloat _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		gfloat* _tmp18_;
		gint _tmp18__length1;
		gfloat _tmp19_;
		gfloat _tmp20_;
		gfloat _tmp21_;
		gfloat* _tmp22_;
		gint _tmp22__length1;
		gfloat _tmp23_;
		gfloat _tmp24_;
		gfloat _tmp25_;
		gfloat _tmp26_;
		gfloat* _tmp27_;
		gint _tmp27__length1;
		gfloat _tmp28_;
		gfloat _tmp29_;
		gfloat _tmp30_;
		gfloat* _tmp31_;
		gint _tmp31__length1;
		gfloat _tmp32_;
		gfloat _tmp33_;
		gfloat _tmp34_;
		gfloat* _tmp35_;
		gint _tmp35__length1;
		gfloat _tmp36_;
		gfloat _tmp37_;
		gfloat _tmp38_;
		gfloat* _tmp39_;
		gint _tmp39__length1;
		gfloat _tmp40_;
		gfloat _tmp41_;
		gfloat _tmp42_;
		gfloat _tmp43_;
#line 589 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 589 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp3_ / SATURATION_TRANSFORMATION_MAX_PARAMETER;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = adjusted_param;
#line 590 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = _tmp4_ + 1.0f;
#line 592 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		one_third = 0.3333333f;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = adjusted_param;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = one_third;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = adjusted_param;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_[0] = ((1.0f - _tmp6_) * _tmp7_) + _tmp8_;
#line 594 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = _tmp5_[0];
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = adjusted_param;
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = one_third;
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_[1] = (1.0f - _tmp11_) * _tmp12_;
#line 596 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = _tmp10_[1];
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = adjusted_param;
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = one_third;
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_[2] = (1.0f - _tmp15_) * _tmp16_;
#line 597 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = _tmp14_[2];
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp19_ = adjusted_param;
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = one_third;
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_[4] = (1.0f - _tmp19_) * _tmp20_;
#line 599 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = _tmp18_[4];
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = adjusted_param;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp24_ = one_third;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = adjusted_param;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_[5] = ((1.0f - _tmp23_) * _tmp24_) + _tmp25_;
#line 600 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = _tmp22_[5];
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = adjusted_param;
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp29_ = one_third;
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_[6] = (1.0f - _tmp28_) * _tmp29_;
#line 602 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp30_ = _tmp27_[6];
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp32_ = adjusted_param;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp33_ = one_third;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_[8] = (1.0f - _tmp32_) * _tmp33_;
#line 604 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp34_ = _tmp31_[8];
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = adjusted_param;
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = one_third;
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_[9] = (1.0f - _tmp36_) * _tmp37_;
#line 605 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp38_ = _tmp35_[9];
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp40_ = adjusted_param;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp41_ = one_third;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp42_ = adjusted_param;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_[10] = ((1.0f - _tmp40_) * _tmp41_) + _tmp42_;
#line 606 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp43_ = _tmp39_[10];
#line 609 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5529 "ColorTransformation.c"
	}
#line 583 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5533 "ColorTransformation.c"
}


SaturationTransformation* saturation_transformation_new (gfloat client_parameter) {
#line 583 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return saturation_transformation_construct (TYPE_SATURATION_TRANSFORMATION, client_parameter);
#line 5540 "ColorTransformation.c"
}


gfloat saturation_transformation_get_parameter (SaturationTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 614 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 614 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 614 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5553 "ColorTransformation.c"
}


static void saturation_transformation_class_init (SaturationTransformationClass * klass) {
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	saturation_transformation_parent_class = g_type_class_peek_parent (klass);
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = saturation_transformation_finalize;
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (SaturationTransformationPrivate));
#line 5564 "ColorTransformation.c"
}


static void saturation_transformation_instance_init (SaturationTransformation * self) {
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = SATURATION_TRANSFORMATION_GET_PRIVATE (self);
#line 5571 "ColorTransformation.c"
}


static void saturation_transformation_finalize (PixelTransformation * obj) {
	SaturationTransformation * self;
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SATURATION_TRANSFORMATION, SaturationTransformation);
#line 577 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (saturation_transformation_parent_class)->finalize (obj);
#line 5581 "ColorTransformation.c"
}


GType saturation_transformation_get_type (void) {
	static volatile gsize saturation_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&saturation_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SaturationTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saturation_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SaturationTransformation), 0, (GInstanceInitFunc) saturation_transformation_instance_init, NULL };
		GType saturation_transformation_type_id;
		saturation_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "SaturationTransformation", &g_define_type_info, 0);
		g_once_init_leave (&saturation_transformation_type_id__volatile, saturation_transformation_type_id);
	}
	return saturation_transformation_type_id__volatile;
}


ExposureTransformation* exposure_transformation_construct (GType object_type, gfloat client_parameter) {
	ExposureTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 625 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExposureTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_EXPOSURE);
#line 627 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 627 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, EXPOSURE_TRANSFORMATION_MIN_PARAMETER, EXPOSURE_TRANSFORMATION_MAX_PARAMETER);
#line 627 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 629 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5614 "ColorTransformation.c"
		gfloat adjusted_param = 0.0F;
		gfloat _tmp3_;
		gfloat* _tmp4_;
		gint _tmp4__length1;
		gfloat _tmp5_;
		gfloat _tmp6_;
		gfloat* _tmp7_;
		gint _tmp7__length1;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat* _tmp10_;
		gint _tmp10__length1;
		gfloat _tmp11_;
		gfloat _tmp12_;
#line 631 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 631 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		adjusted_param = ((_tmp3_ + 16.0f) / 32.0f) + 0.5f;
#line 633 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 633 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 633 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = adjusted_param;
#line 633 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_[0] = _tmp5_;
#line 633 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = _tmp4_[0];
#line 634 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 634 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 634 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = adjusted_param;
#line 634 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_[5] = _tmp8_;
#line 634 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = _tmp7_[5];
#line 635 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 635 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 635 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = adjusted_param;
#line 635 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_[10] = _tmp11_;
#line 635 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = _tmp10_[10];
#line 637 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5665 "ColorTransformation.c"
	}
#line 624 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5669 "ColorTransformation.c"
}


ExposureTransformation* exposure_transformation_new (gfloat client_parameter) {
#line 624 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return exposure_transformation_construct (TYPE_EXPOSURE_TRANSFORMATION, client_parameter);
#line 5676 "ColorTransformation.c"
}


gfloat exposure_transformation_get_parameter (ExposureTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 642 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 642 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 642 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5689 "ColorTransformation.c"
}


static void exposure_transformation_class_init (ExposureTransformationClass * klass) {
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	exposure_transformation_parent_class = g_type_class_peek_parent (klass);
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = exposure_transformation_finalize;
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ExposureTransformationPrivate));
#line 5700 "ColorTransformation.c"
}


static void exposure_transformation_instance_init (ExposureTransformation * self) {
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = EXPOSURE_TRANSFORMATION_GET_PRIVATE (self);
#line 5707 "ColorTransformation.c"
}


static void exposure_transformation_finalize (PixelTransformation * obj) {
	ExposureTransformation * self;
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPOSURE_TRANSFORMATION, ExposureTransformation);
#line 618 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (exposure_transformation_parent_class)->finalize (obj);
#line 5717 "ColorTransformation.c"
}


GType exposure_transformation_get_type (void) {
	static volatile gsize exposure_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&exposure_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExposureTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exposure_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExposureTransformation), 0, (GInstanceInitFunc) exposure_transformation_instance_init, NULL };
		GType exposure_transformation_type_id;
		exposure_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ExposureTransformation", &g_define_type_info, 0);
		g_once_init_leave (&exposure_transformation_type_id__volatile, exposure_transformation_type_id);
	}
	return exposure_transformation_type_id__volatile;
}


ContrastTransformation* contrast_transformation_construct (GType object_type, gfloat client_parameter) {
	ContrastTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 655 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ContrastTransformation*) rgb_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_CONTRAST);
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = client_parameter;
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, CONTRAST_TRANSFORMATION_MIN_PARAMETER, CONTRAST_TRANSFORMATION_MAX_PARAMETER);
#line 657 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->parameter = _tmp1_;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->parameter;
#line 659 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != 0.0f) {
#line 5750 "ColorTransformation.c"
		gfloat contrast_adjustment = 0.0F;
		gfloat _tmp3_;
		gfloat component_coefficient = 0.0F;
		gfloat _tmp4_;
		gfloat component_offset = 0.0F;
		gfloat _tmp5_;
		gfloat* _tmp6_;
		gint _tmp6__length1;
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat* _tmp9_;
		gint _tmp9__length1;
		gfloat _tmp10_;
		gfloat _tmp11_;
		gfloat* _tmp12_;
		gint _tmp12__length1;
		gfloat _tmp13_;
		gfloat _tmp14_;
		gfloat* _tmp15_;
		gint _tmp15__length1;
		gfloat _tmp16_;
		gfloat _tmp17_;
		gfloat* _tmp18_;
		gint _tmp18__length1;
		gfloat _tmp19_;
		gfloat _tmp20_;
		gfloat* _tmp21_;
		gint _tmp21__length1;
		gfloat _tmp22_;
		gfloat _tmp23_;
#line 661 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->parameter;
#line 661 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		contrast_adjustment = (_tmp3_ / 16.0f) * CONTRAST_TRANSFORMATION_MAX_CONTRAST_ADJUSTMENT;
#line 662 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = contrast_adjustment;
#line 662 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		component_coefficient = 1.0f + _tmp4_;
#line 663 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = contrast_adjustment;
#line 663 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		component_offset = _tmp5_ / (-2.0f);
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = component_coefficient;
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_[0] = _tmp7_;
#line 665 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = _tmp6_[0];
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp10_ = component_coefficient;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_[5] = _tmp10_;
#line 666 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = _tmp9_[5];
#line 667 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 667 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 667 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = component_coefficient;
#line 667 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp12_[10] = _tmp13_;
#line 667 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = _tmp12_[10];
#line 669 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 669 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 669 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = component_offset;
#line 669 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_[3] = _tmp16_;
#line 669 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp17_ = _tmp15_[3];
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp19_ = component_offset;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_[7] = _tmp19_;
#line 670 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = _tmp18_[7];
#line 671 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries;
#line 671 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->matrix_entries_length1;
#line 671 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_ = component_offset;
#line 671 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_[11] = _tmp22_;
#line 671 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = _tmp21_[11];
#line 673 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_RGB_TRANSFORMATION, RGBTransformation)->identity = FALSE;
#line 5855 "ColorTransformation.c"
	}
#line 654 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5859 "ColorTransformation.c"
}


ContrastTransformation* contrast_transformation_new (gfloat client_parameter) {
#line 654 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return contrast_transformation_construct (TYPE_CONTRAST_TRANSFORMATION, client_parameter);
#line 5866 "ColorTransformation.c"
}


gfloat contrast_transformation_get_parameter (ContrastTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 678 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->parameter;
#line 678 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 678 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 5879 "ColorTransformation.c"
}


static void contrast_transformation_class_init (ContrastTransformationClass * klass) {
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	contrast_transformation_parent_class = g_type_class_peek_parent (klass);
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = contrast_transformation_finalize;
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ContrastTransformationPrivate));
#line 5890 "ColorTransformation.c"
}


static void contrast_transformation_instance_init (ContrastTransformation * self) {
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = CONTRAST_TRANSFORMATION_GET_PRIVATE (self);
#line 5897 "ColorTransformation.c"
}


static void contrast_transformation_finalize (PixelTransformation * obj) {
	ContrastTransformation * self;
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTRAST_TRANSFORMATION, ContrastTransformation);
#line 646 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (contrast_transformation_parent_class)->finalize (obj);
#line 5907 "ColorTransformation.c"
}


GType contrast_transformation_get_type (void) {
	static volatile gsize contrast_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&contrast_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContrastTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contrast_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContrastTransformation), 0, (GInstanceInitFunc) contrast_transformation_instance_init, NULL };
		GType contrast_transformation_type_id;
		contrast_transformation_type_id = g_type_register_static (TYPE_RGB_TRANSFORMATION, "ContrastTransformation", &g_define_type_info, 0);
		g_once_init_leave (&contrast_transformation_type_id__volatile, contrast_transformation_type_id);
	}
	return contrast_transformation_type_id__volatile;
}


PixelTransformer* pixel_transformer_construct (GType object_type) {
	PixelTransformer* self = NULL;
#line 688 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (PixelTransformer*) g_type_create_instance (object_type);
#line 688 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 5929 "ColorTransformation.c"
}


PixelTransformer* pixel_transformer_new (void) {
#line 688 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return pixel_transformer_construct (TYPE_PIXEL_TRANSFORMER);
#line 5936 "ColorTransformation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? g_object_ref (self) : NULL;
#line 5943 "ColorTransformation.c"
}


PixelTransformer* pixel_transformer_copy (PixelTransformer* self) {
	PixelTransformer* result = NULL;
	PixelTransformer* clone = NULL;
	PixelTransformer* _tmp0_;
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformer_new ();
#line 692 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	clone = _tmp0_;
#line 5955 "ColorTransformation.c"
	{
		GeeArrayList* _transformation_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _transformation_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _transformation_index = 0;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = self->priv->transformations;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_list = _tmp2_;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = _transformation_list;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = _tmp4_;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_size = _tmp5_;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_transformation_index = -1;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 5983 "ColorTransformation.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			PixelTransformation* transformation = NULL;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			PixelTransformer* _tmp12_;
			GeeArrayList* _tmp13_;
			PixelTransformation* _tmp14_;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = _transformation_index;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_transformation_index = _tmp6_ + 1;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = _transformation_index;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = _transformation_size;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 6006 "ColorTransformation.c"
			}
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = _transformation_list;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = _transformation_index;
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp10_);
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			transformation = (PixelTransformation*) _tmp11_;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = clone;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = _tmp12_->priv->transformations;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = transformation;
#line 695 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_pixel_transformation_unref0 (transformation);
#line 6026 "ColorTransformation.c"
		}
#line 694 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_transformation_list);
#line 6030 "ColorTransformation.c"
	}
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = clone;
#line 697 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6036 "ColorTransformation.c"
}


static void pixel_transformer_build_optimized_transformations (PixelTransformer* self) {
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PixelTransformation** _tmp3_;
	PixelTransformation* pre_trans = NULL;
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _tmp1_;
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = g_new0 (PixelTransformation*, _tmp2_ + 1);
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = _tmp3_;
#line 701 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations_length1 = _tmp2_;
#line 703 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pre_trans = NULL;
#line 704 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_slots_used = 0;
#line 6064 "ColorTransformation.c"
	{
		gint i = 0;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 6069 "ColorTransformation.c"
		{
			gboolean _tmp4_ = FALSE;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = TRUE;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6076 "ColorTransformation.c"
				gint _tmp6_;
				GeeArrayList* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				PixelTransformation* trans = NULL;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				PixelTransformation* _tmp13_;
				gboolean _tmp14_;
				PixelTransformation* this_trans = NULL;
				PixelTransformation* _tmp15_;
				CompositionMode _tmp16_;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				PixelTransformation* _tmp23_;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp4_) {
#line 6095 "ColorTransformation.c"
					gint _tmp5_;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = i;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp5_ + 1;
#line 6101 "ColorTransformation.c"
				}
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = FALSE;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = i;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = self->priv->transformations;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = _tmp8_;
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp6_ < _tmp9_)) {
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6117 "ColorTransformation.c"
				}
#line 706 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = self->priv->transformations;
#line 706 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = i;
#line 706 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
#line 706 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				trans = (PixelTransformation*) _tmp12_;
#line 708 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = trans;
#line 708 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = pixel_transformation_is_identity (_tmp13_);
#line 708 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp14_) {
#line 709 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (trans);
#line 709 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					continue;
#line 6137 "ColorTransformation.c"
				}
#line 711 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				this_trans = NULL;
#line 712 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = trans;
#line 712 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = pixel_transformation_get_composition_mode (_tmp15_);
#line 712 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp16_ == COMPOSITION_MODE_NONE) {
#line 6147 "ColorTransformation.c"
					PixelTransformation* _tmp17_;
					PixelTransformation* _tmp18_;
#line 713 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17_ = trans;
#line 713 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = _pixel_transformation_ref0 (_tmp17_);
#line 713 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (this_trans);
#line 713 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					this_trans = _tmp18_;
#line 6158 "ColorTransformation.c"
				} else {
					PixelTransformation* _tmp19_;
					PixelTransformation* _tmp20_;
#line 715 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = trans;
#line 715 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = pixel_transformation_copy (_tmp19_);
#line 715 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (this_trans);
#line 715 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					this_trans = _tmp20_;
#line 6170 "ColorTransformation.c"
				}
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = pre_trans;
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp23_ != NULL) {
#line 6176 "ColorTransformation.c"
					PixelTransformation* _tmp24_;
					CompositionMode _tmp25_;
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp24_ = this_trans;
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp25_ = pixel_transformation_get_composition_mode (_tmp24_);
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp22_ = _tmp25_ != COMPOSITION_MODE_NONE;
#line 6185 "ColorTransformation.c"
				} else {
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp22_ = FALSE;
#line 6189 "ColorTransformation.c"
				}
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp22_) {
#line 6193 "ColorTransformation.c"
					PixelTransformation* _tmp26_;
					CompositionMode _tmp27_;
					PixelTransformation* _tmp28_;
					CompositionMode _tmp29_;
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp26_ = this_trans;
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = pixel_transformation_get_composition_mode (_tmp26_);
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = pre_trans;
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = pixel_transformation_get_composition_mode (_tmp28_);
#line 718 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = _tmp27_ == _tmp29_;
#line 6208 "ColorTransformation.c"
				} else {
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = FALSE;
#line 6212 "ColorTransformation.c"
				}
#line 717 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp21_) {
#line 6216 "ColorTransformation.c"
					PixelTransformation* _tmp30_;
					PixelTransformation* _tmp31_;
#line 719 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = pre_trans;
#line 719 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = this_trans;
#line 719 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_transformation_compose_with (_tmp30_, _tmp31_);
#line 6225 "ColorTransformation.c"
				} else {
					PixelTransformation** _tmp32_;
					gint _tmp32__length1;
					gint _tmp33_;
					PixelTransformation* _tmp34_;
					PixelTransformation* _tmp35_;
					PixelTransformation* _tmp36_;
					PixelTransformation* _tmp37_;
					PixelTransformation* _tmp38_;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = self->optimized_transformations;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32__length1 = self->optimized_transformations_length1;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = self->optimized_slots_used;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->optimized_slots_used = _tmp33_ + 1;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp34_ = this_trans;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_ = _pixel_transformation_ref0 (_tmp34_);
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (_tmp32_[_tmp33_]);
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_[_tmp33_] = _tmp35_;
#line 721 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36_ = _tmp32_[_tmp33_];
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp37_ = this_trans;
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = _pixel_transformation_ref0 (_tmp37_);
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_pixel_transformation_unref0 (pre_trans);
#line 722 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pre_trans = _tmp38_;
#line 6261 "ColorTransformation.c"
				}
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (this_trans);
#line 705 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (trans);
#line 6267 "ColorTransformation.c"
			}
		}
	}
#line 700 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (pre_trans);
#line 6273 "ColorTransformation.c"
}


void pixel_transformer_attach_transformation (PixelTransformer* self, PixelTransformation* trans) {
	GeeArrayList* _tmp0_;
	PixelTransformation* _tmp1_;
#line 733 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 733 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = trans;
#line 733 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 734 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 734 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = NULL;
#line 734 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations_length1 = 0;
#line 6292 "ColorTransformation.c"
}


void pixel_transformer_detach_transformation (PixelTransformer* self, PixelTransformation* victim) {
	GeeArrayList* _tmp0_;
	PixelTransformation* _tmp1_;
#line 740 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->transformations;
#line 740 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = victim;
#line 740 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 741 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 741 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = NULL;
#line 741 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations_length1 = 0;
#line 6311 "ColorTransformation.c"
}


void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans) {
	{
		gint i = 0;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 6320 "ColorTransformation.c"
		{
			gboolean _tmp0_ = FALSE;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp0_ = TRUE;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6327 "ColorTransformation.c"
				gint _tmp2_;
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				PixelTransformation* _tmp9_;
				PixelTransformation* _tmp10_;
				gboolean _tmp11_;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp0_) {
#line 6340 "ColorTransformation.c"
					gint _tmp1_;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp1_ = i;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp1_ + 1;
#line 6346 "ColorTransformation.c"
				}
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp0_ = FALSE;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp2_ = i;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp3_ = self->priv->transformations;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = _tmp4_;
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 748 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6362 "ColorTransformation.c"
				}
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = self->priv->transformations;
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp7_);
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = (PixelTransformation*) _tmp8_;
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = old_trans;
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = _tmp9_ == _tmp10_;
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_pixel_transformation_unref0 (_tmp9_);
#line 749 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp11_) {
#line 6380 "ColorTransformation.c"
					GeeArrayList* _tmp12_;
					gint _tmp13_;
					PixelTransformation* _tmp14_;
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = self->priv->transformations;
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = i;
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = new_trans;
#line 750 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp13_, _tmp14_);
#line 752 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 752 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->optimized_transformations = NULL;
#line 752 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					self->optimized_transformations_length1 = 0;
#line 753 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return;
#line 6400 "ColorTransformation.c"
				}
			}
		}
	}
#line 756 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_error ("ColorTransformation.vala:756: %s", "PixelTransformer: replace_transformation( ): old_trans is not present " \
"in " "transformation collection");
#line 6407 "ColorTransformation.c"
}


void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GCancellable* _tmp2_;
#line 761 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 761 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixbuf;
#line 761 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = cancellable;
#line 761 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformer_transform_to_other_pixbuf (self, _tmp0_, _tmp1_, _tmp2_, -1);
#line 6423 "ColorTransformation.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return _data1_;
#line 6432 "ColorTransformation.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 6441 "ColorTransformation.c"
		PixelTransformer* self;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self = _data1_->self;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformer_unref0 (self);
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_slice_free (Block1Data, _data1_);
#line 6449 "ColorTransformation.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return _data2_;
#line 6459 "ColorTransformation.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 6468 "ColorTransformation.c"
		PixelTransformer* self;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self = _data2_->_data1_->self;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		block1_data_unref (_data2_->_data1_);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_data2_->_data1_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_slice_free (Block2Data, _data2_);
#line 6478 "ColorTransformation.c"
	}
}


static void* _____lambda5_ (Block2Data* _data2_) {
	Block1Data* _data1_;
	PixelTransformer* self;
	void* result = NULL;
	guint cache_pixel_ticker = 0U;
	guint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_ = _data2_->_data1_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = _data1_->self;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = _data2_->row;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _data1_->dest_width;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = _data1_->dest_num_channels;
#line 788 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	cache_pixel_ticker = (_tmp0_ * _tmp1_) * _tmp2_;
#line 6503 "ColorTransformation.c"
	{
		guint j = 0U;
		guint _tmp3_;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = _data2_->row;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = _tmp3_;
#line 6511 "ColorTransformation.c"
		{
			gboolean _tmp4_ = FALSE;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = TRUE;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6518 "ColorTransformation.c"
				guint _tmp6_;
				guint _tmp7_;
				guint row_start_index = 0U;
				guint _tmp8_;
				gint _tmp9_;
				guint row_end_index = 0U;
				guint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp4_) {
#line 6530 "ColorTransformation.c"
					guint _tmp5_;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = j;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp5_ + 1;
#line 6536 "ColorTransformation.c"
				}
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = FALSE;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = j;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = _data2_->slice_height;
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp6_ < _tmp7_)) {
#line 789 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6548 "ColorTransformation.c"
				}
#line 790 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = j;
#line 790 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = _data1_->dest_rowstride;
#line 790 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_index = _tmp8_ * _tmp9_;
#line 791 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = row_start_index;
#line 791 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = _data1_->dest_width;
#line 791 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = _data1_->dest_num_channels;
#line 791 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_end_index = _tmp10_ + (_tmp11_ * _tmp12_);
#line 6564 "ColorTransformation.c"
				{
					guint i = 0U;
					guint _tmp13_;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = row_start_index;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp13_;
#line 6572 "ColorTransformation.c"
					{
						gboolean _tmp14_ = FALSE;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp14_ = TRUE;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 6579 "ColorTransformation.c"
							guint _tmp17_;
							guint _tmp18_;
							RGBAnalyticPixel pixel = {0};
							gfloat* _tmp19_;
							gint _tmp19__length1;
							guint _tmp20_;
							gfloat _tmp21_;
							gfloat* _tmp22_;
							gint _tmp22__length1;
							guint _tmp23_;
							gfloat _tmp24_;
							gfloat* _tmp25_;
							gint _tmp25__length1;
							guint _tmp26_;
							gfloat _tmp27_;
							guint _tmp28_;
							RGBAnalyticPixel _tmp29_;
							RGBAnalyticPixel _tmp30_ = {0};
							guchar* _tmp31_;
							gint _tmp31__length1;
							guint _tmp32_;
							RGBAnalyticPixel _tmp33_;
							gfloat _tmp34_;
							guchar _tmp35_;
							guchar* _tmp36_;
							gint _tmp36__length1;
							guint _tmp37_;
							RGBAnalyticPixel _tmp38_;
							gfloat _tmp39_;
							guchar _tmp40_;
							guchar* _tmp41_;
							gint _tmp41__length1;
							guint _tmp42_;
							RGBAnalyticPixel _tmp43_;
							gfloat _tmp44_;
							guchar _tmp45_;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp14_) {
#line 6618 "ColorTransformation.c"
								guint _tmp15_;
								gint _tmp16_;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp15_ = i;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp16_ = _data1_->dest_num_channels;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								i = _tmp15_ + _tmp16_;
#line 6627 "ColorTransformation.c"
							}
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp14_ = FALSE;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp17_ = i;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp18_ = row_end_index;
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp17_ < _tmp18_)) {
#line 792 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 6639 "ColorTransformation.c"
							}
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp19_ = _data1_->cache;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp19__length1 = _data1_->cache_length1;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp20_ = cache_pixel_ticker;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp21_ = _tmp19_[_tmp20_];
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp22_ = _data1_->cache;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp22__length1 = _data1_->cache_length1;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp23_ = cache_pixel_ticker;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp24_ = _tmp22_[_tmp23_ + 1];
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp25_ = _data1_->cache;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp25__length1 = _data1_->cache_length1;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26_ = cache_pixel_ticker;
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp27_ = _tmp25_[_tmp26_ + 2];
#line 793 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							rgb_analytic_pixel_init_from_components (&pixel, _tmp21_, _tmp24_, _tmp27_);
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp28_ = cache_pixel_ticker;
#line 798 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							cache_pixel_ticker = _tmp28_ + 3;
#line 800 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29_ = pixel;
#line 800 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_transformer_apply_transformations (self, &_tmp29_, &_tmp30_);
#line 800 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel = _tmp30_;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31_ = _data1_->dest_pixels;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31__length1 = _data1_->dest_pixels_length1;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32_ = i;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp33_ = pixel;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp34_ = _tmp33_.red;
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31_[_tmp32_] = (guchar) (_tmp34_ * 255.0f);
#line 802 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp35_ = _tmp31_[_tmp32_];
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36_ = _data1_->dest_pixels;
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36__length1 = _data1_->dest_pixels_length1;
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp37_ = i;
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_ = pixel;
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = _tmp38_.green;
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36_[_tmp37_ + 1] = (guchar) (_tmp39_ * 255.0f);
#line 803 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp40_ = _tmp36_[_tmp37_ + 1];
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp41_ = _data1_->dest_pixels;
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp41__length1 = _data1_->dest_pixels_length1;
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp42_ = i;
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp43_ = pixel;
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp44_ = _tmp43_.blue;
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp41_[_tmp42_ + 2] = (guchar) (_tmp44_ * 255.0f);
#line 804 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp45_ = _tmp41_[_tmp42_ + 2];
#line 6719 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = NULL;
#line 808 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6730 "ColorTransformation.c"
}


static gpointer ______lambda5__gthread_func (gpointer self) {
	gpointer result;
	result = _____lambda5_ (self);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	block2_data_unref (self);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 6741 "ColorTransformation.c"
}


static gpointer _g_thread_ref0 (gpointer self) {
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self ? g_thread_ref (self) : NULL;
#line 6748 "ColorTransformation.c"
}


void pixel_transformer_transform_from_fp (PixelTransformer* self, gfloat** fp_pixel_cache, int* fp_pixel_cache_length1, GdkPixbuf* dest) {
	Block1Data* _data1_;
	PixelTransformation** _tmp0_;
	gint _tmp0__length1;
	GdkPixbuf* _tmp1_;
	gint _tmp2_;
	gint dest_height = 0;
	GdkPixbuf* _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	gint _tmp6_;
	GdkPixbuf* _tmp7_;
	gint _tmp8_;
	GdkPixbuf* _tmp9_;
	guint8* _tmp10_;
	gint jobs = 0;
	guint _tmp11_;
	guint slice_length = 0U;
	gint _tmp12_;
	gint _tmp13_;
	GThread** threads = NULL;
	gint _tmp17_;
	GThread** _tmp18_;
	gint threads_length1;
	gint _threads_size_;
	gfloat* _tmp19_;
	gint _tmp19__length1;
	GThread** _tmp34_;
	gint _tmp34__length1;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->_ref_count_ = 1;
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->self = pixel_transformer_ref (self);
#line 765 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->optimized_transformations;
#line 765 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = self->optimized_transformations_length1;
#line 765 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == NULL) {
#line 766 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_build_optimized_transformations (self);
#line 6795 "ColorTransformation.c"
	}
#line 768 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = dest;
#line 768 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
#line 768 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->dest_width = _tmp2_;
#line 769 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = dest;
#line 769 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
#line 769 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	dest_height = _tmp4_;
#line 770 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = dest;
#line 770 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = gdk_pixbuf_get_n_channels (_tmp5_);
#line 770 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->dest_num_channels = _tmp6_;
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = dest;
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = gdk_pixbuf_get_rowstride (_tmp7_);
#line 771 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->dest_rowstride = _tmp8_;
#line 772 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = dest;
#line 772 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = gdk_pixbuf_get_pixels (_tmp9_);
#line 772 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->dest_pixels = _tmp10_;
#line 772 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->dest_pixels_length1 = -1;
#line 772 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->_dest_pixels_size_ = _data1_->dest_pixels_length1;
#line 774 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = g_get_num_processors ();
#line 774 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	jobs = ((gint) _tmp11_) - 1;
#line 776 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = dest_height;
#line 776 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	slice_length = (guint) _tmp12_;
#line 777 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = jobs;
#line 777 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp13_ > 0) {
#line 6843 "ColorTransformation.c"
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp14_ = dest_height;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp15_ = jobs;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp16_ = jobs;
#line 778 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		slice_length = (guint) ((_tmp14_ + (_tmp15_ - 1)) / _tmp16_);
#line 6855 "ColorTransformation.c"
	}
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = jobs;
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = g_new0 (GThread*, _tmp17_ + 1);
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads = _tmp18_;
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads_length1 = _tmp17_;
#line 781 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_threads_size_ = threads_length1;
#line 783 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = *fp_pixel_cache;
#line 783 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19__length1 = *fp_pixel_cache_length1;
#line 783 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->cache = _tmp19_;
#line 783 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->cache_length1 = _tmp19__length1;
#line 783 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_->_cache_size_ = _data1_->cache_length1;
#line 6877 "ColorTransformation.c"
	{
		gint job = 0;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		job = 0;
#line 6882 "ColorTransformation.c"
		{
			gboolean _tmp20_ = FALSE;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = TRUE;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 6889 "ColorTransformation.c"
				Block2Data* _data2_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				guint _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				gint _tmp28_;
				guint _tmp29_;
				GThread** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				GThread* _tmp32_;
				GThread* _tmp33_;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_ = g_slice_new0 (Block2Data);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_->_ref_count_ = 1;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_->_data1_ = block1_data_ref (_data1_);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp20_) {
#line 6912 "ColorTransformation.c"
					gint _tmp21_;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = job;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					job = _tmp21_ + 1;
#line 6918 "ColorTransformation.c"
				}
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = FALSE;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = job;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = jobs;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp22_ < _tmp23_)) {
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					block2_data_unref (_data2_);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_data2_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 6934 "ColorTransformation.c"
				}
#line 785 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = job;
#line 785 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = slice_length;
#line 785 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_->row = _tmp24_ * _tmp25_;
#line 786 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = _data2_->row;
#line 786 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp27_ = slice_length;
#line 786 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28_ = dest_height;
#line 786 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = CLAMP (_tmp26_ + _tmp27_, (guint) 0, (guint) _tmp28_);
#line 786 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_->slice_height = _tmp29_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30_ = threads;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30__length1 = threads_length1;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = job;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = g_thread_new ("shotwell-worker", ______lambda5__gthread_func, block2_data_ref (_data2_));
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_thread_unref0 (_tmp30_[_tmp31_]);
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30_[_tmp31_] = _tmp32_;
#line 787 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp33_ = _tmp30_[_tmp31_];
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				block2_data_unref (_data2_);
#line 784 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data2_ = NULL;
#line 6970 "ColorTransformation.c"
			}
		}
	}
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = threads;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = threads_length1;
#line 6978 "ColorTransformation.c"
	{
		GThread** thread_collection = NULL;
		gint thread_collection_length1 = 0;
		gint _thread_collection_size_ = 0;
		gint thread_it = 0;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		thread_collection = _tmp34_;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		thread_collection_length1 = _tmp34__length1;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		for (thread_it = 0; thread_it < _tmp34__length1; thread_it = thread_it + 1) {
#line 6990 "ColorTransformation.c"
			GThread* _tmp35_;
			GThread* thread = NULL;
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp35_ = _g_thread_ref0 (thread_collection[thread_it]);
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			thread = _tmp35_;
#line 6997 "ColorTransformation.c"
			{
				GThread* _tmp36_;
				GThread* _tmp37_;
#line 813 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = thread;
#line 813 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37_ = _g_thread_ref0 (_tmp36_);
#line 813 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				g_thread_join (_tmp37_);
#line 812 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_thread_unref0 (thread);
#line 7009 "ColorTransformation.c"
			}
		}
	}
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads = (_vala_array_free (threads, threads_length1, (GDestroyNotify) g_thread_unref), NULL);
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	block1_data_unref (_data1_);
#line 764 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data1_ = NULL;
#line 7019 "ColorTransformation.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return _data3_;
#line 7028 "ColorTransformation.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 7037 "ColorTransformation.c"
		PixelTransformer* self;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self = _data3_->self;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (_data3_->cancellable);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformer_unref0 (self);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_slice_free (Block3Data, _data3_);
#line 7047 "ColorTransformation.c"
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return _data4_;
#line 7057 "ColorTransformation.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 7066 "ColorTransformation.c"
		PixelTransformer* self;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self = _data4_->_data3_->self;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		block3_data_unref (_data4_->_data3_);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_data4_->_data3_ = NULL;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_slice_free (Block4Data, _data4_);
#line 7076 "ColorTransformation.c"
	}
}


static void* _____lambda4_ (Block4Data* _data4_) {
	Block3Data* _data3_;
	PixelTransformer* self;
	void* result = NULL;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_ = _data4_->_data3_;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = _data3_->self;
#line 7089 "ColorTransformation.c"
	{
		guint j = 0U;
		guint _tmp0_;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _data4_->row;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = _tmp0_;
#line 7097 "ColorTransformation.c"
		{
			gboolean _tmp1_ = FALSE;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp1_ = TRUE;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7104 "ColorTransformation.c"
				guint _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				guchar* _tmp9_;
				gint _tmp9__length1;
				guchar* _tmp10_;
				gint _tmp10__length1;
				gboolean _tmp11_ = FALSE;
				GCancellable* _tmp12_;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp1_) {
#line 7119 "ColorTransformation.c"
					guint _tmp2_;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp2_ = j;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp2_ + 1;
#line 7125 "ColorTransformation.c"
				}
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp1_ = FALSE;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp3_ = j;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp4_ = _data4_->slice_height;
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 855 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7137 "ColorTransformation.c"
				}
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = j;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp6_ = _data3_->rowstride;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = _data3_->rowbytes;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = _data3_->n_channels;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = _data3_->source_pixels;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9__length1 = _data3_->source_pixels_length1;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = _data3_->dest_pixels;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10__length1 = _data3_->dest_pixels_length1;
#line 856 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				pixel_transformer_apply_transformation (self, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp9__length1, _tmp10_, _tmp10__length1);
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = _data3_->cancellable;
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp12_ != NULL) {
#line 7161 "ColorTransformation.c"
					GCancellable* _tmp13_;
					gboolean _tmp14_;
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = _data3_->cancellable;
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = g_cancellable_is_cancelled (_tmp13_);
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11_ = _tmp14_;
#line 7170 "ColorTransformation.c"
				} else {
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11_ = FALSE;
#line 7174 "ColorTransformation.c"
				}
#line 859 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp11_) {
#line 860 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7180 "ColorTransformation.c"
				}
			}
		}
	}
#line 864 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = NULL;
#line 864 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 7189 "ColorTransformation.c"
}


static gpointer ______lambda4__gthread_func (gpointer self) {
	gpointer result;
	result = _____lambda4_ (self);
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	block4_data_unref (self);
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 7200 "ColorTransformation.c"
}


void pixel_transformer_transform_to_other_pixbuf (PixelTransformer* self, GdkPixbuf* source, GdkPixbuf* dest, GCancellable* cancellable, gint jobs) {
	Block3Data* _data3_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GdkPixbuf* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkPixbuf* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GdkPixbuf* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	PixelTransformation** _tmp20_;
	gint _tmp20__length1;
	GdkPixbuf* _tmp21_;
	gint _tmp22_;
	GdkPixbuf* _tmp23_;
	gint _tmp24_;
	gint width = 0;
	GdkPixbuf* _tmp25_;
	gint _tmp26_;
	gint height = 0;
	GdkPixbuf* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GdkPixbuf* _tmp31_;
	guint8* _tmp32_;
	GdkPixbuf* _tmp33_;
	guint8* _tmp34_;
	gint _tmp35_;
	guint slice_length = 0U;
	gint _tmp37_;
	gint _tmp38_;
	GThread** threads = NULL;
	gint _tmp42_;
	GThread** _tmp43_;
	gint threads_length1;
	gint _threads_size_;
	GThread** _tmp58_;
	gint _tmp58__length1;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->_ref_count_ = 1;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->self = pixel_transformer_ref (self);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = cancellable;
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (_data3_->cancellable);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->cancellable = _tmp1_;
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = source;
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = gdk_pixbuf_get_width (_tmp2_);
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp3_;
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = dest;
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = gdk_pixbuf_get_width (_tmp5_);
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_;
#line 819 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ != _tmp7_) {
#line 820 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:820: PixelTransformer: source and destination" \
" pixbufs must have the same width");
#line 7285 "ColorTransformation.c"
	}
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = source;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = gdk_pixbuf_get_height (_tmp8_);
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = _tmp9_;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = dest;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_;
#line 822 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp10_ != _tmp13_) {
#line 823 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:823: PixelTransformer: source and destination" \
" pixbufs must have the same height");
#line 7303 "ColorTransformation.c"
	}
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = source;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = gdk_pixbuf_get_n_channels (_tmp14_);
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = _tmp15_;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = dest;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = gdk_pixbuf_get_n_channels (_tmp17_);
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = _tmp18_;
#line 825 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp16_ != _tmp19_) {
#line 826 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_error ("ColorTransformation.vala:826: %s", "PixelTransformer: source and destination pixbufs must have the same nu" \
"mber " "of channels");
#line 7321 "ColorTransformation.c"
	}
#line 829 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = self->optimized_transformations;
#line 829 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20__length1 = self->optimized_transformations_length1;
#line 829 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp20_ == NULL) {
#line 830 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_build_optimized_transformations (self);
#line 7331 "ColorTransformation.c"
	}
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = source;
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = gdk_pixbuf_get_n_channels (_tmp21_);
#line 832 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->n_channels = _tmp22_;
#line 833 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = source;
#line 833 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = gdk_pixbuf_get_rowstride (_tmp23_);
#line 833 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->rowstride = _tmp24_;
#line 834 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = source;
#line 834 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = gdk_pixbuf_get_width (_tmp25_);
#line 834 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	width = _tmp26_;
#line 835 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = source;
#line 835 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = gdk_pixbuf_get_height (_tmp27_);
#line 835 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	height = _tmp28_;
#line 836 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _data3_->n_channels;
#line 836 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = width;
#line 836 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->rowbytes = _tmp29_ * _tmp30_;
#line 837 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = source;
#line 837 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = gdk_pixbuf_get_pixels (_tmp31_);
#line 837 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->source_pixels = _tmp32_;
#line 837 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->source_pixels_length1 = -1;
#line 837 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->_source_pixels_size_ = _data3_->source_pixels_length1;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = dest;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = gdk_pixbuf_get_pixels (_tmp33_);
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->dest_pixels = _tmp34_;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->dest_pixels_length1 = -1;
#line 838 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_->_dest_pixels_size_ = _data3_->dest_pixels_length1;
#line 839 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = jobs;
#line 839 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp35_ == -1) {
#line 7387 "ColorTransformation.c"
		guint _tmp36_;
#line 840 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = g_get_num_processors ();
#line 840 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		jobs = ((gint) _tmp36_) - 1;
#line 7393 "ColorTransformation.c"
	}
#line 843 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = height;
#line 843 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	slice_length = (guint) _tmp37_;
#line 844 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = jobs;
#line 844 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp38_ > 0) {
#line 7403 "ColorTransformation.c"
		gint _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_ = height;
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp40_ = jobs;
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp41_ = jobs;
#line 845 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		slice_length = (guint) ((_tmp39_ + (_tmp40_ - 1)) / _tmp41_);
#line 7415 "ColorTransformation.c"
	}
#line 848 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = jobs;
#line 848 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = g_new0 (GThread*, _tmp42_ + 1);
#line 848 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads = _tmp43_;
#line 848 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads_length1 = _tmp42_;
#line 848 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_threads_size_ = threads_length1;
#line 7427 "ColorTransformation.c"
	{
		gint job = 0;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		job = 0;
#line 7432 "ColorTransformation.c"
		{
			gboolean _tmp44_ = FALSE;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp44_ = TRUE;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7439 "ColorTransformation.c"
				Block4Data* _data4_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				guint _tmp49_;
				guint _tmp50_;
				guint _tmp51_;
				gint _tmp52_;
				guint _tmp53_;
				GThread** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				GThread* _tmp56_;
				GThread* _tmp57_;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_ = g_slice_new0 (Block4Data);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_->_ref_count_ = 1;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_->_data3_ = block3_data_ref (_data3_);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp44_) {
#line 7462 "ColorTransformation.c"
					gint _tmp45_;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp45_ = job;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					job = _tmp45_ + 1;
#line 7468 "ColorTransformation.c"
				}
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp44_ = FALSE;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp46_ = job;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = jobs;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp46_ < _tmp47_)) {
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					block4_data_unref (_data4_);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_data4_ = NULL;
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7484 "ColorTransformation.c"
				}
#line 851 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp48_ = job;
#line 851 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49_ = slice_length;
#line 851 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_->row = _tmp48_ * _tmp49_;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_ = _data4_->row;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp51_ = slice_length;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52_ = height;
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = CLAMP (_tmp50_ + _tmp51_, (guint) 0, (guint) _tmp52_);
#line 852 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_->slice_height = _tmp53_;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp54_ = threads;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp54__length1 = threads_length1;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp55_ = job;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_ = g_thread_new ("shotwell-worker", ______lambda4__gthread_func, block4_data_ref (_data4_));
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_thread_unref0 (_tmp54_[_tmp55_]);
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp54_[_tmp55_] = _tmp56_;
#line 854 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp57_ = _tmp54_[_tmp55_];
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				block4_data_unref (_data4_);
#line 850 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_data4_ = NULL;
#line 7520 "ColorTransformation.c"
			}
		}
	}
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = threads;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58__length1 = threads_length1;
#line 7528 "ColorTransformation.c"
	{
		GThread** thread_collection = NULL;
		gint thread_collection_length1 = 0;
		gint _thread_collection_size_ = 0;
		gint thread_it = 0;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		thread_collection = _tmp58_;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		thread_collection_length1 = _tmp58__length1;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		for (thread_it = 0; thread_it < _tmp58__length1; thread_it = thread_it + 1) {
#line 7540 "ColorTransformation.c"
			GThread* _tmp59_;
			GThread* thread = NULL;
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp59_ = _g_thread_ref0 (thread_collection[thread_it]);
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			thread = _tmp59_;
#line 7547 "ColorTransformation.c"
			{
				GThread* _tmp60_;
				GThread* _tmp61_;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp60_ = thread;
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_ = _g_thread_ref0 (_tmp60_);
#line 869 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				g_thread_join (_tmp61_);
#line 868 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_g_thread_unref0 (thread);
#line 7559 "ColorTransformation.c"
			}
		}
	}
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	threads = (_vala_array_free (threads, threads_length1, (GDestroyNotify) g_thread_unref), NULL);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	block3_data_unref (_data3_);
#line 817 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_data3_ = NULL;
#line 7569 "ColorTransformation.c"
}


static void value_pixel_transformer_init (GValue* value) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 7576 "ColorTransformation.c"
}


static void value_pixel_transformer_free_value (GValue* value) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (value->data[0].v_pointer);
#line 7585 "ColorTransformation.c"
	}
}


static void value_pixel_transformer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = pixel_transformer_ref (src_value->data[0].v_pointer);
#line 7595 "ColorTransformation.c"
	} else {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7599 "ColorTransformation.c"
	}
}


static gpointer value_pixel_transformer_peek_pointer (const GValue* value) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 7607 "ColorTransformation.c"
}


static gchar* value_pixel_transformer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 7614 "ColorTransformation.c"
		PixelTransformer * object;
		object = collect_values[0].v_pointer;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7621 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7625 "ColorTransformation.c"
		}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = pixel_transformer_ref (object);
#line 7629 "ColorTransformation.c"
	} else {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 7633 "ColorTransformation.c"
	}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 7637 "ColorTransformation.c"
}


static gchar* value_pixel_transformer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixelTransformer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7648 "ColorTransformation.c"
	}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 7654 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 7658 "ColorTransformation.c"
	} else {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = pixel_transformer_ref (value->data[0].v_pointer);
#line 7662 "ColorTransformation.c"
	}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 7666 "ColorTransformation.c"
}


GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixelTransformer* spec;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXEL_TRANSFORMER), NULL);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 7680 "ColorTransformation.c"
}


gpointer value_get_pixel_transformer (const GValue* value) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER), NULL);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 7689 "ColorTransformation.c"
}


void value_set_pixel_transformer (GValue* value, gpointer v_object) {
	PixelTransformer * old;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_ref (value->data[0].v_pointer);
#line 7709 "ColorTransformation.c"
	} else {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 7713 "ColorTransformation.c"
	}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (old);
#line 7719 "ColorTransformation.c"
	}
}


void value_take_pixel_transformer (GValue* value, gpointer v_object) {
	PixelTransformer * old;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXEL_TRANSFORMER));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXEL_TRANSFORMER));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 7738 "ColorTransformation.c"
	} else {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 7742 "ColorTransformation.c"
	}
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformer_unref (old);
#line 7748 "ColorTransformation.c"
	}
}


static void pixel_transformer_class_init (PixelTransformerClass * klass) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformer_parent_class = g_type_class_peek_parent (klass);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformerClass *) klass)->finalize = pixel_transformer_finalize;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (PixelTransformerPrivate));
#line 7760 "ColorTransformation.c"
}


static void pixel_transformer_instance_init (PixelTransformer * self) {
	GeeArrayList* _tmp0_;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = PIXEL_TRANSFORMER_GET_PRIVATE (self);
#line 683 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = gee_array_list_new (TYPE_PIXEL_TRANSFORMATION, (GBoxedCopyFunc) pixel_transformation_ref, (GDestroyNotify) pixel_transformation_unref, NULL, NULL, NULL);
#line 683 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->transformations = _tmp0_;
#line 685 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = NULL;
#line 685 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations_length1 = 0;
#line 686 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_slots_used = 0;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 7780 "ColorTransformation.c"
}


static void pixel_transformer_finalize (PixelTransformer * obj) {
	PixelTransformer * self;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXEL_TRANSFORMER, PixelTransformer);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 683 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->transformations);
#line 685 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->optimized_transformations = (_vala_array_free (self->optimized_transformations, self->optimized_transformations_length1, (GDestroyNotify) pixel_transformation_unref), NULL);
#line 7794 "ColorTransformation.c"
}


GType pixel_transformer_get_type (void) {
	static volatile gsize pixel_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&pixel_transformer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixel_transformer_init, value_pixel_transformer_free_value, value_pixel_transformer_copy_value, value_pixel_transformer_peek_pointer, "p", value_pixel_transformer_collect_value, "p", value_pixel_transformer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixelTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixel_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixelTransformer), 0, (GInstanceInitFunc) pixel_transformer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixel_transformer_type_id;
		pixel_transformer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixelTransformer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixel_transformer_type_id__volatile, pixel_transformer_type_id);
	}
	return pixel_transformer_type_id__volatile;
}


gpointer pixel_transformer_ref (gpointer instance) {
	PixelTransformer * self;
	self = instance;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 7819 "ColorTransformation.c"
}


void pixel_transformer_unref (gpointer instance) {
	PixelTransformer * self;
	self = instance;
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		PIXEL_TRANSFORMER_GET_CLASS (self)->finalize (self);
#line 682 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7832 "ColorTransformation.c"
	}
}


RGBHistogram* rgb_histogram_construct (GType object_type, GdkPixbuf* pixbuf) {
	RGBHistogram* self = NULL;
	gint sample_bytes = 0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint pixel_bytes = 0;
	gint _tmp2_;
	GdkPixbuf* _tmp3_;
	gint _tmp4_;
	gint row_length_bytes = 0;
	gint _tmp5_;
	GdkPixbuf* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	guchar* pixel_data = NULL;
	GdkPixbuf* _tmp9_;
	guint8* _tmp10_;
	gint pixel_data_length1;
	gint _pixel_data_size_;
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (RGBHistogram*) g_type_create_instance (object_type);
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gdk_pixbuf_get_bits_per_sample (_tmp0_);
#line 899 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	sample_bytes = _tmp1_ / 8;
#line 900 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = sample_bytes;
#line 900 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = pixbuf;
#line 900 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = gdk_pixbuf_get_n_channels (_tmp3_);
#line 900 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_bytes = _tmp2_ * _tmp4_;
#line 901 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = pixel_bytes;
#line 901 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = pixbuf;
#line 901 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
#line 901 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp7_;
#line 901 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	row_length_bytes = _tmp5_ * _tmp8_;
#line 903 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = pixbuf;
#line 903 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = gdk_pixbuf_get_pixels (_tmp9_);
#line 903 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_data = _tmp10_;
#line 903 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_data_length1 = -1;
#line 903 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_data_size_ = pixel_data_length1;
#line 7892 "ColorTransformation.c"
	{
		gint y = 0;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		y = 0;
#line 7897 "ColorTransformation.c"
		{
			gboolean _tmp11_ = FALSE;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = TRUE;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 7904 "ColorTransformation.c"
				gint _tmp13_;
				GdkPixbuf* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint row_start_offset = 0;
				gint _tmp17_;
				GdkPixbuf* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint r_offset = 0;
				gint _tmp21_;
				gint g_offset = 0;
				gint _tmp22_;
				gint _tmp23_;
				gint b_offset = 0;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp11_) {
#line 7925 "ColorTransformation.c"
					gint _tmp12_;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = y;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					y = _tmp12_ + 1;
#line 7931 "ColorTransformation.c"
				}
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = FALSE;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = y;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = pixbuf;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = _tmp15_;
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 905 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 7947 "ColorTransformation.c"
				}
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = y;
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = pixbuf;
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = gdk_pixbuf_get_rowstride (_tmp18_);
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = _tmp19_;
#line 906 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_offset = _tmp17_ * _tmp20_;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp21_ = row_start_offset;
#line 908 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				r_offset = _tmp21_;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = row_start_offset;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = sample_bytes;
#line 909 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				g_offset = _tmp22_ + _tmp23_;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = row_start_offset;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = sample_bytes;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = sample_bytes;
#line 910 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				b_offset = (_tmp24_ + _tmp25_) + _tmp26_;
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 7979 "ColorTransformation.c"
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint* _tmp30_;
					gint _tmp30__length1;
					guchar* _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					guchar _tmp33_;
					gint _tmp34_;
					gint* _tmp35_;
					gint _tmp35__length1;
					guchar* _tmp36_;
					gint _tmp36__length1;
					gint _tmp37_;
					guchar _tmp38_;
					gint _tmp39_;
					gint* _tmp40_;
					gint _tmp40__length1;
					guchar* _tmp41_;
					gint _tmp41__length1;
					gint _tmp42_;
					guchar _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = b_offset;
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = row_start_offset;
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = row_length_bytes;
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp27_ < (_tmp28_ + _tmp29_))) {
#line 912 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 8020 "ColorTransformation.c"
					}
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = self->priv->red_counts;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30__length1 = self->priv->red_counts_length1;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = pixel_data;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31__length1 = pixel_data_length1;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = r_offset;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = _tmp31_[_tmp32_];
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_[_tmp33_] += 1;
#line 913 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp34_ = _tmp30_[_tmp33_];
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_ = self->priv->green_counts;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35__length1 = self->priv->green_counts_length1;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36_ = pixel_data;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp36__length1 = pixel_data_length1;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp37_ = g_offset;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = _tmp36_[_tmp37_];
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp35_[_tmp38_] += 1;
#line 914 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp39_ = _tmp35_[_tmp38_];
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40_ = self->priv->blue_counts;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40__length1 = self->priv->blue_counts_length1;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp41_ = pixel_data;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp41__length1 = pixel_data_length1;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp42_ = b_offset;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp43_ = _tmp41_[_tmp42_];
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp40_[_tmp43_] += 1;
#line 915 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp44_ = _tmp40_[_tmp43_];
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp45_ = r_offset;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp46_ = pixel_bytes;
#line 917 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					r_offset = _tmp45_ + _tmp46_;
#line 918 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp47_ = g_offset;
#line 918 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = pixel_bytes;
#line 918 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					g_offset = _tmp47_ + _tmp48_;
#line 919 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp49_ = b_offset;
#line 919 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp50_ = pixel_bytes;
#line 919 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					b_offset = _tmp49_ + _tmp50_;
#line 8088 "ColorTransformation.c"
				}
			}
		}
	}
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 8095 "ColorTransformation.c"
}


RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf) {
#line 898 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return rgb_histogram_construct (TYPE_RGB_HISTOGRAM, pixbuf);
#line 8102 "ColorTransformation.c"
}


static gint rgb_histogram_correct_snap_to_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp4_;
	gint* _tmp54_;
	gint _tmp54__length1;
	gint _tmp55_;
	gint _tmp56_;
#line 925 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = buckets;
#line 925 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = buckets_length1;
#line 925 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "buckets.length == 256");
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = i;
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ >= 0) {
#line 8127 "ColorTransformation.c"
		gint _tmp3_;
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = i;
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ <= 255;
#line 8133 "ColorTransformation.c"
	} else {
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 8137 "ColorTransformation.c"
	}
#line 926 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp1_, "(i >= 0) && (i <= 255)");
#line 928 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = i;
#line 928 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == 0) {
#line 8145 "ColorTransformation.c"
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		gint _tmp7_;
#line 929 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = buckets;
#line 929 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = buckets_length1;
#line 929 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = i;
#line 929 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[_tmp6_];
#line 929 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp7_ > 0) {
#line 8160 "ColorTransformation.c"
			gint* _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			gint _tmp10_;
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = buckets;
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8__length1 = buckets_length1;
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = i;
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = _tmp8_[_tmp9_ + 1];
#line 930 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp10_ > 0) {
#line 8175 "ColorTransformation.c"
				gint* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				gint* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gint _tmp16_;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = buckets;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11__length1 = buckets_length1;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = i;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = buckets;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14__length1 = buckets_length1;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = i;
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = _tmp14_[_tmp15_ + 1];
#line 931 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp13_ > (2 * _tmp16_)) {
#line 8202 "ColorTransformation.c"
					gint* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					gint _tmp19_;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17_ = buckets;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp17__length1 = buckets_length1;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = i;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = _tmp17_[_tmp18_ + 1];
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					result = _tmp19_;
#line 932 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return result;
#line 8219 "ColorTransformation.c"
				}
			}
		}
	} else {
		gint _tmp20_;
#line 933 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp20_ = i;
#line 933 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp20_ == 255) {
#line 8229 "ColorTransformation.c"
			gint* _tmp21_;
			gint _tmp21__length1;
			gint _tmp22_;
			gint _tmp23_;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21_ = buckets;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21__length1 = buckets_length1;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = i;
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp23_ = _tmp21_[_tmp22_];
#line 934 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp23_ > 0) {
#line 8244 "ColorTransformation.c"
				gint* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				gint _tmp26_;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = buckets;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24__length1 = buckets_length1;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = i;
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = _tmp24_[_tmp25_ - 1];
#line 935 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp26_ > 0) {
#line 8259 "ColorTransformation.c"
					gint* _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					gint _tmp29_;
					gint* _tmp30_;
					gint _tmp30__length1;
					gint _tmp31_;
					gint _tmp32_;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27_ = buckets;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp27__length1 = buckets_length1;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp28_ = i;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp29_ = _tmp27_[_tmp28_];
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = buckets;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30__length1 = buckets_length1;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp31_ = i;
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp32_ = _tmp30_[_tmp31_ - 1];
#line 936 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp29_ > (2 * _tmp32_)) {
#line 8286 "ColorTransformation.c"
						gint* _tmp33_;
						gint _tmp33__length1;
						gint _tmp34_;
						gint _tmp35_;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp33_ = buckets;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp33__length1 = buckets_length1;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp34_ = i;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp35_ = _tmp33_[_tmp34_ - 1];
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						result = _tmp35_;
#line 937 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						return result;
#line 8303 "ColorTransformation.c"
					}
				}
			}
		} else {
			gint* _tmp36_;
			gint _tmp36__length1;
			gint _tmp37_;
			gint _tmp38_;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp36_ = buckets;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp36__length1 = buckets_length1;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp37_ = i;
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp38_ = _tmp36_[_tmp37_];
#line 939 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp38_ > 0) {
#line 8322 "ColorTransformation.c"
				gint* _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				gint _tmp41_;
				gint* _tmp42_;
				gint _tmp42__length1;
				gint _tmp43_;
				gint _tmp44_;
				gint* _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_;
				gint _tmp47_;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = buckets;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39__length1 = buckets_length1;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = i;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_ = _tmp39_[_tmp40_];
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42_ = buckets;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42__length1 = buckets_length1;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43_ = i;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp44_ = _tmp42_[_tmp43_ - 1];
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45_ = buckets;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45__length1 = buckets_length1;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp46_ = i;
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = _tmp45_[_tmp46_ + 1];
#line 940 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp41_ > ((_tmp44_ + _tmp47_) / 2)) {
#line 8361 "ColorTransformation.c"
					gint* _tmp48_;
					gint _tmp48__length1;
					gint _tmp49_;
					gint _tmp50_;
					gint* _tmp51_;
					gint _tmp51__length1;
					gint _tmp52_;
					gint _tmp53_;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = buckets;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48__length1 = buckets_length1;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp49_ = i;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp50_ = _tmp48_[_tmp49_ - 1];
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp51_ = buckets;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp51__length1 = buckets_length1;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp52_ = i;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp53_ = _tmp51_[_tmp52_ + 1];
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					result = (_tmp50_ + _tmp53_) / 2;
#line 941 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					return result;
#line 8390 "ColorTransformation.c"
				}
			}
		}
	}
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = buckets;
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54__length1 = buckets_length1;
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = i;
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = _tmp54_[_tmp55_];
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp56_;
#line 944 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 8407 "ColorTransformation.c"
}


static gint rgb_histogram_correct_snap_from_quantization (RGBHistogram* self, gint* buckets, int buckets_length1, gint i) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp4_;
	gint* _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_;
	gint _tmp29_;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = buckets;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = buckets_length1;
#line 948 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "buckets.length == 256");
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = i;
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ >= 0) {
#line 8432 "ColorTransformation.c"
		gint _tmp3_;
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = i;
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ <= 255;
#line 8438 "ColorTransformation.c"
	} else {
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 8442 "ColorTransformation.c"
	}
#line 949 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp1_, "(i >= 0) && (i <= 255)");
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = i;
#line 951 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == 0) {
#line 8450 "ColorTransformation.c"
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		gint _tmp7_;
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5_ = buckets;
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp5__length1 = buckets_length1;
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = i;
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = _tmp5_[_tmp6_];
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		result = _tmp7_;
#line 952 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return result;
#line 8467 "ColorTransformation.c"
	} else {
		gint _tmp8_;
#line 953 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = i;
#line 953 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp8_ == 255) {
#line 8474 "ColorTransformation.c"
			gint* _tmp9_;
			gint _tmp9__length1;
			gint _tmp10_;
			gint _tmp11_;
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = buckets;
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9__length1 = buckets_length1;
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = i;
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = _tmp9_[_tmp10_];
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp11_;
#line 954 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 8491 "ColorTransformation.c"
		} else {
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gint _tmp14_;
#line 956 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = buckets;
#line 956 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12__length1 = buckets_length1;
#line 956 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = i;
#line 956 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = _tmp12_[_tmp13_];
#line 956 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp14_ == 0) {
#line 8507 "ColorTransformation.c"
				gint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint _tmp17_;
#line 957 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = buckets;
#line 957 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15__length1 = buckets_length1;
#line 957 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = i;
#line 957 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = _tmp15_[_tmp16_ - 1];
#line 957 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp17_ > 0) {
#line 8522 "ColorTransformation.c"
					gint* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					gint _tmp20_;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = buckets;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18__length1 = buckets_length1;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = i;
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = _tmp18_[_tmp19_ + 1];
#line 958 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp20_ > 0) {
#line 8537 "ColorTransformation.c"
						gint* _tmp21_;
						gint _tmp21__length1;
						gint _tmp22_;
						gint _tmp23_;
						gint* _tmp24_;
						gint _tmp24__length1;
						gint _tmp25_;
						gint _tmp26_;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21_ = buckets;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21__length1 = buckets_length1;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22_ = i;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp23_ = _tmp21_[_tmp22_ - 1];
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24_ = buckets;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24__length1 = buckets_length1;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp25_ = i;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp26_ = _tmp24_[_tmp25_ + 1];
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						result = (_tmp23_ + _tmp26_) / 2;
#line 959 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						return result;
#line 8566 "ColorTransformation.c"
					}
				}
			}
		}
	}
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = buckets;
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27__length1 = buckets_length1;
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = i;
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp27_[_tmp28_];
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp29_;
#line 962 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 8584 "ColorTransformation.c"
}


static void rgb_histogram_smooth_extrema (RGBHistogram* self, gint** count_data, int* count_data_length1) {
	gint* _tmp0_;
	gint _tmp0__length1;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gint _tmp8_;
	gint* _tmp9_;
	gint _tmp9__length1;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	gint* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	gint* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gint _tmp18_;
	gint* _tmp19_;
	gint _tmp19__length1;
	gint* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	gint* _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	gint* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	gint* _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	gint* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	gint _tmp30_;
	gint* _tmp31_;
	gint _tmp31__length1;
	gint* _tmp32_;
	gint _tmp32__length1;
	gint _tmp33_;
	gint* _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	gint* _tmp36_;
	gint _tmp36__length1;
	gint _tmp37_;
	gint* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gint* _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	gint _tmp42_;
	gint* _tmp43_;
	gint _tmp43__length1;
	gint* _tmp44_;
	gint _tmp44__length1;
	gint _tmp45_;
	gint* _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	gint* _tmp48_;
	gint _tmp48__length1;
	gint _tmp49_;
	gint* _tmp50_;
	gint _tmp50__length1;
	gint _tmp51_;
	gint* _tmp52_;
	gint _tmp52__length1;
	gint _tmp53_;
	gint _tmp54_;
	gint* _tmp55_;
	gint _tmp55__length1;
	gint* _tmp56_;
	gint _tmp56__length1;
	gint _tmp57_;
	gint* _tmp58_;
	gint _tmp58__length1;
	gint _tmp59_;
	gint* _tmp60_;
	gint _tmp60__length1;
	gint _tmp61_;
	gint _tmp62_;
	gint* _tmp63_;
	gint _tmp63__length1;
	gint* _tmp64_;
	gint _tmp64__length1;
	gint _tmp65_;
	gint* _tmp66_;
	gint _tmp66__length1;
	gint _tmp67_;
	gint* _tmp68_;
	gint _tmp68__length1;
	gint _tmp69_;
	gint* _tmp70_;
	gint _tmp70__length1;
	gint _tmp71_;
	gint _tmp72_;
	gint* _tmp73_;
	gint _tmp73__length1;
	gint* _tmp74_;
	gint _tmp74__length1;
	gint _tmp75_;
	gint* _tmp76_;
	gint _tmp76__length1;
	gint _tmp77_;
	gint* _tmp78_;
	gint _tmp78__length1;
	gint _tmp79_;
	gint* _tmp80_;
	gint _tmp80__length1;
	gint _tmp81_;
	gint* _tmp82_;
	gint _tmp82__length1;
	gint _tmp83_;
	gint _tmp84_;
	gint* _tmp85_;
	gint _tmp85__length1;
	gint* _tmp86_;
	gint _tmp86__length1;
	gint _tmp87_;
	gint* _tmp88_;
	gint _tmp88__length1;
	gint _tmp89_;
	gint* _tmp90_;
	gint _tmp90__length1;
	gint _tmp91_;
	gint* _tmp92_;
	gint _tmp92__length1;
	gint _tmp93_;
	gint* _tmp94_;
	gint _tmp94__length1;
	gint _tmp95_;
	gint _tmp96_;
	gint* _tmp97_;
	gint _tmp97__length1;
	gint* _tmp98_;
	gint _tmp98__length1;
	gint _tmp99_;
	gint* _tmp100_;
	gint _tmp100__length1;
	gint _tmp101_;
	gint* _tmp102_;
	gint _tmp102__length1;
	gint _tmp103_;
	gint* _tmp104_;
	gint _tmp104__length1;
	gint _tmp105_;
	gint* _tmp106_;
	gint _tmp106__length1;
	gint _tmp107_;
	gint _tmp108_;
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = *count_data;
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0__length1 = *count_data_length1;
#line 966 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (_tmp0__length1 == 256, "count_data.length == 256");
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = *count_data;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1__length1 = *count_data_length1;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = *count_data;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = *count_data_length1;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_[0];
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = *count_data;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4__length1 = *count_data_length1;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = _tmp4_[1];
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = *count_data;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6__length1 = *count_data_length1;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = _tmp6_[2];
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_[0] = (((5 * _tmp3_) + (3 * _tmp5_)) + (2 * _tmp7_)) / 10;
#line 972 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = _tmp1_[0];
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = *count_data;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9__length1 = *count_data_length1;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = *count_data;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10__length1 = *count_data_length1;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = _tmp10_[0];
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12_ = *count_data;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp12__length1 = *count_data_length1;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp13_ = _tmp12_[1];
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14_ = *count_data;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp14__length1 = *count_data_length1;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp15_ = _tmp14_[2];
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16_ = *count_data;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp16__length1 = *count_data_length1;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp17_ = _tmp16_[3];
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_[1] = ((((3 * _tmp11_) + (5 * _tmp13_)) + (3 * _tmp15_)) + (2 * _tmp17_)) / 13;
#line 974 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp18_ = _tmp9_[1];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp20__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp21_ = _tmp20_[0];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp22__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp23_ = _tmp22_[1];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp24__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp25_ = _tmp24_[2];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp26__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp27_ = _tmp26_[3];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28_ = *count_data;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp28__length1 = *count_data_length1;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp29_ = _tmp28_[4];
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_[2] = (((((2 * _tmp21_) + (3 * _tmp23_)) + (5 * _tmp25_)) + (3 * _tmp27_)) + (2 * _tmp29_)) / 15;
#line 976 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp30_ = _tmp19_[2];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp32__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp33_ = _tmp32_[1];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp34__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp35_ = _tmp34_[2];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp36__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp37_ = _tmp36_[3];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp38__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp39_ = _tmp38_[4];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40_ = *count_data;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp40__length1 = *count_data_length1;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = _tmp40_[5];
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp31_[3] = (((((2 * _tmp33_) + (3 * _tmp35_)) + (5 * _tmp37_)) + (3 * _tmp39_)) + (2 * _tmp41_)) / 15;
#line 978 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = _tmp31_[3];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = _tmp44_[2];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = _tmp46_[3];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = _tmp48_[4];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_[5];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = *count_data;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52__length1 = *count_data_length1;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = _tmp52_[6];
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_[4] = (((((2 * _tmp45_) + (3 * _tmp47_)) + (5 * _tmp49_)) + (3 * _tmp51_)) + (2 * _tmp53_)) / 15;
#line 980 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp43_[4];
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = *count_data;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55__length1 = *count_data_length1;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = *count_data;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56__length1 = *count_data_length1;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_[255];
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = *count_data;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58__length1 = *count_data_length1;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = _tmp58_[254];
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = *count_data;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60__length1 = *count_data_length1;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = _tmp60_[253];
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_[255] = (((5 * _tmp57_) + (3 * _tmp59_)) + (2 * _tmp61_)) / 10;
#line 983 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = _tmp55_[255];
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = *count_data;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63__length1 = *count_data_length1;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64_ = *count_data;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp64__length1 = *count_data_length1;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp65_ = _tmp64_[255];
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66_ = *count_data;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp66__length1 = *count_data_length1;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp67_ = _tmp66_[254];
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68_ = *count_data;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp68__length1 = *count_data_length1;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp69_ = _tmp68_[253];
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70_ = *count_data;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp70__length1 = *count_data_length1;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp71_ = _tmp70_[252];
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_[254] = ((((3 * _tmp65_) + (5 * _tmp67_)) + (3 * _tmp69_)) + (2 * _tmp71_)) / 13;
#line 985 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp72_ = _tmp63_[254];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp74__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp75_ = _tmp74_[255];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp76__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp77_ = _tmp76_[254];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp78__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp79_ = _tmp78_[253];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp80__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp81_ = _tmp80_[252];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82_ = *count_data;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp82__length1 = *count_data_length1;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp83_ = _tmp82_[251];
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp73_[253] = (((((2 * _tmp75_) + (3 * _tmp77_)) + (5 * _tmp79_)) + (3 * _tmp81_)) + (2 * _tmp83_)) / 15;
#line 987 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp84_ = _tmp73_[253];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp86__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = _tmp86_[254];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp89_ = _tmp88_[253];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp90__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp91_ = _tmp90_[252];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp92__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp93_ = _tmp92_[251];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94_ = *count_data;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp94__length1 = *count_data_length1;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp95_ = _tmp94_[250];
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp85_[252] = (((((2 * _tmp87_) + (3 * _tmp89_)) + (5 * _tmp91_)) + (3 * _tmp93_)) + (2 * _tmp95_)) / 15;
#line 989 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp96_ = _tmp85_[252];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp98__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp99_ = _tmp98_[253];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp100__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp101_ = _tmp100_[252];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp102__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp103_ = _tmp102_[251];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp104__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp105_ = _tmp104_[250];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106_ = *count_data;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp106__length1 = *count_data_length1;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp107_ = _tmp106_[249];
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp97_[251] = (((((2 * _tmp99_) + (3 * _tmp101_)) + (5 * _tmp103_)) + (3 * _tmp105_)) + (2 * _tmp107_)) / 15;
#line 991 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp108_ = _tmp97_[251];
#line 9103 "ColorTransformation.c"
}


static void rgb_histogram_prepare_qualitative_counts (RGBHistogram* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint* _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_;
	gint* temp_red_counts = NULL;
	gint* _tmp8_;
	gint temp_red_counts_length1;
	gint _temp_red_counts_size_;
	gint* temp_green_counts = NULL;
	gint* _tmp9_;
	gint temp_green_counts_length1;
	gint _temp_green_counts_size_;
	gint* temp_blue_counts = NULL;
	gint* _tmp10_;
	gint temp_blue_counts_length1;
	gint _temp_blue_counts_size_;
	gint mean_qual_count = 0;
	gint _tmp87_;
	gint constrained_max_qual_count = 0;
	gint _tmp88_;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->qualitative_red_counts;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = self->priv->qualitative_red_counts_length1;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp2_ != NULL) {
#line 9137 "ColorTransformation.c"
		gint* _tmp3_;
		gint _tmp3__length1;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = self->priv->qualitative_green_counts;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3__length1 = self->priv->qualitative_green_counts_length1;
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 9146 "ColorTransformation.c"
	} else {
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = FALSE;
#line 9150 "ColorTransformation.c"
	}
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_) {
#line 9154 "ColorTransformation.c"
		gint* _tmp4_;
		gint _tmp4__length1;
#line 997 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = self->priv->qualitative_blue_counts;
#line 997 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4__length1 = self->priv->qualitative_blue_counts_length1;
#line 997 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 9163 "ColorTransformation.c"
	} else {
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 9167 "ColorTransformation.c"
	}
#line 996 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_) {
#line 998 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return;
#line 9173 "ColorTransformation.c"
	}
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = g_new0 (gint, 256);
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = _tmp5_;
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts_length1 = 256;
#line 1000 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = g_new0 (gint, 256);
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = _tmp6_;
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts_length1 = 256;
#line 1001 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = g_new0 (gint, 256);
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = _tmp7_;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts_length1 = 256;
#line 1002 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = g_new0 (gint, 256);
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts = _tmp8_;
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts_length1 = 256;
#line 1004 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_red_counts_size_ = temp_red_counts_length1;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = g_new0 (gint, 256);
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts = _tmp9_;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts_length1 = 256;
#line 1005 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_green_counts_size_ = temp_green_counts_length1;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = g_new0 (gint, 256);
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts = _tmp10_;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts_length1 = 256;
#line 1006 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_temp_blue_counts_size_ = temp_blue_counts_length1;
#line 9229 "ColorTransformation.c"
	{
		gint i = 0;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9234 "ColorTransformation.c"
		{
			gboolean _tmp11_ = FALSE;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = TRUE;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9241 "ColorTransformation.c"
				gint _tmp13_;
				gint* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gint* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				gint* _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp11_) {
#line 9269 "ColorTransformation.c"
					gint _tmp12_;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = i;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp12_ + 1;
#line 9275 "ColorTransformation.c"
				}
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = FALSE;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = i;
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp13_ < 256)) {
#line 1012 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9285 "ColorTransformation.c"
				}
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = self->priv->qualitative_red_counts;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14__length1 = self->priv->qualitative_red_counts_length1;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = i;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = self->priv->red_counts;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16__length1 = self->priv->red_counts_length1;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = i;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = rgb_histogram_correct_snap_from_quantization (self, _tmp16_, _tmp16__length1, _tmp17_);
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_[_tmp15_] = _tmp18_;
#line 1013 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = _tmp14_[_tmp15_];
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_ = self->priv->qualitative_green_counts;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20__length1 = self->priv->qualitative_green_counts_length1;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp21_ = i;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22_ = self->priv->green_counts;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp22__length1 = self->priv->green_counts_length1;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = i;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp24_ = rgb_histogram_correct_snap_from_quantization (self, _tmp22_, _tmp22__length1, _tmp23_);
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp20_[_tmp21_] = _tmp24_;
#line 1015 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp25_ = _tmp20_[_tmp21_];
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_ = self->priv->qualitative_blue_counts;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26__length1 = self->priv->qualitative_blue_counts_length1;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp27_ = i;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28_ = self->priv->blue_counts;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp28__length1 = self->priv->blue_counts_length1;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = i;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp30_ = rgb_histogram_correct_snap_from_quantization (self, _tmp28_, _tmp28__length1, _tmp29_);
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp26_[_tmp27_] = _tmp30_;
#line 1017 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = _tmp26_[_tmp27_];
#line 9341 "ColorTransformation.c"
			}
		}
	}
	{
		gint i = 0;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9349 "ColorTransformation.c"
		{
			gboolean _tmp32_ = FALSE;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp32_ = TRUE;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9356 "ColorTransformation.c"
				gint _tmp34_;
				gint* _tmp35_;
				gint _tmp35__length1;
				gint _tmp36_;
				gint* _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint* _tmp41_;
				gint _tmp41__length1;
				gint _tmp42_;
				gint* _tmp43_;
				gint _tmp43__length1;
				gint _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint* _tmp47_;
				gint _tmp47__length1;
				gint _tmp48_;
				gint* _tmp49_;
				gint _tmp49__length1;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp32_) {
#line 9384 "ColorTransformation.c"
					gint _tmp33_;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp33_ = i;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp33_ + 1;
#line 9390 "ColorTransformation.c"
				}
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = FALSE;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp34_ = i;
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp34_ < 256)) {
#line 1021 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9400 "ColorTransformation.c"
				}
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_ = temp_red_counts;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35__length1 = temp_red_counts_length1;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp36_ = i;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37_ = self->priv->qualitative_red_counts;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp37__length1 = self->priv->qualitative_red_counts_length1;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp38_ = i;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp39_ = _tmp37_[_tmp38_];
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp35_[_tmp36_] = _tmp39_;
#line 1022 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp40_ = _tmp35_[_tmp36_];
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_ = temp_green_counts;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41__length1 = temp_green_counts_length1;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp42_ = i;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43_ = self->priv->qualitative_green_counts;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp43__length1 = self->priv->qualitative_green_counts_length1;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp44_ = i;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp45_ = _tmp43_[_tmp44_];
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp41_[_tmp42_] = _tmp45_;
#line 1023 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp46_ = _tmp41_[_tmp42_];
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = temp_blue_counts;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47__length1 = temp_blue_counts_length1;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp48_ = i;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49_ = self->priv->qualitative_blue_counts;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49__length1 = self->priv->qualitative_blue_counts_length1;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_ = i;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp51_ = _tmp49_[_tmp50_];
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_[_tmp48_] = _tmp51_;
#line 1024 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52_ = _tmp47_[_tmp48_];
#line 9456 "ColorTransformation.c"
			}
		}
	}
	{
		gint i = 0;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9464 "ColorTransformation.c"
		{
			gboolean _tmp53_ = FALSE;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp53_ = TRUE;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9471 "ColorTransformation.c"
				gint _tmp55_;
				gint* _tmp56_;
				gint _tmp56__length1;
				gint _tmp57_;
				gint* _tmp58_;
				gint _tmp58__length1;
				gint _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				gint* _tmp62_;
				gint _tmp62__length1;
				gint _tmp63_;
				gint* _tmp64_;
				gint _tmp64__length1;
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				gint* _tmp68_;
				gint _tmp68__length1;
				gint _tmp69_;
				gint* _tmp70_;
				gint _tmp70__length1;
				gint _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp53_) {
#line 9499 "ColorTransformation.c"
					gint _tmp54_;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp54_ = i;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp54_ + 1;
#line 9505 "ColorTransformation.c"
				}
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = FALSE;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp55_ = i;
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp55_ < 256)) {
#line 1029 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9515 "ColorTransformation.c"
				}
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_ = self->priv->qualitative_red_counts;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56__length1 = self->priv->qualitative_red_counts_length1;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp57_ = i;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58_ = temp_red_counts;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58__length1 = temp_red_counts_length1;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp59_ = i;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp60_ = rgb_histogram_correct_snap_to_quantization (self, _tmp58_, _tmp58__length1, _tmp59_);
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_[_tmp57_] = _tmp60_;
#line 1030 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_ = _tmp56_[_tmp57_];
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_ = self->priv->qualitative_green_counts;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62__length1 = self->priv->qualitative_green_counts_length1;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp63_ = i;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64_ = temp_green_counts;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64__length1 = temp_green_counts_length1;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp65_ = i;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp66_ = rgb_histogram_correct_snap_to_quantization (self, _tmp64_, _tmp64__length1, _tmp65_);
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_[_tmp63_] = _tmp66_;
#line 1032 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp67_ = _tmp62_[_tmp63_];
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68_ = self->priv->qualitative_blue_counts;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68__length1 = self->priv->qualitative_blue_counts_length1;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp69_ = i;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp70_ = temp_blue_counts;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp70__length1 = temp_blue_counts_length1;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp71_ = i;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp72_ = rgb_histogram_correct_snap_to_quantization (self, _tmp70_, _tmp70__length1, _tmp71_);
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp68_[_tmp69_] = _tmp72_;
#line 1034 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp73_ = _tmp68_[_tmp69_];
#line 9571 "ColorTransformation.c"
			}
		}
	}
#line 1040 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	mean_qual_count = 0;
#line 9577 "ColorTransformation.c"
	{
		gint i = 0;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9582 "ColorTransformation.c"
		{
			gboolean _tmp74_ = FALSE;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp74_ = TRUE;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9589 "ColorTransformation.c"
				gint _tmp76_;
				gint _tmp77_;
				gint* _tmp78_;
				gint _tmp78__length1;
				gint _tmp79_;
				gint _tmp80_;
				gint* _tmp81_;
				gint _tmp81__length1;
				gint _tmp82_;
				gint _tmp83_;
				gint* _tmp84_;
				gint _tmp84__length1;
				gint _tmp85_;
				gint _tmp86_;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp74_) {
#line 9606 "ColorTransformation.c"
					gint _tmp75_;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp75_ = i;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp75_ + 1;
#line 9612 "ColorTransformation.c"
				}
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp74_ = FALSE;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp76_ = i;
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp76_ < 256)) {
#line 1041 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9622 "ColorTransformation.c"
				}
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp77_ = mean_qual_count;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp78_ = self->priv->qualitative_red_counts;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp78__length1 = self->priv->qualitative_red_counts_length1;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp79_ = i;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp80_ = _tmp78_[_tmp79_];
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp81_ = self->priv->qualitative_green_counts;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp81__length1 = self->priv->qualitative_green_counts_length1;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp82_ = i;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp83_ = _tmp81_[_tmp82_];
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp84_ = self->priv->qualitative_blue_counts;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp84__length1 = self->priv->qualitative_blue_counts_length1;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp85_ = i;
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp86_ = _tmp84_[_tmp85_];
#line 1042 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				mean_qual_count = _tmp77_ + ((_tmp80_ + _tmp83_) + _tmp86_);
#line 9652 "ColorTransformation.c"
			}
		}
	}
#line 1045 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp87_ = mean_qual_count;
#line 1045 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	mean_qual_count = _tmp87_ / (256 * 3);
#line 1046 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp88_ = mean_qual_count;
#line 1046 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	constrained_max_qual_count = 8 * _tmp88_;
#line 9664 "ColorTransformation.c"
	{
		gint i = 0;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 9669 "ColorTransformation.c"
		{
			gboolean _tmp89_ = FALSE;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp89_ = TRUE;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 9676 "ColorTransformation.c"
				gint _tmp91_;
				gint* _tmp92_;
				gint _tmp92__length1;
				gint _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint* _tmp100_;
				gint _tmp100__length1;
				gint _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				gint* _tmp108_;
				gint _tmp108__length1;
				gint _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp89_) {
#line 9695 "ColorTransformation.c"
					gint _tmp90_;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp90_ = i;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp90_ + 1;
#line 9701 "ColorTransformation.c"
				}
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp89_ = FALSE;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp91_ = i;
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp91_ < 256)) {
#line 1047 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 9711 "ColorTransformation.c"
				}
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp92_ = self->priv->qualitative_red_counts;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp92__length1 = self->priv->qualitative_red_counts_length1;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp93_ = i;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp94_ = _tmp92_[_tmp93_];
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp95_ = constrained_max_qual_count;
#line 1048 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp94_ > _tmp95_) {
#line 9725 "ColorTransformation.c"
					gint* _tmp96_;
					gint _tmp96__length1;
					gint _tmp97_;
					gint _tmp98_;
					gint _tmp99_;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96_ = self->priv->qualitative_red_counts;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96__length1 = self->priv->qualitative_red_counts_length1;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp97_ = i;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp98_ = constrained_max_qual_count;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp96_[_tmp97_] = _tmp98_;
#line 1049 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp99_ = _tmp96_[_tmp97_];
#line 9743 "ColorTransformation.c"
				}
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp100_ = self->priv->qualitative_green_counts;
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp100__length1 = self->priv->qualitative_green_counts_length1;
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp101_ = i;
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp102_ = _tmp100_[_tmp101_];
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp103_ = constrained_max_qual_count;
#line 1051 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp102_ > _tmp103_) {
#line 9757 "ColorTransformation.c"
					gint* _tmp104_;
					gint _tmp104__length1;
					gint _tmp105_;
					gint _tmp106_;
					gint _tmp107_;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104_ = self->priv->qualitative_green_counts;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104__length1 = self->priv->qualitative_green_counts_length1;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp105_ = i;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp106_ = constrained_max_qual_count;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp104_[_tmp105_] = _tmp106_;
#line 1052 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp107_ = _tmp104_[_tmp105_];
#line 9775 "ColorTransformation.c"
				}
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp108_ = self->priv->qualitative_blue_counts;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp108__length1 = self->priv->qualitative_blue_counts_length1;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp109_ = i;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp110_ = _tmp108_[_tmp109_];
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp111_ = constrained_max_qual_count;
#line 1054 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (_tmp110_ > _tmp111_) {
#line 9789 "ColorTransformation.c"
					gint* _tmp112_;
					gint _tmp112__length1;
					gint _tmp113_;
					gint _tmp114_;
					gint _tmp115_;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112_ = self->priv->qualitative_blue_counts;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112__length1 = self->priv->qualitative_blue_counts_length1;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp113_ = i;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp114_ = constrained_max_qual_count;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp112_[_tmp113_] = _tmp114_;
#line 1055 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp115_ = _tmp112_[_tmp113_];
#line 9807 "ColorTransformation.c"
				}
			}
		}
	}
#line 1058 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_red_counts, &self->priv->qualitative_red_counts_length1);
#line 1059 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_green_counts, &self->priv->qualitative_green_counts_length1);
#line 1060 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_smooth_extrema (self, &self->priv->qualitative_blue_counts, &self->priv->qualitative_blue_counts_length1);
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_blue_counts = (g_free (temp_blue_counts), NULL);
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_green_counts = (g_free (temp_green_counts), NULL);
#line 995 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	temp_red_counts = (g_free (temp_red_counts), NULL);
#line 9824 "ColorTransformation.c"
}


GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp121_;
	GdkPixbuf* _tmp122_;
#line 1064 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->graphic;
#line 1064 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ == NULL) {
#line 9837 "ColorTransformation.c"
		gint max_count = 0;
		GdkPixbuf* _tmp25_;
		gint rowstride = 0;
		GdkPixbuf* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint sample_bytes = 0;
		GdkPixbuf* _tmp29_;
		gint _tmp30_;
		gint pixel_bytes = 0;
		gint _tmp31_;
		GdkPixbuf* _tmp32_;
		gint _tmp33_;
		gdouble scale_bar = 0.0;
		gint _tmp34_;
		guchar* pixel_data = NULL;
		GdkPixbuf* _tmp35_;
		guint8* _tmp36_;
		gint pixel_data_length1;
		gint _pixel_data_size_;
		gint _tmp37_;
#line 1065 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_prepare_qualitative_counts (self);
#line 1066 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		max_count = 0;
#line 9863 "ColorTransformation.c"
		{
			gint i = 0;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			i = 0;
#line 9868 "ColorTransformation.c"
			{
				gboolean _tmp1_ = FALSE;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp1_ = TRUE;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 9875 "ColorTransformation.c"
					gint _tmp3_;
					gint* _tmp4_;
					gint _tmp4__length1;
					gint _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					gint* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gint* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!_tmp1_) {
#line 9894 "ColorTransformation.c"
						gint _tmp2_;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp2_ = i;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						i = _tmp2_ + 1;
#line 9900 "ColorTransformation.c"
					}
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp1_ = FALSE;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp3_ = i;
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp3_ < 256)) {
#line 1067 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 9910 "ColorTransformation.c"
					}
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp4_ = self->priv->qualitative_red_counts;
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp4__length1 = self->priv->qualitative_red_counts_length1;
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp5_ = i;
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp6_ = _tmp4_[_tmp5_];
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp7_ = max_count;
#line 1068 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp6_ > _tmp7_) {
#line 9924 "ColorTransformation.c"
						gint* _tmp8_;
						gint _tmp8__length1;
						gint _tmp9_;
						gint _tmp10_;
#line 1069 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp8_ = self->priv->qualitative_red_counts;
#line 1069 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp8__length1 = self->priv->qualitative_red_counts_length1;
#line 1069 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp9_ = i;
#line 1069 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp10_ = _tmp8_[_tmp9_];
#line 1069 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp10_;
#line 9939 "ColorTransformation.c"
					}
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11_ = self->priv->qualitative_green_counts;
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp11__length1 = self->priv->qualitative_green_counts_length1;
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp12_ = i;
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = _tmp11_[_tmp12_];
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp14_ = max_count;
#line 1070 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp13_ > _tmp14_) {
#line 9953 "ColorTransformation.c"
						gint* _tmp15_;
						gint _tmp15__length1;
						gint _tmp16_;
						gint _tmp17_;
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp15_ = self->priv->qualitative_green_counts;
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp15__length1 = self->priv->qualitative_green_counts_length1;
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp16_ = i;
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp17_ = _tmp15_[_tmp16_];
#line 1071 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp17_;
#line 9968 "ColorTransformation.c"
					}
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18_ = self->priv->qualitative_blue_counts;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp18__length1 = self->priv->qualitative_blue_counts_length1;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp19_ = i;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = _tmp18_[_tmp19_];
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp21_ = max_count;
#line 1072 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (_tmp20_ > _tmp21_) {
#line 9982 "ColorTransformation.c"
						gint* _tmp22_;
						gint _tmp22__length1;
						gint _tmp23_;
						gint _tmp24_;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22_ = self->priv->qualitative_blue_counts;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp22__length1 = self->priv->qualitative_blue_counts_length1;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp23_ = i;
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp24_ = _tmp22_[_tmp23_];
#line 1073 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						max_count = _tmp24_;
#line 9997 "ColorTransformation.c"
					}
				}
			}
		}
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, RGB_HISTOGRAM_GRAPHIC_WIDTH, RGB_HISTOGRAM_GRAPHIC_HEIGHT);
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_g_object_unref0 (self->priv->graphic);
#line 1076 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->graphic = _tmp25_;
#line 1079 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = self->priv->graphic;
#line 1079 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = gdk_pixbuf_get_rowstride (_tmp26_);
#line 1079 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = _tmp27_;
#line 1079 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rowstride = _tmp28_;
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp29_ = self->priv->graphic;
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp30_ = gdk_pixbuf_get_bits_per_sample (_tmp29_);
#line 1080 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		sample_bytes = _tmp30_ / 8;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp31_ = sample_bytes;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp32_ = self->priv->graphic;
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp33_ = gdk_pixbuf_get_n_channels (_tmp32_);
#line 1081 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_bytes = _tmp31_ * _tmp33_;
#line 1083 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp34_ = max_count;
#line 1083 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		scale_bar = (0.98 * ((gdouble) RGB_HISTOGRAM_GRAPHIC_HEIGHT)) / ((gdouble) _tmp34_);
#line 1086 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = self->priv->graphic;
#line 1086 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = gdk_pixbuf_get_pixels (_tmp35_);
#line 1086 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_data = _tmp36_;
#line 1086 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_data_length1 = -1;
#line 1086 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_data_size_ = pixel_data_length1;
#line 1090 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = max_count;
#line 1090 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp37_ == 0) {
#line 10048 "ColorTransformation.c"
			GdkPixbuf* _tmp51_;
			GdkPixbuf* _tmp52_;
			{
				gint i = 0;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = 0;
#line 10055 "ColorTransformation.c"
				{
					gboolean _tmp38_ = FALSE;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp38_ = TRUE;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					while (TRUE) {
#line 10062 "ColorTransformation.c"
						gint _tmp40_;
						gint _tmp41_;
						GdkPixbuf* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						GdkPixbuf* _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						guchar* _tmp48_;
						gint _tmp48__length1;
						gint _tmp49_;
						guchar _tmp50_;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						if (!_tmp38_) {
#line 10077 "ColorTransformation.c"
							gint _tmp39_;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = i;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							i = _tmp39_ + 1;
#line 10083 "ColorTransformation.c"
						}
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp38_ = FALSE;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp40_ = i;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp41_ = pixel_bytes;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp42_ = self->priv->graphic;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp43_ = gdk_pixbuf_get_width (_tmp42_);
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp44_ = _tmp43_;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp45_ = self->priv->graphic;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp46_ = gdk_pixbuf_get_height (_tmp45_);
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp47_ = _tmp46_;
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						if (!(_tmp40_ < ((_tmp41_ * _tmp44_) * _tmp47_))) {
#line 1091 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							break;
#line 10107 "ColorTransformation.c"
						}
#line 1092 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48_ = pixel_data;
#line 1092 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48__length1 = pixel_data_length1;
#line 1092 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp49_ = i;
#line 1092 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp48_[_tmp49_] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1092 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp50_ = _tmp48_[_tmp49_];
#line 10119 "ColorTransformation.c"
					}
				}
			}
#line 1094 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp51_ = self->priv->graphic;
#line 1094 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1094 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp52_;
#line 1094 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 10131 "ColorTransformation.c"
		}
		{
			gint x = 0;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			x = 0;
#line 10137 "ColorTransformation.c"
			{
				gboolean _tmp53_ = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = TRUE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				while (TRUE) {
#line 10144 "ColorTransformation.c"
					gint _tmp55_;
					gint red_bar_height = 0;
					gint* _tmp56_;
					gint _tmp56__length1;
					gint _tmp57_;
					gint _tmp58_;
					gdouble _tmp59_;
					gint green_bar_height = 0;
					gint* _tmp60_;
					gint _tmp60__length1;
					gint _tmp61_;
					gint _tmp62_;
					gdouble _tmp63_;
					gint blue_bar_height = 0;
					gint* _tmp64_;
					gint _tmp64__length1;
					gint _tmp65_;
					gint _tmp66_;
					gdouble _tmp67_;
					gint max_bar_height = 0;
					gint _tmp68_;
					gint _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					gint _tmp72_;
					gint y = 0;
					gint pixel_index = 0;
					gint _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!_tmp53_) {
#line 10178 "ColorTransformation.c"
						gint _tmp54_;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp54_ = x;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						x = _tmp54_ + 1;
#line 10184 "ColorTransformation.c"
					}
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp53_ = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp55_ = x;
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					if (!(_tmp55_ < 256)) {
#line 1097 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						break;
#line 10194 "ColorTransformation.c"
					}
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp56_ = self->priv->qualitative_red_counts;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp56__length1 = self->priv->qualitative_red_counts_length1;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp57_ = x;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp58_ = _tmp56_[_tmp57_];
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp59_ = scale_bar;
#line 1098 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					red_bar_height = (gint) (((gdouble) _tmp58_) * _tmp59_);
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp60_ = self->priv->qualitative_green_counts;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp60__length1 = self->priv->qualitative_green_counts_length1;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp61_ = x;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp62_ = _tmp60_[_tmp61_];
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp63_ = scale_bar;
#line 1100 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					green_bar_height = (gint) (((gdouble) _tmp62_) * _tmp63_);
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp64_ = self->priv->qualitative_blue_counts;
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp64__length1 = self->priv->qualitative_blue_counts_length1;
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp65_ = x;
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp66_ = _tmp64_[_tmp65_];
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp67_ = scale_bar;
#line 1102 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					blue_bar_height = (gint) (((gdouble) _tmp66_) * _tmp67_);
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp68_ = red_bar_height;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp69_ = green_bar_height;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp70_ = MAX (_tmp68_, _tmp69_);
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp71_ = blue_bar_height;
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp72_ = MAX (_tmp70_, _tmp71_);
#line 1105 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					max_bar_height = _tmp72_;
#line 1108 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					y = RGB_HISTOGRAM_GRAPHIC_HEIGHT - 1;
#line 1109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp73_ = x;
#line 1109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp74_ = pixel_bytes;
#line 1109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp75_ = y;
#line 1109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp76_ = rowstride;
#line 1109 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					pixel_index = (_tmp73_ * _tmp74_) + (_tmp75_ * _tmp76_);
#line 10256 "ColorTransformation.c"
					{
						gboolean _tmp77_ = FALSE;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp77_ = TRUE;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 10263 "ColorTransformation.c"
							gint _tmp79_;
							gint _tmp80_;
							guchar* _tmp81_;
							gint _tmp81__length1;
							gint _tmp82_;
							guchar _tmp83_;
							guchar* _tmp84_;
							gint _tmp84__length1;
							gint _tmp85_;
							guchar _tmp86_;
							guchar* _tmp87_;
							gint _tmp87__length1;
							gint _tmp88_;
							guchar _tmp89_;
							gint _tmp90_;
							gint _tmp91_;
							gint _tmp95_;
							gint _tmp96_;
							gint _tmp100_;
							gint _tmp101_;
							gint _tmp105_;
							gint _tmp106_;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp77_) {
#line 10288 "ColorTransformation.c"
								gint _tmp78_;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp78_ = y;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								y = _tmp78_ - 1;
#line 10294 "ColorTransformation.c"
							}
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp77_ = FALSE;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp79_ = y;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp80_ = max_bar_height;
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp79_ >= (RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp80_))) {
#line 1110 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 10306 "ColorTransformation.c"
							}
#line 1111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81_ = pixel_data;
#line 1111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81__length1 = pixel_data_length1;
#line 1111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp82_ = pixel_index;
#line 1111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp81_[_tmp82_] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1111 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp83_ = _tmp81_[_tmp82_];
#line 1112 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84_ = pixel_data;
#line 1112 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84__length1 = pixel_data_length1;
#line 1112 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp85_ = pixel_index;
#line 1112 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp84_[_tmp85_ + 1] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1112 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp86_ = _tmp84_[_tmp85_ + 1];
#line 1113 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87_ = pixel_data;
#line 1113 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87__length1 = pixel_data_length1;
#line 1113 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp88_ = pixel_index;
#line 1113 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp87_[_tmp88_ + 2] = RGB_HISTOGRAM_MARKED_BACKGROUND;
#line 1113 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp89_ = _tmp87_[_tmp88_ + 2];
#line 1115 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp90_ = y;
#line 1115 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp91_ = red_bar_height;
#line 1115 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp90_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp91_) - 1)) {
#line 10344 "ColorTransformation.c"
								guchar* _tmp92_;
								gint _tmp92__length1;
								gint _tmp93_;
								guchar _tmp94_;
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92_ = pixel_data;
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92__length1 = pixel_data_length1;
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp93_ = pixel_index;
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp92_[_tmp93_] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1116 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp94_ = _tmp92_[_tmp93_];
#line 10359 "ColorTransformation.c"
							}
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp95_ = y;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp96_ = green_bar_height;
#line 1117 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp95_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp96_) - 1)) {
#line 10367 "ColorTransformation.c"
								guchar* _tmp97_;
								gint _tmp97__length1;
								gint _tmp98_;
								guchar _tmp99_;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97_ = pixel_data;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97__length1 = pixel_data_length1;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp98_ = pixel_index;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp97_[_tmp98_ + 1] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1118 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp99_ = _tmp97_[_tmp98_ + 1];
#line 10382 "ColorTransformation.c"
							}
#line 1119 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp100_ = y;
#line 1119 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp101_ = blue_bar_height;
#line 1119 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (_tmp100_ >= ((RGB_HISTOGRAM_GRAPHIC_HEIGHT - _tmp101_) - 1)) {
#line 10390 "ColorTransformation.c"
								guchar* _tmp102_;
								gint _tmp102__length1;
								gint _tmp103_;
								guchar _tmp104_;
#line 1120 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102_ = pixel_data;
#line 1120 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102__length1 = pixel_data_length1;
#line 1120 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp103_ = pixel_index;
#line 1120 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp102_[_tmp103_ + 2] = RGB_HISTOGRAM_MARKED_FOREGROUND;
#line 1120 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp104_ = _tmp102_[_tmp103_ + 2];
#line 10405 "ColorTransformation.c"
							}
#line 1122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp105_ = pixel_index;
#line 1122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp106_ = rowstride;
#line 1122 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_index = _tmp105_ - _tmp106_;
#line 10413 "ColorTransformation.c"
						}
					}
					{
						gboolean _tmp107_ = FALSE;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp107_ = TRUE;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 10422 "ColorTransformation.c"
							gint _tmp109_;
							guchar* _tmp110_;
							gint _tmp110__length1;
							gint _tmp111_;
							guchar _tmp112_;
							guchar* _tmp113_;
							gint _tmp113__length1;
							gint _tmp114_;
							guchar _tmp115_;
							guchar* _tmp116_;
							gint _tmp116__length1;
							gint _tmp117_;
							guchar _tmp118_;
							gint _tmp119_;
							gint _tmp120_;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp107_) {
#line 10440 "ColorTransformation.c"
								gint _tmp108_;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp108_ = y;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								y = _tmp108_ - 1;
#line 10446 "ColorTransformation.c"
							}
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp107_ = FALSE;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp109_ = y;
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp109_ >= 0)) {
#line 1125 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 10456 "ColorTransformation.c"
							}
#line 1126 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110_ = pixel_data;
#line 1126 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110__length1 = pixel_data_length1;
#line 1126 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp111_ = pixel_index;
#line 1126 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp110_[_tmp111_] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1126 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp112_ = _tmp110_[_tmp111_];
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113_ = pixel_data;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113__length1 = pixel_data_length1;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp114_ = pixel_index;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp113_[_tmp114_ + 1] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1127 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp115_ = _tmp113_[_tmp114_ + 1];
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116_ = pixel_data;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116__length1 = pixel_data_length1;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp117_ = pixel_index;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp116_[_tmp117_ + 2] = RGB_HISTOGRAM_UNMARKED_BACKGROUND;
#line 1128 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp118_ = _tmp116_[_tmp117_ + 2];
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp119_ = pixel_index;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp120_ = rowstride;
#line 1130 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							pixel_index = _tmp119_ - _tmp120_;
#line 10494 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
#line 1135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp121_ = self->priv->graphic;
#line 1135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp122_ = _g_object_ref0 (_tmp121_);
#line 1135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp122_;
#line 1135 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 10509 "ColorTransformation.c"
}


static void value_rgb_histogram_init (GValue* value) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 10516 "ColorTransformation.c"
}


static void value_rgb_histogram_free_value (GValue* value) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (value->data[0].v_pointer);
#line 10525 "ColorTransformation.c"
	}
}


static void value_rgb_histogram_copy_value (const GValue* src_value, GValue* dest_value) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = rgb_histogram_ref (src_value->data[0].v_pointer);
#line 10535 "ColorTransformation.c"
	} else {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 10539 "ColorTransformation.c"
	}
}


static gpointer value_rgb_histogram_peek_pointer (const GValue* value) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 10547 "ColorTransformation.c"
}


static gchar* value_rgb_histogram_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 10554 "ColorTransformation.c"
		RGBHistogram * object;
		object = collect_values[0].v_pointer;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10561 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10565 "ColorTransformation.c"
		}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = rgb_histogram_ref (object);
#line 10569 "ColorTransformation.c"
	} else {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 10573 "ColorTransformation.c"
	}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 10577 "ColorTransformation.c"
}


static gchar* value_rgb_histogram_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RGBHistogram ** object_p;
	object_p = collect_values[0].v_pointer;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 10588 "ColorTransformation.c"
	}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 10594 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 10598 "ColorTransformation.c"
	} else {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = rgb_histogram_ref (value->data[0].v_pointer);
#line 10602 "ColorTransformation.c"
	}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 10606 "ColorTransformation.c"
}


GParamSpec* param_spec_rgb_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRGBHistogram* spec;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_RGB_HISTOGRAM), NULL);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 10620 "ColorTransformation.c"
}


gpointer value_get_rgb_histogram (const GValue* value) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM), NULL);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 10629 "ColorTransformation.c"
}


void value_set_rgb_histogram (GValue* value, gpointer v_object) {
	RGBHistogram * old;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_ref (value->data[0].v_pointer);
#line 10649 "ColorTransformation.c"
	} else {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 10653 "ColorTransformation.c"
	}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (old);
#line 10659 "ColorTransformation.c"
	}
}


void value_take_rgb_histogram (GValue* value, gpointer v_object) {
	RGBHistogram * old;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_RGB_HISTOGRAM));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_RGB_HISTOGRAM));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 10678 "ColorTransformation.c"
	} else {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 10682 "ColorTransformation.c"
	}
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		rgb_histogram_unref (old);
#line 10688 "ColorTransformation.c"
	}
}


static void rgb_histogram_class_init (RGBHistogramClass * klass) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rgb_histogram_parent_class = g_type_class_peek_parent (klass);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((RGBHistogramClass *) klass)->finalize = rgb_histogram_finalize;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (RGBHistogramPrivate));
#line 10700 "ColorTransformation.c"
}


static void rgb_histogram_instance_init (RGBHistogram * self) {
	gint* _tmp0_;
	gint* _tmp1_;
	gint* _tmp2_;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = RGB_HISTOGRAM_GET_PRIVATE (self);
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_new0 (gint, 256);
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts = _tmp0_;
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts_length1 = 256;
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_red_counts_size_ = self->priv->red_counts_length1;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gint, 256);
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts = _tmp1_;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts_length1 = 256;
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_green_counts_size_ = self->priv->green_counts_length1;
#line 892 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_new0 (gint, 256);
#line 892 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts = _tmp2_;
#line 892 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts_length1 = 256;
#line 892 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_blue_counts_size_ = self->priv->blue_counts_length1;
#line 893 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = NULL;
#line 893 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts_length1 = 0;
#line 893 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_red_counts_size_ = self->priv->qualitative_red_counts_length1;
#line 894 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = NULL;
#line 894 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts_length1 = 0;
#line 894 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_green_counts_size_ = self->priv->qualitative_green_counts_length1;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = NULL;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts_length1 = 0;
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_qualitative_blue_counts_size_ = self->priv->qualitative_blue_counts_length1;
#line 896 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->graphic = NULL;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 10756 "ColorTransformation.c"
}


static void rgb_histogram_finalize (RGBHistogram * obj) {
	RGBHistogram * self;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM, RGBHistogram);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 890 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->red_counts = (g_free (self->priv->red_counts), NULL);
#line 891 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->green_counts = (g_free (self->priv->green_counts), NULL);
#line 892 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->blue_counts = (g_free (self->priv->blue_counts), NULL);
#line 893 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_red_counts = (g_free (self->priv->qualitative_red_counts), NULL);
#line 894 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_green_counts = (g_free (self->priv->qualitative_green_counts), NULL);
#line 895 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->qualitative_blue_counts = (g_free (self->priv->qualitative_blue_counts), NULL);
#line 896 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_object_unref0 (self->priv->graphic);
#line 10780 "ColorTransformation.c"
}


GType rgb_histogram_get_type (void) {
	static volatile gsize rgb_histogram_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_rgb_histogram_init, value_rgb_histogram_free_value, value_rgb_histogram_copy_value, value_rgb_histogram_peek_pointer, "p", value_rgb_histogram_collect_value, "p", value_rgb_histogram_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogram), 0, (GInstanceInitFunc) rgb_histogram_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rgb_histogram_type_id;
		rgb_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RGBHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rgb_histogram_type_id__volatile, rgb_histogram_type_id);
	}
	return rgb_histogram_type_id__volatile;
}


gpointer rgb_histogram_ref (gpointer instance) {
	RGBHistogram * self;
	self = instance;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 10805 "ColorTransformation.c"
}


void rgb_histogram_unref (gpointer instance) {
	RGBHistogram * self;
	self = instance;
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		RGB_HISTOGRAM_GET_CLASS (self)->finalize (self);
#line 882 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 10818 "ColorTransformation.c"
	}
}


IntensityHistogram* intensity_histogram_construct (GType object_type, GdkPixbuf* pixbuf) {
	IntensityHistogram* self = NULL;
	gint n_channels = 0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint rowstride = 0;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	gint width = 0;
	GdkPixbuf* _tmp4_;
	gint _tmp5_;
	gint height = 0;
	GdkPixbuf* _tmp6_;
	gint _tmp7_;
	gint rowbytes = 0;
	gint _tmp8_;
	gint _tmp9_;
	guchar* pixels = NULL;
	GdkPixbuf* _tmp10_;
	guint8* _tmp11_;
	gint pixels_length1;
	gint _pixels_size_;
	gfloat pixel_count = 0.0F;
	GdkPixbuf* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	GdkPixbuf* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gfloat accumulator = 0.0F;
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (IntensityHistogram*) g_type_create_instance (object_type);
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixbuf;
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = gdk_pixbuf_get_n_channels (_tmp0_);
#line 1145 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	n_channels = _tmp1_;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = pixbuf;
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = gdk_pixbuf_get_rowstride (_tmp2_);
#line 1146 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowstride = _tmp3_;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = pixbuf;
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
#line 1147 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	width = _tmp5_;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = pixbuf;
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 1148 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	height = _tmp7_;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = n_channels;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = width;
#line 1149 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	rowbytes = _tmp8_ * _tmp9_;
#line 1150 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = pixbuf;
#line 1150 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp11_ = gdk_pixbuf_get_pixels (_tmp10_);
#line 1150 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixels = _tmp11_;
#line 1150 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixels_length1 = -1;
#line 1150 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixels_size_ = pixels_length1;
#line 10895 "ColorTransformation.c"
	{
		gint j = 0;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		j = 0;
#line 10900 "ColorTransformation.c"
		{
			gboolean _tmp12_ = FALSE;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = TRUE;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 10907 "ColorTransformation.c"
				gint _tmp14_;
				gint _tmp15_;
				gint row_start_index = 0;
				gint _tmp16_;
				gint _tmp17_;
				gint row_end_index = 0;
				gint _tmp18_;
				gint _tmp19_;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp12_) {
#line 10918 "ColorTransformation.c"
					gint _tmp13_;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp13_ = j;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					j = _tmp13_ + 1;
#line 10924 "ColorTransformation.c"
				}
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = FALSE;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = j;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = height;
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp14_ < _tmp15_)) {
#line 1151 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 10936 "ColorTransformation.c"
				}
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = j;
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = rowstride;
#line 1152 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_start_index = _tmp16_ * _tmp17_;
#line 1153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = row_start_index;
#line 1153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp19_ = rowbytes;
#line 1153 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				row_end_index = _tmp18_ + _tmp19_;
#line 10950 "ColorTransformation.c"
				{
					gint i = 0;
					gint _tmp20_;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp20_ = row_start_index;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp20_;
#line 10958 "ColorTransformation.c"
					{
						gboolean _tmp21_ = FALSE;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						_tmp21_ = TRUE;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
						while (TRUE) {
#line 10965 "ColorTransformation.c"
							gint _tmp24_;
							gint _tmp25_;
							RGBAnalyticPixel pix_rgb = {0};
							guchar* _tmp26_;
							gint _tmp26__length1;
							gint _tmp27_;
							guchar _tmp28_;
							guchar* _tmp29_;
							gint _tmp29__length1;
							gint _tmp30_;
							guchar _tmp31_;
							guchar* _tmp32_;
							gint _tmp32__length1;
							gint _tmp33_;
							guchar _tmp34_;
							HSVAnalyticPixel pix_hsi = {0};
							RGBAnalyticPixel _tmp35_;
							gint quantized_light_value = 0;
							HSVAnalyticPixel _tmp36_;
							gfloat _tmp37_;
							gint* _tmp38_;
							gint _tmp38__length1;
							gint _tmp39_;
							gint _tmp40_;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!_tmp21_) {
#line 10992 "ColorTransformation.c"
								gint _tmp22_;
								gint _tmp23_;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp22_ = i;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								_tmp23_ = n_channels;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								i = _tmp22_ + _tmp23_;
#line 11001 "ColorTransformation.c"
							}
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp21_ = FALSE;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp24_ = i;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp25_ = row_end_index;
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							if (!(_tmp24_ < _tmp25_)) {
#line 1154 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
								break;
#line 11013 "ColorTransformation.c"
							}
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26_ = pixels;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp26__length1 = pixels_length1;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp27_ = i;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp28_ = _tmp26_[_tmp27_];
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29_ = pixels;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp29__length1 = pixels_length1;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp30_ = i;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp31_ = _tmp29_[_tmp30_ + 1];
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32_ = pixels;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp32__length1 = pixels_length1;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp33_ = i;
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp34_ = _tmp32_[_tmp33_ + 2];
#line 1155 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							rgb_analytic_pixel_init_from_quantized_components (&pix_rgb, _tmp28_, _tmp31_, _tmp34_);
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp35_ = pix_rgb;
#line 1157 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							hsv_analytic_pixel_init_from_rgb (&pix_hsi, &_tmp35_);
#line 1158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp36_ = pix_hsi;
#line 1158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp37_ = _tmp36_.light_value;
#line 1158 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							quantized_light_value = (gint) (_tmp37_ * 255.0f);
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_ = self->priv->counts;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38__length1 = self->priv->counts_length1;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp39_ = quantized_light_value;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp38_[_tmp39_] += 1;
#line 1159 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
							_tmp40_ = _tmp38_[_tmp39_];
#line 11061 "ColorTransformation.c"
						}
					}
				}
			}
		}
	}
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp41_ = pixbuf;
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp42_ = gdk_pixbuf_get_width (_tmp41_);
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp43_ = _tmp42_;
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp44_ = pixbuf;
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp45_ = gdk_pixbuf_get_height (_tmp44_);
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = _tmp45_;
#line 1163 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_count = (gfloat) (_tmp43_ * _tmp46_);
#line 1164 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	accumulator = 0.0f;
#line 11084 "ColorTransformation.c"
	{
		gint i = 0;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 11089 "ColorTransformation.c"
		{
			gboolean _tmp47_ = FALSE;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp47_ = TRUE;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 11096 "ColorTransformation.c"
				gint _tmp49_;
				gfloat* _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_;
				gint* _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_;
				gint _tmp54_;
				gfloat _tmp55_;
				gfloat _tmp56_;
				gfloat _tmp57_;
				gfloat* _tmp58_;
				gint _tmp58__length1;
				gint _tmp59_;
				gfloat _tmp60_;
				gfloat* _tmp61_;
				gint _tmp61__length1;
				gint _tmp62_;
				gfloat _tmp63_;
				gfloat _tmp64_;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp47_) {
#line 11119 "ColorTransformation.c"
					gint _tmp48_;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp48_ = i;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp48_ + 1;
#line 11125 "ColorTransformation.c"
				}
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp47_ = FALSE;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp49_ = i;
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp49_ < 256)) {
#line 1165 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 11135 "ColorTransformation.c"
				}
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_ = self->priv->probabilities;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50__length1 = self->priv->probabilities_length1;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp51_ = i;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52_ = self->priv->counts;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp52__length1 = self->priv->counts_length1;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp53_ = i;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp54_ = _tmp52_[_tmp53_];
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp55_ = pixel_count;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp50_[_tmp51_] = ((gfloat) _tmp54_) / _tmp55_;
#line 1166 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp56_ = _tmp50_[_tmp51_];
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp57_ = accumulator;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58_ = self->priv->probabilities;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp58__length1 = self->priv->probabilities_length1;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp59_ = i;
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp60_ = _tmp58_[_tmp59_];
#line 1167 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				accumulator = _tmp57_ + _tmp60_;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_ = self->priv->cumulative_probabilities;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61__length1 = self->priv->cumulative_probabilities_length1;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp62_ = i;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp63_ = accumulator;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp61_[_tmp62_] = _tmp63_;
#line 1168 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp64_ = _tmp61_[_tmp62_];
#line 11181 "ColorTransformation.c"
			}
		}
	}
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11187 "ColorTransformation.c"
}


IntensityHistogram* intensity_histogram_new (GdkPixbuf* pixbuf) {
#line 1144 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return intensity_histogram_construct (TYPE_INTENSITY_HISTOGRAM, pixbuf);
#line 11194 "ColorTransformation.c"
}


gfloat intensity_histogram_get_cumulative_probability (IntensityHistogram* self, gint level) {
	gfloat result = 0.0F;
	gint _tmp0_;
	gint _tmp1_;
	gfloat* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gfloat _tmp4_;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = level;
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, 255);
#line 1174 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	level = _tmp1_;
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->cumulative_probabilities;
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2__length1 = self->priv->cumulative_probabilities_length1;
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = level;
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp4_;
#line 1175 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 11224 "ColorTransformation.c"
}


static void value_intensity_histogram_init (GValue* value) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 11231 "ColorTransformation.c"
}


static void value_intensity_histogram_free_value (GValue* value) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (value->data[0].v_pointer);
#line 11240 "ColorTransformation.c"
	}
}


static void value_intensity_histogram_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = intensity_histogram_ref (src_value->data[0].v_pointer);
#line 11250 "ColorTransformation.c"
	} else {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 11254 "ColorTransformation.c"
	}
}


static gpointer value_intensity_histogram_peek_pointer (const GValue* value) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 11262 "ColorTransformation.c"
}


static gchar* value_intensity_histogram_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 11269 "ColorTransformation.c"
		IntensityHistogram * object;
		object = collect_values[0].v_pointer;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11276 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 11280 "ColorTransformation.c"
		}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = intensity_histogram_ref (object);
#line 11284 "ColorTransformation.c"
	} else {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11288 "ColorTransformation.c"
	}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 11292 "ColorTransformation.c"
}


static gchar* value_intensity_histogram_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IntensityHistogram ** object_p;
	object_p = collect_values[0].v_pointer;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 11303 "ColorTransformation.c"
	}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 11309 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 11313 "ColorTransformation.c"
	} else {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = intensity_histogram_ref (value->data[0].v_pointer);
#line 11317 "ColorTransformation.c"
	}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 11321 "ColorTransformation.c"
}


GParamSpec* param_spec_intensity_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecIntensityHistogram* spec;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_INTENSITY_HISTOGRAM), NULL);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 11335 "ColorTransformation.c"
}


gpointer value_get_intensity_histogram (const GValue* value) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM), NULL);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 11344 "ColorTransformation.c"
}


void value_set_intensity_histogram (GValue* value, gpointer v_object) {
	IntensityHistogram * old;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_ref (value->data[0].v_pointer);
#line 11364 "ColorTransformation.c"
	} else {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11368 "ColorTransformation.c"
	}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (old);
#line 11374 "ColorTransformation.c"
	}
}


void value_take_intensity_histogram (GValue* value, gpointer v_object) {
	IntensityHistogram * old;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_INTENSITY_HISTOGRAM));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_INTENSITY_HISTOGRAM));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 11393 "ColorTransformation.c"
	} else {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 11397 "ColorTransformation.c"
	}
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		intensity_histogram_unref (old);
#line 11403 "ColorTransformation.c"
	}
}


static void intensity_histogram_class_init (IntensityHistogramClass * klass) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_histogram_parent_class = g_type_class_peek_parent (klass);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((IntensityHistogramClass *) klass)->finalize = intensity_histogram_finalize;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (IntensityHistogramPrivate));
#line 11415 "ColorTransformation.c"
}


static void intensity_histogram_instance_init (IntensityHistogram * self) {
	gint* _tmp0_;
	gfloat* _tmp1_;
	gfloat* _tmp2_;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = INTENSITY_HISTOGRAM_GET_PRIVATE (self);
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = g_new0 (gint, 256);
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts = _tmp0_;
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts_length1 = 256;
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_counts_size_ = self->priv->counts_length1;
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = g_new0 (gfloat, 256);
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities = _tmp1_;
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities_length1 = 256;
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_probabilities_size_ = self->priv->probabilities_length1;
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_new0 (gfloat, 256);
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities = _tmp2_;
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities_length1 = 256;
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->_cumulative_probabilities_size_ = self->priv->cumulative_probabilities_length1;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 11451 "ColorTransformation.c"
}


static void intensity_histogram_finalize (IntensityHistogram * obj) {
	IntensityHistogram * self;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INTENSITY_HISTOGRAM, IntensityHistogram);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 1140 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->counts = (g_free (self->priv->counts), NULL);
#line 1141 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->probabilities = (g_free (self->priv->probabilities), NULL);
#line 1142 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->cumulative_probabilities = (g_free (self->priv->cumulative_probabilities), NULL);
#line 11467 "ColorTransformation.c"
}


GType intensity_histogram_get_type (void) {
	static volatile gsize intensity_histogram_type_id__volatile = 0;
	if (g_once_init_enter (&intensity_histogram_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_intensity_histogram_init, value_intensity_histogram_free_value, value_intensity_histogram_copy_value, value_intensity_histogram_peek_pointer, "p", value_intensity_histogram_collect_value, "p", value_intensity_histogram_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IntensityHistogramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) intensity_histogram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IntensityHistogram), 0, (GInstanceInitFunc) intensity_histogram_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType intensity_histogram_type_id;
		intensity_histogram_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IntensityHistogram", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&intensity_histogram_type_id__volatile, intensity_histogram_type_id);
	}
	return intensity_histogram_type_id__volatile;
}


gpointer intensity_histogram_ref (gpointer instance) {
	IntensityHistogram * self;
	self = instance;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 11492 "ColorTransformation.c"
}


void intensity_histogram_unref (gpointer instance) {
	IntensityHistogram * self;
	self = instance;
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		INTENSITY_HISTOGRAM_GET_CLASS (self)->finalize (self);
#line 1139 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 11505 "ColorTransformation.c"
	}
}


ExpansionTransformation* expansion_transformation_construct (GType object_type, IntensityHistogram* histogram) {
	ExpansionTransformation* self = NULL;
	gfloat LOW_KINK_MASS = 0.0F;
	gfloat HIGH_KINK_MASS = 0.0F;
#line 1187 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1189 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	LOW_KINK_MASS = EXPANSION_TRANSFORMATION_LOW_DISCARD_MASS;
#line 1190 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->low_kink = 0;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	while (TRUE) {
#line 11522 "ColorTransformation.c"
		IntensityHistogram* _tmp0_;
		gint _tmp1_;
		gfloat _tmp2_;
		gfloat _tmp3_;
		gint _tmp4_;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = histogram;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = self->priv->low_kink;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = intensity_histogram_get_cumulative_probability (_tmp0_, _tmp1_);
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp3_ = LOW_KINK_MASS;
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (!(_tmp2_ < _tmp3_)) {
#line 1191 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			break;
#line 11540 "ColorTransformation.c"
		}
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp4_ = self->priv->low_kink;
#line 1192 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->low_kink = _tmp4_ + 1;
#line 11546 "ColorTransformation.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	HIGH_KINK_MASS = 1.0f - EXPANSION_TRANSFORMATION_HIGH_DISCARD_MASS;
#line 1195 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->high_kink = 255;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	while (TRUE) {
#line 11554 "ColorTransformation.c"
		gboolean _tmp5_ = FALSE;
		IntensityHistogram* _tmp6_;
		gint _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gint _tmp11_;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = histogram;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = self->priv->high_kink;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp8_ = intensity_histogram_get_cumulative_probability (_tmp6_, _tmp7_);
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp9_ = HIGH_KINK_MASS;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp8_ > _tmp9_) {
#line 11571 "ColorTransformation.c"
			gint _tmp10_;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = self->priv->high_kink;
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = _tmp10_ > 0;
#line 11577 "ColorTransformation.c"
		} else {
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = FALSE;
#line 11581 "ColorTransformation.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (!_tmp5_) {
#line 1196 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			break;
#line 11587 "ColorTransformation.c"
		}
#line 1197 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = self->priv->high_kink;
#line 1197 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		self->priv->high_kink = _tmp11_ - 1;
#line 11593 "ColorTransformation.c"
	}
#line 1199 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11599 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new (IntensityHistogram* histogram) {
#line 1186 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct (TYPE_EXPANSION_TRANSFORMATION, histogram);
#line 11606 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_construct_from_extrema (GType object_type, gint black_point, gint white_point) {
	ExpansionTransformation* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp9_;
	gint _tmp10_;
#line 1203 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1205 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = white_point;
#line 1205 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, 255);
#line 1205 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	white_point = _tmp1_;
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = black_point;
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = CLAMP (_tmp2_, 0, 255);
#line 1206 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	black_point = _tmp3_;
#line 1208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = black_point;
#line 1208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = white_point;
#line 1208 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp4_ == _tmp5_) {
#line 11640 "ColorTransformation.c"
		gint _tmp6_;
#line 1209 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp6_ = black_point;
#line 1209 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp6_ == 0) {
#line 1210 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			white_point = 1;
#line 11648 "ColorTransformation.c"
		} else {
			gint _tmp7_;
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = white_point;
#line 1211 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp7_ == 255) {
#line 1212 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				black_point = 254;
#line 11657 "ColorTransformation.c"
			} else {
				gint _tmp8_;
#line 1214 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = white_point;
#line 1214 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				black_point = _tmp8_ - 1;
#line 11664 "ColorTransformation.c"
			}
		}
	}
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = black_point;
#line 1217 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->low_kink = _tmp9_;
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = white_point;
#line 1218 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->high_kink = _tmp10_;
#line 1220 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11680 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new_from_extrema (gint black_point, gint white_point) {
#line 1202 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct_from_extrema (TYPE_EXPANSION_TRANSFORMATION, black_point, white_point);
#line 11687 "ColorTransformation.c"
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1227 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1227 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1228 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1228 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strchug (_tmp1_);
#line 1229 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1229 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 11708 "ColorTransformation.c"
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1219 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1219 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1220 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1220 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strchomp (_tmp1_);
#line 1221 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1221 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 11729 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_construct_from_string (GType object_type, const gchar* encoded_transformation) {
	ExpansionTransformation* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint num_captured = 0;
	const gchar* _tmp7_;
	gint _tmp8_;
#line 1224 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ExpansionTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION);
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = encoded_transformation;
#line 1226 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_strcanon (_tmp0_, "0123456789. ", ' ');
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = encoded_transformation;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = string_chug (_tmp1_);
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = _tmp2_;
#line 1227 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp3_);
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = encoded_transformation;
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = string_chomp (_tmp4_);
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = _tmp5_;
#line 1228 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_g_free0 (_tmp6_);
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = encoded_transformation;
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = sscanf (_tmp7_, "%d %d", &self->priv->low_kink, &self->priv->high_kink);
#line 1230 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	num_captured = _tmp8_;
#line 1233 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_vala_assert (num_captured == 2, "num_captured == 2");
#line 1235 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_build_remap_table (self);
#line 1223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 11779 "ColorTransformation.c"
}


ExpansionTransformation* expansion_transformation_new_from_string (const gchar* encoded_transformation) {
#line 1223 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return expansion_transformation_construct_from_string (TYPE_EXPANSION_TRANSFORMATION, encoded_transformation);
#line 11786 "ColorTransformation.c"
}


static void expansion_transformation_build_remap_table (ExpansionTransformation* self) {
	gfloat low_kink_f = 0.0F;
	gint _tmp0_;
	gfloat high_kink_f = 0.0F;
	gint _tmp1_;
	gfloat slope = 0.0F;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat intercept = 0.0F;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gint i = 0;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1239 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	low_kink_f = ((gfloat) _tmp0_) / 255.0f;
#line 1240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->high_kink;
#line 1240 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	high_kink_f = ((gfloat) _tmp1_) / 255.0f;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = high_kink_f;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = low_kink_f;
#line 1242 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	slope = 1.0f / (_tmp2_ - _tmp3_);
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = low_kink_f;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = high_kink_f;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = low_kink_f;
#line 1243 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intercept = -(_tmp4_ / (_tmp5_ - _tmp6_));
#line 1245 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	i = 0;
#line 11827 "ColorTransformation.c"
	{
		gboolean _tmp7_ = FALSE;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp7_ = TRUE;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 11834 "ColorTransformation.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gfloat _tmp12_;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp7_) {
#line 11841 "ColorTransformation.c"
				gint _tmp8_;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = i;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp8_ + 1;
#line 11847 "ColorTransformation.c"
			}
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = FALSE;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = i;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = self->priv->low_kink;
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp9_ <= _tmp10_)) {
#line 1246 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 11859 "ColorTransformation.c"
			}
#line 1247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = i;
#line 1247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp11_] = 0.0f;
#line 1247 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp11_];
#line 11867 "ColorTransformation.c"
		}
	}
	{
		gboolean _tmp13_ = FALSE;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp13_ = TRUE;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 11876 "ColorTransformation.c"
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gfloat _tmp18_;
			gint _tmp19_;
			gfloat _tmp20_;
			gfloat _tmp21_;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp13_) {
#line 11886 "ColorTransformation.c"
				gint _tmp14_;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = i;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp14_ + 1;
#line 11892 "ColorTransformation.c"
			}
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = FALSE;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp15_ = i;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp16_ = self->priv->high_kink;
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 1249 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 11904 "ColorTransformation.c"
			}
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp17_ = i;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp18_ = slope;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp19_ = i;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = intercept;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp17_] = (_tmp18_ * (((gfloat) _tmp19_) / 255.0f)) + _tmp20_;
#line 1250 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp17_];
#line 11918 "ColorTransformation.c"
		}
	}
	{
		gboolean _tmp22_ = FALSE;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp22_ = TRUE;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 11927 "ColorTransformation.c"
			gint _tmp24_;
			gint _tmp25_;
			gfloat _tmp26_;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp22_) {
#line 11933 "ColorTransformation.c"
				gint _tmp23_;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp23_ = i;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				i = _tmp23_ + 1;
#line 11939 "ColorTransformation.c"
			}
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = FALSE;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp24_ = i;
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp24_ < 256)) {
#line 1252 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 11949 "ColorTransformation.c"
			}
#line 1253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp25_ = i;
#line 1253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp25_] = 1.0f;
#line 1253 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp25_];
#line 11957 "ColorTransformation.c"
		}
	}
}


static gchar* expansion_transformation_real_to_string (PixelTransformation* base) {
	ExpansionTransformation * self;
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
#line 1256 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1257 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1257 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->high_kink;
#line 1257 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = g_strdup_printf ("{ %d, %d }", _tmp0_, _tmp1_);
#line 1257 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp2_;
#line 1257 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 11981 "ColorTransformation.c"
}


gint expansion_transformation_get_white_point (ExpansionTransformation* self) {
	gint result = 0;
	gint _tmp0_;
#line 1261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->high_kink;
#line 1261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1261 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 11994 "ColorTransformation.c"
}


gint expansion_transformation_get_black_point (ExpansionTransformation* self) {
	gint result = 0;
	gint _tmp0_;
#line 1265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1265 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12007 "ColorTransformation.c"
}


static gboolean expansion_transformation_real_is_identity (PixelTransformation* base) {
	ExpansionTransformation * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 1268 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->low_kink;
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp1_ == 0) {
#line 12022 "ColorTransformation.c"
		gint _tmp2_;
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = self->priv->high_kink;
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = _tmp2_ == 255;
#line 12028 "ColorTransformation.c"
	} else {
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp0_ = FALSE;
#line 12032 "ColorTransformation.c"
	}
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1269 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12038 "ColorTransformation.c"
}


static PixelTransformation* expansion_transformation_real_copy (PixelTransformation* base) {
	ExpansionTransformation * self;
	PixelTransformation* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ExpansionTransformation* _tmp2_;
#line 1272 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->low_kink;
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->high_kink;
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = expansion_transformation_new_from_extrema (_tmp0_, _tmp1_);
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1273 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12060 "ColorTransformation.c"
}


static void expansion_transformation_class_init (ExpansionTransformationClass * klass) {
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	expansion_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = expansion_transformation_finalize;
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ExpansionTransformationPrivate));
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->to_string = (gchar* (*) (PixelTransformation *)) expansion_transformation_real_to_string;
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation *)) expansion_transformation_real_is_identity;
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation *)) expansion_transformation_real_copy;
#line 12077 "ColorTransformation.c"
}


static void expansion_transformation_instance_init (ExpansionTransformation * self) {
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = EXPANSION_TRANSFORMATION_GET_PRIVATE (self);
#line 12084 "ColorTransformation.c"
}


static void expansion_transformation_finalize (PixelTransformation * obj) {
	ExpansionTransformation * self;
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPANSION_TRANSFORMATION, ExpansionTransformation);
#line 1179 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (expansion_transformation_parent_class)->finalize (obj);
#line 12094 "ColorTransformation.c"
}


GType expansion_transformation_get_type (void) {
	static volatile gsize expansion_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&expansion_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpansionTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expansion_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpansionTransformation), 0, (GInstanceInitFunc) expansion_transformation_instance_init, NULL };
		GType expansion_transformation_type_id;
		expansion_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ExpansionTransformation", &g_define_type_info, 0);
		g_once_init_leave (&expansion_transformation_type_id__volatile, expansion_transformation_type_id);
	}
	return expansion_transformation_type_id__volatile;
}


ShadowDetailTransformation* shadow_detail_transformation_construct (GType object_type, gfloat user_intensity) {
	ShadowDetailTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat intensity_adj = 0.0F;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat effect_shift = 0.0F;
	gfloat _tmp3_;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp4_;
#line 1289 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (ShadowDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_SHADOWS);
#line 1291 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_intensity;
#line 1291 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = _tmp0_;
#line 1292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->intensity;
#line 1292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = CLAMP (_tmp1_ / SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER, 0.0f, 1.0f);
#line 1292 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_adj = _tmp2_;
#line 1294 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = intensity_adj;
#line 1294 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	effect_shift = SHADOW_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * _tmp3_;
#line 1295 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = hermite_gamma_approximation_function_new (SHADOW_DETAIL_TRANSFORMATION_TONAL_WIDTH);
#line 1295 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	func = _tmp4_;
#line 12140 "ColorTransformation.c"
	{
		gint i = 0;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 12145 "ColorTransformation.c"
		{
			gboolean _tmp5_ = FALSE;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = TRUE;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 12152 "ColorTransformation.c"
				gint _tmp7_;
				gfloat x = 0.0F;
				gint _tmp8_;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp9_;
				gfloat _tmp10_;
				gfloat _tmp11_;
				gint _tmp12_;
				gfloat _tmp13_;
				gfloat _tmp14_;
				gfloat _tmp15_;
				gfloat _tmp16_;
				gfloat _tmp17_;
				gfloat _tmp18_;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp5_) {
#line 12169 "ColorTransformation.c"
					gint _tmp6_;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp6_ = i;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp6_ + 1;
#line 12175 "ColorTransformation.c"
				}
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = FALSE;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp7_ < 256)) {
#line 1298 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 12185 "ColorTransformation.c"
				}
#line 1299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = i;
#line 1299 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				x = ((gfloat) _tmp8_) / 255.0f;
#line 1300 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = func;
#line 1300 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = x;
#line 1300 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = hermite_gamma_approximation_function_evaluate (_tmp9_, _tmp10_);
#line 1300 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				weight = _tmp11_;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = i;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = weight;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = x;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = effect_shift;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = weight;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = x;
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp12_] = (_tmp13_ * (_tmp14_ + _tmp15_)) + ((1.0f - _tmp16_) * _tmp17_);
#line 1301 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp12_];
#line 12215 "ColorTransformation.c"
			}
		}
	}
#line 1288 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_hermite_gamma_approximation_function_unref0 (func);
#line 1288 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12223 "ColorTransformation.c"
}


ShadowDetailTransformation* shadow_detail_transformation_new (gfloat user_intensity) {
#line 1288 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return shadow_detail_transformation_construct (TYPE_SHADOW_DETAIL_TRANSFORMATION, user_intensity);
#line 12230 "ColorTransformation.c"
}


static PixelTransformation* shadow_detail_transformation_real_copy (PixelTransformation* base) {
	ShadowDetailTransformation * self;
	PixelTransformation* result = NULL;
	gfloat _tmp0_;
	ShadowDetailTransformation* _tmp1_;
#line 1305 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = shadow_detail_transformation_new (_tmp0_);
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1306 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12249 "ColorTransformation.c"
}


static gboolean shadow_detail_transformation_real_is_identity (PixelTransformation* base) {
	ShadowDetailTransformation * self;
	gboolean result = FALSE;
	gfloat _tmp0_;
#line 1309 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ == 0.0f;
#line 1310 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12265 "ColorTransformation.c"
}


gfloat shadow_detail_transformation_get_parameter (ShadowDetailTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 1314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1314 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12278 "ColorTransformation.c"
}


static void shadow_detail_transformation_class_init (ShadowDetailTransformationClass * klass) {
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_detail_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = shadow_detail_transformation_finalize;
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (ShadowDetailTransformationPrivate));
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation *)) shadow_detail_transformation_real_copy;
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation *)) shadow_detail_transformation_real_is_identity;
#line 12293 "ColorTransformation.c"
}


static void shadow_detail_transformation_instance_init (ShadowDetailTransformation * self) {
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = SHADOW_DETAIL_TRANSFORMATION_GET_PRIVATE (self);
#line 1283 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = 0.0f;
#line 12302 "ColorTransformation.c"
}


static void shadow_detail_transformation_finalize (PixelTransformation * obj) {
	ShadowDetailTransformation * self;
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHADOW_DETAIL_TRANSFORMATION, ShadowDetailTransformation);
#line 1277 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (shadow_detail_transformation_parent_class)->finalize (obj);
#line 12312 "ColorTransformation.c"
}


GType shadow_detail_transformation_get_type (void) {
	static volatile gsize shadow_detail_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&shadow_detail_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShadowDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shadow_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShadowDetailTransformation), 0, (GInstanceInitFunc) shadow_detail_transformation_instance_init, NULL };
		GType shadow_detail_transformation_type_id;
		shadow_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "ShadowDetailTransformation", &g_define_type_info, 0);
		g_once_init_leave (&shadow_detail_transformation_type_id__volatile, shadow_detail_transformation_type_id);
	}
	return shadow_detail_transformation_type_id__volatile;
}


HermiteGammaApproximationFunction* hermite_gamma_approximation_function_construct (GType object_type, gfloat user_interval_upper) {
	HermiteGammaApproximationFunction* self = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
#line 1322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HermiteGammaApproximationFunction*) g_type_create_instance (object_type);
#line 1323 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_interval_upper;
#line 1323 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.1f, 1.0f);
#line 1323 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->nonzero_interval_upper = _tmp1_;
#line 1324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = self->priv->nonzero_interval_upper;
#line 1324 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->x_scale = 1.0f / _tmp2_;
#line 1322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12347 "ColorTransformation.c"
}


HermiteGammaApproximationFunction* hermite_gamma_approximation_function_new (gfloat user_interval_upper) {
#line 1322 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return hermite_gamma_approximation_function_construct (TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, user_interval_upper);
#line 12354 "ColorTransformation.c"
}


gfloat hermite_gamma_approximation_function_evaluate (HermiteGammaApproximationFunction* self, gfloat x) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = x;
#line 1328 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp0_ < 0.0f) {
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		result = 0.0f;
#line 1329 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return result;
#line 12369 "ColorTransformation.c"
	} else {
		gfloat _tmp1_;
		gfloat _tmp2_;
#line 1330 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp1_ = x;
#line 1330 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp2_ = self->priv->nonzero_interval_upper;
#line 1330 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp1_ > _tmp2_) {
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = 0.0f;
#line 1331 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 12383 "ColorTransformation.c"
		} else {
			gfloat indep_var = 0.0F;
			gfloat _tmp3_;
			gfloat _tmp4_;
			gfloat dep_var = 0.0F;
			gfloat _tmp5_;
			gfloat _tmp6_;
			gfloat _tmp7_;
			gfloat _tmp8_;
			gfloat _tmp9_;
			gfloat _tmp10_;
			gfloat _tmp11_;
			gfloat _tmp12_;
#line 1333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp3_ = self->priv->x_scale;
#line 1333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp4_ = x;
#line 1333 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			indep_var = _tmp3_ * _tmp4_;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp6_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp7_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp8_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp9_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp10_ = indep_var;
#line 1335 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			dep_var = 6.0f * ((((_tmp5_ * _tmp6_) * _tmp7_) - (2.0f * (_tmp8_ * _tmp9_))) + _tmp10_);
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = dep_var;
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp12_ = CLAMP (_tmp11_, 0.0f, 1.0f);
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			result = _tmp12_;
#line 1338 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return result;
#line 12425 "ColorTransformation.c"
		}
	}
}


static void value_hermite_gamma_approximation_function_init (GValue* value) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	value->data[0].v_pointer = NULL;
#line 12434 "ColorTransformation.c"
}


static void value_hermite_gamma_approximation_function_free_value (GValue* value) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (value->data[0].v_pointer) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (value->data[0].v_pointer);
#line 12443 "ColorTransformation.c"
	}
}


static void value_hermite_gamma_approximation_function_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (src_value->data[0].v_pointer) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = hermite_gamma_approximation_function_ref (src_value->data[0].v_pointer);
#line 12453 "ColorTransformation.c"
	} else {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		dest_value->data[0].v_pointer = NULL;
#line 12457 "ColorTransformation.c"
	}
}


static gpointer value_hermite_gamma_approximation_function_peek_pointer (const GValue* value) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 12465 "ColorTransformation.c"
}


static gchar* value_hermite_gamma_approximation_function_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (collect_values[0].v_pointer) {
#line 12472 "ColorTransformation.c"
		HermiteGammaApproximationFunction * object;
		object = collect_values[0].v_pointer;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12479 "ColorTransformation.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12483 "ColorTransformation.c"
		}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = hermite_gamma_approximation_function_ref (object);
#line 12487 "ColorTransformation.c"
	} else {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 12491 "ColorTransformation.c"
	}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 12495 "ColorTransformation.c"
}


static gchar* value_hermite_gamma_approximation_function_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HermiteGammaApproximationFunction ** object_p;
	object_p = collect_values[0].v_pointer;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!object_p) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 12506 "ColorTransformation.c"
	}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (!value->data[0].v_pointer) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = NULL;
#line 12512 "ColorTransformation.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = value->data[0].v_pointer;
#line 12516 "ColorTransformation.c"
	} else {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		*object_p = hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
#line 12520 "ColorTransformation.c"
	}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return NULL;
#line 12524 "ColorTransformation.c"
}


GParamSpec* param_spec_hermite_gamma_approximation_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHermiteGammaApproximationFunction* spec;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return G_PARAM_SPEC (spec);
#line 12538 "ColorTransformation.c"
}


gpointer value_get_hermite_gamma_approximation_function (const GValue* value) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION), NULL);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return value->data[0].v_pointer;
#line 12547 "ColorTransformation.c"
}


void value_set_hermite_gamma_approximation_function (GValue* value, gpointer v_object) {
	HermiteGammaApproximationFunction * old;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_ref (value->data[0].v_pointer);
#line 12567 "ColorTransformation.c"
	} else {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 12571 "ColorTransformation.c"
	}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (old);
#line 12577 "ColorTransformation.c"
	}
}


void value_take_hermite_gamma_approximation_function (GValue* value, gpointer v_object) {
	HermiteGammaApproximationFunction * old;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	old = value->data[0].v_pointer;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (v_object) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = v_object;
#line 12596 "ColorTransformation.c"
	} else {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		value->data[0].v_pointer = NULL;
#line 12600 "ColorTransformation.c"
	}
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (old) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		hermite_gamma_approximation_function_unref (old);
#line 12606 "ColorTransformation.c"
	}
}


static void hermite_gamma_approximation_function_class_init (HermiteGammaApproximationFunctionClass * klass) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	hermite_gamma_approximation_function_parent_class = g_type_class_peek_parent (klass);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((HermiteGammaApproximationFunctionClass *) klass)->finalize = hermite_gamma_approximation_function_finalize;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (HermiteGammaApproximationFunctionPrivate));
#line 12618 "ColorTransformation.c"
}


static void hermite_gamma_approximation_function_instance_init (HermiteGammaApproximationFunction * self) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_PRIVATE (self);
#line 1319 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->x_scale = 1.0f;
#line 1320 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->nonzero_interval_upper = 1.0f;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->ref_count = 1;
#line 12631 "ColorTransformation.c"
}


static void hermite_gamma_approximation_function_finalize (HermiteGammaApproximationFunction * obj) {
	HermiteGammaApproximationFunction * self;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HERMITE_GAMMA_APPROXIMATION_FUNCTION, HermiteGammaApproximationFunction);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_signal_handlers_destroy (self);
#line 12641 "ColorTransformation.c"
}


GType hermite_gamma_approximation_function_get_type (void) {
	static volatile gsize hermite_gamma_approximation_function_type_id__volatile = 0;
	if (g_once_init_enter (&hermite_gamma_approximation_function_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hermite_gamma_approximation_function_init, value_hermite_gamma_approximation_function_free_value, value_hermite_gamma_approximation_function_copy_value, value_hermite_gamma_approximation_function_peek_pointer, "p", value_hermite_gamma_approximation_function_collect_value, "p", value_hermite_gamma_approximation_function_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HermiteGammaApproximationFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hermite_gamma_approximation_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HermiteGammaApproximationFunction), 0, (GInstanceInitFunc) hermite_gamma_approximation_function_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hermite_gamma_approximation_function_type_id;
		hermite_gamma_approximation_function_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HermiteGammaApproximationFunction", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hermite_gamma_approximation_function_type_id__volatile, hermite_gamma_approximation_function_type_id);
	}
	return hermite_gamma_approximation_function_type_id__volatile;
}


gpointer hermite_gamma_approximation_function_ref (gpointer instance) {
	HermiteGammaApproximationFunction * self;
	self = instance;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return instance;
#line 12666 "ColorTransformation.c"
}


void hermite_gamma_approximation_function_unref (gpointer instance) {
	HermiteGammaApproximationFunction * self;
	self = instance;
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		HERMITE_GAMMA_APPROXIMATION_FUNCTION_GET_CLASS (self)->finalize (self);
#line 1318 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 12679 "ColorTransformation.c"
	}
}


HighlightDetailTransformation* highlight_detail_transformation_construct (GType object_type, gfloat user_intensity) {
	HighlightDetailTransformation* self = NULL;
	gfloat _tmp0_;
	gfloat intensity_adj = 0.0F;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat effect_shift = 0.0F;
	gfloat _tmp3_;
	HermiteGammaApproximationFunction* func = NULL;
	HermiteGammaApproximationFunction* _tmp4_;
#line 1355 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = (HighlightDetailTransformation*) hsv_transformation_construct (object_type, PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS);
#line 1357 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = user_intensity;
#line 1357 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = _tmp0_;
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = self->priv->intensity;
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = CLAMP (_tmp1_ / HIGHLIGHT_DETAIL_TRANSFORMATION_MIN_PARAMETER, 0.0f, 1.0f);
#line 1358 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	intensity_adj = _tmp2_;
#line 1360 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = intensity_adj;
#line 1360 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	effect_shift = HIGHLIGHT_DETAIL_TRANSFORMATION_MAX_EFFECT_SHIFT * _tmp3_;
#line 1361 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = hermite_gamma_approximation_function_new (HIGHLIGHT_DETAIL_TRANSFORMATION_TONAL_WIDTH);
#line 1361 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	func = _tmp4_;
#line 12714 "ColorTransformation.c"
	{
		gint i = 0;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		i = 0;
#line 12719 "ColorTransformation.c"
		{
			gboolean _tmp5_ = FALSE;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp5_ = TRUE;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 12726 "ColorTransformation.c"
				gint _tmp7_;
				gfloat x = 0.0F;
				gint _tmp8_;
				gfloat weight = 0.0F;
				HermiteGammaApproximationFunction* _tmp9_;
				gfloat _tmp10_;
				gfloat _tmp11_;
				gint _tmp12_;
				gfloat _tmp13_;
				gfloat _tmp14_;
				gfloat _tmp15_;
				gfloat _tmp16_;
				gfloat _tmp17_;
				gfloat _tmp18_;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp5_) {
#line 12743 "ColorTransformation.c"
					gint _tmp6_;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp6_ = i;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					i = _tmp6_ + 1;
#line 12749 "ColorTransformation.c"
				}
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp5_ = FALSE;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp7_ = i;
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp7_ < 256)) {
#line 1364 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 12759 "ColorTransformation.c"
				}
#line 1365 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp8_ = i;
#line 1365 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				x = ((gfloat) _tmp8_) / 255.0f;
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp9_ = func;
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp10_ = x;
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp11_ = hermite_gamma_approximation_function_evaluate (_tmp9_, 1.0f - _tmp10_);
#line 1366 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				weight = _tmp11_;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = i;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp13_ = weight;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp14_ = x;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp15_ = effect_shift;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp16_ = weight;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp17_ = x;
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp12_] = (_tmp13_ * (_tmp14_ - _tmp15_)) + ((1.0f - _tmp16_) * _tmp17_);
#line 1367 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_HSV_TRANSFORMATION, HSVTransformation)->remap_table[_tmp12_];
#line 12789 "ColorTransformation.c"
			}
		}
	}
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_hermite_gamma_approximation_function_unref0 (func);
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return self;
#line 12797 "ColorTransformation.c"
}


HighlightDetailTransformation* highlight_detail_transformation_new (gfloat user_intensity) {
#line 1354 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return highlight_detail_transformation_construct (TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, user_intensity);
#line 12804 "ColorTransformation.c"
}


static PixelTransformation* highlight_detail_transformation_real_copy (PixelTransformation* base) {
	HighlightDetailTransformation * self;
	PixelTransformation* result = NULL;
	gfloat _tmp0_;
	HighlightDetailTransformation* _tmp1_;
#line 1371 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1372 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1372 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = highlight_detail_transformation_new (_tmp0_);
#line 1372 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation);
#line 1372 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12823 "ColorTransformation.c"
}


static gboolean highlight_detail_transformation_real_is_identity (PixelTransformation* base) {
	HighlightDetailTransformation * self;
	gboolean result = FALSE;
	gfloat _tmp0_;
#line 1375 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1376 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1376 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_ == 0.0f;
#line 1376 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12839 "ColorTransformation.c"
}


gfloat highlight_detail_transformation_get_parameter (HighlightDetailTransformation* self) {
	gfloat result = 0.0F;
	gfloat _tmp0_;
#line 1380 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = self->priv->intensity;
#line 1380 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = _tmp0_;
#line 1380 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 12852 "ColorTransformation.c"
}


static void highlight_detail_transformation_class_init (HighlightDetailTransformationClass * klass) {
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	highlight_detail_transformation_parent_class = g_type_class_peek_parent (klass);
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->finalize = highlight_detail_transformation_finalize;
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	g_type_class_add_private (klass, sizeof (HighlightDetailTransformationPrivate));
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->copy = (PixelTransformation* (*) (PixelTransformation *)) highlight_detail_transformation_real_copy;
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	((PixelTransformationClass *) klass)->is_identity = (gboolean (*) (PixelTransformation *)) highlight_detail_transformation_real_is_identity;
#line 12867 "ColorTransformation.c"
}


static void highlight_detail_transformation_instance_init (HighlightDetailTransformation * self) {
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv = HIGHLIGHT_DETAIL_TRANSFORMATION_GET_PRIVATE (self);
#line 1349 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self->priv->intensity = 0.0f;
#line 12876 "ColorTransformation.c"
}


static void highlight_detail_transformation_finalize (PixelTransformation * obj) {
	HighlightDetailTransformation * self;
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIGHLIGHT_DETAIL_TRANSFORMATION, HighlightDetailTransformation);
#line 1343 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	PIXEL_TRANSFORMATION_CLASS (highlight_detail_transformation_parent_class)->finalize (obj);
#line 12886 "ColorTransformation.c"
}


GType highlight_detail_transformation_get_type (void) {
	static volatile gsize highlight_detail_transformation_type_id__volatile = 0;
	if (g_once_init_enter (&highlight_detail_transformation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HighlightDetailTransformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) highlight_detail_transformation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HighlightDetailTransformation), 0, (GInstanceInitFunc) highlight_detail_transformation_instance_init, NULL };
		GType highlight_detail_transformation_type_id;
		highlight_detail_transformation_type_id = g_type_register_static (TYPE_HSV_TRANSFORMATION, "HighlightDetailTransformation", &g_define_type_info, 0);
		g_once_init_leave (&highlight_detail_transformation_type_id__volatile, highlight_detail_transformation_type_id);
	}
	return highlight_detail_transformation_type_id__volatile;
}


PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf) {
	PixelTransformationBundle* result = NULL;
	PixelTransformationBundle* adjustments = NULL;
	PixelTransformationBundle* _tmp0_;
	IntensityHistogram* analysis_histogram = NULL;
	GdkPixbuf* _tmp1_;
	IntensityHistogram* _tmp2_;
	gfloat pct_in_range = 0.0F;
	IntensityHistogram* _tmp3_;
	gfloat _tmp4_;
	IntensityHistogram* _tmp5_;
	gfloat _tmp6_;
	gfloat shadow_range_mean_prob_val = 0.0F;
	IntensityHistogram* _tmp7_;
	gfloat _tmp8_;
	IntensityHistogram* _tmp9_;
	gfloat _tmp10_;
	gint shadow_mean_intensity = 0;
	gboolean _tmp18_ = FALSE;
	gfloat _tmp19_;
	PixelTransformationBundle* _tmp46_;
	HighlightDetailTransformation* _tmp47_;
	HighlightDetailTransformation* _tmp48_;
	PixelTransformationBundle* _tmp49_;
	TemperatureTransformation* _tmp50_;
	TemperatureTransformation* _tmp51_;
	PixelTransformationBundle* _tmp52_;
	TintTransformation* _tmp53_;
	TintTransformation* _tmp54_;
	PixelTransformationBundle* _tmp55_;
	ExposureTransformation* _tmp56_;
	ExposureTransformation* _tmp57_;
	PixelTransformationBundle* _tmp58_;
	ContrastTransformation* _tmp59_;
	ContrastTransformation* _tmp60_;
	PixelTransformationBundle* _tmp61_;
	SaturationTransformation* _tmp62_;
	SaturationTransformation* _tmp63_;
#line 1394 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 1394 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	adjustments = _tmp0_;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp1_ = pixbuf;
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp2_ = intensity_histogram_new (_tmp1_);
#line 1396 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	analysis_histogram = _tmp2_;
#line 1399 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp3_ = analysis_histogram;
#line 1399 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp4_ = intensity_histogram_get_cumulative_probability (_tmp3_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY);
#line 1399 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp5_ = analysis_histogram;
#line 1399 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp6_ = intensity_histogram_get_cumulative_probability (_tmp5_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY);
#line 1399 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pct_in_range = 100.0f * (_tmp4_ - _tmp6_);
#line 1405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp7_ = analysis_histogram;
#line 1405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp8_ = intensity_histogram_get_cumulative_probability (_tmp7_, AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY);
#line 1405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp9_ = analysis_histogram;
#line 1405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp10_ = intensity_histogram_get_cumulative_probability (_tmp9_, AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY);
#line 1405 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_range_mean_prob_val = (_tmp8_ + _tmp10_) * 0.5f;
#line 1408 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	shadow_mean_intensity = AUTO_ENHANCE_SHADOW_DETECT_MIN_INTENSITY;
#line 12972 "ColorTransformation.c"
	{
		gboolean _tmp11_ = FALSE;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp11_ = TRUE;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		while (TRUE) {
#line 12979 "ColorTransformation.c"
			gint _tmp13_;
			IntensityHistogram* _tmp14_;
			gint _tmp15_;
			gfloat _tmp16_;
			gfloat _tmp17_;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!_tmp11_) {
#line 12987 "ColorTransformation.c"
				gint _tmp12_;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp12_ = shadow_mean_intensity;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				shadow_mean_intensity = _tmp12_ + 1;
#line 12993 "ColorTransformation.c"
			}
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp11_ = FALSE;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp13_ = shadow_mean_intensity;
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (!(_tmp13_ <= AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY)) {
#line 1409 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 13003 "ColorTransformation.c"
			}
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp14_ = analysis_histogram;
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp15_ = shadow_mean_intensity;
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp16_ = intensity_histogram_get_cumulative_probability (_tmp14_, _tmp15_);
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp17_ = shadow_range_mean_prob_val;
#line 1410 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			if (_tmp16_ >= _tmp17_) {
#line 1411 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				break;
#line 13017 "ColorTransformation.c"
			}
		}
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp19_ = pct_in_range;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp19_ > 40.0f) {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = TRUE;
#line 13027 "ColorTransformation.c"
	} else {
		gboolean _tmp20_ = FALSE;
		gfloat _tmp21_;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp21_ = pct_in_range;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		if (_tmp21_ > 20.0f) {
#line 13035 "ColorTransformation.c"
			gint _tmp22_;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp22_ = shadow_mean_intensity;
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = _tmp22_ < AUTO_ENHANCE_EMPIRICAL_DARK;
#line 13041 "ColorTransformation.c"
		} else {
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp20_ = FALSE;
#line 13045 "ColorTransformation.c"
		}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp18_ = _tmp20_;
#line 13049 "ColorTransformation.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	if (_tmp18_) {
#line 13053 "ColorTransformation.c"
		gfloat shadow_trans_effect_size = 0.0F;
		gint _tmp23_;
		gfloat _tmp24_;
		PixelTransformationBundle* _tmp25_;
		gfloat _tmp26_;
		ShadowDetailTransformation* _tmp27_;
		ShadowDetailTransformation* _tmp28_;
		gint discard_point = 0;
		PixelTransformationBundle* _tmp35_;
		gint _tmp36_;
		ExpansionTransformation* _tmp37_;
		ExpansionTransformation* _tmp38_;
#line 1420 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp23_ = shadow_mean_intensity;
#line 1420 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		shadow_trans_effect_size = ((((gfloat) AUTO_ENHANCE_SHADOW_DETECT_MAX_INTENSITY) - ((gfloat) _tmp23_)) / ((gfloat) AUTO_ENHANCE_SHADOW_DETECT_INTENSITY_RANGE)) * SHADOW_DETAIL_TRANSFORMATION_MAX_PARAMETER;
#line 1424 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp24_ = shadow_trans_effect_size;
#line 1424 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		shadow_trans_effect_size = _tmp24_ * AUTO_ENHANCE_SHADOW_AGGRESSIVENESS_MUL;
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp25_ = adjustments;
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp26_ = shadow_trans_effect_size;
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp27_ = shadow_detail_transformation_new (_tmp26_);
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp28_ = _tmp27_;
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1426 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp28_);
#line 1430 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		discard_point = 255;
#line 13088 "ColorTransformation.c"
		{
			gboolean _tmp29_ = FALSE;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			_tmp29_ = TRUE;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
			while (TRUE) {
#line 13095 "ColorTransformation.c"
				gint _tmp31_;
				IntensityHistogram* _tmp32_;
				gint _tmp33_;
				gfloat _tmp34_;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!_tmp29_) {
#line 13102 "ColorTransformation.c"
					gint _tmp30_;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					_tmp30_ = discard_point;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					discard_point = _tmp30_ - 1;
#line 13108 "ColorTransformation.c"
				}
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp29_ = FALSE;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp31_ = discard_point;
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if (!(_tmp31_ > -1)) {
#line 1431 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 13118 "ColorTransformation.c"
				}
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp32_ = analysis_histogram;
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp33_ = discard_point;
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				_tmp34_ = intensity_histogram_get_cumulative_probability (_tmp32_, _tmp33_);
#line 1432 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
				if ((1.0f - _tmp34_) > AUTO_ENHANCE_SHADOW_MODE_HIGH_DISCARD_MASS) {
#line 1434 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
					break;
#line 13130 "ColorTransformation.c"
				}
			}
		}
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp35_ = adjustments;
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp36_ = discard_point;
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp37_ = expansion_transformation_new_from_extrema (0, _tmp36_);
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp38_ = _tmp37_;
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1437 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp38_);
#line 13146 "ColorTransformation.c"
	} else {
		PixelTransformationBundle* _tmp39_;
		IntensityHistogram* _tmp40_;
		ExpansionTransformation* _tmp41_;
		ExpansionTransformation* _tmp42_;
		PixelTransformationBundle* _tmp43_;
		ShadowDetailTransformation* _tmp44_;
		ShadowDetailTransformation* _tmp45_;
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp39_ = adjustments;
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp40_ = analysis_histogram;
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp41_ = expansion_transformation_new (_tmp40_);
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp42_ = _tmp41_;
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp39_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1440 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp42_);
#line 1441 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp43_ = adjustments;
#line 1441 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp44_ = shadow_detail_transformation_new ((gfloat) 0);
#line 1441 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_tmp45_ = _tmp44_;
#line 1441 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		pixel_transformation_bundle_set (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1441 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
		_pixel_transformation_unref0 (_tmp45_);
#line 13177 "ColorTransformation.c"
	}
#line 1445 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp46_ = adjustments;
#line 1445 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp47_ = highlight_detail_transformation_new (0.0f);
#line 1445 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp48_ = _tmp47_;
#line 1445 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1445 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp48_);
#line 1446 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp49_ = adjustments;
#line 1446 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp50_ = temperature_transformation_new (0.0f);
#line 1446 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp51_ = _tmp50_;
#line 1446 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1446 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp51_);
#line 1447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp52_ = adjustments;
#line 1447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp53_ = tint_transformation_new (0.0f);
#line 1447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp54_ = _tmp53_;
#line 1447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1447 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp54_);
#line 1448 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp55_ = adjustments;
#line 1448 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp56_ = exposure_transformation_new (0.0f);
#line 1448 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp57_ = _tmp56_;
#line 1448 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1448 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp57_);
#line 1449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp58_ = adjustments;
#line 1449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp59_ = contrast_transformation_new (0.0f);
#line 1449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp60_ = _tmp59_;
#line 1449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1449 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp60_);
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp61_ = adjustments;
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp62_ = saturation_transformation_new (0.0f);
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_tmp63_ = _tmp62_;
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	pixel_transformation_bundle_set (_tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 1450 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_pixel_transformation_unref0 (_tmp63_);
#line 1452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	result = adjustments;
#line 1452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	_intensity_histogram_unref0 (analysis_histogram);
#line 1452 "/home/jens/Source/shotwell/src/ColorTransformation.vala"
	return result;
#line 13245 "ColorTransformation.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



