/* SearchBoolean.c generated by valac 0.34.4, the Vala compiler
 * generated from SearchBoolean.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* For specifying whether a search should be ORed (any) or ANDed (all).*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SEARCH_OPERATOR (search_operator_get_type ())

#define TYPE_SEARCH_CONDITION (search_condition_get_type ())
#define SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION, SearchCondition))
#define SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION, SearchConditionClass))
#define IS_SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION))
#define IS_SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION))
#define SEARCH_CONDITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION, SearchConditionClass))

typedef struct _SearchCondition SearchCondition;
typedef struct _SearchConditionClass SearchConditionClass;
typedef struct _SearchConditionPrivate SearchConditionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define SEARCH_CONDITION_TYPE_SEARCH_TYPE (search_condition_search_type_get_type ())
typedef struct _ParamSpecSearchCondition ParamSpecSearchCondition;

#define TYPE_SEARCH_CONDITION_TEXT (search_condition_text_get_type ())
#define SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionText))
#define SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))
#define IS_SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_TEXT))
#define IS_SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_TEXT))
#define SEARCH_CONDITION_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))

typedef struct _SearchConditionText SearchConditionText;
typedef struct _SearchConditionTextClass SearchConditionTextClass;
typedef struct _SearchConditionTextPrivate SearchConditionTextPrivate;

#define SEARCH_CONDITION_TEXT_TYPE_CONTEXT (search_condition_text_context_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_SEARCH_CONDITION_MEDIA_TYPE (search_condition_media_type_get_type ())
#define SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType))
#define SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))
#define IS_SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define IS_SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define SEARCH_CONDITION_MEDIA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))

typedef struct _SearchConditionMediaType SearchConditionMediaType;
typedef struct _SearchConditionMediaTypeClass SearchConditionMediaTypeClass;
typedef struct _SearchConditionMediaTypePrivate SearchConditionMediaTypePrivate;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_MEDIA_TYPE (search_condition_media_type_media_type_get_type ())

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_CONTEXT (search_condition_media_type_context_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_SEARCH_CONDITION_FLAGGED (search_condition_flagged_get_type ())
#define SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged))
#define SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))
#define IS_SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_FLAGGED))
#define IS_SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_FLAGGED))
#define SEARCH_CONDITION_FLAGGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))

typedef struct _SearchConditionFlagged SearchConditionFlagged;
typedef struct _SearchConditionFlaggedClass SearchConditionFlaggedClass;
typedef struct _SearchConditionFlaggedPrivate SearchConditionFlaggedPrivate;

#define SEARCH_CONDITION_FLAGGED_TYPE_STATE (search_condition_flagged_state_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_SEARCH_CONDITION_MODIFIED (search_condition_modified_get_type ())
#define SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified))
#define SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))
#define IS_SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MODIFIED))
#define IS_SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MODIFIED))
#define SEARCH_CONDITION_MODIFIED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))

typedef struct _SearchConditionModified SearchConditionModified;
typedef struct _SearchConditionModifiedClass SearchConditionModifiedClass;
typedef struct _SearchConditionModifiedPrivate SearchConditionModifiedPrivate;

#define SEARCH_CONDITION_MODIFIED_TYPE_STATE (search_condition_modified_state_get_type ())

#define SEARCH_CONDITION_MODIFIED_TYPE_CONTEXT (search_condition_modified_context_get_type ())

#define TYPE_SEARCH_CONDITION_RATING (search_condition_rating_get_type ())
#define SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRating))
#define SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))
#define IS_SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_RATING))
#define IS_SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_RATING))
#define SEARCH_CONDITION_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))

typedef struct _SearchConditionRating SearchConditionRating;
typedef struct _SearchConditionRatingClass SearchConditionRatingClass;
typedef struct _SearchConditionRatingPrivate SearchConditionRatingPrivate;

#define TYPE_RATING (rating_get_type ())

#define SEARCH_CONDITION_RATING_TYPE_CONTEXT (search_condition_rating_context_get_type ())

#define TYPE_SEARCH_CONDITION_DATE (search_condition_date_get_type ())
#define SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDate))
#define SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))
#define IS_SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_DATE))
#define IS_SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_DATE))
#define SEARCH_CONDITION_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))

typedef struct _SearchConditionDate SearchConditionDate;
typedef struct _SearchConditionDateClass SearchConditionDateClass;
typedef struct _SearchConditionDatePrivate SearchConditionDatePrivate;

#define SEARCH_CONDITION_DATE_TYPE_CONTEXT (search_condition_date_context_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_SAVED_SEARCH (saved_search_get_type ())
#define SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH, SavedSearch))
#define SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH, SavedSearchClass))
#define IS_SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH))
#define IS_SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH))
#define SAVED_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH, SavedSearchClass))

typedef struct _SavedSearch SavedSearch;
typedef struct _SavedSearchClass SavedSearchClass;
typedef struct _SavedSearchPrivate SavedSearchPrivate;

#define TYPE_SAVED_SEARCH_ROW (saved_search_row_get_type ())
#define SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRow))
#define SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))
#define IS_SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_ROW))
#define IS_SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_ROW))
#define SAVED_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))

typedef struct _SavedSearchRow SavedSearchRow;
typedef struct _SavedSearchRowClass SavedSearchRowClass;
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))
typedef struct _SavedSearchRowPrivate SavedSearchRowPrivate;

#define TYPE_SAVED_SEARCH_ID (saved_search_id_get_type ())
typedef struct _SavedSearchID SavedSearchID;
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_SAVED_SEARCH_DB_TABLE (saved_search_db_table_get_type ())
#define SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable))
#define SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))
#define IS_SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_DB_TABLE))
#define IS_SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_DB_TABLE))
#define SAVED_SEARCH_DB_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))

typedef struct _SavedSearchDBTable SavedSearchDBTable;
typedef struct _SavedSearchDBTableClass SavedSearchDBTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SAVED_SEARCH_TABLE (saved_search_table_get_type ())
#define SAVED_SEARCH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_TABLE, SavedSearchTable))
#define SAVED_SEARCH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_TABLE, SavedSearchTableClass))
#define IS_SAVED_SEARCH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_TABLE))
#define IS_SAVED_SEARCH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_TABLE))
#define SAVED_SEARCH_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_TABLE, SavedSearchTableClass))

typedef struct _SavedSearchTable SavedSearchTable;
typedef struct _SavedSearchTableClass SavedSearchTableClass;
#define _saved_search_table_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_table_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;
typedef struct _SavedSearchTablePrivate SavedSearchTablePrivate;
typedef struct _ParamSpecSavedSearchTable ParamSpecSavedSearchTable;

typedef enum  {
	SEARCH_OPERATOR_ANY = 0,
	SEARCH_OPERATOR_ALL,
	SEARCH_OPERATOR_NONE
} SearchOperator;

struct _SearchCondition {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SearchConditionPrivate * priv;
};

struct _SearchConditionClass {
	GTypeClass parent_class;
	void (*finalize) (SearchCondition *self);
	gboolean (*predicate) (SearchCondition* self, MediaSource* source);
};

typedef enum  {
	SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT = 0,
	SEARCH_CONDITION_SEARCH_TYPE_TITLE,
	SEARCH_CONDITION_SEARCH_TYPE_TAG,
	SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE,
	SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_RATING,
	SEARCH_CONDITION_SEARCH_TYPE_COMMENT,
	SEARCH_CONDITION_SEARCH_TYPE_DATE
} SearchConditionSearchType;

struct _SearchConditionPrivate {
	SearchConditionSearchType _search_type;
};

struct _ParamSpecSearchCondition {
	GParamSpec parent_instance;
};

struct _SearchConditionText {
	SearchCondition parent_instance;
	SearchConditionTextPrivate * priv;
};

struct _SearchConditionTextClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS = 0,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY,
	SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_SET
} SearchConditionTextContext;

struct _SearchConditionTextPrivate {
	gchar* _text;
	SearchConditionTextContext _context;
};

struct _SearchConditionMediaType {
	SearchCondition parent_instance;
	SearchConditionMediaTypePrivate * priv;
};

struct _SearchConditionMediaTypeClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL = 0,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO
} SearchConditionMediaTypeMediaType;

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS = 0,
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT
} SearchConditionMediaTypeContext;

struct _SearchConditionMediaTypePrivate {
	SearchConditionMediaTypeMediaType _media_type;
	SearchConditionMediaTypeContext _context;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _SearchConditionFlagged {
	SearchCondition parent_instance;
	SearchConditionFlaggedPrivate * priv;
};

struct _SearchConditionFlaggedClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	SEARCH_CONDITION_FLAGGED_STATE_FLAGGED = 0,
	SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED
} SearchConditionFlaggedState;

struct _SearchConditionFlaggedPrivate {
	SearchConditionFlaggedState _state;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _SearchConditionModified {
	SearchCondition parent_instance;
	SearchConditionModifiedPrivate * priv;
};

struct _SearchConditionModifiedClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	SEARCH_CONDITION_MODIFIED_STATE_MODIFIED = 0,
	SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES,
	SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES
} SearchConditionModifiedState;

typedef enum  {
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS = 0,
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO
} SearchConditionModifiedContext;

struct _SearchConditionModifiedPrivate {
	SearchConditionModifiedState _state;
	SearchConditionModifiedContext _context;
};

struct _SearchConditionRating {
	SearchCondition parent_instance;
	SearchConditionRatingPrivate * priv;
};

struct _SearchConditionRatingClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER = 0,
	SEARCH_CONDITION_RATING_CONTEXT_ONLY,
	SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER
} SearchConditionRatingContext;

struct _SearchConditionRatingPrivate {
	Rating _rating;
	SearchConditionRatingContext _context;
};

struct _SearchConditionDate {
	SearchCondition parent_instance;
	SearchConditionDatePrivate * priv;
};

struct _SearchConditionDateClass {
	SearchConditionClass parent_class;
};

typedef enum  {
	SEARCH_CONDITION_DATE_CONTEXT_EXACT = 0,
	SEARCH_CONDITION_DATE_CONTEXT_AFTER,
	SEARCH_CONDITION_DATE_CONTEXT_BEFORE,
	SEARCH_CONDITION_DATE_CONTEXT_BETWEEN,
	SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET
} SearchConditionDateContext;

struct _SearchConditionDatePrivate {
	GDateTime* _date_one;
	GDateTime* _date_two;
	SearchConditionDateContext _context;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _SavedSearch {
	DataSource parent_instance;
	SavedSearchPrivate * priv;
};

struct _SavedSearchClass {
	DataSourceClass parent_class;
};

struct _SavedSearchPrivate {
	SavedSearchRow* row;
};

struct _SavedSearchID {
	gint64 id;
};

struct _SavedSearchRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchRowPrivate * priv;
	SavedSearchID search_id;
	gchar* name;
	SearchOperator operator;
	GeeList* conditions;
};

struct _SavedSearchRowClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _SavedSearchTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchTablePrivate * priv;
};

struct _SavedSearchTableClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchTable *self);
};

struct _SavedSearchTablePrivate {
	GeeHashMap* search_map;
};

struct _ParamSpecSavedSearchTable {
	GParamSpec parent_instance;
};


static gpointer search_condition_parent_class = NULL;
static gpointer search_condition_text_parent_class = NULL;
extern TagSourceCollection* tag_global;
static gpointer search_condition_media_type_parent_class = NULL;
static gpointer search_condition_flagged_parent_class = NULL;
static gpointer search_condition_modified_parent_class = NULL;
static gpointer search_condition_rating_parent_class = NULL;
static gpointer search_condition_date_parent_class = NULL;
static gpointer saved_search_parent_class = NULL;
static gpointer saved_search_table_parent_class = NULL;
static SavedSearchTable* saved_search_table_instance;
static SavedSearchTable* saved_search_table_instance = NULL;

GType search_operator_get_type (void) G_GNUC_CONST;
gchar* search_operator_to_string (SearchOperator self);
SearchOperator search_operator_from_string (const gchar* str);
gpointer search_condition_ref (gpointer instance);
void search_condition_unref (gpointer instance);
GParamSpec* param_spec_search_condition (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_search_condition (GValue* value, gpointer v_object);
void value_take_search_condition (GValue* value, gpointer v_object);
gpointer value_get_search_condition (const GValue* value);
GType search_condition_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType search_condition_search_type_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION, SearchConditionPrivate))
enum  {
	SEARCH_CONDITION_DUMMY_PROPERTY
};
SearchConditionSearchType* search_condition_search_type_as_array (int* result_length1);
void search_condition_search_type_sort_array (SearchConditionSearchType** array, int* array_length1);
static gint __lambda11_ (void* a, void* b);
gint utf8_cs_compare (void* a, void* b);
gchar* search_condition_search_type_display_text (SearchConditionSearchType self);
static gint ___lambda11____compar_fn_t (void* key1, void* key2);
gchar* search_condition_search_type_to_string (SearchConditionSearchType self);
SearchConditionSearchType search_condition_search_type_from_string (const gchar* str);
gboolean search_condition_predicate (SearchCondition* self, MediaSource* source);
static gboolean search_condition_real_predicate (SearchCondition* self, MediaSource* source);
SearchCondition* search_condition_construct (GType object_type);
SearchConditionSearchType search_condition_get_search_type (SearchCondition* self);
void search_condition_set_search_type (SearchCondition* self, SearchConditionSearchType value);
static void search_condition_finalize (SearchCondition* obj);
GType search_condition_text_get_type (void) G_GNUC_CONST;
GType search_condition_text_context_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_TEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextPrivate))
enum  {
	SEARCH_CONDITION_TEXT_DUMMY_PROPERTY
};
gchar* search_condition_text_context_to_string (SearchConditionTextContext self);
SearchConditionTextContext search_condition_text_context_from_string (const gchar* str);
SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context);
SearchConditionText* search_condition_text_construct (GType object_type, SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context);
gchar* string_remove_diacritics (const gchar* istring);
static void search_condition_text_set_text (SearchConditionText* self, const gchar* value);
static void search_condition_text_set_context (SearchConditionText* self, SearchConditionTextContext value);
static gboolean search_condition_text_string_match (SearchConditionText* self, const gchar* needle, const gchar* haystack);
SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self);
gboolean is_string_empty (const gchar* s);
static gboolean search_condition_text_real_predicate (SearchCondition* base, MediaSource* source);
gchar* media_source_get_title (MediaSource* self);
const gchar* search_condition_text_get_text (SearchConditionText* self);
GType tag_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self, MediaSource* source);
gchar* tag_get_searchable_name (Tag* self);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
gchar* data_object_get_name (DataObject* self);
gchar* media_source_get_comment (MediaSource* self);
gchar* media_source_get_basename (MediaSource* self);
static void search_condition_text_finalize (SearchCondition* obj);
GType search_condition_media_type_get_type (void) G_GNUC_CONST;
GType search_condition_media_type_media_type_get_type (void) G_GNUC_CONST;
GType search_condition_media_type_context_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_MEDIA_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypePrivate))
enum  {
	SEARCH_CONDITION_MEDIA_TYPE_DUMMY_PROPERTY
};
gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self);
SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str);
gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self);
SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str);
SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type);
SearchConditionMediaType* search_condition_media_type_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type);
static void search_condition_media_type_set_context (SearchConditionMediaType* self, SearchConditionMediaTypeContext value);
static void search_condition_media_type_set_media_type (SearchConditionMediaType* self, SearchConditionMediaTypeMediaType value);
static gboolean search_condition_media_type_real_predicate (SearchCondition* base, MediaSource* source);
SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType video_source_get_type (void) G_GNUC_CONST;
static void search_condition_media_type_finalize (SearchCondition* obj);
GType search_condition_flagged_get_type (void) G_GNUC_CONST;
GType search_condition_flagged_state_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_FLAGGED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedPrivate))
enum  {
	SEARCH_CONDITION_FLAGGED_DUMMY_PROPERTY
};
gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self);
SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str);
SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type, SearchConditionFlaggedState state);
SearchConditionFlagged* search_condition_flagged_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionFlaggedState state);
static void search_condition_flagged_set_state (SearchConditionFlagged* self, SearchConditionFlaggedState value);
static gboolean search_condition_flagged_real_predicate (SearchCondition* base, MediaSource* source);
SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
static void search_condition_flagged_finalize (SearchCondition* obj);
GType search_condition_modified_get_type (void) G_GNUC_CONST;
GType search_condition_modified_state_get_type (void) G_GNUC_CONST;
GType search_condition_modified_context_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_MODIFIED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedPrivate))
enum  {
	SEARCH_CONDITION_MODIFIED_DUMMY_PROPERTY
};
gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self);
SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str);
gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self);
SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str);
SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state);
SearchConditionModified* search_condition_modified_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state);
static void search_condition_modified_set_context (SearchConditionModified* self, SearchConditionModifiedContext value);
static void search_condition_modified_set_state (SearchConditionModified* self, SearchConditionModifiedState value);
static gboolean search_condition_modified_real_predicate (SearchCondition* base, MediaSource* source);
SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self);
gboolean photo_has_transformations (Photo* self);
gboolean photo_has_editable (Photo* self);
SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self);
static void search_condition_modified_finalize (SearchCondition* obj);
GType search_condition_rating_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType search_condition_rating_context_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_RATING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingPrivate))
enum  {
	SEARCH_CONDITION_RATING_DUMMY_PROPERTY
};
gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self);
SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str);
SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context);
SearchConditionRating* search_condition_rating_construct (GType object_type, SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context);
static void search_condition_rating_set_rating (SearchConditionRating* self, Rating value);
static void search_condition_rating_set_context (SearchConditionRating* self, SearchConditionRatingContext value);
static gboolean search_condition_rating_real_predicate (SearchCondition* base, MediaSource* source);
Rating media_source_get_rating (MediaSource* self);
SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self);
Rating search_condition_rating_get_rating (SearchConditionRating* self);
static void search_condition_rating_finalize (SearchCondition* obj);
GType search_condition_date_get_type (void) G_GNUC_CONST;
GType search_condition_date_context_get_type (void) G_GNUC_CONST;
#define SEARCH_CONDITION_DATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_CONDITION_DATE, SearchConditionDatePrivate))
enum  {
	SEARCH_CONDITION_DATE_DUMMY_PROPERTY
};
gchar* search_condition_date_context_to_string (SearchConditionDateContext self);
SearchConditionDateContext search_condition_date_context_from_string (const gchar* str);
SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two);
SearchConditionDate* search_condition_date_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two);
static void search_condition_date_set_context (SearchConditionDate* self, SearchConditionDateContext value);
static void search_condition_date_set_date_one (SearchConditionDate* self, GDateTime* value);
static void search_condition_date_set_date_two (SearchConditionDate* self, GDateTime* value);
static gboolean search_condition_date_real_predicate (SearchCondition* base, MediaSource* source);
time_t media_source_get_exposure_time (MediaSource* self);
SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self);
GDateTime* search_condition_date_get_date_one (SearchConditionDate* self);
GDateTime* search_condition_date_get_date_two (SearchConditionDate* self);
static void search_condition_date_finalize (SearchCondition* obj);
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType saved_search_get_type (void) G_GNUC_CONST;
gpointer saved_search_row_ref (gpointer instance);
void saved_search_row_unref (gpointer instance);
GParamSpec* param_spec_saved_search_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_saved_search_row (GValue* value, gpointer v_object);
void value_take_saved_search_row (GValue* value, gpointer v_object);
gpointer value_get_saved_search_row (const GValue* value);
GType saved_search_row_get_type (void) G_GNUC_CONST;
#define SAVED_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SAVED_SEARCH, SavedSearchPrivate))
enum  {
	SAVED_SEARCH_DUMMY_PROPERTY
};
#define SAVED_SEARCH_TYPENAME "saved_search"
SavedSearch* saved_search_new (SavedSearchRow* row, gint64 object_id);
SavedSearch* saved_search_construct (GType object_type, SavedSearchRow* row, gint64 object_id);
DataSource* data_source_construct (GType object_type, gint64 object_id);
static gchar* saved_search_real_get_name (DataObject* base);
GType saved_search_id_get_type (void) G_GNUC_CONST;
SavedSearchID* saved_search_id_dup (const SavedSearchID* self);
void saved_search_id_free (SavedSearchID* self);
static gchar* saved_search_real_to_string (DataObject* base);
static gchar* saved_search_real_get_typename (DataSource* base);
void saved_search_get_saved_search_id (SavedSearch* self, SavedSearchID* result);
static gint64 saved_search_real_get_instance_id (DataSource* base);
gint saved_search_compare_names (void* a, void* b);
gint string_collated_compare (void* a, void* b);
gboolean saved_search_predicate (SavedSearch* self, MediaSource* source);
void saved_search_reconstitute (SavedSearch* self);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType saved_search_db_table_get_type (void) G_GNUC_CONST;
SavedSearchDBTable* saved_search_db_table_get_instance (void);
GQuark database_error_quark (void);
void saved_search_db_table_create_from_row (SavedSearchDBTable* self, SavedSearchRow* row, SavedSearchID* result, GError** error);
void app_window_database_error (GError* err);
gpointer saved_search_table_ref (gpointer instance);
void saved_search_table_unref (gpointer instance);
GParamSpec* param_spec_saved_search_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_saved_search_table (GValue* value, gpointer v_object);
void value_take_saved_search_table (GValue* value, gpointer v_object);
gpointer value_get_saved_search_table (const GValue* value);
GType saved_search_table_get_type (void) G_GNUC_CONST;
SavedSearchTable* saved_search_table_get_instance (void);
void saved_search_table_add_to_map (SavedSearchTable* self, SavedSearch* search);
gchar* data_object_to_string (DataObject* self);
gboolean saved_search_rename (SavedSearch* self, const gchar* new_name);
gboolean saved_search_table_exists (SavedSearchTable* self, const gchar* search_name);
void saved_search_db_table_rename (SavedSearchDBTable* self, SavedSearchID* search_id, const gchar* new_name, GError** error);
void saved_search_table_remove_from_map (SavedSearchTable* self, SavedSearch* search);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
GType library_window_get_type (void) G_GNUC_CONST;
LibraryWindow* library_window_get_app (void);
void library_window_switch_to_saved_search (LibraryWindow* self, SavedSearch* search);
GeeList* saved_search_get_conditions (SavedSearch* self);
SearchOperator saved_search_get_operator (SavedSearch* self);
static void saved_search_finalize (GObject* obj);
#define SAVED_SEARCH_TABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SAVED_SEARCH_TABLE, SavedSearchTablePrivate))
enum  {
	SAVED_SEARCH_TABLE_DUMMY_PROPERTY
};
static SavedSearchTable* saved_search_table_new (void);
static SavedSearchTable* saved_search_table_construct (GType object_type);
GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self, GError** error);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
GeeCollection* saved_search_table_get_all (SavedSearchTable* self);
SavedSearch* saved_search_table_create (SavedSearchTable* self, const gchar* name, SearchOperator operator, GeeArrayList* conditions);
SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self, const gchar* name, SearchOperator operator, GeeArrayList* conditions, GError** error);
void saved_search_table_remove (SavedSearchTable* self, SavedSearch* search);
void saved_search_db_table_remove (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error);
GeeIterable* saved_search_table_get_saved_searches (SavedSearchTable* self);
gint saved_search_table_get_count (SavedSearchTable* self);
gchar* saved_search_table_generate_unique_name (SavedSearchTable* self);
#define RESOURCES_DEFAULT_SAVED_SEARCH_NAME _ ("Saved Search")
static void saved_search_table_finalize (SavedSearchTable* obj);


gchar* search_operator_to_string (SearchOperator self) {
	gchar* result = NULL;
#line 14 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 14 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_OPERATOR_ANY:
#line 1005 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 16 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("ANY");
#line 16 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 16 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1014 "SearchBoolean.c"
		}
#line 14 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_OPERATOR_ALL:
#line 1018 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("ALL");
#line 19 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 19 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1027 "SearchBoolean.c"
		}
#line 14 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_OPERATOR_NONE:
#line 1031 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 22 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("NONE");
#line 22 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 22 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1040 "SearchBoolean.c"
		}
		default:
		{
#line 25 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:25: unrecognized search operator enumeration value");
#line 1046 "SearchBoolean.c"
		}
	}
}


SearchOperator search_operator_from_string (const gchar* str) {
	SearchOperator result = 0;
	const gchar* _tmp0_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 30 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 30 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "ANY") == 0) {
#line 31 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_OPERATOR_ANY;
#line 31 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 1065 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 33 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 33 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "ALL") == 0) {
#line 34 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_OPERATOR_ALL;
#line 34 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1076 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 36 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 36 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "NONE") == 0) {
#line 37 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_OPERATOR_NONE;
#line 37 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 1087 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 40 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 40 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:40: unrecognized search operator name: %s", _tmp3_);
#line 1094 "SearchBoolean.c"
			}
		}
	}
}


GType search_operator_get_type (void) {
	static volatile gsize search_operator_type_id__volatile = 0;
	if (g_once_init_enter (&search_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_OPERATOR_ANY, "SEARCH_OPERATOR_ANY", "any"}, {SEARCH_OPERATOR_ALL, "SEARCH_OPERATOR_ALL", "all"}, {SEARCH_OPERATOR_NONE, "SEARCH_OPERATOR_NONE", "none"}, {0, NULL, NULL}};
		GType search_operator_type_id;
		search_operator_type_id = g_enum_register_static ("SearchOperator", values);
		g_once_init_leave (&search_operator_type_id__volatile, search_operator_type_id);
	}
	return search_operator_type_id__volatile;
}


SearchConditionSearchType* search_condition_search_type_as_array (int* result_length1) {
	SearchConditionSearchType* result = NULL;
	SearchConditionSearchType* _tmp0_ = NULL;
	SearchConditionSearchType* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = g_new0 (SearchConditionSearchType, 11);
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[0] = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[1] = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[2] = SEARCH_CONDITION_SEARCH_TYPE_TAG;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[3] = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[4] = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[5] = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[6] = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[7] = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[8] = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[9] = SEARCH_CONDITION_SEARCH_TYPE_RATING;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_[10] = SEARCH_CONDITION_SEARCH_TYPE_DATE;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1__length1 = 11;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (result_length1) {
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*result_length1 = _tmp1__length1;
#line 1150 "SearchBoolean.c"
	}
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp1_;
#line 64 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 1156 "SearchBoolean.c"
}


static gint __lambda11_ (void* a, void* b) {
	gint result = 0;
	void* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	void* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = a;
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) _tmp0_));
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = b;
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) _tmp2_));
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = utf8_cs_compare (_tmp1_, _tmp3_);
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp4_;
#line 71 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 1181 "SearchBoolean.c"
}


static gint ___lambda11____compar_fn_t (void* key1, void* key2) {
	gint result;
	result = __lambda11_ (key1, key2);
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 1190 "SearchBoolean.c"
}


void search_condition_search_type_sort_array (SearchConditionSearchType** array, int* array_length1) {
	SearchConditionSearchType* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	SearchConditionSearchType* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = *array;
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0__length1 = *array_length1;
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = *array;
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1__length1 = *array_length1;
#line 70 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	qsort (_tmp0_, (gsize) _tmp1__length1, (gsize) sizeof (SearchConditionSearchType), ___lambda11____compar_fn_t);
#line 1209 "SearchBoolean.c"
}


gchar* search_condition_search_type_to_string (SearchConditionSearchType self) {
	gchar* result = NULL;
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
#line 1219 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("ANY_TEXT");
#line 79 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 79 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1228 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
#line 1232 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("TITLE");
#line 82 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1241 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
#line 1245 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("TAG");
#line 85 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 85 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1254 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
#line 1258 "SearchBoolean.c"
		{
			gchar* _tmp3_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = g_strdup ("COMMENT");
#line 88 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp3_;
#line 88 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1267 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
#line 1271 "SearchBoolean.c"
		{
			gchar* _tmp4_ = NULL;
#line 91 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = g_strdup ("EVENT_NAME");
#line 91 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp4_;
#line 91 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1280 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
#line 1284 "SearchBoolean.c"
		{
			gchar* _tmp5_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = g_strdup ("FILE_NAME");
#line 94 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp5_;
#line 94 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1293 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
#line 1297 "SearchBoolean.c"
		{
			gchar* _tmp6_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp6_ = g_strdup ("MEDIA_TYPE");
#line 97 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp6_;
#line 97 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1306 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
#line 1310 "SearchBoolean.c"
		{
			gchar* _tmp7_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = g_strdup ("FLAG_STATE");
#line 100 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp7_;
#line 100 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1319 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
#line 1323 "SearchBoolean.c"
		{
			gchar* _tmp8_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = g_strdup ("MODIFIED_STATE");
#line 103 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp8_;
#line 103 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1332 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_RATING:
#line 1336 "SearchBoolean.c"
		{
			gchar* _tmp9_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp9_ = g_strdup ("RATING");
#line 106 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp9_;
#line 106 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1345 "SearchBoolean.c"
		}
#line 77 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
#line 1349 "SearchBoolean.c"
		{
			gchar* _tmp10_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = g_strdup ("DATE");
#line 109 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp10_;
#line 109 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1358 "SearchBoolean.c"
		}
		default:
		{
#line 112 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:112: unrecognized search type enumeration value");
#line 1364 "SearchBoolean.c"
		}
	}
}


SearchConditionSearchType search_condition_search_type_from_string (const gchar* str) {
	SearchConditionSearchType result = 0;
	const gchar* _tmp0_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 117 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 117 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "ANY_TEXT") == 0) {
#line 118 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
#line 118 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 1383 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 120 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "TITLE") == 0) {
#line 121 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
#line 121 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1394 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 123 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "TAG") == 0) {
#line 124 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_SEARCH_TYPE_TAG;
#line 124 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 1405 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 126 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 126 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (g_strcmp0 (_tmp3_, "COMMENT") == 0) {
#line 127 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					result = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
#line 127 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					return result;
#line 1416 "SearchBoolean.c"
				} else {
					const gchar* _tmp4_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp4_ = str;
#line 129 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					if (g_strcmp0 (_tmp4_, "EVENT_NAME") == 0) {
#line 130 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						result = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
#line 130 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						return result;
#line 1427 "SearchBoolean.c"
					} else {
						const gchar* _tmp5_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp5_ = str;
#line 132 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						if (g_strcmp0 (_tmp5_, "FILE_NAME") == 0) {
#line 133 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							result = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
#line 133 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							return result;
#line 1438 "SearchBoolean.c"
						} else {
							const gchar* _tmp6_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							_tmp6_ = str;
#line 135 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							if (g_strcmp0 (_tmp6_, "MEDIA_TYPE") == 0) {
#line 136 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								result = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
#line 136 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								return result;
#line 1449 "SearchBoolean.c"
							} else {
								const gchar* _tmp7_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								_tmp7_ = str;
#line 138 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								if (g_strcmp0 (_tmp7_, "FLAG_STATE") == 0) {
#line 139 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
									result = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
#line 139 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
									return result;
#line 1460 "SearchBoolean.c"
								} else {
									const gchar* _tmp8_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
									_tmp8_ = str;
#line 141 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
									if (g_strcmp0 (_tmp8_, "MODIFIED_STATE") == 0) {
#line 142 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
										result = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
#line 142 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
										return result;
#line 1471 "SearchBoolean.c"
									} else {
										const gchar* _tmp9_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
										_tmp9_ = str;
#line 144 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
										if (g_strcmp0 (_tmp9_, "RATING") == 0) {
#line 145 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
											result = SEARCH_CONDITION_SEARCH_TYPE_RATING;
#line 145 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
											return result;
#line 1482 "SearchBoolean.c"
										} else {
											const gchar* _tmp10_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
											_tmp10_ = str;
#line 147 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
											if (g_strcmp0 (_tmp10_, "DATE") == 0) {
#line 148 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
												result = SEARCH_CONDITION_SEARCH_TYPE_DATE;
#line 148 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
												return result;
#line 1493 "SearchBoolean.c"
											} else {
												const gchar* _tmp11_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
												_tmp11_ = str;
#line 151 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
												g_error ("SearchBoolean.vala:151: unrecognized search type name: %s", _tmp11_);
#line 1500 "SearchBoolean.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gchar* search_condition_search_type_display_text (SearchConditionSearchType self) {
	gchar* result = NULL;
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
#line 1521 "SearchBoolean.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = _ ("Any text");
#line 157 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 157 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 157 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1533 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
#line 1537 "SearchBoolean.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = _ ("Title");
#line 160 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 160 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp3_;
#line 160 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1549 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
#line 1553 "SearchBoolean.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = _ ("Tag");
#line 163 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 163 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp5_;
#line 163 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1565 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
#line 1569 "SearchBoolean.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp6_ = _ ("Comment");
#line 166 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 166 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp7_;
#line 166 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1581 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
#line 1585 "SearchBoolean.c"
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 169 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = _ ("Event name");
#line 169 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 169 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp9_;
#line 169 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1597 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
#line 1601 "SearchBoolean.c"
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = _ ("File name");
#line 172 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 172 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp11_;
#line 172 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1613 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
#line 1617 "SearchBoolean.c"
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp12_ = _ ("Media type");
#line 175 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 175 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp13_;
#line 175 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1629 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
#line 1633 "SearchBoolean.c"
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
#line 178 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp14_ = _ ("Flag state");
#line 178 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 178 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp15_;
#line 178 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1645 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
#line 1649 "SearchBoolean.c"
		{
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
#line 181 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp16_ = _ ("Photo state");
#line 181 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp17_ = g_strdup (_tmp16_);
#line 181 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp17_;
#line 181 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1661 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_RATING:
#line 1665 "SearchBoolean.c"
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp18_ = _ ("Rating");
#line 184 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp19_ = g_strdup (_tmp18_);
#line 184 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp19_;
#line 184 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1677 "SearchBoolean.c"
		}
#line 155 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
#line 1681 "SearchBoolean.c"
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp20_ = _ ("Date");
#line 187 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 187 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp21_;
#line 187 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 1693 "SearchBoolean.c"
		}
		default:
		{
#line 190 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:190: unrecognized search type enumeration value");
#line 1699 "SearchBoolean.c"
		}
	}
}


GType search_condition_search_type_get_type (void) {
	static volatile gsize search_condition_search_type_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_search_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT, "SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT", "any-text"}, {SEARCH_CONDITION_SEARCH_TYPE_TITLE, "SEARCH_CONDITION_SEARCH_TYPE_TITLE", "title"}, {SEARCH_CONDITION_SEARCH_TYPE_TAG, "SEARCH_CONDITION_SEARCH_TYPE_TAG", "tag"}, {SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME, "SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME", "event-name"}, {SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME, "SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME", "file-name"}, {SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE, "SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE", "media-type"}, {SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE, "SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE", "flag-state"}, {SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE, "SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE", "modified-state"}, {SEARCH_CONDITION_SEARCH_TYPE_RATING, "SEARCH_CONDITION_SEARCH_TYPE_RATING", "rating"}, {SEARCH_CONDITION_SEARCH_TYPE_COMMENT, "SEARCH_CONDITION_SEARCH_TYPE_COMMENT", "comment"}, {SEARCH_CONDITION_SEARCH_TYPE_DATE, "SEARCH_CONDITION_SEARCH_TYPE_DATE", "date"}, {0, NULL, NULL}};
		GType search_condition_search_type_type_id;
		search_condition_search_type_type_id = g_enum_register_static ("SearchConditionSearchType", values);
		g_once_init_leave (&search_condition_search_type_type_id__volatile, search_condition_search_type_type_id);
	}
	return search_condition_search_type_type_id__volatile;
}


static gboolean search_condition_real_predicate (SearchCondition* self, MediaSource* source) {
#line 198 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_critical ("Type `%s' does not implement abstract method `search_condition_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 198 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return FALSE;
#line 1722 "SearchBoolean.c"
}


gboolean search_condition_predicate (SearchCondition* self, MediaSource* source) {
#line 198 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION (self), FALSE);
#line 198 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return SEARCH_CONDITION_GET_CLASS (self)->predicate (self, source);
#line 1731 "SearchBoolean.c"
}


SearchCondition* search_condition_construct (GType object_type) {
	SearchCondition* self = NULL;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchCondition*) g_type_create_instance (object_type);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 1741 "SearchBoolean.c"
}


SearchConditionSearchType search_condition_get_search_type (SearchCondition* self) {
	SearchConditionSearchType result;
	SearchConditionSearchType _tmp0_ = 0;
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION (self), 0);
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_search_type;
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 1756 "SearchBoolean.c"
}


void search_condition_set_search_type (SearchCondition* self, SearchConditionSearchType value) {
	SearchConditionSearchType _tmp0_ = 0;
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION (self));
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 195 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_search_type = _tmp0_;
#line 1768 "SearchBoolean.c"
}


static void value_search_condition_init (GValue* value) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	value->data[0].v_pointer = NULL;
#line 1775 "SearchBoolean.c"
}


static void value_search_condition_free_value (GValue* value) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_unref (value->data[0].v_pointer);
#line 1784 "SearchBoolean.c"
	}
}


static void value_search_condition_copy_value (const GValue* src_value, GValue* dest_value) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (src_value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		dest_value->data[0].v_pointer = search_condition_ref (src_value->data[0].v_pointer);
#line 1794 "SearchBoolean.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1798 "SearchBoolean.c"
	}
}


static gpointer value_search_condition_peek_pointer (const GValue* value) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return value->data[0].v_pointer;
#line 1806 "SearchBoolean.c"
}


static gchar* value_search_condition_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (collect_values[0].v_pointer) {
#line 1813 "SearchBoolean.c"
		SearchCondition* object;
		object = collect_values[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (object->parent_instance.g_class == NULL) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1820 "SearchBoolean.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1824 "SearchBoolean.c"
		}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = search_condition_ref (object);
#line 1828 "SearchBoolean.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 1832 "SearchBoolean.c"
	}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return NULL;
#line 1836 "SearchBoolean.c"
}


static gchar* value_search_condition_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SearchCondition** object_p;
	object_p = collect_values[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (!object_p) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1847 "SearchBoolean.c"
	}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (!value->data[0].v_pointer) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = NULL;
#line 1853 "SearchBoolean.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = value->data[0].v_pointer;
#line 1857 "SearchBoolean.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = search_condition_ref (value->data[0].v_pointer);
#line 1861 "SearchBoolean.c"
	}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return NULL;
#line 1865 "SearchBoolean.c"
}


GParamSpec* param_spec_search_condition (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSearchCondition* spec;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SEARCH_CONDITION), NULL);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return G_PARAM_SPEC (spec);
#line 1879 "SearchBoolean.c"
}


gpointer value_get_search_condition (const GValue* value) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION), NULL);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return value->data[0].v_pointer;
#line 1888 "SearchBoolean.c"
}


void value_set_search_condition (GValue* value, gpointer v_object) {
	SearchCondition* old;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (v_object) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = v_object;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_ref (value->data[0].v_pointer);
#line 1908 "SearchBoolean.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 1912 "SearchBoolean.c"
	}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (old) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_unref (old);
#line 1918 "SearchBoolean.c"
	}
}


void value_take_search_condition (GValue* value, gpointer v_object) {
	SearchCondition* old;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	old = value->data[0].v_pointer;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (v_object) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = v_object;
#line 1937 "SearchBoolean.c"
	} else {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 1941 "SearchBoolean.c"
	}
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (old) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_unref (old);
#line 1947 "SearchBoolean.c"
	}
}


static void search_condition_class_init (SearchConditionClass * klass) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_finalize;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionPrivate));
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_real_predicate;
#line 1961 "SearchBoolean.c"
}


static void search_condition_instance_init (SearchCondition * self) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_GET_PRIVATE (self);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->ref_count = 1;
#line 1970 "SearchBoolean.c"
}


static void search_condition_finalize (SearchCondition* obj) {
	SearchCondition * self;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION, SearchCondition);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_handlers_destroy (self);
#line 1980 "SearchBoolean.c"
}


GType search_condition_get_type (void) {
	static volatile gsize search_condition_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_search_condition_init, value_search_condition_free_value, value_search_condition_copy_value, value_search_condition_peek_pointer, "p", value_search_condition_collect_value, "p", value_search_condition_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchCondition), 0, (GInstanceInitFunc) search_condition_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType search_condition_type_id;
		search_condition_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SearchCondition", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&search_condition_type_id__volatile, search_condition_type_id);
	}
	return search_condition_type_id__volatile;
}


gpointer search_condition_ref (gpointer instance) {
	SearchCondition* self;
	self = instance;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_atomic_int_inc (&self->ref_count);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return instance;
#line 2005 "SearchBoolean.c"
}


void search_condition_unref (gpointer instance) {
	SearchCondition* self;
	self = instance;
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		SEARCH_CONDITION_GET_CLASS (self)->finalize (self);
#line 47 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2018 "SearchBoolean.c"
	}
}


gchar* search_condition_text_context_to_string (SearchConditionTextContext self) {
	gchar* result = NULL;
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
#line 2029 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("CONTAINS");
#line 215 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 215 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2038 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
#line 2042 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("IS_EXACTLY");
#line 218 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 218 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2051 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
#line 2055 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("STARTS_WITH");
#line 221 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 221 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2064 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
#line 2068 "SearchBoolean.c"
		{
			gchar* _tmp3_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = g_strdup ("ENDS_WITH");
#line 224 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp3_;
#line 224 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2077 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
#line 2081 "SearchBoolean.c"
		{
			gchar* _tmp4_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = g_strdup ("DOES_NOT_CONTAIN");
#line 227 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp4_;
#line 227 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2090 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
#line 2094 "SearchBoolean.c"
		{
			gchar* _tmp5_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = g_strdup ("IS_NOT_SET");
#line 230 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp5_;
#line 230 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2103 "SearchBoolean.c"
		}
#line 213 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_SET:
#line 2107 "SearchBoolean.c"
		{
			gchar* _tmp6_ = NULL;
#line 233 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp6_ = g_strdup ("IS_SET");
#line 233 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp6_;
#line 233 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2116 "SearchBoolean.c"
		}
		default:
		{
#line 236 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:236: unrecognized text search context enumeration v" \
"alue");
#line 2122 "SearchBoolean.c"
		}
	}
}


SearchConditionTextContext search_condition_text_context_from_string (const gchar* str) {
	SearchConditionTextContext result = 0;
	const gchar* _tmp0_ = NULL;
#line 240 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 241 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 241 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "CONTAINS") == 0) {
#line 242 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS;
#line 242 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 2141 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 244 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "IS_EXACTLY") == 0) {
#line 245 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY;
#line 245 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2152 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 247 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 247 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "STARTS_WITH") == 0) {
#line 248 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH;
#line 248 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 2163 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 250 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 250 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (g_strcmp0 (_tmp3_, "ENDS_WITH") == 0) {
#line 251 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					result = SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH;
#line 251 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					return result;
#line 2174 "SearchBoolean.c"
				} else {
					const gchar* _tmp4_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp4_ = str;
#line 253 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					if (g_strcmp0 (_tmp4_, "DOES_NOT_CONTAIN") == 0) {
#line 254 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						result = SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN;
#line 254 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						return result;
#line 2185 "SearchBoolean.c"
					} else {
						const gchar* _tmp5_ = NULL;
#line 256 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp5_ = str;
#line 256 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						if (g_strcmp0 (_tmp5_, "IS_NOT_SET") == 0) {
#line 257 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							result = SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET;
#line 257 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							return result;
#line 2196 "SearchBoolean.c"
						} else {
							const gchar* _tmp6_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							_tmp6_ = str;
#line 259 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
							if (g_strcmp0 (_tmp6_, "IS_SET") == 0) {
#line 260 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								result = SEARCH_CONDITION_TEXT_CONTEXT_IS_SET;
#line 260 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								return result;
#line 2207 "SearchBoolean.c"
							} else {
								const gchar* _tmp7_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								_tmp7_ = str;
#line 263 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
								g_error ("SearchBoolean.vala:263: unrecognized text search context name: %s", _tmp7_);
#line 2214 "SearchBoolean.c"
							}
						}
					}
				}
			}
		}
	}
}


GType search_condition_text_context_get_type (void) {
	static volatile gsize search_condition_text_context_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_text_context_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS, "SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS", "contains"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY, "SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY", "is-exactly"}, {SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH", "starts-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH", "ends-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN, "SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN", "does-not-contain"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET", "is-not-set"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_SET, "SEARCH_CONDITION_TEXT_CONTEXT_IS_SET", "is-set"}, {0, NULL, NULL}};
		GType search_condition_text_context_type_id;
		search_condition_text_context_type_id = g_enum_register_static ("SearchConditionTextContext", values);
		g_once_init_leave (&search_condition_text_context_type_id__volatile, search_condition_text_context_type_id);
	}
	return search_condition_text_context_type_id__volatile;
}


SearchConditionText* search_condition_text_construct (GType object_type, SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context) {
	SearchConditionText* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	SearchConditionTextContext _tmp8_ = 0;
#line 273 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionText*) search_condition_construct (object_type);
#line 274 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 274 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = text;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp2_ != NULL) {
#line 2253 "SearchBoolean.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = text;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = _tmp4_;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = string_remove_diacritics (_tmp5_);
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp1_);
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = _tmp6_;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp5_);
#line 2272 "SearchBoolean.c"
	} else {
		gchar* _tmp7_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = g_strdup ("");
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp1_);
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = _tmp7_;
#line 2281 "SearchBoolean.c"
	}
#line 275 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_text_set_text (self, _tmp1_);
#line 276 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp8_ = context;
#line 276 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_text_set_context (self, _tmp8_);
#line 273 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp1_);
#line 273 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 2293 "SearchBoolean.c"
}


SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context) {
#line 273 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_text_construct (TYPE_SEARCH_CONDITION_TEXT, search_type, text, context);
#line 2300 "SearchBoolean.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2320 "SearchBoolean.c"
}


static gboolean search_condition_text_string_match (SearchConditionText* self, const gchar* needle, const gchar* haystack) {
	gboolean result = FALSE;
	SearchConditionTextContext _tmp0_ = 0;
#line 280 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), FALSE);
#line 280 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (_tmp0_) {
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
#line 2339 "SearchBoolean.c"
		{
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = haystack;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = is_string_empty (_tmp2_);
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (!_tmp3_) {
#line 2350 "SearchBoolean.c"
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp4_ = haystack;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp5_ = needle;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp6_ = string_contains (_tmp4_, _tmp5_);
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp1_ = _tmp6_;
#line 2362 "SearchBoolean.c"
			} else {
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp1_ = FALSE;
#line 2366 "SearchBoolean.c"
			}
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 284 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2372 "SearchBoolean.c"
		}
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
#line 2376 "SearchBoolean.c"
		{
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = haystack;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp9_ = is_string_empty (_tmp8_);
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (!_tmp9_) {
#line 2387 "SearchBoolean.c"
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp10_ = haystack;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp11_ = needle;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp7_ = g_strcmp0 (_tmp10_, _tmp11_) == 0;
#line 2396 "SearchBoolean.c"
			} else {
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp7_ = FALSE;
#line 2400 "SearchBoolean.c"
			}
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp7_;
#line 287 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2406 "SearchBoolean.c"
		}
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
#line 2410 "SearchBoolean.c"
		{
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp13_ = haystack;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp14_ = is_string_empty (_tmp13_);
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (!_tmp14_) {
#line 2421 "SearchBoolean.c"
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp15_ = haystack;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp16_ = needle;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp17_ = g_str_has_prefix (_tmp15_, _tmp16_);
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp12_ = _tmp17_;
#line 2433 "SearchBoolean.c"
			} else {
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp12_ = FALSE;
#line 2437 "SearchBoolean.c"
			}
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp12_;
#line 290 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2443 "SearchBoolean.c"
		}
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
#line 2447 "SearchBoolean.c"
		{
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp19_ = haystack;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp20_ = is_string_empty (_tmp19_);
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (!_tmp20_) {
#line 2458 "SearchBoolean.c"
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp21_ = haystack;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp22_ = needle;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp23_ = g_str_has_suffix (_tmp21_, _tmp22_);
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp18_ = _tmp23_;
#line 2470 "SearchBoolean.c"
			} else {
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp18_ = FALSE;
#line 2474 "SearchBoolean.c"
			}
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp18_;
#line 293 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2480 "SearchBoolean.c"
		}
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
#line 2484 "SearchBoolean.c"
		{
			const gchar* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 296 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp24_ = haystack;
#line 296 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp25_ = is_string_empty (_tmp24_);
#line 296 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp25_;
#line 296 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2496 "SearchBoolean.c"
		}
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_SET:
#line 2500 "SearchBoolean.c"
		{
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
#line 299 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp26_ = haystack;
#line 299 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp27_ = is_string_empty (_tmp26_);
#line 299 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = !_tmp27_;
#line 299 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 2512 "SearchBoolean.c"
		}
		default:
#line 281 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		break;
#line 2517 "SearchBoolean.c"
	}
#line 302 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = FALSE;
#line 302 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 2523 "SearchBoolean.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self ? g_object_ref (self) : NULL;
#line 2530 "SearchBoolean.c"
}


static gboolean search_condition_text_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionText * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SearchConditionSearchType _tmp1_ = 0;
	SearchConditionSearchType _tmp2_ = 0;
	gboolean _tmp21_ = FALSE;
	SearchConditionSearchType _tmp22_ = 0;
	SearchConditionSearchType _tmp23_ = 0;
	gboolean _tmp52_ = FALSE;
	SearchConditionSearchType _tmp53_ = 0;
	SearchConditionSearchType _tmp54_ = 0;
	gboolean _tmp75_ = FALSE;
	SearchConditionSearchType _tmp76_ = 0;
	SearchConditionSearchType _tmp77_ = 0;
	gboolean _tmp91_ = FALSE;
	SearchConditionSearchType _tmp92_ = 0;
	SearchConditionSearchType _tmp93_ = 0;
	gboolean _tmp106_ = FALSE;
	SearchConditionTextContext _tmp107_ = 0;
#line 306 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_TEXT, SearchConditionText);
#line 306 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 307 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	ret = FALSE;
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _tmp1_;
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp2_) {
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = TRUE;
#line 2569 "SearchBoolean.c"
	} else {
		SearchConditionSearchType _tmp3_ = 0;
		SearchConditionSearchType _tmp4_ = 0;
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = _tmp3_;
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = SEARCH_CONDITION_SEARCH_TYPE_TITLE == _tmp4_;
#line 2579 "SearchBoolean.c"
	}
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp0_) {
#line 2583 "SearchBoolean.c"
		gchar* _tmp5_ = NULL;
		MediaSource* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gchar* title = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = source;
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = media_source_get_title (_tmp6_);
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp8_ = _tmp7_;
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = NULL != _tmp8_;
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp8_);
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp9_) {
#line 2607 "SearchBoolean.c"
			MediaSource* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = source;
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp11_ = media_source_get_title (_tmp10_);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp12_ = _tmp11_;
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp14_ = _tmp13_;
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp15_ = string_remove_diacritics (_tmp14_);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp5_);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = _tmp15_;
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp14_);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp12_);
#line 2634 "SearchBoolean.c"
		} else {
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp5_);
#line 312 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = NULL;
#line 2640 "SearchBoolean.c"
		}
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp16_ = g_strdup (_tmp5_);
#line 311 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		title = _tmp16_;
#line 313 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp17_ = ret;
#line 313 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp18_ = self->priv->_text;
#line 313 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp19_ = title;
#line 313 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp20_ = search_condition_text_string_match (self, _tmp18_, _tmp19_);
#line 313 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ret = _tmp17_ | _tmp20_;
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (title);
#line 310 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp5_);
#line 2660 "SearchBoolean.c"
	}
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp22_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp23_ = _tmp22_;
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp23_) {
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp21_ = TRUE;
#line 2670 "SearchBoolean.c"
	} else {
		SearchConditionSearchType _tmp24_ = 0;
		SearchConditionSearchType _tmp25_ = 0;
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp24_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp25_ = _tmp24_;
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp21_ = SEARCH_CONDITION_SEARCH_TYPE_TAG == _tmp25_;
#line 2680 "SearchBoolean.c"
	}
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp21_) {
#line 2684 "SearchBoolean.c"
		GeeList* tag_list = NULL;
		TagSourceCollection* _tmp26_ = NULL;
		MediaSource* _tmp27_ = NULL;
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp26_ = tag_global;
#line 318 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp27_ = source;
#line 318 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp28_ = tag_source_collection_fetch_for_source (_tmp26_, _tmp27_);
#line 318 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		tag_list = _tmp28_;
#line 319 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp29_ = tag_list;
#line 319 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (NULL != _tmp29_) {
#line 2702 "SearchBoolean.c"
			gchar* itag = NULL;
			{
				GeeList* _tag_list = NULL;
				GeeList* _tmp30_ = NULL;
				GeeList* _tmp31_ = NULL;
				gint _tag_size = 0;
				GeeList* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tag_index = 0;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp30_ = tag_list;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp31_ = _g_object_ref0 (_tmp30_);
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tag_list = _tmp31_;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp32_ = _tag_list;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp33_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection));
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp34_ = _tmp33_;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tag_size = _tmp34_;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tag_index = -1;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				while (TRUE) {
#line 2731 "SearchBoolean.c"
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					Tag* tag = NULL;
					GeeList* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gpointer _tmp40_ = NULL;
					Tag* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					gboolean _tmp48_ = FALSE;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp35_ = _tag_index;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tag_index = _tmp35_ + 1;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp36_ = _tag_index;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp37_ = _tag_size;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					if (!(_tmp36_ < _tmp37_)) {
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						break;
#line 2759 "SearchBoolean.c"
					}
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp38_ = _tag_list;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp39_ = _tag_index;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp40_ = gee_list_get (_tmp38_, _tmp39_);
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					tag = (Tag*) _tmp40_;
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp41_ = tag;
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp42_ = tag_get_searchable_name (_tmp41_);
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp43_ = _tmp42_;
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_g_free0 (itag);
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					itag = _tmp44_;
#line 322 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_g_free0 (_tmp43_);
#line 323 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp45_ = ret;
#line 323 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp46_ = self->priv->_text;
#line 323 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp47_ = itag;
#line 323 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp48_ = search_condition_text_string_match (self, _tmp46_, _tmp47_);
#line 323 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					ret = _tmp45_ | _tmp48_;
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_g_object_unref0 (tag);
#line 2795 "SearchBoolean.c"
				}
#line 321 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_g_object_unref0 (_tag_list);
#line 2799 "SearchBoolean.c"
			}
#line 319 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (itag);
#line 2803 "SearchBoolean.c"
		} else {
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
#line 326 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp49_ = ret;
#line 326 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp50_ = self->priv->_text;
#line 326 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp51_ = search_condition_text_string_match (self, _tmp50_, NULL);
#line 326 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			ret = _tmp49_ | _tmp51_;
#line 2816 "SearchBoolean.c"
		}
#line 317 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (tag_list);
#line 2820 "SearchBoolean.c"
	}
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp53_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp54_ = _tmp53_;
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp54_) {
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp52_ = TRUE;
#line 2830 "SearchBoolean.c"
	} else {
		SearchConditionSearchType _tmp55_ = 0;
		SearchConditionSearchType _tmp56_ = 0;
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp55_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp56_ = _tmp55_;
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp52_ = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME == _tmp56_;
#line 2840 "SearchBoolean.c"
	}
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp52_) {
#line 2844 "SearchBoolean.c"
		gchar* _tmp57_ = NULL;
		MediaSource* _tmp58_ = NULL;
		Event* _tmp59_ = NULL;
		Event* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		gchar* event_name = NULL;
		gchar* _tmp70_ = NULL;
		gboolean _tmp71_ = FALSE;
		const gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		gboolean _tmp74_ = FALSE;
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp58_ = source;
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp59_ = media_source_get_event (_tmp58_);
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp60_ = _tmp59_;
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp61_ = NULL != _tmp60_;
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (_tmp60_);
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp61_) {
#line 2868 "SearchBoolean.c"
			MediaSource* _tmp62_ = NULL;
			Event* _tmp63_ = NULL;
			Event* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp62_ = source;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp63_ = media_source_get_event (_tmp62_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp64_ = _tmp63_;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp65_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_DATA_OBJECT, DataObject));
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp66_ = _tmp65_;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp67_ = g_utf8_strdown (_tmp66_, (gssize) -1);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp68_ = _tmp67_;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp69_ = string_remove_diacritics (_tmp68_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp57_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp57_ = _tmp69_;
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp68_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp66_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_object_unref0 (_tmp64_);
#line 2903 "SearchBoolean.c"
		} else {
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp57_);
#line 333 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp57_ = NULL;
#line 2909 "SearchBoolean.c"
		}
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp70_ = g_strdup (_tmp57_);
#line 332 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		event_name = _tmp70_;
#line 334 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp71_ = ret;
#line 334 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp72_ = self->priv->_text;
#line 334 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp73_ = event_name;
#line 334 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp74_ = search_condition_text_string_match (self, _tmp72_, _tmp73_);
#line 334 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ret = _tmp71_ | _tmp74_;
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (event_name);
#line 331 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp57_);
#line 2929 "SearchBoolean.c"
	}
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp76_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp77_ = _tmp76_;
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp77_) {
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp75_ = TRUE;
#line 2939 "SearchBoolean.c"
	} else {
		SearchConditionSearchType _tmp78_ = 0;
		SearchConditionSearchType _tmp79_ = 0;
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp78_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp79_ = _tmp78_;
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp75_ = SEARCH_CONDITION_SEARCH_TYPE_COMMENT == _tmp79_;
#line 2949 "SearchBoolean.c"
	}
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp75_) {
#line 2953 "SearchBoolean.c"
		gchar* comment = NULL;
		MediaSource* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp80_ = source;
#line 339 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp81_ = media_source_get_comment (_tmp80_);
#line 339 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		comment = _tmp81_;
#line 340 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp82_ = comment;
#line 340 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (NULL != _tmp82_) {
#line 2968 "SearchBoolean.c"
			gboolean _tmp83_ = FALSE;
			const gchar* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gboolean _tmp90_ = FALSE;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp83_ = ret;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp84_ = self->priv->_text;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp85_ = comment;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp86_ = g_utf8_strdown (_tmp85_, (gssize) -1);
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp87_ = _tmp86_;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp88_ = string_remove_diacritics (_tmp87_);
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp89_ = _tmp88_;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp90_ = search_condition_text_string_match (self, _tmp84_, _tmp89_);
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			ret = _tmp83_ | _tmp90_;
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp89_);
#line 341 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_free0 (_tmp87_);
#line 2999 "SearchBoolean.c"
		}
#line 338 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (comment);
#line 3003 "SearchBoolean.c"
	}
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp92_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp93_ = _tmp92_;
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp93_) {
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp91_ = TRUE;
#line 3013 "SearchBoolean.c"
	} else {
		SearchConditionSearchType _tmp94_ = 0;
		SearchConditionSearchType _tmp95_ = 0;
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp94_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp95_ = _tmp94_;
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp91_ = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME == _tmp95_;
#line 3023 "SearchBoolean.c"
	}
#line 345 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp91_) {
#line 3027 "SearchBoolean.c"
		gboolean _tmp96_ = FALSE;
		const gchar* _tmp97_ = NULL;
		MediaSource* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
		gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		gchar* _tmp103_ = NULL;
		gchar* _tmp104_ = NULL;
		gboolean _tmp105_ = FALSE;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp96_ = ret;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp97_ = self->priv->_text;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp98_ = source;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp99_ = media_source_get_basename (_tmp98_);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp100_ = _tmp99_;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp101_ = g_utf8_strdown (_tmp100_, (gssize) -1);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp102_ = _tmp101_;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp103_ = string_remove_diacritics (_tmp102_);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp104_ = _tmp103_;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp105_ = search_condition_text_string_match (self, _tmp97_, _tmp104_);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ret = _tmp96_ | _tmp105_;
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp104_);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp102_);
#line 346 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_free0 (_tmp100_);
#line 3066 "SearchBoolean.c"
	}
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp107_ = self->priv->_context;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp107_ == SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN) {
#line 3072 "SearchBoolean.c"
		gboolean _tmp108_ = FALSE;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp108_ = ret;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp106_ = !_tmp108_;
#line 3078 "SearchBoolean.c"
	} else {
		gboolean _tmp109_ = FALSE;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp109_ = ret;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp106_ = _tmp109_;
#line 3085 "SearchBoolean.c"
	}
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp106_;
#line 349 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3091 "SearchBoolean.c"
}


const gchar* search_condition_text_get_text (SearchConditionText* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), NULL);
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_text;
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3106 "SearchBoolean.c"
}


static void search_condition_text_set_text (SearchConditionText* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_TEXT (self));
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (self->priv->_text);
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_text = _tmp1_;
#line 3123 "SearchBoolean.c"
}


SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self) {
	SearchConditionTextContext result;
	SearchConditionTextContext _tmp0_ = 0;
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), 0);
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3138 "SearchBoolean.c"
}


static void search_condition_text_set_context (SearchConditionText* self, SearchConditionTextContext value) {
	SearchConditionTextContext _tmp0_ = 0;
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_TEXT (self));
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 271 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_context = _tmp0_;
#line 3150 "SearchBoolean.c"
}


static void search_condition_text_class_init (SearchConditionTextClass * klass) {
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_text_parent_class = g_type_class_peek_parent (klass);
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_text_finalize;
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionTextPrivate));
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_text_real_predicate;
#line 3163 "SearchBoolean.c"
}


static void search_condition_text_instance_init (SearchConditionText * self) {
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_TEXT_GET_PRIVATE (self);
#line 3170 "SearchBoolean.c"
}


static void search_condition_text_finalize (SearchCondition* obj) {
	SearchConditionText * self;
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_TEXT, SearchConditionText);
#line 268 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (self->priv->_text);
#line 202 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_text_parent_class)->finalize (obj);
#line 3182 "SearchBoolean.c"
}


GType search_condition_text_get_type (void) {
	static volatile gsize search_condition_text_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_text_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionText), 0, (GInstanceInitFunc) search_condition_text_instance_init, NULL };
		GType search_condition_text_type_id;
		search_condition_text_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionText", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_text_type_id__volatile, search_condition_text_type_id);
	}
	return search_condition_text_type_id__volatile;
}


gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self) {
	gchar* result = NULL;
#line 360 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 360 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS:
#line 3204 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("IS");
#line 362 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 362 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3213 "SearchBoolean.c"
		}
#line 360 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT:
#line 3217 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 365 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("IS_NOT");
#line 365 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 365 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3226 "SearchBoolean.c"
		}
		default:
		{
#line 368 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:368: unrecognized media search context enumeration " \
"value");
#line 3232 "SearchBoolean.c"
		}
	}
}


SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str) {
	SearchConditionMediaTypeContext result = 0;
	const gchar* _tmp0_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 373 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 373 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "IS") == 0) {
#line 374 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
#line 374 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 3251 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 376 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "IS_NOT") == 0) {
#line 377 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
#line 377 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3262 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 380 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 380 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:380: unrecognized media search context name: %s", _tmp2_);
#line 3269 "SearchBoolean.c"
		}
	}
}


GType search_condition_media_type_context_get_type (void) {
	static volatile gsize search_condition_media_type_context_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_media_type_context_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS", "is"}, {SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT", "is-not"}, {0, NULL, NULL}};
		GType search_condition_media_type_context_type_id;
		search_condition_media_type_context_type_id = g_enum_register_static ("SearchConditionMediaTypeContext", values);
		g_once_init_leave (&search_condition_media_type_context_type_id__volatile, search_condition_media_type_context_type_id);
	}
	return search_condition_media_type_context_type_id__volatile;
}


gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self) {
	gchar* result = NULL;
#line 390 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 390 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
#line 3293 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 392 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("PHOTO_ALL");
#line 392 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 392 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3302 "SearchBoolean.c"
		}
#line 390 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
#line 3306 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 395 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("PHOTO_RAW");
#line 395 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 395 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3315 "SearchBoolean.c"
		}
#line 390 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
#line 3319 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 398 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("VIDEO");
#line 398 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 398 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3328 "SearchBoolean.c"
		}
		default:
		{
#line 401 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:401: unrecognized media search type enumeration val" \
"ue");
#line 3334 "SearchBoolean.c"
		}
	}
}


SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str) {
	SearchConditionMediaTypeMediaType result = 0;
	const gchar* _tmp0_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 406 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 406 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "PHOTO_ALL") == 0) {
#line 407 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL;
#line 407 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 3353 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 409 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "PHOTO_RAW") == 0) {
#line 410 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW;
#line 410 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3364 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 412 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 412 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "VIDEO") == 0) {
#line 413 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO;
#line 413 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3375 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 416 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:416: unrecognized media search type name: %s", _tmp3_);
#line 3382 "SearchBoolean.c"
			}
		}
	}
}


GType search_condition_media_type_media_type_get_type (void) {
	static volatile gsize search_condition_media_type_media_type_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_media_type_media_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL", "photo-all"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW", "photo-raw"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
		GType search_condition_media_type_media_type_type_id;
		search_condition_media_type_media_type_type_id = g_enum_register_static ("SearchConditionMediaTypeMediaType", values);
		g_once_init_leave (&search_condition_media_type_media_type_type_id__volatile, search_condition_media_type_media_type_type_id);
	}
	return search_condition_media_type_media_type_type_id__volatile;
}


SearchConditionMediaType* search_condition_media_type_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type) {
	SearchConditionMediaType* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	SearchConditionMediaTypeContext _tmp1_ = 0;
	SearchConditionMediaTypeMediaType _tmp2_ = 0;
#line 426 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionMediaType*) search_condition_construct (object_type);
#line 427 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 427 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 428 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = context;
#line 428 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_media_type_set_context (self, _tmp1_);
#line 429 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = media_type;
#line 429 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_media_type_set_media_type (self, _tmp2_);
#line 426 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 3422 "SearchBoolean.c"
}


SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type) {
#line 426 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_media_type_construct (TYPE_SEARCH_CONDITION_MEDIA_TYPE, search_type, context, media_type);
#line 3429 "SearchBoolean.c"
}


static gboolean search_condition_media_type_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionMediaType * self;
	gboolean result = FALSE;
	SearchConditionMediaTypeMediaType _tmp0_ = 0;
#line 433 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType);
#line 433 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 436 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_media_type;
#line 436 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (_tmp0_) {
#line 436 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
#line 3447 "SearchBoolean.c"
		{
			MediaSource* _tmp1_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = source;
#line 438 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_PHOTO)) {
#line 3454 "SearchBoolean.c"
				SearchConditionMediaTypeContext _tmp2_ = 0;
#line 439 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp2_ = self->priv->_context;
#line 439 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp2_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
#line 439 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3462 "SearchBoolean.c"
			} else {
				SearchConditionMediaTypeContext _tmp3_ = 0;
#line 441 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = self->priv->_context;
#line 441 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp3_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
#line 441 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3471 "SearchBoolean.c"
			}
		}
#line 436 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
#line 3476 "SearchBoolean.c"
		{
			gboolean _tmp4_ = FALSE;
			MediaSource* _tmp5_ = NULL;
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = source;
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_PHOTO)) {
#line 3484 "SearchBoolean.c"
				MediaSource* _tmp6_ = NULL;
				PhotoFileFormat _tmp7_ = 0;
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp6_ = source;
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp7_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp4_ = _tmp7_ == PHOTO_FILE_FORMAT_RAW;
#line 3493 "SearchBoolean.c"
			} else {
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp4_ = FALSE;
#line 3497 "SearchBoolean.c"
			}
#line 444 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_tmp4_) {
#line 3501 "SearchBoolean.c"
				SearchConditionMediaTypeContext _tmp8_ = 0;
#line 445 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp8_ = self->priv->_context;
#line 445 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp8_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
#line 445 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3509 "SearchBoolean.c"
			} else {
				SearchConditionMediaTypeContext _tmp9_ = 0;
#line 447 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp9_ = self->priv->_context;
#line 447 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp9_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
#line 447 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3518 "SearchBoolean.c"
			}
		}
#line 436 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
#line 3523 "SearchBoolean.c"
		{
			MediaSource* _tmp10_ = NULL;
#line 450 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = source;
#line 450 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_VIDEO_SOURCE)) {
#line 3530 "SearchBoolean.c"
				SearchConditionMediaTypeContext _tmp11_ = 0;
#line 451 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp11_ = self->priv->_context;
#line 451 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp11_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
#line 451 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3538 "SearchBoolean.c"
			} else {
				SearchConditionMediaTypeContext _tmp12_ = 0;
#line 453 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp12_ = self->priv->_context;
#line 453 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp12_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
#line 453 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 3547 "SearchBoolean.c"
			}
		}
		default:
		{
#line 456 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:456: unrecognized media search type enumeration val" \
"ue");
#line 3554 "SearchBoolean.c"
		}
	}
}


SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self) {
	SearchConditionMediaTypeMediaType result;
	SearchConditionMediaTypeMediaType _tmp0_ = 0;
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self), 0);
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_media_type;
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3571 "SearchBoolean.c"
}


static void search_condition_media_type_set_media_type (SearchConditionMediaType* self, SearchConditionMediaTypeMediaType value) {
	SearchConditionMediaTypeMediaType _tmp0_ = 0;
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self));
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 421 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_media_type = _tmp0_;
#line 3583 "SearchBoolean.c"
}


SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self) {
	SearchConditionMediaTypeContext result;
	SearchConditionMediaTypeContext _tmp0_ = 0;
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self), 0);
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3598 "SearchBoolean.c"
}


static void search_condition_media_type_set_context (SearchConditionMediaType* self, SearchConditionMediaTypeContext value) {
	SearchConditionMediaTypeContext _tmp0_ = 0;
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self));
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 424 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_context = _tmp0_;
#line 3610 "SearchBoolean.c"
}


static void search_condition_media_type_class_init (SearchConditionMediaTypeClass * klass) {
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_media_type_parent_class = g_type_class_peek_parent (klass);
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_media_type_finalize;
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionMediaTypePrivate));
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_media_type_real_predicate;
#line 3623 "SearchBoolean.c"
}


static void search_condition_media_type_instance_init (SearchConditionMediaType * self) {
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_MEDIA_TYPE_GET_PRIVATE (self);
#line 3630 "SearchBoolean.c"
}


static void search_condition_media_type_finalize (SearchCondition* obj) {
	SearchConditionMediaType * self;
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType);
#line 354 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_media_type_parent_class)->finalize (obj);
#line 3640 "SearchBoolean.c"
}


GType search_condition_media_type_get_type (void) {
	static volatile gsize search_condition_media_type_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_media_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionMediaTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_media_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionMediaType), 0, (GInstanceInitFunc) search_condition_media_type_instance_init, NULL };
		GType search_condition_media_type_type_id;
		search_condition_media_type_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionMediaType", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_media_type_type_id__volatile, search_condition_media_type_type_id);
	}
	return search_condition_media_type_type_id__volatile;
}


gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self) {
	gchar* result = NULL;
#line 468 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 468 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_FLAGGED_STATE_FLAGGED:
#line 3662 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 470 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("FLAGGED");
#line 470 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 470 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3671 "SearchBoolean.c"
		}
#line 468 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED:
#line 3675 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 473 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("UNFLAGGED");
#line 473 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 473 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3684 "SearchBoolean.c"
		}
		default:
		{
#line 476 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:476: unrecognized flagged search state enumeration " \
"value");
#line 3690 "SearchBoolean.c"
		}
	}
}


SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str) {
	SearchConditionFlaggedState result = 0;
	const gchar* _tmp0_ = NULL;
#line 480 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 481 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 481 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "FLAGGED") == 0) {
#line 482 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_FLAGGED_STATE_FLAGGED;
#line 482 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 3709 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 484 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "UNFLAGGED") == 0) {
#line 485 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED;
#line 485 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3720 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 488 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 488 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:488: unrecognized flagged search state name: %s", _tmp2_);
#line 3727 "SearchBoolean.c"
		}
	}
}


GType search_condition_flagged_state_get_type (void) {
	static volatile gsize search_condition_flagged_state_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_flagged_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_FLAGGED_STATE_FLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_FLAGGED", "flagged"}, {SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED", "unflagged"}, {0, NULL, NULL}};
		GType search_condition_flagged_state_type_id;
		search_condition_flagged_state_type_id = g_enum_register_static ("SearchConditionFlaggedState", values);
		g_once_init_leave (&search_condition_flagged_state_type_id__volatile, search_condition_flagged_state_type_id);
	}
	return search_condition_flagged_state_type_id__volatile;
}


SearchConditionFlagged* search_condition_flagged_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionFlaggedState state) {
	SearchConditionFlagged* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	SearchConditionFlaggedState _tmp1_ = 0;
#line 495 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionFlagged*) search_condition_construct (object_type);
#line 496 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 496 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 497 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = state;
#line 497 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_flagged_set_state (self, _tmp1_);
#line 495 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 3761 "SearchBoolean.c"
}


SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type, SearchConditionFlaggedState state) {
#line 495 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_flagged_construct (TYPE_SEARCH_CONDITION_FLAGGED, search_type, state);
#line 3768 "SearchBoolean.c"
}


static gboolean search_condition_flagged_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionFlagged * self;
	gboolean result = FALSE;
	SearchConditionFlaggedState _tmp0_ = 0;
#line 501 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged);
#line 501 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 502 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_state;
#line 502 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp0_ == SEARCH_CONDITION_FLAGGED_STATE_FLAGGED) {
#line 3784 "SearchBoolean.c"
		MediaSource* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 503 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = source;
#line 503 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_FLAGGABLE, Flaggable));
#line 503 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = _tmp2_;
#line 503 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 3795 "SearchBoolean.c"
	} else {
		SearchConditionFlaggedState _tmp3_ = 0;
#line 504 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = self->priv->_state;
#line 504 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp3_ == SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED) {
#line 3802 "SearchBoolean.c"
			MediaSource* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 505 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = source;
#line 505 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_FLAGGABLE, Flaggable));
#line 505 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = !_tmp5_;
#line 505 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3813 "SearchBoolean.c"
		} else {
#line 507 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:507: unrecognized flagged search state");
#line 3817 "SearchBoolean.c"
		}
	}
}


SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self) {
	SearchConditionFlaggedState result;
	SearchConditionFlaggedState _tmp0_ = 0;
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_FLAGGED (self), 0);
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_state;
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 3834 "SearchBoolean.c"
}


static void search_condition_flagged_set_state (SearchConditionFlagged* self, SearchConditionFlaggedState value) {
	SearchConditionFlaggedState _tmp0_ = 0;
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_FLAGGED (self));
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 493 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_state = _tmp0_;
#line 3846 "SearchBoolean.c"
}


static void search_condition_flagged_class_init (SearchConditionFlaggedClass * klass) {
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_flagged_parent_class = g_type_class_peek_parent (klass);
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_flagged_finalize;
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionFlaggedPrivate));
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_flagged_real_predicate;
#line 3859 "SearchBoolean.c"
}


static void search_condition_flagged_instance_init (SearchConditionFlagged * self) {
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_FLAGGED_GET_PRIVATE (self);
#line 3866 "SearchBoolean.c"
}


static void search_condition_flagged_finalize (SearchCondition* obj) {
	SearchConditionFlagged * self;
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged);
#line 462 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_flagged_parent_class)->finalize (obj);
#line 3876 "SearchBoolean.c"
}


GType search_condition_flagged_get_type (void) {
	static volatile gsize search_condition_flagged_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_flagged_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionFlaggedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_flagged_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionFlagged), 0, (GInstanceInitFunc) search_condition_flagged_instance_init, NULL };
		GType search_condition_flagged_type_id;
		search_condition_flagged_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionFlagged", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_flagged_type_id__volatile, search_condition_flagged_type_id);
	}
	return search_condition_flagged_type_id__volatile;
}


gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self) {
	gchar* result = NULL;
#line 520 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 520 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS:
#line 3898 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 522 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("HAS");
#line 522 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 522 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3907 "SearchBoolean.c"
		}
#line 520 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO:
#line 3911 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 525 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("HAS_NO");
#line 525 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3920 "SearchBoolean.c"
		}
		default:
		{
#line 528 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:528: unrecognized modified search context enumerati" \
"on value");
#line 3926 "SearchBoolean.c"
		}
	}
}


SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str) {
	SearchConditionModifiedContext result = 0;
	const gchar* _tmp0_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 533 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 533 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "HAS") == 0) {
#line 534 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
#line 534 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 3945 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 536 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 536 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "HAS_NO") == 0) {
#line 537 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
#line 537 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3956 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 540 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 540 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:540: unrecognized modified search context name: %s", _tmp2_);
#line 3963 "SearchBoolean.c"
		}
	}
}


GType search_condition_modified_context_get_type (void) {
	static volatile gsize search_condition_modified_context_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_modified_context_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_CONTEXT_HAS, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS", "has"}, {SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO", "has-no"}, {0, NULL, NULL}};
		GType search_condition_modified_context_type_id;
		search_condition_modified_context_type_id = g_enum_register_static ("SearchConditionModifiedContext", values);
		g_once_init_leave (&search_condition_modified_context_type_id__volatile, search_condition_modified_context_type_id);
	}
	return search_condition_modified_context_type_id__volatile;
}


gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self) {
	gchar* result = NULL;
#line 550 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 550 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MODIFIED_STATE_MODIFIED:
#line 3987 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("MODIFIED");
#line 552 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 552 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 3996 "SearchBoolean.c"
		}
#line 550 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES:
#line 4000 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 555 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("INTERNAL_CHANGES");
#line 555 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 555 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4009 "SearchBoolean.c"
		}
#line 550 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES:
#line 4013 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("EXTERNAL_CHANGES");
#line 558 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 558 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4022 "SearchBoolean.c"
		}
		default:
		{
#line 561 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:561: unrecognized modified search state enumeration" \
" value");
#line 4028 "SearchBoolean.c"
		}
	}
}


SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str) {
	SearchConditionModifiedState result = 0;
	const gchar* _tmp0_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 566 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 566 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "MODIFIED") == 0) {
#line 567 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_MODIFIED_STATE_MODIFIED;
#line 567 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4047 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 569 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 569 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "INTERNAL_CHANGES") == 0) {
#line 570 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES;
#line 570 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4058 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 572 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "EXTERNAL_CHANGES") == 0) {
#line 573 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES;
#line 573 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 4069 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 576 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 576 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:576: unrecognized modified search state name: %s", _tmp3_);
#line 4076 "SearchBoolean.c"
			}
		}
	}
}


GType search_condition_modified_state_get_type (void) {
	static volatile gsize search_condition_modified_state_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_modified_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_STATE_MODIFIED, "SEARCH_CONDITION_MODIFIED_STATE_MODIFIED", "modified"}, {SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES", "internal-changes"}, {SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES", "external-changes"}, {0, NULL, NULL}};
		GType search_condition_modified_state_type_id;
		search_condition_modified_state_type_id = g_enum_register_static ("SearchConditionModifiedState", values);
		g_once_init_leave (&search_condition_modified_state_type_id__volatile, search_condition_modified_state_type_id);
	}
	return search_condition_modified_state_type_id__volatile;
}


SearchConditionModified* search_condition_modified_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state) {
	SearchConditionModified* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	SearchConditionModifiedContext _tmp1_ = 0;
	SearchConditionModifiedState _tmp2_ = 0;
#line 586 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionModified*) search_condition_construct (object_type);
#line 587 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 587 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 588 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = context;
#line 588 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_modified_set_context (self, _tmp1_);
#line 589 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = state;
#line 589 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_modified_set_state (self, _tmp2_);
#line 586 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 4116 "SearchBoolean.c"
}


SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state) {
#line 586 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_modified_construct (TYPE_SEARCH_CONDITION_MODIFIED, search_type, context, state);
#line 4123 "SearchBoolean.c"
}


static gboolean search_condition_modified_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionModified * self;
	gboolean result = FALSE;
	Photo* photo = NULL;
	MediaSource* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	gboolean match = FALSE;
	SearchConditionModifiedState _tmp3_ = 0;
	gboolean _tmp15_ = FALSE;
#line 593 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified);
#line 593 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 595 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = source;
#line 595 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO) ? ((Photo*) _tmp0_) : NULL);
#line 595 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	photo = _tmp1_;
#line 596 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = photo;
#line 596 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp2_ == NULL) {
#line 597 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = FALSE;
#line 597 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (photo);
#line 597 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4157 "SearchBoolean.c"
	}
#line 600 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = self->priv->_state;
#line 600 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp3_ == SEARCH_CONDITION_MODIFIED_STATE_MODIFIED) {
#line 4163 "SearchBoolean.c"
		gboolean _tmp4_ = FALSE;
		Photo* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = photo;
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = photo_has_transformations (_tmp5_);
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp6_) {
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = TRUE;
#line 4175 "SearchBoolean.c"
		} else {
			Photo* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = photo;
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = photo_has_editable (_tmp7_);
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = _tmp8_;
#line 4185 "SearchBoolean.c"
		}
#line 601 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		match = _tmp4_;
#line 4189 "SearchBoolean.c"
	} else {
		SearchConditionModifiedState _tmp9_ = 0;
#line 602 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = self->priv->_state;
#line 602 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp9_ == SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES) {
#line 4196 "SearchBoolean.c"
			Photo* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
#line 603 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = photo;
#line 603 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp11_ = photo_has_transformations (_tmp10_);
#line 603 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			match = _tmp11_;
#line 4205 "SearchBoolean.c"
		} else {
			SearchConditionModifiedState _tmp12_ = 0;
#line 604 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp12_ = self->priv->_state;
#line 604 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_tmp12_ == SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES) {
#line 4212 "SearchBoolean.c"
				Photo* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
#line 605 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp13_ = photo;
#line 605 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp14_ = photo_has_editable (_tmp13_);
#line 605 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				match = _tmp14_;
#line 4221 "SearchBoolean.c"
			} else {
#line 607 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:607: unrecognized modified search state");
#line 4225 "SearchBoolean.c"
			}
		}
	}
#line 609 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp15_ = match;
#line 609 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp15_) {
#line 4233 "SearchBoolean.c"
		SearchConditionModifiedContext _tmp16_ = 0;
#line 610 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp16_ = self->priv->_context;
#line 610 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = _tmp16_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
#line 610 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (photo);
#line 610 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4243 "SearchBoolean.c"
	} else {
		SearchConditionModifiedContext _tmp17_ = 0;
#line 612 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp17_ = self->priv->_context;
#line 612 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = _tmp17_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
#line 612 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (photo);
#line 612 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4254 "SearchBoolean.c"
	}
#line 593 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_object_unref0 (photo);
#line 4258 "SearchBoolean.c"
}


SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self) {
	SearchConditionModifiedState result;
	SearchConditionModifiedState _tmp0_ = 0;
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_MODIFIED (self), 0);
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_state;
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 4273 "SearchBoolean.c"
}


static void search_condition_modified_set_state (SearchConditionModified* self, SearchConditionModifiedState value) {
	SearchConditionModifiedState _tmp0_ = 0;
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_MODIFIED (self));
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 581 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_state = _tmp0_;
#line 4285 "SearchBoolean.c"
}


SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self) {
	SearchConditionModifiedContext result;
	SearchConditionModifiedContext _tmp0_ = 0;
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_MODIFIED (self), 0);
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 4300 "SearchBoolean.c"
}


static void search_condition_modified_set_context (SearchConditionModified* self, SearchConditionModifiedContext value) {
	SearchConditionModifiedContext _tmp0_ = 0;
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_MODIFIED (self));
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 584 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_context = _tmp0_;
#line 4312 "SearchBoolean.c"
}


static void search_condition_modified_class_init (SearchConditionModifiedClass * klass) {
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_modified_parent_class = g_type_class_peek_parent (klass);
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_modified_finalize;
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionModifiedPrivate));
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_modified_real_predicate;
#line 4325 "SearchBoolean.c"
}


static void search_condition_modified_instance_init (SearchConditionModified * self) {
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_MODIFIED_GET_PRIVATE (self);
#line 4332 "SearchBoolean.c"
}


static void search_condition_modified_finalize (SearchCondition* obj) {
	SearchConditionModified * self;
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified);
#line 513 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_modified_parent_class)->finalize (obj);
#line 4342 "SearchBoolean.c"
}


GType search_condition_modified_get_type (void) {
	static volatile gsize search_condition_modified_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_modified_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionModifiedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_modified_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionModified), 0, (GInstanceInitFunc) search_condition_modified_instance_init, NULL };
		GType search_condition_modified_type_id;
		search_condition_modified_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionModified", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_modified_type_id__volatile, search_condition_modified_type_id);
	}
	return search_condition_modified_type_id__volatile;
}


gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self) {
	gchar* result = NULL;
#line 625 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 625 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER:
#line 4364 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("AND_HIGHER");
#line 627 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 627 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4373 "SearchBoolean.c"
		}
#line 625 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_RATING_CONTEXT_ONLY:
#line 4377 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("ONLY");
#line 630 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 630 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4386 "SearchBoolean.c"
		}
#line 625 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER:
#line 4390 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("AND_LOWER");
#line 633 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 633 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4399 "SearchBoolean.c"
		}
		default:
		{
#line 636 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:636: unrecognized rating search context enumeration" \
" value");
#line 4405 "SearchBoolean.c"
		}
	}
}


SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str) {
	SearchConditionRatingContext result = 0;
	const gchar* _tmp0_ = NULL;
#line 640 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 641 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 641 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "AND_HIGHER") == 0) {
#line 642 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER;
#line 642 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4424 "SearchBoolean.c"
	} else {
		const gchar* _tmp1_ = NULL;
#line 644 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = str;
#line 644 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp1_, "ONLY") == 0) {
#line 645 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_RATING_CONTEXT_ONLY;
#line 645 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4435 "SearchBoolean.c"
		} else {
			const gchar* _tmp2_ = NULL;
#line 647 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = str;
#line 647 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp2_, "AND_LOWER") == 0) {
#line 648 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER;
#line 648 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 4446 "SearchBoolean.c"
			} else {
				const gchar* _tmp3_ = NULL;
#line 651 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = str;
#line 651 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:651: unrecognized rating search context name: %s", _tmp3_);
#line 4453 "SearchBoolean.c"
			}
		}
	}
}


GType search_condition_rating_context_get_type (void) {
	static volatile gsize search_condition_rating_context_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_rating_context_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER, "SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER", "and-higher"}, {SEARCH_CONDITION_RATING_CONTEXT_ONLY, "SEARCH_CONDITION_RATING_CONTEXT_ONLY", "only"}, {SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER, "SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER", "and-lower"}, {0, NULL, NULL}};
		GType search_condition_rating_context_type_id;
		search_condition_rating_context_type_id = g_enum_register_static ("SearchConditionRatingContext", values);
		g_once_init_leave (&search_condition_rating_context_type_id__volatile, search_condition_rating_context_type_id);
	}
	return search_condition_rating_context_type_id__volatile;
}


SearchConditionRating* search_condition_rating_construct (GType object_type, SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context) {
	SearchConditionRating* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	Rating _tmp1_ = 0;
	SearchConditionRatingContext _tmp2_ = 0;
#line 661 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionRating*) search_condition_construct (object_type);
#line 662 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 662 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 663 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = rating;
#line 663 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_rating_set_rating (self, _tmp1_);
#line 664 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = context;
#line 664 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_rating_set_context (self, _tmp2_);
#line 661 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 4493 "SearchBoolean.c"
}


SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context) {
#line 661 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_rating_construct (TYPE_SEARCH_CONDITION_RATING, search_type, rating, context);
#line 4500 "SearchBoolean.c"
}


static gboolean search_condition_rating_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionRating * self;
	gboolean result = FALSE;
	Rating source_rating = 0;
	MediaSource* _tmp0_ = NULL;
	Rating _tmp1_ = 0;
	SearchConditionRatingContext _tmp2_ = 0;
#line 668 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_RATING, SearchConditionRating);
#line 668 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 669 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = source;
#line 669 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = media_source_get_rating (_tmp0_);
#line 669 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	source_rating = _tmp1_;
#line 670 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = self->priv->_context;
#line 670 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp2_ == SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER) {
#line 4525 "SearchBoolean.c"
		Rating _tmp3_ = 0;
		Rating _tmp4_ = 0;
#line 671 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = source_rating;
#line 671 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = self->priv->_rating;
#line 671 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = _tmp3_ >= _tmp4_;
#line 671 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4536 "SearchBoolean.c"
	} else {
		SearchConditionRatingContext _tmp5_ = 0;
#line 672 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = self->priv->_context;
#line 672 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (_tmp5_ == SEARCH_CONDITION_RATING_CONTEXT_ONLY) {
#line 4543 "SearchBoolean.c"
			Rating _tmp6_ = 0;
			Rating _tmp7_ = 0;
#line 673 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp6_ = source_rating;
#line 673 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = self->priv->_rating;
#line 673 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp6_ == _tmp7_;
#line 673 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4554 "SearchBoolean.c"
		} else {
			SearchConditionRatingContext _tmp8_ = 0;
#line 674 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = self->priv->_context;
#line 674 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_tmp8_ == SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER) {
#line 4561 "SearchBoolean.c"
				Rating _tmp9_ = 0;
				Rating _tmp10_ = 0;
#line 675 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp9_ = source_rating;
#line 675 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp10_ = self->priv->_rating;
#line 675 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = _tmp9_ <= _tmp10_;
#line 675 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 4572 "SearchBoolean.c"
			} else {
#line 677 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				g_error ("SearchBoolean.vala:677: unknown rating search context");
#line 4576 "SearchBoolean.c"
			}
		}
	}
}


Rating search_condition_rating_get_rating (SearchConditionRating* self) {
	Rating result;
	Rating _tmp0_ = 0;
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_RATING (self), 0);
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_rating;
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 4594 "SearchBoolean.c"
}


static void search_condition_rating_set_rating (SearchConditionRating* self, Rating value) {
	Rating _tmp0_ = 0;
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_RATING (self));
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 656 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_rating = _tmp0_;
#line 4606 "SearchBoolean.c"
}


SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self) {
	SearchConditionRatingContext result;
	SearchConditionRatingContext _tmp0_ = 0;
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_RATING (self), 0);
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 4621 "SearchBoolean.c"
}


static void search_condition_rating_set_context (SearchConditionRating* self, SearchConditionRatingContext value) {
	SearchConditionRatingContext _tmp0_ = 0;
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_RATING (self));
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 659 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_context = _tmp0_;
#line 4633 "SearchBoolean.c"
}


static void search_condition_rating_class_init (SearchConditionRatingClass * klass) {
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_rating_parent_class = g_type_class_peek_parent (klass);
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_rating_finalize;
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionRatingPrivate));
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_rating_real_predicate;
#line 4646 "SearchBoolean.c"
}


static void search_condition_rating_instance_init (SearchConditionRating * self) {
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_RATING_GET_PRIVATE (self);
#line 4653 "SearchBoolean.c"
}


static void search_condition_rating_finalize (SearchCondition* obj) {
	SearchConditionRating * self;
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_RATING, SearchConditionRating);
#line 618 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_rating_parent_class)->finalize (obj);
#line 4663 "SearchBoolean.c"
}


GType search_condition_rating_get_type (void) {
	static volatile gsize search_condition_rating_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_rating_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionRatingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_rating_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionRating), 0, (GInstanceInitFunc) search_condition_rating_instance_init, NULL };
		GType search_condition_rating_type_id;
		search_condition_rating_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionRating", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_rating_type_id__volatile, search_condition_rating_type_id);
	}
	return search_condition_rating_type_id__volatile;
}


gchar* search_condition_date_context_to_string (SearchConditionDateContext self) {
	gchar* result = NULL;
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (self) {
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
#line 4685 "SearchBoolean.c"
		{
			gchar* _tmp0_ = NULL;
#line 694 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = g_strdup ("EXACT");
#line 694 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp0_;
#line 694 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4694 "SearchBoolean.c"
		}
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
#line 4698 "SearchBoolean.c"
		{
			gchar* _tmp1_ = NULL;
#line 697 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp1_ = g_strdup ("AFTER");
#line 697 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp1_;
#line 697 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4707 "SearchBoolean.c"
		}
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
#line 4711 "SearchBoolean.c"
		{
			gchar* _tmp2_ = NULL;
#line 700 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp2_ = g_strdup ("BEFORE");
#line 700 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp2_;
#line 700 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4720 "SearchBoolean.c"
		}
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
#line 4724 "SearchBoolean.c"
		{
			gchar* _tmp3_ = NULL;
#line 703 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = g_strdup ("BETWEEN");
#line 703 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp3_;
#line 703 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4733 "SearchBoolean.c"
		}
#line 692 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
#line 4737 "SearchBoolean.c"
		{
			gchar* _tmp4_ = NULL;
#line 706 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp4_ = g_strdup ("IS_NOT_SET");
#line 706 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp4_;
#line 706 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4746 "SearchBoolean.c"
		}
		default:
		{
#line 709 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:709: unrecognized date search context enumeration v" \
"alue");
#line 4752 "SearchBoolean.c"
		}
	}
}


SearchConditionDateContext search_condition_date_context_from_string (const gchar* str) {
	SearchConditionDateContext result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 713 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (str != NULL, 0);
#line 714 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = str;
#line 714 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp0_, "EXACT") == 0) {
#line 715 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_DATE_CONTEXT_EXACT;
#line 715 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4772 "SearchBoolean.c"
	}
#line 717 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = str;
#line 717 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_strcmp0 (_tmp1_, "AFTER") == 0) {
#line 718 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = SEARCH_CONDITION_DATE_CONTEXT_AFTER;
#line 718 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4782 "SearchBoolean.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 720 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = str;
#line 720 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (g_strcmp0 (_tmp2_, "BEFORE") == 0) {
#line 721 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = SEARCH_CONDITION_DATE_CONTEXT_BEFORE;
#line 721 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 4793 "SearchBoolean.c"
		} else {
			const gchar* _tmp3_ = NULL;
#line 723 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp3_ = str;
#line 723 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (g_strcmp0 (_tmp3_, "BETWEEN") == 0) {
#line 724 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				result = SEARCH_CONDITION_DATE_CONTEXT_BETWEEN;
#line 724 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				return result;
#line 4804 "SearchBoolean.c"
			} else {
				const gchar* _tmp4_ = NULL;
#line 726 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp4_ = str;
#line 726 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (g_strcmp0 (_tmp4_, "IS_NOT_SET") == 0) {
#line 727 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					result = SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
#line 727 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					return result;
#line 4815 "SearchBoolean.c"
				} else {
					const gchar* _tmp5_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp5_ = str;
#line 730 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					g_error ("SearchBoolean.vala:730: unrecognized date search context name: %s", _tmp5_);
#line 4822 "SearchBoolean.c"
				}
			}
		}
	}
}


GType search_condition_date_context_get_type (void) {
	static volatile gsize search_condition_date_context_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_date_context_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_CONDITION_DATE_CONTEXT_EXACT, "SEARCH_CONDITION_DATE_CONTEXT_EXACT", "exact"}, {SEARCH_CONDITION_DATE_CONTEXT_AFTER, "SEARCH_CONDITION_DATE_CONTEXT_AFTER", "after"}, {SEARCH_CONDITION_DATE_CONTEXT_BEFORE, "SEARCH_CONDITION_DATE_CONTEXT_BEFORE", "before"}, {SEARCH_CONDITION_DATE_CONTEXT_BETWEEN, "SEARCH_CONDITION_DATE_CONTEXT_BETWEEN", "between"}, {SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET", "is-not-set"}, {0, NULL, NULL}};
		GType search_condition_date_context_type_id;
		search_condition_date_context_type_id = g_enum_register_static ("SearchConditionDateContext", values);
		g_once_init_leave (&search_condition_date_context_type_id__volatile, search_condition_date_context_type_id);
	}
	return search_condition_date_context_type_id__volatile;
}


SearchConditionDate* search_condition_date_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two) {
	SearchConditionDate* self = NULL;
	SearchConditionSearchType _tmp0_ = 0;
	SearchConditionDateContext _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	SearchConditionDateContext _tmp3_ = 0;
#line 741 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (date_one != NULL, NULL);
#line 741 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (date_two != NULL, NULL);
#line 741 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SearchConditionDate*) search_condition_construct (object_type);
#line 743 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = search_type;
#line 743 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), _tmp0_);
#line 744 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = context;
#line 744 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_date_set_context (self, _tmp1_);
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = context;
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp3_ != SEARCH_CONDITION_DATE_CONTEXT_BETWEEN) {
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = TRUE;
#line 4868 "SearchBoolean.c"
	} else {
		GDateTime* _tmp4_ = NULL;
		GDateTime* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = date_two;
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = date_one;
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = g_date_time_compare (_tmp4_, _tmp5_);
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = _tmp6_ >= 1;
#line 4881 "SearchBoolean.c"
	}
#line 745 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp2_) {
#line 4885 "SearchBoolean.c"
		GDateTime* _tmp7_ = NULL;
		GDateTime* _tmp8_ = NULL;
#line 746 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = date_one;
#line 746 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_date_set_date_one (self, _tmp7_);
#line 747 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp8_ = date_two;
#line 747 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_date_set_date_two (self, _tmp8_);
#line 4896 "SearchBoolean.c"
	} else {
		GDateTime* _tmp9_ = NULL;
		GDateTime* _tmp10_ = NULL;
#line 749 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = date_two;
#line 749 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_date_set_date_one (self, _tmp9_);
#line 750 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp10_ = date_one;
#line 750 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search_condition_date_set_date_two (self, _tmp10_);
#line 4908 "SearchBoolean.c"
	}
#line 741 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 4912 "SearchBoolean.c"
}


SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two) {
#line 741 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return search_condition_date_construct (TYPE_SEARCH_CONDITION_DATE, search_type, context, date_one, date_two);
#line 4919 "SearchBoolean.c"
}


static gboolean search_condition_date_real_predicate (SearchCondition* base, MediaSource* source) {
	SearchConditionDate * self;
	gboolean result = FALSE;
	time_t exposure_time = 0;
	MediaSource* _tmp0_ = NULL;
	time_t _tmp1_ = 0;
	time_t _tmp2_ = 0;
	GDateTime* dt = NULL;
	time_t _tmp4_ = 0;
	GDateTime* _tmp5_ = NULL;
	SearchConditionDateContext _tmp6_ = 0;
#line 756 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_DATE, SearchConditionDate);
#line 756 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 757 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = source;
#line 757 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = media_source_get_exposure_time (_tmp0_);
#line 757 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	exposure_time = _tmp1_;
#line 758 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = exposure_time;
#line 758 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp2_ == ((time_t) 0)) {
#line 4948 "SearchBoolean.c"
		SearchConditionDateContext _tmp3_ = 0;
#line 759 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = self->priv->_context;
#line 759 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = _tmp3_ == SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
#line 759 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 4956 "SearchBoolean.c"
	}
#line 761 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = exposure_time;
#line 761 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp5_ = g_date_time_new_from_unix_local ((gint64) _tmp4_);
#line 761 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	dt = _tmp5_;
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp6_ = self->priv->_context;
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	switch (_tmp6_) {
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
#line 4970 "SearchBoolean.c"
		{
			GDateTime* second = NULL;
			GDateTime* _tmp7_ = NULL;
			GDateTime* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			GDateTime* _tmp10_ = NULL;
			GDateTime* _tmp11_ = NULL;
			gint _tmp12_ = 0;
#line 764 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = self->priv->_date_one;
#line 764 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = g_date_time_add_days (_tmp7_, 1);
#line 764 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			second = _tmp8_;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp10_ = dt;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp11_ = self->priv->_date_one;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp12_ = g_date_time_compare (_tmp10_, _tmp11_);
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_tmp12_ >= 0) {
#line 4993 "SearchBoolean.c"
				GDateTime* _tmp13_ = NULL;
				GDateTime* _tmp14_ = NULL;
				gint _tmp15_ = 0;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp13_ = dt;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp14_ = second;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp15_ = g_date_time_compare (_tmp13_, _tmp14_);
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp9_ = _tmp15_ < 0;
#line 5005 "SearchBoolean.c"
			} else {
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp9_ = FALSE;
#line 5009 "SearchBoolean.c"
			}
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp9_;
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (second);
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (dt);
#line 765 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 5019 "SearchBoolean.c"
		}
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
#line 5023 "SearchBoolean.c"
		{
			GDateTime* _tmp16_ = NULL;
			GDateTime* _tmp17_ = NULL;
			gint _tmp18_ = 0;
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp16_ = dt;
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp17_ = self->priv->_date_one;
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp18_ = g_date_time_compare (_tmp16_, _tmp17_);
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp18_ >= 0;
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (dt);
#line 768 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 5040 "SearchBoolean.c"
		}
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
#line 5044 "SearchBoolean.c"
		{
			GDateTime* _tmp19_ = NULL;
			GDateTime* _tmp20_ = NULL;
			gint _tmp21_ = 0;
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp19_ = dt;
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp20_ = self->priv->_date_one;
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp21_ = g_date_time_compare (_tmp19_, _tmp20_);
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp21_ <= 0;
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (dt);
#line 771 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 5061 "SearchBoolean.c"
		}
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
#line 5065 "SearchBoolean.c"
		{
			GDateTime* second = NULL;
			GDateTime* _tmp22_ = NULL;
			GDateTime* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			GDateTime* _tmp25_ = NULL;
			GDateTime* _tmp26_ = NULL;
			gint _tmp27_ = 0;
#line 774 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp22_ = self->priv->_date_two;
#line 774 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp23_ = g_date_time_add_days (_tmp22_, 1);
#line 774 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			second = _tmp23_;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp25_ = dt;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp26_ = self->priv->_date_one;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp27_ = g_date_time_compare (_tmp25_, _tmp26_);
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_tmp27_ >= 0) {
#line 5088 "SearchBoolean.c"
				GDateTime* _tmp28_ = NULL;
				GDateTime* _tmp29_ = NULL;
				gint _tmp30_ = 0;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp28_ = dt;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp29_ = second;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp30_ = g_date_time_compare (_tmp28_, _tmp29_);
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp24_ = _tmp30_ < 0;
#line 5100 "SearchBoolean.c"
			} else {
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp24_ = FALSE;
#line 5104 "SearchBoolean.c"
			}
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = _tmp24_;
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (second);
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (dt);
#line 775 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 5114 "SearchBoolean.c"
		}
#line 762 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
#line 5118 "SearchBoolean.c"
		{
#line 778 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			result = FALSE;
#line 778 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_date_time_unref0 (dt);
#line 778 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return result;
#line 5126 "SearchBoolean.c"
		}
		default:
		{
#line 781 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_error ("SearchBoolean.vala:781: unrecognized date search context enumeration v" \
"alue");
#line 5132 "SearchBoolean.c"
		}
	}
#line 756 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_date_time_unref0 (dt);
#line 5137 "SearchBoolean.c"
}


GDateTime* search_condition_date_get_date_one (SearchConditionDate* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), NULL);
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_date_one;
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5152 "SearchBoolean.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 5159 "SearchBoolean.c"
}


static void search_condition_date_set_date_one (SearchConditionDate* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_date_time_unref0 (self->priv->_date_one);
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_date_one = _tmp1_;
#line 5176 "SearchBoolean.c"
}


GDateTime* search_condition_date_get_date_two (SearchConditionDate* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), NULL);
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_date_two;
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5191 "SearchBoolean.c"
}


static void search_condition_date_set_date_two (SearchConditionDate* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_date_time_unref0 (self->priv->_date_two);
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_date_two = _tmp1_;
#line 5208 "SearchBoolean.c"
}


SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self) {
	SearchConditionDateContext result;
	SearchConditionDateContext _tmp0_ = 0;
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), 0);
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->_context;
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5223 "SearchBoolean.c"
}


static void search_condition_date_set_context (SearchConditionDate* self, SearchConditionDateContext value) {
	SearchConditionDateContext _tmp0_ = 0;
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = value;
#line 739 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->_context = _tmp0_;
#line 5235 "SearchBoolean.c"
}


static void search_condition_date_class_init (SearchConditionDateClass * klass) {
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search_condition_date_parent_class = g_type_class_peek_parent (klass);
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->finalize = search_condition_date_finalize;
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SearchConditionDatePrivate));
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SearchConditionClass *) klass)->predicate = search_condition_date_real_predicate;
#line 5248 "SearchBoolean.c"
}


static void search_condition_date_instance_init (SearchConditionDate * self) {
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SEARCH_CONDITION_DATE_GET_PRIVATE (self);
#line 5255 "SearchBoolean.c"
}


static void search_condition_date_finalize (SearchCondition* obj) {
	SearchConditionDate * self;
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_DATE, SearchConditionDate);
#line 735 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_date_time_unref0 (self->priv->_date_one);
#line 736 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_date_time_unref0 (self->priv->_date_two);
#line 683 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	SEARCH_CONDITION_CLASS (search_condition_date_parent_class)->finalize (obj);
#line 5269 "SearchBoolean.c"
}


GType search_condition_date_get_type (void) {
	static volatile gsize search_condition_date_type_id__volatile = 0;
	if (g_once_init_enter (&search_condition_date_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchConditionDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionDate), 0, (GInstanceInitFunc) search_condition_date_instance_init, NULL };
		GType search_condition_date_type_id;
		search_condition_date_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionDate", &g_define_type_info, 0);
		g_once_init_leave (&search_condition_date_type_id__volatile, search_condition_date_type_id);
	}
	return search_condition_date_type_id__volatile;
}


static gpointer _saved_search_row_ref0 (gpointer self) {
#line 797 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self ? saved_search_row_ref (self) : NULL;
#line 5288 "SearchBoolean.c"
}


SavedSearch* saved_search_construct (GType object_type, SavedSearchRow* row, gint64 object_id) {
	SavedSearch * self = NULL;
	gint64 _tmp0_ = 0LL;
	SavedSearchRow* _tmp1_ = NULL;
	SavedSearchRow* _tmp2_ = NULL;
#line 794 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_ROW (row), NULL);
#line 795 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = object_id;
#line 795 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SavedSearch*) data_source_construct (object_type, _tmp0_);
#line 797 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = row;
#line 797 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _saved_search_row_ref0 (_tmp1_);
#line 797 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_row_unref0 (self->priv->row);
#line 797 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->row = _tmp2_;
#line 794 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 5313 "SearchBoolean.c"
}


SavedSearch* saved_search_new (SavedSearchRow* row, gint64 object_id) {
#line 794 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return saved_search_construct (TYPE_SAVED_SEARCH, row, object_id);
#line 5320 "SearchBoolean.c"
}


static gchar* saved_search_real_get_name (DataObject* base) {
	SavedSearch * self;
	gchar* result = NULL;
	SavedSearchRow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 800 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
#line 801 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->row;
#line 801 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_->name;
#line 801 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 801 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp2_;
#line 801 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5342 "SearchBoolean.c"
}


static gchar* saved_search_real_to_string (DataObject* base) {
	SavedSearch * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 804 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_;
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = g_strconcat ("SavedSearch ", _tmp1_, NULL);
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _tmp2_;
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp1_);
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp3_;
#line 805 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5369 "SearchBoolean.c"
}


static gchar* saved_search_real_get_typename (DataSource* base) {
	SavedSearch * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 808 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
#line 809 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = g_strdup (SAVED_SEARCH_TYPENAME);
#line 809 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp0_;
#line 809 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5385 "SearchBoolean.c"
}


void saved_search_get_saved_search_id (SavedSearch* self, SavedSearchID* result) {
	SavedSearchRow* _tmp0_ = NULL;
	SavedSearchID _tmp1_ = {0};
#line 812 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH (self));
#line 813 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->row;
#line 813 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_->search_id;
#line 813 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	*result = _tmp1_;
#line 813 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return;
#line 5402 "SearchBoolean.c"
}


static gint64 saved_search_real_get_instance_id (DataSource* base) {
	SavedSearch * self;
	gint64 result = 0LL;
	SavedSearchID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
#line 816 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
#line 817 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_get_saved_search_id (self, &_tmp0_);
#line 817 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_.id;
#line 817 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp1_;
#line 817 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5421 "SearchBoolean.c"
}


gint saved_search_compare_names (void* a, void* b) {
	gint result = 0;
	SavedSearch* asearch = NULL;
	void* _tmp0_ = NULL;
	SavedSearch* bsearch = NULL;
	void* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 821 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = a;
#line 821 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	asearch = (SavedSearch*) _tmp0_;
#line 822 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = b;
#line 822 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	bsearch = (SavedSearch*) _tmp1_;
#line 824 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (asearch, TYPE_DATA_OBJECT, DataObject));
#line 824 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (bsearch, TYPE_DATA_OBJECT, DataObject));
#line 824 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = string_collated_compare (_tmp2_, _tmp3_);
#line 824 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp4_;
#line 824 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5452 "SearchBoolean.c"
}


gboolean saved_search_predicate (SavedSearch* self, MediaSource* source) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SavedSearchRow* _tmp1_ = NULL;
	SearchOperator _tmp2_ = 0;
#line 827 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH (self), FALSE);
#line 827 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = self->priv->row;
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _tmp1_->operator;
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (SEARCH_OPERATOR_ALL == _tmp2_) {
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = TRUE;
#line 5474 "SearchBoolean.c"
	} else {
		SavedSearchRow* _tmp3_ = NULL;
		SearchOperator _tmp4_ = 0;
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = self->priv->row;
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = _tmp3_->operator;
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = SEARCH_OPERATOR_NONE == _tmp4_;
#line 5484 "SearchBoolean.c"
	}
#line 829 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp0_) {
#line 830 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ret = TRUE;
#line 5490 "SearchBoolean.c"
	} else {
#line 832 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ret = FALSE;
#line 5494 "SearchBoolean.c"
	}
	{
		GeeList* _c_list = NULL;
		SavedSearchRow* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _c_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _c_index = 0;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = self->priv->row;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = _tmp5_->conditions;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_c_list = _tmp7_;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp8_ = _c_list;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp10_ = _tmp9_;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_c_size = _tmp10_;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_c_index = -1;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		while (TRUE) {
#line 5526 "SearchBoolean.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			SearchCondition* c = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			SavedSearchRow* _tmp17_ = NULL;
			SearchOperator _tmp18_ = 0;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp11_ = _c_index;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_c_index = _tmp11_ + 1;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp12_ = _c_index;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp13_ = _c_size;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				break;
#line 5548 "SearchBoolean.c"
			}
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp14_ = _c_list;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp15_ = _c_index;
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			c = (SearchCondition*) _tmp16_;
#line 835 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp17_ = self->priv->row;
#line 835 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp18_ = _tmp17_->operator;
#line 835 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (SEARCH_OPERATOR_ALL == _tmp18_) {
#line 5564 "SearchBoolean.c"
				gboolean _tmp19_ = FALSE;
				SearchCondition* _tmp20_ = NULL;
				MediaSource* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
#line 836 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp19_ = ret;
#line 836 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp20_ = c;
#line 836 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp21_ = source;
#line 836 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp22_ = search_condition_predicate (_tmp20_, _tmp21_);
#line 836 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				ret = _tmp19_ & _tmp22_;
#line 5579 "SearchBoolean.c"
			} else {
				SavedSearchRow* _tmp23_ = NULL;
				SearchOperator _tmp24_ = 0;
#line 837 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp23_ = self->priv->row;
#line 837 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp24_ = _tmp23_->operator;
#line 837 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (SEARCH_OPERATOR_ANY == _tmp24_) {
#line 5589 "SearchBoolean.c"
					gboolean _tmp25_ = FALSE;
					SearchCondition* _tmp26_ = NULL;
					MediaSource* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
#line 838 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp25_ = ret;
#line 838 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp26_ = c;
#line 838 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp27_ = source;
#line 838 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp28_ = search_condition_predicate (_tmp26_, _tmp27_);
#line 838 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					ret = _tmp25_ | _tmp28_;
#line 5604 "SearchBoolean.c"
				} else {
					SavedSearchRow* _tmp29_ = NULL;
					SearchOperator _tmp30_ = 0;
#line 839 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp29_ = self->priv->row;
#line 839 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp30_ = _tmp29_->operator;
#line 839 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					if (SEARCH_OPERATOR_NONE == _tmp30_) {
#line 5614 "SearchBoolean.c"
						gboolean _tmp31_ = FALSE;
						SearchCondition* _tmp32_ = NULL;
						MediaSource* _tmp33_ = NULL;
						gboolean _tmp34_ = FALSE;
#line 840 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp31_ = ret;
#line 840 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp32_ = c;
#line 840 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp33_ = source;
#line 840 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						_tmp34_ = search_condition_predicate (_tmp32_, _tmp33_);
#line 840 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
						ret = _tmp31_ & (!_tmp34_);
#line 5629 "SearchBoolean.c"
					}
				}
			}
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_search_condition_unref0 (c);
#line 5635 "SearchBoolean.c"
		}
#line 834 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (_c_list);
#line 5639 "SearchBoolean.c"
	}
#line 842 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = ret;
#line 842 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5645 "SearchBoolean.c"
}


void saved_search_reconstitute (SavedSearch* self) {
	SavedSearchTable* _tmp8_ = NULL;
	SavedSearchTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH (self));
#line 5657 "SearchBoolean.c"
	{
		SavedSearchID _tmp0_ = {0};
		SavedSearchDBTable* _tmp1_ = NULL;
		SavedSearchDBTable* _tmp2_ = NULL;
		SavedSearchRow* _tmp3_ = NULL;
		SavedSearchID _tmp4_ = {0};
		SavedSearchID _tmp5_ = {0};
		SavedSearchRow* _tmp6_ = NULL;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = saved_search_db_table_get_instance ();
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = _tmp1_;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = self->priv->row;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_db_table_create_from_row (_tmp2_, _tmp3_, &_tmp4_, &_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = _tmp4_;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_database_table_unref0 (_tmp2_);
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = _tmp5_;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5684 "SearchBoolean.c"
				goto __catch76_database_error;
			}
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_clear_error (&_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return;
#line 5693 "SearchBoolean.c"
		}
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = self->priv->row;
#line 847 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_->search_id = _tmp0_;
#line 5699 "SearchBoolean.c"
	}
	goto __finally76;
	__catch76_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		err = _inner_error_;
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_inner_error_ = NULL;
#line 849 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = err;
#line 849 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		app_window_database_error (_tmp7_);
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_error_free0 (err);
#line 5716 "SearchBoolean.c"
	}
	__finally76:
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_clear_error (&_inner_error_);
#line 846 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return;
#line 5727 "SearchBoolean.c"
	}
#line 852 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp8_ = saved_search_table_get_instance ();
#line 852 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp9_ = _tmp8_;
#line 852 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_add_to_map (_tmp9_, self);
#line 852 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_table_unref0 (_tmp9_);
#line 853 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 853 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp11_ = _tmp10_;
#line 853 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_debug ("SearchBoolean.vala:853: Reconstituted %s", _tmp11_);
#line 853 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp11_);
#line 5745 "SearchBoolean.c"
}


gboolean saved_search_rename (SavedSearch* self, const gchar* new_name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	SavedSearchTable* _tmp2_ = NULL;
	SavedSearchTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	SavedSearchTable* _tmp13_ = NULL;
	SavedSearchTable* _tmp14_ = NULL;
	SavedSearchRow* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	SavedSearchTable* _tmp18_ = NULL;
	SavedSearchTable* _tmp19_ = NULL;
	LibraryWindow* _tmp20_ = NULL;
	LibraryWindow* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH (self), FALSE);
#line 857 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (new_name != NULL, FALSE);
#line 858 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = new_name;
#line 858 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 858 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp1_) {
#line 859 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = FALSE;
#line 859 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 5782 "SearchBoolean.c"
	}
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = saved_search_table_get_instance ();
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _tmp2_;
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = new_name;
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp5_ = saved_search_table_exists (_tmp3_, _tmp4_);
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp6_ = _tmp5_;
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_table_unref0 (_tmp3_);
#line 861 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp6_) {
#line 862 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = FALSE;
#line 862 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 5802 "SearchBoolean.c"
	}
	{
		SavedSearchDBTable* _tmp7_ = NULL;
		SavedSearchDBTable* _tmp8_ = NULL;
		SavedSearchRow* _tmp9_ = NULL;
		SavedSearchID _tmp10_ = {0};
		const gchar* _tmp11_ = NULL;
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = saved_search_db_table_get_instance ();
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp8_ = _tmp7_;
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = self->priv->row;
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp10_ = _tmp9_->search_id;
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp11_ = new_name;
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_db_table_rename (_tmp8_, &_tmp10_, _tmp11_, &_inner_error_);
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_database_table_unref0 (_tmp8_);
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5828 "SearchBoolean.c"
				goto __catch77_database_error;
			}
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_clear_error (&_inner_error_);
#line 865 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return FALSE;
#line 5837 "SearchBoolean.c"
		}
	}
	goto __finally77;
	__catch77_database_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		err = _inner_error_;
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_inner_error_ = NULL;
#line 867 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp12_ = err;
#line 867 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		app_window_database_error (_tmp12_);
#line 868 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		result = FALSE;
#line 868 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_error_free0 (err);
#line 868 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return result;
#line 5859 "SearchBoolean.c"
	}
	__finally77:
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_clear_error (&_inner_error_);
#line 864 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return FALSE;
#line 5870 "SearchBoolean.c"
	}
#line 871 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp13_ = saved_search_table_get_instance ();
#line 871 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp14_ = _tmp13_;
#line 871 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_remove_from_map (_tmp14_, self);
#line 871 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_table_unref0 (_tmp14_);
#line 872 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp15_ = self->priv->row;
#line 872 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp16_ = new_name;
#line 872 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 872 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp15_->name);
#line 872 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp15_->name = _tmp17_;
#line 873 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp18_ = saved_search_table_get_instance ();
#line 873 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp19_ = _tmp18_;
#line 873 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_add_to_map (_tmp19_, self);
#line 873 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_table_unref0 (_tmp19_);
#line 875 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp20_ = library_window_get_app ();
#line 875 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp21_ = _tmp20_;
#line 875 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	library_window_switch_to_saved_search (_tmp21_, self);
#line 875 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_object_unref0 (_tmp21_);
#line 876 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = TRUE;
#line 876 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5910 "SearchBoolean.c"
}


GeeList* saved_search_get_conditions (SavedSearch* self) {
	GeeList* result = NULL;
	SavedSearchRow* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH (self), NULL);
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->row;
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_->conditions;
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = gee_list_get_read_only_view (_tmp1_);
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _tmp2_;
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp3_;
#line 880 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5934 "SearchBoolean.c"
}


SearchOperator saved_search_get_operator (SavedSearch* self) {
	SearchOperator result = 0;
	SavedSearchRow* _tmp0_ = NULL;
	SearchOperator _tmp1_ = 0;
#line 883 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH (self), 0);
#line 884 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->row;
#line 884 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = _tmp0_->operator;
#line 884 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp1_;
#line 884 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 5952 "SearchBoolean.c"
}


static void saved_search_class_init (SavedSearchClass * klass) {
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_parent_class = g_type_class_peek_parent (klass);
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SavedSearchPrivate));
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((DataObjectClass *) klass)->get_name = saved_search_real_get_name;
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((DataObjectClass *) klass)->to_string = saved_search_real_to_string;
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((DataSourceClass *) klass)->get_typename = saved_search_real_get_typename;
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((DataSourceClass *) klass)->get_instance_id = saved_search_real_get_instance_id;
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	G_OBJECT_CLASS (klass)->finalize = saved_search_finalize;
#line 5971 "SearchBoolean.c"
}


static void saved_search_instance_init (SavedSearch * self) {
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SAVED_SEARCH_GET_PRIVATE (self);
#line 5978 "SearchBoolean.c"
}


static void saved_search_finalize (GObject* obj) {
	SavedSearch * self;
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH, SavedSearch);
#line 792 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_saved_search_row_unref0 (self->priv->row);
#line 788 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	G_OBJECT_CLASS (saved_search_parent_class)->finalize (obj);
#line 5990 "SearchBoolean.c"
}


GType saved_search_get_type (void) {
	static volatile gsize saved_search_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearch), 0, (GInstanceInitFunc) saved_search_instance_init, NULL };
		GType saved_search_type_id;
		saved_search_type_id = g_type_register_static (TYPE_DATA_SOURCE, "SavedSearch", &g_define_type_info, 0);
		g_once_init_leave (&saved_search_type_id__volatile, saved_search_type_id);
	}
	return saved_search_type_id__volatile;
}


static SavedSearchTable* saved_search_table_construct (GType object_type) {
	SavedSearchTable* self = NULL;
	GError * _inner_error_ = NULL;
#line 897 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = (SavedSearchTable*) g_type_create_instance (object_type);
#line 6011 "SearchBoolean.c"
	{
		GeeList* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_ = NULL;
		SavedSearchDBTable* _tmp2_ = NULL;
		GeeList* _tmp3_ = NULL;
		GeeList* _tmp4_ = NULL;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = saved_search_db_table_get_instance ();
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = _tmp1_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = saved_search_db_table_get_all_rows (_tmp2_, &_inner_error_);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = _tmp3_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_database_table_unref0 (_tmp2_);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = _tmp4_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 6034 "SearchBoolean.c"
				goto __catch78_database_error;
			}
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_clear_error (&_inner_error_);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return NULL;
#line 6043 "SearchBoolean.c"
		}
		{
			GeeList* _row_list = NULL;
			GeeList* _tmp5_ = NULL;
			gint _row_size = 0;
			GeeList* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _row_index = 0;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp5_ = _tmp0_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = NULL;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_row_list = _tmp5_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp6_ = _row_list;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp8_ = _tmp7_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_row_size = _tmp8_;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_row_index = -1;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			while (TRUE) {
#line 6071 "SearchBoolean.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				SavedSearchRow* row = NULL;
				GeeList* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gpointer _tmp14_ = NULL;
				SavedSearchRow* _tmp15_ = NULL;
				SavedSearch* _tmp16_ = NULL;
				SavedSearch* _tmp17_ = NULL;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp9_ = _row_index;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_row_index = _tmp9_ + 1;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp10_ = _row_index;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp11_ = _row_size;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (!(_tmp10_ < _tmp11_)) {
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					break;
#line 6094 "SearchBoolean.c"
				}
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp12_ = _row_list;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp13_ = _row_index;
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				row = (SavedSearchRow*) _tmp14_;
#line 901 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp15_ = row;
#line 901 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp16_ = saved_search_new (_tmp15_, DATA_OBJECT_INVALID_OBJECT_ID);
#line 901 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp17_ = _tmp16_;
#line 901 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				saved_search_table_add_to_map (self, _tmp17_);
#line 901 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_g_object_unref0 (_tmp17_);
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_saved_search_row_unref0 (row);
#line 6116 "SearchBoolean.c"
			}
#line 900 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_object_unref0 (_row_list);
#line 6120 "SearchBoolean.c"
		}
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (_tmp0_);
#line 6124 "SearchBoolean.c"
	}
	goto __finally78;
	__catch78_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_ = NULL;
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		err = _inner_error_;
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_inner_error_ = NULL;
#line 903 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp18_ = err;
#line 903 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		app_window_database_error (_tmp18_);
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_error_free0 (err);
#line 6141 "SearchBoolean.c"
	}
	__finally78:
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_clear_error (&_inner_error_);
#line 899 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return NULL;
#line 6152 "SearchBoolean.c"
	}
#line 897 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self;
#line 6156 "SearchBoolean.c"
}


static SavedSearchTable* saved_search_table_new (void) {
#line 897 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return saved_search_table_construct (TYPE_SAVED_SEARCH_TABLE);
#line 6163 "SearchBoolean.c"
}


static gpointer _saved_search_table_ref0 (gpointer self) {
#line 912 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return self ? saved_search_table_ref (self) : NULL;
#line 6170 "SearchBoolean.c"
}


SavedSearchTable* saved_search_table_get_instance (void) {
	SavedSearchTable* result = NULL;
	SavedSearchTable* _tmp0_ = NULL;
	SavedSearchTable* _tmp2_ = NULL;
	SavedSearchTable* _tmp3_ = NULL;
#line 909 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = saved_search_table_instance;
#line 909 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (_tmp0_ == NULL) {
#line 6183 "SearchBoolean.c"
		SavedSearchTable* _tmp1_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = saved_search_table_new ();
#line 910 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_saved_search_table_unref0 (saved_search_table_instance);
#line 910 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_table_instance = _tmp1_;
#line 6191 "SearchBoolean.c"
	}
#line 912 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = saved_search_table_instance;
#line 912 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _saved_search_table_ref0 (_tmp2_);
#line 912 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp3_;
#line 912 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6201 "SearchBoolean.c"
}


GeeCollection* saved_search_table_get_all (SavedSearchTable* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
#line 916 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 916 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 916 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _tmp1_;
#line 916 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp2_;
#line 916 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6222 "SearchBoolean.c"
}


SavedSearch* saved_search_table_create (SavedSearchTable* self, const gchar* name, SearchOperator operator, GeeArrayList* conditions) {
	SavedSearch* result = NULL;
	SavedSearch* search = NULL;
	SavedSearch* _tmp10_ = NULL;
	LibraryWindow* _tmp11_ = NULL;
	LibraryWindow* _tmp12_ = NULL;
	SavedSearch* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 921 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
#line 921 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 921 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (GEE_IS_ARRAY_LIST (conditions), NULL);
#line 923 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	search = NULL;
#line 6242 "SearchBoolean.c"
	{
		SavedSearchRow* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_ = NULL;
		SavedSearchDBTable* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		SearchOperator _tmp4_ = 0;
		GeeArrayList* _tmp5_ = NULL;
		SavedSearchRow* _tmp6_ = NULL;
		SavedSearchRow* _tmp7_ = NULL;
		SavedSearch* _tmp8_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = saved_search_db_table_get_instance ();
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = _tmp1_;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp3_ = name;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = operator;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp5_ = conditions;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp6_ = saved_search_db_table_add (_tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp7_ = _tmp6_;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_database_table_unref0 (_tmp2_);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = _tmp7_;
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 6275 "SearchBoolean.c"
				goto __catch79_database_error;
			}
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_g_object_unref0 (search);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_clear_error (&_inner_error_);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return NULL;
#line 6286 "SearchBoolean.c"
		}
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp8_ = saved_search_new (_tmp0_, DATA_OBJECT_INVALID_OBJECT_ID);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (search);
#line 926 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		search = _tmp8_;
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_saved_search_row_unref0 (_tmp0_);
#line 6296 "SearchBoolean.c"
	}
	goto __finally79;
	__catch79_database_error:
	{
		GError* err = NULL;
		GError* _tmp9_ = NULL;
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		err = _inner_error_;
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_inner_error_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp9_ = err;
#line 928 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		app_window_database_error (_tmp9_);
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_error_free0 (err);
#line 6313 "SearchBoolean.c"
	}
	__finally79:
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_object_unref0 (search);
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_clear_error (&_inner_error_);
#line 925 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return NULL;
#line 6326 "SearchBoolean.c"
	}
#line 932 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp10_ = search;
#line 932 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_add_to_map (self, _tmp10_);
#line 933 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp11_ = library_window_get_app ();
#line 933 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp12_ = _tmp11_;
#line 933 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp13_ = search;
#line 933 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	library_window_switch_to_saved_search (_tmp12_, _tmp13_);
#line 933 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_object_unref0 (_tmp12_);
#line 934 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = search;
#line 934 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6346 "SearchBoolean.c"
}


void saved_search_table_remove (SavedSearchTable* self, SavedSearch* search) {
	SavedSearch* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
#line 938 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH (search));
#line 6357 "SearchBoolean.c"
	{
		SavedSearchDBTable* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_ = NULL;
		SavedSearch* _tmp2_ = NULL;
		SavedSearchID _tmp3_ = {0};
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp0_ = saved_search_db_table_get_instance ();
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp1_ = _tmp0_;
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp2_ = search;
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_get_saved_search_id (_tmp2_, &_tmp3_);
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_db_table_remove (_tmp1_, &_tmp3_, &_inner_error_);
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_database_table_unref0 (_tmp1_);
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 6379 "SearchBoolean.c"
				goto __catch80_database_error;
			}
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			g_clear_error (&_inner_error_);
#line 940 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return;
#line 6388 "SearchBoolean.c"
		}
	}
	goto __finally80;
	__catch80_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		err = _inner_error_;
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_inner_error_ = NULL;
#line 942 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_tmp4_ = err;
#line 942 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		app_window_database_error (_tmp4_);
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		_g_error_free0 (err);
#line 6406 "SearchBoolean.c"
	}
	__finally80:
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_clear_error (&_inner_error_);
#line 939 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return;
#line 6417 "SearchBoolean.c"
	}
#line 945 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp5_ = search;
#line 945 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_remove_from_map (self, _tmp5_);
#line 6423 "SearchBoolean.c"
}


void saved_search_table_add_to_map (SavedSearchTable* self, SavedSearch* search) {
	GeeHashMap* _tmp0_ = NULL;
	SavedSearch* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SavedSearch* _tmp4_ = NULL;
	SavedSearch* _tmp5_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
#line 948 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH (search));
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = search;
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _tmp2_;
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = search;
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, _tmp4_);
#line 949 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp3_);
#line 950 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp5_ = search;
#line 950 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_emit_by_name (self, "search-added", _tmp5_);
#line 6456 "SearchBoolean.c"
}


void saved_search_table_remove_from_map (SavedSearchTable* self, SavedSearch* search) {
	GeeHashMap* _tmp0_ = NULL;
	SavedSearch* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SavedSearch* _tmp4_ = NULL;
#line 953 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
#line 953 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (IS_SAVED_SEARCH (search));
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = search;
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp3_ = _tmp2_;
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, NULL);
#line 954 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_free0 (_tmp3_);
#line 955 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp4_ = search;
#line 955 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_emit_by_name (self, "search-removed", _tmp4_);
#line 6486 "SearchBoolean.c"
}


GeeIterable* saved_search_table_get_saved_searches (SavedSearchTable* self) {
	GeeIterable* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
#line 958 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
#line 959 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 959 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 959 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _tmp1_;
#line 959 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
#line 959 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6507 "SearchBoolean.c"
}


gint saved_search_table_get_count (SavedSearchTable* self) {
	gint result = 0;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 962 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), 0);
#line 963 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 963 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 963 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = _tmp1_;
#line 963 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp2_;
#line 963 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6528 "SearchBoolean.c"
}


gboolean saved_search_table_exists (SavedSearchTable* self, const gchar* search_name) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 966 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), FALSE);
#line 966 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (search_name != NULL, FALSE);
#line 967 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = self->priv->search_map;
#line 967 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp1_ = search_name;
#line 967 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 967 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp2_;
#line 967 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6551 "SearchBoolean.c"
}


gchar* saved_search_table_generate_unique_name (SavedSearchTable* self) {
	gchar* result = NULL;
	gchar* _tmp7_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
#line 6560 "SearchBoolean.c"
	{
		gint ctr = 0;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		ctr = 1;
#line 6565 "SearchBoolean.c"
		{
			gboolean _tmp0_ = FALSE;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			_tmp0_ = TRUE;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			while (TRUE) {
#line 6572 "SearchBoolean.c"
				gint _tmp2_ = 0;
				gchar* name = NULL;
				gint _tmp3_ = 0;
				gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (!_tmp0_) {
#line 6581 "SearchBoolean.c"
					gint _tmp1_ = 0;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					_tmp1_ = ctr;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					ctr = _tmp1_ + 1;
#line 6587 "SearchBoolean.c"
				}
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp0_ = FALSE;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp2_ = ctr;
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (!(_tmp2_ < G_MAXINT)) {
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					break;
#line 6597 "SearchBoolean.c"
				}
#line 973 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp3_ = ctr;
#line 973 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp4_ = g_strdup_printf ("%s %d", RESOURCES_DEFAULT_SAVED_SEARCH_NAME, _tmp3_);
#line 973 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				name = _tmp4_;
#line 975 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp5_ = name;
#line 975 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_tmp6_ = saved_search_table_exists (self, _tmp5_);
#line 975 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				if (!_tmp6_) {
#line 976 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					result = name;
#line 976 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
					return result;
#line 6615 "SearchBoolean.c"
				}
#line 972 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
				_g_free0 (name);
#line 6619 "SearchBoolean.c"
			}
		}
	}
#line 978 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp7_ = g_strdup ("");
#line 978 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	result = _tmp7_;
#line 978 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return result;
#line 6629 "SearchBoolean.c"
}


static void value_saved_search_table_init (GValue* value) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	value->data[0].v_pointer = NULL;
#line 6636 "SearchBoolean.c"
}


static void value_saved_search_table_free_value (GValue* value) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (value->data[0].v_pointer) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_table_unref (value->data[0].v_pointer);
#line 6645 "SearchBoolean.c"
	}
}


static void value_saved_search_table_copy_value (const GValue* src_value, GValue* dest_value) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (src_value->data[0].v_pointer) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		dest_value->data[0].v_pointer = saved_search_table_ref (src_value->data[0].v_pointer);
#line 6655 "SearchBoolean.c"
	} else {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6659 "SearchBoolean.c"
	}
}


static gpointer value_saved_search_table_peek_pointer (const GValue* value) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return value->data[0].v_pointer;
#line 6667 "SearchBoolean.c"
}


static gchar* value_saved_search_table_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (collect_values[0].v_pointer) {
#line 6674 "SearchBoolean.c"
		SavedSearchTable* object;
		object = collect_values[0].v_pointer;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		if (object->parent_instance.g_class == NULL) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6681 "SearchBoolean.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6685 "SearchBoolean.c"
		}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = saved_search_table_ref (object);
#line 6689 "SearchBoolean.c"
	} else {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 6693 "SearchBoolean.c"
	}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return NULL;
#line 6697 "SearchBoolean.c"
}


static gchar* value_saved_search_table_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SavedSearchTable** object_p;
	object_p = collect_values[0].v_pointer;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (!object_p) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6708 "SearchBoolean.c"
	}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (!value->data[0].v_pointer) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = NULL;
#line 6714 "SearchBoolean.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = value->data[0].v_pointer;
#line 6718 "SearchBoolean.c"
	} else {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		*object_p = saved_search_table_ref (value->data[0].v_pointer);
#line 6722 "SearchBoolean.c"
	}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return NULL;
#line 6726 "SearchBoolean.c"
}


GParamSpec* param_spec_saved_search_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSavedSearchTable* spec;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_TABLE), NULL);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return G_PARAM_SPEC (spec);
#line 6740 "SearchBoolean.c"
}


gpointer value_get_saved_search_table (const GValue* value) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE), NULL);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return value->data[0].v_pointer;
#line 6749 "SearchBoolean.c"
}


void value_set_saved_search_table (GValue* value, gpointer v_object) {
	SavedSearchTable* old;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	old = value->data[0].v_pointer;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (v_object) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = v_object;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_table_ref (value->data[0].v_pointer);
#line 6769 "SearchBoolean.c"
	} else {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 6773 "SearchBoolean.c"
	}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (old) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_table_unref (old);
#line 6779 "SearchBoolean.c"
	}
}


void value_take_saved_search_table (GValue* value, gpointer v_object) {
	SavedSearchTable* old;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	old = value->data[0].v_pointer;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (v_object) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = v_object;
#line 6798 "SearchBoolean.c"
	} else {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		value->data[0].v_pointer = NULL;
#line 6802 "SearchBoolean.c"
	}
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (old) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		saved_search_table_unref (old);
#line 6808 "SearchBoolean.c"
	}
}


static void saved_search_table_class_init (SavedSearchTableClass * klass) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	saved_search_table_parent_class = g_type_class_peek_parent (klass);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	((SavedSearchTableClass *) klass)->finalize = saved_search_table_finalize;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_type_class_add_private (klass, sizeof (SavedSearchTablePrivate));
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_new ("search_added", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_new ("search_removed", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
#line 6824 "SearchBoolean.c"
}


static void saved_search_table_instance_init (SavedSearchTable * self) {
	GeeHashMap* _tmp0_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv = SAVED_SEARCH_TABLE_GET_PRIVATE (self);
#line 892 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_SAVED_SEARCH, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 892 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->priv->search_map = _tmp0_;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self->ref_count = 1;
#line 6838 "SearchBoolean.c"
}


static void saved_search_table_finalize (SavedSearchTable* obj) {
	SavedSearchTable * self;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_TABLE, SavedSearchTable);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_signal_handlers_destroy (self);
#line 892 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	_g_object_unref0 (self->priv->search_map);
#line 6850 "SearchBoolean.c"
}


GType saved_search_table_get_type (void) {
	static volatile gsize saved_search_table_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_table_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_saved_search_table_init, value_saved_search_table_free_value, value_saved_search_table_copy_value, value_saved_search_table_peek_pointer, "p", value_saved_search_table_collect_value, "p", value_saved_search_table_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchTable), 0, (GInstanceInitFunc) saved_search_table_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType saved_search_table_type_id;
		saved_search_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&saved_search_table_type_id__volatile, saved_search_table_type_id);
	}
	return saved_search_table_type_id__volatile;
}


gpointer saved_search_table_ref (gpointer instance) {
	SavedSearchTable* self;
	self = instance;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	g_atomic_int_inc (&self->ref_count);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	return instance;
#line 6875 "SearchBoolean.c"
}


void saved_search_table_unref (gpointer instance) {
	SavedSearchTable* self;
	self = instance;
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		SAVED_SEARCH_TABLE_GET_CLASS (self)->finalize (self);
#line 890 "/home/jens/Source/shotwell/src/searches/SearchBoolean.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6888 "SearchBoolean.c"
	}
}



