/* Properties.c generated by valac 0.34.4, the Vala compiler
 * generated from Properties.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define TYPE_PROPERTIES (properties_get_type ())
#define PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES, Properties))
#define PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES, PropertiesClass))
#define IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES))
#define IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES))
#define PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES, PropertiesClass))

typedef struct _Properties Properties;
typedef struct _PropertiesClass PropertiesClass;
typedef struct _PropertiesPrivate PropertiesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_BASIC_PROPERTIES (basic_properties_get_type ())
#define BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_PROPERTIES, BasicProperties))
#define BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))
#define IS_BASIC_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_PROPERTIES))
#define IS_BASIC_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_PROPERTIES))
#define BASIC_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_PROPERTIES, BasicPropertiesClass))

typedef struct _BasicProperties BasicProperties;
typedef struct _BasicPropertiesClass BasicPropertiesClass;
typedef struct _BasicPropertiesPrivate BasicPropertiesPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_IMPORT_SOURCE (import_source_get_type ())
#define IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE, ImportSource))
#define IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE, ImportSourceClass))
#define IS_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE))
#define IS_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE))
#define IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE, ImportSourceClass))

typedef struct _ImportSource ImportSource;
typedef struct _ImportSourceClass ImportSourceClass;

#define TYPE_PHOTO_IMPORT_SOURCE (photo_import_source_get_type ())
#define PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource))
#define PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))
#define IS_PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_SOURCE))
#define IS_PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_SOURCE))
#define PHOTO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))

typedef struct _PhotoImportSource PhotoImportSource;
typedef struct _PhotoImportSourceClass PhotoImportSourceClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _dimensions_free0(var) ((var == NULL) ? NULL : (var = (dimensions_free (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO_IMPORT_SOURCE (video_import_source_get_type ())
#define VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource))
#define VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))
#define IS_VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_SOURCE))
#define IS_VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_SOURCE))
#define VIDEO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))

typedef struct _VideoImportSource VideoImportSource;
typedef struct _VideoImportSourceClass VideoImportSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;

#define TYPE_MEDIA_PAGE (media_page_get_type ())
#define MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_PAGE, MediaPage))
#define MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_PAGE, MediaPageClass))
#define IS_MEDIA_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_PAGE))
#define IS_MEDIA_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_PAGE))
#define MEDIA_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_PAGE, MediaPageClass))

typedef struct _MediaPage MediaPage;
typedef struct _MediaPageClass MediaPageClass;

#define TYPE_COLLECTION_PAGE (collection_page_get_type ())
#define COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_PAGE, CollectionPage))
#define COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_PAGE, CollectionPageClass))
#define IS_COLLECTION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_PAGE))
#define IS_COLLECTION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_PAGE))
#define COLLECTION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_PAGE, CollectionPageClass))

typedef struct _CollectionPage CollectionPage;
typedef struct _CollectionPageClass CollectionPageClass;

#define TYPE_TAG_PAGE (tag_page_get_type ())
#define TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_PAGE, TagPage))
#define TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_PAGE, TagPageClass))
#define IS_TAG_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_PAGE))
#define IS_TAG_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_PAGE))
#define TAG_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_PAGE, TagPageClass))

typedef struct _TagPage TagPage;
typedef struct _TagPageClass TagPageClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_EXTENDED_PROPERTIES_WINDOW (extended_properties_window_get_type ())
#define EXTENDED_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow))
#define EXTENDED_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowClass))
#define IS_EXTENDED_PROPERTIES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW))
#define IS_EXTENDED_PROPERTIES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTENDED_PROPERTIES_WINDOW))
#define EXTENDED_PROPERTIES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowClass))

typedef struct _ExtendedPropertiesWindow ExtendedPropertiesWindow;
typedef struct _ExtendedPropertiesWindowClass ExtendedPropertiesWindowClass;
typedef struct _ExtendedPropertiesWindowPrivate ExtendedPropertiesWindowPrivate;

#define EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES (extended_properties_window_extended_properties_get_type ())
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties))
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesClass))
#define EXTENDED_PROPERTIES_WINDOW_IS_EXTENDED_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_WINDOW_IS_EXTENDED_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES))
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesClass))

typedef struct _ExtendedPropertiesWindowExtendedProperties ExtendedPropertiesWindowExtendedProperties;
typedef struct _ExtendedPropertiesWindowExtendedPropertiesClass ExtendedPropertiesWindowExtendedPropertiesClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ExtendedPropertiesWindowExtendedPropertiesPrivate ExtendedPropertiesWindowExtendedPropertiesPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_EVENTS_DIRECTORY_PAGE (events_directory_page_get_type ())
#define EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPage))
#define EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))
#define IS_EVENTS_DIRECTORY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENTS_DIRECTORY_PAGE))
#define IS_EVENTS_DIRECTORY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENTS_DIRECTORY_PAGE))
#define EVENTS_DIRECTORY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENTS_DIRECTORY_PAGE, EventsDirectoryPageClass))

typedef struct _EventsDirectoryPage EventsDirectoryPage;
typedef struct _EventsDirectoryPageClass EventsDirectoryPageClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Properties {
	GtkGrid parent_instance;
	PropertiesPrivate * priv;
};

struct _PropertiesClass {
	GtkGridClass parent_class;
	void (*get_single_properties) (Properties* self, DataView* view);
	void (*get_multiple_properties) (Properties* self, GeeIterable* iter);
	void (*get_properties) (Properties* self, Page* current_page);
	void (*clear_properties) (Properties* self);
	void (*internal_update_properties) (Properties* self, Page* page);
};

struct _PropertiesPrivate {
	guint line_count;
};

struct _BasicProperties {
	Properties parent_instance;
	BasicPropertiesPrivate * priv;
};

struct _BasicPropertiesClass {
	PropertiesClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _BasicPropertiesPrivate {
	gchar* title;
	time_t start_time;
	time_t end_time;
	Dimensions dimensions;
	gint photo_count;
	gint event_count;
	gint video_count;
	gchar* exposure;
	gchar* aperture;
	gchar* iso;
	gdouble clip_duration;
	gchar* raw_developer;
	gchar* raw_assoc;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ExtendedPropertiesWindow {
	GtkDialog parent_instance;
	ExtendedPropertiesWindowPrivate * priv;
};

struct _ExtendedPropertiesWindowClass {
	GtkDialogClass parent_class;
};

struct _ExtendedPropertiesWindowPrivate {
	ExtendedPropertiesWindowExtendedProperties* properties;
};

struct _ExtendedPropertiesWindowExtendedProperties {
	Properties parent_instance;
	ExtendedPropertiesWindowExtendedPropertiesPrivate * priv;
};

struct _ExtendedPropertiesWindowExtendedPropertiesClass {
	PropertiesClass parent_class;
};

struct _ExtendedPropertiesWindowExtendedPropertiesPrivate {
	gchar* file_path;
	guint64 filesize;
	Dimensions* original_dim;
	gchar* camera_make;
	gchar* camera_model;
	gchar* flash;
	gchar* focal_length;
	gdouble gps_lat;
	gchar* gps_lat_ref;
	gdouble gps_long;
	gchar* gps_long_ref;
	gdouble gps_alt;
	gchar* artist;
	gchar* copyright;
	gchar* software;
	gchar* exposure_bias;
	gchar* exposure_date;
	gchar* exposure_time;
	gboolean is_raw;
	gchar* development_path;
	gchar* comment;
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;


static gpointer properties_parent_class = NULL;
static gpointer basic_properties_parent_class = NULL;
static gpointer extended_properties_window_parent_class = NULL;
static gpointer extended_properties_window_extended_properties_parent_class = NULL;

GType properties_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType page_get_type (void) G_GNUC_CONST;
#define PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROPERTIES, PropertiesPrivate))
enum  {
	PROPERTIES_DUMMY_PROPERTY
};
Properties* properties_construct (GType object_type);
void properties_add_line (Properties* self, const gchar* label_text, const gchar* info_text, gboolean multi_line);
gboolean is_string_empty (const gchar* s);
gchar* properties_get_prettyprint_time (Properties* self, struct tm* time);
gchar* resources_get_hh_mm_format_string (void);
gchar* properties_get_prettyprint_time_with_seconds (Properties* self, struct tm* time);
gchar* resources_get_hh_mm_ss_format_string (void);
gchar* properties_get_prettyprint_date (Properties* self, struct tm* date);
gchar* format_local_date (struct tm* date);
void properties_get_single_properties (Properties* self, DataView* view);
static void properties_real_get_single_properties (Properties* self, DataView* view);
void properties_get_multiple_properties (Properties* self, GeeIterable* iter);
static void properties_real_get_multiple_properties (Properties* self, GeeIterable* iter);
void properties_get_properties (Properties* self, Page* current_page);
static void properties_real_get_properties (Properties* self, Page* current_page);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
ViewCollection* page_get_view (Page* self);
gint view_collection_get_selected_count (ViewCollection* self);
GeeList* view_collection_get_selected (ViewCollection* self);
gint data_collection_get_count (DataCollection* self);
GeeCollection* data_collection_get_all (DataCollection* self);
void properties_clear_properties (Properties* self);
static void properties_real_clear_properties (Properties* self);
void properties_update_properties (Properties* self, Page* page);
void properties_internal_update_properties (Properties* self, Page* page);
static void properties_real_internal_update_properties (Properties* self, Page* page);
void properties_unselect_text (Properties* self);
static void properties_finalize (GObject* obj);
GType basic_properties_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define BASIC_PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BASIC_PROPERTIES, BasicPropertiesPrivate))
enum  {
	BASIC_PROPERTIES_DUMMY_PROPERTY
};
BasicProperties* basic_properties_new (void);
BasicProperties* basic_properties_construct (GType object_type);
static void basic_properties_real_clear_properties (Properties* base);
void dimensions_init (Dimensions *self, gint width, gint height);
static void basic_properties_real_get_single_properties (Properties* base, DataView* view);
GType data_source_get_type (void) G_GNUC_CONST;
DataSource* data_view_get_source (DataView* self);
gchar* data_object_get_name (DataObject* self);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType import_source_get_type (void) G_GNUC_CONST;
GType photo_import_source_get_type (void) G_GNUC_CONST;
time_t media_source_get_exposure_time (MediaSource* self);
time_t import_source_get_exposure_time (ImportSource* self);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
PhotoMetadata* photo_import_source_get_metadata (PhotoImportSource* self);
gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
gchar* photo_metadata_get_aperture_string (PhotoMetadata* self, gboolean pango_formatted);
gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void orientation_rotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
GType photo_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
RawDeveloper photo_get_raw_developer (Photo* self);
gchar* raw_developer_get_label (RawDeveloper self);
gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d);
GType event_source_get_type (void) G_GNUC_CONST;
time_t event_source_get_start_time (EventSource* self);
time_t event_source_get_end_time (EventSource* self);
void media_source_collection_count_media (GeeCollection* media, gint* photo_count, gint* video_count);
GeeCollection* event_source_get_media (EventSource* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_import_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
gdouble video_get_clip_duration (Video* self);
gboolean video_get_is_interpretable (Video* self);
void video_get_frame_dimensions (Video* self, Dimensions* result);
static void basic_properties_real_get_multiple_properties (Properties* base, GeeIterable* iter);
static void basic_properties_real_get_properties (Properties* base, Page* current_page);
static void basic_properties_real_internal_update_properties (Properties* base, Page* page);
GType checkerboard_page_get_type (void) G_GNUC_CONST;
GType media_page_get_type (void) G_GNUC_CONST;
GType collection_page_get_type (void) G_GNUC_CONST;
GType tag_page_get_type (void) G_GNUC_CONST;
GType tag_get_type (void) G_GNUC_CONST;
Tag* tag_page_get_tag (TagPage* self);
gchar* tag_get_user_visible_name (Tag* self);
gchar* guarded_markup_escape_text (const gchar* plain);
gboolean dimensions_has_area (Dimensions *self);
static void basic_properties_finalize (GObject* obj);
GType extended_properties_window_get_type (void) G_GNUC_CONST;
static GType extended_properties_window_extended_properties_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define EXTENDED_PROPERTIES_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindowPrivate))
enum  {
	EXTENDED_PROPERTIES_WINDOW_DUMMY_PROPERTY
};
ExtendedPropertiesWindow* extended_properties_window_new (GtkWindow* owner);
ExtendedPropertiesWindow* extended_properties_window_construct (GType object_type, GtkWindow* owner);
static gboolean _gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_new (void);
static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_construct (GType object_type);
static gboolean extended_properties_window_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean extended_properties_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void extended_properties_window_update_properties (ExtendedPropertiesWindow* self, Page* page);
static void extended_properties_window_real_show_all (GtkWidget* base);
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedPropertiesPrivate))
enum  {
	EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_DUMMY_PROPERTY
};
#define EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE ""
static void extended_properties_window_extended_properties_real_clear_properties (Properties* base);
static void extended_properties_window_extended_properties_real_get_single_properties (Properties* base, DataView* view);
GFile* media_source_get_master_file (MediaSource* self);
GFile* media_source_get_file (MediaSource* self);
guint64 media_source_get_master_filesize (MediaSource* self);
PhotoMetadata* photo_get_master_metadata (Photo* self, GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
time_t media_source_get_timestamp (MediaSource* self);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type, time_t timestamp);
gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
gboolean photo_metadata_get_gps (PhotoMetadata* self, gdouble* longitude, gchar** long_ref, gdouble* latitude, gchar** lat_ref, gdouble* altitude);
gchar* photo_metadata_get_artist (PhotoMetadata* self);
gchar* photo_metadata_get_copyright (PhotoMetadata* self);
gchar* photo_metadata_get_software (PhotoMetadata* self);
gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_source_get_comment (MediaSource* self);
GType event_get_type (void) G_GNUC_CONST;
gchar* event_source_get_comment (EventSource* self);
static void extended_properties_window_extended_properties_real_internal_update_properties (Properties* base, Page* page);
GType events_directory_page_get_type (void) G_GNUC_CONST;
static void extended_properties_window_extended_properties_finalize (GObject* obj);
static void extended_properties_window_finalize (GObject* obj);


Properties* properties_construct (GType object_type) {
	Properties * self = NULL;
#line 10 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (Properties*) g_object_new (object_type, NULL);
#line 11 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_set_row_spacing (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), 0);
#line 12 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_set_column_spacing (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), 6);
#line 10 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 703 "Properties.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? g_object_ref (self) : NULL;
#line 710 "Properties.c"
}


void properties_add_line (Properties* self, const gchar* label_text, const gchar* info_text, gboolean multi_line) {
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkWidget* info = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkLabel* _tmp46_ = NULL;
	guint _tmp47_ = 0U;
	gboolean _tmp48_ = FALSE;
	guint _tmp53_ = 0U;
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (label_text != NULL);
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (info_text != NULL);
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	g_object_ref_sink (_tmp0_);
#line 16 "/home/jens/Source/shotwell/src/Properties.vala"
	label = _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = label;
#line 19 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_label_set_justify (_tmp1_, GTK_JUSTIFY_RIGHT);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = label;
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = label_text;
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = g_markup_printf_escaped ("<span font_weight=\"bold\">%s</span>", _tmp3_);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = _tmp4_;
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_label_set_markup (_tmp2_, _tmp5_);
#line 21 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp5_);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = multi_line;
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp6_) {
#line 760 "Properties.c"
		GtkScrolledWindow* info_scroll = NULL;
		GtkScrolledWindow* _tmp7_ = NULL;
		GtkScrolledWindow* _tmp8_ = NULL;
		GtkTextView* view = NULL;
		GtkTextView* _tmp9_ = NULL;
		GtkStyleContext* context = NULL;
		GtkScrolledWindow* _tmp10_ = NULL;
		GtkStyleContext* _tmp11_ = NULL;
		GtkStyleContext* _tmp12_ = NULL;
		GtkTextView* _tmp13_ = NULL;
		GtkStyleContext* _tmp14_ = NULL;
		GdkRGBA _tmp15_ = {0};
		GtkTextView* _tmp16_ = NULL;
		GtkTextView* _tmp17_ = NULL;
		GtkTextView* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		GtkTextView* _tmp23_ = NULL;
		GtkTextBuffer* _tmp24_ = NULL;
		GtkTextBuffer* _tmp25_ = NULL;
		GtkScrolledWindow* _tmp26_ = NULL;
		GtkTextView* _tmp27_ = NULL;
		GtkLabel* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		GtkScrolledWindow* _tmp30_ = NULL;
		GtkWidget* _tmp31_ = NULL;
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp7_);
#line 24 "/home/jens/Source/shotwell/src/Properties.vala"
		info_scroll = _tmp7_;
#line 25 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = info_scroll;
#line 25 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_scrolled_window_set_shadow_type (_tmp8_, GTK_SHADOW_ETCHED_IN);
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = (GtkTextView*) gtk_text_view_new ();
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp9_);
#line 26 "/home/jens/Source/shotwell/src/Properties.vala"
		view = _tmp9_;
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = info_scroll;
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 31 "/home/jens/Source/shotwell/src/Properties.vala"
		context = _tmp12_;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = view;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = context;
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_style_context_get_background_color (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
#line 32 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp15_);
#line 34 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = view;
#line 34 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_wrap_mode (_tmp16_, GTK_WRAP_WORD);
#line 35 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp17_ = view;
#line 35 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_cursor_visible (_tmp17_, FALSE);
#line 36 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp18_ = view;
#line 36 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_text_view_set_editable (_tmp18_, FALSE);
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp20_ = info_text;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp21_ = is_string_empty (_tmp20_);
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp21_) {
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = "";
#line 840 "Properties.c"
		} else {
			const gchar* _tmp22_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = info_text;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = _tmp22_;
#line 847 "Properties.c"
		}
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp23_ = view;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp24_ = gtk_text_view_get_buffer (_tmp23_);
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp25_ = _tmp24_;
#line 37 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_set (_tmp25_, "text", _tmp19_, NULL);
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = info_scroll;
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = view;
#line 38 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
#line 39 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp28_ = label;
#line 39 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp28_, 1.0f);
#line 40 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp29_ = label;
#line 40 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp29_, 0.0f);
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp30_ = info_scroll;
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info);
#line 41 "/home/jens/Source/shotwell/src/Properties.vala"
		info = _tmp31_;
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (context);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (view);
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info_scroll);
#line 885 "Properties.c"
	} else {
		GtkLabel* info_label = NULL;
		GtkLabel* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		GtkLabel* _tmp37_ = NULL;
		GtkLabel* _tmp38_ = NULL;
		GtkLabel* _tmp39_ = NULL;
		GtkLabel* _tmp40_ = NULL;
		GtkLabel* _tmp41_ = NULL;
		GtkLabel* _tmp42_ = NULL;
		GtkLabel* _tmp43_ = NULL;
		GtkLabel* _tmp44_ = NULL;
		GtkWidget* _tmp45_ = NULL;
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp32_ = (GtkLabel*) gtk_label_new ("");
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		g_object_ref_sink (_tmp32_);
#line 43 "/home/jens/Source/shotwell/src/Properties.vala"
		info_label = _tmp32_;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp34_ = info_text;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp35_ = is_string_empty (_tmp34_);
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp35_) {
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = "";
#line 915 "Properties.c"
		} else {
			const gchar* _tmp36_ = NULL;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp36_ = info_text;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = _tmp36_;
#line 922 "Properties.c"
		}
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp37_ = info_label;
#line 44 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_markup (_tmp37_, _tmp33_);
#line 45 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp38_ = info_label;
#line 45 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_ellipsize (_tmp38_, PANGO_ELLIPSIZE_END);
#line 46 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = info_label;
#line 46 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp39_, 0.0f);
#line 47 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp40_ = info_label;
#line 47 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp40_, 0.5f);
#line 48 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = info_label;
#line 48 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_selectable (_tmp41_, TRUE);
#line 49 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = label;
#line 49 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_xalign (_tmp42_, 1.0f);
#line 50 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp43_ = label;
#line 50 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_label_set_yalign (_tmp43_, 0.5f);
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp44_ = info_label;
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget));
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info);
#line 51 "/home/jens/Source/shotwell/src/Properties.vala"
		info = _tmp45_;
#line 23 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (info_label);
#line 962 "Properties.c"
	}
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp46_ = label;
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp47_ = self->priv->line_count;
#line 54 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget), 0, (gint) _tmp47_, 1, 1);
#line 56 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp48_ = multi_line;
#line 56 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp48_) {
#line 974 "Properties.c"
		GtkWidget* _tmp49_ = NULL;
		guint _tmp50_ = 0U;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp49_ = info;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp50_ = self->priv->line_count;
#line 57 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), _tmp49_, 1, (gint) _tmp50_, 1, 2);
#line 983 "Properties.c"
	} else {
		GtkWidget* _tmp51_ = NULL;
		guint _tmp52_ = 0U;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp51_ = info;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp52_ = self->priv->line_count;
#line 59 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_grid_attach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), _tmp51_, 1, (gint) _tmp52_, 1, 1);
#line 993 "Properties.c"
	}
#line 62 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp53_ = self->priv->line_count;
#line 62 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = _tmp53_ + 1;
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (info);
#line 15 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (label);
#line 1003 "Properties.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
#line 2758 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1049 "Properties.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1067 "Properties.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1090 "Properties.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1098 "Properties.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1110 "Properties.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1134 "Properties.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1140 "Properties.c"
	} else {
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1144 "Properties.c"
	}
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1148 "Properties.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1160 "Properties.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1170 "Properties.c"
	}
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1176 "Properties.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1190 "Properties.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1200 "Properties.c"
	}
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1206 "Properties.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1215 "Properties.c"
	}
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1235 "Properties.c"
}


gchar* properties_get_prettyprint_time (Properties* self, struct tm* time) {
	gchar* result = NULL;
	gchar* timestring = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar _tmp5_ = '\0';
#line 65 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 65 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (time != NULL, NULL);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = resources_get_hh_mm_format_string ();
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_time_format (time, _tmp1_);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _tmp2_;
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp1_);
#line 66 "/home/jens/Source/shotwell/src/Properties.vala"
	timestring = _tmp3_;
#line 68 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = timestring;
#line 68 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = string_get (_tmp4_, (glong) 0);
#line 68 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp5_ == '0') {
#line 1270 "Properties.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = timestring;
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) -1);
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (timestring);
#line 69 "/home/jens/Source/shotwell/src/Properties.vala"
		timestring = _tmp7_;
#line 1281 "Properties.c"
	}
#line 71 "/home/jens/Source/shotwell/src/Properties.vala"
	result = timestring;
#line 71 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1287 "Properties.c"
}


gchar* properties_get_prettyprint_time_with_seconds (Properties* self, struct tm* time) {
	gchar* result = NULL;
	gchar* timestring = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar _tmp5_ = '\0';
#line 74 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 74 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (time != NULL, NULL);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = resources_get_hh_mm_ss_format_string ();
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_;
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_time_format (time, _tmp1_);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/Properties.vala"
	timestring = _tmp3_;
#line 77 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = timestring;
#line 77 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = string_get (_tmp4_, (glong) 0);
#line 77 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp5_ == '0') {
#line 1322 "Properties.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = timestring;
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = string_substring (_tmp6_, (glong) 1, (glong) -1);
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (timestring);
#line 78 "/home/jens/Source/shotwell/src/Properties.vala"
		timestring = _tmp7_;
#line 1333 "Properties.c"
	}
#line 80 "/home/jens/Source/shotwell/src/Properties.vala"
	result = timestring;
#line 80 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1339 "Properties.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return;
#line 1354 "Properties.c"
}


gchar* properties_get_prettyprint_date (Properties* self, struct tm* date) {
	gchar* result = NULL;
	gchar* date_string = NULL;
	struct tm today = {0};
	time_t _tmp0_ = 0;
	struct tm _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	struct tm _tmp3_ = {0};
	gint _tmp4_ = 0;
	struct tm _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 83 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (IS_PROPERTIES (self), NULL);
#line 83 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (date != NULL, NULL);
#line 84 "/home/jens/Source/shotwell/src/Properties.vala"
	date_string = NULL;
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = time (NULL);
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	g_time_local (_tmp0_, &_tmp1_);
#line 85 "/home/jens/Source/shotwell/src/Properties.vala"
	today = _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = *date;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = _tmp3_.tm_yday;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = today;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = _tmp5_.tm_yday;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp4_ == _tmp6_) {
#line 1391 "Properties.c"
		struct tm _tmp7_ = {0};
		gint _tmp8_ = 0;
		struct tm _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = *date;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = _tmp7_.tm_year;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = today;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = _tmp9_.tm_year;
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 1406 "Properties.c"
	} else {
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = FALSE;
#line 1410 "Properties.c"
	}
#line 86 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp2_) {
#line 1414 "Properties.c"
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = _ ("Today");
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (date_string);
#line 87 "/home/jens/Source/shotwell/src/Properties.vala"
		date_string = _tmp12_;
#line 1425 "Properties.c"
	} else {
		gboolean _tmp13_ = FALSE;
		struct tm _tmp14_ = {0};
		gint _tmp15_ = 0;
		struct tm _tmp16_ = {0};
		gint _tmp17_ = 0;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = *date;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = _tmp14_.tm_yday;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = today;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp17_ = _tmp16_.tm_yday;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp15_ == (_tmp17_ - 1)) {
#line 1442 "Properties.c"
			struct tm _tmp18_ = {0};
			gint _tmp19_ = 0;
			struct tm _tmp20_ = {0};
			gint _tmp21_ = 0;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = *date;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = _tmp18_.tm_year;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = today;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = _tmp20_.tm_year;
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = _tmp19_ == _tmp21_;
#line 1457 "Properties.c"
		} else {
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = FALSE;
#line 1461 "Properties.c"
		}
#line 88 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp13_) {
#line 1465 "Properties.c"
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = _ ("Yesterday");
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = g_strdup (_tmp22_);
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (date_string);
#line 89 "/home/jens/Source/shotwell/src/Properties.vala"
			date_string = _tmp23_;
#line 1476 "Properties.c"
		} else {
			struct tm _tmp24_ = {0};
			gchar* _tmp25_ = NULL;
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = *date;
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = format_local_date (&_tmp24_);
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (date_string);
#line 91 "/home/jens/Source/shotwell/src/Properties.vala"
			date_string = _tmp25_;
#line 1488 "Properties.c"
		}
	}
#line 94 "/home/jens/Source/shotwell/src/Properties.vala"
	result = date_string;
#line 94 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 1495 "Properties.c"
}


static void properties_real_get_single_properties (Properties* self, DataView* view) {
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 1502 "Properties.c"
}


void properties_get_single_properties (Properties* self, DataView* view) {
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 97 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_single_properties (self, view);
#line 1511 "Properties.c"
}


static void properties_real_get_multiple_properties (Properties* self, GeeIterable* iter) {
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail ((iter == NULL) || GEE_IS_ITERABLE (iter));
#line 1518 "Properties.c"
}


void properties_get_multiple_properties (Properties* self, GeeIterable* iter) {
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 100 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_multiple_properties (self, iter);
#line 1527 "Properties.c"
}


static void properties_real_get_properties (Properties* self, Page* current_page) {
	ViewCollection* view = NULL;
	Page* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	ViewCollection* _tmp2_ = NULL;
	gint count = 0;
	ViewCollection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeIterable* iter = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp12_ = FALSE;
	GeeIterable* _tmp13_ = NULL;
	gint _tmp15_ = 0;
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (current_page));
#line 104 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = current_page;
#line 104 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = page_get_view (_tmp0_);
#line 104 "/home/jens/Source/shotwell/src/Properties.vala"
	view = _tmp1_;
#line 105 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = view;
#line 105 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp2_ == NULL) {
#line 106 "/home/jens/Source/shotwell/src/Properties.vala"
		_data_collection_unref0 (view);
#line 106 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 1560 "Properties.c"
	}
#line 109 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = view;
#line 109 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = view_collection_get_selected_count (_tmp3_);
#line 109 "/home/jens/Source/shotwell/src/Properties.vala"
	count = _tmp4_;
#line 110 "/home/jens/Source/shotwell/src/Properties.vala"
	iter = NULL;
#line 111 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = count;
#line 111 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp5_ != 0) {
#line 1574 "Properties.c"
		ViewCollection* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = view;
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = view_collection_get_selected (_tmp6_);
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 112 "/home/jens/Source/shotwell/src/Properties.vala"
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable);
#line 1585 "Properties.c"
	} else {
		ViewCollection* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		ViewCollection* _tmp10_ = NULL;
		GeeCollection* _tmp11_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = view;
#line 114 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
#line 114 "/home/jens/Source/shotwell/src/Properties.vala"
		count = _tmp9_;
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = view;
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 115 "/home/jens/Source/shotwell/src/Properties.vala"
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable);
#line 1605 "Properties.c"
	}
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp13_ = iter;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp13_ == NULL) {
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = TRUE;
#line 1613 "Properties.c"
	} else {
		gint _tmp14_ = 0;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = count;
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = _tmp14_ == 0;
#line 1620 "Properties.c"
	}
#line 118 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp12_) {
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (iter);
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		_data_collection_unref0 (view);
#line 119 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 1630 "Properties.c"
	}
#line 121 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp15_ = count;
#line 121 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp15_ == 1) {
#line 1636 "Properties.c"
		{
			GeeIterator* _item_it = NULL;
			GeeIterable* _tmp16_ = NULL;
			GeeIterator* _tmp17_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp16_ = iter;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = gee_iterable_iterator (_tmp16_);
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_item_it = _tmp17_;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			while (TRUE) {
#line 1649 "Properties.c"
				GeeIterator* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				DataView* item = NULL;
				GeeIterator* _tmp20_ = NULL;
				gpointer _tmp21_ = NULL;
				DataView* _tmp22_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp18_ = _item_it;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp19_ = gee_iterator_next (_tmp18_);
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				if (!_tmp19_) {
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
					break;
#line 1664 "Properties.c"
				}
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp20_ = _item_it;
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp21_ = gee_iterator_get (_tmp20_);
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
				item = (DataView*) _tmp21_;
#line 123 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp22_ = item;
#line 123 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_get_single_properties (self, _tmp22_);
#line 124 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (item);
#line 124 "/home/jens/Source/shotwell/src/Properties.vala"
				break;
#line 1680 "Properties.c"
			}
#line 122 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (_item_it);
#line 1684 "Properties.c"
		}
	} else {
		GeeIterable* _tmp23_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp23_ = iter;
#line 127 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_get_multiple_properties (self, _tmp23_);
#line 1692 "Properties.c"
	}
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (iter);
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	_data_collection_unref0 (view);
#line 1698 "Properties.c"
}


void properties_get_properties (Properties* self, Page* current_page) {
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 103 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->get_properties (self, current_page);
#line 1707 "Properties.c"
}


static void properties_real_clear_properties (Properties* self) {
	GList* _tmp0_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
#line 1715 "Properties.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		child_collection = _tmp0_;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1723 "Properties.c"
			GtkWidget* _tmp1_ = NULL;
			GtkWidget* child = NULL;
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
			child = _tmp1_;
#line 1730 "Properties.c"
			{
				GtkWidget* _tmp2_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp2_ = child;
#line 133 "/home/jens/Source/shotwell/src/Properties.vala"
				gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp2_);
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (child);
#line 1739 "Properties.c"
			}
		}
#line 132 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_list_free0 (child_collection);
#line 1744 "Properties.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = (guint) 0;
#line 1748 "Properties.c"
}


void properties_clear_properties (Properties* self) {
#line 131 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 131 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->clear_properties (self);
#line 1757 "Properties.c"
}


void properties_update_properties (Properties* self, Page* page) {
	Page* _tmp0_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 138 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 139 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_clear_properties (self);
#line 140 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = page;
#line 140 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_internal_update_properties (self, _tmp0_);
#line 141 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1775 "Properties.c"
}


static void properties_real_internal_update_properties (Properties* self, Page* page) {
	Page* _tmp0_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 145 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = page;
#line 145 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_get_properties (self, _tmp0_);
#line 1787 "Properties.c"
}


void properties_internal_update_properties (Properties* self, Page* page) {
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 144 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_GET_CLASS (self)->internal_update_properties (self, page);
#line 1796 "Properties.c"
}


void properties_unselect_text (Properties* self) {
	GList* _tmp0_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PROPERTIES (self));
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
#line 1806 "Properties.c"
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		child_collection = _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 1814 "Properties.c"
			GtkWidget* _tmp1_ = NULL;
			GtkWidget* child = NULL;
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
			child = _tmp1_;
#line 1821 "Properties.c"
			{
				GtkWidget* _tmp2_ = NULL;
#line 150 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp2_ = child;
#line 150 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ())) {
#line 1828 "Properties.c"
					GtkWidget* _tmp3_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp3_ = child;
#line 151 "/home/jens/Source/shotwell/src/Properties.vala"
					gtk_label_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel), 0, 0);
#line 1834 "Properties.c"
				}
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_object_unref0 (child);
#line 1838 "Properties.c"
			}
		}
#line 149 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_list_free0 (child_collection);
#line 1843 "Properties.c"
	}
}


static void properties_class_init (PropertiesClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (PropertiesPrivate));
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = properties_real_get_single_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_multiple_properties = properties_real_get_multiple_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_properties = properties_real_get_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = properties_real_clear_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = properties_real_internal_update_properties;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = properties_finalize;
#line 1865 "Properties.c"
}


static void properties_instance_init (Properties * self) {
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = PROPERTIES_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->line_count = (guint) 0;
#line 1874 "Properties.c"
}


static void properties_finalize (GObject* obj) {
	Properties * self;
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTIES, Properties);
#line 7 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (properties_parent_class)->finalize (obj);
#line 1884 "Properties.c"
}


GType properties_get_type (void) {
	static volatile gsize properties_type_id__volatile = 0;
	if (g_once_init_enter (&properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Properties), 0, (GInstanceInitFunc) properties_instance_init, NULL };
		GType properties_type_id;
		properties_type_id = g_type_register_static (gtk_grid_get_type (), "Properties", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&properties_type_id__volatile, properties_type_id);
	}
	return properties_type_id__volatile;
}


BasicProperties* basic_properties_construct (GType object_type) {
	BasicProperties * self = NULL;
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (BasicProperties*) properties_construct (object_type);
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 1906 "Properties.c"
}


BasicProperties* basic_properties_new (void) {
#line 171 "/home/jens/Source/shotwell/src/Properties.vala"
	return basic_properties_construct (TYPE_BASIC_PROPERTIES);
#line 1913 "Properties.c"
}


static void basic_properties_real_clear_properties (Properties* base) {
	BasicProperties * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 175 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = g_strdup ("");
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 176 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->title = _tmp0_;
#line 177 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->start_time = (time_t) 0;
#line 178 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->end_time = (time_t) 0;
#line 179 "/home/jens/Source/shotwell/src/Properties.vala"
	dimensions_init (&self->priv->dimensions, 0, 0);
#line 180 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->photo_count = -1;
#line 181 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->event_count = -1;
#line 182 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->video_count = -1;
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = g_strdup ("");
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure);
#line 183 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure = _tmp1_;
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = g_strdup ("");
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->aperture);
#line 184 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->aperture = _tmp2_;
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = g_strdup ("");
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->iso);
#line 185 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->iso = _tmp3_;
#line 186 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->clip_duration = 0.0;
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = g_strdup ("");
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_developer);
#line 187 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->raw_developer = _tmp4_;
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = g_strdup ("");
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_assoc);
#line 188 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->raw_assoc = _tmp5_;
#line 1979 "Properties.c"
}


static gpointer _media_metadata_ref0 (gpointer self) {
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 1986 "Properties.c"
}


static void basic_properties_real_get_single_properties (Properties* base, DataView* view) {
	BasicProperties * self;
	DataView* _tmp0_ = NULL;
	DataSource* source = NULL;
	DataView* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DataSource* _tmp6_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 192 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = view;
#line 192 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 194 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = view;
#line 194 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = data_view_get_source (_tmp1_);
#line 194 "/home/jens/Source/shotwell/src/Properties.vala"
	source = _tmp2_;
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = source;
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 196 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->title = _tmp4_;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = source;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_PHOTO_SOURCE)) {
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = TRUE;
#line 2028 "Properties.c"
	} else {
		DataSource* _tmp7_ = NULL;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = source;
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_PHOTO_IMPORT_SOURCE);
#line 2035 "Properties.c"
	}
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp5_) {
#line 2039 "Properties.c"
		time_t _tmp8_ = 0;
		DataSource* _tmp9_ = NULL;
		time_t _tmp14_ = 0;
		PhotoMetadata* _tmp15_ = NULL;
		DataSource* _tmp16_ = NULL;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp21_ = NULL;
		PhotoMetadata* _tmp22_ = NULL;
		DataSource* _tmp47_ = NULL;
		gboolean _tmp50_ = FALSE;
		DataSource* _tmp51_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = source;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_PHOTO_SOURCE)) {
#line 2055 "Properties.c"
			DataSource* _tmp10_ = NULL;
			time_t _tmp11_ = 0;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp10_ = source;
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp11_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp8_ = _tmp11_;
#line 2064 "Properties.c"
		} else {
			DataSource* _tmp12_ = NULL;
			time_t _tmp13_ = 0;
#line 200 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp12_ = source;
#line 200 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 200 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp8_ = _tmp13_;
#line 2074 "Properties.c"
		}
#line 199 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->start_time = _tmp8_;
#line 201 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = self->priv->start_time;
#line 201 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->end_time = _tmp14_;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = source;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_PHOTO_SOURCE)) {
#line 2086 "Properties.c"
			DataSource* _tmp17_ = NULL;
			PhotoMetadata* _tmp18_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = source;
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_SOURCE, PhotoSource));
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp15_);
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = _tmp18_;
#line 2097 "Properties.c"
		} else {
			DataSource* _tmp19_ = NULL;
			PhotoMetadata* _tmp20_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = source;
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = photo_import_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp15_);
#line 204 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp15_ = _tmp20_;
#line 2109 "Properties.c"
		}
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp21_ = _media_metadata_ref0 (_tmp15_);
#line 203 "/home/jens/Source/shotwell/src/Properties.vala"
		metadata = _tmp21_;
#line 206 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp22_ = metadata;
#line 206 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp22_ != NULL) {
#line 2119 "Properties.c"
			PhotoMetadata* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			PhotoMetadata* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			PhotoMetadata* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			Dimensions _tmp35_ = {0};
			PhotoMetadata* _tmp36_ = NULL;
			Dimensions* _tmp37_ = NULL;
			Dimensions* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = metadata;
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = photo_metadata_get_exposure_string (_tmp23_);
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->exposure);
#line 207 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->exposure = _tmp24_;
#line 208 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = self->priv->exposure;
#line 208 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp25_ == NULL) {
#line 2146 "Properties.c"
				gchar* _tmp26_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp26_ = g_strdup ("");
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->exposure);
#line 209 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->exposure = _tmp26_;
#line 2154 "Properties.c"
			}
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp27_ = metadata;
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = photo_metadata_get_aperture_string (_tmp27_, TRUE);
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->aperture);
#line 211 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->aperture = _tmp28_;
#line 212 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = self->priv->aperture;
#line 212 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp29_ == NULL) {
#line 2168 "Properties.c"
				gchar* _tmp30_ = NULL;
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp30_ = g_strdup ("");
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->aperture);
#line 213 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->aperture = _tmp30_;
#line 2176 "Properties.c"
			}
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp31_ = metadata;
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = photo_metadata_get_iso_string (_tmp31_);
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->iso);
#line 215 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->iso = _tmp32_;
#line 216 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = self->priv->iso;
#line 216 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp33_ == NULL) {
#line 2190 "Properties.c"
				gchar* _tmp34_ = NULL;
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp34_ = g_strdup ("");
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (self->priv->iso);
#line 217 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->iso = _tmp34_;
#line 2198 "Properties.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp36_ = metadata;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp37_ = photo_metadata_get_pixel_dimensions (_tmp36_);
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp38_ = _tmp37_;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp39_ = _tmp38_ != NULL;
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			_dimensions_free0 (_tmp38_);
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp39_) {
#line 2212 "Properties.c"
				PhotoMetadata* _tmp40_ = NULL;
				Orientation _tmp41_ = 0;
				PhotoMetadata* _tmp42_ = NULL;
				Dimensions* _tmp43_ = NULL;
				Dimensions* _tmp44_ = NULL;
				Dimensions _tmp45_ = {0};
				Dimensions _tmp46_ = {0};
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp40_ = metadata;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp41_ = photo_metadata_get_orientation (_tmp40_);
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp42_ = metadata;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp43_ = photo_metadata_get_pixel_dimensions (_tmp42_);
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp44_ = _tmp43_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp45_ = *_tmp44_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				orientation_rotate_dimensions (_tmp41_, &_tmp45_, &_tmp46_);
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp35_ = _tmp46_;
#line 220 "/home/jens/Source/shotwell/src/Properties.vala"
				_dimensions_free0 (_tmp44_);
#line 2238 "Properties.c"
			} else {
#line 221 "/home/jens/Source/shotwell/src/Properties.vala"
				dimensions_init (&_tmp35_, 0, 0);
#line 2242 "Properties.c"
			}
#line 219 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->dimensions = _tmp35_;
#line 2246 "Properties.c"
		}
#line 224 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp47_ = source;
#line 224 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, TYPE_PHOTO_SOURCE)) {
#line 2252 "Properties.c"
			DataSource* _tmp48_ = NULL;
			Dimensions _tmp49_ = {0};
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp48_ = source;
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp49_);
#line 225 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->dimensions = _tmp49_;
#line 2261 "Properties.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp51_ = source;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, TYPE_PHOTO)) {
#line 2267 "Properties.c"
			DataSource* _tmp52_ = NULL;
			PhotoFileFormat _tmp53_ = 0;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp52_ = source;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp53_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_PHOTO, Photo));
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = _tmp53_ == PHOTO_FILE_FORMAT_RAW;
#line 2276 "Properties.c"
		} else {
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = FALSE;
#line 2280 "Properties.c"
		}
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp50_) {
#line 2284 "Properties.c"
			Photo* photo = NULL;
			DataSource* _tmp54_ = NULL;
			Photo* _tmp55_ = NULL;
			Photo* _tmp56_ = NULL;
			RawDeveloper _tmp57_ = 0;
			gchar* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			Photo* _tmp60_ = NULL;
			gboolean _tmp61_ = FALSE;
			gchar* _tmp63_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp54_ = source;
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, TYPE_PHOTO) ? ((Photo*) _tmp54_) : NULL);
#line 228 "/home/jens/Source/shotwell/src/Properties.vala"
			photo = _tmp55_;
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp56_ = photo;
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp57_ = photo_get_raw_developer (_tmp56_);
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp58_ = raw_developer_get_label (_tmp57_);
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->raw_developer);
#line 229 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->raw_developer = _tmp58_;
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = photo;
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = photo_is_raw_developer_available (_tmp60_, RAW_DEVELOPER_CAMERA);
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp61_) {
#line 2317 "Properties.c"
				const gchar* _tmp62_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp62_ = _ ("RAW+JPEG");
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp59_ = _tmp62_;
#line 2323 "Properties.c"
			} else {
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp59_ = "";
#line 2327 "Properties.c"
			}
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp63_ = g_strdup (_tmp59_);
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->raw_assoc);
#line 230 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->raw_assoc = _tmp63_;
#line 227 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 2337 "Properties.c"
		}
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (metadata);
#line 198 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (_tmp15_);
#line 2343 "Properties.c"
	} else {
		DataSource* _tmp64_ = NULL;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp64_ = source;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, TYPE_EVENT_SOURCE)) {
#line 2350 "Properties.c"
			EventSource* event_source = NULL;
			DataSource* _tmp65_ = NULL;
			EventSource* _tmp66_ = NULL;
			EventSource* _tmp67_ = NULL;
			time_t _tmp68_ = 0;
			EventSource* _tmp69_ = NULL;
			time_t _tmp70_ = 0;
			gint event_photo_count = 0;
			gint event_video_count = 0;
			EventSource* _tmp71_ = NULL;
			GeeCollection* _tmp72_ = NULL;
			GeeCollection* _tmp73_ = NULL;
			gint _tmp74_ = 0;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gint _tmp77_ = 0;
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp65_ = source;
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, TYPE_EVENT_SOURCE, EventSource));
#line 233 "/home/jens/Source/shotwell/src/Properties.vala"
			event_source = _tmp66_;
#line 235 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp67_ = event_source;
#line 235 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = event_source_get_start_time (_tmp67_);
#line 235 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->start_time = _tmp68_;
#line 236 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp69_ = event_source;
#line 236 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = event_source_get_end_time (_tmp69_);
#line 236 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->end_time = _tmp70_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = event_source;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp72_ = event_source_get_media (_tmp71_);
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp73_ = _tmp72_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			media_source_collection_count_media (_tmp73_, &_tmp74_, &_tmp75_);
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			event_photo_count = _tmp74_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			event_video_count = _tmp75_;
#line 240 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (_tmp73_);
#line 243 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp76_ = event_photo_count;
#line 243 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->photo_count = _tmp76_;
#line 244 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp77_ = event_video_count;
#line 244 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->video_count = _tmp77_;
#line 232 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (event_source);
#line 2409 "Properties.c"
		} else {
			gboolean _tmp78_ = FALSE;
			DataSource* _tmp79_ = NULL;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = source;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, TYPE_VIDEO_SOURCE)) {
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp78_ = TRUE;
#line 2419 "Properties.c"
			} else {
				DataSource* _tmp80_ = NULL;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp80_ = source;
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, TYPE_VIDEO_IMPORT_SOURCE);
#line 2426 "Properties.c"
			}
#line 245 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp78_) {
#line 2430 "Properties.c"
				DataSource* _tmp81_ = NULL;
				time_t _tmp94_ = 0;
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp81_ = source;
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, TYPE_VIDEO_SOURCE)) {
#line 2437 "Properties.c"
					Video* video = NULL;
					DataSource* _tmp82_ = NULL;
					Video* _tmp83_ = NULL;
					Video* _tmp84_ = NULL;
					gdouble _tmp85_ = 0.0;
					Video* _tmp86_ = NULL;
					gboolean _tmp87_ = FALSE;
					Video* _tmp90_ = NULL;
					time_t _tmp91_ = 0;
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp82_ = source;
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, TYPE_VIDEO, Video));
#line 247 "/home/jens/Source/shotwell/src/Properties.vala"
					video = _tmp83_;
#line 248 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp84_ = video;
#line 248 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp85_ = video_get_clip_duration (_tmp84_);
#line 248 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->clip_duration = _tmp85_;
#line 250 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp86_ = video;
#line 250 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp87_ = video_get_is_interpretable (_tmp86_);
#line 250 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp87_) {
#line 2465 "Properties.c"
						Video* _tmp88_ = NULL;
						Dimensions _tmp89_ = {0};
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp88_ = video;
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						video_get_frame_dimensions (_tmp88_, &_tmp89_);
#line 251 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->dimensions = _tmp89_;
#line 2474 "Properties.c"
					}
#line 253 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp90_ = video;
#line 253 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp91_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, TYPE_MEDIA_SOURCE, MediaSource));
#line 253 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->start_time = _tmp91_;
#line 246 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (video);
#line 2484 "Properties.c"
				} else {
					DataSource* _tmp92_ = NULL;
					time_t _tmp93_ = 0;
#line 255 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp92_ = source;
#line 255 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp93_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 255 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->start_time = _tmp93_;
#line 2494 "Properties.c"
				}
#line 257 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp94_ = self->priv->start_time;
#line 257 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->end_time = _tmp94_;
#line 2500 "Properties.c"
			}
		}
	}
#line 191 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (source);
#line 2506 "Properties.c"
}


static void basic_properties_real_get_multiple_properties (Properties* base, GeeIterable* iter) {
	BasicProperties * self;
	GeeIterable* _tmp0_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 261 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail ((iter == NULL) || GEE_IS_ITERABLE (iter));
#line 262 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = iter;
#line 262 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_multiple_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 264 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->photo_count = 0;
#line 265 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->video_count = 0;
#line 2525 "Properties.c"
	{
		GeeIterator* _view_it = NULL;
		GeeIterable* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = iter;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_view_it = _tmp2_;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		while (TRUE) {
#line 2538 "Properties.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DataView* view = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DataSource* source = NULL;
			DataView* _tmp7_ = NULL;
			DataSource* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			DataSource* _tmp10_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = _view_it;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			if (!_tmp4_) {
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
				break;
#line 2557 "Properties.c"
			}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp5_ = _view_it;
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			view = (DataView*) _tmp6_;
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp7_ = view;
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp8_ = data_view_get_source (_tmp7_);
#line 267 "/home/jens/Source/shotwell/src/Properties.vala"
			source = _tmp8_;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp10_ = source;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_PHOTO_SOURCE)) {
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp9_ = TRUE;
#line 2577 "Properties.c"
			} else {
				DataSource* _tmp11_ = NULL;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp11_ = source;
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_PHOTO_IMPORT_SOURCE);
#line 2584 "Properties.c"
			}
#line 269 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp9_) {
#line 2588 "Properties.c"
				time_t _tmp12_ = 0;
				DataSource* _tmp13_ = NULL;
				time_t exposure_time = 0;
				time_t _tmp18_ = 0;
				gint _tmp29_ = 0;
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp13_ = source;
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_PHOTO_SOURCE)) {
#line 2598 "Properties.c"
					DataSource* _tmp14_ = NULL;
					time_t _tmp15_ = 0;
#line 271 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp14_ = source;
#line 271 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp15_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 271 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp12_ = _tmp15_;
#line 2607 "Properties.c"
				} else {
					DataSource* _tmp16_ = NULL;
					time_t _tmp17_ = 0;
#line 272 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp16_ = source;
#line 272 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp17_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 272 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp12_ = _tmp17_;
#line 2617 "Properties.c"
				}
#line 270 "/home/jens/Source/shotwell/src/Properties.vala"
				exposure_time = _tmp12_;
#line 274 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp18_ = exposure_time;
#line 274 "/home/jens/Source/shotwell/src/Properties.vala"
				if (_tmp18_ != ((time_t) 0)) {
#line 2625 "Properties.c"
					gboolean _tmp19_ = FALSE;
					time_t _tmp20_ = 0;
					gboolean _tmp24_ = FALSE;
					time_t _tmp25_ = 0;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp20_ = self->priv->start_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp20_ == ((time_t) 0)) {
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp19_ = TRUE;
#line 2636 "Properties.c"
					} else {
						time_t _tmp21_ = 0;
						time_t _tmp22_ = 0;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp21_ = exposure_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp22_ = self->priv->start_time;
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp19_ = _tmp21_ < _tmp22_;
#line 2646 "Properties.c"
					}
#line 275 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp19_) {
#line 2650 "Properties.c"
						time_t _tmp23_ = 0;
#line 276 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp23_ = exposure_time;
#line 276 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->start_time = _tmp23_;
#line 2656 "Properties.c"
					}
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp25_ = self->priv->end_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp25_ == ((time_t) 0)) {
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp24_ = TRUE;
#line 2664 "Properties.c"
					} else {
						time_t _tmp26_ = 0;
						time_t _tmp27_ = 0;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp26_ = exposure_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp27_ = self->priv->end_time;
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp24_ = _tmp26_ > _tmp27_;
#line 2674 "Properties.c"
					}
#line 278 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp24_) {
#line 2678 "Properties.c"
						time_t _tmp28_ = 0;
#line 279 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp28_ = exposure_time;
#line 279 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->end_time = _tmp28_;
#line 2684 "Properties.c"
					}
				}
#line 282 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp29_ = self->priv->photo_count;
#line 282 "/home/jens/Source/shotwell/src/Properties.vala"
				self->priv->photo_count = _tmp29_ + 1;
#line 2691 "Properties.c"
			} else {
				DataSource* _tmp30_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp30_ = source;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, TYPE_EVENT_SOURCE)) {
#line 2698 "Properties.c"
					EventSource* event_source = NULL;
					DataSource* _tmp31_ = NULL;
					EventSource* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp35_ = FALSE;
					time_t _tmp36_ = 0;
					gboolean _tmp44_ = FALSE;
					gboolean _tmp45_ = FALSE;
					time_t _tmp46_ = 0;
					gint event_photo_count = 0;
					gint event_video_count = 0;
					EventSource* _tmp61_ = NULL;
					GeeCollection* _tmp62_ = NULL;
					GeeCollection* _tmp63_ = NULL;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp31_ = source;
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_EVENT_SOURCE, EventSource));
#line 284 "/home/jens/Source/shotwell/src/Properties.vala"
					event_source = _tmp32_;
#line 286 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp33_ = self->priv->event_count;
#line 286 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp33_ == -1) {
#line 287 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->event_count = 0;
#line 2733 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp36_ = self->priv->start_time;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp36_ == ((time_t) 0)) {
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp35_ = TRUE;
#line 2741 "Properties.c"
					} else {
						EventSource* _tmp37_ = NULL;
						time_t _tmp38_ = 0;
						time_t _tmp39_ = 0;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp37_ = event_source;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp38_ = event_source_get_start_time (_tmp37_);
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp39_ = self->priv->start_time;
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp35_ = _tmp38_ < _tmp39_;
#line 2754 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp35_) {
#line 2758 "Properties.c"
						EventSource* _tmp40_ = NULL;
						time_t _tmp41_ = 0;
#line 290 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp40_ = event_source;
#line 290 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp41_ = event_source_get_start_time (_tmp40_);
#line 290 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp34_ = _tmp41_ != ((time_t) 0);
#line 2767 "Properties.c"
					} else {
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp34_ = FALSE;
#line 2771 "Properties.c"
					}
#line 289 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp34_) {
#line 2775 "Properties.c"
						EventSource* _tmp42_ = NULL;
						time_t _tmp43_ = 0;
#line 291 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp42_ = event_source;
#line 291 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp43_ = event_source_get_start_time (_tmp42_);
#line 291 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->start_time = _tmp43_;
#line 2784 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp46_ = self->priv->end_time;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp46_ == ((time_t) 0)) {
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp45_ = TRUE;
#line 2792 "Properties.c"
					} else {
						EventSource* _tmp47_ = NULL;
						time_t _tmp48_ = 0;
						time_t _tmp49_ = 0;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp47_ = event_source;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp48_ = event_source_get_end_time (_tmp47_);
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp49_ = self->priv->end_time;
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp45_ = _tmp48_ > _tmp49_;
#line 2805 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp45_) {
#line 2809 "Properties.c"
						EventSource* _tmp50_ = NULL;
						time_t _tmp51_ = 0;
#line 294 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp50_ = event_source;
#line 294 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp51_ = event_source_get_end_time (_tmp50_);
#line 294 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp44_ = _tmp51_ != ((time_t) 0);
#line 2818 "Properties.c"
					} else {
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp44_ = FALSE;
#line 2822 "Properties.c"
					}
#line 293 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp44_) {
#line 2826 "Properties.c"
						EventSource* _tmp52_ = NULL;
						time_t _tmp53_ = 0;
#line 295 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp52_ = event_source;
#line 295 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp53_ = event_source_get_end_time (_tmp52_);
#line 295 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->end_time = _tmp53_;
#line 2835 "Properties.c"
					} else {
						gboolean _tmp54_ = FALSE;
						time_t _tmp55_ = 0;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp55_ = self->priv->end_time;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp55_ == ((time_t) 0)) {
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp54_ = TRUE;
#line 2845 "Properties.c"
						} else {
							EventSource* _tmp56_ = NULL;
							time_t _tmp57_ = 0;
							time_t _tmp58_ = 0;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp56_ = event_source;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp57_ = event_source_get_start_time (_tmp56_);
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp58_ = self->priv->end_time;
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp54_ = _tmp57_ > _tmp58_;
#line 2858 "Properties.c"
						}
#line 296 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp54_) {
#line 2862 "Properties.c"
							EventSource* _tmp59_ = NULL;
							time_t _tmp60_ = 0;
#line 297 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp59_ = event_source;
#line 297 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp60_ = event_source_get_start_time (_tmp59_);
#line 297 "/home/jens/Source/shotwell/src/Properties.vala"
							self->priv->end_time = _tmp60_;
#line 2871 "Properties.c"
						}
					}
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp61_ = event_source;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp62_ = event_source_get_media (_tmp61_);
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp63_ = _tmp62_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					media_source_collection_count_media (_tmp63_, &_tmp64_, &_tmp65_);
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					event_photo_count = _tmp64_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					event_video_count = _tmp65_;
#line 302 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (_tmp63_);
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp66_ = self->priv->photo_count;
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp67_ = event_photo_count;
#line 305 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->photo_count = _tmp66_ + _tmp67_;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp68_ = self->priv->video_count;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp69_ = event_video_count;
#line 306 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->video_count = _tmp68_ + _tmp69_;
#line 307 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp70_ = self->priv->event_count;
#line 307 "/home/jens/Source/shotwell/src/Properties.vala"
					self->priv->event_count = _tmp70_ + 1;
#line 283 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_object_unref0 (event_source);
#line 2906 "Properties.c"
				} else {
					gboolean _tmp71_ = FALSE;
					DataSource* _tmp72_ = NULL;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp72_ = source;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, TYPE_VIDEO_SOURCE)) {
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp71_ = TRUE;
#line 2916 "Properties.c"
					} else {
						DataSource* _tmp73_ = NULL;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp73_ = source;
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp71_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, TYPE_VIDEO_IMPORT_SOURCE);
#line 2923 "Properties.c"
					}
#line 308 "/home/jens/Source/shotwell/src/Properties.vala"
					if (_tmp71_) {
#line 2927 "Properties.c"
						time_t _tmp74_ = 0;
						DataSource* _tmp75_ = NULL;
						time_t exposure_time = 0;
						time_t _tmp80_ = 0;
						gint _tmp91_ = 0;
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp75_ = source;
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, TYPE_VIDEO_SOURCE)) {
#line 2937 "Properties.c"
							DataSource* _tmp76_ = NULL;
							time_t _tmp77_ = 0;
#line 310 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp76_ = source;
#line 310 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp77_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_VIDEO_SOURCE, VideoSource), TYPE_MEDIA_SOURCE, MediaSource));
#line 310 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp74_ = _tmp77_;
#line 2946 "Properties.c"
						} else {
							DataSource* _tmp78_ = NULL;
							time_t _tmp79_ = 0;
#line 311 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp78_ = source;
#line 311 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp79_ = import_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), TYPE_IMPORT_SOURCE, ImportSource));
#line 311 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp74_ = _tmp79_;
#line 2956 "Properties.c"
						}
#line 309 "/home/jens/Source/shotwell/src/Properties.vala"
						exposure_time = _tmp74_;
#line 313 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp80_ = exposure_time;
#line 313 "/home/jens/Source/shotwell/src/Properties.vala"
						if (_tmp80_ != ((time_t) 0)) {
#line 2964 "Properties.c"
							gboolean _tmp81_ = FALSE;
							time_t _tmp82_ = 0;
							gboolean _tmp86_ = FALSE;
							time_t _tmp87_ = 0;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp82_ = self->priv->start_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp82_ == ((time_t) 0)) {
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp81_ = TRUE;
#line 2975 "Properties.c"
							} else {
								time_t _tmp83_ = 0;
								time_t _tmp84_ = 0;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp83_ = exposure_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp84_ = self->priv->start_time;
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp81_ = _tmp83_ < _tmp84_;
#line 2985 "Properties.c"
							}
#line 314 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp81_) {
#line 2989 "Properties.c"
								time_t _tmp85_ = 0;
#line 315 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp85_ = exposure_time;
#line 315 "/home/jens/Source/shotwell/src/Properties.vala"
								self->priv->start_time = _tmp85_;
#line 2995 "Properties.c"
							}
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							_tmp87_ = self->priv->end_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp87_ == ((time_t) 0)) {
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp86_ = TRUE;
#line 3003 "Properties.c"
							} else {
								time_t _tmp88_ = 0;
								time_t _tmp89_ = 0;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp88_ = exposure_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp89_ = self->priv->end_time;
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp86_ = _tmp88_ > _tmp89_;
#line 3013 "Properties.c"
							}
#line 317 "/home/jens/Source/shotwell/src/Properties.vala"
							if (_tmp86_) {
#line 3017 "Properties.c"
								time_t _tmp90_ = 0;
#line 318 "/home/jens/Source/shotwell/src/Properties.vala"
								_tmp90_ = exposure_time;
#line 318 "/home/jens/Source/shotwell/src/Properties.vala"
								self->priv->end_time = _tmp90_;
#line 3023 "Properties.c"
							}
						}
#line 321 "/home/jens/Source/shotwell/src/Properties.vala"
						_tmp91_ = self->priv->video_count;
#line 321 "/home/jens/Source/shotwell/src/Properties.vala"
						self->priv->video_count = _tmp91_ + 1;
#line 3030 "Properties.c"
					}
				}
			}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (view);
#line 3038 "Properties.c"
		}
#line 266 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_view_it);
#line 3042 "Properties.c"
	}
}


static void basic_properties_real_get_properties (Properties* base, Page* current_page) {
	BasicProperties * self;
	Page* _tmp0_ = NULL;
	time_t _tmp1_ = 0;
	time_t _tmp3_ = 0;
#line 326 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 326 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (current_page));
#line 327 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = current_page;
#line 327 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->get_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 329 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = self->priv->end_time;
#line 329 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp1_ == ((time_t) 0)) {
#line 3064 "Properties.c"
		time_t _tmp2_ = 0;
#line 330 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp2_ = self->priv->start_time;
#line 330 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->end_time = _tmp2_;
#line 3070 "Properties.c"
	}
#line 331 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = self->priv->start_time;
#line 331 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp3_ == ((time_t) 0)) {
#line 3076 "Properties.c"
		time_t _tmp4_ = 0;
#line 332 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = self->priv->end_time;
#line 332 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->start_time = _tmp4_;
#line 3082 "Properties.c"
	}
}


static void basic_properties_real_internal_update_properties (Properties* base, Page* page) {
	BasicProperties * self;
	Page* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
	time_t _tmp43_ = 0;
	gboolean _tmp72_ = FALSE;
	gdouble _tmp84_ = 0.0;
	const gchar* _tmp90_ = NULL;
	const gchar* _tmp93_ = NULL;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	const gchar* _tmp97_ = NULL;
#line 335 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 335 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 336 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = page;
#line 336 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (basic_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = self->priv->title;
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp2_, "") == 0) {
#line 3115 "Properties.c"
		Page* _tmp3_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp3_ = page;
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_TAG_PAGE);
#line 3121 "Properties.c"
	} else {
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = FALSE;
#line 3125 "Properties.c"
	}
#line 339 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp1_) {
#line 3129 "Properties.c"
		Page* _tmp4_ = NULL;
		Tag* _tmp5_ = NULL;
		Tag* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = page;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = tag_page_get_tag (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TAG_PAGE, TagPage));
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = _tmp5_;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = tag_get_user_visible_name (_tmp6_);
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->title);
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->title = _tmp7_;
#line 340 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp6_);
#line 3148 "Properties.c"
	}
#line 342 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = self->priv->title;
#line 342 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp8_, "") != 0) {
#line 3154 "Properties.c"
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = _ ("Title:");
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = self->priv->title;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = guarded_markup_escape_text (_tmp10_);
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = _tmp11_;
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp9_, _tmp12_, FALSE);
#line 343 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp12_);
#line 3171 "Properties.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp14_ = self->priv->photo_count;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp14_ >= 0) {
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = TRUE;
#line 3179 "Properties.c"
	} else {
		gint _tmp15_ = 0;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = self->priv->video_count;
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = _tmp15_ >= 0;
#line 3186 "Properties.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp13_) {
#line 3190 "Properties.c"
		gchar* label = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* photo_num_string = NULL;
		gint _tmp26_ = 0;
		const gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gchar* _tmp29_ = NULL;
		gchar* video_num_string = NULL;
		gint _tmp30_ = 0;
		const gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		gint _tmp35_ = 0;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
#line 346 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = _ ("Items:");
#line 346 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 346 "/home/jens/Source/shotwell/src/Properties.vala"
		label = _tmp17_;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp18_ = self->priv->event_count;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp18_ >= 0) {
#line 3220 "Properties.c"
			gchar* event_num_string = NULL;
			gint _tmp19_ = 0;
			const gchar* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = self->priv->event_count;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = ngettext ("%d Event", "%d Events", (gulong) _tmp19_);
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = self->priv->event_count;
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 349 "/home/jens/Source/shotwell/src/Properties.vala"
			event_num_string = _tmp22_;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = label;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = event_num_string;
#line 352 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp23_, _tmp24_, FALSE);
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = g_strdup ("");
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 353 "/home/jens/Source/shotwell/src/Properties.vala"
			label = _tmp25_;
#line 348 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (event_num_string);
#line 3253 "Properties.c"
		}
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = self->priv->photo_count;
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = ngettext ("%d Photo", "%d Photos", (gulong) _tmp26_);
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp28_ = self->priv->photo_count;
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp29_ = g_strdup_printf (_tmp27_, _tmp28_);
#line 356 "/home/jens/Source/shotwell/src/Properties.vala"
		photo_num_string = _tmp29_;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp30_ = self->priv->video_count;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp31_ = ngettext ("%d Video", "%d Videos", (gulong) _tmp30_);
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp32_ = self->priv->video_count;
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp33_ = g_strdup_printf (_tmp31_, _tmp32_);
#line 358 "/home/jens/Source/shotwell/src/Properties.vala"
		video_num_string = _tmp33_;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp35_ = self->priv->photo_count;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp35_ == 0) {
#line 3279 "Properties.c"
			gint _tmp36_ = 0;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp36_ = self->priv->video_count;
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = _tmp36_ > 0;
#line 3285 "Properties.c"
		} else {
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = FALSE;
#line 3289 "Properties.c"
		}
#line 361 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp34_) {
#line 3293 "Properties.c"
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp37_ = label;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp38_ = video_num_string;
#line 362 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp37_, _tmp38_, FALSE);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (video_num_string);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (photo_num_string);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 363 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 3310 "Properties.c"
		}
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = label;
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp40_ = photo_num_string;
#line 366 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp39_, _tmp40_, FALSE);
#line 368 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = self->priv->video_count;
#line 368 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp41_ > 0) {
#line 3322 "Properties.c"
			const gchar* _tmp42_ = NULL;
#line 369 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp42_ = video_num_string;
#line 369 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp42_, FALSE);
#line 3328 "Properties.c"
		}
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (video_num_string);
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (photo_num_string);
#line 345 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (label);
#line 3336 "Properties.c"
	}
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp43_ = self->priv->start_time;
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp43_ != ((time_t) 0)) {
#line 3342 "Properties.c"
		gchar* start_date = NULL;
		time_t _tmp44_ = 0;
		struct tm _tmp45_ = {0};
		gchar* _tmp46_ = NULL;
		gchar* start_time = NULL;
		time_t _tmp47_ = 0;
		struct tm _tmp48_ = {0};
		gchar* _tmp49_ = NULL;
		gchar* end_date = NULL;
		time_t _tmp50_ = 0;
		struct tm _tmp51_ = {0};
		gchar* _tmp52_ = NULL;
		gchar* end_time = NULL;
		time_t _tmp53_ = 0;
		struct tm _tmp54_ = {0};
		gchar* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp44_ = self->priv->start_time;
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp44_, &_tmp45_);
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp46_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp45_);
#line 373 "/home/jens/Source/shotwell/src/Properties.vala"
		start_date = _tmp46_;
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp47_ = self->priv->start_time;
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp47_, &_tmp48_);
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp49_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp48_);
#line 374 "/home/jens/Source/shotwell/src/Properties.vala"
		start_time = _tmp49_;
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp50_ = self->priv->end_time;
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp50_, &_tmp51_);
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp52_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp51_);
#line 375 "/home/jens/Source/shotwell/src/Properties.vala"
		end_date = _tmp52_;
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp53_ = self->priv->end_time;
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp53_, &_tmp54_);
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp55_ = properties_get_prettyprint_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp54_);
#line 376 "/home/jens/Source/shotwell/src/Properties.vala"
		end_time = _tmp55_;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp56_ = start_date;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp57_ = end_date;
#line 378 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp56_, _tmp57_) == 0) {
#line 3399 "Properties.c"
			const gchar* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
#line 380 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp58_ = _ ("Date:");
#line 380 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = start_date;
#line 380 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp58_, _tmp59_, FALSE);
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp60_ = start_time;
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = end_time;
#line 382 "/home/jens/Source/shotwell/src/Properties.vala"
			if (g_strcmp0 (_tmp60_, _tmp61_) == 0) {
#line 3416 "Properties.c"
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
#line 384 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp62_ = _ ("Time:");
#line 384 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp63_ = start_time;
#line 384 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp62_, _tmp63_, FALSE);
#line 3425 "Properties.c"
			} else {
				const gchar* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
#line 387 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp64_ = _ ("From:");
#line 387 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp65_ = start_time;
#line 387 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp64_, _tmp65_, FALSE);
#line 388 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp66_ = _ ("To:");
#line 388 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp67_ = end_time;
#line 388 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp66_, _tmp67_, FALSE);
#line 3443 "Properties.c"
			}
		} else {
			const gchar* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
#line 392 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = _ ("From:");
#line 392 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp69_ = start_date;
#line 392 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp68_, _tmp69_, FALSE);
#line 393 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = _ ("To:");
#line 393 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = end_date;
#line 393 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp70_, _tmp71_, FALSE);
#line 3462 "Properties.c"
		}
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (end_time);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (end_date);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (start_time);
#line 372 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (start_date);
#line 3472 "Properties.c"
	}
#line 397 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp72_ = dimensions_has_area (&self->priv->dimensions);
#line 397 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp72_) {
#line 3478 "Properties.c"
		gchar* label = NULL;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gboolean _tmp75_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp73_ = _ ("Size:");
#line 398 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp74_ = g_strdup (_tmp73_);
#line 398 "/home/jens/Source/shotwell/src/Properties.vala"
		label = _tmp74_;
#line 400 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp75_ = dimensions_has_area (&self->priv->dimensions);
#line 400 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp75_) {
#line 3493 "Properties.c"
			const gchar* _tmp76_ = NULL;
			Dimensions _tmp77_ = {0};
			gint _tmp78_ = 0;
			Dimensions _tmp79_ = {0};
			gint _tmp80_ = 0;
			gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp76_ = label;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp77_ = self->priv->dimensions;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp78_ = _tmp77_.width;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = self->priv->dimensions;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp80_ = _tmp79_.height;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp81_ = g_strdup_printf ("%d &#215; %d", _tmp78_, _tmp80_);
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp82_ = _tmp81_;
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp76_, _tmp82_, FALSE);
#line 401 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp82_);
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp83_ = g_strdup ("");
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (label);
#line 402 "/home/jens/Source/shotwell/src/Properties.vala"
			label = _tmp83_;
#line 3526 "Properties.c"
		}
#line 397 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (label);
#line 3530 "Properties.c"
	}
#line 406 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp84_ = self->priv->clip_duration;
#line 406 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp84_ > 0.0) {
#line 3536 "Properties.c"
		const gchar* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		gdouble _tmp87_ = 0.0;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp85_ = _ ("Duration:");
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp86_ = _ ("%.1f seconds");
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp87_ = self->priv->clip_duration;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp88_ = g_strdup_printf (_tmp86_, _tmp87_);
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp89_ = _tmp88_;
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp85_, _tmp89_, FALSE);
#line 407 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp89_);
#line 3556 "Properties.c"
	}
#line 410 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp90_ = self->priv->raw_developer;
#line 410 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp90_, "") != 0) {
#line 3562 "Properties.c"
		const gchar* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp91_ = _ ("Developer:");
#line 411 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp92_ = self->priv->raw_developer;
#line 411 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp91_, _tmp92_, FALSE);
#line 3571 "Properties.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp93_ = self->priv->raw_assoc;
#line 415 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp93_, "") != 0) {
#line 3577 "Properties.c"
		const gchar* _tmp94_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp94_ = self->priv->raw_assoc;
#line 416 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp94_, FALSE);
#line 3583 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp97_ = self->priv->exposure;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp97_, "") != 0) {
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp96_ = TRUE;
#line 3591 "Properties.c"
	} else {
		const gchar* _tmp98_ = NULL;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp98_ = self->priv->aperture;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp96_ = g_strcmp0 (_tmp98_, "") != 0;
#line 3598 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp96_) {
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp95_ = TRUE;
#line 3604 "Properties.c"
	} else {
		const gchar* _tmp99_ = NULL;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp99_ = self->priv->iso;
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp95_ = g_strcmp0 (_tmp99_, "") != 0;
#line 3611 "Properties.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp95_) {
#line 3615 "Properties.c"
		gchar* line = NULL;
		const gchar* _tmp100_ = NULL;
		const gchar* _tmp103_ = NULL;
		gboolean _tmp112_ = FALSE;
		gboolean _tmp113_ = FALSE;
		const gchar* _tmp114_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/Properties.vala"
		line = NULL;
#line 422 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp100_ = self->priv->exposure;
#line 422 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp100_, "") != 0) {
#line 3628 "Properties.c"
			const gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp101_ = self->priv->exposure;
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp102_ = g_strdup (_tmp101_);
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (line);
#line 423 "/home/jens/Source/shotwell/src/Properties.vala"
			line = _tmp102_;
#line 3639 "Properties.c"
		}
#line 425 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp103_ = self->priv->aperture;
#line 425 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp103_, "") != 0) {
#line 3645 "Properties.c"
			const gchar* _tmp104_ = NULL;
#line 426 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp104_ = line;
#line 426 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp104_ != NULL) {
#line 3651 "Properties.c"
				const gchar* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				gchar* _tmp107_ = NULL;
				gchar* _tmp108_ = NULL;
				gchar* _tmp109_ = NULL;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp105_ = line;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp106_ = self->priv->aperture;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp107_ = g_strconcat (", ", _tmp106_, NULL);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp108_ = _tmp107_;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp109_ = g_strconcat (_tmp105_, _tmp108_, NULL);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp109_;
#line 427 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (_tmp108_);
#line 3673 "Properties.c"
			} else {
				const gchar* _tmp110_ = NULL;
				gchar* _tmp111_ = NULL;
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp110_ = self->priv->aperture;
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp111_ = g_strdup (_tmp110_);
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 429 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp111_;
#line 3685 "Properties.c"
			}
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp114_ = self->priv->exposure;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp114_, "") == 0) {
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp113_ = TRUE;
#line 3694 "Properties.c"
		} else {
			const gchar* _tmp115_ = NULL;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp115_ = self->priv->aperture;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp113_ = g_strcmp0 (_tmp115_, "") == 0;
#line 3701 "Properties.c"
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp113_) {
#line 3705 "Properties.c"
			const gchar* _tmp116_ = NULL;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp116_ = self->priv->iso;
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp112_ = g_strcmp0 (_tmp116_, "") != 0;
#line 3711 "Properties.c"
		} else {
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp112_ = FALSE;
#line 3715 "Properties.c"
		}
#line 433 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp112_) {
#line 3719 "Properties.c"
			const gchar* _tmp117_ = NULL;
			const gchar* _tmp125_ = NULL;
			const gchar* _tmp126_ = NULL;
#line 434 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp117_ = line;
#line 434 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp117_ != NULL) {
#line 3727 "Properties.c"
				const gchar* _tmp118_ = NULL;
				const gchar* _tmp119_ = NULL;
				gchar* _tmp120_ = NULL;
				gchar* _tmp121_ = NULL;
				gchar* _tmp122_ = NULL;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp118_ = line;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp119_ = self->priv->iso;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp120_ = g_strconcat (", " "ISO ", _tmp119_, NULL);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp121_ = _tmp120_;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp122_ = g_strconcat (_tmp118_, _tmp121_, NULL);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp122_;
#line 435 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (_tmp121_);
#line 3749 "Properties.c"
			} else {
				const gchar* _tmp123_ = NULL;
				gchar* _tmp124_ = NULL;
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp123_ = self->priv->iso;
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp124_ = g_strconcat ("ISO ", _tmp123_, NULL);
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				_g_free0 (line);
#line 437 "/home/jens/Source/shotwell/src/Properties.vala"
				line = _tmp124_;
#line 3761 "Properties.c"
			}
#line 439 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp125_ = _ ("Exposure:");
#line 439 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp126_ = line;
#line 439 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp125_, _tmp126_, FALSE);
#line 3769 "Properties.c"
		} else {
			const gchar* _tmp127_ = NULL;
			const gchar* _tmp130_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp127_ = line;
#line 442 "/home/jens/Source/shotwell/src/Properties.vala"
			if (_tmp127_ != NULL) {
#line 3777 "Properties.c"
				const gchar* _tmp128_ = NULL;
				const gchar* _tmp129_ = NULL;
#line 443 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp128_ = _ ("Exposure:");
#line 443 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp129_ = line;
#line 443 "/home/jens/Source/shotwell/src/Properties.vala"
				properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp128_, _tmp129_, FALSE);
#line 3786 "Properties.c"
			}
#line 446 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp130_ = self->priv->iso;
#line 446 "/home/jens/Source/shotwell/src/Properties.vala"
			if (g_strcmp0 (_tmp130_, "") != 0) {
#line 3792 "Properties.c"
				const gchar* _tmp131_ = NULL;
#line 447 "/home/jens/Source/shotwell/src/Properties.vala"
				_tmp131_ = line;
#line 447 "/home/jens/Source/shotwell/src/Properties.vala"
				if (_tmp131_ != NULL) {
#line 3798 "Properties.c"
					const gchar* _tmp132_ = NULL;
					gchar* _tmp133_ = NULL;
					gchar* _tmp134_ = NULL;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp132_ = self->priv->iso;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp133_ = g_strconcat ("ISO ", _tmp132_, NULL);
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp134_ = _tmp133_;
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), "", _tmp134_, FALSE);
#line 448 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_free0 (_tmp134_);
#line 3812 "Properties.c"
				} else {
					const gchar* _tmp135_ = NULL;
					const gchar* _tmp136_ = NULL;
					gchar* _tmp137_ = NULL;
					gchar* _tmp138_ = NULL;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp135_ = _ ("Exposure:");
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp136_ = self->priv->iso;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp137_ = g_strconcat ("ISO ", _tmp136_, NULL);
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_tmp138_ = _tmp137_;
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp135_, _tmp138_, FALSE);
#line 450 "/home/jens/Source/shotwell/src/Properties.vala"
					_g_free0 (_tmp138_);
#line 3830 "Properties.c"
				}
			}
		}
#line 418 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (line);
#line 3836 "Properties.c"
	}
}


static void basic_properties_class_init (BasicPropertiesClass * klass) {
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	basic_properties_parent_class = g_type_class_peek_parent (klass);
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (BasicPropertiesPrivate));
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = basic_properties_real_clear_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = basic_properties_real_get_single_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_multiple_properties = basic_properties_real_get_multiple_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_properties = basic_properties_real_get_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = basic_properties_real_internal_update_properties;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = basic_properties_finalize;
#line 3858 "Properties.c"
}


static void basic_properties_instance_init (BasicProperties * self) {
	time_t _tmp0_ = 0;
	time_t _tmp1_ = 0;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = BASIC_PROPERTIES_GET_PRIVATE (self);
#line 158 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = time (NULL);
#line 158 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->start_time = _tmp0_;
#line 159 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = time (NULL);
#line 159 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->end_time = _tmp1_;
#line 3875 "Properties.c"
}


static void basic_properties_finalize (GObject* obj) {
	BasicProperties * self;
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASIC_PROPERTIES, BasicProperties);
#line 157 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->title);
#line 164 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure);
#line 165 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->aperture);
#line 166 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->iso);
#line 168 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_developer);
#line 169 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->raw_assoc);
#line 156 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (basic_properties_parent_class)->finalize (obj);
#line 3897 "Properties.c"
}


GType basic_properties_get_type (void) {
	static volatile gsize basic_properties_type_id__volatile = 0;
	if (g_once_init_enter (&basic_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BasicPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicProperties), 0, (GInstanceInitFunc) basic_properties_instance_init, NULL };
		GType basic_properties_type_id;
		basic_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "BasicProperties", &g_define_type_info, 0);
		g_once_init_leave (&basic_properties_type_id__volatile, basic_properties_type_id);
	}
	return basic_properties_type_id__volatile;
}


static gboolean _gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = gtk_widget_hide_on_delete ((GtkWidget*) self);
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 3918 "Properties.c"
}


ExtendedPropertiesWindow* extended_properties_window_construct (GType object_type, GtkWindow* owner) {
	ExtendedPropertiesWindow * self = NULL;
	gboolean use_header = FALSE;
	GtkSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp5_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp6_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp7_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp8_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp9_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp10_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp11_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp12_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	ExtendedPropertiesWindowExtendedProperties* _tmp15_ = NULL;
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (GTK_IS_WINDOW (owner), NULL);
#line 637 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 637 "/home/jens/Source/shotwell/src/Properties.vala"
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), "gtk-dialogs-use-header", &use_header, NULL);
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = use_header;
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp2_) {
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = 1;
#line 3953 "Properties.c"
	} else {
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp1_ = 0;
#line 3957 "Properties.c"
	}
#line 638 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (ExtendedPropertiesWindow*) g_object_new (object_type, "use-header-bar", _tmp1_, NULL);
#line 640 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) (GDK_BUTTON_PRESS_MASK | GDK_KEY_PRESS_MASK));
#line 641 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_focus_on_map (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
#line 642 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_accept_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
#line 643 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 644 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _ ("Extended Information");
#line 644 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp3_);
#line 645 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_WIN_POS_CENTER);
#line 646 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = owner;
#line 646 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp4_);
#line 647 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
#line 649 "/home/jens/Source/shotwell/src/Properties.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _gtk_widget_hide_on_delete_gtk_widget_delete_event, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0);
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = extended_properties_window_extended_properties_new ();
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	g_object_ref_sink (_tmp5_);
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (self->priv->properties);
#line 651 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->properties = _tmp5_;
#line 652 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = self->priv->properties;
#line 652 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
#line 653 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = self->priv->properties;
#line 653 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
#line 654 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = self->priv->properties;
#line 654 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 655 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp9_ = self->priv->properties;
#line 655 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 656 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = self->priv->properties;
#line 656 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), 3);
#line 657 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp11_ = self->priv->properties;
#line 657 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), 3);
#line 658 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp12_ = self->priv->properties;
#line 658 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 3);
#line 659 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp13_ = self->priv->properties;
#line 659 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), 3);
#line 660 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp14_ = (GtkBox*) gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
#line 660 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp15_ = self->priv->properties;
#line 660 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_box_get_type (), GtkBox), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 4031 "Properties.c"
}


ExtendedPropertiesWindow* extended_properties_window_new (GtkWindow* owner) {
#line 635 "/home/jens/Source/shotwell/src/Properties.vala"
	return extended_properties_window_construct (TYPE_EXTENDED_PROPERTIES_WINDOW, owner);
#line 4038 "Properties.c"
}


static gboolean extended_properties_window_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ExtendedPropertiesWindow * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GdkEventButton* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GdkEventButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GdkEventButton* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	GdkEventButton* _tmp11_ = NULL;
	guint32 _tmp12_ = 0U;
#line 663 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 663 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 665 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = event;
#line 665 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_->button;
#line 665 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 4065 "Properties.c"
		gboolean _tmp2_ = FALSE;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
		if (GTK_WIDGET_CLASS (extended_properties_window_parent_class)->button_press_event != NULL) {
#line 4069 "Properties.c"
			GdkEventButton* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = event;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp4_ = GTK_WIDGET_CLASS (extended_properties_window_parent_class)->button_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp2_ = _tmp4_;
#line 4078 "Properties.c"
		} else {
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp2_ = TRUE;
#line 4082 "Properties.c"
		}
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
		result = _tmp2_;
#line 666 "/home/jens/Source/shotwell/src/Properties.vala"
		return result;
#line 4088 "Properties.c"
	}
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = event;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = _tmp5_->button;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = event;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = _tmp7_->x_root;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp9_ = event;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = _tmp9_->y_root;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp11_ = event;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp12_ = _tmp11_->time;
#line 668 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_window_begin_move_drag (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), (gint) _tmp6_, (gint) _tmp8_, (gint) _tmp10_, _tmp12_);
#line 670 "/home/jens/Source/shotwell/src/Properties.vala"
	result = TRUE;
#line 670 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 4112 "Properties.c"
}


static gboolean extended_properties_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	ExtendedPropertiesWindow * self;
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	AppWindow* _tmp3_ = NULL;
	AppWindow* _tmp4_ = NULL;
	GdkEventKey* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 673 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 673 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = event;
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = _tmp0_->keyval;
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = gdk_keyval_name (_tmp1_);
#line 675 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp2_, "Escape") == 0) {
#line 676 "/home/jens/Source/shotwell/src/Properties.vala"
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 677 "/home/jens/Source/shotwell/src/Properties.vala"
		result = TRUE;
#line 677 "/home/jens/Source/shotwell/src/Properties.vala"
		return result;
#line 4145 "Properties.c"
	}
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = app_window_get_instance ();
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = _tmp3_;
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = event;
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), "key-press-event", _tmp5_, &_tmp6_);
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = _tmp6_;
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (_tmp4_);
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	result = _tmp7_;
#line 680 "/home/jens/Source/shotwell/src/Properties.vala"
	return result;
#line 4163 "Properties.c"
}


void extended_properties_window_update_properties (ExtendedPropertiesWindow* self, Page* page) {
	ExtendedPropertiesWindowExtendedProperties* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 683 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_EXTENDED_PROPERTIES_WINDOW (self));
#line 683 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 684 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = self->priv->properties;
#line 684 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = page;
#line 684 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_update_properties (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PROPERTIES, Properties), _tmp1_);
#line 4180 "Properties.c"
}


static void extended_properties_window_real_show_all (GtkWidget* base) {
	ExtendedPropertiesWindow * self;
	ExtendedPropertiesWindowExtendedProperties* _tmp0_ = NULL;
#line 687 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 688 "/home/jens/Source/shotwell/src/Properties.vala"
	GTK_WIDGET_CLASS (extended_properties_window_parent_class)->show_all (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), gtk_widget_get_type (), GtkWidget));
#line 689 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = self->priv->properties;
#line 689 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_unselect_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PROPERTIES, Properties));
#line 690 "/home/jens/Source/shotwell/src/Properties.vala"
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 4197 "Properties.c"
}


static gpointer _dimensions_dup0 (gpointer self) {
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	return self ? dimensions_dup (self) : NULL;
#line 4204 "Properties.c"
}


static void extended_properties_window_extended_properties_real_clear_properties (Properties* base) {
	ExtendedPropertiesWindowExtendedProperties * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	Dimensions* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 492 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->clear_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties));
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = g_strdup ("");
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->file_path);
#line 494 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->file_path = _tmp0_;
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = g_strdup ("");
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->development_path);
#line 495 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->development_path = _tmp1_;
#line 496 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->is_raw = FALSE;
#line 497 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->filesize = (guint64) 0;
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	dimensions_init (&_tmp2_, 0, 0);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = _dimensions_dup0 (&_tmp2_);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	_dimensions_free0 (self->priv->original_dim);
#line 498 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->original_dim = _tmp3_;
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = g_strdup ("");
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_make);
#line 499 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->camera_make = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp5_ = g_strdup ("");
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_model);
#line 500 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->camera_model = _tmp5_;
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp6_ = g_strdup ("");
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->flash);
#line 501 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->flash = _tmp6_;
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp7_ = g_strdup ("");
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->focal_length);
#line 502 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->focal_length = _tmp7_;
#line 503 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_lat = (gdouble) -1;
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp8_ = g_strdup ("");
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_lat_ref);
#line 504 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_lat_ref = _tmp8_;
#line 505 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_long = (gdouble) -1;
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp9_ = g_strdup ("");
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_long_ref);
#line 506 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->gps_long_ref = _tmp9_;
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp10_ = g_strdup ("");
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->artist);
#line 507 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->artist = _tmp10_;
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp11_ = g_strdup ("");
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->copyright);
#line 508 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->copyright = _tmp11_;
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp12_ = g_strdup ("");
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->software);
#line 509 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->software = _tmp12_;
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp13_ = g_strdup ("");
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_bias);
#line 510 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_bias = _tmp13_;
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp14_ = g_strdup ("");
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_date);
#line 511 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_date = _tmp14_;
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp15_ = g_strdup ("");
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_time);
#line 512 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->exposure_time = _tmp15_;
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp16_ = g_strdup ("");
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->comment);
#line 513 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->comment = _tmp16_;
#line 4337 "Properties.c"
}


static void extended_properties_window_extended_properties_real_get_single_properties (Properties* base, DataView* view) {
	ExtendedPropertiesWindowExtendedProperties * self;
	DataView* _tmp0_ = NULL;
	DataSource* source = NULL;
	DataView* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	DataSource* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_DATA_VIEW (view));
#line 517 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = view;
#line 517 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->get_single_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 519 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = view;
#line 519 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp2_ = data_view_get_source (_tmp1_);
#line 519 "/home/jens/Source/shotwell/src/Properties.vala"
	source = _tmp2_;
#line 520 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp3_ = source;
#line 520 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp3_ == NULL) {
#line 521 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (source);
#line 521 "/home/jens/Source/shotwell/src/Properties.vala"
		return;
#line 4372 "Properties.c"
	}
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp4_ = source;
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MEDIA_SOURCE)) {
#line 4378 "Properties.c"
		MediaSource* media = NULL;
		DataSource* _tmp5_ = NULL;
		MediaSource* _tmp6_ = NULL;
		MediaSource* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		MediaSource* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		MediaSource* _tmp15_ = NULL;
		guint64 _tmp16_ = 0ULL;
		Photo* photo = NULL;
		MediaSource* _tmp17_ = NULL;
		Photo* _tmp18_ = NULL;
		Photo* _tmp19_ = NULL;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp26_ = NULL;
		PhotoMetadata* _tmp27_ = NULL;
		MetadataDateTime* _tmp28_ = NULL;
		MetadataDateTime* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		Photo* _tmp36_ = NULL;
		PhotoFileFormat _tmp37_ = 0;
		PhotoMetadata* _tmp38_ = NULL;
		Dimensions* _tmp39_ = NULL;
		PhotoMetadata* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		PhotoMetadata* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		PhotoMetadata* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		PhotoMetadata* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		PhotoMetadata* _tmp48_ = NULL;
		gdouble _tmp49_ = 0.0;
		gchar* _tmp50_ = NULL;
		gdouble _tmp51_ = 0.0;
		gchar* _tmp52_ = NULL;
		gdouble _tmp53_ = 0.0;
		PhotoMetadata* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		PhotoMetadata* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		PhotoMetadata* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		PhotoMetadata* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		time_t exposure_time_obj = 0;
		PhotoMetadata* _tmp62_ = NULL;
		MetadataDateTime* _tmp63_ = NULL;
		MetadataDateTime* _tmp64_ = NULL;
		time_t _tmp65_ = 0;
		time_t _tmp66_ = 0;
		time_t _tmp67_ = 0;
		struct tm _tmp68_ = {0};
		gchar* _tmp69_ = NULL;
		time_t _tmp70_ = 0;
		struct tm _tmp71_ = {0};
		gchar* _tmp72_ = NULL;
		MediaSource* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp5_ = source;
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE, MediaSource));
#line 524 "/home/jens/Source/shotwell/src/Properties.vala"
		media = _tmp6_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp7_ = media;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp8_ = media_source_get_master_file (_tmp7_);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = _tmp8_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp10_ = g_file_get_path (_tmp9_);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->file_path);
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->file_path = _tmp10_;
#line 525 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp9_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = media;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp12_ = media_source_get_file (_tmp11_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp13_ = _tmp12_;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->development_path);
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->development_path = _tmp14_;
#line 526 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (_tmp13_);
#line 527 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = media;
#line 527 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = media_source_get_master_filesize (_tmp15_);
#line 527 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->filesize = _tmp16_;
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp17_ = media;
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_PHOTO) ? ((Photo*) _tmp17_) : NULL);
#line 532 "/home/jens/Source/shotwell/src/Properties.vala"
		photo = _tmp18_;
#line 533 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp19_ = photo;
#line 533 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp19_ == NULL) {
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 534 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4500 "Properties.c"
		}
		{
			PhotoMetadata* _tmp20_ = NULL;
			Photo* _tmp21_ = NULL;
			PhotoMetadata* _tmp22_ = NULL;
			PhotoMetadata* _tmp23_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp21_ = photo;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = photo_get_master_metadata (_tmp21_, &_inner_error_);
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = _tmp22_;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4515 "Properties.c"
				goto __catch432_g_error;
			}
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = _tmp20_;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = NULL;
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 543 "/home/jens/Source/shotwell/src/Properties.vala"
			metadata = _tmp23_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (_tmp20_);
#line 4528 "Properties.c"
		}
		goto __finally432;
		__catch432_g_error:
		{
			GError* e = NULL;
			Photo* _tmp24_ = NULL;
			PhotoMetadata* _tmp25_ = NULL;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			e = _inner_error_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_inner_error_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = photo;
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PHOTO_SOURCE, PhotoSource));
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 545 "/home/jens/Source/shotwell/src/Properties.vala"
			metadata = _tmp25_;
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_error_free0 (e);
#line 4550 "Properties.c"
		}
		__finally432:
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			g_clear_error (&_inner_error_);
#line 538 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4569 "Properties.c"
		}
#line 548 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp26_ = metadata;
#line 548 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp26_ == NULL) {
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_media_metadata_unref0 (metadata);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (photo);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (media);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (source);
#line 549 "/home/jens/Source/shotwell/src/Properties.vala"
			return;
#line 4585 "Properties.c"
		}
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp27_ = metadata;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp28_ = photo_metadata_get_exposure_date_time (_tmp27_);
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp29_ = _tmp28_;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp30_ = _tmp29_ == NULL;
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		_metadata_date_time_unref0 (_tmp29_);
#line 556 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp30_) {
#line 4599 "Properties.c"
			PhotoMetadata* _tmp31_ = NULL;
			Photo* _tmp32_ = NULL;
			time_t _tmp33_ = 0;
			MetadataDateTime* _tmp34_ = NULL;
			MetadataDateTime* _tmp35_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp31_ = metadata;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = photo;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp33_ = media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_MEDIA_SOURCE, MediaSource));
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = metadata_date_time_new (_tmp33_);
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp35_ = _tmp34_;
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			photo_metadata_set_exposure_date_time (_tmp31_, _tmp35_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 557 "/home/jens/Source/shotwell/src/Properties.vala"
			_metadata_date_time_unref0 (_tmp35_);
#line 4619 "Properties.c"
		}
#line 559 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = photo;
#line 559 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp37_ = photo_get_master_file_format (_tmp36_);
#line 559 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->is_raw = _tmp37_ == PHOTO_FILE_FORMAT_RAW;
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp38_ = metadata;
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = photo_metadata_get_pixel_dimensions (_tmp38_);
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		_dimensions_free0 (self->priv->original_dim);
#line 560 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->original_dim = _tmp39_;
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp40_ = metadata;
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp41_ = photo_metadata_get_camera_make (_tmp40_);
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->camera_make);
#line 561 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->camera_make = _tmp41_;
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = metadata;
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp43_ = photo_metadata_get_camera_model (_tmp42_);
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->camera_model);
#line 562 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->camera_model = _tmp43_;
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp44_ = metadata;
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp45_ = photo_metadata_get_flash_string (_tmp44_);
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->flash);
#line 563 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->flash = _tmp45_;
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp46_ = metadata;
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp47_ = photo_metadata_get_focal_length_string (_tmp46_);
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->focal_length);
#line 564 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->focal_length = _tmp47_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp48_ = metadata;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		photo_metadata_get_gps (_tmp48_, &_tmp49_, &_tmp50_, &_tmp51_, &_tmp52_, &_tmp53_);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_long = _tmp49_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->gps_long_ref);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_long_ref = _tmp50_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_lat = _tmp51_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->gps_lat_ref);
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_lat_ref = _tmp52_;
#line 565 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->gps_alt = _tmp53_;
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp54_ = metadata;
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp55_ = photo_metadata_get_artist (_tmp54_);
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->artist);
#line 566 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->artist = _tmp55_;
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp56_ = metadata;
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp57_ = photo_metadata_get_copyright (_tmp56_);
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->copyright);
#line 567 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->copyright = _tmp57_;
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp58_ = metadata;
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp59_ = photo_metadata_get_software (_tmp58_);
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->software);
#line 568 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->software = _tmp59_;
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp60_ = metadata;
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp61_ = photo_metadata_get_exposure_bias (_tmp60_);
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_bias);
#line 569 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_bias = _tmp61_;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp62_ = metadata;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp63_ = photo_metadata_get_exposure_date_time (_tmp62_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp64_ = _tmp63_;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp65_ = metadata_date_time_get_timestamp (_tmp64_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp66_ = _tmp65_;
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		_metadata_date_time_unref0 (_tmp64_);
#line 570 "/home/jens/Source/shotwell/src/Properties.vala"
		exposure_time_obj = _tmp66_;
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp67_ = exposure_time_obj;
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp67_, &_tmp68_);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp69_ = properties_get_prettyprint_date (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp68_);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_date);
#line 571 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_date = _tmp69_;
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp70_ = exposure_time_obj;
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		g_time_local (_tmp70_, &_tmp71_);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp72_ = properties_get_prettyprint_time_with_seconds (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), &_tmp71_);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->exposure_time);
#line 572 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->exposure_time = _tmp72_;
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp73_ = media;
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp74_ = media_source_get_comment (_tmp73_);
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (self->priv->comment);
#line 573 "/home/jens/Source/shotwell/src/Properties.vala"
		self->priv->comment = _tmp74_;
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_media_metadata_unref0 (metadata);
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (photo);
#line 523 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_object_unref0 (media);
#line 4765 "Properties.c"
	} else {
		DataSource* _tmp75_ = NULL;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp75_ = source;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, TYPE_EVENT_SOURCE)) {
#line 4772 "Properties.c"
			Event* event = NULL;
			DataSource* _tmp76_ = NULL;
			Event* _tmp77_ = NULL;
			Event* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp76_ = source;
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_EVENT, Event));
#line 575 "/home/jens/Source/shotwell/src/Properties.vala"
			event = _tmp77_;
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp78_ = event;
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_EVENT_SOURCE, EventSource));
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (self->priv->comment);
#line 576 "/home/jens/Source/shotwell/src/Properties.vala"
			self->priv->comment = _tmp79_;
#line 574 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_object_unref0 (event);
#line 4794 "Properties.c"
		}
	}
#line 516 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (source);
#line 4799 "Properties.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 4812 "Properties.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4843 "Properties.c"
				goto __catch433_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 4852 "Properties.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4868 "Properties.c"
				goto __catch433_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 4879 "Properties.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 4893 "Properties.c"
	}
	goto __finally433;
	__catch433_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4907 "Properties.c"
	}
	__finally433:
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 4918 "Properties.c"
	}
}


static void extended_properties_window_extended_properties_real_internal_update_properties (Properties* base, Page* page) {
	ExtendedPropertiesWindowExtendedProperties * self;
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp113_ = FALSE;
	const gchar* _tmp114_ = NULL;
	gboolean has_comment = FALSE;
	const gchar* _tmp116_ = NULL;
	gboolean _tmp117_ = FALSE;
	const gchar* _tmp119_ = NULL;
	gboolean _tmp120_ = FALSE;
#line 580 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 580 "/home/jens/Source/shotwell/src/Properties.vala"
	g_return_if_fail (IS_PAGE (page));
#line 581 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp0_ = page;
#line 581 "/home/jens/Source/shotwell/src/Properties.vala"
	PROPERTIES_CLASS (extended_properties_window_extended_properties_parent_class)->internal_update_properties (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp0_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp1_ = page;
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_EVENTS_DIRECTORY_PAGE)) {
#line 4946 "Properties.c"
	} else {
		gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		guint64 _tmp11_ = 0ULL;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gchar* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		Dimensions* _tmp21_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		gboolean _tmp56_ = FALSE;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gboolean _tmp62_ = FALSE;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		gboolean _tmp68_ = FALSE;
		const gchar* _tmp69_ = NULL;
		const gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gboolean _tmp74_ = FALSE;
		gboolean _tmp75_ = FALSE;
		gdouble _tmp76_ = 0.0;
		const gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gboolean _tmp85_ = FALSE;
		gboolean _tmp86_ = FALSE;
		gdouble _tmp87_ = 0.0;
		const gchar* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		gboolean _tmp96_ = FALSE;
		const gchar* _tmp97_ = NULL;
		const gchar* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		gboolean _tmp102_ = FALSE;
		const gchar* _tmp103_ = NULL;
		const gchar* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		gboolean _tmp108_ = FALSE;
		const gchar* _tmp109_ = NULL;
		const gchar* _tmp112_ = NULL;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp4_ = self->priv->file_path;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp4_, "") != 0) {
#line 5014 "Properties.c"
			const gchar* _tmp5_ = NULL;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp5_ = self->priv->file_path;
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = _tmp5_ != NULL;
#line 5020 "Properties.c"
		} else {
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp3_ = FALSE;
#line 5024 "Properties.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp3_) {
#line 5028 "Properties.c"
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp6_ = self->priv->file_path;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp7_ = string_replace (_tmp6_, "&", "&amp;");
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp2_);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp2_ = _tmp7_;
#line 5039 "Properties.c"
		} else {
			gchar* _tmp8_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp8_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp2_);
#line 587 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp2_ = _tmp8_;
#line 5048 "Properties.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp9_ = _ ("Location:");
#line 586 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp9_, _tmp2_, FALSE);
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp11_ = self->priv->filesize;
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp11_ > ((guint64) 0)) {
#line 5058 "Properties.c"
			guint64 _tmp12_ = 0ULL;
			gchar* _tmp13_ = NULL;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp12_ = self->priv->filesize;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp13_ = g_format_size_full ((guint64) ((gint64) _tmp12_), G_FORMAT_SIZE_DEFAULT);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp10_);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp10_ = _tmp13_;
#line 5069 "Properties.c"
		} else {
			gchar* _tmp14_ = NULL;
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp14_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp10_);
#line 590 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp10_ = _tmp14_;
#line 5078 "Properties.c"
		}
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp15_ = _ ("File size:");
#line 589 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp15_, _tmp10_, FALSE);
#line 592 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp16_ = self->priv->is_raw;
#line 592 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp16_) {
#line 5088 "Properties.c"
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
#line 593 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp17_ = _ ("Current Development:");
#line 593 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp18_ = self->priv->development_path;
#line 593 "/home/jens/Source/shotwell/src/Properties.vala"
			properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp17_, _tmp18_, FALSE);
#line 5097 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp21_ = self->priv->original_dim;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp21_ != NULL) {
#line 5103 "Properties.c"
			Dimensions* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp22_ = self->priv->original_dim;
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp23_ = dimensions_has_area (_tmp22_);
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = _tmp23_;
#line 5112 "Properties.c"
		} else {
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp20_ = FALSE;
#line 5116 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp20_) {
#line 5120 "Properties.c"
			Dimensions* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			Dimensions* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gchar* _tmp28_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp24_ = self->priv->original_dim;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp25_ = (*_tmp24_).width;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp26_ = self->priv->original_dim;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp27_ = (*_tmp26_).height;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp28_ = g_strdup_printf ("%d &#215; %d", _tmp25_, _tmp27_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp19_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = _tmp28_;
#line 5140 "Properties.c"
		} else {
			gchar* _tmp29_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp29_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp19_);
#line 596 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp19_ = _tmp29_;
#line 5149 "Properties.c"
		}
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp30_ = _ ("Original dimensions:");
#line 595 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp30_, _tmp19_, FALSE);
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp33_ = self->priv->camera_make;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp33_, "") != 0) {
#line 5159 "Properties.c"
			const gchar* _tmp34_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp34_ = self->priv->camera_make;
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = _tmp34_ != NULL;
#line 5165 "Properties.c"
		} else {
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp32_ = FALSE;
#line 5169 "Properties.c"
		}
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp32_) {
#line 5173 "Properties.c"
			const gchar* _tmp35_ = NULL;
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp35_ = self->priv->camera_make;
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp31_ = _tmp35_;
#line 5179 "Properties.c"
		} else {
#line 599 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp31_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5183 "Properties.c"
		}
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp36_ = _ ("Camera make:");
#line 598 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp36_, _tmp31_, FALSE);
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp39_ = self->priv->camera_model;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp39_, "") != 0) {
#line 5193 "Properties.c"
			const gchar* _tmp40_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp40_ = self->priv->camera_model;
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp38_ = _tmp40_ != NULL;
#line 5199 "Properties.c"
		} else {
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp38_ = FALSE;
#line 5203 "Properties.c"
		}
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp38_) {
#line 5207 "Properties.c"
			const gchar* _tmp41_ = NULL;
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp41_ = self->priv->camera_model;
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp37_ = _tmp41_;
#line 5213 "Properties.c"
		} else {
#line 602 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp37_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5217 "Properties.c"
		}
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp42_ = _ ("Camera model:");
#line 601 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp42_, _tmp37_, FALSE);
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp45_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp45_, "") != 0) {
#line 5227 "Properties.c"
			const gchar* _tmp46_ = NULL;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp46_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp44_ = _tmp46_ != NULL;
#line 5233 "Properties.c"
		} else {
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp44_ = FALSE;
#line 5237 "Properties.c"
		}
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp44_) {
#line 5241 "Properties.c"
			const gchar* _tmp47_ = NULL;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp47_ = self->priv->flash;
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp43_ = _tmp47_;
#line 5247 "Properties.c"
		} else {
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp43_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5251 "Properties.c"
		}
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp48_ = _ ("Flash:");
#line 604 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp48_, _tmp43_, FALSE);
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp51_ = self->priv->focal_length;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp51_, "") != 0) {
#line 5261 "Properties.c"
			const gchar* _tmp52_ = NULL;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp52_ = self->priv->focal_length;
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = _tmp52_ != NULL;
#line 5267 "Properties.c"
		} else {
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp50_ = FALSE;
#line 5271 "Properties.c"
		}
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp50_) {
#line 5275 "Properties.c"
			const gchar* _tmp53_ = NULL;
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp53_ = self->priv->focal_length;
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp49_ = _tmp53_;
#line 5281 "Properties.c"
		} else {
#line 607 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp49_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5285 "Properties.c"
		}
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp54_ = _ ("Focal length:");
#line 606 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp54_, _tmp49_, FALSE);
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp57_ = self->priv->exposure_date;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp57_, "") != 0) {
#line 5295 "Properties.c"
			const gchar* _tmp58_ = NULL;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp58_ = self->priv->exposure_date;
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp56_ = _tmp58_ != NULL;
#line 5301 "Properties.c"
		} else {
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp56_ = FALSE;
#line 5305 "Properties.c"
		}
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp56_) {
#line 5309 "Properties.c"
			const gchar* _tmp59_ = NULL;
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp59_ = self->priv->exposure_date;
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp55_ = _tmp59_;
#line 5315 "Properties.c"
		} else {
#line 610 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp55_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5319 "Properties.c"
		}
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp60_ = _ ("Exposure date:");
#line 609 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp60_, _tmp55_, FALSE);
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp63_ = self->priv->exposure_time;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp63_, "") != 0) {
#line 5329 "Properties.c"
			const gchar* _tmp64_ = NULL;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp64_ = self->priv->exposure_time;
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp62_ = _tmp64_ != NULL;
#line 5335 "Properties.c"
		} else {
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp62_ = FALSE;
#line 5339 "Properties.c"
		}
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp62_) {
#line 5343 "Properties.c"
			const gchar* _tmp65_ = NULL;
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp65_ = self->priv->exposure_time;
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = _tmp65_;
#line 5349 "Properties.c"
		} else {
#line 613 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp61_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5353 "Properties.c"
		}
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp66_ = _ ("Exposure time:");
#line 612 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp66_, _tmp61_, FALSE);
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp69_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp69_, "") != 0) {
#line 5363 "Properties.c"
			const gchar* _tmp70_ = NULL;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp70_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = _tmp70_ != NULL;
#line 5369 "Properties.c"
		} else {
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp68_ = FALSE;
#line 5373 "Properties.c"
		}
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp68_) {
#line 5377 "Properties.c"
			const gchar* _tmp71_ = NULL;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp71_ = self->priv->exposure_bias;
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp67_ = _tmp71_;
#line 5383 "Properties.c"
		} else {
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp67_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5387 "Properties.c"
		}
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp72_ = _ ("Exposure bias:");
#line 615 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp72_, _tmp67_, FALSE);
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp76_ = self->priv->gps_lat;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp76_ != ((gdouble) -1)) {
#line 5397 "Properties.c"
			const gchar* _tmp77_ = NULL;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp77_ = self->priv->gps_lat_ref;
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp75_ = g_strcmp0 (_tmp77_, "") != 0;
#line 5403 "Properties.c"
		} else {
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp75_ = FALSE;
#line 5407 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp75_) {
#line 5411 "Properties.c"
			const gchar* _tmp78_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp78_ = self->priv->gps_lat_ref;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp74_ = _tmp78_ != NULL;
#line 5417 "Properties.c"
		} else {
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp74_ = FALSE;
#line 5421 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp74_) {
#line 5425 "Properties.c"
			gdouble _tmp79_ = 0.0;
			const gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp79_ = self->priv->gps_lat;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp80_ = self->priv->gps_lat_ref;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp81_ = g_strdup_printf ("%f °%s", _tmp79_, _tmp80_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp73_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp73_ = _tmp81_;
#line 5439 "Properties.c"
		} else {
			gchar* _tmp82_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp82_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp73_);
#line 618 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp73_ = _tmp82_;
#line 5448 "Properties.c"
		}
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp83_ = _ ("GPS latitude:");
#line 617 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp83_, _tmp73_, FALSE);
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp87_ = self->priv->gps_long;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp87_ != ((gdouble) -1)) {
#line 5458 "Properties.c"
			const gchar* _tmp88_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp88_ = self->priv->gps_long_ref;
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp86_ = g_strcmp0 (_tmp88_, "") != 0;
#line 5464 "Properties.c"
		} else {
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp86_ = FALSE;
#line 5468 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp86_) {
#line 5472 "Properties.c"
			const gchar* _tmp89_ = NULL;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp89_ = self->priv->gps_long_ref;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp85_ = _tmp89_ != NULL;
#line 5478 "Properties.c"
		} else {
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp85_ = FALSE;
#line 5482 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp85_) {
#line 5486 "Properties.c"
			gdouble _tmp90_ = 0.0;
			const gchar* _tmp91_ = NULL;
			gchar* _tmp92_ = NULL;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp90_ = self->priv->gps_long;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp91_ = self->priv->gps_long_ref;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp92_ = g_strdup_printf ("%f °%s", _tmp90_, _tmp91_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp84_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp84_ = _tmp92_;
#line 5500 "Properties.c"
		} else {
			gchar* _tmp93_ = NULL;
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp93_ = g_strdup (EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_g_free0 (_tmp84_);
#line 621 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp84_ = _tmp93_;
#line 5509 "Properties.c"
		}
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp94_ = _ ("GPS longitude:");
#line 620 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp94_, _tmp84_, FALSE);
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp97_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp97_, "") != 0) {
#line 5519 "Properties.c"
			const gchar* _tmp98_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp98_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp96_ = _tmp98_ != NULL;
#line 5525 "Properties.c"
		} else {
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp96_ = FALSE;
#line 5529 "Properties.c"
		}
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp96_) {
#line 5533 "Properties.c"
			const gchar* _tmp99_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp99_ = self->priv->artist;
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp95_ = _tmp99_;
#line 5539 "Properties.c"
		} else {
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp95_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5543 "Properties.c"
		}
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp100_ = _ ("Artist:");
#line 623 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp100_, _tmp95_, FALSE);
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp103_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp103_, "") != 0) {
#line 5553 "Properties.c"
			const gchar* _tmp104_ = NULL;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp104_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp102_ = _tmp104_ != NULL;
#line 5559 "Properties.c"
		} else {
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp102_ = FALSE;
#line 5563 "Properties.c"
		}
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp102_) {
#line 5567 "Properties.c"
			const gchar* _tmp105_ = NULL;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp105_ = self->priv->copyright;
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp101_ = _tmp105_;
#line 5573 "Properties.c"
		} else {
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp101_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5577 "Properties.c"
		}
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp106_ = _ ("Copyright:");
#line 625 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp106_, _tmp101_, FALSE);
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp109_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		if (g_strcmp0 (_tmp109_, "") != 0) {
#line 5587 "Properties.c"
			const gchar* _tmp110_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp110_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp108_ = _tmp110_ != NULL;
#line 5593 "Properties.c"
		} else {
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp108_ = FALSE;
#line 5597 "Properties.c"
		}
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		if (_tmp108_) {
#line 5601 "Properties.c"
			const gchar* _tmp111_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp111_ = self->priv->software;
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp107_ = _tmp111_;
#line 5607 "Properties.c"
		} else {
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
			_tmp107_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5611 "Properties.c"
		}
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp112_ = _ ("Software:");
#line 627 "/home/jens/Source/shotwell/src/Properties.vala"
		properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp112_, _tmp107_, FALSE);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp84_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp73_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp19_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp10_);
#line 583 "/home/jens/Source/shotwell/src/Properties.vala"
		_g_free0 (_tmp2_);
#line 5627 "Properties.c"
	}
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp114_ = self->priv->comment;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	if (g_strcmp0 (_tmp114_, "") != 0) {
#line 5633 "Properties.c"
		const gchar* _tmp115_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp115_ = self->priv->comment;
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp113_ = _tmp115_ != NULL;
#line 5639 "Properties.c"
	} else {
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp113_ = FALSE;
#line 5643 "Properties.c"
	}
#line 630 "/home/jens/Source/shotwell/src/Properties.vala"
	has_comment = _tmp113_;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp117_ = has_comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	if (_tmp117_) {
#line 5651 "Properties.c"
		const gchar* _tmp118_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp118_ = self->priv->comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp116_ = _tmp118_;
#line 5657 "Properties.c"
	} else {
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
		_tmp116_ = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_NO_VALUE;
#line 5661 "Properties.c"
	}
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp119_ = _ ("Comment:");
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	_tmp120_ = has_comment;
#line 631 "/home/jens/Source/shotwell/src/Properties.vala"
	properties_add_line (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROPERTIES, Properties), _tmp119_, _tmp116_, _tmp120_);
#line 5669 "Properties.c"
}


static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_construct (GType object_type) {
	ExtendedPropertiesWindowExtendedProperties * self = NULL;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self = (ExtendedPropertiesWindowExtendedProperties*) properties_construct (object_type);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	return self;
#line 5679 "Properties.c"
}


static ExtendedPropertiesWindowExtendedProperties* extended_properties_window_extended_properties_new (void) {
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	return extended_properties_window_extended_properties_construct (EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES);
#line 5686 "Properties.c"
}


static void extended_properties_window_extended_properties_class_init (ExtendedPropertiesWindowExtendedPropertiesClass * klass) {
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	extended_properties_window_extended_properties_parent_class = g_type_class_peek_parent (klass);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (ExtendedPropertiesWindowExtendedPropertiesPrivate));
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->clear_properties = extended_properties_window_extended_properties_real_clear_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->get_single_properties = extended_properties_window_extended_properties_real_get_single_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	((PropertiesClass *) klass)->internal_update_properties = extended_properties_window_extended_properties_real_internal_update_properties;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = extended_properties_window_extended_properties_finalize;
#line 5703 "Properties.c"
}


static void extended_properties_window_extended_properties_instance_init (ExtendedPropertiesWindowExtendedProperties * self) {
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = EXTENDED_PROPERTIES_WINDOW_EXTENDED_PROPERTIES_GET_PRIVATE (self);
#line 5710 "Properties.c"
}


static void extended_properties_window_extended_properties_finalize (GObject* obj) {
	ExtendedPropertiesWindowExtendedProperties * self;
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EXTENDED_PROPERTIES_WINDOW_TYPE_EXTENDED_PROPERTIES, ExtendedPropertiesWindowExtendedProperties);
#line 463 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->file_path);
#line 465 "/home/jens/Source/shotwell/src/Properties.vala"
	_dimensions_free0 (self->priv->original_dim);
#line 466 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_make);
#line 467 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->camera_model);
#line 468 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->flash);
#line 469 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->focal_length);
#line 471 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_lat_ref);
#line 473 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->gps_long_ref);
#line 475 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->artist);
#line 476 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->copyright);
#line 477 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->software);
#line 478 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_bias);
#line 479 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_date);
#line 480 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->exposure_time);
#line 482 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->development_path);
#line 489 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_free0 (self->priv->comment);
#line 460 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (extended_properties_window_extended_properties_parent_class)->finalize (obj);
#line 5752 "Properties.c"
}


static GType extended_properties_window_extended_properties_get_type (void) {
	static volatile gsize extended_properties_window_extended_properties_type_id__volatile = 0;
	if (g_once_init_enter (&extended_properties_window_extended_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesWindowExtendedPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_window_extended_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedPropertiesWindowExtendedProperties), 0, (GInstanceInitFunc) extended_properties_window_extended_properties_instance_init, NULL };
		GType extended_properties_window_extended_properties_type_id;
		extended_properties_window_extended_properties_type_id = g_type_register_static (TYPE_PROPERTIES, "ExtendedPropertiesWindowExtendedProperties", &g_define_type_info, 0);
		g_once_init_leave (&extended_properties_window_extended_properties_type_id__volatile, extended_properties_window_extended_properties_type_id);
	}
	return extended_properties_window_extended_properties_type_id__volatile;
}


static void extended_properties_window_class_init (ExtendedPropertiesWindowClass * klass) {
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	extended_properties_window_parent_class = g_type_class_peek_parent (klass);
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	g_type_class_add_private (klass, sizeof (ExtendedPropertiesWindowPrivate));
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->button_press_event = extended_properties_window_real_button_press_event;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->key_press_event = extended_properties_window_real_key_press_event;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	((GtkWidgetClass *) klass)->show_all = extended_properties_window_real_show_all;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (klass)->finalize = extended_properties_window_finalize;
#line 5781 "Properties.c"
}


static void extended_properties_window_instance_init (ExtendedPropertiesWindow * self) {
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv = EXTENDED_PROPERTIES_WINDOW_GET_PRIVATE (self);
#line 458 "/home/jens/Source/shotwell/src/Properties.vala"
	self->priv->properties = NULL;
#line 5790 "Properties.c"
}


static void extended_properties_window_finalize (GObject* obj) {
	ExtendedPropertiesWindow * self;
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTENDED_PROPERTIES_WINDOW, ExtendedPropertiesWindow);
#line 458 "/home/jens/Source/shotwell/src/Properties.vala"
	_g_object_unref0 (self->priv->properties);
#line 457 "/home/jens/Source/shotwell/src/Properties.vala"
	G_OBJECT_CLASS (extended_properties_window_parent_class)->finalize (obj);
#line 5802 "Properties.c"
}


GType extended_properties_window_get_type (void) {
	static volatile gsize extended_properties_window_type_id__volatile = 0;
	if (g_once_init_enter (&extended_properties_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExtendedPropertiesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) extended_properties_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExtendedPropertiesWindow), 0, (GInstanceInitFunc) extended_properties_window_instance_init, NULL };
		GType extended_properties_window_type_id;
		extended_properties_window_type_id = g_type_register_static (gtk_dialog_get_type (), "ExtendedPropertiesWindow", &g_define_type_info, 0);
		g_once_init_leave (&extended_properties_window_type_id__volatile, extended_properties_window_type_id);
	}
	return extended_properties_window_type_id__volatile;
}



