/* Photo.c generated by valac 0.34.4, the Vala compiler
 * generated from Photo.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Specifies how pixel data is fetched from the backing file on disk.  MASTER is the original*/
/* backing photo of any supported photo file format; SOURCE is either the master or the editable*/
/* file, that is, the appropriate reference file for user display; BASELINE is an appropriate*/
/* file with the proviso that it may be a suitable substitute for the master and/or the editable.*/
/* UNMODIFIED represents the photo with no edits, i.e. the head of the pipeline.*/
/**/
/* In general, callers want to use the BASELINE unless requirements are specific.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <time.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
typedef struct _ParamSpecPhotoImportParams ParamSpecPhotoImportParams;

#define TYPE_PHOTO_TRANSFORMATION_STATE (photo_transformation_state_get_type ())
#define PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState))
#define PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))
#define IS_PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TRANSFORMATION_STATE))
#define IS_PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TRANSFORMATION_STATE))
#define PHOTO_TRANSFORMATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))

typedef struct _PhotoTransformationState PhotoTransformationState;
typedef struct _PhotoTransformationStateClass PhotoTransformationStateClass;
typedef struct _PhotoTransformationStatePrivate PhotoTransformationStatePrivate;

#define TYPE_RATING (rating_get_type ())

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define PHOTO_TYPE_BACKING_READERS (photo_backing_readers_get_type ())
#define PHOTO_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders))
#define PHOTO_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))
#define PHOTO_IS_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_IS_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_BACKING_READERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))

typedef struct _PhotoBackingReaders PhotoBackingReaders;
typedef struct _PhotoBackingReadersClass PhotoBackingReadersClass;

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;

#define TYPE_PIXEL_TRANSFORMATION_BUNDLE (pixel_transformation_bundle_get_type ())
#define PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle))
#define PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))
#define IS_PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define IS_PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))

typedef struct _PixelTransformationBundle PixelTransformationBundle;
typedef struct _PixelTransformationBundleClass PixelTransformationBundleClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define PHOTO_TYPE_CACHED_PIXBUF (photo_cached_pixbuf_get_type ())
#define PHOTO_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbuf))
#define PHOTO_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))
#define PHOTO_IS_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_IS_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_CACHED_PIXBUF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))

typedef struct _PhotoCachedPixbuf PhotoCachedPixbuf;
typedef struct _PhotoCachedPixbufClass PhotoCachedPixbufClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _photo_backing_readers_unref0(var) ((var == NULL) ? NULL : (var = (photo_backing_readers_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoBackingReadersPrivate PhotoBackingReadersPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
#define _photo_file_interrogator_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_interrogator_unref (var), NULL)))

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL (photo_reimport_master_state_impl_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))

typedef struct _PhotoReimportMasterStateImpl PhotoReimportMasterStateImpl;
typedef struct _PhotoReimportMasterStateImplClass PhotoReimportMasterStateImplClass;
typedef struct _PhotoReimportMasterStatePrivate PhotoReimportMasterStatePrivate;
typedef struct _PhotoReimportMasterStateImplPrivate PhotoReimportMasterStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL (photo_reimport_editable_state_impl_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))

typedef struct _PhotoReimportEditableStateImpl PhotoReimportEditableStateImpl;
typedef struct _PhotoReimportEditableStateImplClass PhotoReimportEditableStateImplClass;
typedef struct _PhotoReimportEditableStatePrivate PhotoReimportEditableStatePrivate;
typedef struct _PhotoReimportEditableStateImplPrivate PhotoReimportEditableStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (photo_reimport_raw_development_state_impl_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))

typedef struct _PhotoReimportRawDevelopmentStateImpl PhotoReimportRawDevelopmentStateImpl;
typedef struct _PhotoReimportRawDevelopmentStateImplClass PhotoReimportRawDevelopmentStateImplClass;

#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT (photo_reimport_raw_development_state_impl_dev_to_reimport_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))

typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimport PhotoReimportRawDevelopmentStateImplDevToReimport;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass PhotoReimportRawDevelopmentStateImplDevToReimportClass;
typedef struct _PhotoReimportRawDevelopmentStatePrivate PhotoReimportRawDevelopmentStatePrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplPrivate PhotoReimportRawDevelopmentStateImplPrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportPrivate PhotoReimportRawDevelopmentStateImplDevToReimportPrivate;
#define _photo_reimport_raw_development_state_impl_dev_to_reimport_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_impl_dev_to_reimport_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))

#define TYPE_PIXEL_TRANSFORMATION_TYPE (pixel_transformation_type_get_type ())

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL (photo_photo_transformation_state_impl_get_type ())
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))

typedef struct _PhotoPhotoTransformationStateImpl PhotoPhotoTransformationStateImpl;
typedef struct _PhotoPhotoTransformationStateImplClass PhotoPhotoTransformationStateImplClass;

#define EDITING_TOOLS_TYPE_REDEYE_INSTANCE (editing_tools_redeye_instance_get_type ())
typedef struct _EditingToolsRedeyeInstance EditingToolsRedeyeInstance;
typedef struct _PhotoCachedPixbufPrivate PhotoCachedPixbufPrivate;
#define _photo_cached_pixbuf_unref0(var) ((var == NULL) ? NULL : (var = (photo_cached_pixbuf_unref (var), NULL)))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _PhotoPhotoTransformationStateImplPrivate PhotoPhotoTransformationStateImplPrivate;
typedef struct _PhotoParamSpecBackingReaders PhotoParamSpecBackingReaders;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PhotoParamSpecCachedPixbuf PhotoParamSpecCachedPixbuf;
typedef struct _PhotoParamSpecReimportMasterState PhotoParamSpecReimportMasterState;
typedef struct _PhotoParamSpecReimportEditableState PhotoParamSpecReimportEditableState;
typedef struct _PhotoParamSpecReimportRawDevelopmentState PhotoParamSpecReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;
typedef struct _LibraryPhotoSourceCollectionPrivate LibraryPhotoSourceCollectionPrivate;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (library_photo_source_holding_tank_get_type ())
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))

typedef struct _LibraryPhotoSourceHoldingTank LibraryPhotoSourceHoldingTank;
typedef struct _LibraryPhotoSourceHoldingTankClass LibraryPhotoSourceHoldingTankClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;
typedef struct _LibraryPhotoPrivate LibraryPhotoPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;
typedef struct _LibraryPhotoSourceHoldingTankPrivate LibraryPhotoSourceHoldingTankPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

struct _ImportID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

struct _ParamSpecPhotoImportParams {
	GParamSpec parent_instance;
};

struct _PhotoTransformationState {
	GObject parent_instance;
	PhotoTransformationStatePrivate * priv;
};

struct _PhotoTransformationStateClass {
	GObjectClass parent_class;
	void (*broken) (PhotoTransformationState* self);
};

struct _PhotoTransformationStatePrivate {
	gboolean is_broke;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoPrivate {
	time_t cached_exposure_time;
	GRecMutex __lock_row;
	BackingPhotoRow* editable;
	PhotoBackingReaders* readers;
	GRecMutex __lock_readers;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gchar* file_title;
	GFileMonitor* editable_monitor;
	OneShotScheduler* reimport_editable_scheduler;
	OneShotScheduler* update_editable_attributes_scheduler;
	OneShotScheduler* remove_editable_scheduler;
	GeeHashMap* developments;
	GRecMutex __lock_developments;
};

struct _PhotoID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _PhotoBackingReaders {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoBackingReadersPrivate * priv;
	PhotoFileReader* master;
	PhotoFileReader* developer;
	PhotoFileReader* editable;
};

struct _PhotoBackingReadersClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoBackingReaders *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

struct _PhotoReimportMasterState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportMasterStatePrivate * priv;
};

struct _PhotoReimportMasterStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportMasterState *self);
};

struct _PhotoReimportMasterStateImpl {
	PhotoReimportMasterState parent_instance;
	PhotoReimportMasterStateImplPrivate * priv;
	PhotoRow* row;
	PhotoMetadata* metadata;
	gchar** alterations;
	gint alterations_length1;
	gint _alterations_size_;
	gboolean metadata_only;
};

struct _PhotoReimportMasterStateImplClass {
	PhotoReimportMasterStateClass parent_class;
};

struct _PhotoReimportEditableState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportEditableStatePrivate * priv;
};

struct _PhotoReimportEditableStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportEditableState *self);
};

struct _PhotoReimportEditableStateImpl {
	PhotoReimportEditableState parent_instance;
	PhotoReimportEditableStateImplPrivate * priv;
	BackingPhotoRow* backing_state;
	PhotoMetadata* metadata;
	gboolean metadata_only;
};

struct _PhotoReimportEditableStateImplClass {
	PhotoReimportEditableStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStatePrivate * priv;
};

struct _PhotoReimportRawDevelopmentStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentState *self);
};

struct _PhotoReimportRawDevelopmentStateImpl {
	PhotoReimportRawDevelopmentState parent_instance;
	PhotoReimportRawDevelopmentStateImplPrivate * priv;
	GeeCollection* list;
	gboolean metadata_only;
};

struct _PhotoReimportRawDevelopmentStateImplClass {
	PhotoReimportRawDevelopmentStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStateImplDevToReimportPrivate * priv;
	BackingPhotoRow* backing;
	PhotoMetadata* metadata;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentStateImplDevToReimport *self);
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

typedef enum  {
	PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION,
	PIXEL_TRANSFORMATION_TYPE_SHADOWS,
	PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS,
	PIXEL_TRANSFORMATION_TYPE_TEMPERATURE,
	PIXEL_TRANSFORMATION_TYPE_TINT,
	PIXEL_TRANSFORMATION_TYPE_SATURATION,
	PIXEL_TRANSFORMATION_TYPE_EXPOSURE,
	PIXEL_TRANSFORMATION_TYPE_CONTRAST
} PixelTransformationType;

struct _EditingToolsRedeyeInstance {
	GdkPoint center;
	gint radius;
};

struct _PhotoCachedPixbuf {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoCachedPixbufPrivate * priv;
	Photo* photo;
	GdkPixbuf* pixbuf;
	GTimer* last_touched;
};

struct _PhotoCachedPixbufClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoCachedPixbuf *self);
};

typedef void (*OneShotCallback) (void* user_data);
struct _PhotoPhotoTransformationStateImpl {
	PhotoTransformationState parent_instance;
	PhotoPhotoTransformationStateImplPrivate * priv;
};

struct _PhotoPhotoTransformationStateImplClass {
	PhotoTransformationStateClass parent_class;
};

struct _PhotoPhotoTransformationStateImplPrivate {
	Photo* photo;
	Orientation orientation;
	GeeHashMap* transformations;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
};

struct _PhotoParamSpecBackingReaders {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecCachedPixbuf {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportMasterState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportEditableState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportRawDevelopmentState {
	GParamSpec parent_instance;
};

struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _LibraryPhotoSourceCollection {
	MediaSourceCollection parent_instance;
	LibraryPhotoSourceCollectionPrivate * priv;
};

struct _LibraryPhotoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
	void (*notify_master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
};

struct _LibraryPhotoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeHashMap* by_editable_file;
	GeeHashMap* by_raw_development_file;
	GeeMultiMap* filesize_to_photo;
	GeeHashMap* photo_to_master_filesize;
	GeeHashMap* photo_to_editable_filesize;
	GeeMultiMap* photo_to_raw_development_filesize;
};

typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);
struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _LibraryPhoto {
	Photo parent_instance;
	LibraryPhotoPrivate * priv;
};

struct _LibraryPhotoClass {
	PhotoClass parent_class;
};

struct _LibraryPhotoPrivate {
	gboolean block_thumbnail_generation;
	OneShotScheduler* thumbnail_scheduler;
	GeeCollection* import_keywords;
};

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTank {
	MediaSourceHoldingTank parent_instance;
	LibraryPhotoSourceHoldingTankPrivate * priv;
};

struct _LibraryPhotoSourceHoldingTankClass {
	MediaSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTankPrivate {
	GeeHashMap* editable_file_map;
	GeeHashMap* development_file_map;
	GeeMultiMap* reverse_editable_file_map;
	GeeMultiMap* reverse_development_file_map;
};


static gpointer photo_import_params_parent_class = NULL;
static gpointer photo_transformation_state_parent_class = NULL;
static gpointer photo_parent_class = NULL;
static GeeLinkedList* photo_source_pixbuf_cache;
static GRecMutex __lock_photo_source_pixbuf_cache = {0};
static GeeLinkedList* photo_source_pixbuf_cache = NULL;
static guint photo_discard_source_id;
static guint photo_discard_source_id = (guint) 0;
static gboolean photo__develop_raw_photos_to_files;
static gboolean photo__develop_raw_photos_to_files = FALSE;
static gpointer photo_photo_transformation_state_impl_parent_class = NULL;
static gpointer photo_backing_readers_parent_class = NULL;
static gpointer photo_cached_pixbuf_parent_class = NULL;
static gpointer photo_reimport_master_state_parent_class = NULL;
static gpointer photo_reimport_master_state_impl_parent_class = NULL;
static gpointer photo_reimport_editable_state_parent_class = NULL;
static gpointer photo_reimport_editable_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = NULL;
static DateableIface* photo_dateable_parent_iface = NULL;
static gpointer library_photo_source_collection_parent_class = NULL;
static gpointer library_photo_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
LibraryPhotoSourceCollection* library_photo_global = NULL;
extern TagSourceCollection* tag_global;
static FlaggableIface* library_photo_flaggable_parent_iface = NULL;
static MonitorableIface* library_photo_monitorable_parent_iface = NULL;
static gpointer library_photo_source_holding_tank_parent_class = NULL;

GType backing_fetch_mode_get_type (void) G_GNUC_CONST;
gpointer photo_import_params_ref (gpointer instance);
void photo_import_params_unref (gpointer instance);
GParamSpec* param_spec_photo_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_import_params (GValue* value, gpointer v_object);
void value_take_photo_import_params (GValue* value, gpointer v_object);
gpointer value_get_photo_import_params (const GValue* value);
GType photo_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_row (GValue* value, gpointer v_object);
void value_take_photo_row (GValue* value, gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_IMPORT_PARAMS_DUMMY_PROPERTY
};
PhotoRow* photo_row_new (void);
PhotoRow* photo_row_construct (GType object_type);
PhotoImportParams* photo_import_params_new (GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_construct (GType object_type, GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file, ImportID* import_id);
PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type, GFile* file, ImportID* import_id);
static void photo_import_params_finalize (PhotoImportParams* obj);
GType photo_transformation_state_get_type (void) G_GNUC_CONST;
#define PHOTO_TRANSFORMATION_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStatePrivate))
enum  {
	PHOTO_TRANSFORMATION_STATE_DUMMY_PROPERTY
};
PhotoTransformationState* photo_transformation_state_construct (GType object_type);
gboolean photo_transformation_state_is_broken (PhotoTransformationState* self);
static void photo_transformation_state_real_broken (PhotoTransformationState* self);
static void photo_transformation_state_finalize (GObject* obj);
GType rating_get_type (void) G_GNUC_CONST;
gboolean rating_can_increase (Rating self);
gboolean rating_can_decrease (Rating self);
gboolean rating_is_valid (Rating self);
Rating rating_increase (Rating self);
Rating rating_decrease (Rating self);
gint rating_serialize (Rating self);
Rating rating_unserialize (gint value);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType photo_source_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType rotation_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
static gpointer photo_backing_readers_ref (gpointer instance);
static void photo_backing_readers_unref (gpointer instance);
static GParamSpec* photo_param_spec_backing_readers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_backing_readers (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_backing_readers (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_backing_readers (const GValue* value) G_GNUC_UNUSED;
static GType photo_backing_readers_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformer (GValue* value, gpointer v_object);
void value_take_pixel_transformer (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_bundle_ref (gpointer instance);
void pixel_transformation_bundle_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object);
void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation_bundle (const GValue* value);
GType pixel_transformation_bundle_get_type (void) G_GNUC_CONST;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value, gpointer v_object);
void value_take_one_shot_scheduler (GValue* value, gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
#define PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO, PhotoPrivate))
enum  {
	PHOTO_DUMMY_PROPERTY
};
gboolean photo_exception_prohibits (PhotoException self, PhotoException exception);
gboolean photo_exception_allows (PhotoException self, PhotoException exception);
static gpointer photo_cached_pixbuf_ref (gpointer instance);
static void photo_cached_pixbuf_unref (gpointer instance);
static GParamSpec* photo_param_spec_cached_pixbuf (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_cached_pixbuf (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_cached_pixbuf (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_cached_pixbuf (const GValue* value) G_GNUC_UNUSED;
static GType photo_cached_pixbuf_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
static PhotoBackingReaders* photo_backing_readers_new (void);
static PhotoBackingReaders* photo_backing_readers_construct (GType object_type);
#define PHOTO_TYPENAME "thumb"
#define PHOTO_SCALING_FUDGE 64
#define PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC 10
#define PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT 1
#define PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT 3
#define PHOTO_MIN_EMBEDDED_SIZE 1024
Photo* photo_construct (GType object_type, PhotoRow* row);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
PhotoSource* photo_source_construct (GType object_type, gint64 object_id);
gchar* media_source_prep_title (const gchar* title);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
GType orientation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
gchar* media_source_prep_comment (const gchar* comment);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
gchar* string_sliced_at_last_char (const gchar* haystack, gunichar ch, gint start_index);
gchar* string_sliced_at (const gchar* str, gint index);
gboolean is_string_empty (const gchar* s);
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
static BackingPhotoRow* photo_get_backing_row (Photo* self, BackingPhotoID* id);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
PhotoTable* photo_table_get_instance (void);
GQuark database_error_quark (void);
void photo_table_detach_editable (PhotoTable* self, PhotoRow* row, GError** error);
static void photo_internal_remove_all_transformations (Photo* self, gboolean notify);
RawDeveloper* raw_developer_as_array (int* result_length1);
void photo_init_photo (void);
void photo_terminate_photo (void);
void photo_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
static void photo_real_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
void photo_notify_raw_development_modified (Photo* self);
static void photo_real_notify_raw_development_modified (Photo* self);
void photo_notify_baseline_replaced (Photo* self);
static void photo_real_notify_baseline_replaced (Photo* self);
void photo_notify_master_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_master_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_editable_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_editable_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_source_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_source_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static gboolean photo_real_internal_delete_backing (DataSource* base, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static void photo_detach_editable (Photo* self, gboolean delete_editable, gboolean remove_transformations, gboolean notify);
PhotoFileFormat photo_get_master_file_format (Photo* self);
static gboolean photo_delete_raw_development (Photo* self, RawDeveloper d);
gchar* data_object_to_string (DataObject* self);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
GType backing_photo_table_get_type (void) G_GNUC_CONST;
BackingPhotoTable* backing_photo_table_get_instance (void);
BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self, BackingPhotoID* id, GError** error);
void backing_photo_table_remove (BackingPhotoTable* self, BackingPhotoID* backing_id, GError** error);
gboolean photo_is_raw_developer_complete (Photo* self, RawDeveloper d);
gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d);
PhotoMetadata* photo_get_master_metadata (Photo* self, GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result);
void photo_add_backing_photo_for_development (Photo* self, RawDeveloper d, BackingPhotoRow* bpr, GError** error);
void photo_import_developed_backing_photo (PhotoRow* row, RawDeveloper d, BackingPhotoRow* bpr, GError** error);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
gpointer photo_file_interrogator_ref (gpointer instance);
void photo_file_interrogator_unref (gpointer instance);
GParamSpec* param_spec_photo_file_interrogator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_interrogator (GValue* value, gpointer v_object);
void value_take_photo_file_interrogator (GValue* value, gpointer v_object);
gpointer value_get_photo_file_interrogator (const GValue* value);
GType photo_file_interrogator_get_type (void) G_GNUC_CONST;
PhotoFileInterrogator* photo_file_interrogator_new (GFile* file, PhotoFileSnifferOptions options);
PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
void photo_file_interrogator_interrogate (PhotoFileInterrogator* self, GError** error);
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void backing_photo_table_add (BackingPhotoTable* self, BackingPhotoRow* state, GError** error);
void photo_table_update_raw_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, BackingPhotoID* backing_photo_id, GError** error);
static void photo_develop_photo (Photo* self, RawDeveloper d);
BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error);
GdkPixbuf* photo_get_master_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error);
void scaling_for_original (Scaling* result);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
GType jpeg_quality_get_type (void) G_GNUC_CONST;
void photo_file_writer_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error);
void photo_set_default_raw_developer (Photo* self, RawDeveloper d);
void photo_set_raw_developer (Photo* self, RawDeveloper d);
GdkPixbuf* photo_get_prefetched_copy (Photo* self, GError** error);
void photo_revert_to_master (Photo* self, gboolean notify);
gboolean photo_set_orientation (Photo* self, Orientation orientation);
void photo_discard_prefetched (Photo* self);
RawDeveloper photo_get_raw_developer (Photo* self);
gchar* raw_developer_to_string (RawDeveloper self);
void photo_table_remove_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, GError** error);
void photo_redevelop_raw (Photo* self, RawDeveloper d);
static BackingFileState** photo_real_get_backing_files_state (MediaSource* base, int* result_length1);
BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row, const gchar* md5);
BackingFileState* backing_file_state_construct_from_photo_row (GType object_type, BackingPhotoRow* photo_row, const gchar* md5);
static void _vala_array_add85 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
gboolean photo_has_editable (Photo* self);
static void _vala_array_add86 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
gboolean photo_is_developed (Photo* self);
GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
static void _vala_array_add87 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
static PhotoFileReader* photo_get_backing_reader (Photo* self, BackingFetchMode mode);
static PhotoFileReader* photo_get_master_reader (Photo* self);
static PhotoFileReader* photo_get_baseline_reader (Photo* self);
static PhotoFileReader* photo_get_source_reader (Photo* self);
static PhotoFileReader* photo_get_raw_developer_reader (Photo* self);
const gchar* backing_fetch_mode_to_string (BackingFetchMode self);
PhotoFileReader* photo_get_editable_reader (Photo* self);
gboolean photo_does_master_exist (Photo* self);
gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self);
gboolean photo_does_editable_exist (Photo* self);
gboolean photo_is_master_baseline (Photo* self);
gboolean photo_is_master_source (Photo* self);
gboolean photo_is_editable_baseline (Photo* self);
gboolean photo_is_editable_source (Photo* self);
BackingPhotoRow* photo_get_master_photo_row (Photo* self);
BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
gboolean backing_photo_id_is_valid (BackingPhotoID *self);
BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self, RawDeveloper d);
PhotoFileFormat* photo_get_editable_file_format (Photo* self);
PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
PhotoFileFormat photo_get_export_format_for_parameters (Photo* self, ExportFormatParameters* params);
PhotoFileFormat photo_file_format_get_system_default_format (void);
PhotoFileFormat photo_get_best_export_file_format (Photo* self);
gchar* photo_get_export_basename_for_parameters (Photo* self, ExportFormatParameters* params);
GFile* media_source_get_master_file (MediaSource* self);
gchar* photo_get_export_basename (Photo* self, PhotoFileFormat* file_format);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult photo_prepare_for_import (PhotoImportParams* params);
gboolean photo_is_file_image (GFile* file);
gboolean photo_file_format_is_file_supported (GFile* file);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
Rating photo_metadata_get_rating (PhotoMetadata* self);
#define PHOTO_ID_INVALID ((gint64) -1)
void photo_id_init (PhotoID *self, gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails, PhotoFileReader* reader, Orientation orientation, Dimensions* original_dim, GError** error);
ImportResult import_result_convert_error (GError* err, ImportResult default_result);
void photo_create_pre_import (PhotoImportParams* params);
void dimensions_init (Dimensions *self, gint width, gint height);
BackingPhotoRow* photo_query_backing_photo_row (Photo* self, GFile* file, PhotoFileSnifferOptions options, DetectedPhotoInformation** detected, GError** error);
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState** reimport_state, GError** error);
static void _vala_array_add88 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add89 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add90 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add91 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add92 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add93 (gchar*** array, int* length, int* size, gchar* value);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_new (PhotoRow* row, PhotoMetadata* metadata, gchar** alterations, int alterations_length1);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_construct (GType object_type, PhotoRow* row, PhotoMetadata* metadata, gchar** alterations, int alterations_length1);
static GType photo_reimport_master_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata);
static void photo_real_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata);
void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error);
void photo_table_reimport (PhotoTable* self, PhotoRow* row, GError** error);
void backing_photo_row_copy_from (BackingPhotoRow* self, BackingPhotoRow* from);
static void _vala_array_add94 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add95 (gchar*** array, int* length, int* size, gchar* value);
Alteration* alteration_new_from_array (gchar** array, int array_length1);
Alteration* alteration_construct_from_array (GType object_type, gchar** array, int array_length1);
static gboolean photo_verify_file_for_reimport (Photo* self, GFile* file, BackingPhotoRow** backing, DetectedPhotoInformation** detected, GError** error);
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_editable (Photo* self, PhotoReimportEditableState** state, GError** error);
GFile* photo_get_editable_file (Photo* self);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state, PhotoMetadata* metadata);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_construct (GType object_type, BackingPhotoRow* backing_state, PhotoMetadata* metadata);
static GType photo_reimport_editable_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_finish_reimport_editable (Photo* self, PhotoReimportEditableState* state, GError** error);
void photo_get_editable_id (Photo* self, BackingPhotoID* result);
gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
void backing_photo_table_update (BackingPhotoTable* self, BackingPhotoRow* row, GError** error);
void media_source_set_title (MediaSource* self, const gchar* title);
gboolean media_source_set_comment (MediaSource* self, const gchar* comment);
void media_source_set_rating (MediaSource* self, Rating rating);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type, const gchar* list);
gpointer photo_reimport_raw_development_state_ref (gpointer instance);
void photo_reimport_raw_development_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_raw_development_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_raw_development_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState** state, GError** error);
GeeCollection* photo_get_raw_developer_files (Photo* self);
static GType photo_reimport_raw_development_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_new (void);
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_construct (GType object_type);
static void photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self, BackingPhotoRow* backing, PhotoMetadata* metadata);
static gint photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self);
void photo_finish_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState* state, GError** error);
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance);
static GParamSpec* photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value) G_GNUC_UNUSED;
GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void) G_GNUC_CONST;
static gchar* photo_real_get_typename (DataSource* base);
static gint64 photo_real_get_instance_id (DataSource* base);
void photo_get_photo_id (Photo* self, PhotoID* result);
static gchar* photo_real_get_source_id (DataSource* base);
gchar* data_source_get_typename (DataSource* self);
gint64 data_source_get_instance_id (DataSource* self);
void photo_set_master_timestamp (Photo* self, GFileInfo* info);
void photo_table_update_timestamp (PhotoTable* self, PhotoID* photo_id, time_t timestamp, GError** error);
void app_window_database_error (GError* err);
void photo_update_editable_modification_time (Photo* self, GFileInfo* info, GError** error);
void backing_photo_table_update_timestamp (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, GError** error);
void photo_update_many_editable_timestamps (GeeMap* map, GError** error);
void database_table_begin_transaction (void);
void database_table_commit_transaction (GError** error);
static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_get_file_format (Photo* self);
gboolean photo_file_format_can_write_image (PhotoFileFormat self);
static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void scaling_for_best_fit (gint pixels, gboolean scale_up, Scaling* result);
static gboolean photo_is_extension_found (const gchar* basename, gchar** extensions, int extensions_length1);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
gboolean photo_is_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format);
gboolean photo_table_has_duplicate (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format);
PhotoID* photo_get_duplicate_ids (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, int* result_length1);
PhotoID* photo_table_get_duplicate_ids (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format, int* result_length1);
gint64 photo_get_photo_key (DataSource* source);
GType library_photo_get_type (void) G_GNUC_CONST;
static GFile* photo_real_get_file (MediaSource* base);
void photo_set_master_file (Photo* self, GFile* file);
void photo_table_set_filepath (PhotoTable* self, PhotoID* photo_id, const gchar* filepath, GError** error);
void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
static void _vala_array_add96 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add97 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add98 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add99 (gchar*** array, int* length, int* size, gchar* value);
void photo_set_editable_file (Photo* self, GFile* file);
void backing_photo_table_set_filepath (BackingPhotoTable* self, BackingPhotoID* id, const gchar* filepath, GError** error);
static void _vala_array_add100 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add101 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add102 (gchar*** array, int* length, int* size, gchar* value);
void photo_set_many_editable_file (GeeMap* map, GError** error);
GFile* photo_get_actual_file (Photo* self);
static GFile* photo_real_get_master_file (MediaSource* base);
GFile* photo_get_source_file (Photo* self);
gboolean photo_file_format_can_write (PhotoFileFormat self);
static time_t photo_real_get_timestamp (MediaSource* base);
static inline void photo_real_get_event_id (MediaSource* base, EventID* result);
gint64 photo_get_raw_event_id (Photo* self);
static void photo_real_get_import_id (MediaSource* base, ImportID* result);
static gchar* photo_real_get_master_md5 (MediaSource* base);
guint64 photo_get_flags (Photo* self);
static void photo_notify_flags_altered (Photo* self, Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self, Alteration* other);
guint64 photo_replace_flags (Photo* self, guint64 flags, Alteration* additional_alteration);
gboolean photo_table_replace_flags (PhotoTable* self, PhotoID* photo_id, guint64 flags);
gboolean photo_is_flag_set (Photo* self, guint64 mask);
gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector);
guint64 photo_add_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
guint64 media_source_internal_add_flags (guint64 flags, guint64 selector);
guint64 photo_remove_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector);
guint64 photo_add_remove_flags (Photo* self, guint64 add, guint64 remove, Alteration* additional_alteration);
void photo_add_remove_many_flags (GeeCollection* add, guint64 add_mask, Alteration* additional_add_alteration, GeeCollection* remove, guint64 remove_mask, Alteration* additional_remove_alteration, GError** error);
guint64 photo_toggle_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
gboolean photo_is_master_metadata_dirty (Photo* self);
void photo_set_master_metadata_dirty (Photo* self, gboolean dirty, GError** error);
void photo_table_set_metadata_dirty (PhotoTable* self, PhotoID* photo_id, gboolean dirty, GError** error);
static Rating photo_real_get_rating (MediaSource* base);
static void photo_real_set_rating (MediaSource* base, Rating rating);
gboolean photo_table_set_rating (PhotoTable* self, PhotoID* photo_id, Rating rating);
static void photo_real_increase_rating (MediaSource* base);
static void photo_real_decrease_rating (MediaSource* base);
static void photo_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks);
void photo_table_update_backlinks (PhotoTable* self, PhotoID* photo_id, const gchar* backlinks, GError** error);
static gboolean photo_real_set_event_id (MediaSource* base, EventID* event_id);
gboolean photo_table_set_event (PhotoTable* self, PhotoID* photo_id, EventID* event_id);
static gchar* photo_real_to_string (DataObject* base);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static gboolean photo_real_equals (DataSource* base, DataSource* source);
gboolean data_source_equals (DataSource* self, DataSource* source);
static void photo_file_exif_updated (Photo* self);
GFile* media_source_get_file (MediaSource* self);
gboolean photo_table_master_exif_updated (PhotoTable* self, PhotoID* photoID, gint64 filesize, glong timestamp, const gchar* md5, const gchar* exif_md5, const gchar* thumbnail_md5, PhotoRow* row);
static guint64 photo_real_get_filesize (MediaSource* base);
static guint64 photo_real_get_master_filesize (MediaSource* base);
guint64 photo_get_editable_filesize (Photo* self);
static time_t photo_real_get_exposure_time (Dateable* base);
static gchar* photo_real_get_basename (MediaSource* base);
static gchar* photo_real_get_title (MediaSource* base);
static gchar* photo_real_get_comment (MediaSource* base);
static void photo_real_set_title (MediaSource* base, const gchar* title);
gboolean photo_table_set_title (PhotoTable* self, PhotoID* photo_id, const gchar* new_title);
static gboolean photo_real_set_comment (MediaSource* base, const gchar* comment);
gboolean photo_table_set_comment (PhotoTable* self, PhotoID* photo_id, const gchar* new_comment);
void photo_set_import_id (Photo* self, ImportID* import_id);
void photo_table_set_import_id (PhotoTable* self, PhotoID* photo_id, ImportID* import_id, GError** error);
void photo_set_title_persistent (Photo* self, const gchar* title, GError** error);
gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option);
PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self, GError** error);
void library_monitor_blacklist_file (GFile* file, const gchar* reason);
void library_monitor_unblacklist_file (GFile* file);
void photo_set_comment_persistent (Photo* self, const gchar* comment, GError** error);
void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment, PhotoMetadataSetOption option);
static void photo_real_set_exposure_time (Dateable* base, time_t time);
gboolean photo_table_set_exposure_time (PhotoTable* self, PhotoID* photo_id, time_t time);
void photo_set_exposure_time_persistent (Photo* self, time_t time, GError** error);
void dateable_set_exposure_time (Dateable* self, time_t target_time);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type, time_t timestamp);
static void photo_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result);
void photo_get_raw_dimensions (Photo* self, Dimensions* result);
Orientation photo_get_orientation (Photo* self);
gboolean photo_get_straighten (Photo* self, gdouble* theta);
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
gboolean photo_get_crop (Photo* self, Box* crop, PhotoException exceptions);
void box_get_dimensions (Box *self, Dimensions* result);
static void photo_locked_create_adjustments_from_data (Photo* self);
PixelTransformationBundle* pixel_transformation_bundle_new (void);
PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type);
static KeyValueMap* photo_get_transformation (Photo* self, const gchar* name);
void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self);
void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store);
PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self);
PixelTransformationBundle* photo_get_color_adjustments (Photo* self);
PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self);
PixelTransformer* photo_get_pixel_transformer (Photo* self);
PixelTransformer* pixel_transformer_copy (PixelTransformer* self);
gboolean photo_has_color_adjustments (Photo* self);
static gboolean photo_has_transformation (Photo* self, const gchar* name);
GType pixel_transformation_type_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation (GValue* value, gpointer v_object);
void value_take_pixel_transformation (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
PixelTransformation* photo_get_color_adjustment (Photo* self, PixelTransformationType type);
PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type);
void photo_set_color_adjustments (Photo* self, PixelTransformationBundle* new_adjustments);
gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self);
static gboolean photo_remove_transformation (Photo* self, const gchar* name);
KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group);
GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self);
void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans);
PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self);
static gboolean photo_set_transformation (Photo* self, KeyValueMap* trans);
static PhotoMetadata* photo_real_get_metadata (PhotoSource* base);
PhotoMetadata* photo_get_editable_metadata (Photo* self, GError** error);
gboolean photo_persist_master_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportMasterState** state, GError** error);
void photo_finish_update_master_metadata (Photo* self, PhotoReimportMasterState* state, GError** error);
gboolean photo_persist_editable_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportEditableState** state, GError** error);
void photo_finish_update_editable_metadata (Photo* self, PhotoReimportEditableState* state, GError** error);
gboolean photo_has_transformations (Photo* self);
gboolean photo_only_metadata_changed (Photo* self);
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
gboolean photo_has_alterations (Photo* self);
gchar* media_source_get_comment (MediaSource* self);
gchar* media_source_get_title (MediaSource* self);
PhotoTransformationState* photo_save_transformation_state (Photo* self);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_new (Photo* photo, Orientation orientation, GeeHashMap* transformations, PixelTransformer* transformer, PixelTransformationBundle* adjustments);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_construct (GType object_type, Photo* photo, Orientation orientation, GeeHashMap* transformations, PixelTransformer* transformer, PixelTransformationBundle* adjustments);
static GType photo_photo_transformation_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gboolean photo_load_transformation_state (Photo* self, PhotoTransformationState* state);
static Orientation photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self);
static PixelTransformer* photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self);
static PixelTransformationBundle* photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self);
gboolean photo_table_set_transformation_state (PhotoTable* self, PhotoID* photo_id, Orientation orientation, GeeHashMap* transformations);
void photo_remove_all_transformations (Photo* self);
gboolean photo_table_remove_all_transformations (PhotoTable* self, PhotoID* photo_id);
gboolean photo_table_set_orientation (PhotoTable* self, PhotoID* photo_id, Orientation orientation);
Orientation photo_get_original_orientation (Photo* self);
gboolean photo_check_can_rotate (Photo* self);
void photo_rotate (Photo* self, Rotation rotation);
static void photo_real_rotate (Photo* self, Rotation rotation);
Orientation orientation_perform (Orientation self, Rotation rotation);
KeyValueMap* key_value_map_copy (KeyValueMap* self);
gchar* key_value_map_get_group (KeyValueMap* self);
gboolean photo_table_set_transformation (PhotoTable* self, PhotoID* photo_id, KeyValueMap* map);
gboolean photo_table_remove_transformation (PhotoTable* self, PhotoID* photo_id, const gchar* object);
gboolean photo_has_crop (Photo* self);
gboolean photo_get_raw_crop (Photo* self, Box* crop);
void box_init (Box *self, gint left, gint top, gint right, gint bottom);
gint key_value_map_get_int (KeyValueMap* self, const gchar* key, gint def);
static void photo_set_raw_crop (Photo* self, Box* crop);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type, const gchar* group);
void key_value_map_set_int (KeyValueMap* self, const gchar* key, gint value);
static gboolean photo_get_raw_straighten (Photo* self, gdouble* angle);
gdouble key_value_map_get_double (KeyValueMap* self, const gchar* key, gdouble def);
static void photo_set_raw_straighten (Photo* self, gdouble theta);
void key_value_map_set_double (KeyValueMap* self, const gchar* key, gdouble value);
GType editing_tools_redeye_instance_get_type (void) G_GNUC_CONST;
EditingToolsRedeyeInstance* editing_tools_redeye_instance_dup (const EditingToolsRedeyeInstance* self);
void editing_tools_redeye_instance_free (EditingToolsRedeyeInstance* self);
static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self, int* result_length1);
void key_value_map_get_point (KeyValueMap* self, const gchar* key, GdkPoint* def, GdkPoint* result);
gboolean photo_has_redeye_transformations (Photo* self);
void photo_add_redeye_instance (Photo* self, EditingToolsRedeyeInstance* redeye);
void key_value_map_set_point (KeyValueMap* self, const gchar* key, GdkPoint* point);
static gboolean photo_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport);
static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport);
gboolean scaling_is_unscaled (Scaling *self);
void orientation_rotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
void orientation_rotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
void box_get_scaled (Box *self, Dimensions* scaled, Box* result);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
gint box_get_width (Box *self);
gint box_get_height (Box *self);
void dimensions_get_scaled_similar (Dimensions *self, Dimensions* original, Dimensions* scaled, Dimensions* result);
void orientation_derotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
gboolean dimensions_has_area (Dimensions *self);
static GdkPixbuf* photo_load_raw_pixbuf (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self, GError** error);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, BackingFetchMode fetch_mode, GError** error);
GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf);
static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error);
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate, gboolean keep, GError** error);
static PhotoCachedPixbuf* photo_cached_pixbuf_new (Photo* photo, GdkPixbuf* pixbuf);
static PhotoCachedPixbuf* photo_cached_pixbuf_construct (GType object_type, Photo* photo, GdkPixbuf* pixbuf);
static gboolean photo_trim_source_pixbuf_cache (void);
static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self);
gboolean photo_get_develop_raw_photos_to_files (void);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
gboolean dimensions_equals (Dimensions *self, Dimensions* dim);
static GdkPixbuf* photo_do_redeye (Photo* self, GdkPixbuf* pixbuf, EditingToolsRedeyeInstance* inst);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle);
void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable);
gboolean photo_has_user_generated_metadata (Photo* self);
static gboolean photo_real_has_user_generated_metadata (Photo* self);
void photo_set_user_metadata_for_export (Photo* self, PhotoMetadata* metadata);
static void photo_real_set_user_metadata_for_export (Photo* self, PhotoMetadata* metadata);
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self, GFile* file);
static gboolean photo_export_fullsized_backing (Photo* self, GFile* file, gboolean export_metadata, GError** error);
PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self);
time_t media_source_get_exposure_time (MediaSource* self);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option);
void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation);
void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version);
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_clear (PhotoMetadata* self);
gboolean photo_is_export_required (Photo* self, Scaling* scaling, PhotoFileFormat export_format);
void photo_export (Photo* self, GFile* dest_file, Scaling* scaling, JpegQuality quality, PhotoFileFormat export_format, gboolean direct_copy_unmodified, gboolean export_metadata, GError** error);
const gchar* photo_file_format_to_string (PhotoFileFormat self);
void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag);
static GFile* photo_generate_new_editable_file (Photo* self, PhotoFileFormat* file_format, GError** error);
gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext);
gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
static gboolean photo_launch_editor (GFile* file, PhotoFileFormat file_format, GError** error);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void photo_open_with_raw_external_editor (Photo* self, GError** error);
void photo_open_with_external_editor (Photo* self, GError** error);
static void photo_halt_monitoring_editable (Photo* self);
static void photo_attach_editable (Photo* self, PhotoFileFormat file_format, GFile* file, GError** error);
static void photo_start_monitoring_editable (Photo* self, GFile* file, GError** error);
static void photo_on_editable_file_changed (Photo* self, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void photo_update_editable (Photo* self, gboolean only_attributes, PhotoFileReader* new_reader, GError** error);
static void photo_update_editable_attributes (Photo* self, GError** error);
void photo_reimport_editable (Photo* self, GError** error);
void photo_table_attach_editable (PhotoTable* self, PhotoRow* row, BackingPhotoID* editable_id, GError** error);
void backing_photo_table_update_attributes (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, gint64 filesize, GError** error);
static void _vala_array_add103 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add104 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add105 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add106 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add107 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add108 (gchar*** array, int* length, int* size, gchar* value);
void backing_photo_id_init (BackingPhotoID *self, gint64 id);
const gchar* g_file_monitor_event_to_string (GFileMonitorEvent self);
static void photo_on_reimport_editable (Photo* self);
static void _photo_on_reimport_editable_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target);
void one_shot_scheduler_after_timeout (OneShotScheduler* self, guint msec, gboolean reschedule);
static void photo_on_update_editable_attributes (Photo* self);
static void _photo_on_update_editable_attributes_one_shot_callback (gpointer self);
static void photo_on_remove_editable (Photo* self);
static void _photo_on_remove_editable_one_shot_callback (gpointer self);
void photo_get_original_dimensions (Photo* self, Dimensions* result);
void photo_get_master_dimensions (Photo* self, Dimensions* result);
void photo_set_crop (Photo* self, Box* crop);
void orientation_derotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
void photo_set_straighten (Photo* self, gdouble theta);
static GdkPixbuf* photo_red_reduce_pixel (Photo* self, GdkPixbuf* pixbuf, gint x, gint y);
void photo_unscaled_to_raw_point (Photo* self, GdkPoint* unscaled_point, GdkPoint* result);
void orientation_derotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result);
void photo_unscaled_to_raw_rect (Photo* self, GdkRectangle* unscaled_rect, GdkRectangle* result);
PixelTransformationBundle* photo_get_enhance_transformations (Photo* self);
PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf);
gboolean photo_enhance (Photo* self);
void photo_set_develop_raw_photos_to_files (gboolean value);
static void photo_real_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void photo_real_raw_development_modified (Photo* self);
static void photo_real_baseline_replaced (Photo* self);
static void photo_real_master_reimported (Photo* self, PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void photo_real_editable_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_source_reimported (Photo* self, PhotoMetadata* metadata);
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplPrivate))
enum  {
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_DUMMY_PROPERTY
};
static void photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self);
static void _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender, gpointer self);
static GeeHashMap* photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original);
static void photo_photo_transformation_state_impl_finalize (GObject* obj);
enum  {
	PHOTO_BACKING_READERS_DUMMY_PROPERTY
};
static void photo_backing_readers_finalize (PhotoBackingReaders* obj);
enum  {
	PHOTO_CACHED_PIXBUF_DUMMY_PROPERTY
};
static void photo_cached_pixbuf_finalize (PhotoCachedPixbuf* obj);
enum  {
	PHOTO_REIMPORT_MASTER_STATE_DUMMY_PROPERTY
};
PhotoReimportMasterState* photo_reimport_master_state_construct (GType object_type);
static void photo_reimport_master_state_finalize (PhotoReimportMasterState* obj);
enum  {
	PHOTO_REIMPORT_MASTER_STATE_IMPL_DUMMY_PROPERTY
};
static gchar** _vala_array_dup28 (gchar** self, int length);
static void photo_reimport_master_state_impl_finalize (PhotoReimportMasterState* obj);
enum  {
	PHOTO_REIMPORT_EDITABLE_STATE_DUMMY_PROPERTY
};
PhotoReimportEditableState* photo_reimport_editable_state_construct (GType object_type);
static void photo_reimport_editable_state_finalize (PhotoReimportEditableState* obj);
enum  {
	PHOTO_REIMPORT_EDITABLE_STATE_IMPL_DUMMY_PROPERTY
};
static void photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState* obj);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_DUMMY_PROPERTY
};
PhotoReimportRawDevelopmentState* photo_reimport_raw_development_state_construct (GType object_type);
static void photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState* obj);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DUMMY_PROPERTY
};
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing, PhotoMetadata* metadata);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type, BackingPhotoRow* backing, PhotoMetadata* metadata);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_DUMMY_PROPERTY
};
static void photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport* obj);
static void photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState* obj);
static void photo_finalize (GObject* obj);
static void _vala_photo_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_photo_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionPrivate))
enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_DUMMY_PROPERTY
};
GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST;
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint int64_compare (gint64* a, gint64* b);
static gint _int64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint64* _int64_dup (gint64* self);
gboolean int64_equal (gint64* a, gint64* b);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
LibraryPhotoSourceCollection* library_photo_source_collection_new (void);
LibraryPhotoSourceCollection* library_photo_source_collection_construct (GType object_type);
static gint64 _photo_get_photo_key_get_source_database_key (DataSource* source, gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self, DataSource* source, Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_construct (GType object_type, LibraryPhotoSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
GType library_photo_source_holding_tank_get_type (void) G_GNUC_CONST;
static MediaSourceHoldingTank* library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self, DataSource* source, Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
static MediaMonitor* library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable);
PhotoMonitor* photo_monitor_new (Workers* workers, GCancellable* cancellable);
PhotoMonitor* photo_monitor_construct (GType object_type, Workers* workers, GCancellable* cancellable);
GType photo_monitor_get_type (void) G_GNUC_CONST;
static gboolean library_photo_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
static gchar* library_photo_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file);
static void library_photo_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
static void library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self, Photo* photo, GFile* old_file, GFile* new_file);
static void _library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender, GFile* old_file, GFile* new_file, gpointer self);
static void library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self, Photo* _photo);
static void _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender, gpointer self);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
static void library_photo_source_collection_real_items_altered (DataCollection* base, GeeMap* items);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
static void library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base, GeeCollection* media_sources);
GType tag_get_type (void) G_GNUC_CONST;
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
GeeCollection* library_photo_get_import_keywords (LibraryPhoto* self);
gboolean hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self, const gchar* tag);
gchar* tag_prep_tag_name (const gchar* name);
gchar* hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self, const gchar* name);
Tag* tag_for_path (const gchar* name);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
void library_photo_clear_import_keywords (LibraryPhoto* self);
void tag_attach_many (Tag* self, GeeCollection* sources);
void media_source_collection_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media);
void library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static MediaSource* library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id);
LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self, PhotoID* photo_id);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
static MediaSource* library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base, const gchar* source_id);
MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id);
gint64 parse_int64 (const gchar* str, gint num_base);
static GeeCollection* library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id);
GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self, EventID* event_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self, gint64 key);
LibraryPhoto* library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self, GFile* file);
LibraryPhoto* library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self, GFile* file);
static void library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, GFileInfo* info, GeeCollection* matches_master, GeeCollection* matches_editable, GeeCollection* matches_development);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self, GFileInfo* info);
void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self, GFileInfo* info, GeeCollection* matches_master, GeeCollection* matches_editable, GeeCollection* matched_development);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
void library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self, const gchar* basename, gint64 filesize, PhotoID* result);
gint utf8_ci_compare (void* a, void* b);
gboolean library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self, const gchar* basename, gint64 filesize);
gboolean photo_id_is_valid (PhotoID *self);
LibraryPhoto* library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self, GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file);
LibraryPhoto* library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self, GFile* file);
LibraryPhoto* library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self, const gchar* md5);
MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self, const gchar* md5);
LibraryPhoto* library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self, GFile* file);
LibraryPhoto* library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self, const gchar* md5);
gint library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self);
gint source_holding_tank_get_count (SourceHoldingTank* self);
LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self, GFile* file, LibraryPhotoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file);
static gboolean library_photo_source_collection_real_has_backlink (SourceCollection* base, SourceBacklink* backlink);
gboolean source_collection_has_backlink (SourceCollection* self, SourceBacklink* backlink);
gboolean source_holding_tank_has_backlink (SourceHoldingTank* self, SourceBacklink* backlink);
static void library_photo_source_collection_real_remove_backlink (SourceCollection* base, SourceBacklink* backlink);
void source_holding_tank_remove_backlink (SourceHoldingTank* self, SourceBacklink* backlink);
void source_collection_remove_backlink (SourceCollection* self, SourceBacklink* backlink);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_finalize (DataCollection* obj);
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO, LibraryPhotoPrivate))
enum  {
	LIBRARY_PHOTO_DUMMY_PROPERTY
};
#define LIBRARY_PHOTO_FLAG_HIDDEN ((guint64) 0x0000000000000001)
#define LIBRARY_PHOTO_FLAG_FAVORITE ((guint64) 0x0000000000000002)
#define LIBRARY_PHOTO_FLAG_TRASH ((guint64) 0x0000000000000004)
#define LIBRARY_PHOTO_FLAG_OFFLINE ((guint64) 0x0000000000000008)
#define LIBRARY_PHOTO_FLAG_FLAGGED ((guint64) 0x0000000000000010)
static LibraryPhoto* library_photo_new (PhotoRow* row);
static LibraryPhoto* library_photo_construct (GType object_type, PhotoRow* row);
static void library_photo_generate_thumbnails (LibraryPhoto* self);
static void _library_photo_generate_thumbnails_one_shot_callback (gpointer self);
void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated);
static void library_photo_upgrade_rating_flags (LibraryPhoto* self, guint64 flags);
static LibraryPhoto* library_photo_new_from_import_params (PhotoImportParams* import_params);
static LibraryPhoto* library_photo_construct_from_import_params (GType object_type, PhotoImportParams* import_params);
void library_photo_init (ProgressMonitor monitor, void* monitor_target);
GeeArrayList* photo_table_get_all (PhotoTable* self);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources);
void library_photo_terminate (void);
ImportResult library_photo_import_create (PhotoImportParams* params, LibraryPhoto** photo);
void photo_table_add (PhotoTable* self, PhotoRow* photo_row, PhotoID* result);
gboolean photo_id_is_invalid (PhotoID *self);
void library_photo_import_failed (LibraryPhoto* photo);
void photo_table_remove (PhotoTable* self, PhotoID* photo_id, GError** error);
static void library_photo_real_notify_master_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_editable_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_source_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_baseline_reimported (Photo* base, PhotoMetadata* metadata);
void thumbnail_cache_import_from_source (ThumbnailSource* source, gboolean force, GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void library_photo_real_notify_altered (DataObject* base, Alteration* alteration);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
void one_shot_scheduler_at_priority_idle (OneShotScheduler* self, gint priority);
static GdkPixbuf* library_photo_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static void library_photo_real_rotate (Photo* base, Rotation rotation);
void thumbnail_cache_rotate (ThumbnailSource* source, Rotation rotation, GError** error);
static GdkPixbuf* library_photo_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error);
static void library_photo_duplicate_backing_photo (LibraryPhoto* self, BackingPhotoRow* backing, BackingPhotoID* result, GError** error);
GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error);
static void library_photo_on_duplicate_progress (LibraryPhoto* self, gint64 current, gint64 total);
static void _library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self);
LibraryPhoto* library_photo_duplicate (LibraryPhoto* self, GError** error);
void photo_table_duplicate (PhotoTable* self, PhotoID* photo_id, const gchar* new_filename, BackingPhotoID* editable_id, BackingPhotoID* develop_shotwell, BackingPhotoID* develop_camera_id, BackingPhotoID* develop_embedded_id, PhotoID* result);
PhotoRow* photo_table_get_row (PhotoTable* self, PhotoID* photo_id);
void thumbnail_cache_duplicate (ThumbnailSource* src_source, ThumbnailSource* dest_source);
gboolean data_collection_add (DataCollection* self, DataObject* object);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
void event_attach (Event* self, MediaSource* source);
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self, MediaSource* source);
void tag_attach (Tag* self, MediaSource* source);
void spin_event_loop (void);
static gboolean library_photo_real_is_trashed (MediaSource* base);
static void library_photo_real_trash (MediaSource* base);
static void library_photo_real_untrash (MediaSource* base);
static gboolean library_photo_real_is_offline (Monitorable* base);
static void library_photo_real_mark_offline (Monitorable* base);
static void library_photo_real_mark_online (Monitorable* base);
static gboolean library_photo_real_is_flagged (Flaggable* base);
static void library_photo_real_mark_flagged (Flaggable* base);
static void library_photo_real_mark_unflagged (Flaggable* base);
static gboolean library_photo_real_internal_delete_backing (DataSource* base, GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
static void library_photo_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
gboolean library_photo_has_nontrash_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format);
void library_photo_get_nontrash_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, PhotoID* result);
static gboolean library_photo_real_has_user_generated_metadata (Photo* base);
Rating media_source_get_rating (MediaSource* self);
gchar* data_object_get_name (DataObject* self);
static void library_photo_real_set_user_metadata_for_export (Photo* base, PhotoMetadata* metadata);
void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option);
void photo_metadata_set_rating (PhotoMetadata* self, Rating rating);
static void library_photo_real_apply_user_metadata_for_reimport (Photo* base, PhotoMetadata* metadata);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
gboolean tag_source_collection_exists (TagSourceCollection* self, const gchar* name, gboolean treat_htags_as_root);
static void library_photo_finalize (GObject* obj);
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankPrivate))
enum  {
	LIBRARY_PHOTO_SOURCE_HOLDING_TANK_DUMMY_PROPERTY
};
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
static void library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base, GeeCollection* added, GeeCollection* removed);
static void library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self, Photo* _photo, GFile* old_file, GFile* new_file);
static void _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender, GFile* old_file, GFile* new_file, gpointer self);
static void library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self, Photo* _photo);
static void _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender, gpointer self);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
static void library_photo_source_holding_tank_finalize (SourceHoldingTank* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* PHOTO_IMAGE_EXTENSIONS[69] = {"jpg", "jpeg", "jpe", "tiff", "tif", "png", "gif", "bmp", "ppm", "pgm", "pbm", "pnm", "thm", "tga", "ilbm", "pcx", "ecw", "img", "sid", "cd5", "fits", "pgf", "cgm", "svg", "odg", "eps", "pdf", "swf", "wmf", "emf", "xps", "pns", "jps", "mpo", "3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "r3d", "raf", "raw", "rw2", "rwl", "rwz", "x3f", "srw"};

GType backing_fetch_mode_get_type (void) {
	static volatile gsize backing_fetch_mode_type_id__volatile = 0;
	if (g_once_init_enter (&backing_fetch_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BACKING_FETCH_MODE_SOURCE, "BACKING_FETCH_MODE_SOURCE", "source"}, {BACKING_FETCH_MODE_BASELINE, "BACKING_FETCH_MODE_BASELINE", "baseline"}, {BACKING_FETCH_MODE_MASTER, "BACKING_FETCH_MODE_MASTER", "master"}, {BACKING_FETCH_MODE_UNMODIFIED, "BACKING_FETCH_MODE_UNMODIFIED", "unmodified"}, {0, NULL, NULL}};
		GType backing_fetch_mode_type_id;
		backing_fetch_mode_type_id = g_enum_register_static ("BackingFetchMode", values);
		g_once_init_leave (&backing_fetch_mode_type_id__volatile, backing_fetch_mode_type_id);
	}
	return backing_fetch_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_object_ref (self) : NULL;
#line 2879 "Photo.c"
}


static gpointer _thumbnails_ref0 (gpointer self) {
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 2886 "Photo.c"
}


PhotoImportParams* photo_import_params_construct (GType object_type, GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails) {
	PhotoImportParams* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	ImportID _tmp4_ = {0};
	PhotoFileSnifferOptions _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	Thumbnails* _tmp12_ = NULL;
	Thumbnails* _tmp13_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((final_associated_file == NULL) || G_IS_FILE (final_associated_file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp1_;
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = final_associated_file;
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = _tmp3_;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = *import_id;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp4_;
#line 44 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = sniffer_options;
#line 44 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = _tmp5_;
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = exif_md5;
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = _tmp7_;
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = thumbnail_md5;
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = _tmp9_;
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = full_md5;
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = _tmp11_;
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = thumbnails;
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _thumbnails_ref0 (_tmp12_);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = _tmp13_;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 2974 "Photo.c"
}


PhotoImportParams* photo_import_params_new (GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails) {
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct (TYPE_PHOTO_IMPORT_PARAMS, file, final_associated_file, import_id, sniffer_options, exif_md5, thumbnail_md5, full_md5, thumbnails);
#line 2981 "Photo.c"
}


PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type, GFile* file, ImportID* import_id) {
	PhotoImportParams* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	ImportID _tmp2_ = {0};
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp1_;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *import_id;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp2_;
#line 55 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = NULL;
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = NULL;
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = NULL;
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = NULL;
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3028 "Photo.c"
}


PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file, ImportID* import_id) {
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct_create_placeholder (TYPE_PHOTO_IMPORT_PARAMS, file, import_id);
#line 3035 "Photo.c"
}


static void value_photo_import_params_init (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	value->data[0].v_pointer = NULL;
#line 3042 "Photo.c"
}


static void value_photo_import_params_free_value (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (value->data[0].v_pointer);
#line 3051 "Photo.c"
	}
}


static void value_photo_import_params_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = photo_import_params_ref (src_value->data[0].v_pointer);
#line 3061 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3065 "Photo.c"
	}
}


static gpointer value_photo_import_params_peek_pointer (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 3073 "Photo.c"
}


static gchar* value_photo_import_params_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (collect_values[0].v_pointer) {
#line 3080 "Photo.c"
		PhotoImportParams* object;
		object = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3087 "Photo.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3091 "Photo.c"
		}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = photo_import_params_ref (object);
#line 3095 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3099 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 3103 "Photo.c"
}


static gchar* value_photo_import_params_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoImportParams** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!object_p) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3114 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = NULL;
#line 3120 "Photo.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = value->data[0].v_pointer;
#line 3124 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = photo_import_params_ref (value->data[0].v_pointer);
#line 3128 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 3132 "Photo.c"
}


GParamSpec* param_spec_photo_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoImportParams* spec;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return G_PARAM_SPEC (spec);
#line 3146 "Photo.c"
}


gpointer value_get_photo_import_params (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 3155 "Photo.c"
}


void value_set_photo_import_params (GValue* value, gpointer v_object) {
	PhotoImportParams* old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_ref (value->data[0].v_pointer);
#line 3175 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3179 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 3185 "Photo.c"
	}
}


void value_take_photo_import_params (GValue* value, gpointer v_object) {
	PhotoImportParams* old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 3204 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3208 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 3214 "Photo.c"
	}
}


static void photo_import_params_class_init (PhotoImportParamsClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_params_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoImportParamsClass *) klass)->finalize = photo_import_params_finalize;
#line 3224 "Photo.c"
}


static void photo_import_params_instance_init (PhotoImportParams * self) {
	PhotoRow* _tmp0_ = NULL;
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = NULL;
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_row_new ();
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	self->keywords = NULL;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self->ref_count = 1;
#line 3240 "Photo.c"
}


static void photo_import_params_finalize (PhotoImportParams* obj) {
	PhotoImportParams * self;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_handlers_destroy (self);
#line 23 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 27 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 28 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 29 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 32 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->keywords);
#line 3266 "Photo.c"
}


GType photo_import_params_get_type (void) {
	static volatile gsize photo_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&photo_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_import_params_init, value_photo_import_params_free_value, value_photo_import_params_copy_value, value_photo_import_params_peek_pointer, "p", value_photo_import_params_collect_value, "p", value_photo_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportParams), 0, (GInstanceInitFunc) photo_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_import_params_type_id;
		photo_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_import_params_type_id__volatile, photo_import_params_type_id);
	}
	return photo_import_params_type_id__volatile;
}


gpointer photo_import_params_ref (gpointer instance) {
	PhotoImportParams* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return instance;
#line 3291 "Photo.c"
}


void photo_import_params_unref (gpointer instance) {
	PhotoImportParams* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		PHOTO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3304 "Photo.c"
	}
}


PhotoTransformationState* photo_transformation_state_construct (GType object_type) {
	PhotoTransformationState * self = NULL;
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoTransformationState*) g_object_new (object_type, NULL);
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3315 "Photo.c"
}


gboolean photo_transformation_state_is_broken (PhotoTransformationState* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 75 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (self), FALSE);
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->is_broke;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3330 "Photo.c"
}


static void photo_transformation_state_real_broken (PhotoTransformationState* self) {
#line 69 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = TRUE;
#line 3337 "Photo.c"
}


static void photo_transformation_state_class_init (PhotoTransformationStateClass * klass) {
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_transformation_state_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	g_type_class_add_private (klass, sizeof (PhotoTransformationStatePrivate));
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoTransformationStateClass *) klass)->broken = photo_transformation_state_real_broken;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (klass)->finalize = photo_transformation_state_finalize;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_new ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoTransformationStateClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3352 "Photo.c"
}


static void photo_transformation_state_instance_init (PhotoTransformationState * self) {
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv = PHOTO_TRANSFORMATION_STATE_GET_PRIVATE (self);
#line 64 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = FALSE;
#line 3361 "Photo.c"
}


static void photo_transformation_state_finalize (GObject* obj) {
	PhotoTransformationState * self;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (photo_transformation_state_parent_class)->finalize (obj);
#line 3371 "Photo.c"
}


GType photo_transformation_state_get_type (void) {
	static volatile gsize photo_transformation_state_type_id__volatile = 0;
	if (g_once_init_enter (&photo_transformation_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoTransformationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_transformation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTransformationState), 0, (GInstanceInitFunc) photo_transformation_state_instance_init, NULL };
		GType photo_transformation_state_type_id;
		photo_transformation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PhotoTransformationState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_transformation_state_type_id__volatile, photo_transformation_state_type_id);
	}
	return photo_transformation_state_type_id__volatile;
}


gboolean rating_can_increase (Rating self) {
	gboolean result = FALSE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self < RATING_FIVE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3393 "Photo.c"
}


gboolean rating_can_decrease (Rating self) {
	gboolean result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self > RATING_REJECTED;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3403 "Photo.c"
}


gboolean rating_is_valid (Rating self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	if (self >= RATING_REJECTED) {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self <= RATING_FIVE;
#line 3414 "Photo.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = FALSE;
#line 3418 "Photo.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3424 "Photo.c"
}


Rating rating_increase (Rating self) {
	Rating result = 0;
	Rating _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = rating_can_increase (self);
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self + 1;
#line 3438 "Photo.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 3442 "Photo.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3448 "Photo.c"
}


Rating rating_decrease (Rating self) {
	Rating result = 0;
	Rating _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = rating_can_decrease (self);
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self - 1;
#line 3462 "Photo.c"
	} else {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 3466 "Photo.c"
	}
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3472 "Photo.c"
}


gint rating_serialize (Rating self) {
	gint result = 0;
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (self) {
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_REJECTED:
#line 3482 "Photo.c"
		{
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			result = -1;
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3488 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_UNRATED:
#line 3492 "Photo.c"
		{
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3498 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_ONE:
#line 3502 "Photo.c"
		{
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 1;
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3508 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_TWO:
#line 3512 "Photo.c"
		{
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 2;
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3518 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_THREE:
#line 3522 "Photo.c"
		{
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 3;
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3528 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FOUR:
#line 3532 "Photo.c"
		{
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 4;
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3538 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FIVE:
#line 3542 "Photo.c"
		{
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 5;
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3548 "Photo.c"
		}
		default:
		{
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3556 "Photo.c"
		}
	}
}


Rating rating_unserialize (gint value) {
	Rating result = 0;
	gint _tmp0_ = 0;
	gint _tmp2_ = 0;
#line 131 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = value;
#line 131 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ > ((gint) RATING_FIVE)) {
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		result = RATING_FIVE;
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 3574 "Photo.c"
	} else {
		gint _tmp1_ = 0;
#line 133 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = value;
#line 133 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp1_ < ((gint) RATING_REJECTED)) {
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3585 "Photo.c"
		}
	}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = value;
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp2_) {
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case -1:
#line 3594 "Photo.c"
		{
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3600 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 0:
#line 3604 "Photo.c"
		{
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3610 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 1:
#line 3614 "Photo.c"
		{
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_ONE;
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3620 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 2:
#line 3624 "Photo.c"
		{
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_TWO;
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3630 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 3:
#line 3634 "Photo.c"
		{
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_THREE;
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3640 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 4:
#line 3644 "Photo.c"
		{
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FOUR;
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3650 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 5:
#line 3654 "Photo.c"
		{
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FIVE;
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3660 "Photo.c"
		}
		default:
		{
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3668 "Photo.c"
		}
	}
}


GType rating_get_type (void) {
	static volatile gsize rating_type_id__volatile = 0;
	if (g_once_init_enter (&rating_type_id__volatile)) {
		static const GEnumValue values[] = {{RATING_REJECTED, "RATING_REJECTED", "rejected"}, {RATING_UNRATED, "RATING_UNRATED", "unrated"}, {RATING_ONE, "RATING_ONE", "one"}, {RATING_TWO, "RATING_TWO", "two"}, {RATING_THREE, "RATING_THREE", "three"}, {RATING_FOUR, "RATING_FOUR", "four"}, {RATING_FIVE, "RATING_FIVE", "five"}, {0, NULL, NULL}};
		GType rating_type_id;
		rating_type_id = g_enum_register_static ("Rating", values);
		g_once_init_leave (&rating_type_id__volatile, rating_type_id);
	}
	return rating_type_id__volatile;
}


gboolean photo_exception_prohibits (PhotoException self, PhotoException exception) {
	gboolean result = FALSE;
	PhotoException _tmp0_ = 0;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = exception;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & _tmp0_) != 0;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3695 "Photo.c"
}


gboolean photo_exception_allows (PhotoException self, PhotoException exception) {
	gboolean result = FALSE;
	PhotoException _tmp0_ = 0;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = exception;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & _tmp0_) == 0;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3708 "Photo.c"
}


GType photo_exception_get_type (void) {
	static volatile gsize photo_exception_type_id__volatile = 0;
	if (g_once_init_enter (&photo_exception_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_EXCEPTION_NONE, "PHOTO_EXCEPTION_NONE", "none"}, {PHOTO_EXCEPTION_ORIENTATION, "PHOTO_EXCEPTION_ORIENTATION", "orientation"}, {PHOTO_EXCEPTION_CROP, "PHOTO_EXCEPTION_CROP", "crop"}, {PHOTO_EXCEPTION_REDEYE, "PHOTO_EXCEPTION_REDEYE", "redeye"}, {PHOTO_EXCEPTION_ADJUST, "PHOTO_EXCEPTION_ADJUST", "adjust"}, {PHOTO_EXCEPTION_STRAIGHTEN, "PHOTO_EXCEPTION_STRAIGHTEN", "straighten"}, {PHOTO_EXCEPTION_ALL, "PHOTO_EXCEPTION_ALL", "all"}, {0, NULL, NULL}};
		GType photo_exception_type_id;
		photo_exception_type_id = g_enum_register_static ("PhotoException", values);
		g_once_init_leave (&photo_exception_type_id__volatile, photo_exception_type_id);
	}
	return photo_exception_type_id__volatile;
}


static gpointer _photo_row_ref0 (gpointer self) {
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_row_ref (self) : NULL;
#line 3727 "Photo.c"
}


static gpointer _backing_photo_row_ref0 (gpointer self) {
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? backing_photo_row_ref (self) : NULL;
#line 3734 "Photo.c"
}


Photo* photo_construct (GType object_type, PhotoRow* row) {
	Photo * self = NULL;
	PhotoRow* _tmp0_ = NULL;
	PhotoRow* _tmp1_ = NULL;
	PhotoRow* _tmp2_ = NULL;
	PhotoRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	PhotoRow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	PhotoBackingReaders* _tmp10_ = NULL;
	PhotoRow* _tmp11_ = NULL;
	BackingPhotoRow* _tmp12_ = NULL;
	PhotoFileFormat _tmp13_ = 0;
	PhotoRow* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	PhotoFileReader* _tmp17_ = NULL;
	gchar* basename = NULL;
	PhotoRow* _tmp18_ = NULL;
	BackingPhotoRow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	PhotoRow* _tmp31_ = NULL;
	BackingPhotoID _tmp32_ = {0};
	gint64 _tmp33_ = 0LL;
	PhotoRow* _tmp49_ = NULL;
	BackingPhotoRow* _tmp50_ = NULL;
	PhotoFileFormat _tmp51_ = 0;
	gboolean _tmp67_ = FALSE;
	PhotoRow* _tmp68_ = NULL;
	BackingPhotoRow* _tmp69_ = NULL;
	PhotoFileFormat _tmp70_ = 0;
	PhotoBackingReaders* _tmp85_ = NULL;
	PhotoFileReader* _tmp86_ = NULL;
	PhotoRow* _tmp106_ = NULL;
	time_t _tmp107_ = 0;
	GError * _inner_error_ = NULL;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (Photo*) photo_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = row;
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _photo_row_ref0 (_tmp0_);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp1_;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_->title;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = media_source_prep_title (_tmp4_);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp2_->title);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_->title = _tmp5_;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp7_->comment;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = media_source_prep_comment (_tmp8_);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp6_->comment);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_->comment = _tmp9_;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = self->priv->readers;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = row;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_->file_format;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = row;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_->filepath;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = photo_file_format_create_reader (_tmp13_, _tmp16_);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp10_->master);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_->master = _tmp17_;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = row;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_->master;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = _tmp19_->filepath;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = string_sliced_at_last_char (_tmp20_, (gunichar) G_DIR_SEPARATOR, 0);
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	basename = _tmp21_;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = basename;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_ != NULL) {
#line 3851 "Photo.c"
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = basename;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = string_sliced_at (_tmp23_, 1);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp24_;
#line 3862 "Photo.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = self->priv->file_title;
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = is_string_empty (_tmp25_);
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp26_) {
#line 3870 "Photo.c"
		PhotoRow* _tmp27_ = NULL;
		BackingPhotoRow* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = row;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->master;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_->filepath;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = g_strdup (_tmp29_);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp30_;
#line 3887 "Photo.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = row;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = _tmp31_->editable_id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_.id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp33_ != BACKING_PHOTO_ID_INVALID) {
#line 3897 "Photo.c"
		BackingPhotoRow* e = NULL;
		PhotoRow* _tmp34_ = NULL;
		BackingPhotoID _tmp35_ = {0};
		BackingPhotoRow* _tmp36_ = NULL;
		BackingPhotoRow* _tmp37_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = row;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _tmp34_->editable_id;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = photo_get_backing_row (self, &_tmp35_);
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		e = _tmp36_;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = e;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp37_ != NULL) {
#line 3915 "Photo.c"
			BackingPhotoRow* _tmp38_ = NULL;
			BackingPhotoRow* _tmp39_ = NULL;
			PhotoBackingReaders* _tmp40_ = NULL;
			BackingPhotoRow* _tmp41_ = NULL;
			PhotoFileFormat _tmp42_ = 0;
			BackingPhotoRow* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			PhotoFileReader* _tmp45_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = e;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = _backing_photo_row_ref0 (_tmp38_);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->priv->editable);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->editable = _tmp39_;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = self->priv->readers;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = _tmp41_->file_format;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp44_ = _tmp43_->filepath;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45_ = photo_file_format_create_reader (_tmp42_, _tmp44_);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp40_->editable);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_->editable = _tmp45_;
#line 3948 "Photo.c"
		} else {
			{
				PhotoTable* _tmp46_ = NULL;
				PhotoTable* _tmp47_ = NULL;
				PhotoRow* _tmp48_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = photo_table_get_instance ();
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = _tmp46_;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = self->row;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_detach_editable (_tmp47_, _tmp48_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp47_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 3968 "Photo.c"
						goto __catch255_database_error;
					}
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (e);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (basename);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					return NULL;
#line 3981 "Photo.c"
				}
			}
			goto __finally255;
			__catch255_database_error:
			{
				GError* err = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 3994 "Photo.c"
			}
			__finally255:
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (e);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (basename);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 4009 "Photo.c"
			}
#line 432 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_internal_remove_all_transformations (self, FALSE);
#line 4013 "Photo.c"
		}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (e);
#line 4017 "Photo.c"
	}
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = row;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = _tmp49_->master;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->file_format;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp51_ == PHOTO_FILE_FORMAT_RAW) {
#line 4027 "Photo.c"
		GeeHashMap* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		RawDeveloper* _tmp54_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_ = gee_hash_map_new (TYPE_RAW_DEVELOPER, NULL, NULL, TYPE_BACKING_PHOTO_ROW, (GBoxedCopyFunc) backing_photo_row_ref, backing_photo_row_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (self->priv->developments);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->developments = _tmp52_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = raw_developer_as_array (&_tmp53_);
#line 4039 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp54_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp53_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp53_; d_it = d_it + 1) {
#line 4051 "Photo.c"
				RawDeveloper d = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 4055 "Photo.c"
				{
					BackingPhotoID id = {0};
					PhotoRow* _tmp55_ = NULL;
					BackingPhotoID* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					RawDeveloper _tmp57_ = 0;
					BackingPhotoID _tmp58_ = {0};
					BackingPhotoID _tmp59_ = {0};
					gint64 _tmp60_ = 0LL;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp55_ = row;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56_ = _tmp55_->development_ids;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56__length1 = _tmp55_->development_ids_length1;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp57_ = d;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp58_ = _tmp56_[_tmp57_];
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					id = _tmp58_;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp59_ = id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp60_ = _tmp59_.id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp60_ != BACKING_PHOTO_ID_INVALID) {
#line 4083 "Photo.c"
						BackingPhotoRow* bpr = NULL;
						BackingPhotoID _tmp61_ = {0};
						BackingPhotoRow* _tmp62_ = NULL;
						BackingPhotoRow* _tmp63_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp61_ = id;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp62_ = photo_get_backing_row (self, &_tmp61_);
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						bpr = _tmp62_;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp63_ = bpr;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp63_ != NULL) {
#line 4098 "Photo.c"
							GeeHashMap* _tmp64_ = NULL;
							RawDeveloper _tmp65_ = 0;
							BackingPhotoRow* _tmp66_ = NULL;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp64_ = self->priv->developments;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp65_ = d;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp66_ = bpr;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp65_), _tmp66_);
#line 4110 "Photo.c"
						}
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bpr);
#line 4114 "Photo.c"
					}
				}
			}
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 4120 "Photo.c"
		}
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp68_ = row;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp69_ = _tmp68_->master;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp70_ = _tmp69_->file_format;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp70_ == PHOTO_FILE_FORMAT_RAW) {
#line 4131 "Photo.c"
		GeeHashMap* _tmp71_ = NULL;
		PhotoRow* _tmp72_ = NULL;
		RawDeveloper _tmp73_ = 0;
		gboolean _tmp74_ = FALSE;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = self->priv->developments;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = row;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = _tmp72_->developer;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp73_));
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = _tmp74_;
#line 4146 "Photo.c"
	} else {
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = FALSE;
#line 4150 "Photo.c"
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp67_) {
#line 4154 "Photo.c"
		BackingPhotoRow* r = NULL;
		GeeHashMap* _tmp75_ = NULL;
		PhotoRow* _tmp76_ = NULL;
		RawDeveloper _tmp77_ = 0;
		gpointer _tmp78_ = NULL;
		PhotoBackingReaders* _tmp79_ = NULL;
		BackingPhotoRow* _tmp80_ = NULL;
		PhotoFileFormat _tmp81_ = 0;
		BackingPhotoRow* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		PhotoFileReader* _tmp84_ = NULL;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = self->priv->developments;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = row;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = _tmp76_->developer;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp77_));
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		r = (BackingPhotoRow*) _tmp78_;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = self->priv->readers;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_->file_format;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp82_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_ = _tmp82_->filepath;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp84_ = photo_file_format_create_reader (_tmp81_, _tmp83_);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp79_->developer);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_->developer = _tmp84_;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (r);
#line 4194 "Photo.c"
	}
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = self->priv->readers;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = _tmp85_->editable;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp86_ != NULL) {
#line 4202 "Photo.c"
		BackingPhotoRow* _tmp87_ = NULL;
		BackingPhotoRow* _tmp88_ = NULL;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp87_ = self->priv->editable;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp88_ = _backing_photo_row_ref0 (_tmp87_);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (self->backing_photo_row);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		self->backing_photo_row = _tmp88_;
#line 4213 "Photo.c"
	} else {
		PhotoRow* _tmp89_ = NULL;
		BackingPhotoRow* _tmp90_ = NULL;
		PhotoFileFormat _tmp91_ = 0;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp89_ = row;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = _tmp89_->master;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = _tmp90_->file_format;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp91_ != PHOTO_FILE_FORMAT_RAW) {
#line 4226 "Photo.c"
			PhotoRow* _tmp92_ = NULL;
			BackingPhotoRow* _tmp93_ = NULL;
			BackingPhotoRow* _tmp94_ = NULL;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp92_ = self->row;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp93_ = _tmp92_->master;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp94_ = _backing_photo_row_ref0 (_tmp93_);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = _tmp94_;
#line 4240 "Photo.c"
		} else {
			GeeHashMap* _tmp95_ = NULL;
			PhotoRow* _tmp96_ = NULL;
			RawDeveloper _tmp97_ = 0;
			gboolean _tmp98_ = FALSE;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp95_ = self->priv->developments;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp96_ = row;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp97_ = _tmp96_->developer;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp98_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp97_));
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp98_) {
#line 4256 "Photo.c"
				GeeHashMap* _tmp99_ = NULL;
				PhotoRow* _tmp100_ = NULL;
				RawDeveloper _tmp101_ = 0;
				gpointer _tmp102_ = NULL;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp99_ = self->priv->developments;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp100_ = row;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp101_ = _tmp100_->developer;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp102_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp101_));
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = (BackingPhotoRow*) _tmp102_;
#line 4273 "Photo.c"
			} else {
				PhotoRow* _tmp103_ = NULL;
				BackingPhotoRow* _tmp104_ = NULL;
				BackingPhotoRow* _tmp105_ = NULL;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp103_ = self->row;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp104_ = _tmp103_->master;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp105_ = _backing_photo_row_ref0 (_tmp104_);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = _tmp105_;
#line 4288 "Photo.c"
			}
		}
	}
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp106_ = self->row;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp107_ = _tmp106_->exposure_time;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->cached_exposure_time = _tmp107_;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (basename);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 4302 "Photo.c"
}


void photo_init_photo (void) {
	GeeLinkedList* _tmp0_ = NULL;
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = gee_linked_list_new (PHOTO_TYPE_CACHED_PIXBUF, (GBoxedCopyFunc) photo_cached_pixbuf_ref, photo_cached_pixbuf_unref, NULL, NULL, NULL);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = _tmp0_;
#line 4314 "Photo.c"
}


void photo_terminate_photo (void) {
	guint _tmp0_ = 0U;
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = NULL;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_discard_source_id;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 4328 "Photo.c"
		guint _tmp1_ = 0U;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_discard_source_id;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		g_source_remove (_tmp1_);
#line 483 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_discard_source_id = (guint) 0;
#line 4336 "Photo.c"
	}
}


static void photo_real_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((old_file == NULL) || G_IS_FILE (old_file));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((new_file == NULL) || G_IS_FILE (new_file));
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = old_file;
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = new_file;
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "editable-replaced", _tmp0_, _tmp1_);
#line 4354 "Photo.c"
}


void photo_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file) {
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_replaced (self, old_file, new_file);
#line 4363 "Photo.c"
}


static void photo_real_notify_raw_development_modified (Photo* self) {
#line 492 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "raw-development-modified");
#line 4370 "Photo.c"
}


void photo_notify_raw_development_modified (Photo* self) {
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_raw_development_modified (self);
#line 4379 "Photo.c"
}


static void photo_real_notify_baseline_replaced (Photo* self) {
#line 496 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "baseline-replaced");
#line 4386 "Photo.c"
}


void photo_notify_baseline_replaced (Photo* self) {
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_replaced (self);
#line 4395 "Photo.c"
}


static void photo_real_notify_master_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 500 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 500 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "master-reimported", _tmp0_);
#line 4407 "Photo.c"
}


void photo_notify_master_reimported (Photo* self, PhotoMetadata* metadata) {
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_master_reimported (self, metadata);
#line 4416 "Photo.c"
}


static void photo_real_notify_editable_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 504 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 504 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "editable-reimported", _tmp0_);
#line 4428 "Photo.c"
}


void photo_notify_editable_reimported (Photo* self, PhotoMetadata* metadata) {
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_reimported (self, metadata);
#line 4437 "Photo.c"
}


static void photo_real_notify_source_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 508 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 508 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "source-reimported", _tmp0_);
#line 4449 "Photo.c"
}


void photo_notify_source_reimported (Photo* self, PhotoMetadata* metadata) {
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_source_reimported (self, metadata);
#line 4458 "Photo.c"
}


static void photo_real_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 512 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 512 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "baseline-reimported", _tmp0_);
#line 4470 "Photo.c"
}


void photo_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata) {
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_reimported (self, metadata);
#line 4479 "Photo.c"
}


static gboolean photo_real_internal_delete_backing (DataSource* base, GError** error) {
	Photo * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GFile* file = NULL;
	PhotoFileFormat _tmp7_ = 0;
	GFile* _tmp11_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 516 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = TRUE;
#line 517 "/home/jens/Source/shotwell/src/Photo.vala"
	file = NULL;
#line 4500 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 4507 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 4517 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				GFile* _tmp5_ = NULL;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				file = _tmp5_;
#line 4531 "Photo.c"
			}
		}
		__finally256:
		{
			PhotoBackingReaders* _tmp6_ = NULL;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 4541 "Photo.c"
		}
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 4551 "Photo.c"
		}
	}
#line 523 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_detach_editable (self, TRUE, FALSE, TRUE);
#line 525 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_get_master_file_format (self);
#line 525 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_ == PHOTO_FILE_FORMAT_RAW) {
#line 4560 "Photo.c"
		gint _tmp8_ = 0;
		RawDeveloper* _tmp9_ = NULL;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = raw_developer_as_array (&_tmp8_);
#line 4565 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp9_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp8_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp8_; d_it = d_it + 1) {
#line 4577 "Photo.c"
				RawDeveloper d = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 4581 "Photo.c"
				{
					RawDeveloper _tmp10_ = 0;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = d;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_delete_raw_development (self, _tmp10_);
#line 4588 "Photo.c"
				}
			}
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 4593 "Photo.c"
		}
	}
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = file;
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_ != NULL) {
#line 4600 "Photo.c"
		{
			gboolean _tmp12_ = FALSE;
			GFile* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = file;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = g_file_trash (_tmp13_, NULL, &_inner_error_);
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp14_;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4613 "Photo.c"
				goto __catch257_g_error;
			}
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp12_;
#line 4618 "Photo.c"
		}
		goto __finally257;
		__catch257_g_error:
		{
			GError* err = NULL;
			GFile* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = FALSE;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = file;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = g_file_get_path (_tmp15_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = _tmp18_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = err;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = _tmp20_->message;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			g_message ("Photo.vala:536: Unable to move editable %s for %s to trash: %s", _tmp17_, _tmp19_, _tmp21_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp19_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp17_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 4659 "Photo.c"
		}
		__finally257:
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 4670 "Photo.c"
		}
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = DATA_SOURCE_CLASS (photo_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = _tmp24_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 4685 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 4689 "Photo.c"
		gboolean _tmp25_ = FALSE;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = ret;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp25_;
#line 4695 "Photo.c"
	} else {
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = FALSE;
#line 4699 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp22_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4707 "Photo.c"
}


static BackingPhotoRow* photo_get_backing_row (Photo* self, BackingPhotoID* id) {
	BackingPhotoRow* result = NULL;
	BackingPhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	BackingPhotoRow* backing_row = NULL;
	BackingPhotoRow* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == BACKING_PHOTO_ID_INVALID) {
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 4732 "Photo.c"
	}
#line 551 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_row = NULL;
#line 4736 "Photo.c"
	{
		BackingPhotoRow* _tmp2_ = NULL;
		BackingPhotoTable* _tmp3_ = NULL;
		BackingPhotoTable* _tmp4_ = NULL;
		BackingPhotoID _tmp5_ = {0};
		BackingPhotoRow* _tmp6_ = NULL;
		BackingPhotoRow* _tmp7_ = NULL;
		BackingPhotoRow* _tmp8_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = backing_photo_table_get_instance ();
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = *id;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = backing_photo_table_fetch (_tmp4_, &_tmp5_, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp4_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp7_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 4763 "Photo.c"
				goto __catch258_database_error;
			}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 4774 "Photo.c"
		}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp2_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_row = _tmp8_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp2_);
#line 4786 "Photo.c"
	}
	goto __finally258;
	__catch258_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = err;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->message;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:555: Unable to fetch backing state for %s: %s", _tmp10_, _tmp12_);
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 4814 "Photo.c"
	}
	__finally258:
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 4827 "Photo.c"
	}
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = backing_row;
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 4833 "Photo.c"
		{
			BackingPhotoTable* _tmp14_ = NULL;
			BackingPhotoTable* _tmp15_ = NULL;
			BackingPhotoID _tmp16_ = {0};
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = backing_photo_table_get_instance ();
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = *id;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_table_remove (_tmp15_, &_tmp16_, &_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp15_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 4852 "Photo.c"
					goto __catch259_database_error;
				}
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing_row);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 4863 "Photo.c"
			}
		}
		goto __finally259;
		__catch259_database_error:
		{
			GError* err = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 4876 "Photo.c"
		}
		__finally259:
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 4889 "Photo.c"
		}
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 4897 "Photo.c"
	}
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing_row;
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4903 "Photo.c"
}


gboolean photo_is_raw_developer_complete (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 4912 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 4919 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			GeeHashMap* _tmp2_ = NULL;
			RawDeveloper _tmp3_ = 0;
			gboolean _tmp4_ = FALSE;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = d;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp3_));
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_) {
#line 4933 "Photo.c"
				GeeHashMap* _tmp5_ = NULL;
				RawDeveloper _tmp6_ = 0;
				gpointer _tmp7_ = NULL;
				BackingPhotoRow* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->priv->developments;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = d;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp6_));
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = (BackingPhotoRow*) _tmp7_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_->filepath;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp10_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp8_);
#line 4956 "Photo.c"
			} else {
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 4960 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 4964 "Photo.c"
			{
				GeeHashMap* _tmp11_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 4971 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4975 "Photo.c"
		}
		__finally260:
		{
			GeeHashMap* _tmp12_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 4984 "Photo.c"
		}
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 4992 "Photo.c"
	}
}


gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	RawDeveloper _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 5003 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5010 "Photo.c"
		{
			GeeHashMap* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
			gboolean _tmp3_ = FALSE;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp2_));
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_) {
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 5025 "Photo.c"
				{
					GeeHashMap* _tmp4_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp4_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5032 "Photo.c"
				}
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 5036 "Photo.c"
			}
		}
		__finally261:
		{
			GeeHashMap* _tmp5_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5046 "Photo.c"
		}
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 5056 "Photo.c"
		}
	}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = d;
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp6_) {
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 5065 "Photo.c"
		{
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			result = TRUE;
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5071 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 5075 "Photo.c"
		{
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5081 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 5085 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp7_ = NULL;
				guint num_previews = 0U;
				PhotoMetadata* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo_get_master_metadata (self, &_inner_error_);
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp7_;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5100 "Photo.c"
					goto __catch262_g_error;
				}
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = meta;
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo_metadata_get_preview_count (_tmp8_);
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				num_previews = _tmp9_;
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = num_previews;
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ > ((guint) 0)) {
#line 5113 "Photo.c"
					PhotoPreview* prev = NULL;
					PhotoMetadata* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					PhotoPreview* _tmp13_ = NULL;
					PhotoPreview* _tmp14_ = NULL;
					Dimensions dims = {0};
					PhotoPreview* _tmp15_ = NULL;
					Dimensions _tmp16_ = {0};
					gint _tmp17_ = 0;
					Dimensions _tmp18_ = {0};
					gint _tmp19_ = 0;
					Dimensions _tmp20_ = {0};
					gint _tmp21_ = 0;
					gint preview_major_axis = 0;
					gint _tmp26_ = 0;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = meta;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = num_previews;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = photo_metadata_get_preview (_tmp11_, _tmp12_ - 1);
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					prev = _tmp13_;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = prev;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp14_ == NULL) {
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 5149 "Photo.c"
					}
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = prev;
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_preview_get_pixel_dimensions (_tmp15_, &_tmp16_);
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					dims = _tmp16_;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = _tmp18_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = _tmp20_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp19_ > _tmp21_) {
#line 5167 "Photo.c"
						Dimensions _tmp22_ = {0};
						gint _tmp23_ = 0;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp22_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = _tmp22_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = _tmp23_;
#line 5176 "Photo.c"
					} else {
						Dimensions _tmp24_ = {0};
						gint _tmp25_ = 0;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp24_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = _tmp24_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = _tmp25_;
#line 5186 "Photo.c"
					}
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					preview_major_axis = _tmp17_;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp26_ = preview_major_axis;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp26_ < PHOTO_MIN_EMBEDDED_SIZE) {
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 5202 "Photo.c"
					}
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 5212 "Photo.c"
				}
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 5220 "Photo.c"
			}
			goto __finally262;
			__catch262_g_error:
			{
				GError* e = NULL;
				GError* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = e;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_->message;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:619: Error accessing embedded preview. Message: %s", _tmp28_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 5240 "Photo.c"
			}
			__finally262:
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				return FALSE;
#line 5251 "Photo.c"
			}
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5257 "Photo.c"
		}
		default:
		{
#line 624 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 5263 "Photo.c"
		}
	}
}


void photo_add_backing_photo_for_development (Photo* self, RawDeveloper d, BackingPhotoRow* bpr, GError** error) {
	PhotoRow* _tmp0_ = NULL;
	RawDeveloper _tmp1_ = 0;
	BackingPhotoRow* _tmp2_ = NULL;
	Alteration* _tmp8_ = NULL;
	Alteration* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = d;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = bpr;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_developed_backing_photo (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5294 "Photo.c"
	}
	{
		GeeHashMap* _tmp3_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5302 "Photo.c"
		{
			GeeHashMap* _tmp4_ = NULL;
			RawDeveloper _tmp5_ = 0;
			BackingPhotoRow* _tmp6_ = NULL;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->developments;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = d;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = bpr;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp5_), _tmp6_);
#line 5315 "Photo.c"
		}
		__finally263:
		{
			GeeHashMap* _tmp7_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5324 "Photo.c"
		}
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 5332 "Photo.c"
		}
	}
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = alteration_new ("image", "developer");
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp9_);
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp9_);
#line 5343 "Photo.c"
}


void photo_import_developed_backing_photo (PhotoRow* row, RawDeveloper d, BackingPhotoRow* bpr, GError** error) {
	GFile* file = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp5_ = NULL;
	GTimeVal _tmp6_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp7_ = NULL;
	PhotoFileInterrogator* _tmp8_ = NULL;
	PhotoFileInterrogator* _tmp9_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp10_ = NULL;
	DetectedPhotoInformation* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	DetectedPhotoInformation* _tmp13_ = NULL;
	BackingPhotoRow* _tmp16_ = NULL;
	DetectedPhotoInformation* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	BackingPhotoRow* _tmp19_ = NULL;
	GFileInfo* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	BackingPhotoRow* _tmp22_ = NULL;
	GTimeVal _tmp23_ = {0};
	glong _tmp24_ = 0L;
	Orientation _tmp25_ = 0;
	DetectedPhotoInformation* _tmp26_ = NULL;
	PhotoMetadata* _tmp27_ = NULL;
	BackingPhotoRow* _tmp31_ = NULL;
	BackingPhotoTable* _tmp32_ = NULL;
	BackingPhotoTable* _tmp33_ = NULL;
	BackingPhotoRow* _tmp34_ = NULL;
	PhotoTable* _tmp35_ = NULL;
	PhotoTable* _tmp36_ = NULL;
	PhotoRow* _tmp37_ = NULL;
	RawDeveloper _tmp38_ = 0;
	BackingPhotoRow* _tmp39_ = NULL;
	BackingPhotoID _tmp40_ = {0};
	GError * _inner_error_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = bpr;
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->filepath;
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = file;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	info = _tmp4_;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5416 "Photo.c"
	}
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = info;
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp5_, &_tmp6_);
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp6_;
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = file;
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_file_interrogator_new (_tmp7_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp8_;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = interrogator;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp9_, &_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5446 "Photo.c"
	}
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = interrogator;
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_interrogator_get_detected_photo_information (_tmp10_);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp11_;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = detected;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 5460 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = interrogator;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = photo_file_interrogator_get_is_photo_corrupted (_tmp14_);
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp15_;
#line 5470 "Photo.c"
	}
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5484 "Photo.c"
	}
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = bpr;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = detected;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_->image_dim;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_->dim = _tmp18_;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = bpr;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = info;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = g_file_info_get_size (_tmp20_);
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->filesize = _tmp21_;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = bpr;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = timestamp;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_.tv_sec;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_->timestamp = (time_t) _tmp24_;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = detected;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = _tmp26_->metadata;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp27_ != NULL) {
#line 5516 "Photo.c"
		DetectedPhotoInformation* _tmp28_ = NULL;
		PhotoMetadata* _tmp29_ = NULL;
		Orientation _tmp30_ = 0;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = detected;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_->metadata;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = photo_metadata_get_orientation (_tmp29_);
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp30_;
#line 5528 "Photo.c"
	} else {
#line 661 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = ORIENTATION_TOP_LEFT;
#line 5532 "Photo.c"
	}
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = bpr;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_->original_orientation = _tmp25_;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = backing_photo_table_get_instance ();
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = bpr;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_photo_table_add (_tmp33_, _tmp34_, &_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp33_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5562 "Photo.c"
	}
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_table_get_instance ();
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = row;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = d;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = bpr;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->id;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_update_raw_development (_tmp36_, _tmp37_, _tmp38_, &_tmp40_, &_inner_error_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp36_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5594 "Photo.c"
	}
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 5604 "Photo.c"
}


static void photo_develop_photo (Photo* self, RawDeveloper d) {
	gboolean wrote_img_to_disk = FALSE;
	BackingPhotoRow* bps = NULL;
	RawDeveloper _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 671 "/home/jens/Source/shotwell/src/Photo.vala"
	wrote_img_to_disk = FALSE;
#line 672 "/home/jens/Source/shotwell/src/Photo.vala"
	bps = NULL;
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = d;
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp0_) {
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 5625 "Photo.c"
		{
			{
				BackingPhotoRow* _tmp1_ = NULL;
				RawDeveloper _tmp2_ = 0;
				PhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				BackingPhotoRow* _tmp6_ = NULL;
				BackingPhotoRow* _tmp7_ = NULL;
				GdkPixbuf* pix = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				PhotoFileWriter* _tmp22_ = NULL;
				PhotoFileWriter* _tmp23_ = NULL;
				GdkPixbuf* _tmp24_ = NULL;
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp25_ = NULL;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				PhotoFileMetadataWriter* _tmp28_ = NULL;
				PhotoFileMetadataWriter* _tmp29_ = NULL;
				PhotoMetadata* _tmp30_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = d;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->master;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->filepath;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = raw_developer_create_backing_row_for_development (_tmp2_, _tmp5_, NULL, &_inner_error_);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5665 "Photo.c"
					goto __catch264_g_error;
				}
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp1_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp7_;
#line 679 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = NULL;
#line 5678 "Photo.c"
				{
					PhotoBackingReaders* _tmp8_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = self->priv->readers;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 5685 "Photo.c"
					{
						GdkPixbuf* _tmp9_ = NULL;
						Scaling _tmp10_ = {0};
						GdkPixbuf* _tmp11_ = NULL;
						GdkPixbuf* _tmp12_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						scaling_for_original (&_tmp10_);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp11_ = photo_get_master_pixbuf (self, &_tmp10_, FALSE, &_inner_error_);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = _tmp11_;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5699 "Photo.c"
							goto __finally265;
						}
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp12_ = _tmp9_;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						pix = _tmp12_;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp9_);
#line 5712 "Photo.c"
					}
					__finally265:
					{
						PhotoBackingReaders* _tmp13_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = self->priv->readers;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 5721 "Photo.c"
					}
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp1_);
#line 5729 "Photo.c"
						goto __catch264_g_error;
					}
				}
#line 688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = pix;
#line 688 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp14_ == NULL) {
#line 689 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:689: Could not get preview pixbuf");
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5743 "Photo.c"
					{
						gboolean _tmp15_ = FALSE;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = wrote_img_to_disk;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp15_) {
#line 5750 "Photo.c"
							{
								RawDeveloper _tmp16_ = 0;
								BackingPhotoRow* _tmp17_ = NULL;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp16_ = d;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp17_ = bps;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp16_, _tmp17_, &_inner_error_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5762 "Photo.c"
									goto __catch266_g_error;
								}
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 5767 "Photo.c"
							}
							goto __finally266;
							__catch266_g_error:
							{
								GError* e = NULL;
								GError* _tmp18_ = NULL;
								const gchar* _tmp19_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp18_ = e;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp19_ = _tmp18_->message;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:721: Error adding backing photo as development. Message: %s", _tmp19_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 5787 "Photo.c"
							}
							__finally266:
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5792 "Photo.c"
								goto __catch264_g_error;
							}
						}
					}
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 5801 "Photo.c"
				}
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = bps;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = _tmp20_->filepath;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp21_, &_inner_error_);
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				writer = _tmp22_;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5817 "Photo.c"
					goto __catch264_g_error;
				}
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = writer;
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = pix;
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_writer_write (_tmp23_, _tmp24_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5834 "Photo.c"
					goto __catch264_g_error;
				}
#line 703 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = photo_get_master_metadata (self, &_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp25_;
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5851 "Photo.c"
					goto __catch264_g_error;
				}
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = bps;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_->filepath;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp27_, &_inner_error_);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp28_;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5872 "Photo.c"
					goto __catch264_g_error;
				}
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = mwriter;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = meta;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp29_, _tmp30_, &_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5893 "Photo.c"
					goto __catch264_g_error;
				}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (writer);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (pix);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 5906 "Photo.c"
			}
			goto __finally264;
			__catch264_g_error:
			{
				GError* err = NULL;
				GError* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = err;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = _tmp31_->message;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:712: Error developing photo: %s", _tmp32_);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 5926 "Photo.c"
			}
			__finally264:
			{
				gboolean _tmp33_ = FALSE;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = wrote_img_to_disk;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp33_) {
#line 5935 "Photo.c"
					{
						RawDeveloper _tmp34_ = 0;
						BackingPhotoRow* _tmp35_ = NULL;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp34_ = d;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp35_ = bps;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, _tmp34_, _tmp35_, &_inner_error_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5947 "Photo.c"
							goto __catch267_g_error;
						}
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 5952 "Photo.c"
					}
					goto __finally267;
					__catch267_g_error:
					{
						GError* e = NULL;
						GError* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp36_ = e;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp37_ = _tmp36_->message;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:721: Error adding backing photo as development. Message: %s", _tmp37_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 5972 "Photo.c"
					}
					__finally267:
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 5985 "Photo.c"
					}
				}
			}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 5999 "Photo.c"
			}
#line 727 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6003 "Photo.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 6007 "Photo.c"
		{
#line 731 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6011 "Photo.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 6015 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp38_ = NULL;
				guint c = 0U;
				PhotoMetadata* _tmp39_ = NULL;
				guint _tmp40_ = 0U;
				guint _tmp41_ = 0U;
				PhotoPreview* prev = NULL;
				PhotoMetadata* _tmp47_ = NULL;
				guint _tmp48_ = 0U;
				PhotoPreview* _tmp49_ = NULL;
				PhotoPreview* _tmp50_ = NULL;
				GdkPixbuf* pix = NULL;
				PhotoPreview* _tmp56_ = NULL;
				GdkPixbuf* _tmp57_ = NULL;
				GdkPixbuf* _tmp58_ = NULL;
				BackingPhotoRow* _tmp64_ = NULL;
				RawDeveloper _tmp65_ = 0;
				PhotoRow* _tmp66_ = NULL;
				BackingPhotoRow* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				BackingPhotoRow* _tmp69_ = NULL;
				BackingPhotoRow* _tmp70_ = NULL;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				PhotoFileWriter* _tmp73_ = NULL;
				PhotoFileWriter* _tmp74_ = NULL;
				GdkPixbuf* _tmp75_ = NULL;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				PhotoFileMetadataWriter* _tmp78_ = NULL;
				PhotoFileMetadataWriter* _tmp79_ = NULL;
				PhotoMetadata* _tmp80_ = NULL;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = photo_get_master_metadata (self, &_inner_error_);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp38_;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6058 "Photo.c"
					goto __catch268_g_error;
				}
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = meta;
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = photo_metadata_get_preview_count (_tmp39_);
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				c = _tmp40_;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = c;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp41_ <= ((guint) 0)) {
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6073 "Photo.c"
					{
						gboolean _tmp42_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp42_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp42_) {
#line 6080 "Photo.c"
							{
								RawDeveloper _tmp43_ = 0;
								BackingPhotoRow* _tmp44_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp43_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp44_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp43_, _tmp44_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6092 "Photo.c"
									goto __catch269_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6097 "Photo.c"
							}
							goto __finally269;
							__catch269_g_error:
							{
								GError* e = NULL;
								GError* _tmp45_ = NULL;
								const gchar* _tmp46_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp45_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp46_ = _tmp45_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp46_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6117 "Photo.c"
							}
							__finally269:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6122 "Photo.c"
								goto __catch268_g_error;
							}
						}
					}
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6131 "Photo.c"
				}
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = meta;
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = c;
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp49_ = photo_metadata_get_preview (_tmp47_, _tmp48_ - 1);
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				prev = _tmp49_;
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp50_ = prev;
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp50_ == NULL) {
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:742: Could not get preview from metadata");
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6151 "Photo.c"
					{
						gboolean _tmp51_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp51_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp51_) {
#line 6158 "Photo.c"
							{
								RawDeveloper _tmp52_ = 0;
								BackingPhotoRow* _tmp53_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp52_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp53_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp52_, _tmp53_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6170 "Photo.c"
									goto __catch270_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6175 "Photo.c"
							}
							goto __finally270;
							__catch270_g_error:
							{
								GError* e = NULL;
								GError* _tmp54_ = NULL;
								const gchar* _tmp55_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp54_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp55_ = _tmp54_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp55_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6195 "Photo.c"
							}
							__finally270:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6200 "Photo.c"
								goto __catch268_g_error;
							}
						}
					}
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6209 "Photo.c"
				}
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp56_ = prev;
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp57_ = photo_preview_get_pixbuf (_tmp56_, &_inner_error_);
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = _tmp57_;
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6223 "Photo.c"
					goto __catch268_g_error;
				}
#line 747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp58_ = pix;
#line 747 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp58_ == NULL) {
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:748: Could not get preview pixbuf");
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6238 "Photo.c"
					{
						gboolean _tmp59_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp59_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp59_) {
#line 6245 "Photo.c"
							{
								RawDeveloper _tmp60_ = 0;
								BackingPhotoRow* _tmp61_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp60_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp61_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp60_, _tmp61_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6257 "Photo.c"
									goto __catch271_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6262 "Photo.c"
							}
							goto __finally271;
							__catch271_g_error:
							{
								GError* e = NULL;
								GError* _tmp62_ = NULL;
								const gchar* _tmp63_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp62_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp63_ = _tmp62_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp63_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6282 "Photo.c"
							}
							__finally271:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6287 "Photo.c"
								goto __catch268_g_error;
							}
						}
					}
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6296 "Photo.c"
				}
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp65_ = d;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp66_ = self->row;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp67_ = _tmp66_->master;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp68_ = _tmp67_->filepath;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = raw_developer_create_backing_row_for_development (_tmp65_, _tmp68_, NULL, &_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = _tmp69_;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6318 "Photo.c"
					goto __catch268_g_error;
				}
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp70_ = _tmp64_;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = NULL;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp70_;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp71_ = bps;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp72_ = _tmp71_->filepath;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp73_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp72_, &_inner_error_);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				writer = _tmp73_;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6347 "Photo.c"
					goto __catch268_g_error;
				}
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp74_ = writer;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp75_ = pix;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_writer_write (_tmp74_, _tmp75_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6368 "Photo.c"
					goto __catch268_g_error;
				}
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp76_ = bps;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp77_ = _tmp76_->filepath;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp78_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp77_, &_inner_error_);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp78_;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6393 "Photo.c"
					goto __catch268_g_error;
				}
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp79_ = mwriter;
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp80_ = meta;
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp79_, _tmp80_, &_inner_error_);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6416 "Photo.c"
					goto __catch268_g_error;
				}
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (writer);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp64_);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (pix);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_preview_unref0 (prev);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 6431 "Photo.c"
			}
			goto __finally268;
			__catch268_g_error:
			{
				GError* e = NULL;
				GError* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp81_ = e;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp82_ = _tmp81_->message;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:765: Error accessing embedded preview. Message: %s", _tmp82_);
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6451 "Photo.c"
				{
					gboolean _tmp83_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp83_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp83_) {
#line 6458 "Photo.c"
						{
							RawDeveloper _tmp84_ = 0;
							BackingPhotoRow* _tmp85_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp84_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp85_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_add_backing_photo_for_development (self, _tmp84_, _tmp85_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6470 "Photo.c"
								goto __catch272_g_error;
							}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_notify_raw_development_modified (self);
#line 6475 "Photo.c"
						}
						goto __finally272;
						__catch272_g_error:
						{
							GError* e = NULL;
							GError* _tmp86_ = NULL;
							const gchar* _tmp87_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp86_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp87_ = _tmp86_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp87_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_error_free0 (e);
#line 6495 "Photo.c"
						}
						__finally272:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (bps);
#line 6502 "Photo.c"
						}
					}
				}
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6510 "Photo.c"
			}
			__finally268:
			{
				gboolean _tmp88_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp88_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp88_) {
#line 6519 "Photo.c"
					{
						RawDeveloper _tmp89_ = 0;
						BackingPhotoRow* _tmp90_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp89_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp90_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, _tmp89_, _tmp90_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6531 "Photo.c"
							goto __catch273_g_error;
						}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 6536 "Photo.c"
					}
					goto __finally273;
					__catch273_g_error:
					{
						GError* e = NULL;
						GError* _tmp91_ = NULL;
						const gchar* _tmp92_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp91_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp92_ = _tmp91_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp92_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 6556 "Photo.c"
					}
					__finally273:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 6569 "Photo.c"
					}
				}
			}
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6583 "Photo.c"
			}
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6587 "Photo.c"
		}
		default:
		{
#line 783 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 6593 "Photo.c"
		}
	}
#line 670 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (bps);
#line 6598 "Photo.c"
}


void photo_set_default_raw_developer (Photo* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
#line 788 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 6606 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 6613 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_->developer = _tmp2_;
#line 6623 "Photo.c"
		}
		__finally274:
		{
			PhotoRow* _tmp3_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 6632 "Photo.c"
		}
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 6642 "Photo.c"
		}
	}
}


void photo_set_raw_developer (Photo* self, RawDeveloper d) {
	PhotoFileFormat _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Alteration* _tmp48_ = NULL;
	Alteration* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
#line 795 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 796 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 796 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 797 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6664 "Photo.c"
	}
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_is_raw_developer_available (self, RAW_DEVELOPER_CAMERA);
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 6670 "Photo.c"
		RawDeveloper _tmp3_ = 0;
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = d;
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp3_ == RAW_DEVELOPER_EMBEDDED;
#line 6676 "Photo.c"
	} else {
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = FALSE;
#line 6680 "Photo.c"
	}
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 803 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_CAMERA;
#line 6686 "Photo.c"
	}
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_is_raw_developer_available (self, RAW_DEVELOPER_EMBEDDED);
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp4_) {
#line 808 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_SHOTWELL;
#line 6694 "Photo.c"
	}
	{
		GeeHashMap* _tmp5_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 6702 "Photo.c"
		{
			RawDeveloper stale_raw_developer = 0;
			PhotoRow* _tmp6_ = NULL;
			RawDeveloper _tmp7_ = 0;
			RawDeveloper _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
			GeeHashMap* _tmp15_ = NULL;
			RawDeveloper _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			PhotoRow* _tmp19_ = NULL;
			RawDeveloper _tmp20_ = 0;
			GeeHashMap* _tmp21_ = NULL;
			RawDeveloper _tmp22_ = 0;
			gpointer _tmp23_ = NULL;
			PhotoBackingReaders* _tmp24_ = NULL;
			BackingPhotoRow* _tmp25_ = NULL;
			PhotoFileFormat _tmp26_ = 0;
			BackingPhotoRow* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			PhotoFileReader* _tmp29_ = NULL;
			BackingPhotoRow* _tmp30_ = NULL;
			Orientation _tmp31_ = 0;
			gboolean _tmp41_ = FALSE;
			RawDeveloper _tmp42_ = 0;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->developer;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			stale_raw_developer = _tmp7_;
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = d;
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = photo_is_raw_developer_complete (self, _tmp8_);
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp9_) {
#line 6739 "Photo.c"
				RawDeveloper _tmp10_ = 0;
#line 815 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = d;
#line 815 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_develop_photo (self, _tmp10_);
#line 6745 "Photo.c"
				{
					GdkPixbuf* _tmp11_ = NULL;
					GdkPixbuf* _tmp12_ = NULL;
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = photo_get_prefetched_copy (self, &_inner_error_);
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = _tmp11_;
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp12_);
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6757 "Photo.c"
						goto __catch276_g_error;
					}
				}
				goto __finally276;
				__catch276_g_error:
				{
					GError* e = NULL;
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
					e = _inner_error_;
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
					_inner_error_ = NULL;
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (e);
#line 6771 "Photo.c"
					{
						GeeHashMap* _tmp13_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6778 "Photo.c"
					}
#line 820 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6782 "Photo.c"
				}
				__finally276:
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6787 "Photo.c"
					{
						GeeHashMap* _tmp14_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6794 "Photo.c"
					}
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 816 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6802 "Photo.c"
				}
			}
#line 823 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->priv->developments;
#line 823 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = d;
#line 823 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp16_));
#line 823 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp17_) {
#line 6813 "Photo.c"
				{
					GeeHashMap* _tmp18_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6820 "Photo.c"
				}
#line 824 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6824 "Photo.c"
			}
#line 827 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_revert_to_master (self, FALSE);
#line 830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = d;
#line 830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_->developer = _tmp20_;
#line 831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = self->priv->developments;
#line 831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = d;
#line 831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp22_));
#line 831 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 831 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = (BackingPhotoRow*) _tmp23_;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = self->priv->readers;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = self->backing_photo_row;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = _tmp25_->file_format;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = self->backing_photo_row;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = _tmp27_->filepath;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = photo_file_format_create_reader (_tmp26_, _tmp28_);
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp24_->developer);
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_->developer = _tmp29_;
#line 834 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = self->backing_photo_row;
#line 834 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _tmp30_->original_orientation;
#line 834 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, _tmp31_);
#line 6866 "Photo.c"
			{
				PhotoTable* _tmp32_ = NULL;
				PhotoTable* _tmp33_ = NULL;
				PhotoRow* _tmp34_ = NULL;
				RawDeveloper _tmp35_ = 0;
				BackingPhotoRow* _tmp36_ = NULL;
				BackingPhotoID _tmp37_ = {0};
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = photo_table_get_instance ();
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp32_;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = self->row;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = d;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = self->backing_photo_row;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_->id;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_raw_development (_tmp33_, _tmp34_, _tmp35_, &_tmp37_, &_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp33_);
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6892 "Photo.c"
					goto __catch277_g_error;
				}
			}
			goto __finally277;
			__catch277_g_error:
			{
				GError* e = NULL;
				GError* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = e;
#line 839 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = _tmp38_->message;
#line 839 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:839: Error updating database: %s", _tmp39_);
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6914 "Photo.c"
			}
			__finally277:
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6919 "Photo.c"
				{
					GeeHashMap* _tmp40_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp40_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6926 "Photo.c"
				}
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 836 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6934 "Photo.c"
			}
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = stale_raw_developer;
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp42_ != RAW_DEVELOPER_CAMERA) {
#line 6940 "Photo.c"
				RawDeveloper _tmp43_ = 0;
				PhotoRow* _tmp44_ = NULL;
				RawDeveloper _tmp45_ = 0;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = stale_raw_developer;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = self->row;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = _tmp44_->developer;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = _tmp43_ != _tmp45_;
#line 6952 "Photo.c"
			} else {
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = FALSE;
#line 6956 "Photo.c"
			}
#line 846 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp41_) {
#line 6960 "Photo.c"
				RawDeveloper _tmp46_ = 0;
#line 850 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = stale_raw_developer;
#line 850 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_delete_raw_development (self, _tmp46_);
#line 6966 "Photo.c"
			}
		}
		__finally275:
		{
			GeeHashMap* _tmp47_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp47_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6976 "Photo.c"
		}
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 6986 "Photo.c"
		}
	}
#line 857 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = alteration_new ("image", "developer");
#line 857 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = _tmp48_;
#line 857 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp49_);
#line 857 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp49_);
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_discard_prefetched (self);
#line 6999 "Photo.c"
}


RawDeveloper photo_get_raw_developer (Photo* self) {
	RawDeveloper result = 0;
	PhotoRow* _tmp0_ = NULL;
	RawDeveloper _tmp1_ = 0;
#line 861 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 862 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 862 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->developer;
#line 862 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 862 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7017 "Photo.c"
}


static gboolean photo_delete_raw_development (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 867 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 868 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = FALSE;
#line 7029 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 7036 "Photo.c"
		{
			GeeHashMap* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
			gboolean _tmp3_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			RawDeveloper _tmp7_ = 0;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			BackingPhotoRow* bpr = NULL;
			GeeHashMap* _tmp10_ = NULL;
			RawDeveloper _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			BackingPhotoRow* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			GeeHashMap* _tmp37_ = NULL;
			RawDeveloper _tmp38_ = 0;
			gboolean _tmp39_ = FALSE;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp2_));
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp3_) {
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 7065 "Photo.c"
				{
					GeeHashMap* _tmp4_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp4_ = self->priv->developments;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7072 "Photo.c"
				}
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7076 "Photo.c"
			}
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_;
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = d;
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = raw_developer_to_string (_tmp7_);
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_;
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			g_debug ("Photo.vala:876: Delete raw development: %s %s", _tmp6_, _tmp9_);
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp9_);
#line 876 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp6_);
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->priv->developments;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = d;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp11_));
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			bpr = (BackingPhotoRow*) _tmp12_;
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = bpr;
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->filepath;
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp14_ != NULL) {
#line 7108 "Photo.c"
				GFile* f = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = bpr;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->filepath;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = g_file_new_for_path (_tmp16_);
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
				f = _tmp17_;
#line 7121 "Photo.c"
				{
					RawDeveloper _tmp18_ = 0;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = d;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp18_ == RAW_DEVELOPER_CAMERA) {
#line 7128 "Photo.c"
						GFile* _tmp19_ = NULL;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp19_ = f;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_trash (_tmp19_, NULL, &_inner_error_);
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7136 "Photo.c"
							goto __catch279_g_error;
						}
					} else {
						GFile* _tmp20_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp20_ = f;
#line 884 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_delete (_tmp20_, NULL, &_inner_error_);
#line 884 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7147 "Photo.c"
							goto __catch279_g_error;
						}
					}
				}
				goto __finally279;
				__catch279_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					GError* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					e = _inner_error_;
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_inner_error_ = NULL;
#line 886 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = bpr;
#line 886 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp22_ = _tmp21_->filepath;
#line 886 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp23_ = e;
#line 886 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp24_ = _tmp23_->message;
#line 886 "/home/jens/Source/shotwell/src/Photo.vala"
					g_warning ("Photo.vala:886: Unable to delete RAW development: %s error: %s", _tmp22_, _tmp24_);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (e);
#line 7176 "Photo.c"
				}
				__finally279:
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 7189 "Photo.c"
					{
						GeeHashMap* _tmp25_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = self->priv->developments;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7196 "Photo.c"
					}
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
					return FALSE;
#line 7204 "Photo.c"
				}
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (f);
#line 7208 "Photo.c"
			}
			{
				PhotoTable* _tmp26_ = NULL;
				PhotoTable* _tmp27_ = NULL;
				PhotoRow* _tmp28_ = NULL;
				RawDeveloper _tmp29_ = 0;
				BackingPhotoTable* _tmp30_ = NULL;
				BackingPhotoTable* _tmp31_ = NULL;
				BackingPhotoRow* _tmp32_ = NULL;
				BackingPhotoID _tmp33_ = {0};
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = photo_table_get_instance ();
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = self->row;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = d;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_remove_development (_tmp27_, _tmp28_, _tmp29_, &_inner_error_);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp27_);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7233 "Photo.c"
					goto __catch280_g_error;
				}
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = backing_photo_table_get_instance ();
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = _tmp30_;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = bpr;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp32_->id;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_remove (_tmp31_, &_tmp33_, &_inner_error_);
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp31_);
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7250 "Photo.c"
					goto __catch280_g_error;
				}
			}
			goto __finally280;
			__catch280_g_error:
			{
				GError* e = NULL;
				GError* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 895 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = e;
#line 895 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = _tmp34_->message;
#line 895 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:895: Database error while deleting RAW development: %s", _tmp35_);
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 7272 "Photo.c"
			}
			__finally280:
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 7281 "Photo.c"
				{
					GeeHashMap* _tmp36_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp36_ = self->priv->developments;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7288 "Photo.c"
				}
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 891 "/home/jens/Source/shotwell/src/Photo.vala"
				return FALSE;
#line 7296 "Photo.c"
			}
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = self->priv->developments;
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = d;
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp38_), NULL);
#line 898 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp39_;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (bpr);
#line 7308 "Photo.c"
		}
		__finally278:
		{
			GeeHashMap* _tmp40_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = self->priv->developments;
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7317 "Photo.c"
		}
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 870 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 7327 "Photo.c"
		}
	}
#line 901 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
	result = ret;
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7336 "Photo.c"
}


void photo_redevelop_raw (Photo* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
#line 906 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 7344 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 7351 "Photo.c"
		{
			RawDeveloper _tmp1_ = 0;
			RawDeveloper dev = 0;
			RawDeveloper _tmp2_ = 0;
			RawDeveloper _tmp3_ = 0;
			RawDeveloper _tmp4_ = 0;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = d;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_delete_raw_development (self, _tmp1_);
#line 909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 909 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = _tmp2_;
#line 910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = dev;
#line 910 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ == RAW_DEVELOPER_CAMERA) {
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
				dev = RAW_DEVELOPER_EMBEDDED;
#line 7372 "Photo.c"
			}
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = dev;
#line 913 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_raw_developer (self, _tmp4_);
#line 7378 "Photo.c"
		}
		__finally281:
		{
			GeeHashMap* _tmp5_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->developments;
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7387 "Photo.c"
		}
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 7397 "Photo.c"
		}
	}
}


static void _vala_array_add85 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7410 "Photo.c"
	}
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7416 "Photo.c"
}


static void _vala_array_add86 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7427 "Photo.c"
	}
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7433 "Photo.c"
}


static void _vala_array_add87 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7444 "Photo.c"
	}
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7450 "Photo.c"
}


static BackingFileState** photo_real_get_backing_files_state (MediaSource* base, int* result_length1) {
	Photo * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_ = NULL;
	gint backing_length1 = 0;
	gint _backing_size_ = 0;
	BackingFileState** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	GError * _inner_error_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_new0 (BackingFileState*, 0 + 1);
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_length1 = 0;
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_size_ = backing_length1;
#line 7474 "Photo.c"
	{
		PhotoRow* _tmp1_ = NULL;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 7481 "Photo.c"
		{
			BackingFileState** _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			PhotoRow* _tmp3_ = NULL;
			BackingPhotoRow* _tmp4_ = NULL;
			PhotoRow* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			BackingFileState* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp12_ = FALSE;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = backing;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2__length1 = backing_length1;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->master;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->md5;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = backing_file_state_new_from_photo_row (_tmp4_, _tmp6_);
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add85 (&backing, &backing_length1, &_backing_size_, _tmp7_);
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = photo_has_editable (self);
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_) {
#line 7512 "Photo.c"
				BackingFileState** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				BackingPhotoRow* _tmp10_ = NULL;
				BackingFileState* _tmp11_ = NULL;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = backing;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9__length1 = backing_length1;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->priv->editable;
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = backing_file_state_new_from_photo_row (_tmp10_, NULL);
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_array_add86 (&backing, &backing_length1, &_backing_size_, _tmp11_);
#line 7527 "Photo.c"
			}
#line 924 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_is_developed (self);
#line 924 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp12_) {
#line 7533 "Photo.c"
				GeeCollection* dev_rows = NULL;
				GeeCollection* _tmp13_ = NULL;
				GeeCollection* _tmp14_ = NULL;
#line 925 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = photo_get_raw_development_photo_rows (self);
#line 925 "/home/jens/Source/shotwell/src/Photo.vala"
				dev_rows = _tmp13_;
#line 926 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = dev_rows;
#line 926 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp14_ != NULL) {
#line 7545 "Photo.c"
					{
						GeeIterator* _r_it = NULL;
						GeeCollection* _tmp15_ = NULL;
						GeeIterator* _tmp16_ = NULL;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = dev_rows;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
						_r_it = _tmp16_;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
						while (TRUE) {
#line 7558 "Photo.c"
							GeeIterator* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							BackingPhotoRow* r = NULL;
							GeeIterator* _tmp19_ = NULL;
							gpointer _tmp20_ = NULL;
							BackingPhotoRow* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							BackingFileState** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							BackingPhotoRow* _tmp24_ = NULL;
							BackingFileState* _tmp25_ = NULL;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = _r_it;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = gee_iterator_next (_tmp17_);
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							if (!_tmp18_) {
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
								break;
#line 7578 "Photo.c"
							}
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _r_it;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = gee_iterator_get (_tmp19_);
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							r = (BackingPhotoRow*) _tmp20_;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = r;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = _tmp21_->filepath;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:928: adding: %s", _tmp22_);
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = backing;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23__length1 = backing_length1;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = r;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = backing_file_state_new_from_photo_row (_tmp24_, NULL);
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_vala_array_add87 (&backing, &backing_length1, &_backing_size_, _tmp25_);
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (r);
#line 7604 "Photo.c"
						}
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_r_it);
#line 7608 "Photo.c"
					}
				}
#line 924 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (dev_rows);
#line 7613 "Photo.c"
			}
		}
		__finally282:
		{
			PhotoRow* _tmp26_ = NULL;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = self->row;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 7623 "Photo.c"
		}
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 7635 "Photo.c"
		}
	}
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = backing;
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27__length1 = backing_length1;
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp27__length1;
#line 7646 "Photo.c"
	}
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp27_;
#line 935 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7652 "Photo.c"
}


static PhotoFileReader* photo_get_backing_reader (Photo* self, BackingFetchMode mode) {
	PhotoFileReader* result = NULL;
	BackingFetchMode _tmp0_ = 0;
#line 938 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = mode;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp0_) {
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_MASTER:
#line 7667 "Photo.c"
		{
			PhotoFileReader* _tmp1_ = NULL;
#line 941 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_get_master_reader (self);
#line 941 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 941 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7676 "Photo.c"
		}
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_BASELINE:
#line 7680 "Photo.c"
		{
			PhotoFileReader* _tmp2_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = photo_get_baseline_reader (self);
#line 944 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 944 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7689 "Photo.c"
		}
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_SOURCE:
#line 7693 "Photo.c"
		{
			PhotoFileReader* _tmp3_ = NULL;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_get_source_reader (self);
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 947 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7702 "Photo.c"
		}
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_UNMODIFIED:
#line 7706 "Photo.c"
		{
			PhotoFileFormat _tmp4_ = 0;
#line 950 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_master_file_format (self);
#line 950 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ == PHOTO_FILE_FORMAT_RAW) {
#line 7713 "Photo.c"
				PhotoFileReader* _tmp5_ = NULL;
#line 951 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_get_raw_developer_reader (self);
#line 951 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 951 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7721 "Photo.c"
			} else {
				PhotoFileReader* _tmp6_ = NULL;
#line 953 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_get_master_reader (self);
#line 953 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp6_;
#line 953 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7730 "Photo.c"
			}
		}
		default:
		{
			BackingFetchMode _tmp7_ = 0;
			GEnumValue* _tmp8_;
#line 956 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = mode;
#line 956 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = g_enum_get_value (g_type_class_ref (TYPE_BACKING_FETCH_MODE), _tmp7_);
#line 956 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:956: Unknown backing fetch mode %s", (_tmp8_ != NULL) ? _tmp8_->value_name : NULL);
#line 7743 "Photo.c"
		}
	}
}


static gpointer _photo_file_adapter_ref0 (gpointer self) {
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_file_adapter_ref (self) : NULL;
#line 7752 "Photo.c"
}


static PhotoFileReader* photo_get_master_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 960 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7761 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7768 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 7781 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7788 "Photo.c"
			}
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7792 "Photo.c"
		}
		__finally283:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7801 "Photo.c"
		}
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 7809 "Photo.c"
	}
}


PhotoFileReader* photo_get_editable_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 966 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7819 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7826 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 7839 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7846 "Photo.c"
			}
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7850 "Photo.c"
		}
		__finally284:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7859 "Photo.c"
		}
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 7867 "Photo.c"
	}
}


static PhotoFileReader* photo_get_baseline_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7877 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7884 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoBackingReaders* _tmp7_ = NULL;
			PhotoFileReader* _tmp8_ = NULL;
			PhotoBackingReaders* _tmp13_ = NULL;
			PhotoFileReader* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 7899 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 7911 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7918 "Photo.c"
				}
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7922 "Photo.c"
			}
#line 978 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 978 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 978 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 7930 "Photo.c"
				PhotoBackingReaders* _tmp9_ = NULL;
				PhotoFileReader* _tmp10_ = NULL;
				PhotoFileReader* _tmp11_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 7942 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7949 "Photo.c"
				}
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7953 "Photo.c"
			}
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 7963 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7970 "Photo.c"
			}
#line 981 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7974 "Photo.c"
		}
		__finally285:
		{
			PhotoBackingReaders* _tmp17_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7983 "Photo.c"
		}
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 7991 "Photo.c"
	}
}


static PhotoFileReader* photo_get_source_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8001 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8008 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoBackingReaders* _tmp7_ = NULL;
			PhotoFileReader* _tmp8_ = NULL;
			PhotoBackingReaders* _tmp13_ = NULL;
			PhotoFileReader* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8023 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 8035 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8042 "Photo.c"
				}
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8046 "Photo.c"
			}
#line 991 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 991 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 991 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 8054 "Photo.c"
				PhotoBackingReaders* _tmp9_ = NULL;
				PhotoFileReader* _tmp10_ = NULL;
				PhotoFileReader* _tmp11_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 8066 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8073 "Photo.c"
				}
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8077 "Photo.c"
			}
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 8087 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8094 "Photo.c"
			}
#line 994 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8098 "Photo.c"
		}
		__finally286:
		{
			PhotoBackingReaders* _tmp17_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8107 "Photo.c"
		}
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8115 "Photo.c"
	}
}


static PhotoFileReader* photo_get_raw_developer_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8125 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8132 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8145 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8152 "Photo.c"
			}
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8156 "Photo.c"
		}
		__finally287:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8165 "Photo.c"
		}
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8173 "Photo.c"
	}
}


gboolean photo_is_developed (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1005 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8183 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8190 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8200 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8207 "Photo.c"
			}
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8211 "Photo.c"
		}
		__finally288:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8220 "Photo.c"
		}
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8228 "Photo.c"
	}
}


gboolean photo_has_editable (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1011 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8238 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8245 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8255 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8262 "Photo.c"
			}
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8266 "Photo.c"
		}
		__finally289:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8275 "Photo.c"
		}
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8283 "Photo.c"
	}
}


gboolean photo_does_master_exist (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1017 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8293 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8300 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8313 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8320 "Photo.c"
			}
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8324 "Photo.c"
		}
		__finally290:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8333 "Photo.c"
		}
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8341 "Photo.c"
	}
}


gboolean photo_does_editable_exist (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1024 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8351 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8358 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->editable;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 8369 "Photo.c"
				PhotoBackingReaders* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->editable;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 8381 "Photo.c"
			} else {
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 8385 "Photo.c"
			}
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8389 "Photo.c"
			{
				PhotoBackingReaders* _tmp7_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->readers;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8396 "Photo.c"
			}
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8400 "Photo.c"
		}
		__finally291:
		{
			PhotoBackingReaders* _tmp8_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->priv->readers;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8409 "Photo.c"
		}
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8417 "Photo.c"
	}
}


gboolean photo_is_master_baseline (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1030 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8427 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8434 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ == NULL;
#line 8444 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8451 "Photo.c"
			}
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8455 "Photo.c"
		}
		__finally292:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8464 "Photo.c"
		}
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8472 "Photo.c"
	}
}


gboolean photo_is_master_source (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1036 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1037 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_editable (self);
#line 1037 "/home/jens/Source/shotwell/src/Photo.vala"
	result = !_tmp0_;
#line 1037 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8488 "Photo.c"
}


gboolean photo_is_editable_baseline (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1040 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8497 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8504 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8514 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8521 "Photo.c"
			}
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8525 "Photo.c"
		}
		__finally293:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8534 "Photo.c"
		}
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 8542 "Photo.c"
	}
}


gboolean photo_is_editable_source (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1046 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_editable (self);
#line 1047 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1047 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8558 "Photo.c"
}


BackingPhotoRow* photo_get_master_photo_row (Photo* self) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1050 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8567 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8574 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoRow* _tmp2_ = NULL;
			BackingPhotoRow* _tmp3_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8587 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8594 "Photo.c"
			}
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8598 "Photo.c"
		}
		__finally294:
		{
			PhotoRow* _tmp5_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8607 "Photo.c"
		}
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8615 "Photo.c"
	}
}


BackingPhotoRow* photo_get_editable_photo_row (Photo* self) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1056 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8625 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8632 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 1059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = backing_photo_id_is_valid (&_tmp1_->editable_id);
#line 1059 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_) {
#line 8642 "Photo.c"
				BackingPhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->editable;
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _backing_photo_row_ref0 (_tmp3_);
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp4_;
#line 8651 "Photo.c"
				{
					PhotoRow* _tmp5_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp5_ = self->row;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8658 "Photo.c"
				}
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8662 "Photo.c"
			} else {
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
				result = NULL;
#line 8666 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8673 "Photo.c"
				}
#line 1062 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8677 "Photo.c"
			}
		}
		__finally295:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8687 "Photo.c"
		}
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8695 "Photo.c"
	}
}


GeeCollection* photo_get_raw_development_photo_rows (Photo* self) {
	GeeCollection* result = NULL;
	GError * _inner_error_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8705 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8712 "Photo.c"
		{
			GeeCollection* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8720 "Photo.c"
				GeeHashMap* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeCollection* _tmp5_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MAP, GeeMap));
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp5_;
#line 8734 "Photo.c"
			} else {
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 8740 "Photo.c"
			}
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8744 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8751 "Photo.c"
			}
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8755 "Photo.c"
		}
		__finally296:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8764 "Photo.c"
		}
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8772 "Photo.c"
	}
}


BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self, RawDeveloper d) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1072 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8782 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8789 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8797 "Photo.c"
				GeeHashMap* _tmp3_ = NULL;
				RawDeveloper _tmp4_ = 0;
				gpointer _tmp5_ = NULL;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = d;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp4_));
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = (BackingPhotoRow*) _tmp5_;
#line 8811 "Photo.c"
			} else {
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 8817 "Photo.c"
			}
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8821 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8828 "Photo.c"
			}
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8832 "Photo.c"
		}
		__finally297:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8841 "Photo.c"
		}
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8849 "Photo.c"
	}
}


static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self) {
	PhotoFileFormat* dup;
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	dup = g_new0 (PhotoFileFormat, 1);
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	memcpy (dup, self, sizeof (PhotoFileFormat));
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	return dup;
#line 8862 "Photo.c"
}


static gpointer __photo_file_format_dup0 (gpointer self) {
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? _photo_file_format_dup (self) : NULL;
#line 8869 "Photo.c"
}


PhotoFileFormat* photo_get_editable_file_format (Photo* self) {
	PhotoFileFormat* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	PhotoFileFormat* _tmp4_ = NULL;
#line 1078 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1079 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1079 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = reader;
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1081 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1081 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 1081 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 8897 "Photo.c"
	}
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = __photo_file_format_dup0 (&_tmp3_);
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1084 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8911 "Photo.c"
}


PhotoFileFormat photo_get_export_format_for_parameters (Photo* self, ExportFormatParameters* params) {
	PhotoFileFormat result = 0;
	PhotoFileFormat _result_ = 0;
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
	ExportFormatMode _tmp2_ = 0;
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1087 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, 0);
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = _tmp0_;
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *params;
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.mode;
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp2_) {
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 8937 "Photo.c"
		{
			PhotoFileFormat _tmp3_ = 0;
#line 1092 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_get_master_file_format (self);
#line 1092 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp3_;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 8946 "Photo.c"
		}
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 8950 "Photo.c"
		{
			PhotoFileFormat _tmp4_ = 0;
#line 1096 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_best_export_file_format (self);
#line 1096 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp4_;
#line 1097 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 8959 "Photo.c"
		}
#line 1090 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 8963 "Photo.c"
		{
			ExportFormatParameters _tmp5_ = {0};
			PhotoFileFormat _tmp6_ = 0;
#line 1100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *params;
#line 1100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_.specified_format;
#line 1100 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp6_;
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 8975 "Photo.c"
		}
		default:
		{
#line 1104 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1104: get_export_format_for_parameters: unsupported export " \
"format mode");
#line 8981 "Photo.c"
		}
	}
#line 1107 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1107 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8988 "Photo.c"
}


gchar* photo_get_export_basename_for_parameters (Photo* self, ExportFormatParameters* params) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ExportFormatParameters _tmp0_ = {0};
	ExportFormatMode _tmp1_ = 0;
	const gchar* _tmp8_ = NULL;
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1110 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, NULL);
#line 1111 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = NULL;
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *params;
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.mode;
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp1_) {
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 9012 "Photo.c"
		{
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_;
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = g_file_get_basename (_tmp3_);
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp4_;
#line 1115 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp3_);
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 9031 "Photo.c"
		}
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 1113 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 9037 "Photo.c"
		{
			ExportFormatParameters _tmp5_ = {0};
			PhotoFileFormat _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *params;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_get_export_format_for_parameters (self, &_tmp5_);
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_get_export_basename (self, &_tmp6_);
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp7_;
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1120 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9054 "Photo.c"
		}
		default:
		{
#line 1123 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1123: get_export_basename_for_parameters: unsupported expor" \
"t format mode");
#line 9060 "Photo.c"
		}
	}
#line 1126 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _result_;
#line 1126 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp8_ != NULL, "result != null");
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9071 "Photo.c"
}


ImportResult photo_prepare_for_import (PhotoImportParams* params) {
	ImportResult result = 0;
	GFile* file = NULL;
	PhotoImportParams* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileType _tmp8_ = 0;
	GFile* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GFile* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp19_ = NULL;
	GTimeVal _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	PhotoImportParams* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp32_ = NULL;
	PhotoImportParams* _tmp33_ = NULL;
	PhotoFileSnifferOptions _tmp34_ = 0;
	PhotoFileInterrogator* _tmp35_ = NULL;
	PhotoFileInterrogator* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp44_ = NULL;
	DetectedPhotoInformation* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	DetectedPhotoInformation* _tmp47_ = NULL;
	PhotoImportParams* _tmp50_ = NULL;
	PhotoFileSnifferOptions _tmp51_ = 0;
	Orientation orientation = 0;
	time_t exposure_time = 0;
	gchar* title = NULL;
	gchar* _tmp64_ = NULL;
	gchar* comment = NULL;
	gchar* _tmp65_ = NULL;
	Rating rating = 0;
	DetectedPhotoInformation* _tmp66_ = NULL;
	PhotoMetadata* _tmp67_ = NULL;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	DetectedPhotoInformation* _tmp92_ = NULL;
	GdkColorspace _tmp93_ = 0;
	PhotoImportParams* _tmp101_ = NULL;
	PhotoRow* _tmp102_ = NULL;
	PhotoImportParams* _tmp103_ = NULL;
	PhotoRow* _tmp104_ = NULL;
	BackingPhotoRow* _tmp105_ = NULL;
	GFile* _tmp106_ = NULL;
	gchar* _tmp107_ = NULL;
	PhotoImportParams* _tmp108_ = NULL;
	PhotoRow* _tmp109_ = NULL;
	BackingPhotoRow* _tmp110_ = NULL;
	DetectedPhotoInformation* _tmp111_ = NULL;
	Dimensions _tmp112_ = {0};
	PhotoImportParams* _tmp113_ = NULL;
	PhotoRow* _tmp114_ = NULL;
	BackingPhotoRow* _tmp115_ = NULL;
	GFileInfo* _tmp116_ = NULL;
	gint64 _tmp117_ = 0LL;
	PhotoImportParams* _tmp118_ = NULL;
	PhotoRow* _tmp119_ = NULL;
	BackingPhotoRow* _tmp120_ = NULL;
	GTimeVal _tmp121_ = {0};
	glong _tmp122_ = 0L;
	PhotoImportParams* _tmp123_ = NULL;
	PhotoRow* _tmp124_ = NULL;
	time_t _tmp125_ = 0;
	PhotoImportParams* _tmp126_ = NULL;
	PhotoRow* _tmp127_ = NULL;
	Orientation _tmp128_ = 0;
	PhotoImportParams* _tmp129_ = NULL;
	PhotoRow* _tmp130_ = NULL;
	BackingPhotoRow* _tmp131_ = NULL;
	Orientation _tmp132_ = 0;
	PhotoImportParams* _tmp133_ = NULL;
	PhotoRow* _tmp134_ = NULL;
	PhotoImportParams* _tmp135_ = NULL;
	ImportID _tmp136_ = {0};
	PhotoImportParams* _tmp137_ = NULL;
	PhotoRow* _tmp138_ = NULL;
	PhotoImportParams* _tmp139_ = NULL;
	PhotoRow* _tmp140_ = NULL;
	PhotoImportParams* _tmp141_ = NULL;
	PhotoRow* _tmp142_ = NULL;
	DetectedPhotoInformation* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	gchar* _tmp145_ = NULL;
	PhotoImportParams* _tmp146_ = NULL;
	PhotoRow* _tmp147_ = NULL;
	DetectedPhotoInformation* _tmp148_ = NULL;
	const gchar* _tmp149_ = NULL;
	gchar* _tmp150_ = NULL;
	PhotoImportParams* _tmp151_ = NULL;
	PhotoRow* _tmp152_ = NULL;
	DetectedPhotoInformation* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	gchar* _tmp155_ = NULL;
	PhotoImportParams* _tmp156_ = NULL;
	PhotoRow* _tmp157_ = NULL;
	PhotoImportParams* _tmp158_ = NULL;
	PhotoRow* _tmp159_ = NULL;
	PhotoImportParams* _tmp160_ = NULL;
	PhotoRow* _tmp161_ = NULL;
	BackingPhotoRow* _tmp162_ = NULL;
	DetectedPhotoInformation* _tmp163_ = NULL;
	PhotoFileFormat _tmp164_ = 0;
	PhotoImportParams* _tmp165_ = NULL;
	PhotoRow* _tmp166_ = NULL;
	const gchar* _tmp167_ = NULL;
	gchar* _tmp168_ = NULL;
	PhotoImportParams* _tmp169_ = NULL;
	PhotoRow* _tmp170_ = NULL;
	const gchar* _tmp171_ = NULL;
	gchar* _tmp172_ = NULL;
	PhotoImportParams* _tmp173_ = NULL;
	PhotoRow* _tmp174_ = NULL;
	Rating _tmp175_ = 0;
	PhotoImportParams* _tmp176_ = NULL;
	Thumbnails* _tmp177_ = NULL;
	GError * _inner_error_ = NULL;
#line 1142 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (params), 0);
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params;
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->file;
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1146 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 1148 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 9212 "Photo.c"
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileInfo* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = file;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = g_file_query_info (_tmp4_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp5_;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9226 "Photo.c"
			goto __catch298_g_error;
		}
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp3_;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = NULL;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp6_;
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 9239 "Photo.c"
	}
	goto __finally298;
	__catch298_g_error:
	{
		GError* err = NULL;
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1153 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 1153 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1153 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1153 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1153 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9259 "Photo.c"
	}
	__finally298:
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 9274 "Photo.c"
	}
#line 1156 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = info;
#line 1156 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 1156 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ != G_FILE_TYPE_REGULAR) {
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9290 "Photo.c"
	}
#line 1159 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = file;
#line 1159 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_is_file_image (_tmp9_);
#line 1159 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp10_) {
#line 9298 "Photo.c"
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = file;
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_;
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1160: Not importing %s: Not an image file", _tmp13_);
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp13_);
#line 1162 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1162 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1162 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1162 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9320 "Photo.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = file;
#line 1165 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_format_is_file_supported (_tmp14_);
#line 1165 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp15_) {
#line 9328 "Photo.c"
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = file;
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1166: Not importing %s: Unsupported extension", _tmp18_);
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp18_);
#line 1168 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1168 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1168 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1168 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9350 "Photo.c"
	}
#line 1171 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = info;
#line 1171 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp19_, &_tmp20_);
#line 1171 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp20_;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = params;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_->exif_md5;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp24_ != NULL) {
#line 9364 "Photo.c"
		PhotoImportParams* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = params;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = _tmp25_->thumbnail_md5;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp26_ != NULL;
#line 9373 "Photo.c"
	} else {
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = FALSE;
#line 9377 "Photo.c"
	}
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_) {
#line 9381 "Photo.c"
		PhotoImportParams* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = params;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->full_md5;
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp28_ != NULL;
#line 9390 "Photo.c"
	} else {
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = FALSE;
#line 9394 "Photo.c"
	}
#line 1174 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 9398 "Photo.c"
		PhotoImportParams* _tmp29_ = NULL;
		PhotoImportParams* _tmp30_ = NULL;
		PhotoFileSnifferOptions _tmp31_ = 0;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = params;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = params;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = _tmp30_->sniffer_options;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_->sniffer_options = _tmp31_ | PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 9410 "Photo.c"
	}
#line 1178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = file;
#line 1178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = params;
#line 1178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->sniffer_options;
#line 1178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_file_interrogator_new (_tmp32_, _tmp34_);
#line 1178 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp35_;
#line 9422 "Photo.c"
	{
		PhotoFileInterrogator* _tmp36_ = NULL;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = interrogator;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (_tmp36_, &_inner_error_);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9431 "Photo.c"
			goto __catch299_g_error;
		}
	}
	goto __finally299;
	__catch299_g_error:
	{
		GError* err = NULL;
		GFile* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = file;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = g_file_get_path (_tmp37_);
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp38_;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = err;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = _tmp40_->message;
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1182: Unable to interrogate photo file %s: %s", _tmp39_, _tmp41_);
#line 1182 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp39_);
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_DECODE_ERROR;
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1184 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9474 "Photo.c"
	}
	__finally299:
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 9491 "Photo.c"
	}
#line 1187 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = interrogator;
#line 1187 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = photo_file_interrogator_get_is_photo_corrupted (_tmp42_);
#line 1187 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp43_) {
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9509 "Photo.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = interrogator;
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = photo_file_interrogator_get_detected_photo_information (_tmp44_);
#line 1191 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp45_;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = detected;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp47_ == NULL) {
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = TRUE;
#line 9523 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp48_ = NULL;
		PhotoFileFormat _tmp49_ = 0;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = detected;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = _tmp48_->file_format;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp49_ == PHOTO_FILE_FORMAT_UNKNOWN;
#line 9533 "Photo.c"
	}
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp46_) {
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9549 "Photo.c"
	}
#line 1196 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = params;
#line 1196 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->sniffer_options;
#line 1196 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((_tmp51_ & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) != 0) {
#line 9557 "Photo.c"
		DetectedPhotoInformation* _tmp52_ = NULL;
		PhotoImportParams* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		DetectedPhotoInformation* _tmp56_ = NULL;
		PhotoImportParams* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		DetectedPhotoInformation* _tmp60_ = NULL;
		PhotoImportParams* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_ = detected;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = params;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = _tmp53_->exif_md5;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp55_ = g_strdup (_tmp54_);
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp52_->exif_md5);
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_->exif_md5 = _tmp55_;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp56_ = detected;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = params;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = _tmp57_->thumbnail_md5;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = g_strdup (_tmp58_);
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp56_->thumbnail_md5);
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp56_->thumbnail_md5 = _tmp59_;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = params;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = _tmp61_->full_md5;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = g_strdup (_tmp62_);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp60_->md5);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_->md5 = _tmp63_;
#line 9606 "Photo.c"
	}
#line 1202 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = ORIENTATION_TOP_LEFT;
#line 1203 "/home/jens/Source/shotwell/src/Photo.vala"
	exposure_time = (time_t) 0;
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp64_ = g_strdup ("");
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
	title = _tmp64_;
#line 1205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp65_ = g_strdup ("");
#line 1205 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = _tmp65_;
#line 1206 "/home/jens/Source/shotwell/src/Photo.vala"
	rating = RATING_UNRATED;
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp66_ = detected;
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp67_ = _tmp66_->metadata;
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp67_ != NULL) {
#line 9628 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp68_ = NULL;
		PhotoMetadata* _tmp69_ = NULL;
		MetadataDateTime* _tmp70_ = NULL;
		MetadataDateTime* _tmp71_ = NULL;
		DetectedPhotoInformation* _tmp74_ = NULL;
		PhotoMetadata* _tmp75_ = NULL;
		Orientation _tmp76_ = 0;
		DetectedPhotoInformation* _tmp77_ = NULL;
		PhotoMetadata* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		DetectedPhotoInformation* _tmp80_ = NULL;
		PhotoMetadata* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		PhotoImportParams* _tmp83_ = NULL;
		DetectedPhotoInformation* _tmp84_ = NULL;
		PhotoMetadata* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		DetectedPhotoInformation* _tmp87_ = NULL;
		PhotoMetadata* _tmp88_ = NULL;
		Rating _tmp89_ = 0;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = detected;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = _tmp68_->metadata;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = photo_metadata_get_exposure_date_time (_tmp69_);
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp70_;
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = date_time;
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp71_ != NULL) {
#line 9662 "Photo.c"
			MetadataDateTime* _tmp72_ = NULL;
			time_t _tmp73_ = 0;
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp72_ = date_time;
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp73_ = metadata_date_time_get_timestamp (_tmp72_);
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
			exposure_time = _tmp73_;
#line 9671 "Photo.c"
		}
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = detected;
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = _tmp74_->metadata;
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = photo_metadata_get_orientation (_tmp75_);
#line 1218 "/home/jens/Source/shotwell/src/Photo.vala"
		orientation = _tmp76_;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = detected;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = _tmp77_->metadata;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp79_;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = detected;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_->metadata;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp82_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp82_;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_ = params;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp84_ = detected;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp85_ = _tmp84_->metadata;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp86_ = photo_metadata_get_keywords (_tmp85_, NULL, NULL, NULL);
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp83_->keywords);
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_->keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp87_ = detected;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp88_ = _tmp87_->metadata;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp89_ = photo_metadata_get_rating (_tmp88_);
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		rating = _tmp89_;
#line 1213 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 9723 "Photo.c"
	}
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = detected;
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = _tmp92_->colorspace;
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp93_ != GDK_COLORSPACE_RGB) {
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = TRUE;
#line 9733 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp94_ = NULL;
		gint _tmp95_ = 0;
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp94_ = detected;
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp95_ = _tmp94_->channels;
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = _tmp95_ < 3;
#line 9743 "Photo.c"
	}
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp91_) {
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = TRUE;
#line 9749 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp96_ = NULL;
		gint _tmp97_ = 0;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp96_ = detected;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp97_ = _tmp96_->bits_per_channel;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = _tmp97_ != 8;
#line 9759 "Photo.c"
	}
#line 1226 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp90_) {
#line 9763 "Photo.c"
		GFile* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp98_ = file;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp99_ = g_file_get_path (_tmp98_);
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp100_ = _tmp99_;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1229: Not importing %s: Unsupported color format", _tmp100_);
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp100_);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1231 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9793 "Photo.c"
	}
#line 1237 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp101_ = params;
#line 1237 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp102_ = _tmp101_->row;
#line 1237 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp102_->photo_id, PHOTO_ID_INVALID);
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp103_ = params;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp104_ = _tmp103_->row;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_ = _tmp104_->master;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp106_ = file;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp107_ = g_file_get_path (_tmp106_);
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp105_->filepath);
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_->filepath = _tmp107_;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp108_ = params;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp109_ = _tmp108_->row;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp110_ = _tmp109_->master;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp111_ = detected;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp112_ = _tmp111_->image_dim;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp110_->dim = _tmp112_;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp113_ = params;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp114_ = _tmp113_->row;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp115_ = _tmp114_->master;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp116_ = info;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp117_ = g_file_info_get_size (_tmp116_);
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp115_->filesize = _tmp117_;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp118_ = params;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp119_ = _tmp118_->row;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_ = _tmp119_->master;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp121_ = timestamp;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_ = _tmp121_.tv_sec;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_->timestamp = (time_t) _tmp122_;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp123_ = params;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_ = _tmp123_->row;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp125_ = exposure_time;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_->exposure_time = _tmp125_;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp126_ = params;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_ = _tmp126_->row;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp128_ = orientation;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_->orientation = _tmp128_;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp129_ = params;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp130_ = _tmp129_->row;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp131_ = _tmp130_->master;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp132_ = orientation;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp131_->original_orientation = _tmp132_;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp133_ = params;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp134_ = _tmp133_->row;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp135_ = params;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp136_ = _tmp135_->import_id;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp134_->import_id = _tmp136_;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp137_ = params;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp138_ = _tmp137_->row;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp138_->event_id, EVENT_ID_INVALID);
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp139_ = params;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp140_ = _tmp139_->row;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp140_->transformations);
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp140_->transformations = NULL;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp141_ = params;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp142_ = _tmp141_->row;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp143_ = detected;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp144_ = _tmp143_->md5;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp145_ = g_strdup (_tmp144_);
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp142_->md5);
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp142_->md5 = _tmp145_;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp146_ = params;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp147_ = _tmp146_->row;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp148_ = detected;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp149_ = _tmp148_->thumbnail_md5;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp150_ = g_strdup (_tmp149_);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp147_->thumbnail_md5);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp147_->thumbnail_md5 = _tmp150_;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp151_ = params;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp152_ = _tmp151_->row;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp153_ = detected;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp154_ = _tmp153_->exif_md5;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp155_ = g_strdup (_tmp154_);
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp152_->exif_md5);
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp152_->exif_md5 = _tmp155_;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp156_ = params;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp157_ = _tmp156_->row;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp157_->time_created = (time_t) 0;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp158_ = params;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp159_ = _tmp158_->row;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp159_->flags = (guint64) 0;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp160_ = params;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp161_ = _tmp160_->row;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp162_ = _tmp161_->master;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp163_ = detected;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp164_ = _tmp163_->file_format;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp162_->file_format = _tmp164_;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp165_ = params;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp166_ = _tmp165_->row;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp167_ = title;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp168_ = g_strdup (_tmp167_);
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp166_->title);
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp166_->title = _tmp168_;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp169_ = params;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp170_ = _tmp169_->row;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp171_ = comment;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp172_ = g_strdup (_tmp171_);
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp170_->comment);
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp170_->comment = _tmp172_;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp173_ = params;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp174_ = _tmp173_->row;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp175_ = rating;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp174_->rating = _tmp175_;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp176_ = params;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp177_ = _tmp176_->thumbnails;
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp177_ != NULL) {
#line 10005 "Photo.c"
		PhotoFileReader* reader = NULL;
		PhotoImportParams* _tmp178_ = NULL;
		PhotoRow* _tmp179_ = NULL;
		BackingPhotoRow* _tmp180_ = NULL;
		PhotoFileFormat _tmp181_ = 0;
		PhotoImportParams* _tmp182_ = NULL;
		PhotoRow* _tmp183_ = NULL;
		BackingPhotoRow* _tmp184_ = NULL;
		const gchar* _tmp185_ = NULL;
		PhotoFileReader* _tmp186_ = NULL;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp178_ = params;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp179_ = _tmp178_->row;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp180_ = _tmp179_->master;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp181_ = _tmp180_->file_format;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp182_ = params;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp183_ = _tmp182_->row;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp184_ = _tmp183_->master;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp185_ = _tmp184_->filepath;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp186_ = photo_file_format_create_reader (_tmp181_, _tmp185_);
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		reader = _tmp186_;
#line 10036 "Photo.c"
		{
			PhotoImportParams* _tmp187_ = NULL;
			Thumbnails* _tmp188_ = NULL;
			PhotoFileReader* _tmp189_ = NULL;
			PhotoImportParams* _tmp190_ = NULL;
			PhotoRow* _tmp191_ = NULL;
			Orientation _tmp192_ = 0;
			PhotoImportParams* _tmp193_ = NULL;
			PhotoRow* _tmp194_ = NULL;
			BackingPhotoRow* _tmp195_ = NULL;
			Dimensions _tmp196_ = {0};
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp187_ = params;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp188_ = _tmp187_->thumbnails;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp189_ = reader;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp190_ = params;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp191_ = _tmp190_->row;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp192_ = _tmp191_->orientation;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp193_ = params;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp194_ = _tmp193_->row;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp195_ = _tmp194_->master;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp196_ = _tmp195_->dim;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			thumbnail_cache_generate_for_photo (_tmp188_, _tmp189_, _tmp192_, &_tmp196_, &_inner_error_);
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10072 "Photo.c"
				goto __catch300_g_error;
			}
		}
		goto __finally300;
		__catch300_g_error:
		{
			GError* err = NULL;
			GError* _tmp197_ = NULL;
			ImportResult _tmp198_ = 0;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp197_ = err;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp198_ = import_result_convert_error (_tmp197_, IMPORT_RESULT_FILE_ERROR);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp198_;
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1265 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 10110 "Photo.c"
		}
		__finally300:
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0;
#line 10135 "Photo.c"
		}
#line 1258 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 10139 "Photo.c"
	}
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1272 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10157 "Photo.c"
}


void photo_create_pre_import (PhotoImportParams* params) {
	GFile* file = NULL;
	PhotoImportParams* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	PhotoImportParams* _tmp3_ = NULL;
	PhotoRow* _tmp4_ = NULL;
	PhotoImportParams* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	PhotoImportParams* _tmp9_ = NULL;
	PhotoRow* _tmp10_ = NULL;
	BackingPhotoRow* _tmp11_ = NULL;
	PhotoImportParams* _tmp12_ = NULL;
	PhotoRow* _tmp13_ = NULL;
	BackingPhotoRow* _tmp14_ = NULL;
	PhotoImportParams* _tmp15_ = NULL;
	PhotoRow* _tmp16_ = NULL;
	BackingPhotoRow* _tmp17_ = NULL;
	PhotoImportParams* _tmp18_ = NULL;
	PhotoRow* _tmp19_ = NULL;
	PhotoImportParams* _tmp20_ = NULL;
	PhotoRow* _tmp21_ = NULL;
	PhotoImportParams* _tmp22_ = NULL;
	PhotoRow* _tmp23_ = NULL;
	BackingPhotoRow* _tmp24_ = NULL;
	PhotoImportParams* _tmp25_ = NULL;
	PhotoRow* _tmp26_ = NULL;
	PhotoImportParams* _tmp27_ = NULL;
	ImportID _tmp28_ = {0};
	PhotoImportParams* _tmp29_ = NULL;
	PhotoRow* _tmp30_ = NULL;
	PhotoImportParams* _tmp31_ = NULL;
	PhotoRow* _tmp32_ = NULL;
	PhotoImportParams* _tmp33_ = NULL;
	PhotoRow* _tmp34_ = NULL;
	PhotoImportParams* _tmp35_ = NULL;
	PhotoRow* _tmp36_ = NULL;
	PhotoImportParams* _tmp37_ = NULL;
	PhotoRow* _tmp38_ = NULL;
	PhotoImportParams* _tmp39_ = NULL;
	PhotoRow* _tmp40_ = NULL;
	PhotoImportParams* _tmp41_ = NULL;
	PhotoRow* _tmp42_ = NULL;
	PhotoImportParams* _tmp43_ = NULL;
	PhotoRow* _tmp44_ = NULL;
	BackingPhotoRow* _tmp45_ = NULL;
	PhotoImportParams* _tmp46_ = NULL;
	PhotoRow* _tmp47_ = NULL;
	PhotoImportParams* _tmp48_ = NULL;
	PhotoRow* _tmp49_ = NULL;
	PhotoImportParams* _tmp50_ = NULL;
	PhotoRow* _tmp51_ = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoImportParams* _tmp52_ = NULL;
	GFile* _tmp53_ = NULL;
	PhotoImportParams* _tmp54_ = NULL;
	PhotoFileSnifferOptions _tmp55_ = 0;
	PhotoFileInterrogator* _tmp56_ = NULL;
	GError * _inner_error_ = NULL;
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_IMPORT_PARAMS (params));
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params;
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->file;
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1276 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = params;
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_->row;
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp4_->photo_id, PHOTO_ID_INVALID);
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = params;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _tmp5_->row;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_->master;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_file_get_path (file);
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp7_->filepath);
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_->filepath = _tmp8_;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = params;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_->row;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_->master;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_tmp11_->dim, 0, 0);
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = params;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_->row;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_->master;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_->filesize = (gint64) 0;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = params;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_->row;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _tmp16_->master;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_->timestamp = (time_t) 0;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = params;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_->row;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->exposure_time = (time_t) 0;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = params;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = _tmp20_->row;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_->orientation = ORIENTATION_TOP_LEFT;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = params;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = _tmp22_->row;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_->master;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->original_orientation = ORIENTATION_TOP_LEFT;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = params;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = _tmp25_->row;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = params;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = _tmp27_->import_id;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_->import_id = _tmp28_;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = params;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = _tmp29_->row;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp30_->event_id, EVENT_ID_INVALID);
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = params;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = _tmp31_->row;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp32_->transformations);
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_->transformations = NULL;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = params;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->row;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp34_->md5);
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_->md5 = NULL;
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = params;
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_->row;
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp36_->thumbnail_md5);
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_->thumbnail_md5 = NULL;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = params;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->row;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp38_->exif_md5);
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_->exif_md5 = NULL;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = params;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->row;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_->time_created = (time_t) 0;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = params;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = _tmp41_->row;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_->flags = (guint64) 0;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = params;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = _tmp43_->row;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = _tmp44_->master;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_->file_format = PHOTO_FILE_FORMAT_JFIF;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp46_ = params;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = _tmp46_->row;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp47_->title);
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_->title = NULL;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = params;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = _tmp48_->row;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp49_->comment);
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_->comment = NULL;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = params;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->row;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_->rating = RATING_UNRATED;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp52_ = params;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp53_ = _tmp52_->file;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp54_ = params;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp55_ = _tmp54_->sniffer_options;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp56_ = photo_file_interrogator_new (_tmp53_, _tmp55_);
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp56_;
#line 10396 "Photo.c"
	{
		DetectedPhotoInformation* detected = NULL;
		DetectedPhotoInformation* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		DetectedPhotoInformation* _tmp60_ = NULL;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10407 "Photo.c"
			goto __catch301_g_error;
		}
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		detected = _tmp57_;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp60_ != NULL) {
#line 10418 "Photo.c"
			gboolean _tmp61_ = FALSE;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp61_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = !_tmp61_;
#line 10424 "Photo.c"
		} else {
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = FALSE;
#line 10428 "Photo.c"
		}
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp59_) {
#line 10432 "Photo.c"
			DetectedPhotoInformation* _tmp62_ = NULL;
			PhotoFileFormat _tmp63_ = 0;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp62_ = detected;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp63_ = _tmp62_->file_format;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = _tmp63_ != PHOTO_FILE_FORMAT_UNKNOWN;
#line 10441 "Photo.c"
		} else {
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = FALSE;
#line 10445 "Photo.c"
		}
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp58_) {
#line 10449 "Photo.c"
			PhotoImportParams* _tmp64_ = NULL;
			PhotoRow* _tmp65_ = NULL;
			BackingPhotoRow* _tmp66_ = NULL;
			DetectedPhotoInformation* _tmp67_ = NULL;
			PhotoFileFormat _tmp68_ = 0;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp64_ = params;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp65_ = _tmp64_->row;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_ = _tmp65_->master;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp67_ = detected;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp68_ = _tmp67_->file_format;
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_->file_format = _tmp68_;
#line 10467 "Photo.c"
		}
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 10471 "Photo.c"
	}
	goto __finally301;
	__catch301_g_error:
	{
		GError* err = NULL;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		GError* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = g_file_get_path (file);
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = _tmp69_;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = err;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = _tmp71_->message;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		g_debug ("Photo.vala:1305: Unable to interrogate photo file %s: %s", _tmp70_, _tmp72_);
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp70_);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 10499 "Photo.c"
	}
	__finally301:
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1299 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 10514 "Photo.c"
	}
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1275 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 10520 "Photo.c"
}


BackingPhotoRow* photo_query_backing_photo_row (Photo* self, GFile* file, PhotoFileSnifferOptions options, DetectedPhotoInformation** detected, GError** error) {
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* result = NULL;
	BackingPhotoRow* backing = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp10_ = NULL;
	PhotoFileSnifferOptions _tmp11_ = 0;
	PhotoFileInterrogator* _tmp12_ = NULL;
	PhotoFileInterrogator* _tmp13_ = NULL;
	PhotoFileInterrogator* _tmp14_ = NULL;
	DetectedPhotoInformation* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	DetectedPhotoInformation* _tmp17_ = NULL;
	GTimeVal modification_time = {0};
	GFileInfo* _tmp22_ = NULL;
	GTimeVal _tmp23_ = {0};
	BackingPhotoRow* _tmp24_ = NULL;
	GFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	BackingPhotoRow* _tmp27_ = NULL;
	GTimeVal _tmp28_ = {0};
	glong _tmp29_ = 0L;
	BackingPhotoRow* _tmp30_ = NULL;
	GFileInfo* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	BackingPhotoRow* _tmp33_ = NULL;
	DetectedPhotoInformation* _tmp34_ = NULL;
	PhotoFileFormat _tmp35_ = 0;
	BackingPhotoRow* _tmp36_ = NULL;
	DetectedPhotoInformation* _tmp37_ = NULL;
	Dimensions _tmp38_ = {0};
	Orientation _tmp39_ = 0;
	DetectedPhotoInformation* _tmp40_ = NULL;
	PhotoMetadata* _tmp41_ = NULL;
	BackingPhotoRow* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 1309 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1309 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = NULL;
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = backing_photo_row_new ();
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 10576 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = file;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = g_file_query_info (_tmp2_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp3_;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10590 "Photo.c"
			goto __catch302_g_error;
		}
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp1_;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp4_;
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 10603 "Photo.c"
	}
	goto __finally302;
	__catch302_g_error:
	{
		GError* err = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = file;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = err;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = _tmp8_->message;
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1320: Unable to read file information for %s: %s", _tmp7_, _tmp9_);
#line 1320 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp7_);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 10644 "Photo.c"
		} else {
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 10648 "Photo.c"
		}
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10652 "Photo.c"
	}
	__finally302:
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1316 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 10665 "Photo.c"
	}
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = file;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = options;
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = photo_file_interrogator_new (_tmp10_, _tmp11_);
#line 1326 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp12_;
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = interrogator;
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp13_, &_inner_error_);
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1327 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 10691 "Photo.c"
	}
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = interrogator;
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_interrogator_get_detected_photo_information (_tmp14_);
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp15_;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _vala_detected;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_ == NULL) {
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = TRUE;
#line 10707 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = interrogator;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = photo_file_interrogator_get_is_photo_corrupted (_tmp18_);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp19_;
#line 10717 "Photo.c"
	}
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 10721 "Photo.c"
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1330: Photo update: %s no longer a recognized image", _tmp21_);
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp21_);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 10744 "Photo.c"
		} else {
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 10748 "Photo.c"
		}
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10752 "Photo.c"
	}
#line 1335 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = info;
#line 1335 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp22_, &_tmp23_);
#line 1335 "/home/jens/Source/shotwell/src/Photo.vala"
	modification_time = _tmp23_;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = backing;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = file;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = g_file_get_path (_tmp25_);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp24_->filepath);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->filepath = _tmp26_;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = backing;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = modification_time;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = _tmp28_.tv_sec;
#line 1338 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_->timestamp = (time_t) _tmp29_;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = backing;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = info;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = g_file_info_get_size (_tmp31_);
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_->filesize = _tmp32_;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = backing;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _vala_detected;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = _tmp34_->file_format;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_->file_format = _tmp35_;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = backing;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = _vala_detected;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->image_dim;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_->dim = _tmp38_;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _vala_detected;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = _tmp40_->metadata;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp41_ != NULL) {
#line 10808 "Photo.c"
		DetectedPhotoInformation* _tmp42_ = NULL;
		PhotoMetadata* _tmp43_ = NULL;
		Orientation _tmp44_ = 0;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = _vala_detected;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = _tmp42_->metadata;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = photo_metadata_get_orientation (_tmp43_);
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp44_;
#line 10820 "Photo.c"
	} else {
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = ORIENTATION_TOP_LEFT;
#line 10824 "Photo.c"
	}
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = backing;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_->original_orientation = _tmp39_;
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing;
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 10840 "Photo.c"
	} else {
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 10844 "Photo.c"
	}
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10848 "Photo.c"
}


static void _vala_array_add88 (gchar*** array, int* length, int* size, gchar* value) {
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10859 "Photo.c"
	}
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10865 "Photo.c"
}


static void _vala_array_add89 (gchar*** array, int* length, int* size, gchar* value) {
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10876 "Photo.c"
	}
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10882 "Photo.c"
}


static void _vala_array_add90 (gchar*** array, int* length, int* size, gchar* value) {
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10893 "Photo.c"
	}
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10899 "Photo.c"
}


static void _vala_array_add91 (gchar*** array, int* length, int* size, gchar* value) {
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10910 "Photo.c"
	}
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10916 "Photo.c"
}


static void _vala_array_add92 (gchar*** array, int* length, int* size, gchar* value) {
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10927 "Photo.c"
	}
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10933 "Photo.c"
}


static void _vala_array_add93 (gchar*** array, int* length, int* size, gchar* value) {
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10944 "Photo.c"
	}
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10950 "Photo.c"
}


static gpointer _media_metadata_ref0 (gpointer self) {
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 10957 "Photo.c"
}


gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState** reimport_state, GError** error) {
	PhotoReimportMasterState* _vala_reimport_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	DetectedPhotoInformation* _tmp13_ = NULL;
	GdkColorspace _tmp14_ = 0;
	PhotoRow* updated_row = NULL;
	PhotoRow* _tmp22_ = NULL;
	gchar** list = NULL;
	gchar** _tmp27_ = NULL;
	gint list_length1 = 0;
	gint _list_size_ = 0;
	PhotoRow* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	DetectedPhotoInformation* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	PhotoRow* _tmp34_ = NULL;
	BackingPhotoRow* _tmp35_ = NULL;
	Orientation _tmp36_ = 0;
	BackingPhotoRow* _tmp37_ = NULL;
	Orientation _tmp38_ = 0;
	DetectedPhotoInformation* _tmp45_ = NULL;
	PhotoMetadata* _tmp46_ = NULL;
	PhotoRow* _tmp83_ = NULL;
	BackingPhotoRow* _tmp84_ = NULL;
	BackingPhotoRow* _tmp85_ = NULL;
	PhotoRow* _tmp86_ = NULL;
	DetectedPhotoInformation* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	PhotoRow* _tmp90_ = NULL;
	DetectedPhotoInformation* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	gchar* _tmp93_ = NULL;
	PhotoRow* _tmp94_ = NULL;
	DetectedPhotoInformation* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	PhotoMetadata* metadata = NULL;
	DetectedPhotoInformation* _tmp98_ = NULL;
	PhotoMetadata* _tmp99_ = NULL;
	PhotoRow* _tmp122_ = NULL;
	PhotoMetadata* _tmp123_ = NULL;
	gchar** _tmp124_ = NULL;
	gint _tmp124__length1 = 0;
	PhotoReimportMasterStateImpl* _tmp125_ = NULL;
	GError * _inner_error_ = NULL;
#line 1409 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1410 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1410 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = NULL;
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp3_;
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = file;
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_query_backing_photo_row (self, _tmp4_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, &_tmp5_, &_inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp6_;
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1415 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 11058 "Photo.c"
	}
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = backing;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_ == NULL) {
#line 11064 "Photo.c"
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 1418 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = file;
#line 1418 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 1418 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 1418 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1418: Unable to retrieve photo state from %s for reimport", _tmp10_);
#line 1418 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 11090 "Photo.c"
		} else {
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11094 "Photo.c"
		}
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11098 "Photo.c"
	}
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = detected;
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_->colorspace;
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp14_ != GDK_COLORSPACE_RGB) {
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 11108 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 1424 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = detected;
#line 1424 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_->channels;
#line 1424 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp16_ < 3;
#line 11118 "Photo.c"
	}
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = TRUE;
#line 11124 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp17_ = NULL;
		gint _tmp18_ = 0;
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = detected;
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_->bits_per_channel;
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp18_ != 8;
#line 11134 "Photo.c"
	}
#line 1423 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 11138 "Photo.c"
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = file;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = g_file_get_path (_tmp19_);
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1426: Not re-importing %s: Unsupported color format", _tmp21_);
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp21_);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 11164 "Photo.c"
		} else {
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11168 "Photo.c"
		}
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11172 "Photo.c"
	}
#line 1432 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = photo_row_new ();
#line 1432 "/home/jens/Source/shotwell/src/Photo.vala"
	updated_row = _tmp22_;
#line 11178 "Photo.c"
	{
		PhotoRow* _tmp23_ = NULL;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = self->row;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 11185 "Photo.c"
		{
			PhotoRow* _tmp24_ = NULL;
			PhotoRow* _tmp25_ = NULL;
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = self->row;
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = _photo_row_ref0 (_tmp24_);
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
			updated_row = _tmp25_;
#line 11197 "Photo.c"
		}
		__finally303:
		{
			PhotoRow* _tmp26_ = NULL;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = self->row;
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 11206 "Photo.c"
		}
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1433 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 11222 "Photo.c"
		}
	}
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = g_new0 (gchar*, 0 + 1);
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp27_;
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	list_length1 = 0;
#line 1438 "/home/jens/Source/shotwell/src/Photo.vala"
	_list_size_ = list_length1;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = updated_row;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = _tmp28_->md5;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = detected;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = _tmp30_->md5;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_strcmp0 (_tmp29_, _tmp31_) != 0) {
#line 11243 "Photo.c"
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gchar* _tmp33_ = NULL;
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = list;
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32__length1 = list_length1;
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = g_strdup ("metadata:md5");
#line 1441 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add88 (&list, &list_length1, &_list_size_, _tmp33_);
#line 11255 "Photo.c"
	}
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = updated_row;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = _tmp34_->master;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_->original_orientation;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = backing;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->original_orientation;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp36_ != _tmp38_) {
#line 11269 "Photo.c"
		gchar** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gchar* _tmp40_ = NULL;
		PhotoRow* _tmp41_ = NULL;
		BackingPhotoRow* _tmp42_ = NULL;
		BackingPhotoRow* _tmp43_ = NULL;
		Orientation _tmp44_ = 0;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = list;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39__length1 = list_length1;
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = g_strdup ("image:orientation");
#line 1444 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add89 (&list, &list_length1, &_list_size_, _tmp40_);
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = updated_row;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = _tmp41_->master;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = backing;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_->original_orientation;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_->original_orientation = _tmp44_;
#line 11295 "Photo.c"
	}
#line 1448 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = detected;
#line 1448 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp46_ = _tmp45_->metadata;
#line 1448 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp46_ != NULL) {
#line 11303 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp47_ = NULL;
		PhotoMetadata* _tmp48_ = NULL;
		MetadataDateTime* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		MetadataDateTime* _tmp51_ = NULL;
		PhotoRow* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		DetectedPhotoInformation* _tmp60_ = NULL;
		PhotoMetadata* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		PhotoRow* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		DetectedPhotoInformation* _tmp69_ = NULL;
		PhotoMetadata* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		PhotoRow* _tmp76_ = NULL;
		Rating _tmp77_ = 0;
		DetectedPhotoInformation* _tmp78_ = NULL;
		PhotoMetadata* _tmp79_ = NULL;
		Rating _tmp80_ = 0;
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = detected;
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = _tmp47_->metadata;
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = photo_metadata_get_exposure_date_time (_tmp48_);
#line 1449 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp49_;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = date_time;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp51_ != NULL) {
#line 11341 "Photo.c"
			PhotoRow* _tmp52_ = NULL;
			time_t _tmp53_ = 0;
			MetadataDateTime* _tmp54_ = NULL;
			time_t _tmp55_ = 0;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = updated_row;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp53_ = _tmp52_->exposure_time;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp54_ = date_time;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55_ = metadata_date_time_get_timestamp (_tmp54_);
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = _tmp53_ != _tmp55_;
#line 11356 "Photo.c"
		} else {
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = FALSE;
#line 11360 "Photo.c"
		}
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp50_) {
#line 11364 "Photo.c"
			gchar** _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			gchar* _tmp57_ = NULL;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = list;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56__length1 = list_length1;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp57_ = g_strdup ("metadata:exposure-time");
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add90 (&list, &list_length1, &_list_size_, _tmp57_);
#line 11376 "Photo.c"
		}
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = updated_row;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_->title;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = _tmp60_->metadata;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = _tmp62_;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp64_ = g_strcmp0 (_tmp59_, _tmp63_) != 0;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp63_);
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp64_) {
#line 11396 "Photo.c"
			gchar** _tmp65_ = NULL;
			gint _tmp65__length1 = 0;
			gchar* _tmp66_ = NULL;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp65_ = list;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp65__length1 = list_length1;
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_ = g_strdup ("metadata:name");
#line 1454 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add91 (&list, &list_length1, &_list_size_, _tmp66_);
#line 11408 "Photo.c"
		}
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = updated_row;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = _tmp67_->comment;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = detected;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = _tmp69_->metadata;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = _tmp71_;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = g_strcmp0 (_tmp68_, _tmp72_) != 0;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp72_);
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp73_) {
#line 11428 "Photo.c"
			gchar** _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gchar* _tmp75_ = NULL;
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp74_ = list;
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp74__length1 = list_length1;
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp75_ = g_strdup ("metadata:comment");
#line 1457 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add92 (&list, &list_length1, &_list_size_, _tmp75_);
#line 11440 "Photo.c"
		}
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = updated_row;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = _tmp76_->rating;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = detected;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = _tmp78_->metadata;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = photo_metadata_get_rating (_tmp79_);
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp77_ != _tmp80_) {
#line 11454 "Photo.c"
			gchar** _tmp81_ = NULL;
			gint _tmp81__length1 = 0;
			gchar* _tmp82_ = NULL;
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp81_ = list;
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp81__length1 = list_length1;
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp82_ = g_strdup ("metadata:rating");
#line 1460 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add93 (&list, &list_length1, &_list_size_, _tmp82_);
#line 11466 "Photo.c"
		}
#line 1448 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 11470 "Photo.c"
	}
#line 1463 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp83_ = updated_row;
#line 1463 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp84_ = backing;
#line 1463 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = _backing_photo_row_ref0 (_tmp84_);
#line 1463 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp83_->master);
#line 1463 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp83_->master = _tmp85_;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = updated_row;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp87_ = detected;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_ = _tmp87_->md5;
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp89_ = g_strdup (_tmp88_);
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp86_->md5);
#line 1464 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_->md5 = _tmp89_;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_ = updated_row;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp91_ = detected;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = _tmp91_->exif_md5;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = g_strdup (_tmp92_);
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp90_->exif_md5);
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_->exif_md5 = _tmp93_;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_ = updated_row;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp95_ = detected;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp96_ = _tmp95_->thumbnail_md5;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp97_ = g_strdup (_tmp96_);
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp94_->thumbnail_md5);
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_->thumbnail_md5 = _tmp97_;
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = NULL;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp98_ = detected;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp99_ = _tmp98_->metadata;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp99_ != NULL) {
#line 11526 "Photo.c"
		DetectedPhotoInformation* _tmp100_ = NULL;
		PhotoMetadata* _tmp101_ = NULL;
		PhotoMetadata* _tmp102_ = NULL;
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp103_ = NULL;
		PhotoMetadata* _tmp104_ = NULL;
		MetadataDateTime* _tmp105_ = NULL;
		MetadataDateTime* _tmp106_ = NULL;
		PhotoRow* _tmp110_ = NULL;
		DetectedPhotoInformation* _tmp111_ = NULL;
		PhotoMetadata* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		PhotoRow* _tmp114_ = NULL;
		DetectedPhotoInformation* _tmp115_ = NULL;
		PhotoMetadata* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		PhotoRow* _tmp118_ = NULL;
		DetectedPhotoInformation* _tmp119_ = NULL;
		PhotoMetadata* _tmp120_ = NULL;
		Rating _tmp121_ = 0;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp100_ = detected;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp101_ = _tmp100_->metadata;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp102_ = _media_metadata_ref0 (_tmp101_);
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
		metadata = _tmp102_;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp103_ = detected;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp104_ = _tmp103_->metadata;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp105_ = photo_metadata_get_exposure_date_time (_tmp104_);
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp105_;
#line 1473 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp106_ = date_time;
#line 1473 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp106_ != NULL) {
#line 11569 "Photo.c"
			PhotoRow* _tmp107_ = NULL;
			MetadataDateTime* _tmp108_ = NULL;
			time_t _tmp109_ = 0;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp107_ = updated_row;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp108_ = date_time;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp109_ = metadata_date_time_get_timestamp (_tmp108_);
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp107_->exposure_time = _tmp109_;
#line 11581 "Photo.c"
		}
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp110_ = updated_row;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp111_ = detected;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp112_ = _tmp111_->metadata;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp113_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp110_->title);
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp110_->title = _tmp113_;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp114_ = updated_row;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp115_ = detected;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp116_ = _tmp115_->metadata;
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp117_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp114_->comment);
#line 1477 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp114_->comment = _tmp117_;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp118_ = updated_row;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp119_ = detected;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp120_ = _tmp119_->metadata;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp121_ = photo_metadata_get_rating (_tmp120_);
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp118_->rating = _tmp121_;
#line 1469 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 11619 "Photo.c"
	}
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_ = updated_row;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp123_ = metadata;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_ = list;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124__length1 = list_length1;
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp125_ = photo_reimport_master_state_impl_new (_tmp122_, _tmp123_, _tmp124_, _tmp124__length1);
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1481 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (updated_row);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	if (reimport_state) {
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
		*reimport_state = _vala_reimport_state;
#line 11653 "Photo.c"
	} else {
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11657 "Photo.c"
	}
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 11661 "Photo.c"
}


static void photo_real_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata) {
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_apply_user_metadata_for_reimport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 11670 "Photo.c"
}


void photo_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata) {
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1486 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->apply_user_metadata_for_reimport (self, metadata);
#line 11679 "Photo.c"
}


static gpointer _photo_reimport_master_state_ref0 (gpointer self) {
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_master_state_ref (self) : NULL;
#line 11686 "Photo.c"
}


static void _vala_array_add94 (gchar*** array, int* length, int* size, gchar* value) {
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11697 "Photo.c"
	}
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11703 "Photo.c"
}


static void _vala_array_add95 (gchar*** array, int* length, int* size, gchar* value) {
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11714 "Photo.c"
	}
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11720 "Photo.c"
}


void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error) {
	PhotoReimportMasterStateImpl* reimport_state = NULL;
	PhotoReimportMasterState* _tmp0_ = NULL;
	PhotoReimportMasterStateImpl* _tmp1_ = NULL;
	PhotoTable* _tmp2_ = NULL;
	PhotoTable* _tmp3_ = NULL;
	PhotoRow* _tmp4_ = NULL;
	PhotoMetadata* _tmp20_ = NULL;
	gboolean _tmp22_ = FALSE;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	PhotoMetadata* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1489 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1489 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _photo_reimport_master_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl));
#line 1490 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp1_;
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_table_get_instance ();
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = reimport_state->row;
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_reimport (_tmp3_, _tmp4_, &_inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp3_);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 11769 "Photo.c"
		} else {
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 11779 "Photo.c"
		}
	}
	{
		PhotoRow* _tmp5_ = NULL;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = self->row;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 11788 "Photo.c"
		{
			BackingPhotoRow* original_master = NULL;
			PhotoRow* _tmp6_ = NULL;
			BackingPhotoRow* _tmp7_ = NULL;
			BackingPhotoRow* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoRow* _tmp10_ = NULL;
			PhotoRow* _tmp11_ = NULL;
			BackingPhotoRow* _tmp12_ = NULL;
			BackingPhotoRow* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			BackingPhotoRow* _tmp15_ = NULL;
			PhotoRow* _tmp16_ = NULL;
			BackingPhotoRow* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->master;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _backing_photo_row_ref0 (_tmp7_);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			original_master = _tmp8_;
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = reimport_state->row;
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _photo_row_ref0 (_tmp9_);
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (self->row);
#line 1497 "/home/jens/Source/shotwell/src/Photo.vala"
			self->row = _tmp10_;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = original_master;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _backing_photo_row_ref0 (_tmp12_);
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_tmp11_->master);
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_->master = _tmp13_;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->master;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = reimport_state->row;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_->master;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_row_copy_from (_tmp15_, _tmp17_);
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = reimport_state->metadata_only;
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp18_) {
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 11846 "Photo.c"
			}
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (original_master);
#line 11850 "Photo.c"
		}
		__finally304:
		{
			PhotoRow* _tmp19_ = NULL;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 11859 "Photo.c"
		}
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 11871 "Photo.c"
			} else {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 11881 "Photo.c"
			}
		}
	}
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = reimport_state->metadata;
#line 1504 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_ != NULL) {
#line 11889 "Photo.c"
		PhotoMetadata* _tmp21_ = NULL;
#line 1505 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = reimport_state->metadata;
#line 1505 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp21_);
#line 11895 "Photo.c"
	}
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = reimport_state->metadata_only;
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp22_) {
#line 11901 "Photo.c"
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = reimport_state->alterations;
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23__length1 = reimport_state->alterations_length1;
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = g_strdup ("image:master");
#line 1508 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add94 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp24_);
#line 1509 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = photo_is_master_baseline (self);
#line 1509 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp25_) {
#line 11918 "Photo.c"
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gchar* _tmp27_ = NULL;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = reimport_state->alterations;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26__length1 = reimport_state->alterations_length1;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = g_strdup ("image:baseline");
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add95 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp27_);
#line 11930 "Photo.c"
		}
	}
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = reimport_state->alterations;
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28__length1 = reimport_state->alterations_length1;
#line 1513 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp28__length1 > 0) {
#line 11939 "Photo.c"
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		Alteration* _tmp30_ = NULL;
		Alteration* _tmp31_ = NULL;
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = reimport_state->alterations;
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29__length1 = reimport_state->alterations_length1;
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = alteration_new_from_array (_tmp29_, _tmp29__length1);
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = _tmp30_;
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp31_);
#line 1514 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp31_);
#line 11956 "Photo.c"
	}
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = reimport_state->metadata;
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_master_reimported (self, _tmp32_);
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = photo_is_master_baseline (self);
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp33_) {
#line 11966 "Photo.c"
		PhotoMetadata* _tmp34_ = NULL;
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = reimport_state->metadata;
#line 1519 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp34_);
#line 11972 "Photo.c"
	}
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_is_master_source (self);
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp35_) {
#line 11978 "Photo.c"
		PhotoMetadata* _tmp36_ = NULL;
#line 1522 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = reimport_state->metadata;
#line 1522 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp36_);
#line 11984 "Photo.c"
	}
#line 1489 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (reimport_state);
#line 11988 "Photo.c"
}


static gboolean photo_verify_file_for_reimport (Photo* self, GFile* file, BackingPhotoRow** backing, DetectedPhotoInformation** detected, GError** error) {
	BackingPhotoRow* _vala_backing = NULL;
	DetectedPhotoInformation* _vala_detected = NULL;
	gboolean result = FALSE;
	BackingPhotoRow* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DetectedPhotoInformation* _tmp2_ = NULL;
	BackingPhotoRow* _tmp3_ = NULL;
	BackingPhotoRow* _tmp4_ = NULL;
	BackingPhotoRow* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	DetectedPhotoInformation* _tmp8_ = NULL;
	GdkColorspace _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 1526 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1526 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_query_backing_photo_row (self, _tmp1_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp2_, &_inner_error_);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp2_;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 12027 "Photo.c"
	}
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_vala_backing);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_backing = _tmp4_;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _vala_backing;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp5_ == NULL) {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 12049 "Photo.c"
		} else {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 12053 "Photo.c"
		}
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 12059 "Photo.c"
		} else {
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 12063 "Photo.c"
		}
#line 1531 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12067 "Photo.c"
	}
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _vala_detected;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_->colorspace;
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp9_ != GDK_COLORSPACE_RGB) {
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = TRUE;
#line 12077 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 1536 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _vala_detected;
#line 1536 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_->channels;
#line 1536 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp11_ < 3;
#line 12087 "Photo.c"
	}
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_) {
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = TRUE;
#line 12093 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _vala_detected;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_->bits_per_channel;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp13_ != 8;
#line 12103 "Photo.c"
	}
#line 1535 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_) {
#line 12107 "Photo.c"
		GFile* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = file;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = g_file_get_path (_tmp14_);
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1538: Not re-importing %s: Unsupported color format", _tmp16_);
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp16_);
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 12129 "Photo.c"
		} else {
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 12133 "Photo.c"
		}
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 12139 "Photo.c"
		} else {
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 12143 "Photo.c"
		}
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12147 "Photo.c"
	}
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp0_);
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
	if (backing) {
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		*backing = _vala_backing;
#line 12157 "Photo.c"
	} else {
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_vala_backing);
#line 12161 "Photo.c"
	}
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 12167 "Photo.c"
	} else {
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 12171 "Photo.c"
	}
#line 1543 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12175 "Photo.c"
}


gboolean photo_prepare_for_reimport_editable (Photo* self, PhotoReimportEditableState** state, GError** error) {
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	BackingPhotoRow* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	BackingPhotoRow* _tmp7_ = NULL;
	DetectedPhotoInformation* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoReimportEditableStateImpl* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 1547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1548 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1548 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1550 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_file (self);
#line 1550 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 1551 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1551 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12219 "Photo.c"
		} else {
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 12223 "Photo.c"
		}
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12227 "Photo.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = file;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_verify_file_for_reimport (self, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp4_;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp6_;
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 12255 "Photo.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp2_) {
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12271 "Photo.c"
		} else {
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 12275 "Photo.c"
		}
#line 1557 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12279 "Photo.c"
	}
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = backing;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = detected;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_->metadata;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_reimport_editable_state_impl_new (_tmp7_, _tmp9_);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 12305 "Photo.c"
	} else {
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 12309 "Photo.c"
	}
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12313 "Photo.c"
}


static gpointer _photo_reimport_editable_state_ref0 (gpointer self) {
#line 1570 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_editable_state_ref (self) : NULL;
#line 12320 "Photo.c"
}


void photo_finish_reimport_editable (Photo* self, PhotoReimportEditableState* state, GError** error) {
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	PhotoReimportEditableStateImpl* reimport_state = NULL;
	PhotoReimportEditableState* _tmp2_ = NULL;
	PhotoReimportEditableStateImpl* _tmp3_ = NULL;
	PhotoReimportEditableStateImpl* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	PhotoReimportEditableStateImpl* _tmp21_ = NULL;
	PhotoMetadata* _tmp22_ = NULL;
	gchar* list = NULL;
	gchar* _tmp36_ = NULL;
	PhotoReimportEditableStateImpl* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp41_ = NULL;
	Alteration* _tmp42_ = NULL;
	Alteration* _tmp43_ = NULL;
	PhotoReimportEditableStateImpl* _tmp44_ = NULL;
	PhotoMetadata* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp49_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1565 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1565 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 1566 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_editable_id (self, &_tmp0_);
#line 1566 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_id = _tmp0_;
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = backing_photo_id_is_invalid (&editable_id);
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 1568 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 12361 "Photo.c"
	}
#line 1570 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = state;
#line 1570 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _photo_reimport_editable_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl));
#line 1570 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp3_;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = reimport_state;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp4_->metadata_only;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp5_) {
#line 12375 "Photo.c"
		BackingPhotoTable* _tmp6_ = NULL;
		BackingPhotoTable* _tmp7_ = NULL;
		PhotoReimportEditableStateImpl* _tmp8_ = NULL;
		BackingPhotoRow* _tmp9_ = NULL;
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = backing_photo_table_get_instance ();
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = reimport_state;
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = _tmp8_->backing_state;
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_photo_table_update (_tmp7_, _tmp9_, &_inner_error_);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp7_);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12402 "Photo.c"
			} else {
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1573 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12412 "Photo.c"
			}
		}
		{
			PhotoRow* _tmp10_ = NULL;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 12421 "Photo.c"
			{
				PhotoReimportEditableStateImpl* _tmp11_ = NULL;
				BackingPhotoRow* _tmp12_ = NULL;
				BackingPhotoRow* _tmp13_ = NULL;
				PhotoReimportEditableStateImpl* _tmp14_ = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
				Orientation _tmp16_ = 0;
#line 1576 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = reimport_state;
#line 1576 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->backing_state;
#line 1576 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _backing_photo_row_ref0 (_tmp12_);
#line 1576 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->priv->editable);
#line 1576 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->editable = _tmp13_;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = reimport_state;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->backing_state;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->original_orientation;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_set_orientation (self, _tmp16_);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 12449 "Photo.c"
			}
			__finally305:
			{
				PhotoRow* _tmp17_ = NULL;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->row;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 12458 "Photo.c"
			}
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 12470 "Photo.c"
				} else {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 12480 "Photo.c"
				}
			}
		}
	} else {
		PhotoReimportEditableStateImpl* _tmp18_ = NULL;
		BackingPhotoRow* _tmp19_ = NULL;
		Orientation _tmp20_ = 0;
#line 1581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = reimport_state;
#line 1581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->backing_state;
#line 1581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_->original_orientation;
#line 1581 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_orientation (self, _tmp20_);
#line 12496 "Photo.c"
	}
#line 1584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = reimport_state;
#line 1584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = _tmp21_->metadata;
#line 1584 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_ != NULL) {
#line 12504 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp23_ = NULL;
		PhotoMetadata* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		PhotoReimportEditableStateImpl* _tmp27_ = NULL;
		PhotoMetadata* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		PhotoReimportEditableStateImpl* _tmp31_ = NULL;
		PhotoMetadata* _tmp32_ = NULL;
		Rating _tmp33_ = 0;
		PhotoReimportEditableStateImpl* _tmp34_ = NULL;
		PhotoMetadata* _tmp35_ = NULL;
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = reimport_state;
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = _tmp23_->metadata;
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = _tmp25_;
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp26_);
#line 1585 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp26_);
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = reimport_state;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->metadata;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = _tmp29_;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp30_);
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp30_);
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = reimport_state;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = _tmp31_->metadata;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = photo_metadata_get_rating (_tmp32_);
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp33_);
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = reimport_state;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _tmp34_->metadata;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp35_);
#line 12556 "Photo.c"
	}
#line 1591 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1591 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp36_;
#line 1592 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = reimport_state;
#line 1592 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->metadata_only;
#line 1592 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp38_) {
#line 12568 "Photo.c"
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = list;
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = g_strconcat (_tmp39_, "image:editable,image:baseline", NULL);
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp40_;
#line 12579 "Photo.c"
	}
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = list;
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = alteration_new_from_list (_tmp41_);
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = _tmp42_;
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp43_);
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp43_);
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = reimport_state;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = _tmp44_->metadata;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_editable_reimported (self, _tmp45_);
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp46_ = photo_is_editable_baseline (self);
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp46_) {
#line 12601 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp47_ = NULL;
		PhotoMetadata* _tmp48_ = NULL;
#line 1600 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = reimport_state;
#line 1600 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = _tmp47_->metadata;
#line 1600 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp48_);
#line 12610 "Photo.c"
	}
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = photo_is_editable_source (self);
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp49_) {
#line 12616 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp50_ = NULL;
		PhotoMetadata* _tmp51_ = NULL;
#line 1603 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp50_ = reimport_state;
#line 1603 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = _tmp50_->metadata;
#line 1603 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp51_);
#line 12625 "Photo.c"
	}
#line 1565 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1565 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (reimport_state);
#line 12631 "Photo.c"
}


static gpointer _photo_reimport_raw_development_state_ref0 (gpointer self) {
#line 1625 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_raw_development_state_ref (self) : NULL;
#line 12638 "Photo.c"
}


gboolean photo_prepare_for_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState** state, GError** error) {
	PhotoReimportRawDevelopmentState* _vala_state = NULL;
	gboolean result = FALSE;
	GeeCollection* files = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp18_ = NULL;
	PhotoReimportRawDevelopmentState* _tmp19_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 1607 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1608 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1608 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1610 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_raw_developer_files (self);
#line 1610 "/home/jens/Source/shotwell/src/Photo.vala"
	files = _tmp0_;
#line 1611 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = files;
#line 1611 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (files);
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12677 "Photo.c"
		} else {
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 12681 "Photo.c"
		}
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12685 "Photo.c"
	}
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_reimport_raw_development_state_impl_new ();
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp2_;
#line 12691 "Photo.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = files;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
		_file_it = _tmp4_;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 12704 "Photo.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DetectedPhotoInformation* detected = NULL;
			BackingPhotoRow* backing = NULL;
			gboolean _tmp9_ = FALSE;
			GFile* _tmp10_ = NULL;
			BackingPhotoRow* _tmp11_ = NULL;
			DetectedPhotoInformation* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			PhotoReimportRawDevelopmentStateImpl* _tmp14_ = NULL;
			BackingPhotoRow* _tmp15_ = NULL;
			DetectedPhotoInformation* _tmp16_ = NULL;
			PhotoMetadata* _tmp17_ = NULL;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _file_it;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp6_) {
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 12729 "Photo.c"
			}
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _file_it;
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			file = (GFile*) _tmp8_;
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = file;
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_verify_file_for_reimport (self, _tmp10_, &_tmp11_, &_tmp12_, &_inner_error_);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = _tmp11_;
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			detected = _tmp12_;
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp13_;
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_file_it);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (files);
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
				return FALSE;
#line 12769 "Photo.c"
			}
#line 1619 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp9_) {
#line 1620 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1620 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1620 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1620 "/home/jens/Source/shotwell/src/Photo.vala"
				continue;
#line 12781 "Photo.c"
			}
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = reimport_state;
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = backing;
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = detected;
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_->metadata;
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_reimport_raw_development_state_impl_add (_tmp14_, _tmp15_, _tmp17_);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 12799 "Photo.c"
		}
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_file_it);
#line 12803 "Photo.c"
	}
#line 1625 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = reimport_state;
#line 1625 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState));
#line 1625 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1625 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp19_;
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = reimport_state;
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = photo_reimport_raw_development_state_impl_get_size (_tmp20_);
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp21_ > 0;
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (files);
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 12827 "Photo.c"
	} else {
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 12831 "Photo.c"
	}
#line 1626 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12835 "Photo.c"
}


void photo_finish_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState* state, GError** error) {
	PhotoFileFormat _tmp0_ = 0;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentState* _tmp1_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_ = NULL;
	gchar* list = NULL;
	gchar* _tmp32_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp37_ = NULL;
	Alteration* _tmp38_ = NULL;
	Alteration* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
#line 1630 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1630 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE (state));
#line 1631 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 1631 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 12862 "Photo.c"
	}
#line 1634 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = state;
#line 1634 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl));
#line 1634 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp2_;
#line 12870 "Photo.c"
	{
		GeeIterator* _dev_it = NULL;
		PhotoReimportRawDevelopmentStateImpl* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reimport_state;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_->list;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		_dev_it = _tmp5_;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 12886 "Photo.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			PhotoReimportRawDevelopmentStateImplDevToReimport* dev = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PhotoReimportRawDevelopmentStateImpl* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _dev_it;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp7_) {
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 12902 "Photo.c"
			}
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _dev_it;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = (PhotoReimportRawDevelopmentStateImplDevToReimport*) _tmp9_;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = reimport_state;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = _tmp10_->metadata_only;
#line 1637 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp11_) {
#line 12916 "Photo.c"
				BackingPhotoTable* _tmp12_ = NULL;
				BackingPhotoTable* _tmp13_ = NULL;
				PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp14_ = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = backing_photo_table_get_instance ();
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = dev;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->backing;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update (_tmp13_, _tmp15_, &_inner_error_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp13_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						g_propagate_error (error, _inner_error_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 12947 "Photo.c"
					} else {
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 12961 "Photo.c"
					}
				}
				{
					PhotoRow* _tmp16_ = NULL;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = self->row;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_row);
#line 12970 "Photo.c"
					{
						gint _tmp17_ = 0;
						RawDeveloper* _tmp18_ = NULL;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = raw_developer_as_array (&_tmp17_);
#line 12976 "Photo.c"
						{
							RawDeveloper* d_collection = NULL;
							gint d_collection_length1 = 0;
							gint _d_collection_size_ = 0;
							gint d_it = 0;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = _tmp18_;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection_length1 = _tmp17_;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							for (d_it = 0; d_it < _tmp17_; d_it = d_it + 1) {
#line 12988 "Photo.c"
								RawDeveloper d = 0;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
								d = d_collection[d_it];
#line 12992 "Photo.c"
								{
									BackingPhotoID id = {0};
									PhotoRow* _tmp19_ = NULL;
									BackingPhotoID* _tmp20_ = NULL;
									gint _tmp20__length1 = 0;
									RawDeveloper _tmp21_ = 0;
									BackingPhotoID _tmp22_ = {0};
									BackingPhotoID _tmp23_ = {0};
									gint64 _tmp24_ = 0LL;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp19_ = self->row;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp20_ = _tmp19_->development_ids;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp20__length1 = _tmp19_->development_ids_length1;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp21_ = d;
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp22_ = _tmp20_[_tmp21_];
#line 1643 "/home/jens/Source/shotwell/src/Photo.vala"
									id = _tmp22_;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp23_ = id;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp24_ = _tmp23_.id;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
									if (_tmp24_ != BACKING_PHOTO_ID_INVALID) {
#line 13020 "Photo.c"
										BackingPhotoRow* bpr = NULL;
										BackingPhotoID _tmp25_ = {0};
										BackingPhotoRow* _tmp26_ = NULL;
										BackingPhotoRow* _tmp27_ = NULL;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp25_ = id;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp26_ = photo_get_backing_row (self, &_tmp25_);
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
										bpr = _tmp26_;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp27_ = bpr;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
										if (_tmp27_ != NULL) {
#line 13035 "Photo.c"
											GeeHashMap* _tmp28_ = NULL;
											RawDeveloper _tmp29_ = 0;
											BackingPhotoRow* _tmp30_ = NULL;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp28_ = self->priv->developments;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp29_ = d;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp30_ = bpr;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
											gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp29_), _tmp30_);
#line 13047 "Photo.c"
										}
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
										_backing_photo_row_unref0 (bpr);
#line 13051 "Photo.c"
									}
								}
							}
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = (g_free (d_collection), NULL);
#line 13057 "Photo.c"
						}
					}
					__finally306:
					{
						PhotoRow* _tmp31_ = NULL;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = self->row;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13067 "Photo.c"
					}
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							g_propagate_error (error, _inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13083 "Photo.c"
						} else {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							g_clear_error (&_inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13097 "Photo.c"
						}
					}
				}
			}
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 13104 "Photo.c"
		}
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_dev_it);
#line 13108 "Photo.c"
	}
#line 1654 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1654 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp32_;
#line 1655 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = reimport_state;
#line 1655 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->metadata_only;
#line 1655 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp34_) {
#line 13120 "Photo.c"
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = list;
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = g_strconcat (_tmp35_, "image:editable,image:baseline", NULL);
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp36_;
#line 13131 "Photo.c"
	}
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = list;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = alteration_new_from_list (_tmp37_);
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = _tmp38_;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp39_);
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp39_);
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 1630 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1630 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 13149 "Photo.c"
}


static gchar* photo_real_get_typename (DataSource* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1663 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1664 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13165 "Photo.c"
}


static gint64 photo_real_get_instance_id (DataSource* base) {
	Photo * self;
	gint64 result = 0LL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
#line 1667 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp0_);
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1668 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13184 "Photo.c"
}


static gchar* photo_real_get_source_id (DataSource* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 1671 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = data_source_get_typename (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", _tmp1_, _tmp2_);
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp1_);
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1675 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13214 "Photo.c"
}


void photo_set_master_timestamp (Photo* self, GFileInfo* info) {
	GTimeVal modification = {0};
	GFileInfo* _tmp0_ = NULL;
	GTimeVal _tmp1_ = {0};
	gboolean _tmp21_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1679 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1680 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = info;
#line 1680 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 1680 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp1_;
#line 13234 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 13242 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
				time_t _tmp5_ = 0;
				GTimeVal _tmp6_ = {0};
				glong _tmp7_ = 0L;
				PhotoTable* _tmp9_ = NULL;
				PhotoTable* _tmp10_ = NULL;
				PhotoRow* _tmp11_ = NULL;
				PhotoID _tmp12_ = {0};
				GTimeVal _tmp13_ = {0};
				glong _tmp14_ = 0L;
				PhotoRow* _tmp15_ = NULL;
				BackingPhotoRow* _tmp16_ = NULL;
				GTimeVal _tmp17_ = {0};
				glong _tmp18_ = 0L;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->master;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->timestamp;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = modification;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_.tv_sec;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp5_ == ((time_t) _tmp7_)) {
#line 13271 "Photo.c"
					{
						PhotoRow* _tmp8_ = NULL;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp8_ = self->row;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13278 "Photo.c"
					}
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13282 "Photo.c"
				}
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo_table_get_instance ();
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_;
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->row;
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->photo_id;
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = modification;
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = _tmp13_.tv_sec;
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_timestamp (_tmp10_, &_tmp12_, (time_t) _tmp14_, &_inner_error_);
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp10_);
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13302 "Photo.c"
					goto __finally308;
				}
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->master;
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = modification;
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_.tv_sec;
#line 1688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_->timestamp = (time_t) _tmp18_;
#line 13315 "Photo.c"
			}
			__finally308:
			{
				PhotoRow* _tmp19_ = NULL;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = self->row;
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13324 "Photo.c"
			}
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 13330 "Photo.c"
					goto __catch307_database_error;
				}
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1683 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13339 "Photo.c"
			}
		}
	}
	goto __finally307;
	__catch307_database_error:
	{
		GError* err = NULL;
		GError* _tmp20_ = NULL;
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1691 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = err;
#line 1691 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp20_);
#line 1693 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1693 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13360 "Photo.c"
	}
	__finally307:
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13371 "Photo.c"
	}
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = photo_is_master_baseline (self);
#line 1696 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 13377 "Photo.c"
		Alteration* _tmp22_ = NULL;
		Alteration* _tmp23_ = NULL;
#line 1697 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = alteration_new_from_list ("metadata:master-timestamp,metadata:baseline-timestamp");
#line 1697 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 1697 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 1697 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp23_);
#line 13388 "Photo.c"
	} else {
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("metadata", "master-timestamp");
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 13400 "Photo.c"
	}
}


void photo_update_editable_modification_time (Photo* self, GFileInfo* info, GError** error) {
	GTimeVal modification = {0};
	GFileInfo* _tmp0_ = NULL;
	GTimeVal _tmp1_ = {0};
	gboolean altered = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1703 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = info;
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 1704 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp1_;
#line 1706 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 13424 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 13431 "Photo.c"
		{
			gboolean _tmp3_ = FALSE;
			PhotoRow* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = backing_photo_id_is_valid (&_tmp4_->editable_id);
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp5_) {
#line 13442 "Photo.c"
				BackingPhotoRow* _tmp6_ = NULL;
				time_t _tmp7_ = 0;
				GTimeVal _tmp8_ = {0};
				glong _tmp9_ = 0L;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->priv->editable;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->timestamp;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = modification;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_.tv_sec;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _tmp7_ != ((time_t) _tmp9_);
#line 13457 "Photo.c"
			} else {
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = FALSE;
#line 13461 "Photo.c"
			}
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_) {
#line 13465 "Photo.c"
				BackingPhotoTable* _tmp10_ = NULL;
				BackingPhotoTable* _tmp11_ = NULL;
				PhotoRow* _tmp12_ = NULL;
				BackingPhotoID _tmp13_ = {0};
				GTimeVal _tmp14_ = {0};
				glong _tmp15_ = 0L;
				BackingPhotoRow* _tmp16_ = NULL;
				GTimeVal _tmp17_ = {0};
				glong _tmp18_ = 0L;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = backing_photo_table_get_instance ();
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->editable_id;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = modification;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_.tv_sec;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update_timestamp (_tmp11_, &_tmp13_, (time_t) _tmp15_, &_inner_error_);
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp11_);
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13493 "Photo.c"
					goto __finally309;
				}
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->editable;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = modification;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_.tv_sec;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_->timestamp = (time_t) _tmp18_;
#line 1712 "/home/jens/Source/shotwell/src/Photo.vala"
				altered = TRUE;
#line 13506 "Photo.c"
			}
		}
		__finally309:
		{
			PhotoRow* _tmp19_ = NULL;
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13516 "Photo.c"
		}
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13526 "Photo.c"
			} else {
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1707 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13534 "Photo.c"
			}
		}
	}
#line 1716 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = altered;
#line 1716 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_) {
#line 13542 "Photo.c"
		Alteration* _tmp21_ = NULL;
		Alteration* _tmp22_ = NULL;
#line 1717 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = alteration_new_from_list ("metadata:editable-timestamp,metadata:baseline-timestamp");
#line 1717 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp21_;
#line 1717 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp22_);
#line 1717 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp22_);
#line 13553 "Photo.c"
	}
}


void photo_update_many_editable_timestamps (GeeMap* map, GError** error) {
	GError * _inner_error_ = NULL;
#line 1721 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1723 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 13564 "Photo.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = map;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_it = _tmp5_;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 13591 "Photo.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			Photo* photo = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			Photo* _tmp10_ = NULL;
			GeeMap* _tmp11_ = NULL;
			Photo* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			GFileInfo* _tmp14_ = NULL;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _photo_it;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp7_) {
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 13610 "Photo.c"
			}
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _photo_it;
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			photo = (Photo*) _tmp9_;
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = photo;
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = map;
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo;
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = (GFileInfo*) _tmp13_;
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_update_editable_modification_time (_tmp10_, _tmp14_, &_inner_error_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp14_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13644 "Photo.c"
				} else {
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13656 "Photo.c"
				}
			}
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (photo);
#line 13661 "Photo.c"
		}
#line 1724 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_photo_it);
#line 13665 "Photo.c"
	}
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 13677 "Photo.c"
		} else {
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 13685 "Photo.c"
		}
	}
}


static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base) {
	Photo * self;
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 1729 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_file_format (self);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_can_write_image (_tmp1_);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 13705 "Photo.c"
		PhotoFileFormat _tmp3_ = 0;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_get_file_format (self);
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp3_;
#line 13711 "Photo.c"
	} else {
		PhotoFileFormat _tmp4_ = 0;
#line 1731 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_format_get_system_default_format ();
#line 1731 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp4_;
#line 13718 "Photo.c"
	}
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1730 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13724 "Photo.c"
}


static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Scaling _tmp2_ = {0};
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 1734 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = scale;
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	scaling_for_best_fit (_tmp1_, TRUE, &_tmp2_);
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp2_, &_inner_error_);
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 13753 "Photo.c"
	}
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 1735 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13765 "Photo.c"
}


gboolean photo_is_file_image (GFile* file) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 1738 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_is_file_supported (_tmp1_);
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = TRUE;
#line 13784 "Photo.c"
	} else {
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = file;
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_get_basename (_tmp3_);
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = photo_is_extension_found (_tmp5_, PHOTO_IMAGE_EXTENSIONS, G_N_ELEMENTS (PHOTO_IMAGE_EXTENSIONS));
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp6_;
#line 1743 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 13802 "Photo.c"
	}
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1742 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13808 "Photo.c"
}


static gboolean photo_is_extension_found (const gchar* basename, gchar** extensions, int extensions_length1) {
	gboolean result = FALSE;
	gchar* name = NULL;
	gchar* ext = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 1746 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = basename;
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	disassemble_filename (_tmp0_, &_tmp1_, &_tmp2_);
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	name = _tmp1_;
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp2_;
#line 1749 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = ext;
#line 1749 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp3_ == NULL) {
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (ext);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (name);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13850 "Photo.c"
	}
#line 1753 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = ext;
#line 1753 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 1753 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1753 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp5_;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = extensions;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6__length1 = extensions_length1;
#line 13864 "Photo.c"
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection = _tmp6_;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection_length1 = _tmp6__length1;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
		for (extension_it = 0; extension_it < _tmp6__length1; extension_it = extension_it + 1) {
#line 13876 "Photo.c"
			gchar* _tmp7_ = NULL;
			gchar* extension = NULL;
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = g_strdup (extension_collection[extension_it]);
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
			extension = _tmp7_;
#line 13883 "Photo.c"
			{
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 1757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = ext;
#line 1757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = extension;
#line 1757 "/home/jens/Source/shotwell/src/Photo.vala"
				if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (extension);
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (ext);
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (name);
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 13903 "Photo.c"
				}
#line 1756 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (extension);
#line 13907 "Photo.c"
			}
		}
	}
#line 1761 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 1761 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1761 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1761 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13919 "Photo.c"
}


gboolean photo_is_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format) {
	gboolean result = FALSE;
	PhotoTable* _tmp0_ = NULL;
	PhotoTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1767 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = file;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = thumbnail_md5;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = full_md5;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = file_format;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_table_has_duplicate (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp7_;
#line 1770 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13957 "Photo.c"
}


PhotoID* photo_get_duplicate_ids (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, int* result_length1) {
	PhotoID* result = NULL;
	PhotoTable* _tmp0_ = NULL;
	PhotoTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	gint _tmp6_ = 0;
	PhotoID* _tmp7_ = NULL;
	PhotoID* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	PhotoID* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 1776 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = file;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = thumbnail_md5;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = full_md5;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = file_format;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_table_get_duplicate_ids (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp7_;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8__length1 = _tmp6_;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9__length1 = _tmp8__length1;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp9__length1;
#line 14005 "Photo.c"
	}
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp9_;
#line 1779 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14011 "Photo.c"
}


gint64 photo_get_photo_key (DataSource* source) {
	gint64 result = 0LL;
	DataSource* _tmp0_ = NULL;
	PhotoID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
#line 1786 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1787 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = source;
#line 1787 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_PHOTO, Photo), &_tmp1_);
#line 1787 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.id;
#line 1787 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 1787 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14032 "Photo.c"
}


static GFile* photo_real_get_file (MediaSource* base) {
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1805 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1806 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14059 "Photo.c"
}


static void _vala_array_add96 (gchar*** array, int* length, int* size, gchar* value) {
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14070 "Photo.c"
	}
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14076 "Photo.c"
}


static void _vala_array_add97 (gchar*** array, int* length, int* size, gchar* value) {
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14087 "Photo.c"
	}
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14093 "Photo.c"
}


static void _vala_array_add98 (gchar*** array, int* length, int* size, gchar* value) {
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14104 "Photo.c"
	}
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14110 "Photo.c"
}


static void _vala_array_add99 (gchar*** array, int* length, int* size, gchar* value) {
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14121 "Photo.c"
	}
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14127 "Photo.c"
}


void photo_set_master_file (Photo* self, GFile* file) {
	gchar* filepath = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	gboolean name_changed = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp41_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1811 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1811 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1812 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 1812 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1812 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp1_;
#line 1814 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1815 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1816 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1817 "/home/jens/Source/shotwell/src/Photo.vala"
	name_changed = FALSE;
#line 1818 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 14162 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 14170 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp3_ = NULL;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp3_ = self->priv->readers;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 14178 "Photo.c"
					{
						PhotoBackingReaders* _tmp4_ = NULL;
						PhotoFileReader* _tmp5_ = NULL;
						GFile* _tmp6_ = NULL;
						GFile* _tmp7_ = NULL;
						GFile* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp4_ = self->priv->readers;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = _tmp4_->master;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp6_;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp7_ = file;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp8_ = old_file;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = g_file_equal (_tmp7_, _tmp8_);
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!_tmp9_) {
#line 14204 "Photo.c"
							PhotoTable* _tmp10_ = NULL;
							PhotoTable* _tmp11_ = NULL;
							PhotoID _tmp12_ = {0};
							const gchar* _tmp13_ = NULL;
							PhotoRow* _tmp14_ = NULL;
							BackingPhotoRow* _tmp15_ = NULL;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							GFile* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							PhotoBackingReaders* _tmp20_ = NULL;
							PhotoRow* _tmp21_ = NULL;
							BackingPhotoRow* _tmp22_ = NULL;
							PhotoFileFormat _tmp23_ = 0;
							const gchar* _tmp24_ = NULL;
							PhotoFileReader* _tmp25_ = NULL;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							PhotoRow* _tmp29_ = NULL;
							const gchar* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp10_ = photo_table_get_instance ();
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = _tmp10_;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_get_photo_id (self, &_tmp12_);
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = filepath;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_table_set_filepath (_tmp11_, &_tmp12_, _tmp13_, &_inner_error_);
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp11_);
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14241 "Photo.c"
								goto __finally312;
							}
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = self->row;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = _tmp14_->master;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = filepath;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = g_strdup (_tmp16_);
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp15_->filepath);
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_->filepath = _tmp17_;
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = file;
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = g_file_get_basename (_tmp18_);
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (self->priv->file_title);
#line 1827 "/home/jens/Source/shotwell/src/Photo.vala"
							self->priv->file_title = _tmp19_;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = self->priv->readers;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = self->row;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = _tmp21_->master;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = _tmp22_->file_format;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = filepath;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = photo_file_format_create_reader (_tmp23_, _tmp24_);
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp20_->master);
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_->master = _tmp25_;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1831 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = photo_is_master_baseline (self);
#line 1831 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = _tmp26_;
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = photo_is_master_source (self);
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = _tmp27_;
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp29_ = self->row;
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp30_ = _tmp29_->title;
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp31_ = is_string_empty (_tmp30_);
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							if (_tmp31_) {
#line 14298 "Photo.c"
								GFile* _tmp32_ = NULL;
								gchar* _tmp33_ = NULL;
								gchar* _tmp34_ = NULL;
								GFile* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp32_ = old_file;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp33_ = g_file_get_basename (_tmp32_);
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp34_ = _tmp33_;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp35_ = file;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp36_ = g_file_get_basename (_tmp35_);
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp37_ = _tmp36_;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp28_ = g_strcmp0 (_tmp34_, _tmp37_) != 0;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp37_);
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp34_);
#line 14323 "Photo.c"
							} else {
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp28_ = FALSE;
#line 14327 "Photo.c"
							}
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							name_changed = _tmp28_;
#line 14331 "Photo.c"
						}
					}
					__finally312:
					{
						PhotoBackingReaders* _tmp38_ = NULL;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp38_ = self->priv->readers;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 14341 "Photo.c"
					}
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14345 "Photo.c"
						goto __finally311;
					}
				}
			}
			__finally311:
			{
				PhotoRow* _tmp39_ = NULL;
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = self->row;
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14357 "Photo.c"
			}
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 14363 "Photo.c"
					goto __catch310_database_error;
				}
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14376 "Photo.c"
			}
		}
	}
	goto __finally310;
	__catch310_database_error:
	{
		GError* err = NULL;
		GError* _tmp40_ = NULL;
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1839 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = err;
#line 1839 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp40_);
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 14395 "Photo.c"
	}
	__finally310:
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14410 "Photo.c"
	}
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = altered;
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp41_) {
#line 14416 "Photo.c"
		GFile* _tmp42_ = NULL;
		GFile* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		gchar** alteration_list = NULL;
		gchar** _tmp45_ = NULL;
		gint alteration_list_length1 = 0;
		gint _alteration_list_size_ = 0;
		gchar** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		gchar* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gchar** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		Alteration* _tmp58_ = NULL;
		Alteration* _tmp59_ = NULL;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = old_file;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = file;
#line 1843 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp42_, _tmp43_);
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = is_baseline;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp44_) {
#line 1846 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 14446 "Photo.c"
		}
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = g_new0 (gchar*, 0 + 1);
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp45_;
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = alteration_list;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46__length1 = alteration_list_length1;
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = g_strdup ("backing:master");
#line 1849 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add96 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp47_);
#line 1853 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = name_changed;
#line 1853 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp48_) {
#line 14468 "Photo.c"
			gchar** _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gchar* _tmp50_ = NULL;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp49_ = alteration_list;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp49__length1 = alteration_list_length1;
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = g_strdup ("metadata:name");
#line 1854 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add97 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp50_);
#line 14480 "Photo.c"
		}
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = is_source;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp51_) {
#line 14486 "Photo.c"
			gchar** _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
			gchar* _tmp53_ = NULL;
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = alteration_list;
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52__length1 = alteration_list_length1;
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp53_ = g_strdup ("backing:source");
#line 1857 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add98 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp53_);
#line 14498 "Photo.c"
		}
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = is_baseline;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp54_) {
#line 14504 "Photo.c"
			gchar** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gchar* _tmp56_ = NULL;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55_ = alteration_list;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55__length1 = alteration_list_length1;
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = g_strdup ("backing:baseline");
#line 1860 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add99 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp56_);
#line 14516 "Photo.c"
		}
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = alteration_list;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57__length1 = alteration_list_length1;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = alteration_new_from_array (_tmp57_, _tmp57__length1);
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp59_);
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp59_);
#line 1842 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 14532 "Photo.c"
	}
#line 1811 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1811 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 14538 "Photo.c"
}


static void _vala_array_add100 (gchar*** array, int* length, int* size, gchar* value) {
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14549 "Photo.c"
	}
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14555 "Photo.c"
}


static void _vala_array_add101 (gchar*** array, int* length, int* size, gchar* value) {
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14566 "Photo.c"
	}
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14572 "Photo.c"
}


static void _vala_array_add102 (gchar*** array, int* length, int* size, gchar* value) {
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14583 "Photo.c"
	}
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14589 "Photo.c"
}


void photo_set_editable_file (Photo* self, GFile* file) {
	gchar* filepath = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp34_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1868 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1868 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1869 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp1_;
#line 1871 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1872 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1873 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1874 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 14621 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 14629 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp3_ = NULL;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp3_ = self->priv->readers;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 14637 "Photo.c"
					{
						GFile* _tmp4_ = NULL;
						PhotoBackingReaders* _tmp5_ = NULL;
						PhotoFileReader* _tmp6_ = NULL;
						GFile* _tmp10_ = NULL;
						gboolean _tmp11_ = FALSE;
						GFile* _tmp12_ = NULL;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = self->priv->readers;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = _tmp5_->editable;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp6_ != NULL) {
#line 14651 "Photo.c"
							PhotoBackingReaders* _tmp7_ = NULL;
							PhotoFileReader* _tmp8_ = NULL;
							GFile* _tmp9_ = NULL;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp7_ = self->priv->readers;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp8_ = _tmp7_->editable;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp9_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp4_);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp4_ = _tmp9_;
#line 14665 "Photo.c"
						} else {
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp4_);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp4_ = NULL;
#line 14671 "Photo.c"
						}
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp10_ = _g_object_ref0 (_tmp4_);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp10_;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp12_ = old_file;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp12_ != NULL) {
#line 14683 "Photo.c"
							GFile* _tmp13_ = NULL;
							GFile* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = old_file;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = file;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = g_file_equal (_tmp13_, _tmp14_);
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = !_tmp15_;
#line 14695 "Photo.c"
						} else {
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = FALSE;
#line 14699 "Photo.c"
						}
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp11_) {
#line 14703 "Photo.c"
							BackingPhotoTable* _tmp16_ = NULL;
							BackingPhotoTable* _tmp17_ = NULL;
							PhotoRow* _tmp18_ = NULL;
							BackingPhotoID _tmp19_ = {0};
							const gchar* _tmp20_ = NULL;
							BackingPhotoRow* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							PhotoBackingReaders* _tmp24_ = NULL;
							BackingPhotoRow* _tmp25_ = NULL;
							PhotoFileFormat _tmp26_ = 0;
							const gchar* _tmp27_ = NULL;
							PhotoFileReader* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = backing_photo_table_get_instance ();
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = _tmp16_;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = self->row;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _tmp18_->editable_id;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = filepath;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							backing_photo_table_set_filepath (_tmp17_, &_tmp19_, _tmp20_, &_inner_error_);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp17_);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_object_unref0 (_tmp4_);
#line 14737 "Photo.c"
								goto __finally315;
							}
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = self->priv->editable;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = filepath;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = g_strdup (_tmp22_);
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp21_->filepath);
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_->filepath = _tmp23_;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = self->priv->readers;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = self->priv->editable;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = _tmp25_->file_format;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = filepath;
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp28_ = photo_file_format_create_reader (_tmp26_, _tmp27_);
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp24_->editable);
#line 1883 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_->editable = _tmp28_;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1886 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp29_ = photo_is_editable_baseline (self);
#line 1886 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = _tmp29_;
#line 1887 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp30_ = photo_is_editable_source (self);
#line 1887 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = _tmp30_;
#line 14774 "Photo.c"
						}
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp4_);
#line 14778 "Photo.c"
					}
					__finally315:
					{
						PhotoBackingReaders* _tmp31_ = NULL;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = self->priv->readers;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 14787 "Photo.c"
					}
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14791 "Photo.c"
						goto __finally314;
					}
				}
			}
			__finally314:
			{
				PhotoRow* _tmp32_ = NULL;
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = self->row;
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14803 "Photo.c"
			}
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 14809 "Photo.c"
					goto __catch313_database_error;
				}
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14822 "Photo.c"
			}
		}
	}
	goto __finally313;
	__catch313_database_error:
	{
		GError* err = NULL;
		GError* _tmp33_ = NULL;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1892 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = err;
#line 1892 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp33_);
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 14841 "Photo.c"
	}
	__finally313:
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14856 "Photo.c"
	}
#line 1895 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = altered;
#line 1895 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp34_) {
#line 14862 "Photo.c"
		GFile* _tmp35_ = NULL;
		GFile* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gchar** alteration_list = NULL;
		gchar** _tmp38_ = NULL;
		gint alteration_list_length1 = 0;
		gint _alteration_list_size_ = 0;
		gchar** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gchar* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gchar** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		Alteration* _tmp48_ = NULL;
		Alteration* _tmp49_ = NULL;
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = old_file;
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = file;
#line 1896 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_editable_replaced (self, _tmp35_, _tmp36_);
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = is_baseline;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp37_) {
#line 1899 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 14891 "Photo.c"
		}
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = g_new0 (gchar*, 0 + 1);
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp38_;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = alteration_list;
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39__length1 = alteration_list_length1;
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = g_strdup ("backing:editable");
#line 1902 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add100 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp40_);
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = is_baseline;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp41_) {
#line 14913 "Photo.c"
			gchar** _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gchar* _tmp43_ = NULL;
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = alteration_list;
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42__length1 = alteration_list_length1;
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = g_strdup ("backing:baseline");
#line 1905 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add101 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp43_);
#line 14925 "Photo.c"
		}
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = is_source;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp44_) {
#line 14931 "Photo.c"
			gchar** _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gchar* _tmp46_ = NULL;
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45_ = alteration_list;
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45__length1 = alteration_list_length1;
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp46_ = g_strdup ("backing:source");
#line 1908 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add102 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp46_);
#line 14943 "Photo.c"
		}
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = alteration_list;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47__length1 = alteration_list_length1;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = alteration_new_from_array (_tmp47_, _tmp47__length1);
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = _tmp48_;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp49_);
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp49_);
#line 1895 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 14959 "Photo.c"
	}
#line 1868 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1868 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 14965 "Photo.c"
}


void photo_set_many_editable_file (GeeMap* map, GError** error) {
	GeeMapIterator* map_iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 1915 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1916 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 1918 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = map;
#line 1918 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = gee_map_map_iterator (_tmp0_);
#line 1918 "/home/jens/Source/shotwell/src/Photo.vala"
	map_iter = _tmp1_;
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
	while (TRUE) {
#line 14986 "Photo.c"
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		Photo* _tmp6_ = NULL;
		GeeMapIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = map_iter;
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = gee_map_iterator_next (_tmp2_);
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
		if (!_tmp3_) {
#line 1919 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 15003 "Photo.c"
		}
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = map_iter;
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = (Photo*) _tmp5_;
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = map_iter;
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = gee_map_iterator_get_value (_tmp7_);
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = (GFile*) _tmp8_;
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_editable_file (_tmp6_, _tmp9_);
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp9_);
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp6_);
#line 15023 "Photo.c"
	}
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15037 "Photo.c"
		} else {
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15047 "Photo.c"
		}
	}
#line 1915 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (map_iter);
#line 15052 "Photo.c"
}


GFile* photo_get_actual_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1927 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_baseline_reader (self);
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1928 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15078 "Photo.c"
}


static GFile* photo_real_get_master_file (MediaSource* base) {
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1931 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1932 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15105 "Photo.c"
}


GFile* photo_get_editable_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
#line 1935 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1936 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 15125 "Photo.c"
		PhotoFileReader* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 15136 "Photo.c"
	} else {
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 15142 "Photo.c"
	}
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15150 "Photo.c"
}


GeeCollection* photo_get_raw_developer_files (Photo* self) {
	GeeCollection* result = NULL;
	PhotoFileFormat _tmp0_ = 0;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 1941 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1942 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 1942 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 15170 "Photo.c"
	}
#line 1945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 1945 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = _tmp1_;
#line 15176 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15183 "Photo.c"
		{
			{
				GeeIterator* _row_it = NULL;
				GeeHashMap* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeCollection* _tmp5_ = NULL;
				GeeCollection* _tmp6_ = NULL;
				GeeIterator* _tmp7_ = NULL;
				GeeIterator* _tmp8_ = NULL;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MAP, GeeMap));
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp6_);
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_row_it = _tmp8_;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 15211 "Photo.c"
					GeeIterator* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					BackingPhotoRow* row = NULL;
					GeeIterator* _tmp11_ = NULL;
					gpointer _tmp12_ = NULL;
					GeeArrayList* _tmp13_ = NULL;
					BackingPhotoRow* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_ = NULL;
					GFile* _tmp17_ = NULL;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = _row_it;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = gee_iterator_next (_tmp9_);
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!_tmp10_) {
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 15230 "Photo.c"
					}
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = _row_it;
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = gee_iterator_get (_tmp11_);
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					row = (BackingPhotoRow*) _tmp12_;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = ret;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = row;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = _tmp14_->filepath;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = g_file_new_for_path (_tmp15_);
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = _tmp16_;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp17_);
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (row);
#line 15254 "Photo.c"
				}
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_row_it);
#line 15258 "Photo.c"
			}
		}
		__finally316:
		{
			PhotoRow* _tmp18_ = NULL;
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = self->row;
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15268 "Photo.c"
		}
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (ret);
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1946 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 15280 "Photo.c"
		}
	}
#line 1951 "/home/jens/Source/shotwell/src/Photo.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (ret, GEE_TYPE_COLLECTION, GeeCollection);
#line 1951 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15287 "Photo.c"
}


GFile* photo_get_source_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1954 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1955 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15313 "Photo.c"
}


PhotoFileFormat photo_get_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1958 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 15322 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15329 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			PhotoFileFormat _tmp2_ = 0;
#line 1960 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 1960 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->file_format;
#line 1960 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15339 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15346 "Photo.c"
			}
#line 1960 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15350 "Photo.c"
		}
		__finally317:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15359 "Photo.c"
		}
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1959 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 15367 "Photo.c"
	}
}


PhotoFileFormat photo_get_best_export_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	PhotoFileFormat file_format = 0;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 1964 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1965 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_file_format (self);
#line 1965 "/home/jens/Source/shotwell/src/Photo.vala"
	file_format = _tmp0_;
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file_format;
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_can_write (_tmp1_);
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp2_) {
#line 15390 "Photo.c"
		PhotoFileFormat _tmp3_ = 0;
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_format_get_system_default_format ();
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
		file_format = _tmp3_;
#line 15396 "Photo.c"
	}
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
	result = file_format;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15402 "Photo.c"
}


PhotoFileFormat photo_get_master_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1972 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 15411 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15418 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileFormat _tmp3_ = 0;
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 15431 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15438 "Photo.c"
			}
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15442 "Photo.c"
		}
		__finally318:
		{
			PhotoRow* _tmp5_ = NULL;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15451 "Photo.c"
		}
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1973 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 15459 "Photo.c"
	}
}


static time_t photo_real_get_timestamp (MediaSource* base) {
	Photo * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 1978 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15470 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15477 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			time_t _tmp2_ = 0;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15487 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15494 "Photo.c"
			}
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15498 "Photo.c"
		}
		__finally319:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15507 "Photo.c"
		}
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1979 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 15515 "Photo.c"
	}
}


void photo_get_photo_id (Photo* self, PhotoID* result) {
	GError * _inner_error_ = NULL;
#line 1984 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 15524 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15531 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			PhotoID _tmp2_ = {0};
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->photo_id;
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15541 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15548 "Photo.c"
			}
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15552 "Photo.c"
		}
		__finally320:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15561 "Photo.c"
		}
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1985 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15569 "Photo.c"
	}
}


static inline void photo_real_get_event_id (MediaSource* base, EventID* result) {
	Photo * self;
	PhotoRow* _tmp0_ = NULL;
	EventID _tmp1_ = {0};
#line 1991 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1992 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 1992 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 1992 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = _tmp1_;
#line 1992 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 15588 "Photo.c"
}


inline gint64 photo_get_raw_event_id (Photo* self) {
	gint64 result = 0LL;
	PhotoRow* _tmp0_ = NULL;
	EventID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
#line 1996 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0LL);
#line 1997 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 1997 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 1997 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.id;
#line 1997 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 1997 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15609 "Photo.c"
}


static void photo_real_get_import_id (MediaSource* base, ImportID* result) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2000 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15618 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15625 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			ImportID _tmp2_ = {0};
#line 2002 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2002 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->import_id;
#line 2002 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15635 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15642 "Photo.c"
			}
#line 2002 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15646 "Photo.c"
		}
		__finally321:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15655 "Photo.c"
		}
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2001 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15663 "Photo.c"
	}
}


void photo_get_editable_id (Photo* self, BackingPhotoID* result) {
	GError * _inner_error_ = NULL;
#line 2006 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 15672 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15679 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoID _tmp2_ = {0};
#line 2008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable_id;
#line 2008 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15689 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15696 "Photo.c"
			}
#line 2008 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15700 "Photo.c"
		}
		__finally322:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15709 "Photo.c"
		}
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2007 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15717 "Photo.c"
	}
}


static gchar* photo_real_get_master_md5 (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2012 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15728 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15735 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->md5;
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 15748 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15755 "Photo.c"
			}
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15759 "Photo.c"
		}
		__finally323:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15768 "Photo.c"
		}
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2013 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 15776 "Photo.c"
	}
}


guint64 photo_get_flags (Photo* self) {
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2020 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 15786 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15793 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15803 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15810 "Photo.c"
			}
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15814 "Photo.c"
		}
		__finally324:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15823 "Photo.c"
		}
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2021 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0ULL;
#line 15831 "Photo.c"
	}
}


static void photo_notify_flags_altered (Photo* self, Alteration* additional_alteration) {
	Alteration* alteration = NULL;
	Alteration* _tmp0_ = NULL;
	Alteration* _tmp1_ = NULL;
	Alteration* _tmp5_ = NULL;
#line 2026 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2026 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 2027 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 2027 "/home/jens/Source/shotwell/src/Photo.vala"
	alteration = _tmp0_;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = additional_alteration;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 15853 "Photo.c"
		Alteration* _tmp2_ = NULL;
		Alteration* _tmp3_ = NULL;
		Alteration* _tmp4_ = NULL;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = alteration;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = additional_alteration;
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = alteration_compress (_tmp2_, _tmp3_);
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (alteration);
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration = _tmp4_;
#line 15867 "Photo.c"
	}
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = alteration;
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
#line 2026 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (alteration);
#line 15875 "Photo.c"
}


guint64 photo_replace_flags (Photo* self, guint64 flags, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp10_ = FALSE;
	guint64 _tmp12_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2034 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 15889 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15896 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoID _tmp3_ = {0};
			guint64 _tmp4_ = 0ULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp3_);
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = flags;
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_table_replace_flags (_tmp2_, &_tmp3_, _tmp4_);
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp5_;
#line 2037 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = committed;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_) {
#line 15922 "Photo.c"
				PhotoRow* _tmp7_ = NULL;
				guint64 _tmp8_ = 0ULL;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = flags;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_->flags = _tmp8_;
#line 15931 "Photo.c"
			}
		}
		__finally325:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15941 "Photo.c"
		}
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0ULL;
#line 15951 "Photo.c"
		}
	}
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = committed;
#line 2042 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_) {
#line 15958 "Photo.c"
		Alteration* _tmp11_ = NULL;
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = additional_alteration;
#line 2043 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp11_);
#line 15964 "Photo.c"
	}
#line 2045 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = flags;
#line 2045 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp12_;
#line 2045 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15972 "Photo.c"
}


gboolean photo_is_flag_set (Photo* self, guint64 mask) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2048 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 15981 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15988 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			gboolean _tmp4_ = FALSE;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_is_flag_set (_tmp2_, _tmp3_);
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp4_;
#line 16004 "Photo.c"
			{
				PhotoRow* _tmp5_ = NULL;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16011 "Photo.c"
			}
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16015 "Photo.c"
		}
		__finally326:
		{
			PhotoRow* _tmp6_ = NULL;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16024 "Photo.c"
		}
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2049 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 16032 "Photo.c"
	}
}


guint64 photo_add_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2054 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2054 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2055 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16051 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16058 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_add_flags (_tmp2_, _tmp3_);
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp4_;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16085 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16110 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16119 "Photo.c"
				}
			}
		}
		__finally327:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16130 "Photo.c"
		}
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2058 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0ULL;
#line 16140 "Photo.c"
		}
	}
#line 2067 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = committed;
#line 2067 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 16147 "Photo.c"
		Alteration* _tmp18_ = NULL;
#line 2068 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = additional_alteration;
#line 2068 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp18_);
#line 16153 "Photo.c"
	}
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16159 "Photo.c"
}


guint64 photo_remove_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2073 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2073 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2074 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2076 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16177 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16184 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_remove_flags (_tmp2_, _tmp3_);
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp4_;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16211 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16236 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16245 "Photo.c"
				}
			}
		}
		__finally328:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16256 "Photo.c"
		}
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2077 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0ULL;
#line 16266 "Photo.c"
		}
	}
#line 2086 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = committed;
#line 2086 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 16273 "Photo.c"
		Alteration* _tmp18_ = NULL;
#line 2087 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = additional_alteration;
#line 2087 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp18_);
#line 16279 "Photo.c"
	}
#line 2089 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2089 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16285 "Photo.c"
}


guint64 photo_add_remove_flags (Photo* self, guint64 add, guint64 remove, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2092 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2092 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2093 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2095 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16303 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16310 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = add;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = remove;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = (_tmp2_ | _tmp3_) & (~_tmp4_);
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16337 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16362 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16371 "Photo.c"
				}
			}
		}
		__finally329:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16382 "Photo.c"
		}
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2096 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0ULL;
#line 16392 "Photo.c"
		}
	}
#line 2105 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = committed;
#line 2105 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 16399 "Photo.c"
		Alteration* _tmp18_ = NULL;
#line 2106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = additional_alteration;
#line 2106 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp18_);
#line 16405 "Photo.c"
	}
#line 2108 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2108 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16411 "Photo.c"
}


void photo_add_remove_many_flags (GeeCollection* add, guint64 add_mask, Alteration* additional_add_alteration, GeeCollection* remove, guint64 remove_mask, Alteration* additional_remove_alteration, GError** error) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 2111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((add == NULL) || GEE_IS_COLLECTION (add));
#line 2111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_add_alteration == NULL) || IS_ALTERATION (additional_add_alteration));
#line 2111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((remove == NULL) || GEE_IS_COLLECTION (remove));
#line 2111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_remove_alteration == NULL) || IS_ALTERATION (additional_remove_alteration));
#line 2114 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 2116 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = add;
#line 2116 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != NULL) {
#line 16433 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeCollection* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = add;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp2_;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 16446 "Photo.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				Photo* photo = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				Photo* _tmp7_ = NULL;
				guint64 _tmp8_ = 0ULL;
				Alteration* _tmp9_ = NULL;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _photo_it;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp4_) {
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 16463 "Photo.c"
				}
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_it;
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp6_;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = add_mask;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = additional_add_alteration;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_add_flags (_tmp7_, _tmp8_, _tmp9_);
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 16481 "Photo.c"
			}
#line 2117 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 16485 "Photo.c"
		}
	}
#line 2121 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = remove;
#line 2121 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_ != NULL) {
#line 16492 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeCollection* _tmp11_ = NULL;
			GeeIterator* _tmp12_ = NULL;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = remove;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp12_;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 16505 "Photo.c"
				GeeIterator* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				Photo* photo = NULL;
				GeeIterator* _tmp15_ = NULL;
				gpointer _tmp16_ = NULL;
				Photo* _tmp17_ = NULL;
				guint64 _tmp18_ = 0ULL;
				Alteration* _tmp19_ = NULL;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _photo_it;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = gee_iterator_next (_tmp13_);
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp14_) {
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 16522 "Photo.c"
				}
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _photo_it;
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = gee_iterator_get (_tmp15_);
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp16_;
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = photo;
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = remove_mask;
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = additional_remove_alteration;
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_remove_flags (_tmp17_, _tmp18_, _tmp19_);
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 16540 "Photo.c"
			}
#line 2122 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 16544 "Photo.c"
		}
	}
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16557 "Photo.c"
		} else {
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2126 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16565 "Photo.c"
		}
	}
}


guint64 photo_toggle_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2129 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2129 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2130 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16585 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16592 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			PhotoRow* _tmp4_ = NULL;
			guint64 _tmp5_ = 0ULL;
			guint64 _tmp6_ = 0ULL;
#line 2134 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2134 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2134 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2134 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp2_ ^ _tmp3_;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->flags;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = flags;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp5_ != _tmp6_) {
#line 16616 "Photo.c"
				PhotoTable* _tmp7_ = NULL;
				PhotoTable* _tmp8_ = NULL;
				PhotoID _tmp9_ = {0};
				guint64 _tmp10_ = 0ULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo_table_get_instance ();
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp9_);
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = flags;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_replace_flags (_tmp8_, &_tmp9_, _tmp10_);
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp11_;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp8_);
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = committed;
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_) {
#line 16641 "Photo.c"
					PhotoRow* _tmp13_ = NULL;
					guint64 _tmp14_ = 0ULL;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = self->row;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = flags;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_->flags = _tmp14_;
#line 16650 "Photo.c"
				}
			}
		}
		__finally330:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16661 "Photo.c"
		}
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2133 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0ULL;
#line 16671 "Photo.c"
		}
	}
#line 2142 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = committed;
#line 2142 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 16678 "Photo.c"
		Alteration* _tmp17_ = NULL;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = additional_alteration;
#line 2143 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp17_);
#line 16684 "Photo.c"
	}
#line 2145 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2145 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16690 "Photo.c"
}


gboolean photo_is_master_metadata_dirty (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2148 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 16699 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16706 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16716 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16723 "Photo.c"
			}
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16727 "Photo.c"
		}
		__finally331:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16736 "Photo.c"
		}
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2149 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 16744 "Photo.c"
	}
}


void photo_set_master_metadata_dirty (Photo* self, gboolean dirty, GError** error) {
	gboolean committed = FALSE;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2154 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2155 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16757 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16764 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = dirty;
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp3_) {
#line 16777 "Photo.c"
				PhotoTable* _tmp4_ = NULL;
				PhotoTable* _tmp5_ = NULL;
				PhotoID _tmp6_ = {0};
				gboolean _tmp7_ = FALSE;
				PhotoRow* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_table_get_instance ();
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp6_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = dirty;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_metadata_dirty (_tmp5_, &_tmp6_, _tmp7_, &_inner_error_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp5_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16798 "Photo.c"
					goto __finally332;
				}
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = dirty;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_->metadata_dirty = _tmp9_;
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = TRUE;
#line 16809 "Photo.c"
			}
		}
		__finally332:
		{
			PhotoRow* _tmp10_ = NULL;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16819 "Photo.c"
		}
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 16829 "Photo.c"
			} else {
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 16837 "Photo.c"
			}
		}
	}
#line 2164 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = committed;
#line 2164 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 16845 "Photo.c"
		Alteration* _tmp12_ = NULL;
		Alteration* _tmp13_ = NULL;
#line 2165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = alteration_new ("metadata", "master-dirty");
#line 2165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_;
#line 2165 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 2165 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp13_);
#line 16856 "Photo.c"
	}
}


static Rating photo_real_get_rating (MediaSource* base) {
	Photo * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 2168 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 16867 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16874 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16884 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16891 "Photo.c"
			}
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16895 "Photo.c"
		}
		__finally333:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16904 "Photo.c"
		}
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2169 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 16912 "Photo.c"
	}
}


static void photo_real_set_rating (MediaSource* base, Rating rating) {
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2174 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2175 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16926 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16933 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			Rating _tmp2_ = 0;
			PhotoRow* _tmp3_ = NULL;
			Rating _tmp4_ = 0;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = rating;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->rating;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp4_) {
#line 16947 "Photo.c"
				Rating _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = rating;
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = rating_is_valid (_tmp5_);
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 16956 "Photo.c"
			} else {
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 16960 "Photo.c"
			}
#line 2178 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_) {
#line 16964 "Photo.c"
				PhotoTable* _tmp7_ = NULL;
				PhotoTable* _tmp8_ = NULL;
				PhotoID _tmp9_ = {0};
				Rating _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo_table_get_instance ();
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp9_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = rating;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_set_rating (_tmp8_, &_tmp9_, _tmp10_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp11_;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp8_);
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = committed;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_) {
#line 16989 "Photo.c"
					PhotoRow* _tmp13_ = NULL;
					Rating _tmp14_ = 0;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = self->row;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = rating;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_->rating = _tmp14_;
#line 16998 "Photo.c"
				}
			}
		}
		__finally334:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17009 "Photo.c"
		}
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17019 "Photo.c"
		}
	}
#line 2185 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = committed;
#line 2185 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 17026 "Photo.c"
		Alteration* _tmp17_ = NULL;
		Alteration* _tmp18_ = NULL;
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = alteration_new ("metadata", "rating");
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
#line 2186 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp18_);
#line 17037 "Photo.c"
	}
}


static void photo_real_increase_rating (MediaSource* base) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2189 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17047 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17054 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = rating_increase (_tmp2_);
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 17067 "Photo.c"
		}
		__finally335:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17076 "Photo.c"
		}
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2190 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17086 "Photo.c"
		}
	}
}


static void photo_real_decrease_rating (MediaSource* base) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2195 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17097 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17104 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 2197 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2197 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2197 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = rating_decrease (_tmp2_);
#line 2197 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 17117 "Photo.c"
		}
		__finally336:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17126 "Photo.c"
		}
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2196 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17136 "Photo.c"
		}
	}
}


static void photo_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2201 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2201 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 17149 "Photo.c"
	{
		PhotoTable* _tmp0_ = NULL;
		PhotoTable* _tmp1_ = NULL;
		PhotoID _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_table_get_instance ();
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp2_);
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = backlinks;
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_table_update_backlinks (_tmp1_, &_tmp2_, _tmp3_, &_inner_error_);
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp1_);
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 17171 "Photo.c"
				goto __catch337_database_error;
			}
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2206 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17180 "Photo.c"
		}
		{
			PhotoRow* _tmp4_ = NULL;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 17188 "Photo.c"
			{
				PhotoRow* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = backlinks;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp5_->backlinks);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_->backlinks = _tmp7_;
#line 17203 "Photo.c"
			}
			__finally338:
			{
				PhotoRow* _tmp8_ = NULL;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17212 "Photo.c"
			}
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 17218 "Photo.c"
					goto __catch337_database_error;
				}
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 17227 "Photo.c"
			}
		}
	}
	goto __finally337;
	__catch337_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = err;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->message;
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2211: Unable to update link state for %s: %s", _tmp10_, _tmp12_);
#line 2211 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17257 "Photo.c"
	}
	__finally337:
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2205 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17268 "Photo.c"
	}
}


static gboolean photo_real_set_event_id (MediaSource* base, EventID* event_id) {
	Photo * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2219 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2219 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 17281 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17288 "Photo.c"
		{
			gboolean committed = FALSE;
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			EventID _tmp5_ = {0};
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *event_id;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp7_;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = committed;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_) {
#line 17321 "Photo.c"
				PhotoRow* _tmp9_ = NULL;
				EventID _tmp10_ = {0};
#line 2224 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->row;
#line 2224 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = *event_id;
#line 2224 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_->event_id = _tmp10_;
#line 17330 "Photo.c"
			}
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
			result = committed;
#line 17334 "Photo.c"
			{
				PhotoRow* _tmp11_ = NULL;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->row;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17341 "Photo.c"
			}
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17345 "Photo.c"
		}
		__finally339:
		{
			PhotoRow* _tmp12_ = NULL;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17354 "Photo.c"
		}
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2220 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 17362 "Photo.c"
	}
}


static gchar* photo_real_to_string (DataObject* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	PhotoID _tmp10_ = {0};
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	PhotoFileReader* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
#line 2230 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_is_master_baseline (self);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp1_) {
#line 17388 "Photo.c"
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = photo_get_actual_file (self);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = g_strconcat (" (", _tmp5_, NULL);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp8_;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp7_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 17420 "Photo.c"
	} else {
		gchar* _tmp9_ = NULL;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = g_strdup ("");
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp9_;
#line 17429 "Photo.c"
	}
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp10_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_.id;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_get_master_reader (self);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _tmp16_;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = g_strdup_printf ("[%s] %s%s", _tmp13_, _tmp17_, _tmp0_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp17_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp15_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp13_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp19_;
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp0_);
#line 2231 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17463 "Photo.c"
}


static gboolean photo_real_equals (DataSource* base, DataSource* source) {
	Photo * self;
	gboolean result = FALSE;
	Photo* photo = NULL;
	DataSource* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	DataSource* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 2235 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2235 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 2237 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = source;
#line 2237 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO) ? ((Photo*) _tmp0_) : NULL);
#line 2237 "/home/jens/Source/shotwell/src/Photo.vala"
	photo = _tmp1_;
#line 2238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo;
#line 2238 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 17490 "Photo.c"
		PhotoID photo_id = {0};
		PhotoID _tmp3_ = {0};
		PhotoID other_photo_id = {0};
		Photo* _tmp4_ = NULL;
		PhotoID _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		Photo* _tmp7_ = NULL;
#line 2239 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp3_);
#line 2239 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_id = _tmp3_;
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo;
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (_tmp4_, &_tmp5_);
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
		other_photo_id = _tmp5_;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = photo;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		if (self != _tmp7_) {
#line 17512 "Photo.c"
			PhotoID _tmp8_ = {0};
			gint64 _tmp9_ = 0LL;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = photo_id;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_.id;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp9_ != PHOTO_ID_INVALID;
#line 17521 "Photo.c"
		} else {
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = FALSE;
#line 17525 "Photo.c"
		}
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp6_) {
#line 17529 "Photo.c"
			PhotoID _tmp10_ = {0};
			gint64 _tmp11_ = 0LL;
			PhotoID _tmp12_ = {0};
			gint64 _tmp13_ = 0LL;
#line 2243 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = photo_id;
#line 2243 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = _tmp10_.id;
#line 2243 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = other_photo_id;
#line 2243 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_.id;
#line 2243 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_assert (_tmp11_ != _tmp13_, "photo_id.id != other_photo_id.id");
#line 17544 "Photo.c"
		}
	}
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = DATA_SOURCE_CLASS (photo_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), _tmp14_);
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp15_;
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo);
#line 2247 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17557 "Photo.c"
}


static void photo_file_exif_updated (Photo* self) {
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp7_ = NULL;
	GTimeVal _tmp8_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp9_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	DetectedPhotoInformation* _tmp16_ = NULL;
	gboolean success = FALSE;
	gboolean _tmp37_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2252 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 2254 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 17585 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp2_;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17596 "Photo.c"
			goto __catch340_g_error;
		}
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp1_;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp3_;
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 17609 "Photo.c"
	}
	goto __finally340;
	__catch340_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err->message;
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
		g_error ("Photo.vala:2259: Unable to read file information for %s: %s", _tmp5_, _tmp6_);
#line 2259 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17634 "Photo.c"
	}
	__finally340:
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2255 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17649 "Photo.c"
	}
#line 2262 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = info;
#line 2262 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp7_, &_tmp8_);
#line 2262 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp8_;
#line 2265 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_interrogator_new (file, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 2265 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp9_;
#line 17661 "Photo.c"
	{
#line 2267 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 2267 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17667 "Photo.c"
			goto __catch341_g_error;
		}
	}
	goto __finally341;
	__catch341_g_error:
	{
		GError* err = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = g_file_get_path (file);
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_;
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = err;
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_->message;
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2269: Unable to interrogate photo file %s: %s", _tmp11_, _tmp13_);
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp11_);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17697 "Photo.c"
	}
	__finally341:
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2266 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17714 "Photo.c"
	}
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 2272 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp14_;
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = detected;
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_ == NULL) {
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = TRUE;
#line 17726 "Photo.c"
	} else {
		gboolean _tmp17_ = FALSE;
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp17_;
#line 17733 "Photo.c"
	}
#line 2273 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 17737 "Photo.c"
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_;
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:2274: file_exif_updated: %s no longer an image", _tmp19_);
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp19_);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17758 "Photo.c"
	}
	{
		PhotoRow* _tmp20_ = NULL;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = self->row;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17766 "Photo.c"
		{
			PhotoTable* _tmp21_ = NULL;
			PhotoTable* _tmp22_ = NULL;
			PhotoID _tmp23_ = {0};
			GFileInfo* _tmp24_ = NULL;
			gint64 _tmp25_ = 0LL;
			GTimeVal _tmp26_ = {0};
			glong _tmp27_ = 0L;
			DetectedPhotoInformation* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			DetectedPhotoInformation* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			DetectedPhotoInformation* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			PhotoRow* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = photo_table_get_instance ();
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = _tmp21_;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp23_);
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = info;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = g_file_info_get_size (_tmp24_);
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = timestamp;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = _tmp26_.tv_sec;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = detected;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = _tmp28_->md5;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = detected;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _tmp30_->exif_md5;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp32_ = detected;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = _tmp32_->thumbnail_md5;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = self->row;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = photo_table_master_exif_updated (_tmp22_, &_tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, _tmp33_, _tmp34_);
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			success = _tmp35_;
#line 2281 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp22_);
#line 17817 "Photo.c"
		}
		__finally342:
		{
			PhotoRow* _tmp36_ = NULL;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = self->row;
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17826 "Photo.c"
		}
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2280 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17844 "Photo.c"
		}
	}
#line 2285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = success;
#line 2285 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp37_) {
#line 17851 "Photo.c"
		Alteration* _tmp38_ = NULL;
		Alteration* _tmp39_ = NULL;
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = alteration_new_from_list ("metadata:exif,metadata:md5");
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp38_;
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp39_);
#line 2286 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp39_);
#line 17862 "Photo.c"
	}
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 2251 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 17872 "Photo.c"
}


static guint64 photo_real_get_filesize (MediaSource* base) {
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2291 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17882 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17889 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			gint64 _tmp2_ = 0LL;
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 17899 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17906 "Photo.c"
			}
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17910 "Photo.c"
		}
		__finally343:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17919 "Photo.c"
		}
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2292 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0ULL;
#line 17927 "Photo.c"
	}
}


static guint64 photo_real_get_master_filesize (MediaSource* base) {
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2297 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17938 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17945 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoRow* _tmp2_ = NULL;
			gint64 _tmp3_ = 0LL;
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->filesize;
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp3_;
#line 17958 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17965 "Photo.c"
			}
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17969 "Photo.c"
		}
		__finally344:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17978 "Photo.c"
		}
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2298 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0ULL;
#line 17986 "Photo.c"
	}
}


guint64 photo_get_editable_filesize (Photo* self) {
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2303 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 17996 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18003 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			gint64 _tmp2_ = 0LL;
#line 2305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->editable;
#line 2305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2305 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 18013 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18020 "Photo.c"
			}
#line 2305 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18024 "Photo.c"
		}
		__finally345:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18033 "Photo.c"
		}
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2304 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0ULL;
#line 18041 "Photo.c"
	}
}


static time_t photo_real_get_exposure_time (Dateable* base) {
	Photo * self;
	time_t result = 0;
	time_t _tmp0_ = 0;
#line 2309 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2310 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->cached_exposure_time;
#line 2310 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2310 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18058 "Photo.c"
}


static gchar* photo_real_get_basename (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2313 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18068 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18075 "Photo.c"
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
#line 2315 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->file_title;
#line 2315 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = g_strdup (_tmp1_);
#line 2315 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 18085 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18092 "Photo.c"
			}
#line 2315 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18096 "Photo.c"
		}
		__finally346:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18105 "Photo.c"
		}
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2314 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18113 "Photo.c"
	}
}


static gchar* photo_real_get_title (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2319 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18124 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18131 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->title;
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18144 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18151 "Photo.c"
			}
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18155 "Photo.c"
		}
		__finally347:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18164 "Photo.c"
		}
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2320 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18172 "Photo.c"
	}
}


static gchar* photo_real_get_comment (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2325 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18183 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18190 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->comment;
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18203 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18210 "Photo.c"
			}
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18214 "Photo.c"
		}
		__finally348:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18223 "Photo.c"
		}
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2326 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18231 "Photo.c"
	}
}


static void photo_real_set_title (MediaSource* base, const gchar* title) {
	Photo * self;
	gchar* new_title = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2331 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2332 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = title;
#line 2332 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 2332 "/home/jens/Source/shotwell/src/Photo.vala"
	new_title = _tmp1_;
#line 2334 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 18254 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18261 "Photo.c"
		{
			const gchar* _tmp3_ = NULL;
			PhotoRow* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			PhotoTable* _tmp7_ = NULL;
			PhotoTable* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoID _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = new_title;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->title;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 18281 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18288 "Photo.c"
				}
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_title);
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 18294 "Photo.c"
			}
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_table_get_instance ();
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_;
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->photo_id;
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = new_title;
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_set_title (_tmp8_, &_tmp10_, _tmp11_);
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp12_;
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp8_);
#line 2340 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = committed;
#line 2340 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp13_) {
#line 18316 "Photo.c"
				PhotoRow* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = new_title;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp14_->title);
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_->title = _tmp16_;
#line 18330 "Photo.c"
			}
		}
		__finally349:
		{
			PhotoRow* _tmp17_ = NULL;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->row;
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18340 "Photo.c"
		}
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_title);
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2335 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 18352 "Photo.c"
		}
	}
#line 2344 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2344 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 18359 "Photo.c"
		Alteration* _tmp19_ = NULL;
		Alteration* _tmp20_ = NULL;
#line 2345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = alteration_new ("metadata", "name");
#line 2345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_;
#line 2345 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 2345 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp20_);
#line 18370 "Photo.c"
	}
#line 2331 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_title);
#line 18374 "Photo.c"
}


static gboolean photo_real_set_comment (MediaSource* base, const gchar* comment) {
	Photo * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2348 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2349 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = comment;
#line 2349 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = media_source_prep_comment (_tmp0_);
#line 2349 "/home/jens/Source/shotwell/src/Photo.vala"
	new_comment = _tmp1_;
#line 2351 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 18397 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18404 "Photo.c"
		{
			const gchar* _tmp3_ = NULL;
			PhotoRow* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			PhotoTable* _tmp7_ = NULL;
			PhotoTable* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoID _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = new_comment;
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->comment;
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 18426 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18433 "Photo.c"
				}
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_comment);
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 18439 "Photo.c"
			}
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_table_get_instance ();
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->photo_id;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = new_comment;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_set_comment (_tmp8_, &_tmp10_, _tmp11_);
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp12_;
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp8_);
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = committed;
#line 2357 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp13_) {
#line 18461 "Photo.c"
				PhotoRow* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = new_comment;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp14_->comment);
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_->comment = _tmp16_;
#line 18475 "Photo.c"
			}
		}
		__finally350:
		{
			PhotoRow* _tmp17_ = NULL;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->row;
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18485 "Photo.c"
		}
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_comment);
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2352 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 18497 "Photo.c"
		}
	}
#line 2361 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2361 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 18504 "Photo.c"
		Alteration* _tmp19_ = NULL;
		Alteration* _tmp20_ = NULL;
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = alteration_new ("metadata", "comment");
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_;
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 2362 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp20_);
#line 18515 "Photo.c"
	}
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_comment);
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18523 "Photo.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_error_copy (self) : NULL;
#line 18530 "Photo.c"
}


void photo_set_import_id (Photo* self, ImportID* import_id) {
	GError* dberr = NULL;
	GError* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 2367 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2367 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (import_id != NULL);
#line 2368 "/home/jens/Source/shotwell/src/Photo.vala"
	dberr = NULL;
#line 18544 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18551 "Photo.c"
		{
			{
				PhotoTable* _tmp1_ = NULL;
				PhotoTable* _tmp2_ = NULL;
				PhotoRow* _tmp3_ = NULL;
				PhotoID _tmp4_ = {0};
				ImportID _tmp5_ = {0};
				PhotoRow* _tmp7_ = NULL;
				ImportID _tmp8_ = {0};
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = photo_table_get_instance ();
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _tmp1_;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->photo_id;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = *import_id;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_import_id (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp2_);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 18579 "Photo.c"
						goto __catch352_database_error;
					}
					{
						PhotoRow* _tmp6_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = self->row;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18588 "Photo.c"
					}
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (dberr);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 18598 "Photo.c"
				}
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = *import_id;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_->import_id = _tmp8_;
#line 18606 "Photo.c"
			}
			goto __finally352;
			__catch352_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = err;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				dberr = _tmp10_;
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 18628 "Photo.c"
			}
			__finally352:
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18633 "Photo.c"
				{
					PhotoRow* _tmp11_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18640 "Photo.c"
				}
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 18650 "Photo.c"
			}
		}
		__finally351:
		{
			PhotoRow* _tmp12_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18660 "Photo.c"
		}
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (dberr);
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 18672 "Photo.c"
		}
	}
#line 2378 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = dberr;
#line 2378 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 18679 "Photo.c"
		Alteration* _tmp14_ = NULL;
		Alteration* _tmp15_ = NULL;
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = alteration_new ("metadata", "import-id");
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp14_;
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 2379 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp15_);
#line 18690 "Photo.c"
	} else {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = dberr;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->message;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2381: Unable to write import ID for %s: %s", _tmp17_, _tmp19_);
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp17_);
#line 18708 "Photo.c"
	}
#line 2367 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_error_free0 (dberr);
#line 18712 "Photo.c"
}


void photo_set_title_persistent (Photo* self, const gchar* title, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp12_ = NULL;
	PhotoFileMetadataWriter* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 2384 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2385 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2385 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2388 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 18749 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2389: No photo file writer available for %s", _tmp6_);
#line 2389 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = title;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp7_);
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18772 "Photo.c"
	}
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2396 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18788 "Photo.c"
	}
#line 2397 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2397 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = title;
#line 2397 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_title (_tmp10_, _tmp11_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = source;
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_file_reader_create_metadata_writer (_tmp12_, &_inner_error_);
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp13_;
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18812 "Photo.c"
	}
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_;
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp16_, "Photo.set_persistent_title");
#line 2400 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp16_);
#line 18824 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp17_ = NULL;
		PhotoMetadata* _tmp18_ = NULL;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = writer;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = metadata;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp17_, _tmp18_, &_inner_error_);
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18836 "Photo.c"
			goto __finally353;
		}
	}
	__finally353:
	{
		PhotoFileReader* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = source;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp21_);
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp21_);
#line 18855 "Photo.c"
	}
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18869 "Photo.c"
	}
#line 2407 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = title;
#line 2407 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp22_);
#line 2409 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2384 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2384 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2384 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 18883 "Photo.c"
}


void photo_set_comment_persistent (Photo* self, const gchar* comment, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp12_ = NULL;
	PhotoFileMetadataWriter* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 2412 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2413 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2413 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2416 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2416 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2416 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2416 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 18920 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2417: No photo file writer available for %s", _tmp6_);
#line 2417 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = comment;
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp7_);
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18943 "Photo.c"
	}
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2424 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18959 "Photo.c"
	}
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = comment;
#line 2425 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_comment (_tmp10_, _tmp11_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = source;
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_file_reader_create_metadata_writer (_tmp12_, &_inner_error_);
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp13_;
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18983 "Photo.c"
	}
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_;
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp16_, "Photo.set_persistent_comment");
#line 2428 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp16_);
#line 18995 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp17_ = NULL;
		PhotoMetadata* _tmp18_ = NULL;
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = writer;
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = metadata;
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp17_, _tmp18_, &_inner_error_);
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19007 "Photo.c"
			goto __finally354;
		}
	}
	__finally354:
	{
		PhotoFileReader* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = source;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp21_);
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp21_);
#line 19026 "Photo.c"
	}
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19040 "Photo.c"
	}
#line 2435 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = comment;
#line 2435 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp22_);
#line 2437 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2412 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2412 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2412 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19054 "Photo.c"
}


static void photo_real_set_exposure_time (Dateable* base, time_t time) {
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2440 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 19065 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19072 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			time_t _tmp5_ = 0;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = time;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_set_exposure_time (_tmp2_, &_tmp4_, _tmp5_);
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp6_;
#line 2443 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = committed;
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_) {
#line 19101 "Photo.c"
				PhotoRow* _tmp8_ = NULL;
				time_t _tmp9_ = 0;
				time_t _tmp10_ = 0;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = time;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_->exposure_time = _tmp9_;
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = time;
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->cached_exposure_time = _tmp10_;
#line 19115 "Photo.c"
			}
		}
		__finally355:
		{
			PhotoRow* _tmp11_ = NULL;
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19125 "Photo.c"
		}
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 19135 "Photo.c"
		}
	}
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = committed;
#line 2450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 19142 "Photo.c"
		Alteration* _tmp13_ = NULL;
		Alteration* _tmp14_ = NULL;
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = alteration_new ("metadata", "exposure-time");
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_;
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp14_);
#line 2451 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp14_);
#line 19153 "Photo.c"
	}
}


void photo_set_exposure_time_persistent (Photo* self, time_t time, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	time_t _tmp11_ = 0;
	MetadataDateTime* _tmp12_ = NULL;
	MetadataDateTime* _tmp13_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	PhotoFileMetadataWriter* _tmp15_ = NULL;
	PhotoFileReader* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	time_t _tmp24_ = 0;
	GError * _inner_error_ = NULL;
#line 2454 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2455 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2455 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2458 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2458 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2458 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2458 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 19193 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		time_t _tmp7_ = 0;
#line 2459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2459 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2459 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2459: No photo file writer available for %s", _tmp6_);
#line 2459 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = time;
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), _tmp7_);
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19216 "Photo.c"
	}
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2466 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19232 "Photo.c"
	}
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = time;
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = metadata_date_time_new (_tmp11_);
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_;
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_exposure_date_time (_tmp10_, _tmp13_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2467 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (_tmp13_);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_reader_create_metadata_writer (_tmp14_, &_inner_error_);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp15_;
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19262 "Photo.c"
	}
#line 2470 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = source;
#line 2470 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2470 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_;
#line 2470 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp18_, "Photo.set_exposure_time_persistent");
#line 2470 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp18_);
#line 19274 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp19_ = NULL;
		PhotoMetadata* _tmp20_ = NULL;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = writer;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = metadata;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp19_, _tmp20_, &_inner_error_);
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19286 "Photo.c"
			goto __finally356;
		}
	}
	__finally356:
	{
		PhotoFileReader* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = source;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp23_);
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp23_);
#line 19305 "Photo.c"
	}
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19319 "Photo.c"
	}
#line 2477 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = time;
#line 2477 "/home/jens/Source/shotwell/src/Photo.vala"
	dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), _tmp24_);
#line 2479 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2454 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2454 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2454 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19333 "Photo.c"
}


/**
     * @brief Returns the width and height of the Photo after various
     * arbitrary stages of the pipeline have been applied in
     * the same order they're applied in get_pixbuf_with_options.
     * With no argument passed, it works exactly like the
     * previous incarnation did.
     *
     * @param disallowed_steps Which pipeline steps should NOT
     *      be taken into account when computing image dimensions
     *      (matching the convention set by get_pixbuf_with_options()).
     *      Pipeline steps that do not affect the image geometry are
     *      ignored.
     */
static void photo_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result) {
	Photo * self;
	Dimensions returned_dims = {0};
	Dimensions _tmp0_ = {0};
	PhotoException _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	PhotoException _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	PhotoException _tmp22_ = 0;
	gboolean _tmp23_ = FALSE;
#line 2495 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2497 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 2497 "/home/jens/Source/shotwell/src/Photo.vala"
	returned_dims = _tmp0_;
#line 2500 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = disallowed_steps;
#line 2500 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_exception_allows (_tmp1_, PHOTO_EXCEPTION_ORIENTATION);
#line 2500 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 19372 "Photo.c"
		Orientation ori_tmp = 0;
		Orientation _tmp3_ = 0;
		Orientation _tmp4_ = 0;
#line 2501 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_get_orientation (self);
#line 2501 "/home/jens/Source/shotwell/src/Photo.vala"
		ori_tmp = _tmp3_;
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = ori_tmp;
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
		switch (_tmp4_) {
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_TOP:
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_TOP:
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_BOTTOM:
#line 2504 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_BOTTOM:
#line 19392 "Photo.c"
			{
				gint width_tmp = 0;
				Dimensions _tmp5_ = {0};
				gint _tmp6_ = 0;
				Dimensions _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 2510 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = returned_dims;
#line 2510 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_.width;
#line 2510 "/home/jens/Source/shotwell/src/Photo.vala"
				width_tmp = _tmp6_;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = returned_dims;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_.height;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.width = _tmp8_;
#line 2513 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = width_tmp;
#line 2513 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.height = _tmp9_;
#line 2514 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 19418 "Photo.c"
			}
			default:
			{
#line 2518 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 19424 "Photo.c"
			}
		}
	}
#line 2523 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = disallowed_steps;
#line 2523 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_exception_allows (_tmp10_, PHOTO_EXCEPTION_STRAIGHTEN);
#line 2523 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 19434 "Photo.c"
		gdouble x_size = 0.0;
		gdouble y_size = 0.0;
		gdouble angle = 0.0;
		gdouble _tmp12_ = 0.0;
		Dimensions _tmp13_ = {0};
		gint _tmp14_ = 0;
		Dimensions _tmp15_ = {0};
		gint _tmp16_ = 0;
		gdouble _tmp17_ = 0.0;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		gdouble _tmp21_ = 0.0;
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = 0.0;
#line 2527 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_straighten (self, &_tmp12_);
#line 2527 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = _tmp12_;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = returned_dims;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_.width;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = returned_dims;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_.height;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = angle;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		compute_arb_rotated_size ((gdouble) _tmp14_, (gdouble) _tmp16_, _tmp17_, &_tmp18_, &_tmp19_);
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		x_size = _tmp18_;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		y_size = _tmp19_;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = x_size;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.width = (gint) _tmp20_;
#line 2532 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = y_size;
#line 2532 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.height = (gint) _tmp21_;
#line 19478 "Photo.c"
	}
#line 2536 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = disallowed_steps;
#line 2536 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_exception_allows (_tmp22_, PHOTO_EXCEPTION_CROP);
#line 2536 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 19486 "Photo.c"
		Box crop = {0};
		PhotoException _tmp24_ = 0;
		Box _tmp25_ = {0};
		gboolean _tmp26_ = FALSE;
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = disallowed_steps;
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = photo_get_crop (self, &_tmp25_, _tmp24_);
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp25_;
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp26_) {
#line 19499 "Photo.c"
			Dimensions _tmp27_ = {0};
#line 2539 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp27_);
#line 2539 "/home/jens/Source/shotwell/src/Photo.vala"
			returned_dims = _tmp27_;
#line 19505 "Photo.c"
		}
	}
#line 2542 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = returned_dims;
#line 2542 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 19512 "Photo.c"
}


static void photo_locked_create_adjustments_from_data (Photo* self) {
	PixelTransformationBundle* _tmp0_ = NULL;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp1_ = NULL;
	KeyValueMap* _tmp2_ = NULL;
	PixelTransformationBundle* _tmp6_ = NULL;
	PixelTransformer* _tmp7_ = NULL;
#line 2546 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2547 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 2547 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2547 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->adjustments = _tmp0_;
#line 2549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_transformation (self, "adjustments");
#line 2549 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp1_;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2550 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 19539 "Photo.c"
		PixelTransformationBundle* _tmp3_ = NULL;
#line 2551 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = self->priv->adjustments;
#line 2551 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_set_to_identity (_tmp3_);
#line 19545 "Photo.c"
	} else {
		PixelTransformationBundle* _tmp4_ = NULL;
		KeyValueMap* _tmp5_ = NULL;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->priv->adjustments;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = map;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_load (_tmp4_, _tmp5_);
#line 19555 "Photo.c"
	}
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->priv->adjustments;
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = pixel_transformation_bundle_generate_transformer (_tmp6_);
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (self->priv->transformer);
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->transformer = _tmp7_;
#line 2546 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 19567 "Photo.c"
}


PixelTransformationBundle* photo_get_color_adjustments (Photo* self) {
	PixelTransformationBundle* result = NULL;
	GError * _inner_error_ = NULL;
#line 2559 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 19576 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19583 "Photo.c"
		{
			PixelTransformationBundle* _tmp1_ = NULL;
			PixelTransformationBundle* _tmp2_ = NULL;
			PixelTransformationBundle* _tmp3_ = NULL;
#line 2561 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->adjustments;
#line 2561 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 19594 "Photo.c"
			}
#line 2564 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->adjustments;
#line 2564 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
#line 2564 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 19602 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19609 "Photo.c"
			}
#line 2564 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 19613 "Photo.c"
		}
		__finally357:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19622 "Photo.c"
		}
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2560 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 19630 "Photo.c"
	}
}


PixelTransformer* photo_get_pixel_transformer (Photo* self) {
	PixelTransformer* result = NULL;
	GError * _inner_error_ = NULL;
#line 2568 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 19640 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19647 "Photo.c"
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_ = NULL;
			PixelTransformer* _tmp3_ = NULL;
#line 2570 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->transformer;
#line 2570 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 19658 "Photo.c"
			}
#line 2573 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2573 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformer_copy (_tmp2_);
#line 2573 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 19666 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19673 "Photo.c"
			}
#line 2573 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 19677 "Photo.c"
		}
		__finally358:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19686 "Photo.c"
		}
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2569 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 19694 "Photo.c"
	}
}


gboolean photo_has_color_adjustments (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2577 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2578 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "adjustments");
#line 2578 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2578 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 19710 "Photo.c"
}


PixelTransformation* photo_get_color_adjustment (Photo* self, PixelTransformationType type) {
	PixelTransformation* result = NULL;
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_ = NULL;
	PixelTransformationType _tmp2_ = 0;
	PixelTransformation* _tmp3_ = NULL;
	PixelTransformation* _tmp4_ = NULL;
#line 2581 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_color_adjustments (self);
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = type;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = pixel_transformation_bundle_get_transformation (_tmp1_, _tmp2_);
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (_tmp1_);
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 2582 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 19739 "Photo.c"
}


void photo_set_color_adjustments (Photo* self, PixelTransformationBundle* new_adjustments) {
	PixelTransformationBundle* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	KeyValueMap* map = NULL;
	PixelTransformationBundle* _tmp8_ = NULL;
	KeyValueMap* _tmp9_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp39_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (new_adjustments));
#line 2588 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = new_adjustments;
#line 2588 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = pixel_transformation_bundle_is_identity (_tmp0_);
#line 2588 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 19762 "Photo.c"
		gboolean _result_ = FALSE;
		gboolean _tmp5_ = FALSE;
		{
			PhotoRow* _tmp2_ = NULL;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 19771 "Photo.c"
			{
				gboolean _tmp3_ = FALSE;
#line 2591 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = photo_remove_transformation (self, "adjustments");
#line 2591 "/home/jens/Source/shotwell/src/Photo.vala"
				_result_ = _tmp3_;
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = NULL;
#line 2593 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2593 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = NULL;
#line 19786 "Photo.c"
			}
			__finally359:
			{
				PhotoRow* _tmp4_ = NULL;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19795 "Photo.c"
			}
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 19805 "Photo.c"
			}
		}
#line 2596 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _result_;
#line 2596 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp5_) {
#line 19812 "Photo.c"
			Alteration* _tmp6_ = NULL;
			Alteration* _tmp7_ = NULL;
#line 2597 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = alteration_new ("image", "color-adjustments");
#line 2597 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2597 "/home/jens/Source/shotwell/src/Photo.vala"
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp7_);
#line 2597 "/home/jens/Source/shotwell/src/Photo.vala"
			_alteration_unref0 (_tmp7_);
#line 19823 "Photo.c"
		}
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19827 "Photo.c"
	}
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = new_adjustments;
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = pixel_transformation_bundle_save (_tmp8_, "adjustments");
#line 2603 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp9_;
#line 19835 "Photo.c"
	{
		PhotoRow* _tmp10_ = NULL;
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = self->row;
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19842 "Photo.c"
		{
			gboolean _tmp11_ = FALSE;
			PixelTransformer* _tmp12_ = NULL;
			KeyValueMap* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->priv->transformer;
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp12_ == NULL) {
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = TRUE;
#line 19854 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp13_ = NULL;
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = self->priv->adjustments;
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp13_ == NULL;
#line 19861 "Photo.c"
			}
#line 2607 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 19865 "Photo.c"
				PixelTransformationBundle* _tmp14_ = NULL;
				PixelTransformationBundle* _tmp15_ = NULL;
				PixelTransformationBundle* _tmp16_ = NULL;
				PixelTransformer* _tmp17_ = NULL;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = new_adjustments;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = pixel_transformation_bundle_copy (_tmp14_);
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp15_;
#line 2610 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = new_adjustments;
#line 2610 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = pixel_transformation_bundle_generate_transformer (_tmp16_);
#line 2610 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2610 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp17_;
#line 19886 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp34_ = NULL;
				PixelTransformationBundle* _tmp35_ = NULL;
				{
					GeeIterator* _transformation_it = NULL;
					PixelTransformationBundle* _tmp18_ = NULL;
					GeeIterable* _tmp19_ = NULL;
					GeeIterable* _tmp20_ = NULL;
					GeeIterator* _tmp21_ = NULL;
					GeeIterator* _tmp22_ = NULL;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = new_adjustments;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = pixel_transformation_bundle_get_transformations (_tmp18_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = _tmp19_;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = gee_iterable_iterator (_tmp20_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp22_ = _tmp21_;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp20_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_transformation_it = _tmp22_;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					while (TRUE) {
#line 19913 "Photo.c"
						GeeIterator* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						PixelTransformation* transformation = NULL;
						GeeIterator* _tmp25_ = NULL;
						gpointer _tmp26_ = NULL;
						PixelTransformer* _tmp27_ = NULL;
						PixelTransformationBundle* _tmp28_ = NULL;
						PixelTransformation* _tmp29_ = NULL;
						PixelTransformationType _tmp30_ = 0;
						PixelTransformation* _tmp31_ = NULL;
						PixelTransformation* _tmp32_ = NULL;
						PixelTransformation* _tmp33_ = NULL;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = _transformation_it;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp24_ = gee_iterator_next (_tmp23_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!_tmp24_) {
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
							break;
#line 19934 "Photo.c"
						}
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = _transformation_it;
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp26_ = gee_iterator_get (_tmp25_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						transformation = (PixelTransformation*) _tmp26_;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp27_ = self->priv->transformer;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp28_ = self->priv->adjustments;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp29_ = transformation;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp30_ = pixel_transformation_get_transformation_type (_tmp29_);
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = pixel_transformation_bundle_get_transformation (_tmp28_, _tmp30_);
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp32_ = _tmp31_;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp33_ = transformation;
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						pixel_transformer_replace_transformation (_tmp27_, _tmp32_, _tmp33_);
#line 2614 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (_tmp32_);
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (transformation);
#line 19962 "Photo.c"
					}
#line 2613 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_transformation_it);
#line 19966 "Photo.c"
				}
#line 2619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = new_adjustments;
#line 2619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = pixel_transformation_bundle_copy (_tmp34_);
#line 2619 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2619 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp35_;
#line 19976 "Photo.c"
			}
#line 2622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = map;
#line 2622 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = photo_set_transformation (self, _tmp36_);
#line 2622 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp37_;
#line 19984 "Photo.c"
		}
		__finally360:
		{
			PhotoRow* _tmp38_ = NULL;
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = self->row;
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19993 "Photo.c"
		}
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2606 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20005 "Photo.c"
		}
	}
#line 2625 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = committed;
#line 2625 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp39_) {
#line 20012 "Photo.c"
		Alteration* _tmp40_ = NULL;
		Alteration* _tmp41_ = NULL;
#line 2626 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = alteration_new ("image", "color-adjustments");
#line 2626 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = _tmp40_;
#line 2626 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp41_);
#line 2626 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp41_);
#line 20023 "Photo.c"
	}
#line 2585 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 20027 "Photo.c"
}


static PhotoMetadata* photo_real_get_metadata (PhotoSource* base) {
	Photo * self;
	PhotoMetadata* result = NULL;
	GError * _inner_error_ = NULL;
#line 2630 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 20037 "Photo.c"
	{
		PhotoMetadata* _tmp0_ = NULL;
		PhotoFileReader* _tmp1_ = NULL;
		PhotoFileReader* _tmp2_ = NULL;
		PhotoMetadata* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
		PhotoMetadata* _tmp5_ = NULL;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_get_source_reader (self);
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp4_;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20059 "Photo.c"
			goto __catch361_g_error;
		}
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp0_;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = NULL;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp5_;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp0_);
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20072 "Photo.c"
	}
	goto __finally361;
	__catch361_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_->message;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2634: Unable to load metadata: %s", _tmp7_);
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20096 "Photo.c"
	}
	__finally361:
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_clear_error (&_inner_error_);
#line 2631 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 20105 "Photo.c"
}


PhotoMetadata* photo_get_master_metadata (Photo* self, GError** error) {
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoMetadata* _tmp3_ = NULL;
	PhotoMetadata* _tmp4_ = NULL;
	PhotoMetadata* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 2640 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_master_reader (self);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp2_);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp4_;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 20138 "Photo.c"
	}
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp0_;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (_tmp0_);
#line 2641 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20150 "Photo.c"
}


PhotoMetadata* photo_get_editable_metadata (Photo* self, GError** error) {
	PhotoMetadata* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 2644 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2645 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2645 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 20171 "Photo.c"
		PhotoFileReader* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_reader_read_metadata (_tmp3_, &_inner_error_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (_tmp1_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 20192 "Photo.c"
		}
	} else {
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 20199 "Photo.c"
	}
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20207 "Photo.c"
}


gboolean photo_persist_master_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportMasterState** state, GError** error) {
	PhotoReimportMasterState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* master_reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoFileMetadataWriter* _tmp4_ = NULL;
	PhotoFileReader* _tmp5_ = NULL;
	PhotoFileMetadataWriter* _tmp6_ = NULL;
	PhotoFileMetadataWriter* _tmp7_ = NULL;
	PhotoFileMetadataWriter* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	PhotoReimportMasterState* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	PhotoReimportMasterState* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2653 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
	master_reader = _tmp0_;
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = master_reader;
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20258 "Photo.c"
		} else {
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 20262 "Photo.c"
		}
#line 2660 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20266 "Photo.c"
	}
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = master_reader;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_file_reader_create_metadata_writer (_tmp5_, &_inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp6_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20282 "Photo.c"
	}
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp4_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = NULL;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp7_;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = metadata;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp8_, _tmp9_, &_inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp8_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20306 "Photo.c"
	}
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = photo_prepare_for_reimport_master (self, &_tmp11_, &_inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp11_;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp12_;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20326 "Photo.c"
	}
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp10_) {
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20340 "Photo.c"
		} else {
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 20344 "Photo.c"
		}
#line 2665 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20348 "Photo.c"
	}
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _vala_state;
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl)->metadata_only = TRUE;
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp4_);
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (master_reader);
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 20364 "Photo.c"
	} else {
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_state);
#line 20368 "Photo.c"
	}
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20372 "Photo.c"
}


void photo_finish_update_master_metadata (Photo* self, PhotoReimportMasterState* state, GError** error) {
	PhotoReimportMasterState* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 2672 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2672 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_master (self, _tmp0_, &_inner_error_);
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20395 "Photo.c"
		} else {
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2673 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20403 "Photo.c"
		}
	}
}


gboolean photo_persist_editable_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportEditableState** state, GError** error) {
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* editable_reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	PhotoFileMetadataWriter* _tmp5_ = NULL;
	PhotoFileReader* _tmp6_ = NULL;
	PhotoFileMetadataWriter* _tmp7_ = NULL;
	PhotoFileMetadataWriter* _tmp8_ = NULL;
	PhotoFileMetadataWriter* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	PhotoReimportEditableState* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	PhotoReimportEditableState* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 2676 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2676 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_reader = _tmp0_;
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = editable_reader;
#line 2681 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20453 "Photo.c"
		} else {
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20457 "Photo.c"
		}
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20461 "Photo.c"
	}
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = editable_reader;
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_file_format_can_write_metadata (_tmp3_);
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp4_) {
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20479 "Photo.c"
		} else {
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20483 "Photo.c"
		}
#line 2685 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20487 "Photo.c"
	}
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = editable_reader;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_file_reader_create_metadata_writer (_tmp6_, &_inner_error_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp7_;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20503 "Photo.c"
	}
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp5_;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = NULL;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp9_, _tmp10_, &_inner_error_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp9_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20527 "Photo.c"
	}
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_prepare_for_reimport_editable (self, &_tmp12_, &_inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp12_;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp13_;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20547 "Photo.c"
	}
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp11_) {
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20561 "Photo.c"
		} else {
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20565 "Photo.c"
		}
#line 2690 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20569 "Photo.c"
	}
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _vala_state;
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl)->metadata_only = TRUE;
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp5_);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (editable_reader);
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 20585 "Photo.c"
	} else {
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 20589 "Photo.c"
	}
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20593 "Photo.c"
}


void photo_finish_update_editable_metadata (Photo* self, PhotoReimportEditableState* state, GError** error) {
	PhotoReimportEditableState* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 2697 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2697 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_editable (self, _tmp0_, &_inner_error_);
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20616 "Photo.c"
		} else {
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2698 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20624 "Photo.c"
		}
	}
}


void photo_get_raw_dimensions (Photo* self, Dimensions* result) {
	GError * _inner_error_ = NULL;
#line 2703 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 20634 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20641 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			Dimensions _tmp2_ = {0};
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->dim;
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 20651 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20658 "Photo.c"
			}
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20662 "Photo.c"
		}
		__finally362:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20671 "Photo.c"
		}
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2704 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 20679 "Photo.c"
	}
}


gboolean photo_has_transformations (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2709 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 20689 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20696 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_ = NULL;
			Orientation _tmp3_ = 0;
			BackingPhotoRow* _tmp4_ = NULL;
			Orientation _tmp5_ = 0;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->orientation;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->backing_photo_row;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->original_orientation;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != _tmp5_) {
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = TRUE;
#line 20715 "Photo.c"
			} else {
				PhotoRow* _tmp6_ = NULL;
				GeeHashMap* _tmp7_ = NULL;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->transformations;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp7_ != NULL;
#line 20725 "Photo.c"
			}
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 20729 "Photo.c"
			{
				PhotoRow* _tmp8_ = NULL;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20736 "Photo.c"
			}
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20740 "Photo.c"
		}
		__finally363:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20749 "Photo.c"
		}
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2710 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20757 "Photo.c"
	}
}


gboolean photo_only_metadata_changed (Photo* self) {
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 2717 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2718 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2720 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2720 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2721 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2721 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 20781 "Photo.c"
		PhotoMetadata* _tmp2_ = NULL;
		MetadataDateTime* _tmp3_ = NULL;
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 20792 "Photo.c"
	}
	{
		PhotoRow* _tmp4_ = NULL;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->row;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20800 "Photo.c"
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->transformations;
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_ == NULL) {
#line 20811 "Photo.c"
				gboolean _tmp8_ = FALSE;
				PhotoRow* _tmp9_ = NULL;
				Orientation _tmp10_ = 0;
				BackingPhotoRow* _tmp11_ = NULL;
				Orientation _tmp12_ = 0;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->orientation;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->backing_photo_row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->original_orientation;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ != _tmp12_) {
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = TRUE;
#line 20829 "Photo.c"
				} else {
					gboolean _tmp13_ = FALSE;
					MetadataDateTime* _tmp14_ = NULL;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = date_time;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp14_ != NULL) {
#line 20837 "Photo.c"
						PhotoRow* _tmp15_ = NULL;
						time_t _tmp16_ = 0;
						MetadataDateTime* _tmp17_ = NULL;
						time_t _tmp18_ = 0;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = self->row;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = _tmp15_->exposure_time;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = date_time;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = metadata_date_time_get_timestamp (_tmp17_);
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = _tmp16_ != _tmp18_;
#line 20852 "Photo.c"
					} else {
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = FALSE;
#line 20856 "Photo.c"
					}
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = _tmp13_;
#line 20860 "Photo.c"
				}
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 20864 "Photo.c"
			} else {
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = FALSE;
#line 20868 "Photo.c"
			}
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp5_;
#line 20872 "Photo.c"
			{
				PhotoRow* _tmp19_ = NULL;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = self->row;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20879 "Photo.c"
			}
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2725 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20887 "Photo.c"
		}
		__finally364:
		{
			PhotoRow* _tmp20_ = NULL;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->row;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20896 "Photo.c"
		}
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 20908 "Photo.c"
	}
#line 2717 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2717 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 20914 "Photo.c"
}


gboolean photo_has_alterations (Photo* self) {
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	gchar* title = NULL;
	gchar* comment = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	MetadataDateTime* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2732 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	title = NULL;
#line 2734 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = NULL;
#line 2736 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2736 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2737 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 20944 "Photo.c"
		PhotoMetadata* _tmp2_ = NULL;
		MetadataDateTime* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		PhotoMetadata* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = metadata;
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp5_;
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = metadata;
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp7_;
#line 20975 "Photo.c"
	}
#line 2744 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = date_time;
#line 2744 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == NULL) {
#line 20981 "Photo.c"
		{
			PhotoRow* _tmp9_ = NULL;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 20988 "Photo.c"
			{
				BackingPhotoRow* _tmp10_ = NULL;
				time_t _tmp11_ = 0;
				PhotoRow* _tmp12_ = NULL;
				time_t _tmp13_ = 0;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->backing_photo_row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_->timestamp;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->exposure_time;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_ != _tmp13_) {
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 21006 "Photo.c"
					{
						PhotoRow* _tmp14_ = NULL;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = self->row;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21013 "Photo.c"
					}
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (metadata);
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (comment);
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (title);
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					_metadata_date_time_unref0 (date_time);
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 21025 "Photo.c"
				}
			}
			__finally365:
			{
				PhotoRow* _tmp15_ = NULL;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21035 "Photo.c"
			}
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (metadata);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (comment);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (title);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				_metadata_date_time_unref0 (date_time);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
				return FALSE;
#line 21053 "Photo.c"
			}
		}
	}
	{
		PhotoRow* _tmp16_ = NULL;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = self->row;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21063 "Photo.c"
		{
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			PhotoRow* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = self->row;
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = _tmp21_->transformations;
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp22_ != NULL) {
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = TRUE;
#line 21079 "Photo.c"
			} else {
				PhotoRow* _tmp23_ = NULL;
				Orientation _tmp24_ = 0;
				BackingPhotoRow* _tmp25_ = NULL;
				Orientation _tmp26_ = 0;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = self->row;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = _tmp23_->orientation;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = self->backing_photo_row;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp25_->original_orientation;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = _tmp24_ != _tmp26_;
#line 21095 "Photo.c"
			}
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp20_) {
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = TRUE;
#line 21101 "Photo.c"
			} else {
				gboolean _tmp27_ = FALSE;
				MetadataDateTime* _tmp28_ = NULL;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = date_time;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp28_ != NULL) {
#line 21109 "Photo.c"
					PhotoRow* _tmp29_ = NULL;
					time_t _tmp30_ = 0;
					MetadataDateTime* _tmp31_ = NULL;
					time_t _tmp32_ = 0;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp29_ = self->row;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp30_ = _tmp29_->exposure_time;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp31_ = date_time;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp32_ = metadata_date_time_get_timestamp (_tmp31_);
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp27_ = _tmp30_ != _tmp32_;
#line 21124 "Photo.c"
				} else {
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp27_ = FALSE;
#line 21128 "Photo.c"
				}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = _tmp27_;
#line 21132 "Photo.c"
			}
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp19_) {
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = TRUE;
#line 21138 "Photo.c"
			} else {
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = comment;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = g_strcmp0 (_tmp34_, _tmp35_) != 0;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp34_);
#line 21153 "Photo.c"
			}
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp18_) {
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = TRUE;
#line 21159 "Photo.c"
			} else {
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = title;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = g_strcmp0 (_tmp37_, _tmp38_) != 0;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp37_);
#line 21174 "Photo.c"
			}
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp17_;
#line 21178 "Photo.c"
			{
				PhotoRow* _tmp39_ = NULL;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = self->row;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21185 "Photo.c"
			}
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2756 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21197 "Photo.c"
		}
		__finally366:
		{
			PhotoRow* _tmp40_ = NULL;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = self->row;
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21206 "Photo.c"
		}
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2755 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 21222 "Photo.c"
	}
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 2731 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 21232 "Photo.c"
}


PhotoTransformationState* photo_save_transformation_state (Photo* self) {
	PhotoTransformationState* result = NULL;
	GError * _inner_error_ = NULL;
#line 2765 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 21241 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21248 "Photo.c"
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_ = NULL;
			PixelTransformationBundle* _tmp5_ = NULL;
			PixelTransformationBundle* _tmp6_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			Orientation _tmp10_ = 0;
			PhotoRow* _tmp11_ = NULL;
			GeeHashMap* _tmp12_ = NULL;
			PhotoPhotoTransformationStateImpl* _tmp13_ = NULL;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 21263 "Photo.c"
				PixelTransformer* _tmp3_ = NULL;
				PixelTransformer* _tmp4_ = NULL;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->transformer;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = pixel_transformer_copy (_tmp3_);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp4_;
#line 21274 "Photo.c"
			} else {
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 21280 "Photo.c"
			}
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->adjustments;
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != NULL) {
#line 21286 "Photo.c"
				PixelTransformationBundle* _tmp7_ = NULL;
				PixelTransformationBundle* _tmp8_ = NULL;
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->adjustments;
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = pixel_transformation_bundle_copy (_tmp7_);
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 21297 "Photo.c"
			} else {
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2770 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = NULL;
#line 21303 "Photo.c"
			}
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->orientation;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_->transformations;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_photo_transformation_state_impl_new (self, _tmp10_, _tmp12_, _tmp1_, _tmp5_);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (_tmp1_);
#line 21321 "Photo.c"
			{
				PhotoRow* _tmp14_ = NULL;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21328 "Photo.c"
			}
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21332 "Photo.c"
		}
		__finally367:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21341 "Photo.c"
		}
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2766 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 21349 "Photo.c"
	}
}


static gpointer _pixel_transformer_ref0 (gpointer self) {
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformer_ref (self) : NULL;
#line 21357 "Photo.c"
}


static gpointer _pixel_transformation_bundle_ref0 (gpointer self) {
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformation_bundle_ref (self) : NULL;
#line 21364 "Photo.c"
}


gboolean photo_load_transformation_state (Photo* self, PhotoTransformationState* state) {
	gboolean result = FALSE;
	PhotoPhotoTransformationStateImpl* state_impl = NULL;
	PhotoTransformationState* _tmp0_ = NULL;
	PhotoPhotoTransformationStateImpl* _tmp1_ = NULL;
	PhotoPhotoTransformationStateImpl* _tmp2_ = NULL;
	Orientation saved_orientation = 0;
	PhotoPhotoTransformationStateImpl* _tmp3_ = NULL;
	Orientation _tmp4_ = 0;
	GeeHashMap* saved_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	PixelTransformer* saved_transformer = NULL;
	PhotoPhotoTransformationStateImpl* _tmp7_ = NULL;
	PixelTransformer* _tmp8_ = NULL;
	PixelTransformationBundle* saved_adjustments = NULL;
	PhotoPhotoTransformationStateImpl* _tmp9_ = NULL;
	PixelTransformationBundle* _tmp10_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp30_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2774 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2774 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (state), FALSE);
#line 2775 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2775 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL) ? ((PhotoPhotoTransformationStateImpl*) _tmp0_) : NULL);
#line 2775 "/home/jens/Source/shotwell/src/Photo.vala"
	state_impl = _tmp1_;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = state_impl;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (state_impl);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21409 "Photo.c"
	}
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = state_impl;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_photo_transformation_state_impl_get_orientation (_tmp3_);
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_orientation = _tmp4_;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = state_impl;
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_photo_transformation_state_impl_get_transformations (_tmp5_);
#line 2780 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformations = _tmp6_;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = state_impl;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_photo_transformation_state_impl_get_transformer (_tmp7_);
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformer = _tmp8_;
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = state_impl;
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_photo_transformation_state_impl_get_color_adjustments (_tmp9_);
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_adjustments = _tmp10_;
#line 21435 "Photo.c"
	{
		PhotoRow* _tmp11_ = NULL;
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = self->row;
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21442 "Photo.c"
		{
			PhotoTable* _tmp12_ = NULL;
			PhotoTable* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			PhotoID _tmp15_ = {0};
			Orientation _tmp16_ = 0;
			GeeHashMap* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_get_instance ();
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->photo_id;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = saved_orientation;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = saved_transformations;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = photo_table_set_transformation_state (_tmp13_, &_tmp15_, _tmp16_, _tmp17_);
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp18_;
#line 2786 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp13_);
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = committed;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp19_) {
#line 21474 "Photo.c"
				PhotoRow* _tmp20_ = NULL;
				Orientation _tmp21_ = 0;
				PhotoRow* _tmp22_ = NULL;
				GeeHashMap* _tmp23_ = NULL;
				GeeHashMap* _tmp24_ = NULL;
				PixelTransformer* _tmp25_ = NULL;
				PixelTransformer* _tmp26_ = NULL;
				PixelTransformationBundle* _tmp27_ = NULL;
				PixelTransformationBundle* _tmp28_ = NULL;
#line 2789 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = self->row;
#line 2789 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = saved_orientation;
#line 2789 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_->orientation = _tmp21_;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = self->row;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = saved_transformations;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp22_->transformations);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_->transformations = _tmp24_;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = saved_transformer;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _pixel_transformer_ref0 (_tmp25_);
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp26_;
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = saved_adjustments;
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _pixel_transformation_bundle_ref0 (_tmp27_);
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp28_;
#line 21516 "Photo.c"
			}
		}
		__finally368:
		{
			PhotoRow* _tmp29_ = NULL;
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = self->row;
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21526 "Photo.c"
		}
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (saved_transformer);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (saved_transformations);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (state_impl);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2785 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 21544 "Photo.c"
		}
	}
#line 2796 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = committed;
#line 2796 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp30_) {
#line 21551 "Photo.c"
		Alteration* _tmp31_ = NULL;
		Alteration* _tmp32_ = NULL;
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = alteration_new ("image", "transformation-state");
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = _tmp31_;
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp32_);
#line 2797 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp32_);
#line 21562 "Photo.c"
	}
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (saved_transformer);
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (saved_transformations);
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (state_impl);
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21576 "Photo.c"
}


void photo_remove_all_transformations (Photo* self) {
#line 2802 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2803 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_internal_remove_all_transformations (self, TRUE);
#line 21585 "Photo.c"
}


static void photo_internal_remove_all_transformations (Photo* self, gboolean notify) {
	gboolean is_altered = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2806 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2807 "/home/jens/Source/shotwell/src/Photo.vala"
	is_altered = FALSE;
#line 21598 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21605 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_ = NULL;
			PhotoRow* _tmp7_ = NULL;
			Orientation _tmp8_ = 0;
			BackingPhotoRow* _tmp9_ = NULL;
			Orientation _tmp10_ = 0;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_table_remove_all_transformations (_tmp2_, &_tmp4_);
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			is_altered = _tmp5_;
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp6_->transformations);
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_->transformations = NULL;
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (self->priv->transformer);
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->transformer = NULL;
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2813 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->adjustments = NULL;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->orientation;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->backing_photo_row;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->original_orientation;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != _tmp10_) {
#line 21655 "Photo.c"
				PhotoTable* _tmp11_ = NULL;
				PhotoTable* _tmp12_ = NULL;
				PhotoRow* _tmp13_ = NULL;
				PhotoID _tmp14_ = {0};
				BackingPhotoRow* _tmp15_ = NULL;
				Orientation _tmp16_ = 0;
				PhotoRow* _tmp17_ = NULL;
				BackingPhotoRow* _tmp18_ = NULL;
				Orientation _tmp19_ = 0;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_get_instance ();
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = self->row;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = _tmp13_->photo_id;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->backing_photo_row;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->original_orientation;
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_orientation (_tmp12_, &_tmp14_, _tmp16_);
#line 2816 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp12_);
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->row;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->backing_photo_row;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = _tmp18_->original_orientation;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_->orientation = _tmp19_;
#line 2819 "/home/jens/Source/shotwell/src/Photo.vala"
				is_altered = TRUE;
#line 21691 "Photo.c"
			}
		}
		__finally369:
		{
			PhotoRow* _tmp20_ = NULL;
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->row;
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21701 "Photo.c"
		}
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21711 "Photo.c"
		}
	}
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = is_altered;
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_) {
#line 21718 "Photo.c"
		gboolean _tmp23_ = FALSE;
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = notify;
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp23_;
#line 21724 "Photo.c"
	} else {
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = FALSE;
#line 21728 "Photo.c"
	}
#line 2823 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 21732 "Photo.c"
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 2824 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("image", "revert");
#line 2824 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 2824 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 2824 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 21743 "Photo.c"
	}
}


Orientation photo_get_original_orientation (Photo* self) {
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2827 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 21753 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21760 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->original_orientation;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 21770 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21777 "Photo.c"
			}
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21781 "Photo.c"
		}
		__finally370:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21790 "Photo.c"
		}
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2828 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 21798 "Photo.c"
	}
}


Orientation photo_get_orientation (Photo* self) {
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2833 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 21808 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21815 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
#line 2835 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2835 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2835 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 21825 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21832 "Photo.c"
			}
#line 2835 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21836 "Photo.c"
		}
		__finally371:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21845 "Photo.c"
		}
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2834 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 21853 "Photo.c"
	}
}


gboolean photo_set_orientation (Photo* self, Orientation orientation) {
	gboolean result = FALSE;
	gboolean committed = FALSE;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2839 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2840 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 21867 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21874 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
			Orientation _tmp3_ = 0;
#line 2842 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2842 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2842 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = orientation;
#line 2842 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp3_) {
#line 21887 "Photo.c"
				PhotoTable* _tmp4_ = NULL;
				PhotoTable* _tmp5_ = NULL;
				PhotoRow* _tmp6_ = NULL;
				PhotoID _tmp7_ = {0};
				Orientation _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_table_get_instance ();
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->photo_id;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = orientation;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo_table_set_orientation (_tmp5_, &_tmp7_, _tmp8_);
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp9_;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp5_);
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 21915 "Photo.c"
					PhotoRow* _tmp11_ = NULL;
					Orientation _tmp12_ = 0;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = orientation;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->orientation = _tmp12_;
#line 21924 "Photo.c"
				}
			}
		}
		__finally372:
		{
			PhotoRow* _tmp13_ = NULL;
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21935 "Photo.c"
		}
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 21945 "Photo.c"
		}
	}
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = committed;
#line 2849 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp14_) {
#line 21952 "Photo.c"
		Alteration* _tmp15_ = NULL;
		Alteration* _tmp16_ = NULL;
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = alteration_new ("image", "orientation");
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_;
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp16_);
#line 2850 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp16_);
#line 21963 "Photo.c"
	}
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21969 "Photo.c"
}


gboolean photo_check_can_rotate (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2855 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->can_rotate_now;
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2856 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21984 "Photo.c"
}


static void photo_real_rotate (Photo* self, Rotation rotation) {
	GError * _inner_error_ = NULL;
	{
		PhotoRow* _tmp0_ = NULL;
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21996 "Photo.c"
		{
			Orientation _tmp1_ = 0;
			Rotation _tmp2_ = 0;
			Orientation _tmp3_ = 0;
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_get_orientation (self);
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = rotation;
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = orientation_perform (_tmp1_, _tmp2_);
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, _tmp3_);
#line 22009 "Photo.c"
		}
		__finally373:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22018 "Photo.c"
		}
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2860 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 22028 "Photo.c"
		}
	}
}


void photo_rotate (Photo* self, Rotation rotation) {
#line 2859 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2859 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->rotate (self, rotation);
#line 22039 "Photo.c"
}


static gboolean photo_has_transformation (Photo* self, const gchar* name) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2865 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2865 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 22050 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22057 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_ = NULL;
			GeeHashMap* _tmp3_ = NULL;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->transformations;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 22068 "Photo.c"
				PhotoRow* _tmp4_ = NULL;
				GeeHashMap* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->transformations;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = name;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp7_;
#line 22083 "Photo.c"
			} else {
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 22087 "Photo.c"
			}
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 22091 "Photo.c"
			{
				PhotoRow* _tmp8_ = NULL;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22098 "Photo.c"
			}
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22102 "Photo.c"
		}
		__finally374:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22111 "Photo.c"
		}
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2866 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 22119 "Photo.c"
	}
}


static KeyValueMap* photo_get_transformation (Photo* self, const gchar* name) {
	KeyValueMap* result = NULL;
	KeyValueMap* map = NULL;
	GError * _inner_error_ = NULL;
#line 2874 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2874 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2875 "/home/jens/Source/shotwell/src/Photo.vala"
	map = NULL;
#line 22134 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22141 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 22151 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				KeyValueMap* _tmp7_ = NULL;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = name;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_);
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				_key_value_map_unref0 (map);
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
				map = (KeyValueMap*) _tmp6_;
#line 2879 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = map;
#line 2879 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp7_ != NULL) {
#line 22173 "Photo.c"
					KeyValueMap* _tmp8_ = NULL;
					KeyValueMap* _tmp9_ = NULL;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = map;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = key_value_map_copy (_tmp8_);
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
					_key_value_map_unref0 (map);
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
					map = _tmp9_;
#line 22184 "Photo.c"
				}
			}
		}
		__finally375:
		{
			PhotoRow* _tmp10_ = NULL;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22195 "Photo.c"
		}
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 22207 "Photo.c"
		}
	}
#line 2884 "/home/jens/Source/shotwell/src/Photo.vala"
	result = map;
#line 2884 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22214 "Photo.c"
}


static gboolean photo_set_transformation (Photo* self, KeyValueMap* trans) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2887 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_KEY_VALUE_MAP (trans), FALSE);
#line 22225 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22232 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
			PhotoRow* _tmp5_ = NULL;
			GeeHashMap* _tmp6_ = NULL;
			KeyValueMap* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			KeyValueMap* _tmp10_ = NULL;
			PhotoTable* _tmp11_ = NULL;
			PhotoTable* _tmp12_ = NULL;
			PhotoRow* _tmp13_ = NULL;
			PhotoID _tmp14_ = {0};
			KeyValueMap* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
#line 2889 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2889 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2889 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ == NULL) {
#line 22255 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp3_->transformations);
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_->transformations = _tmp4_;
#line 22266 "Photo.c"
			}
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->transformations;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = trans;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = key_value_map_get_group (_tmp7_);
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = trans;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp9_);
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = photo_table_get_instance ();
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->photo_id;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = trans;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = photo_table_set_transformation (_tmp12_, &_tmp14_, _tmp15_);
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp12_);
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp17_;
#line 22302 "Photo.c"
			{
				PhotoRow* _tmp18_ = NULL;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->row;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22309 "Photo.c"
			}
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22313 "Photo.c"
		}
		__finally376:
		{
			PhotoRow* _tmp19_ = NULL;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22322 "Photo.c"
		}
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2888 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 22330 "Photo.c"
	}
}


static gboolean photo_remove_transformation (Photo* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean altered_cache = FALSE;
	gboolean altered_persistent = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2898 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2898 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 22346 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22353 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
			PhotoTable* _tmp12_ = NULL;
			PhotoTable* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			PhotoID _tmp15_ = {0};
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2901 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 22369 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				PhotoRow* _tmp7_ = NULL;
				GeeHashMap* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = name;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_, NULL);
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = _tmp6_;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_->transformations;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_MAP, GeeMap));
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ == 0) {
#line 22398 "Photo.c"
					PhotoRow* _tmp11_ = NULL;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp11_->transformations);
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->transformations = NULL;
#line 22406 "Photo.c"
				}
			} else {
#line 2906 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = FALSE;
#line 22411 "Photo.c"
			}
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_get_instance ();
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->photo_id;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = name;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = photo_table_remove_transformation (_tmp13_, &_tmp15_, _tmp16_);
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			altered_persistent = _tmp17_;
#line 2909 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp13_);
#line 22429 "Photo.c"
		}
		__finally377:
		{
			PhotoRow* _tmp18_ = NULL;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = self->row;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22438 "Photo.c"
		}
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
			return FALSE;
#line 22448 "Photo.c"
		}
	}
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = altered_cache;
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_) {
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = TRUE;
#line 22457 "Photo.c"
	} else {
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = altered_persistent;
#line 22461 "Photo.c"
	}
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp19_;
#line 2913 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22467 "Photo.c"
}


gboolean photo_has_crop (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2916 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2917 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "crop");
#line 2917 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2917 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22482 "Photo.c"
}


gboolean photo_get_raw_crop (Photo* self, Box* crop) {
	Box _vala_crop = {0};
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint left = 0;
	KeyValueMap* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint top = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint right = 0;
	KeyValueMap* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint bottom = 0;
	KeyValueMap* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
#line 2921 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2922 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, 0, 0, 0, 0);
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "crop");
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2925 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2925 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 22532 "Photo.c"
		}
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22536 "Photo.c"
	}
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = key_value_map_get_int (_tmp2_, "left", -1);
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
	left = _tmp3_;
#line 2929 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2929 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "top", -1);
#line 2929 "/home/jens/Source/shotwell/src/Photo.vala"
	top = _tmp5_;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = map;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = key_value_map_get_int (_tmp6_, "right", -1);
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	right = _tmp7_;
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = map;
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = key_value_map_get_int (_tmp8_, "bottom", -1);
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	bottom = _tmp9_;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = left;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == -1) {
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 22568 "Photo.c"
	} else {
		gint _tmp14_ = 0;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = top;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp14_ == -1;
#line 22575 "Photo.c"
	}
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = TRUE;
#line 22581 "Photo.c"
	} else {
		gint _tmp15_ = 0;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = right;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp15_ == -1;
#line 22588 "Photo.c"
	}
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = TRUE;
#line 22594 "Photo.c"
	} else {
		gint _tmp16_ = 0;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = bottom;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp16_ == -1;
#line 22601 "Photo.c"
	}
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_) {
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 22613 "Photo.c"
		}
#line 2934 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22617 "Photo.c"
	}
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = left;
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = top;
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = right;
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = bottom;
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	if (crop) {
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
		*crop = _vala_crop;
#line 22637 "Photo.c"
	}
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22641 "Photo.c"
}


static void photo_set_raw_crop (Photo* self, Box* crop) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	Box _tmp2_ = {0};
	gint _tmp3_ = 0;
	KeyValueMap* _tmp4_ = NULL;
	Box _tmp5_ = {0};
	gint _tmp6_ = 0;
	KeyValueMap* _tmp7_ = NULL;
	Box _tmp8_ = {0};
	gint _tmp9_ = 0;
	KeyValueMap* _tmp10_ = NULL;
	Box _tmp11_ = {0};
	gint _tmp12_ = 0;
	KeyValueMap* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 2942 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2942 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (crop != NULL);
#line 2943 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("crop");
#line 2943 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *crop;
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_.left;
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp1_, "left", _tmp3_);
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = *crop;
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _tmp5_.top;
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp4_, "top", _tmp6_);
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = map;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = *crop;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_.right;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp7_, "right", _tmp9_);
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = map;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = *crop;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_.bottom;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp10_, "bottom", _tmp12_);
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = map;
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_set_transformation (self, _tmp13_);
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp14_) {
#line 22708 "Photo.c"
		Alteration* _tmp15_ = NULL;
		Alteration* _tmp16_ = NULL;
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = alteration_new ("image", "crop");
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_;
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp16_);
#line 2950 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp16_);
#line 22719 "Photo.c"
	}
#line 2942 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 22723 "Photo.c"
}


static gboolean photo_get_raw_straighten (Photo* self, gdouble* angle) {
	gdouble _vala_angle = 0.0;
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	KeyValueMap* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 2953 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "straighten");
#line 2954 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2956 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_angle = 0.0;
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
		if (angle) {
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
			*angle = _vala_angle;
#line 22755 "Photo.c"
		}
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22759 "Photo.c"
	}
#line 2961 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2961 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = key_value_map_get_double (_tmp2_, "angle", 0.0);
#line 2961 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_angle = _tmp3_;
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	if (angle) {
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
		*angle = _vala_angle;
#line 22775 "Photo.c"
	}
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22779 "Photo.c"
}


static void photo_set_raw_straighten (Photo* self, gdouble theta) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	KeyValueMap* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("straighten");
#line 2967 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = theta;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_double (_tmp1_, "angle", _tmp2_);
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = map;
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_set_transformation (self, _tmp3_);
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp4_) {
#line 22808 "Photo.c"
		Alteration* _tmp5_ = NULL;
		Alteration* _tmp6_ = NULL;
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = alteration_new ("image", "straighten");
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp6_);
#line 2971 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp6_);
#line 22819 "Photo.c"
	}
#line 2966 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 22823 "Photo.c"
}


static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self, int* result_length1) {
	EditingToolsRedeyeInstance* result = NULL;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint num_points = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	EditingToolsRedeyeInstance* res = NULL;
	gint _tmp7_ = 0;
	EditingToolsRedeyeInstance* _tmp8_ = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	GdkPoint default_point = {0};
	GdkPoint _tmp9_ = {0};
	EditingToolsRedeyeInstance* _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
#line 2976 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2977 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 2977 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2978 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2978 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 22855 "Photo.c"
		EditingToolsRedeyeInstance* _tmp2_ = NULL;
		EditingToolsRedeyeInstance* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_new0 (EditingToolsRedeyeInstance, 0);
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3__length1 = 0;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		if (result_length1) {
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
			*result_length1 = _tmp3__length1;
#line 22869 "Photo.c"
		}
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp3_;
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22877 "Photo.c"
	}
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp5_;
#line 2982 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 2982 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp6_ > 0, "num_points > 0");
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = num_points;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_new0 (EditingToolsRedeyeInstance, _tmp7_);
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	res = _tmp8_;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	res_length1 = _tmp7_;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_res_size_ = res_length1;
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_.x = 0;
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point = _tmp9_;
#line 2987 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.x = -1;
#line 2988 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.y = -1;
#line 22907 "Photo.c"
	{
		gint i = 0;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
		i = 0;
#line 22912 "Photo.c"
		{
			gboolean _tmp10_ = FALSE;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = TRUE;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 22919 "Photo.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gchar* center_key = NULL;
				gint _tmp14_ = 0;
				gchar* _tmp15_ = NULL;
				gchar* radius_key = NULL;
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				EditingToolsRedeyeInstance* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				KeyValueMap* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				GdkPoint _tmp22_ = {0};
				GdkPoint _tmp23_ = {0};
				EditingToolsRedeyeInstance* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp25_ = 0;
				EditingToolsRedeyeInstance _tmp26_ = {0};
				GdkPoint _tmp27_ = {0};
				gint _tmp28_ = 0;
				GdkPoint _tmp29_ = {0};
				gint _tmp30_ = 0;
				EditingToolsRedeyeInstance* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				EditingToolsRedeyeInstance _tmp33_ = {0};
				GdkPoint _tmp34_ = {0};
				gint _tmp35_ = 0;
				GdkPoint _tmp36_ = {0};
				gint _tmp37_ = 0;
				EditingToolsRedeyeInstance* _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				KeyValueMap* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				EditingToolsRedeyeInstance* _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp44_ = 0;
				EditingToolsRedeyeInstance _tmp45_ = {0};
				gint _tmp46_ = 0;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp10_) {
#line 22964 "Photo.c"
					gint _tmp11_ = 0;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = i;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
					i = _tmp11_ + 1;
#line 22970 "Photo.c"
				}
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = FALSE;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = i;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = num_points;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!(_tmp12_ < _tmp13_)) {
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 22982 "Photo.c"
				}
#line 2991 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = i;
#line 2991 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = g_strdup_printf ("center%d", _tmp14_);
#line 2991 "/home/jens/Source/shotwell/src/Photo.vala"
				center_key = _tmp15_;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = i;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = g_strdup_printf ("radius%d", _tmp16_);
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				radius_key = _tmp17_;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = res;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18__length1 = res_length1;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = i;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = map;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = center_key;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = default_point;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				key_value_map_get_point (_tmp20_, _tmp21_, &_tmp22_, &_tmp23_);
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_[_tmp19_].center = _tmp23_;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = res;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24__length1 = res_length1;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = i;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp24_[_tmp25_];
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_.center;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_.x;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = default_point;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp29_.x;
#line 2995 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp28_ != _tmp30_, "res[i].center.x != default_point.x");
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = res;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31__length1 = res_length1;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = i;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_.center;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = _tmp34_.y;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = default_point;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_.y;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp35_ != _tmp37_, "res[i].center.y != default_point.y");
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = res;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38__length1 = res_length1;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = i;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = map;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = radius_key;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp42_ = key_value_map_get_int (_tmp40_, _tmp41_, -1);
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_[_tmp39_].radius = _tmp42_;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = res;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43__length1 = res_length1;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = i;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = _tmp43_[_tmp44_];
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = _tmp45_.radius;
#line 2999 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp46_ != -1, "res[i].radius != -1");
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (radius_key);
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (center_key);
#line 23078 "Photo.c"
			}
		}
	}
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = res;
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47__length1 = res_length1;
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp47__length1;
#line 23090 "Photo.c"
	}
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp47_;
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 3002 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23098 "Photo.c"
}


gboolean photo_has_redeye_transformations (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 3005 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3006 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "redeye");
#line 3006 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 3006 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23113 "Photo.c"
}


void photo_add_redeye_instance (Photo* self, EditingToolsRedeyeInstance* redeye) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint num_points = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* radius_key = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* center_key = NULL;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	KeyValueMap* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	EditingToolsRedeyeInstance _tmp14_ = {0};
	gint _tmp15_ = 0;
	KeyValueMap* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	EditingToolsRedeyeInstance _tmp18_ = {0};
	GdkPoint _tmp19_ = {0};
	KeyValueMap* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	KeyValueMap* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
#line 3010 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 3010 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (redeye != NULL);
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 3011 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 23156 "Photo.c"
		KeyValueMap* _tmp2_ = NULL;
		KeyValueMap* _tmp3_ = NULL;
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = key_value_map_new ("redeye");
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
		map = _tmp2_;
#line 3014 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = map;
#line 3014 "/home/jens/Source/shotwell/src/Photo.vala"
		key_value_map_set_int (_tmp3_, "num_points", 0);
#line 23169 "Photo.c"
	}
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 3017 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp5_;
#line 3018 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 3018 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp6_ >= 0, "num_points >= 0");
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = num_points;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp7_ + 1;
#line 3022 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = num_points;
#line 3022 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = g_strdup_printf ("radius%d", _tmp8_ - 1);
#line 3022 "/home/jens/Source/shotwell/src/Photo.vala"
	radius_key = _tmp9_;
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = num_points;
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = g_strdup_printf ("center%d", _tmp10_ - 1);
#line 3023 "/home/jens/Source/shotwell/src/Photo.vala"
	center_key = _tmp11_;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = map;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = radius_key;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = *redeye;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_.radius;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp12_, _tmp13_, _tmp15_);
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = map;
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = center_key;
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = *redeye;
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_.center;
#line 3026 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_point (_tmp16_, _tmp17_, &_tmp19_);
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = map;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = num_points;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp20_, "num_points", _tmp21_);
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = map;
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_set_transformation (self, _tmp22_);
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 23229 "Photo.c"
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("image", "redeye");
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 3031 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 23240 "Photo.c"
	}
#line 3010 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (center_key);
#line 3010 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (radius_key);
#line 3010 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 23248 "Photo.c"
}


static gboolean photo_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport) {
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 23261 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 23268 "Photo.c"
		{
			Scaling _tmp1_ = {0};
			PhotoException _tmp2_ = 0;
			Dimensions _tmp3_ = {0};
			Dimensions _tmp4_ = {0};
			gboolean _tmp5_ = FALSE;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = exceptions;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_locked_calculate_pixbuf_dimensions (self, &_tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp3_;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp4_;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp5_;
#line 23287 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23294 "Photo.c"
			}
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_image) {
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_image = _vala_scaled_image;
#line 23300 "Photo.c"
			}
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_to_viewport) {
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23306 "Photo.c"
			}
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 23310 "Photo.c"
		}
		__finally378:
		{
			PhotoRow* _tmp7_ = NULL;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23319 "Photo.c"
		}
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 23327 "Photo.c"
	}
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 23333 "Photo.c"
	}
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3045 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23339 "Photo.c"
	}
}


static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport) {
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	Dimensions raw = {0};
	Dimensions _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	Orientation orientation = 0;
	Orientation _tmp4_ = 0;
	PhotoException _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp53_ = FALSE;
	Dimensions _tmp54_ = {0};
	gint _tmp55_ = 0;
	Dimensions _tmp56_ = {0};
	gint _tmp57_ = 0;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
#line 3055 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3055 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 3057 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 3057 "/home/jens/Source/shotwell/src/Photo.vala"
	raw = _tmp0_;
#line 3059 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = scaling_is_unscaled (scaling);
#line 3059 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 23375 "Photo.c"
		Dimensions _tmp2_ = {0};
		Dimensions _tmp3_ = {0};
#line 3060 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = raw;
#line 3060 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp2_;
#line 3061 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = raw;
#line 3061 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp3_;
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 23392 "Photo.c"
		}
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23398 "Photo.c"
		}
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23402 "Photo.c"
	}
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_get_orientation (self);
#line 3066 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = _tmp4_;
#line 3071 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_image, 0, 0);
#line 3072 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_to_viewport, 0, 0);
#line 3074 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = exceptions;
#line 3074 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_exception_allows (_tmp5_, PHOTO_EXCEPTION_CROP);
#line 3074 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_) {
#line 23418 "Photo.c"
		Box crop = {0};
		Box _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = photo_get_raw_crop (self, &_tmp7_);
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp7_;
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp8_) {
#line 23428 "Photo.c"
			Dimensions rotated_raw = {0};
			Dimensions _tmp9_ = {0};
			PhotoException _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
			Box scaled_crop = {0};
			Dimensions _tmp19_ = {0};
			Dimensions _tmp20_ = {0};
			Box _tmp21_ = {0};
			Dimensions _tmp22_ = {0};
			gboolean _tmp23_ = FALSE;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			Dimensions _tmp30_ = {0};
			Dimensions _tmp31_ = {0};
			Dimensions _tmp32_ = {0};
			PhotoException _tmp33_ = 0;
			gboolean _tmp34_ = FALSE;
#line 3079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = raw;
#line 3079 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp9_;
#line 3080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = exceptions;
#line 3080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = photo_exception_allows (_tmp10_, PHOTO_EXCEPTION_ORIENTATION);
#line 3080 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 23456 "Photo.c"
				Orientation _tmp12_ = 0;
				Dimensions _tmp13_ = {0};
				Box _tmp14_ = {0};
				Box _tmp15_ = {0};
				Orientation _tmp16_ = 0;
				Dimensions _tmp17_ = {0};
				Dimensions _tmp18_ = {0};
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = orientation;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = raw;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = crop;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_box (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
				crop = _tmp15_;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = orientation;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = raw;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_dimensions (_tmp16_, &_tmp17_, &_tmp18_);
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
				rotated_raw = _tmp18_;
#line 23482 "Photo.c"
			}
#line 3086 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp19_);
#line 3086 "/home/jens/Source/shotwell/src/Photo.vala"
			scaling_get_scaled_dimensions (scaling, &_tmp19_, &_tmp20_);
#line 3086 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_scaled (&crop, &_tmp20_, &_tmp21_);
#line 3086 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_crop = _tmp21_;
#line 3089 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp22_);
#line 3089 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp22_;
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = box_get_width (&crop);
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = box_get_width (&scaled_crop);
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp24_ <= _tmp25_) {
#line 23502 "Photo.c"
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
#line 3093 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = box_get_height (&crop);
#line 3093 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = box_get_height (&scaled_crop);
#line 3093 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = _tmp26_ <= _tmp27_;
#line 23511 "Photo.c"
			} else {
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = FALSE;
#line 23515 "Photo.c"
			}
#line 3092 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp23_) {
#line 23519 "Photo.c"
				Dimensions _tmp28_ = {0};
				Dimensions _tmp29_ = {0};
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = raw;
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp28_;
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
				box_get_dimensions (&crop, &_tmp29_);
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_to_viewport = _tmp29_;
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_image) {
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_image = _vala_scaled_image;
#line 23536 "Photo.c"
				}
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_to_viewport) {
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23542 "Photo.c"
				}
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 23546 "Photo.c"
			}
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp30_);
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp31_);
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
			dimensions_get_scaled_similar (&rotated_raw, &_tmp30_, &_tmp31_, &_tmp32_);
#line 3102 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp32_;
#line 3106 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = exceptions;
#line 3106 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = photo_exception_allows (_tmp33_, PHOTO_EXCEPTION_ORIENTATION);
#line 3106 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp34_) {
#line 23562 "Photo.c"
				Orientation _tmp35_ = 0;
				Dimensions _tmp36_ = {0};
				Dimensions _tmp37_ = {0};
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = orientation;
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = _vala_scaled_image;
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_derotate_dimensions (_tmp35_, &_tmp36_, &_tmp37_);
#line 3107 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp37_;
#line 23574 "Photo.c"
			}
		}
	}
#line 3112 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = dimensions_has_area (&_vala_scaled_image);
#line 3112 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp38_) {
#line 23582 "Photo.c"
		Dimensions rotated_raw = {0};
		Dimensions _tmp39_ = {0};
		PhotoException _tmp40_ = 0;
		gboolean _tmp41_ = FALSE;
		Dimensions _tmp45_ = {0};
		Dimensions _tmp46_ = {0};
		Dimensions _tmp47_ = {0};
		PhotoException _tmp48_ = 0;
		gboolean _tmp49_ = FALSE;
#line 3114 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = raw;
#line 3114 "/home/jens/Source/shotwell/src/Photo.vala"
		rotated_raw = _tmp39_;
#line 3115 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = exceptions;
#line 3115 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = photo_exception_allows (_tmp40_, PHOTO_EXCEPTION_ORIENTATION);
#line 3115 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp41_) {
#line 23602 "Photo.c"
			Orientation _tmp42_ = 0;
			Dimensions _tmp43_ = {0};
			Dimensions _tmp44_ = {0};
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = orientation;
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = raw;
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_rotate_dimensions (_tmp42_, &_tmp43_, &_tmp44_);
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp44_;
#line 23614 "Photo.c"
		}
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = rotated_raw;
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
		scaling_get_scaled_dimensions (scaling, &_tmp45_, &_tmp46_);
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp46_;
#line 3119 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = _vala_scaled_image;
#line 3119 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp47_;
#line 3122 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = exceptions;
#line 3122 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = photo_exception_allows (_tmp48_, PHOTO_EXCEPTION_ORIENTATION);
#line 3122 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp49_) {
#line 23632 "Photo.c"
			Orientation _tmp50_ = 0;
			Dimensions _tmp51_ = {0};
			Dimensions _tmp52_ = {0};
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = orientation;
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp51_ = _vala_scaled_image;
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_derotate_dimensions (_tmp50_, &_tmp51_, &_tmp52_);
#line 3123 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp52_;
#line 23644 "Photo.c"
		}
	}
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp54_ = _vala_scaled_image;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp55_ = _tmp54_.width;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp56_ = raw;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp57_ = _tmp56_.width;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp55_ >= _tmp57_) {
#line 23657 "Photo.c"
		Dimensions _tmp58_ = {0};
		gint _tmp59_ = 0;
		Dimensions _tmp60_ = {0};
		gint _tmp61_ = 0;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = _vala_scaled_image;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_.height;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = raw;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = _tmp60_.height;
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = _tmp59_ >= _tmp61_;
#line 23672 "Photo.c"
	} else {
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = FALSE;
#line 23676 "Photo.c"
	}
#line 3127 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp53_) {
#line 23680 "Photo.c"
		Dimensions _tmp62_ = {0};
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = raw;
#line 3128 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp62_;
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 23692 "Photo.c"
		}
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23698 "Photo.c"
		}
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23702 "Photo.c"
	}
#line 3133 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp63_ = dimensions_has_area (&_vala_scaled_image);
#line 3133 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp63_, "scaled_image.has_area()");
#line 3134 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp64_ = dimensions_has_area (&_vala_scaled_to_viewport);
#line 3134 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp64_, "scaled_to_viewport.has_area()");
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 23718 "Photo.c"
	}
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23724 "Photo.c"
	}
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23728 "Photo.c"
}


static GdkPixbuf* photo_load_raw_pixbuf (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error) {
	GdkPixbuf* result = NULL;
	PhotoFileReader* loader = NULL;
	BackingFetchMode _tmp0_ = 0;
	PhotoFileReader* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	gboolean is_scaled = FALSE;
	Scaling _tmp7_ = {0};
	PhotoException _tmp8_ = 0;
	Dimensions _tmp9_ = {0};
	Dimensions _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	PhotoFileReader* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	Dimensions _tmp19_ = {0};
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	Dimensions _tmp22_ = {0};
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 3142 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3142 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3145 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = fetch_mode;
#line 3145 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_backing_reader (self, _tmp0_);
#line 3145 "/home/jens/Source/shotwell/src/Photo.vala"
	loader = _tmp1_;
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = scaling_is_unscaled (scaling);
#line 3148 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 23770 "Photo.c"
		GdkPixbuf* _tmp3_ = NULL;
		PhotoFileReader* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = loader;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_reader_unscaled_read (_tmp4_, &_inner_error_);
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp5_;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 23789 "Photo.c"
		}
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp3_;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = NULL;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp6_;
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3153 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23803 "Photo.c"
	}
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = *scaling;
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = exceptions;
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_calculate_pixbuf_dimensions (self, &_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_image = _tmp9_;
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_to_viewport = _tmp10_;
#line 3158 "/home/jens/Source/shotwell/src/Photo.vala"
	is_scaled = _tmp11_;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = is_scaled;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp12_) {
#line 23821 "Photo.c"
		GdkPixbuf* _tmp13_ = NULL;
		PhotoFileReader* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = loader;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = photo_file_reader_unscaled_read (_tmp14_, &_inner_error_);
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp15_;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 23840 "Photo.c"
		}
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp13_;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = NULL;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp16_;
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp13_);
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3165 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23854 "Photo.c"
	}
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = loader;
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp18_);
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = scaled_image;
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = photo_file_reader_scaled_read (_tmp17_, &_tmp18_, &_tmp19_, &_inner_error_);
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp20_;
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3168 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 23874 "Photo.c"
	}
#line 3176 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = pixbuf;
#line 3176 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_for_pixbuf (_tmp21_, &_tmp22_);
#line 3176 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = dimensions_approx_equals (&scaled_image, &_tmp22_, PHOTO_SCALING_FUDGE);
#line 3176 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp23_, "scaled_image.approx_equals(Dimensions.for_pixbuf(pixbuf), SCALING_FUDGE)");
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (loader);
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23890 "Photo.c"
}


GdkPixbuf* photo_get_master_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 3183 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3183 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = rotate;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_get_untransformed_pixbuf (self, &_tmp1_, _tmp2_, BACKING_FETCH_MODE_MASTER, &_inner_error_);
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 23920 "Photo.c"
	}
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3184 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23932 "Photo.c"
}


GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 3188 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3188 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = rotate;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_get_untransformed_pixbuf (self, &_tmp1_, _tmp2_, BACKING_FETCH_MODE_UNMODIFIED, &_inner_error_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 23962 "Photo.c"
	}
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3189 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23974 "Photo.c"
}


static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, BackingFetchMode fetch_mode, GError** error) {
	GdkPixbuf* result = NULL;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	Orientation original_orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp6_ = {0};
	BackingFetchMode _tmp7_ = 0;
	GdkPixbuf* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
#line 3193 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3193 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 23993 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 24000 "Photo.c"
		{
			Scaling _tmp1_ = {0};
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			Orientation _tmp4_ = 0;
#line 3208 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3208 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_calculate_pixbuf_dimensions (self, &_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_, &_tmp3_);
#line 3208 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_image = _tmp2_;
#line 3208 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_to_viewport = _tmp3_;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_original_orientation (self);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			original_orientation = _tmp4_;
#line 24018 "Photo.c"
		}
		__finally379:
		{
			PhotoRow* _tmp5_ = NULL;
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 24027 "Photo.c"
		}
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3207 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 24035 "Photo.c"
		}
	}
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = *scaling;
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = fetch_mode;
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_load_raw_pixbuf (self, &_tmp6_, PHOTO_EXCEPTION_NONE, _tmp7_, &_inner_error_);
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp8_;
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3214 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24052 "Photo.c"
	}
#line 3220 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = rotate;
#line 3220 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp9_) {
#line 24058 "Photo.c"
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_ = NULL;
#line 3221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = pixbuf;
#line 3221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = orientation_rotate_pixbuf (original_orientation, _tmp10_);
#line 3221 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (pixbuf);
#line 3221 "/home/jens/Source/shotwell/src/Photo.vala"
		pixbuf = _tmp11_;
#line 24069 "Photo.c"
	}
#line 3230 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3230 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24075 "Photo.c"
}


static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error) {
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 3233 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 3233 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_BASELINE, &_inner_error_);
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24103 "Photo.c"
	}
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3234 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24115 "Photo.c"
}


/**
     * One-stop shopping for the source pixbuf cache.
     *
     * The source pixbuf cache holds untransformed, unscaled (full-sized) pixbufs of Photo objects.
     * These can be rather large and shouldn't be held in memory for too long, nor should many be
     * allowed to stack up.
     *
     * If locate is non-null, a source pixbuf is returned for the Photo.  If keep is true, the
     * pixbuf is stored in the cache.  (Thus, passing a Photo w/ keep == false will drop the cached
     * pixbuf.)  If Photo is non-null but keep is false, null is returned.
     *
     * Whether locate is null or not, the cache is walked in its entirety, dropping expired pixbufs
     * and dropping excessive pixbufs from the LRU.  Locating a Photo "touches" the pixbuf, i.e.
     * it moves to the head of the LRU.
     */
static gpointer _photo_cached_pixbuf_ref0 (gpointer self) {
#line 3269 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_cached_pixbuf_ref (self) : NULL;
#line 24137 "Photo.c"
}


static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self) {
	gboolean result;
	result = photo_trim_source_pixbuf_cache ();
#line 3321 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24146 "Photo.c"
}


static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate, gboolean keep, GError** error) {
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
#line 3252 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((locate == NULL) || IS_PHOTO (locate), NULL);
#line 24155 "Photo.c"
	{
		GeeLinkedList* _tmp0_ = NULL;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_source_pixbuf_cache;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&__lock_photo_source_pixbuf_cache);
#line 24162 "Photo.c"
		{
			PhotoCachedPixbuf* found = NULL;
			gdouble min_elapsed = 0.0;
			gint count = 0;
			GeeIterator* iter = NULL;
			GeeLinkedList* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			PhotoCachedPixbuf* _tmp31_ = NULL;
			gboolean _tmp43_ = FALSE;
			PhotoCachedPixbuf* _tmp44_ = NULL;
			guint _tmp59_ = 0U;
			GeeLinkedList* _tmp61_ = NULL;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			GdkPixbuf* _tmp69_ = NULL;
			PhotoCachedPixbuf* _tmp70_ = NULL;
			GdkPixbuf* _tmp73_ = NULL;
#line 3254 "/home/jens/Source/shotwell/src/Photo.vala"
			found = NULL;
#line 3258 "/home/jens/Source/shotwell/src/Photo.vala"
			min_elapsed = DBL_MAX;
#line 3259 "/home/jens/Source/shotwell/src/Photo.vala"
			count = 0;
#line 3260 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_source_pixbuf_cache;
#line 3260 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3260 "/home/jens/Source/shotwell/src/Photo.vala"
			iter = _tmp2_;
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 24196 "Photo.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				PhotoCachedPixbuf* cached_pixbuf = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				gdouble elapsed = 0.0;
				PhotoCachedPixbuf* _tmp7_ = NULL;
				GTimer* _tmp8_ = NULL;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gboolean _tmp11_ = FALSE;
				Photo* _tmp12_ = NULL;
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = iter;
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp4_) {
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 24217 "Photo.c"
				}
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = iter;
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
				cached_pixbuf = (PhotoCachedPixbuf*) _tmp6_;
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = cached_pixbuf;
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_->last_touched;
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = g_timer_elapsed (_tmp8_, NULL);
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = trunc (_tmp9_);
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				elapsed = _tmp10_ + 1;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = locate;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_ != NULL) {
#line 24239 "Photo.c"
					PhotoCachedPixbuf* _tmp13_ = NULL;
					Photo* _tmp14_ = NULL;
					Photo* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = cached_pixbuf;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = _tmp13_->photo;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = locate;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_SOURCE, DataSource));
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = _tmp16_;
#line 24254 "Photo.c"
				} else {
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = FALSE;
#line 24258 "Photo.c"
				}
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_) {
#line 24262 "Photo.c"
					GeeIterator* _tmp17_ = NULL;
					PhotoCachedPixbuf* _tmp18_ = NULL;
					PhotoCachedPixbuf* _tmp19_ = NULL;
					gint _tmp20_ = 0;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = iter;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_iterator_remove (_tmp17_);
#line 3269 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = cached_pixbuf;
#line 3269 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = _photo_cached_pixbuf_ref0 (_tmp18_);
#line 3269 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 3269 "/home/jens/Source/shotwell/src/Photo.vala"
					found = _tmp19_;
#line 3272 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = count;
#line 3272 "/home/jens/Source/shotwell/src/Photo.vala"
					count = _tmp20_ + 1;
#line 24283 "Photo.c"
				} else {
					gdouble _tmp21_ = 0.0;
#line 3273 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = elapsed;
#line 3273 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp21_ >= ((gdouble) PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC)) {
#line 24290 "Photo.c"
						GeeIterator* _tmp22_ = NULL;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp22_ = iter;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
						gee_iterator_remove (_tmp22_);
#line 24296 "Photo.c"
					} else {
						gint _tmp23_ = 0;
#line 3275 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = count;
#line 3275 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp23_ >= PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT) {
#line 24303 "Photo.c"
							GeeIterator* _tmp24_ = NULL;
#line 3276 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = iter;
#line 3276 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_iterator_remove (_tmp24_);
#line 24309 "Photo.c"
						} else {
							gdouble _tmp25_ = 0.0;
							gdouble _tmp26_ = 0.0;
							gdouble _tmp27_ = 0.0;
							gint _tmp28_ = 0;
#line 3280 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = elapsed;
#line 3280 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = min_elapsed;
#line 3280 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = MIN (_tmp25_, _tmp26_);
#line 3280 "/home/jens/Source/shotwell/src/Photo.vala"
							min_elapsed = _tmp27_;
#line 3281 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp28_ = count;
#line 3281 "/home/jens/Source/shotwell/src/Photo.vala"
							count = _tmp28_ + 1;
#line 24327 "Photo.c"
						}
					}
				}
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (cached_pixbuf);
#line 24333 "Photo.c"
			}
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = found;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp31_ == NULL) {
#line 24339 "Photo.c"
				Photo* _tmp32_ = NULL;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = locate;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp32_ != NULL;
#line 24345 "Photo.c"
			} else {
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = FALSE;
#line 24349 "Photo.c"
			}
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp30_) {
#line 24353 "Photo.c"
				gboolean _tmp33_ = FALSE;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = keep;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = _tmp33_;
#line 24359 "Photo.c"
			} else {
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = FALSE;
#line 24363 "Photo.c"
			}
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp29_) {
#line 24367 "Photo.c"
				GdkPixbuf* _tmp34_ = NULL;
				Photo* _tmp35_ = NULL;
				Scaling _tmp36_ = {0};
				GdkPixbuf* _tmp37_ = NULL;
				Photo* _tmp38_ = NULL;
				PhotoCachedPixbuf* _tmp39_ = NULL;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = locate;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				scaling_for_original (&_tmp36_);
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = photo_load_raw_pixbuf (_tmp35_, &_tmp36_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_SOURCE, &_inner_error_);
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp37_;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (iter);
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 24388 "Photo.c"
					goto __finally380;
				}
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = locate;
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = photo_cached_pixbuf_new (_tmp38_, _tmp34_);
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (found);
#line 3287 "/home/jens/Source/shotwell/src/Photo.vala"
				found = _tmp39_;
#line 3286 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp34_);
#line 24401 "Photo.c"
			} else {
				PhotoCachedPixbuf* _tmp40_ = NULL;
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = found;
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp40_ != NULL) {
#line 24408 "Photo.c"
					PhotoCachedPixbuf* _tmp41_ = NULL;
					GTimer* _tmp42_ = NULL;
#line 3291 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp41_ = found;
#line 3291 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp42_ = _tmp41_->last_touched;
#line 3291 "/home/jens/Source/shotwell/src/Photo.vala"
					g_timer_start (_tmp42_);
#line 24417 "Photo.c"
				}
			}
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp44_ = found;
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp44_ != NULL) {
#line 24424 "Photo.c"
				gboolean _tmp45_ = FALSE;
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = keep;
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = _tmp45_;
#line 24430 "Photo.c"
			} else {
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = FALSE;
#line 24434 "Photo.c"
			}
#line 3295 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp43_) {
#line 24438 "Photo.c"
				GeeLinkedList* _tmp46_ = NULL;
				PhotoCachedPixbuf* _tmp47_ = NULL;
				PhotoCachedPixbuf* _tmp48_ = NULL;
				GTimer* _tmp49_ = NULL;
				gdouble _tmp50_ = 0.0;
				gdouble _tmp51_ = 0.0;
				gdouble _tmp52_ = 0.0;
#line 3296 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = photo_source_pixbuf_cache;
#line 3296 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = found;
#line 3296 "/home/jens/Source/shotwell/src/Photo.vala"
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp47_);
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = found;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp49_ = _tmp48_->last_touched;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp50_ = g_timer_elapsed (_tmp49_, NULL);
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp51_ = min_elapsed;
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp52_ = MIN (_tmp50_, _tmp51_);
#line 3301 "/home/jens/Source/shotwell/src/Photo.vala"
				min_elapsed = _tmp52_;
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 24466 "Photo.c"
					GeeLinkedList* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					GeeLinkedList* _tmp56_ = NULL;
					gpointer _tmp57_ = NULL;
					PhotoCachedPixbuf* _tmp58_ = NULL;
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp53_ = photo_source_pixbuf_cache;
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp54_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp55_ = _tmp54_;
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!(_tmp55_ > PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT)) {
#line 3305 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 24483 "Photo.c"
					}
#line 3306 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56_ = photo_source_pixbuf_cache;
#line 3306 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp57_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_DEQUE, GeeDeque));
#line 3306 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp58_ = (PhotoCachedPixbuf*) _tmp57_;
#line 3306 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (_tmp58_);
#line 24493 "Photo.c"
				}
			}
#line 3310 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = photo_discard_source_id;
#line 3310 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp59_ != ((guint) 0)) {
#line 24500 "Photo.c"
				guint _tmp60_ = 0U;
#line 3311 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp60_ = photo_discard_source_id;
#line 3311 "/home/jens/Source/shotwell/src/Photo.vala"
				g_source_remove (_tmp60_);
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = (guint) 0;
#line 24508 "Photo.c"
			}
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp61_ = photo_source_pixbuf_cache;
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp62_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection));
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp63_ = _tmp62_;
#line 3316 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp63_ > PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT) {
#line 24518 "Photo.c"
				gdouble _tmp64_ = 0.0;
				guint retry_sec = 0U;
				gdouble _tmp65_ = 0.0;
				gdouble _tmp66_ = 0.0;
				guint _tmp67_ = 0U;
				guint _tmp68_ = 0U;
#line 3317 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = min_elapsed;
#line 3317 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp64_ >= 0.0, "min_elapsed >= 0.0");
#line 3320 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp65_ = min_elapsed;
#line 3320 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp66_ = trunc (_tmp65_);
#line 3320 "/home/jens/Source/shotwell/src/Photo.vala"
				retry_sec = PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC - ((guint) _tmp66_);
#line 3321 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp67_ = retry_sec;
#line 3321 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp68_ = g_timeout_add_seconds_full (G_PRIORITY_LOW, _tmp67_, _photo_trim_source_pixbuf_cache_gsource_func, NULL, NULL);
#line 3321 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = _tmp68_;
#line 24541 "Photo.c"
			}
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp70_ = found;
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp70_ != NULL) {
#line 24547 "Photo.c"
				PhotoCachedPixbuf* _tmp71_ = NULL;
				GdkPixbuf* _tmp72_ = NULL;
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp71_ = found;
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp72_ = _tmp71_->pixbuf;
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = _tmp72_;
#line 24556 "Photo.c"
			} else {
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = NULL;
#line 24560 "Photo.c"
			}
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp73_ = _g_object_ref0 (_tmp69_);
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp73_;
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (iter);
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_cached_pixbuf_unref0 (found);
#line 24570 "Photo.c"
			{
				GeeLinkedList* _tmp74_ = NULL;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp74_ = photo_source_pixbuf_cache;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 24577 "Photo.c"
			}
#line 3324 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 24581 "Photo.c"
		}
		__finally380:
		{
			GeeLinkedList* _tmp75_ = NULL;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp75_ = photo_source_pixbuf_cache;
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 24590 "Photo.c"
		}
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3253 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24596 "Photo.c"
	}
}


static gboolean photo_trim_source_pixbuf_cache (void) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
#line 3330 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (NULL, FALSE, &_inner_error_);
#line 3330 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 3330 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3330 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24615 "Photo.c"
			goto __catch381_g_error;
		}
	}
	goto __finally381;
	__catch381_g_error:
	{
		GError* err = NULL;
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 24629 "Photo.c"
	}
	__finally381:
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3329 "/home/jens/Source/shotwell/src/Photo.vala"
		return FALSE;
#line 24640 "Photo.c"
	}
#line 3334 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 3334 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24646 "Photo.c"
}


/**
     * @brief Get a copy of what's in the cache.
     *
     * @return A copy of the Pixbuf with the image data from unmodified_precached.
     */
GdkPixbuf* photo_get_prefetched_copy (Photo* self, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 3342 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_run_source_pixbuf_cache (self, TRUE, &_inner_error_);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp1_;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24676 "Photo.c"
	}
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp0_;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp4_;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp3_);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3343 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24696 "Photo.c"
}


/**
     * @brief Discards the cached version of the unmodified image.
     */
void photo_discard_prefetched (Photo* self) {
	GError * _inner_error_ = NULL;
#line 3349 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 24707 "Photo.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (self, FALSE, &_inner_error_);
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24719 "Photo.c"
			goto __catch382_g_error;
		}
	}
	goto __finally382;
	__catch382_g_error:
	{
		GError* err = NULL;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 24733 "Photo.c"
	}
	__finally382:
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3350 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 24744 "Photo.c"
	}
}


/**
     * @brief Returns a fully transformed and scaled pixbuf.  Transformations may be excluded via
     * the mask. If the image is smaller than the scaling, it will be returned in its actual size.
     * The caller is responsible for scaling thereafter.
     *
     * @param scaling A scaling object that describes the size the output pixbuf should be.
     * @param exceptions The parts of the pipeline that should be skipped; defaults to NONE if
     *      left unset.
     * @param fetch_mode The fetch mode; if left unset, defaults to BASELINE so that
     *      we get the image exactly as it is in the file.
     */
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean is_scaled = FALSE;
	gboolean is_cropped = FALSE;
	gboolean is_straightened = FALSE;
	Dimensions scaled_to_viewport = {0};
	Dimensions original = {0};
	Dimensions scaled = {0};
	EditingToolsRedeyeInstance* redeye_instances = NULL;
	gint redeye_instances_length1 = 0;
	gint _redeye_instances_size_ = 0;
	Box crop = {0};
	gdouble straightening_angle = 0.0;
	PixelTransformer* transformer = NULL;
	Orientation orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp33_ = NULL;
	PhotoException _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	PhotoException _tmp40_ = 0;
	gboolean _tmp41_ = FALSE;
	PhotoException _tmp46_ = 0;
	gboolean _tmp47_ = FALSE;
	PhotoException _tmp85_ = 0;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp89_ = FALSE;
	PhotoException _tmp96_ = 0;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp101_ = FALSE;
	gboolean _tmp102_ = FALSE;
	GError * _inn