/* CheckerboardLayout.c generated by valac 0.34.4, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecCheckerboardItemText ParamSpecCheckerboardItemText;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define TYPE_CHECKERBOARD_LAYOUT (checkerboard_layout_get_type ())
#define CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout))
#define CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))
#define IS_CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_LAYOUT))
#define IS_CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_LAYOUT))
#define CHECKERBOARD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))

typedef struct _CheckerboardLayout CheckerboardLayout;
typedef struct _CheckerboardLayoutClass CheckerboardLayoutClass;
typedef struct _CheckerboardLayoutPrivate CheckerboardLayoutPrivate;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_COMPASS_POINT (compass_point_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

struct _CheckerboardItemTextPrivate {
	gchar* text;
	gboolean marked_up;
	PangoAlignment alignment;
	PangoLayout* layout;
	gboolean single_line;
	gint height;
};

struct _ParamSpecCheckerboardItemText {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	gboolean title_visible;
	CheckerboardItemText* comment;
	gboolean comment_visible;
	CheckerboardItemText* subtitle;
	gboolean subtitle_visible;
	gboolean is_cursor;
	PangoAlignment tag_alignment;
	GeeList* user_visible_tag_list;
	GeeCollection* tags;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gint horizontal_trinket_offset;
	gboolean _has_tags;
};

struct _CheckerboardLayout {
	GtkDrawingArea parent_instance;
	CheckerboardLayoutPrivate * priv;
};

struct _CheckerboardLayoutClass {
	GtkDrawingAreaClass parent_class;
};

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	gchar* message;
	GdkRGBA selected_color;
	GdkRGBA unselected_color;
	GdkRGBA border_color;
	GdkRGBA bg_color;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	CheckerboardItem* cursor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};


static gpointer checkerboard_item_text_parent_class = NULL;
static gint checkerboard_item_text_one_line_height;
static gint checkerboard_item_text_one_line_height = 0;
static gpointer checkerboard_item_parent_class = NULL;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

gpointer checkerboard_item_text_ref (gpointer instance);
void checkerboard_item_text_unref (gpointer instance);
GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_checkerboard_item_text (GValue* value, gpointer v_object);
void value_take_checkerboard_item_text (GValue* value, gpointer v_object);
gpointer value_get_checkerboard_item_text (const GValue* value);
GType checkerboard_item_text_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_TEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextPrivate))
enum  {
	CHECKERBOARD_ITEM_TEXT_DUMMY_PROPERTY
};
CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up);
CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up);
static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self);
gboolean string_contains_char (const gchar* haystack, gunichar needle);
gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
gint checkerboard_item_text_get_height (CheckerboardItemText* self);
static void checkerboard_item_text_update_height (CheckerboardItemText* self);
PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width);
static void checkerboard_item_text_create_pango (CheckerboardItemText* self);
void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static void checkerboard_item_text_finalize (CheckerboardItemText* obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType tag_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM, CheckerboardItemPrivate))
enum  {
	CHECKERBOARD_ITEM_DUMMY_PROPERTY,
	CHECKERBOARD_ITEM_HAS_TAGS
};
void dimensions_init (Dimensions *self, gint width, gint height);
#define CHECKERBOARD_ITEM_PROP_SHOW_TITLES "show-titles"
#define CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS "show-comments"
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define CHECKERBOARD_ITEM_FRAME_WIDTH 8
#define CHECKERBOARD_ITEM_LABEL_PADDING 4
#define CHECKERBOARD_ITEM_BORDER_WIDTH 1
#define CHECKERBOARD_ITEM_SHADOW_RADIUS 4
#define CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA 0.5f
#define CHECKERBOARD_ITEM_TRINKET_SCALE 12
#define CHECKERBOARD_ITEM_TRINKET_PADDING 1
#define CHECKERBOARD_ITEM_BRIGHTEN_SHIFT 0x18
GType thumbnail_source_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
ThumbnailView* thumbnail_view_construct (GType object_type, ThumbnailSource* source);
static gchar* checkerboard_item_real_get_name (DataObject* base);
gchar* data_object_get_name (DataObject* self);
gchar* checkerboard_item_get_title (CheckerboardItem* self);
gchar* checkerboard_item_get_comment (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason);
void data_view_notify_view_altered (DataView* self);
void checkerboard_item_clear_title (CheckerboardItem* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_tags (CheckerboardItem* self, GeeCollection* tags, PangoAlignment alignment);
static void checkerboard_item_set_has_tags (CheckerboardItem* self, gboolean value);
gboolean checkerboard_item_get_has_tags (CheckerboardItem* self);
GeeList* tag_make_user_visible_tag_list (GeeCollection* tags);
gchar* tag_make_tag_markup_string (GeeList* tags, gint highlight_index);
void checkerboard_item_clear_tags (CheckerboardItem* self);
void checkerboard_item_clear_subtitle (CheckerboardItem* self);
void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self, gint index);
Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self, gint index);
PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self);
void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self, GdkRectangle* result);
gchar* checkerboard_item_get_subtitle (CheckerboardItem* self);
void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor);
gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection);
void data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def, GValue* result);
static void _vala_GValue_free (GValue* self);
gboolean dimensions_has_area (Dimensions *self);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
void checkerboard_item_exposed (CheckerboardItem* self);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
void checkerboard_item_unexposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
gint checkerboard_item_get_max_width (gint scale);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
void data_view_notify_geometry_altered (DataView* self);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result);
void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2);
void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color);
gboolean data_view_is_selected (DataView* self);
gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self);
void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset);
void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row);
gint checkerboard_item_get_column (CheckerboardItem* self);
gint checkerboard_item_get_row (CheckerboardItem* self);
void checkerboard_item_brighten (CheckerboardItem* self);
void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha);
void checkerboard_item_unbrighten (CheckerboardItem* self);
static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip);
gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip);
gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect);
static void checkerboard_item_finalize (GObject* obj);
static void _vala_checkerboard_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_checkerboard_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType checkerboard_layout_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CHECKERBOARD_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutPrivate))
enum  {
	CHECKERBOARD_LAYOUT_DUMMY_PROPERTY
};
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self);
#define CHECKERBOARD_LAYOUT_TOP_PADDING 16
#define CHECKERBOARD_LAYOUT_BOTTOM_PADDING 16
#define CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_SELECTION_ALPHA 0.40
#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
CheckerboardLayout* checkerboard_layout_new (ViewCollection* view);
CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view);
void checkerboard_layout_clear_drag_select (CheckerboardLayout* self);
void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result);
void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale);
gint checkerboard_layout_get_scale (CheckerboardLayout* self);
void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper);
void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item);
gboolean data_collection_contains (DataCollection* self, DataObject* object);
CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller);
void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text);
void checkerboard_layout_unset_message (CheckerboardLayout* self);
void get_adjustment_page (GtkAdjustment* hadj, GtkAdjustment* vadj, GdkRectangle* result);
void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller);
CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd);
gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list, gint pos);
#define TAG_TAG_LIST_SEPARATOR_STRING ", "
static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y);
gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y, GdkModifierType mask);
gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self);
gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self, CheckerboardItem* item, gdouble xd, gdouble yd, GdkModifierType mask);
GType library_window_get_type (void) G_GNUC_CONST;
LibraryWindow* library_window_get_app (void);
void library_window_switch_to_tag (LibraryWindow* self, Tag* tag);
GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self);
GType compass_point_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point);
gint data_collection_get_count (DataCollection* self);
CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row);
DataView* view_collection_get_last (ViewCollection* self);
void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y);
void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result);
void box_get_rectangle (Box *self, GdkRectangle* result);
GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller);
void data_collection_freeze_notifications (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
gboolean data_view_is_visible (DataView* self);
DataObject* data_collection_get_at (DataCollection* self, gint index);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row);
static void checkerboard_layout_real_map (GtkWidget* base);
static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus);
void config_facade_get_selected_color (ConfigFacade* self, gboolean in_focus, GdkRGBA* result);
void config_facade_get_unselected_color (ConfigFacade* self, GdkRGBA* result);
void config_facade_get_border_color (ConfigFacade* self, GdkRGBA* result);
static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event);
GeeList* view_collection_get_selected (ViewCollection* self);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event);
enum  {
	CHECKERBOARD_LAYOUT_LAYOUT_ROW_DUMMY_PROPERTY
};
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow* obj);
static void checkerboard_layout_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up) {
	CheckerboardItemText* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PangoAlignment _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItemText*) g_type_create_instance (object_type);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->text = _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = marked_up;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->marked_up = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->alignment = _tmp3_;
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_item_text_is_single_line (self);
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = _tmp4_;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 754 "CheckerboardLayout.c"
}


CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up) {
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_item_text_construct (TYPE_CHECKERBOARD_ITEM_TEXT, text, alignment, marked_up);
#line 761 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 28 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = string_contains_char (_tmp0_, (gunichar) '\n');
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = !_tmp1_;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 779 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 32 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->marked_up;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 794 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == _tmp3_) {
#line 814 "CheckerboardLayout.c"
		PangoAlignment _tmp4_ = 0;
		PangoAlignment _tmp5_ = 0;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp4_ == _tmp5_;
#line 823 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 827 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 831 "CheckerboardLayout.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
#line 840 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 844 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 850 "CheckerboardLayout.c"
}


gchar* checkerboard_item_text_get_text (CheckerboardItemText* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 868 "CheckerboardLayout.c"
}


gint checkerboard_item_text_get_height (CheckerboardItemText* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 44 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), 0);
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->height;
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 0) {
#line 46 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_update_height (self);
#line 884 "CheckerboardLayout.c"
	}
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->height;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 892 "CheckerboardLayout.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? g_object_ref (self) : NULL;
#line 899 "CheckerboardLayout.c"
}


PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width) {
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	PangoLayout* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->layout;
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 53 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 917 "CheckerboardLayout.c"
	}
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = max_width;
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ > 0) {
#line 923 "CheckerboardLayout.c"
		PangoLayout* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->layout;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = max_width;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_width (_tmp2_, _tmp3_ * PANGO_SCALE);
#line 932 "CheckerboardLayout.c"
	}
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->layout;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp5_;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 942 "CheckerboardLayout.c"
}


void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self) {
#line 61 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 953 "CheckerboardLayout.c"
}


static void checkerboard_item_text_update_height (CheckerboardItemText* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 65 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_one_line_height;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != 0) {
#line 966 "CheckerboardLayout.c"
		gboolean _tmp2_ = FALSE;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->single_line;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_;
#line 972 "CheckerboardLayout.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 976 "CheckerboardLayout.c"
	}
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 980 "CheckerboardLayout.c"
		gint _tmp3_ = 0;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_one_line_height;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp3_;
#line 986 "CheckerboardLayout.c"
	} else {
#line 69 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 990 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_create_pango (CheckerboardItemText* self) {
	AppWindow* _tmp0_ = NULL;
	AppWindow* _tmp1_ = NULL;
	PangoLayout* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PangoLayout* _tmp8_ = NULL;
	PangoLayout* _tmp9_ = NULL;
	PangoAlignment _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
#line 72 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = app_window_get_instance ();
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), NULL);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->marked_up;
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 1023 "CheckerboardLayout.c"
		PangoLayout* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->layout;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->text;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_text (_tmp4_, _tmp5_, -1);
#line 1032 "CheckerboardLayout.c"
	} else {
		PangoLayout* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->layout;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->text;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_markup (_tmp6_, _tmp7_, -1);
#line 1042 "CheckerboardLayout.c"
	}
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->layout;
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->layout;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->alignment;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_alignment (_tmp9_, _tmp10_);
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_one_line_height;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != 0) {
#line 1058 "CheckerboardLayout.c"
		gboolean _tmp13_ = FALSE;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = self->priv->single_line;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp13_;
#line 1064 "CheckerboardLayout.c"
	} else {
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = FALSE;
#line 1068 "CheckerboardLayout.c"
	}
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 1072 "CheckerboardLayout.c"
		gint _tmp14_ = 0;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = checkerboard_item_text_one_line_height;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp14_;
#line 1078 "CheckerboardLayout.c"
	} else {
		gint width = 0;
		PangoLayout* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->layout;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp15_, &_tmp16_, &_tmp17_);
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		width = _tmp16_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp17_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_one_line_height;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp19_ == 0) {
#line 1098 "CheckerboardLayout.c"
			gboolean _tmp20_ = FALSE;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp20_ = self->priv->single_line;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = _tmp20_;
#line 1104 "CheckerboardLayout.c"
		} else {
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = FALSE;
#line 1108 "CheckerboardLayout.c"
		}
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp18_) {
#line 1112 "CheckerboardLayout.c"
			gint _tmp21_ = 0;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = self->priv->height;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_text_one_line_height = _tmp21_;
#line 1118 "CheckerboardLayout.c"
		}
	}
}


static void value_checkerboard_item_text_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 1127 "CheckerboardLayout.c"
}


static void value_checkerboard_item_text_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (value->data[0].v_pointer);
#line 1136 "CheckerboardLayout.c"
	}
}


static void value_checkerboard_item_text_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_item_text_ref (src_value->data[0].v_pointer);
#line 1146 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1150 "CheckerboardLayout.c"
	}
}


static gpointer value_checkerboard_item_text_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1158 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 1165 "CheckerboardLayout.c"
		CheckerboardItemText* object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1172 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1176 "CheckerboardLayout.c"
		}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_item_text_ref (object);
#line 1180 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1184 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1188 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardItemText** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1199 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 1205 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 1209 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1213 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1217 "CheckerboardLayout.c"
}


GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCheckerboardItemText* spec;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 1231 "CheckerboardLayout.c"
}


gpointer value_get_checkerboard_item_text (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1240 "CheckerboardLayout.c"
}


void value_set_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText* old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1260 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1264 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1270 "CheckerboardLayout.c"
	}
}


void value_take_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText* old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 1289 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1293 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1299 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_class_init (CheckerboardItemTextClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_text_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemTextClass *) klass)->finalize = checkerboard_item_text_finalize;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemTextPrivate));
#line 1311 "CheckerboardLayout.c"
}


static void checkerboard_item_text_instance_init (CheckerboardItemText * self) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_TEXT_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 14 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = TRUE;
#line 15 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->height = 0;
#line 17 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 1328 "CheckerboardLayout.c"
}


static void checkerboard_item_text_finalize (CheckerboardItemText* obj) {
	CheckerboardItemText * self;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 10 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 1342 "CheckerboardLayout.c"
}


GType checkerboard_item_text_get_type (void) {
	static volatile gsize checkerboard_item_text_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_text_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_checkerboard_item_text_init, value_checkerboard_item_text_free_value, value_checkerboard_item_text_copy_value, value_checkerboard_item_text_peek_pointer, "p", value_checkerboard_item_text_collect_value, "p", value_checkerboard_item_text_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItemText), 0, (GInstanceInitFunc) checkerboard_item_text_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_item_text_type_id;
		checkerboard_item_text_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardItemText", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_item_text_type_id__volatile, checkerboard_item_text_type_id);
	}
	return checkerboard_item_text_type_id__volatile;
}


gpointer checkerboard_item_text_ref (gpointer instance) {
	CheckerboardItemText* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 1367 "CheckerboardLayout.c"
}


void checkerboard_item_text_unref (gpointer instance) {
	CheckerboardItemText* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_ITEM_TEXT_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1380 "CheckerboardLayout.c"
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1394 "CheckerboardLayout.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1425 "CheckerboardLayout.c"
				goto __catch241_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 1434 "CheckerboardLayout.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1450 "CheckerboardLayout.c"
				goto __catch241_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 1461 "CheckerboardLayout.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1475 "CheckerboardLayout.c"
	}
	goto __finally241;
	__catch241_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1489 "CheckerboardLayout.c"
	}
	__finally241:
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 1500 "CheckerboardLayout.c"
	}
}


CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment) {
	CheckerboardItem * self = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	PangoAlignment _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	CheckerboardItemText* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = source;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, _tmp0_);
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *initial_pixbuf_dim;
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = title;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = marked_up;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_text_new (_tmp2_, _tmp3_, _tmp4_);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = comment;
#line 152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ != NULL) {
#line 1544 "CheckerboardLayout.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		PangoAlignment _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		CheckerboardItemText* _tmp12_ = NULL;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = comment;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = alignment;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = marked_up;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_item_text_unref0 (self->priv->comment);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment = _tmp12_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp9_);
#line 1569 "CheckerboardLayout.c"
	}
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 1573 "CheckerboardLayout.c"
}


static gchar* checkerboard_item_real_get_name (DataObject* base) {
	CheckerboardItem * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1588 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1599 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject));
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1608 "CheckerboardLayout.c"
	}
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1614 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_title (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1628 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1639 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1648 "CheckerboardLayout.c"
	}
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1654 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_comment (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1668 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1679 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1688 "CheckerboardLayout.c"
	}
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1694 "CheckerboardLayout.c"
}


void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	PangoAlignment _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1714 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1732 "CheckerboardLayout.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1736 "CheckerboardLayout.c"
	}
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1742 "CheckerboardLayout.c"
	}
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp10_;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->title_visible;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_title");
#line 184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1764 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_title (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1780 "CheckerboardLayout.c"
	}
#line 192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title_visible;
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_title");
#line 196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1794 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title_visible;
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1813 "CheckerboardLayout.c"
	}
#line 204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = _tmp2_;
#line 206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_title_visible");
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1823 "CheckerboardLayout.c"
}


void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	PangoAlignment _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	CheckerboardItemText* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1845 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1863 "CheckerboardLayout.c"
	} else {
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1867 "CheckerboardLayout.c"
	}
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1873 "CheckerboardLayout.c"
	}
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = alignment;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = marked_up;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = _tmp12_;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (_tmp9_);
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->comment_visible;
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_comment");
#line 219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1901 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_comment (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment;
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1917 "CheckerboardLayout.c"
	}
#line 227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment_visible;
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_comment");
#line 231 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1931 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment_visible;
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1950 "CheckerboardLayout.c"
	}
#line 239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = _tmp2_;
#line 241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_comment_visible");
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1960 "CheckerboardLayout.c"
}


void checkerboard_item_set_tags (CheckerboardItem* self, GeeCollection* tags, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	GeeCollection* _tmp1_ = NULL;
	PangoAlignment _tmp5_ = 0;
	gchar* text = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_ = NULL;
	const gchar* _tmp20_ = NULL;
	PangoAlignment _tmp21_ = 0;
	CheckerboardItemText* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((tags == NULL) || GEE_IS_COLLECTION (tags));
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = tags;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1984 "CheckerboardLayout.c"
		GeeCollection* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = tags;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = gee_collection_get_size (_tmp2_);
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ > 0;
#line 1996 "CheckerboardLayout.c"
	} else {
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2000 "CheckerboardLayout.c"
	}
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, _tmp0_);
#line 248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = alignment;
#line 248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = _tmp5_;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->_has_tags;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 2012 "CheckerboardLayout.c"
		GeeCollection* _tmp7_ = NULL;
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeList* _tmp10_ = NULL;
		GeeList* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tags;
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->tags);
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->tags = _tmp8_;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = tags;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = tag_make_user_visible_tag_list (_tmp9_);
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->user_visible_tag_list);
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->user_visible_tag_list = _tmp10_;
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->user_visible_tag_list;
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = tag_make_tag_markup_string (_tmp11_, -1);
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp12_;
#line 2043 "CheckerboardLayout.c"
	} else {
		gchar* _tmp13_ = NULL;
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = g_strdup ("<small>.</small>");
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp13_;
#line 2052 "CheckerboardLayout.c"
	}
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != NULL) {
#line 2058 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		PangoAlignment _tmp18_ = 0;
		gboolean _tmp19_ = FALSE;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->subtitle;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = text;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = alignment;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_is_set_to (_tmp16_, _tmp17_, TRUE, _tmp18_);
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp19_;
#line 2073 "CheckerboardLayout.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 2077 "CheckerboardLayout.c"
	}
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2085 "CheckerboardLayout.c"
	}
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = text;
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = alignment;
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = checkerboard_item_text_new (_tmp20_, _tmp21_, TRUE);
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp22_;
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = self->priv->subtitle_visible;
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp23_) {
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2105 "CheckerboardLayout.c"
	}
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2109 "CheckerboardLayout.c"
}


void checkerboard_item_clear_tags (CheckerboardItem* self) {
#line 268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_clear_subtitle (self);
#line 270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, FALSE);
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 2124 "CheckerboardLayout.c"
}


void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self, gint index) {
	GeeList* _tmp0_ = NULL;
	gchar* text = NULL;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	PangoAlignment _tmp5_ = 0;
	CheckerboardItemText* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->user_visible_tag_list;
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "user_visible_tag_list != null");
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->user_visible_tag_list;
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = index;
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = tag_make_tag_markup_string (_tmp1_, _tmp2_);
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text = _tmp3_;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = text;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->tag_alignment;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = checkerboard_item_text_new (_tmp4_, _tmp5_, TRUE);
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp6_;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->subtitle_visible;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_) {
#line 280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2168 "CheckerboardLayout.c"
	}
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2172 "CheckerboardLayout.c"
}


Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self, gint index) {
	Tag* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GeeList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gpointer _tmp7_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = index;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = index;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->user_visible_tag_list;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_val_if_fail ((_tmp0_ >= 0) && (_tmp1_ < _tmp4_), "index >= 0 && index < user_visible_tag_list.size", NULL);
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->user_visible_tag_list;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = index;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = gee_list_get (_tmp5_, _tmp6_);
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (Tag*) _tmp7_;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2210 "CheckerboardLayout.c"
}


PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self) {
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->_has_tags;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 2224 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		PangoLayout* _tmp3_ = NULL;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_pango_layout (_tmp2_, 0);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2235 "CheckerboardLayout.c"
	} else {
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = NULL;
#line 2241 "CheckerboardLayout.c"
	}
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2247 "CheckerboardLayout.c"
}


void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self, GdkRectangle* result) {
	CheckerboardItemText* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
#line 292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_->allocation;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = _tmp1_;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 2264 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_subtitle (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2278 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2289 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 2298 "CheckerboardLayout.c"
	}
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2304 "CheckerboardLayout.c"
}


void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	PangoAlignment _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2324 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 2342 "CheckerboardLayout.c"
	} else {
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2346 "CheckerboardLayout.c"
	}
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2352 "CheckerboardLayout.c"
	}
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp10_;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->subtitle_visible;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2374 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_subtitle (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 315 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2390 "CheckerboardLayout.c"
	}
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle_visible;
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_subtitle");
#line 321 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2404 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle_visible;
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2423 "CheckerboardLayout.c"
	}
#line 329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = _tmp2_;
#line 331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_subtitle_visible");
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2433 "CheckerboardLayout.c"
}


void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor) {
	gboolean _tmp0_ = FALSE;
#line 335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = is_cursor;
#line 336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = _tmp0_;
#line 2445 "CheckerboardLayout.c"
}


gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->is_cursor;
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2460 "CheckerboardLayout.c"
}


static void _vala_GValue_free (GValue* self) {
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_unset (self);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_free (self);
#line 2469 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection) {
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean comment_visible = FALSE;
	GValue* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	gboolean altered = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	DataCollection* _tmp21_ = NULL;
#line 343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_new0 (GValue, 1);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp0_, TRUE);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_, &_tmp1_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = g_value_get_boolean (&_tmp1_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp0_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_visible = _tmp2_;
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp3_, G_TYPE_BOOLEAN);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp3_, TRUE);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp3_, &_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = g_value_get_boolean (&_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp3_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_visible = _tmp5_;
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = g_new0 (GValue, 1);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp6_, G_TYPE_BOOLEAN);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp6_, FALSE);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp6_, &_tmp7_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = g_value_get_boolean (&_tmp7_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp6_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_visible = _tmp8_;
#line 348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	altered = FALSE;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->title_visible;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = title_visible;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != _tmp10_) {
#line 2551 "CheckerboardLayout.c"
		gboolean _tmp11_ = FALSE;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = title_visible;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->title_visible = _tmp11_;
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2559 "CheckerboardLayout.c"
	}
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->comment_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = comment_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != _tmp13_) {
#line 2567 "CheckerboardLayout.c"
		gboolean _tmp14_ = FALSE;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = comment_visible;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment_visible = _tmp14_;
#line 356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2575 "CheckerboardLayout.c"
	}
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = subtitle_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != _tmp16_) {
#line 2583 "CheckerboardLayout.c"
		gboolean _tmp17_ = FALSE;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = subtitle_visible;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->subtitle_visible = _tmp17_;
#line 361 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2591 "CheckerboardLayout.c"
	}
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = altered;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_) {
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = TRUE;
#line 2599 "CheckerboardLayout.c"
	} else {
		gboolean _tmp20_ = FALSE;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = dimensions_has_area (&self->requisition);
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = !_tmp20_;
#line 2606 "CheckerboardLayout.c"
	}
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_) {
#line 365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "notify_membership_changed");
#line 366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2614 "CheckerboardLayout.c"
	}
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = collection;
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 2620 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val) {
	CheckerboardItem * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	const gchar* _tmp7_ = NULL;
	GValue* _tmp8_ = NULL;
	GValue _tmp9_ = {0};
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (val != NULL);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2648 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp4_ = {0};
#line 375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = *val;
#line 375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp4_));
#line 376 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2658 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2664 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp5_ = {0};
#line 379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *val;
#line 379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp5_));
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2674 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2680 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp6_ = {0};
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = *val;
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp6_));
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2690 "CheckerboardLayout.c"
			}
		}
	}
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = name;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = old;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = *val;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp7_, _tmp8_, &_tmp9_);
#line 2702 "CheckerboardLayout.c"
}


gint checkerboard_item_get_alignment_point (CheckerboardItem* self) {
	gint result = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf_dim;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.height;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + _tmp1_;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2720 "CheckerboardLayout.c"
}


static void checkerboard_item_real_exposed (CheckerboardItem* self) {
#line 398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = TRUE;
#line 2727 "CheckerboardLayout.c"
}


void checkerboard_item_exposed (CheckerboardItem* self) {
#line 397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->exposed (self);
#line 2736 "CheckerboardLayout.c"
}


static void checkerboard_item_real_unexposed (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	CheckerboardItemText* _tmp2_ = NULL;
	CheckerboardItemText* _tmp4_ = NULL;
#line 402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 2750 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp1_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->title;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp1_);
#line 2756 "CheckerboardLayout.c"
	}
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->comment;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 2762 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp3_ = NULL;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->comment;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp3_);
#line 2768 "CheckerboardLayout.c"
	}
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->subtitle;
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 2774 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->subtitle;
#line 411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp5_);
#line 2780 "CheckerboardLayout.c"
	}
}


void checkerboard_item_unexposed (CheckerboardItem* self) {
#line 401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->unexposed (self);
#line 2790 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->exposure;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2803 "CheckerboardLayout.c"
}


gboolean checkerboard_item_is_exposed (CheckerboardItem* self) {
#line 414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->is_exposed (self);
#line 2812 "CheckerboardLayout.c"
}


gboolean checkerboard_item_has_image (CheckerboardItem* self) {
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
#line 418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ != NULL;
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2827 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
#line 422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2845 "CheckerboardLayout.c"
}


void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	Dimensions _tmp5_ = {0};
#line 426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = pixbuf;
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = _tmp1_;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = pixbuf;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp3_;
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = pixbuf;
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_pixbuf (_tmp4_, &_tmp5_);
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp5_;
#line 431 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_image");
#line 432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2886 "CheckerboardLayout.c"
}


void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim) {
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dim != NULL);
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	had_image = _tmp0_ != NULL;
#line 438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *dim;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "clear_image");
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = had_image;
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 445 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2923 "CheckerboardLayout.c"
	}
}


gint checkerboard_item_get_max_width (gint scale) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + _tmp0_;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2937 "CheckerboardLayout.c"
}


static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason) {
	Dimensions old_requisition = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_ = NULL;
	gint title_height = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	CheckerboardItemText* _tmp9_ = NULL;
	gint comment_height = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_ = NULL;
	gint subtitle_height = 0;
	Dimensions _tmp19_ = {0};
	gint _tmp20_ = 0;
	Dimensions _tmp21_ = {0};
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	Dimensions _tmp26_ = {0};
	gboolean _tmp27_ = FALSE;
#line 454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->requisition;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_requisition = _tmp0_;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->title;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ != NULL) {
#line 2977 "CheckerboardLayout.c"
		gboolean _tmp4_ = FALSE;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->title_visible;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp4_;
#line 2983 "CheckerboardLayout.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = FALSE;
#line 2987 "CheckerboardLayout.c"
	}
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 2991 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->title;
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_get_height (_tmp5_);
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp6_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3000 "CheckerboardLayout.c"
	} else {
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = 0;
#line 3004 "CheckerboardLayout.c"
	}
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_height = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->comment;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != NULL) {
#line 3012 "CheckerboardLayout.c"
		gboolean _tmp10_ = FALSE;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = self->priv->comment_visible;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_;
#line 3018 "CheckerboardLayout.c"
	} else {
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = FALSE;
#line 3022 "CheckerboardLayout.c"
	}
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 3026 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->comment;
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_get_height (_tmp11_);
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp12_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3035 "CheckerboardLayout.c"
	} else {
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = 0;
#line 3039 "CheckerboardLayout.c"
	}
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_height = _tmp7_;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != NULL) {
#line 3047 "CheckerboardLayout.c"
		gboolean _tmp16_ = FALSE;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->subtitle_visible;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp16_;
#line 3053 "CheckerboardLayout.c"
	} else {
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 3057 "CheckerboardLayout.c"
	}
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 3061 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp17_ = NULL;
		gint _tmp18_ = 0;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->subtitle;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = checkerboard_item_text_get_height (_tmp17_);
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp18_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3070 "CheckerboardLayout.c"
	} else {
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = 0;
#line 3074 "CheckerboardLayout.c"
	}
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_height = _tmp13_;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->pixbuf_dim;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = _tmp19_.width;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp20_;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->pixbuf_dim;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = _tmp21_.height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = title_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = comment_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = subtitle_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp22_) + _tmp23_) + _tmp24_) + _tmp25_;
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = old_requisition;
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = dimensions_approx_equals (&self->requisition, &_tmp26_, 1);
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp27_) {
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_geometry_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 3104 "CheckerboardLayout.c"
	}
}


void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result) {
	Dimensions dimensions = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dim != NULL);
#line 489 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&dimensions, 0, 0);
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_dim;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.width = _tmp1_ + (_tmp2_ * 2);
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_dim;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.height;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.height = _tmp4_ + (_tmp5_ * 2);
#line 492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = dimensions;
#line 492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3141 "CheckerboardLayout.c"
}


void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result) {
	GdkPoint origin = {0};
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&origin, 0, sizeof (GdkPoint));
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_origin;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.x = _tmp1_ - _tmp2_;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_origin;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.y;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.y = _tmp4_ - _tmp5_;
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = origin;
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3177 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
	gdouble rgb_all = 0.0;
	cairo_t* _tmp0_ = NULL;
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gfloat _tmp9_ = 0.0F;
	cairo_t* _tmp10_ = NULL;
	GdkPoint _tmp11_ = {0};
	gint _tmp12_ = 0;
	Dimensions _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	Dimensions _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gfloat _tmp20_ = 0.0F;
	cairo_t* _tmp21_ = NULL;
	GdkPoint _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GdkPoint _tmp25_ = {0};
	gint _tmp26_ = 0;
	Dimensions _tmp27_ = {0};
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gfloat _tmp30_ = 0.0F;
	cairo_pattern_t* lr = NULL;
	GdkPoint _tmp31_ = {0};
	gint _tmp32_ = 0;
	Dimensions _tmp33_ = {0};
	gint _tmp34_ = 0;
	GdkPoint _tmp35_ = {0};
	gint _tmp36_ = 0;
	Dimensions _tmp37_ = {0};
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	cairo_pattern_t* _tmp40_ = NULL;
	gfloat _tmp41_ = 0.0F;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	GdkPoint _tmp44_ = {0};
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GdkPoint _tmp47_ = {0};
	gint _tmp48_ = 0;
	Dimensions _tmp49_ = {0};
	gint _tmp50_ = 0;
	Dimensions _tmp51_ = {0};
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	cairo_t* _tmp55_ = NULL;
	cairo_pattern_t* td = NULL;
	GdkPoint _tmp56_ = {0};
	gint _tmp57_ = 0;
	Dimensions _tmp58_ = {0};
	gint _tmp59_ = 0;
	GdkPoint _tmp60_ = {0};
	gint _tmp61_ = 0;
	Dimensions _tmp62_ = {0};
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	cairo_pattern_t* _tmp65_ = NULL;
	gfloat _tmp66_ = 0.0F;
	cairo_t* _tmp67_ = NULL;
	cairo_t* _tmp68_ = NULL;
	GdkPoint _tmp69_ = {0};
	gint _tmp70_ = 0;
	Dimensions _tmp71_ = {0};
	gint _tmp72_ = 0;
	GdkPoint _tmp73_ = {0};
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	Dimensions _tmp77_ = {0};
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	cairo_t* _tmp80_ = NULL;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dimensions != NULL);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rgb_all = 0.0;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = ctx;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *origin;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *dimensions;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = *origin;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.y;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = radius;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = radius;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp0_, _tmp2_ + _tmp4_, _tmp6_ + _tmp7_, rgb_all, (gfloat) _tmp8_, _tmp9_, (-0.5) * G_PI, (gdouble) 0);
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = ctx;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = *origin;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_.x;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = *dimensions;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _tmp13_.width;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = *origin;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = _tmp15_.y;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = *dimensions;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = _tmp17_.height;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = radius;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = initial_alpha;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp10_, _tmp12_ + _tmp14_, _tmp16_ + _tmp18_, rgb_all, (gfloat) _tmp19_, _tmp20_, (gdouble) 0, 0.5 * G_PI);
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = ctx;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = *origin;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = _tmp22_.x;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = radius;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = *origin;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_.y;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = *dimensions;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _tmp27_.height;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = radius;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = initial_alpha;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp21_, _tmp23_ + _tmp24_, _tmp26_ + _tmp28_, rgb_all, (gfloat) _tmp29_, _tmp30_, 0.5 * G_PI, G_PI);
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = *origin;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_.y;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp33_ = *dimensions;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp34_ = _tmp33_.height;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = *origin;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = _tmp35_.y;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = *dimensions;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = _tmp37_.height;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = radius;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp32_ + _tmp34_), (gdouble) 0, (gdouble) ((_tmp36_ + _tmp38_) + _tmp39_));
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	lr = _tmp40_;
#line 519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = initial_alpha;
#line 519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp41_);
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = ctx;
#line 521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp42_, lr);
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = ctx;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = _tmp44_.x;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.height;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.width;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp54_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp43_, (gdouble) (_tmp45_ + _tmp46_), (gdouble) (_tmp48_ + _tmp50_), (gdouble) (_tmp52_ - _tmp53_), (gdouble) _tmp54_);
#line 523 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp55_ = ctx;
#line 523 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp55_);
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp56_ = *origin;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = _tmp56_.x;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp58_ = *dimensions;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp59_ = _tmp58_.width;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp60_ = *origin;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp61_ = _tmp60_.x;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp62_ = *dimensions;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = _tmp62_.width;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = radius;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = cairo_pattern_create_linear ((gdouble) (_tmp57_ + _tmp59_), (gdouble) 0, (gdouble) ((_tmp61_ + _tmp63_) + _tmp64_), (gdouble) 0);
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	td = _tmp65_;
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = initial_alpha;
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp66_);
#line 529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = ctx;
#line 530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp67_, td);
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = ctx;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = _tmp69_.x;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = _tmp71_.width;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp73_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp74_ = _tmp73_.y;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp75_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp76_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp77_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp78_ = _tmp77_.height;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp79_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp72_), (gdouble) (_tmp74_ + _tmp75_), (gdouble) _tmp76_, (gdouble) (_tmp78_ - _tmp79_));
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp80_ = ctx;
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp80_);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (td);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (lr);
#line 3470 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_shadow (self, ctx, dimensions, origin, radius, initial_alpha);
#line 3479 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2) {
	cairo_pattern_t* p = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	cairo_pattern_t* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gfloat _tmp9_ = 0.0F;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gfloat _tmp20_ = 0.0F;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = x;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = y;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = radius;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = cairo_pattern_create_radial ((gdouble) _tmp0_, (gdouble) _tmp1_, (gdouble) 0, (gdouble) _tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	p = _tmp5_;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 0.0, _tmp6_, _tmp7_, _tmp8_, (gdouble) _tmp9_);
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 1.0, _tmp10_, _tmp11_, _tmp12_, (gdouble) 0);
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = ctx;
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp13_, p);
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = ctx;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = x;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = y;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_move_to (_tmp14_, (gdouble) _tmp15_, (gdouble) _tmp16_);
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = ctx;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = x;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = y;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = radius;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = arc1;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = arc2;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_arc (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_, (gdouble) _tmp20_, _tmp21_, _tmp22_);
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = ctx;
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_close_path (_tmp23_);
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = ctx;
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp24_);
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (p);
#line 3582 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
	gint _tmp0_ = 0;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = border_width;
#line 550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 1) {
#line 3598 "CheckerboardLayout.c"
		cairo_t* _tmp1_ = NULL;
		GdkPoint _tmp2_ = {0};
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkPoint _tmp5_ = {0};
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Dimensions _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Dimensions _tmp11_ = {0};
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		cairo_t* _tmp14_ = NULL;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = ctx;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = *object_origin;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_.x;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = *object_origin;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.y;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = *object_dimensions;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_.width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = *object_dimensions;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.height;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp1_, (gdouble) (_tmp3_ - _tmp4_), (gdouble) (_tmp6_ - _tmp7_), (gdouble) (_tmp9_ + (_tmp10_ * 2)), (gdouble) (_tmp12_ + (_tmp13_ * 2)));
#line 554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = ctx;
#line 554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp14_);
#line 3645 "CheckerboardLayout.c"
	} else {
		Dimensions dimensions = {0};
		Dimensions _tmp15_ = {0};
		gint _tmp16_ = 0;
		Dimensions _tmp17_ = {0};
		GdkPoint origin = {0};
		GdkPoint _tmp18_ = {0};
		gint _tmp19_ = 0;
		GdkPoint _tmp20_ = {0};
		gdouble scale = 0.0;
		Dimensions _tmp21_ = {0};
		gint _tmp22_ = 0;
		Dimensions _tmp23_ = {0};
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		cairo_t* _tmp26_ = NULL;
		Dimensions _tmp27_ = {0};
		GdkPoint _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = *object_dimensions;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = border_width;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_dimensions (&_tmp15_, _tmp16_, &_tmp17_);
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions = _tmp17_;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = *object_origin;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = border_width;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_origin (&_tmp18_, _tmp19_, &_tmp20_);
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		origin = _tmp20_;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = *object_dimensions;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = *object_dimensions;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = MAX (_tmp22_, _tmp24_);
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		scale = (gdouble) _tmp25_;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = dimensions;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = origin;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = scale;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		draw_rounded_corners_filled (_tmp26_, &_tmp27_, &_tmp28_, 0.25 * _tmp29_);
#line 3703 "CheckerboardLayout.c"
	}
}


void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_border (self, ctx, object_dimensions, object_origin, border_width);
#line 3713 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
	GdkPixbuf* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	cairo_t* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPoint _tmp14_ = {0};
	gint _tmp15_ = 0;
	GdkPoint _tmp16_ = {0};
	gint _tmp17_ = 0;
	cairo_t* _tmp18_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = pixbuf;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gdk_pixbuf_get_has_alpha (_tmp0_);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 3739 "CheckerboardLayout.c"
		cairo_t* _tmp2_ = NULL;
		GdkPoint _tmp3_ = {0};
		gint _tmp4_ = 0;
		GdkPoint _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkPixbuf* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		cairo_t* _tmp11_ = NULL;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = ctx;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = *origin;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.x;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = *origin;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.y;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = pixbuf;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = pixbuf;
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
#line 567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp2_, (gdouble) _tmp4_, (gdouble) _tmp6_, (gdouble) _tmp8_, (gdouble) _tmp10_);
#line 568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = ctx;
#line 568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp11_);
#line 3774 "CheckerboardLayout.c"
	}
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = ctx;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = pixbuf;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = *origin;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.x;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = *origin;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = _tmp16_.y;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_cairo_set_source_pixbuf (_tmp12_, _tmp13_, (gdouble) _tmp15_, (gdouble) _tmp17_);
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = ctx;
#line 571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_paint (_tmp18_);
#line 3794 "CheckerboardLayout.c"
}


void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_image (self, ctx, pixbuf, origin);
#line 3803 "CheckerboardLayout.c"
}


static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = scale;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = thumbnail_get_MIN_SCALE ();
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = thumbnail_get_MAX_SCALE ();
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ <= ((_tmp3_ + _tmp5_) / 3)) {
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 2;
#line 3831 "CheckerboardLayout.c"
	} else {
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 3;
#line 3835 "CheckerboardLayout.c"
	}
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3841 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3851 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale) {
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_left_trinket (self, scale);
#line 3860 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3870 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale) {
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_right_trinket (self, scale);
#line 3879 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3889 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_left_trinket (self, scale);
#line 3898 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3908 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_right_trinket (self, scale);
#line 3917 "CheckerboardLayout.c"
}


void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color) {
	GdkPoint pixbuf_origin = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	GdkRGBA _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	GdkRGBA _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	GdkRGBA _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	GdkRGBA* _tmp14_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GdkRGBA* _tmp57_ = NULL;
	GdkPixbuf* _tmp72_ = NULL;
	cairo_t* _tmp87_ = NULL;
	GdkRGBA _tmp88_ = {0};
	gdouble _tmp89_ = 0.0;
	GdkRGBA _tmp90_ = {0};
	gdouble _tmp91_ = 0.0;
	GdkRGBA _tmp92_ = {0};
	gdouble _tmp93_ = 0.0;
	GdkRGBA _tmp94_ = {0};
	gdouble _tmp95_ = 0.0;
	gint text_y = 0;
	GdkRectangle _tmp96_ = {0};
	gint _tmp97_ = 0;
	Dimensions _tmp98_ = {0};
	gint _tmp99_ = 0;
	gboolean _tmp100_ = FALSE;
	CheckerboardItemText* _tmp101_ = NULL;
	gboolean _tmp130_ = FALSE;
	CheckerboardItemText* _tmp131_ = NULL;
	gboolean _tmp160_ = FALSE;
	CheckerboardItemText* _tmp161_ = NULL;
	cairo_t* _tmp187_ = NULL;
	GdkRGBA _tmp188_ = {0};
	gdouble _tmp189_ = 0.0;
	GdkRGBA _tmp190_ = {0};
	gdouble _tmp191_ = 0.0;
	GdkRGBA _tmp192_ = {0};
	gdouble _tmp193_ = 0.0;
	GdkRGBA _tmp194_ = {0};
	gdouble _tmp195_ = 0.0;
	GdkPixbuf* trinket = NULL;
	GdkPixbuf* _tmp196_ = NULL;
	GdkPixbuf* _tmp197_ = NULL;
	GdkPixbuf* _tmp219_ = NULL;
	GdkPixbuf* _tmp220_ = NULL;
	GdkPixbuf* _tmp238_ = NULL;
	GdkPixbuf* _tmp239_ = NULL;
	GdkPixbuf* _tmp262_ = NULL;
	GdkPixbuf* _tmp263_ = NULL;
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (bg_color != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (selected_color != NULL);
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text_color != NULL);
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&pixbuf_origin, 0, sizeof (GdkPoint));
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->allocation;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.x = (_tmp1_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->allocation;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.y = (_tmp3_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 602 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = ctx;
#line 602 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp4_, (gdouble) CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = ctx;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *selected_color;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.red;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = *selected_color;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_.green;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = *selected_color;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_.blue;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = *selected_color;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp12_.alpha;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = border_color;
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 4032 "CheckerboardLayout.c"
		cairo_t* _tmp15_ = NULL;
		Dimensions shadow_dim = {0};
		Dimensions _tmp16_ = {0};
		gint _tmp17_ = 0;
		Dimensions _tmp18_ = {0};
		gint _tmp19_ = 0;
		cairo_t* _tmp20_ = NULL;
		Dimensions _tmp21_ = {0};
		GdkPoint _tmp22_ = {0};
		cairo_t* _tmp23_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = ctx;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp15_);
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions_init (&shadow_dim, 0, 0);
#line 610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->pixbuf_dim;
#line 610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.width;
#line 610 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.width = _tmp17_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->pixbuf_dim;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_.height;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.height = _tmp19_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = ctx;
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = shadow_dim;
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = pixbuf_origin;
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_shadow (self, _tmp20_, &_tmp21_, &_tmp22_, CHECKERBOARD_ITEM_SHADOW_RADIUS, CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA);
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = ctx;
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp23_);
#line 4073 "CheckerboardLayout.c"
	}
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = self->priv->is_cursor;
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 4079 "CheckerboardLayout.c"
		cairo_t* _tmp25_ = NULL;
		cairo_t* _tmp26_ = NULL;
		GdkRGBA* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		GdkRGBA* _tmp29_ = NULL;
		gdouble _tmp30_ = 0.0;
		GdkRGBA* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		GdkRGBA* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		cairo_t* _tmp35_ = NULL;
		Dimensions _tmp36_ = {0};
		GdkPoint _tmp37_ = {0};
		Dimensions _tmp38_ = {0};
		gint _tmp39_ = 0;
		Dimensions _tmp40_ = {0};
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		cairo_t* _tmp44_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp25_);
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = border_color;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = (*_tmp27_).red;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = border_color;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = (*_tmp29_).green;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = border_color;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = (*_tmp31_).blue;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = border_color;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = (*_tmp33_).alpha;
#line 619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = ctx;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = self->priv->pixbuf_dim;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = pixbuf_origin;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = self->priv->pixbuf_dim;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.width;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = self->priv->pixbuf_dim;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.height;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = MAX (_tmp39_, _tmp41_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = checkerboard_item_get_selection_border_width (self, _tmp42_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp35_, &_tmp36_, &_tmp37_, _tmp43_);
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = ctx;
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp44_);
#line 4148 "CheckerboardLayout.c"
	}
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp45_) {
#line 4154 "CheckerboardLayout.c"
		cairo_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		Dimensions _tmp48_ = {0};
		GdkPoint _tmp49_ = {0};
		Dimensions _tmp50_ = {0};
		gint _tmp51_ = 0;
		Dimensions _tmp52_ = {0};
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		cairo_t* _tmp56_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = ctx;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp46_);
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = ctx;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = self->priv->pixbuf_dim;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = pixbuf_origin;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = self->priv->pixbuf_dim;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = _tmp50_.width;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = self->priv->pixbuf_dim;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = _tmp52_.height;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = MAX (_tmp51_, _tmp53_);
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = checkerboard_item_get_selection_border_width (self, _tmp54_);
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp47_, &_tmp48_, &_tmp49_, _tmp55_);
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = ctx;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp56_);
#line 4194 "CheckerboardLayout.c"
	}
#line 636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = border_color;
#line 636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp57_ != NULL) {
#line 4200 "CheckerboardLayout.c"
		cairo_t* _tmp58_ = NULL;
		cairo_t* _tmp59_ = NULL;
		GdkRGBA* _tmp60_ = NULL;
		gdouble _tmp61_ = 0.0;
		GdkRGBA* _tmp62_ = NULL;
		gdouble _tmp63_ = 0.0;
		GdkRGBA* _tmp64_ = NULL;
		gdouble _tmp65_ = 0.0;
		GdkRGBA* _tmp66_ = NULL;
		gdouble _tmp67_ = 0.0;
		cairo_t* _tmp68_ = NULL;
		Dimensions _tmp69_ = {0};
		GdkPoint _tmp70_ = {0};
		cairo_t* _tmp71_ = NULL;
#line 637 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 637 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp58_);
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = ctx;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = border_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = (*_tmp60_).red;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = border_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp63_ = (*_tmp62_).green;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp64_ = border_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp65_ = (*_tmp64_).blue;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp66_ = border_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp67_ = (*_tmp66_).alpha;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp59_, _tmp61_, _tmp63_, _tmp65_, _tmp67_);
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp68_ = ctx;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp69_ = self->priv->pixbuf_dim;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp70_ = pixbuf_origin;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp68_, &_tmp69_, &_tmp70_, CHECKERBOARD_ITEM_BORDER_WIDTH);
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp71_ = ctx;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp71_);
#line 4251 "CheckerboardLayout.c"
	}
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = self->priv->display_pixbuf;
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp72_ != NULL) {
#line 4257 "CheckerboardLayout.c"
		cairo_t* _tmp73_ = NULL;
		cairo_t* _tmp74_ = NULL;
		GdkRGBA _tmp75_ = {0};
		gdouble _tmp76_ = 0.0;
		GdkRGBA _tmp77_ = {0};
		gdouble _tmp78_ = 0.0;
		GdkRGBA _tmp79_ = {0};
		gdouble _tmp80_ = 0.0;
		GdkRGBA _tmp81_ = {0};
		gdouble _tmp82_ = 0.0;
		cairo_t* _tmp83_ = NULL;
		GdkPixbuf* _tmp84_ = NULL;
		GdkPoint _tmp85_ = {0};
		cairo_t* _tmp86_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = ctx;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp73_);
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp74_ = ctx;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp75_ = *bg_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp76_ = _tmp75_.red;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp77_ = *bg_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp78_ = _tmp77_.green;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp79_ = *bg_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp80_ = _tmp79_.blue;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp81_ = *bg_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp82_ = _tmp81_.alpha;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp74_, _tmp76_, _tmp78_, _tmp80_, _tmp82_);
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp83_ = ctx;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp84_ = self->priv->display_pixbuf;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp85_ = pixbuf_origin;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_image (self, _tmp83_, _tmp84_, &_tmp85_);
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp86_ = ctx;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp86_);
#line 4308 "CheckerboardLayout.c"
	}
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp87_ = ctx;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp88_ = *text_color;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp89_ = _tmp88_.red;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp90_ = *text_color;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp91_ = _tmp90_.green;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp92_ = *text_color;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp93_ = _tmp92_.blue;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp94_ = *text_color;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp95_ = _tmp94_.alpha;
#line 651 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp87_, _tmp89_, _tmp91_, _tmp93_, _tmp95_);
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp96_ = self->allocation;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp97_ = _tmp96_.y;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp98_ = self->priv->pixbuf_dim;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp99_ = _tmp98_.height;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text_y = (((_tmp97_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + _tmp99_) + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp101_ = self->priv->title;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp101_ != NULL) {
#line 4344 "CheckerboardLayout.c"
		gboolean _tmp102_ = FALSE;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp102_ = self->priv->title_visible;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = _tmp102_;
#line 4350 "CheckerboardLayout.c"
	} else {
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = FALSE;
#line 4354 "CheckerboardLayout.c"
	}
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp100_) {
#line 4358 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp103_ = NULL;
		GdkRectangle _tmp104_ = {0};
		gint _tmp105_ = 0;
		CheckerboardItemText* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		CheckerboardItemText* _tmp108_ = NULL;
		Dimensions _tmp109_ = {0};
		gint _tmp110_ = 0;
		CheckerboardItemText* _tmp111_ = NULL;
		CheckerboardItemText* _tmp112_ = NULL;
		gint _tmp113_ = 0;
		cairo_t* _tmp114_ = NULL;
		CheckerboardItemText* _tmp115_ = NULL;
		GdkRectangle _tmp116_ = {0};
		gint _tmp117_ = 0;
		CheckerboardItemText* _tmp118_ = NULL;
		GdkRectangle _tmp119_ = {0};
		gint _tmp120_ = 0;
		cairo_t* _tmp121_ = NULL;
		CheckerboardItemText* _tmp122_ = NULL;
		Dimensions _tmp123_ = {0};
		gint _tmp124_ = 0;
		PangoLayout* _tmp125_ = NULL;
		PangoLayout* _tmp126_ = NULL;
		gint _tmp127_ = 0;
		CheckerboardItemText* _tmp128_ = NULL;
		gint _tmp129_ = 0;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_ = self->priv->title;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp104_ = self->allocation;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp105_ = _tmp104_.x;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_->allocation.x = _tmp105_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_ = self->priv->title;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp107_ = text_y;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_->allocation.y = _tmp107_;
#line 660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_ = self->priv->title;
#line 660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp109_ = self->priv->pixbuf_dim;
#line 660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp110_ = _tmp109_.width;
#line 660 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_->allocation.width = _tmp110_;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_ = self->priv->title;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp112_ = self->priv->title;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp113_ = checkerboard_item_text_get_height (_tmp112_);
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_->allocation.height = _tmp113_;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp114_ = ctx;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp115_ = self->priv->title;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp116_ = _tmp115_->allocation;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp117_ = _tmp116_.x;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp118_ = self->priv->title;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp119_ = _tmp118_->allocation;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp120_ = _tmp119_.y;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp114_, (gdouble) _tmp117_, (gdouble) _tmp120_);
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp121_ = ctx;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp122_ = self->priv->title;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp123_ = self->priv->pixbuf_dim;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp124_ = _tmp123_.width;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp125_ = checkerboard_item_text_get_pango_layout (_tmp122_, _tmp124_);
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp126_ = _tmp125_;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp121_, _tmp126_);
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp126_);
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp127_ = text_y;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp128_ = self->priv->title;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp129_ = checkerboard_item_text_get_height (_tmp128_);
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp127_ + (_tmp129_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4456 "CheckerboardLayout.c"
	}
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp131_ = self->priv->comment;
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp131_ != NULL) {
#line 4462 "CheckerboardLayout.c"
		gboolean _tmp132_ = FALSE;
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp132_ = self->priv->comment_visible;
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = _tmp132_;
#line 4468 "CheckerboardLayout.c"
	} else {
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = FALSE;
#line 4472 "CheckerboardLayout.c"
	}
#line 669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp130_) {
#line 4476 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp133_ = NULL;
		GdkRectangle _tmp134_ = {0};
		gint _tmp135_ = 0;
		CheckerboardItemText* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		CheckerboardItemText* _tmp138_ = NULL;
		Dimensions _tmp139_ = {0};
		gint _tmp140_ = 0;
		CheckerboardItemText* _tmp141_ = NULL;
		CheckerboardItemText* _tmp142_ = NULL;
		gint _tmp143_ = 0;
		cairo_t* _tmp144_ = NULL;
		CheckerboardItemText* _tmp145_ = NULL;
		GdkRectangle _tmp146_ = {0};
		gint _tmp147_ = 0;
		CheckerboardItemText* _tmp148_ = NULL;
		GdkRectangle _tmp149_ = {0};
		gint _tmp150_ = 0;
		cairo_t* _tmp151_ = NULL;
		CheckerboardItemText* _tmp152_ = NULL;
		Dimensions _tmp153_ = {0};
		gint _tmp154_ = 0;
		PangoLayout* _tmp155_ = NULL;
		PangoLayout* _tmp156_ = NULL;
		gint _tmp157_ = 0;
		CheckerboardItemText* _tmp158_ = NULL;
		gint _tmp159_ = 0;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_ = self->priv->comment;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp134_ = self->allocation;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp135_ = _tmp134_.x;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_->allocation.x = _tmp135_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_ = self->priv->comment;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp137_ = text_y;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_->allocation.y = _tmp137_;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_ = self->priv->comment;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp139_ = self->priv->pixbuf_dim;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp140_ = _tmp139_.width;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_->allocation.width = _tmp140_;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_ = self->priv->comment;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp142_ = self->priv->comment;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp143_ = checkerboard_item_text_get_height (_tmp142_);
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_->allocation.height = _tmp143_;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp144_ = ctx;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp145_ = self->priv->comment;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp146_ = _tmp145_->allocation;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp147_ = _tmp146_.x;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp148_ = self->priv->comment;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp149_ = _tmp148_->allocation;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp150_ = _tmp149_.y;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp144_, (gdouble) _tmp147_, (gdouble) _tmp150_);
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp151_ = ctx;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp152_ = self->priv->comment;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp153_ = self->priv->pixbuf_dim;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp154_ = _tmp153_.width;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp155_ = checkerboard_item_text_get_pango_layout (_tmp152_, _tmp154_);
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp156_ = _tmp155_;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp151_, _tmp156_);
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp156_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp157_ = text_y;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp158_ = self->priv->comment;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp159_ = checkerboard_item_text_get_height (_tmp158_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp157_ + (_tmp159_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4574 "CheckerboardLayout.c"
	}
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp161_ = self->priv->subtitle;
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp161_ != NULL) {
#line 4580 "CheckerboardLayout.c"
		gboolean _tmp162_ = FALSE;
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp162_ = self->priv->subtitle_visible;
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = _tmp162_;
#line 4586 "CheckerboardLayout.c"
	} else {
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = FALSE;
#line 4590 "CheckerboardLayout.c"
	}
#line 681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp160_) {
#line 4594 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp163_ = NULL;
		GdkRectangle _tmp164_ = {0};
		gint _tmp165_ = 0;
		CheckerboardItemText* _tmp166_ = NULL;
		gint _tmp167_ = 0;
		CheckerboardItemText* _tmp168_ = NULL;
		Dimensions _tmp169_ = {0};
		gint _tmp170_ = 0;
		CheckerboardItemText* _tmp171_ = NULL;
		CheckerboardItemText* _tmp172_ = NULL;
		gint _tmp173_ = 0;
		cairo_t* _tmp174_ = NULL;
		CheckerboardItemText* _tmp175_ = NULL;
		GdkRectangle _tmp176_ = {0};
		gint _tmp177_ = 0;
		CheckerboardItemText* _tmp178_ = NULL;
		GdkRectangle _tmp179_ = {0};
		gint _tmp180_ = 0;
		cairo_t* _tmp181_ = NULL;
		CheckerboardItemText* _tmp182_ = NULL;
		Dimensions _tmp183_ = {0};
		gint _tmp184_ = 0;
		PangoLayout* _tmp185_ = NULL;
		PangoLayout* _tmp186_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_ = self->priv->subtitle;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp164_ = self->allocation;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp165_ = _tmp164_.x;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_->allocation.x = _tmp165_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_ = self->priv->subtitle;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp167_ = text_y;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_->allocation.y = _tmp167_;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_ = self->priv->subtitle;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp169_ = self->priv->pixbuf_dim;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp170_ = _tmp169_.width;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_->allocation.width = _tmp170_;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_ = self->priv->subtitle;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp172_ = self->priv->subtitle;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp173_ = checkerboard_item_text_get_height (_tmp172_);
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_->allocation.height = _tmp173_;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp174_ = ctx;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp175_ = self->priv->subtitle;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp176_ = _tmp175_->allocation;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp177_ = _tmp176_.x;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp178_ = self->priv->subtitle;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp179_ = _tmp178_->allocation;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp180_ = _tmp179_.y;
#line 687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp174_, (gdouble) _tmp177_, (gdouble) _tmp180_);
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp181_ = ctx;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp182_ = self->priv->subtitle;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp183_ = self->priv->pixbuf_dim;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp184_ = _tmp183_.width;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp185_ = checkerboard_item_text_get_pango_layout (_tmp182_, _tmp184_);
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp186_ = _tmp185_;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp181_, _tmp186_);
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp186_);
#line 4681 "CheckerboardLayout.c"
	}
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp187_ = ctx;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp188_ = *selected_color;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp189_ = _tmp188_.red;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp190_ = *selected_color;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp191_ = _tmp190_.green;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp192_ = *selected_color;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp193_ = _tmp192_.blue;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp194_ = *selected_color;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp195_ = _tmp194_.alpha;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp187_, _tmp189_, _tmp191_, _tmp193_, _tmp195_);
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp196_ = checkerboard_item_get_bottom_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp196_;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp197_ = trinket;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp197_ != NULL) {
#line 4711 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp198_ = {0};
		gint _tmp199_ = 0;
		gint _tmp200_ = 0;
		gint y = 0;
		GdkPoint _tmp201_ = {0};
		gint _tmp202_ = 0;
		Dimensions _tmp203_ = {0};
		gint _tmp204_ = 0;
		GdkPixbuf* _tmp205_ = NULL;
		gint _tmp206_ = 0;
		cairo_t* _tmp207_ = NULL;
		GdkPixbuf* _tmp208_ = NULL;
		gint _tmp209_ = 0;
		gint _tmp210_ = 0;
		cairo_t* _tmp211_ = NULL;
		gint _tmp212_ = 0;
		gint _tmp213_ = 0;
		GdkPixbuf* _tmp214_ = NULL;
		gint _tmp215_ = 0;
		GdkPixbuf* _tmp216_ = NULL;
		gint _tmp217_ = 0;
		cairo_t* _tmp218_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp198_ = pixbuf_origin;
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp199_ = _tmp198_.x;
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp200_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp199_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp200_;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp201_ = pixbuf_origin;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp202_ = _tmp201_.y;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp203_ = self->priv->pixbuf_dim;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp204_ = _tmp203_.height;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp205_ = trinket;
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp206_ = gdk_pixbuf_get_height (_tmp205_);
#line 700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp202_ + _tmp204_) - _tmp206_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp207_ = ctx;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp208_ = trinket;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp209_ = x;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp210_ = y;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp207_, _tmp208_, (gdouble) _tmp209_, (gdouble) _tmp210_);
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp211_ = ctx;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp212_ = x;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp213_ = y;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp214_ = trinket;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp215_ = gdk_pixbuf_get_width (_tmp214_);
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp216_ = trinket;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp217_ = gdk_pixbuf_get_height (_tmp216_);
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp211_, (gdouble) _tmp212_, (gdouble) _tmp213_, (gdouble) _tmp215_, (gdouble) _tmp217_);
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp218_ = ctx;
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp218_);
#line 4787 "CheckerboardLayout.c"
	}
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp219_ = checkerboard_item_get_top_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp219_;
#line 708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp220_ = trinket;
#line 708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp220_ != NULL) {
#line 4799 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp221_ = {0};
		gint _tmp222_ = 0;
		gint _tmp223_ = 0;
		gint y = 0;
		GdkPoint _tmp224_ = {0};
		gint _tmp225_ = 0;
		cairo_t* _tmp226_ = NULL;
		GdkPixbuf* _tmp227_ = NULL;
		gint _tmp228_ = 0;
		gint _tmp229_ = 0;
		cairo_t* _tmp230_ = NULL;
		gint _tmp231_ = 0;
		gint _tmp232_ = 0;
		GdkPixbuf* _tmp233_ = NULL;
		gint _tmp234_ = 0;
		GdkPixbuf* _tmp235_ = NULL;
		gint _tmp236_ = 0;
		cairo_t* _tmp237_ = NULL;
#line 709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp221_ = pixbuf_origin;
#line 709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp222_ = _tmp221_.x;
#line 709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp223_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp222_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp223_;
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp224_ = pixbuf_origin;
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp225_ = _tmp224_.y;
#line 710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp225_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp226_ = ctx;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp227_ = trinket;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp228_ = x;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp229_ = y;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp226_, _tmp227_, (gdouble) _tmp228_, (gdouble) _tmp229_);
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp230_ = ctx;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp231_ = x;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp232_ = y;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp233_ = trinket;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp234_ = gdk_pixbuf_get_width (_tmp233_);
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp235_ = trinket;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp236_ = gdk_pixbuf_get_height (_tmp235_);
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp230_, (gdouble) _tmp231_, (gdouble) _tmp232_, (gdouble) _tmp234_, (gdouble) _tmp236_);
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp237_ = ctx;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp237_);
#line 4863 "CheckerboardLayout.c"
	}
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp238_ = checkerboard_item_get_top_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp238_;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp239_ = trinket;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp239_ != NULL) {
#line 4875 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp240_ = {0};
		gint _tmp241_ = 0;
		Dimensions _tmp242_ = {0};
		gint _tmp243_ = 0;
		GdkPixbuf* _tmp244_ = NULL;
		gint _tmp245_ = 0;
		gint _tmp246_ = 0;
		gint _tmp247_ = 0;
		gint y = 0;
		GdkPoint _tmp248_ = {0};
		gint _tmp249_ = 0;
		cairo_t* _tmp250_ = NULL;
		GdkPixbuf* _tmp251_ = NULL;
		gint _tmp252_ = 0;
		gint _tmp253_ = 0;
		cairo_t* _tmp254_ = NULL;
		gint _tmp255_ = 0;
		gint _tmp256_ = 0;
		GdkPixbuf* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		GdkPixbuf* _tmp259_ = NULL;
		gint _tmp260_ = 0;
		cairo_t* _tmp261_ = NULL;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp240_ = pixbuf_origin;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp241_ = _tmp240_.x;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp242_ = self->priv->pixbuf_dim;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp243_ = _tmp242_.width;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp244_ = trinket;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp245_ = gdk_pixbuf_get_width (_tmp244_);
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp246_ = _tmp245_;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp247_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp241_ + _tmp243_) - _tmp246_) - _tmp247_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp248_ = pixbuf_origin;
#line 720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249_ = _tmp248_.y;
#line 720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp249_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp250_ = ctx;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp251_ = trinket;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp252_ = x;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp253_ = y;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp250_, _tmp251_, (gdouble) _tmp252_, (gdouble) _tmp253_);
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp254_ = ctx;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp255_ = x;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = y;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = trinket;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = gdk_pixbuf_get_width (_tmp257_);
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = trinket;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = gdk_pixbuf_get_height (_tmp259_);
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp254_, (gdouble) _tmp255_, (gdouble) _tmp256_, (gdouble) _tmp258_, (gdouble) _tmp260_);
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp261_ = ctx;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp261_);
#line 4954 "CheckerboardLayout.c"
	}
#line 726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = checkerboard_item_get_bottom_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp262_;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = trinket;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp263_ != NULL) {
#line 4966 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp264_ = {0};
		gint _tmp265_ = 0;
		Dimensions _tmp266_ = {0};
		gint _tmp267_ = 0;
		GdkPixbuf* _tmp268_ = NULL;
		gint _tmp269_ = 0;
		gint _tmp270_ = 0;
		gint _tmp271_ = 0;
		gint y = 0;
		GdkPoint _tmp272_ = {0};
		gint _tmp273_ = 0;
		Dimensions _tmp274_ = {0};
		gint _tmp275_ = 0;
		GdkPixbuf* _tmp276_ = NULL;
		gint _tmp277_ = 0;
		gint _tmp278_ = 0;
		cairo_t* _tmp279_ = NULL;
		GdkPixbuf* _tmp280_ = NULL;
		gint _tmp281_ = 0;
		gint _tmp282_ = 0;
		cairo_t* _tmp283_ = NULL;
		gint _tmp284_ = 0;
		gint _tmp285_ = 0;
		GdkPixbuf* _tmp286_ = NULL;
		gint _tmp287_ = 0;
		GdkPixbuf* _tmp288_ = NULL;
		gint _tmp289_ = 0;
		cairo_t* _tmp290_ = NULL;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp264_ = pixbuf_origin;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp265_ = _tmp264_.x;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp266_ = self->priv->pixbuf_dim;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp267_ = _tmp266_.width;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp268_ = trinket;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = gdk_pixbuf_get_width (_tmp268_);
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp270_ = _tmp269_;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp271_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp265_ + _tmp267_) - _tmp270_) - _tmp271_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp272_ = pixbuf_origin;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = _tmp272_.y;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = self->priv->pixbuf_dim;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = trinket;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = gdk_pixbuf_get_height (_tmp276_);
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = _tmp277_;
#line 730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp273_ + _tmp275_) - _tmp278_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp279_ = ctx;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp280_ = trinket;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp281_ = x;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp282_ = y;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp279_, _tmp280_, (gdouble) _tmp281_, (gdouble) _tmp282_);
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp283_ = ctx;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp284_ = x;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp285_ = y;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp286_ = trinket;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp287_ = gdk_pixbuf_get_width (_tmp286_);
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp288_ = trinket;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp289_ = gdk_pixbuf_get_height (_tmp288_);
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp283_, (gdouble) _tmp284_, (gdouble) _tmp285_, (gdouble) _tmp287_, (gdouble) _tmp289_);
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp290_ = ctx;
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp290_);
#line 5060 "CheckerboardLayout.c"
	}
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 5064 "CheckerboardLayout.c"
}


void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 738 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = horizontal_trinket_offset;
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp0_ >= 0, "horizontal_trinket_offset >= 0");
#line 740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = horizontal_trinket_offset;
#line 740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = _tmp1_;
#line 5081 "CheckerboardLayout.c"
}


gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 743 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->horizontal_trinket_offset;
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5096 "CheckerboardLayout.c"
}


void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = col;
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = _tmp0_;
#line 749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = row;
#line 749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = _tmp1_;
#line 5113 "CheckerboardLayout.c"
}


gint checkerboard_item_get_column (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->col;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5128 "CheckerboardLayout.c"
}


gint checkerboard_item_get_row (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->row;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5143 "CheckerboardLayout.c"
}


void checkerboard_item_brighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5163 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_ = NULL;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5170 "CheckerboardLayout.c"
	}
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 763 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5176 "CheckerboardLayout.c"
	}
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = _tmp4_;
#line 767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->brightened;
#line 767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
#line 769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->brightened;
#line 769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp7_;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5200 "CheckerboardLayout.c"
}


void checkerboard_item_unbrighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
#line 774 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == NULL) {
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5217 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_ = NULL;
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5224 "CheckerboardLayout.c"
	}
#line 776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 777 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5230 "CheckerboardLayout.c"
	}
#line 779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp4_;
#line 784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5246 "CheckerboardLayout.c"
}


static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible) {
	CheckerboardItem * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = visible;
#line 789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp0_) {
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_unbrighten (self);
#line 5262 "CheckerboardLayout.c"
	}
#line 792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_VIEW, DataView), _tmp1_);
#line 5268 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	CheckerboardItemText* _tmp0_ = NULL;
	PangoLayout* _tmp1_ = NULL;
	PangoLayout* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	CheckerboardItemText* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (text), FALSE);
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_get_pango_layout (_tmp0_, 0);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = pango_layout_is_ellipsized (_tmp2_);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = !_tmp3_;
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_) {
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5305 "CheckerboardLayout.c"
	}
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = text;
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = checkerboard_item_text_is_marked_up (_tmp5_);
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 5313 "CheckerboardLayout.c"
		GtkTooltip* _tmp7_ = NULL;
		CheckerboardItemText* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tooltip;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = text;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_text_get_text (_tmp8_);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_markup (_tmp7_, _tmp10_);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 5330 "CheckerboardLayout.c"
	} else {
		GtkTooltip* _tmp11_ = NULL;
		CheckerboardItemText* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = tooltip;
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = text;
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = checkerboard_item_text_get_text (_tmp12_);
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_;
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_text (_tmp11_, _tmp14_);
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp14_);
#line 5348 "CheckerboardLayout.c"
	}
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = TRUE;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5354 "CheckerboardLayout.c"
}


gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CheckerboardItemText* _tmp14_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	CheckerboardItemText* _tmp26_ = NULL;
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->title;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 5377 "CheckerboardLayout.c"
		gboolean _tmp3_ = FALSE;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->title_visible;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp3_;
#line 5383 "CheckerboardLayout.c"
	} else {
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 5387 "CheckerboardLayout.c"
	}
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 5391 "CheckerboardLayout.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		CheckerboardItemText* _tmp6_ = NULL;
		GdkRectangle _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = x;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = y;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->title;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_->allocation;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = coord_in_rectangle (_tmp4_, _tmp5_, &_tmp7_);
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp8_;
#line 5409 "CheckerboardLayout.c"
	} else {
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 5413 "CheckerboardLayout.c"
	}
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 5417 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp9_ = NULL;
		GtkTooltip* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = self->priv->title;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = tooltip;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = checkerboard_item_query_tooltip_on_text (self, _tmp9_, _tmp10_);
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp11_;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5431 "CheckerboardLayout.c"
	}
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->comment;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 5437 "CheckerboardLayout.c"
		gboolean _tmp15_ = FALSE;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->comment_visible;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp15_;
#line 5443 "CheckerboardLayout.c"
	} else {
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 5447 "CheckerboardLayout.c"
	}
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 5451 "CheckerboardLayout.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		CheckerboardItemText* _tmp18_ = NULL;
		GdkRectangle _tmp19_ = {0};
		gboolean _tmp20_ = FALSE;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = x;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = y;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->comment;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_->allocation;
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = coord_in_rectangle (_tmp16_, _tmp17_, &_tmp19_);
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp20_;
#line 5469 "CheckerboardLayout.c"
	} else {
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = FALSE;
#line 5473 "CheckerboardLayout.c"
	}
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_) {
#line 5477 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp21_ = NULL;
		GtkTooltip* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->comment;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = tooltip;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = checkerboard_item_query_tooltip_on_text (self, _tmp21_, _tmp22_);
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp23_;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5491 "CheckerboardLayout.c"
	}
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = self->priv->subtitle;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp26_ != NULL) {
#line 5497 "CheckerboardLayout.c"
		gboolean _tmp27_ = FALSE;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = self->priv->subtitle_visible;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = _tmp27_;
#line 5503 "CheckerboardLayout.c"
	} else {
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = FALSE;
#line 5507 "CheckerboardLayout.c"
	}
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_) {
#line 5511 "CheckerboardLayout.c"
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		CheckerboardItemText* _tmp30_ = NULL;
		GdkRectangle _tmp31_ = {0};
		gboolean _tmp32_ = FALSE;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = x;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = y;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->subtitle;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_->allocation;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = coord_in_rectangle (_tmp28_, _tmp29_, &_tmp31_);
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp32_;
#line 5529 "CheckerboardLayout.c"
	} else {
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = FALSE;
#line 5533 "CheckerboardLayout.c"
	}
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 5537 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp33_ = NULL;
		GtkTooltip* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = self->priv->subtitle;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = tooltip;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = checkerboard_item_query_tooltip_on_text (self, _tmp33_, _tmp34_);
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp35_;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5551 "CheckerboardLayout.c"
	}
#line 817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5557 "CheckerboardLayout.c"
}


gboolean checkerboard_item_get_has_tags (CheckerboardItem* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->_has_tags;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5572 "CheckerboardLayout.c"
}


static void checkerboard_item_set_has_tags (CheckerboardItem* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = value;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_has_tags = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_object_notify ((GObject *) self, "has-tags");
#line 5586 "CheckerboardLayout.c"
}


static void checkerboard_item_class_init (CheckerboardItemClass * klass) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemPrivate));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->get_name = checkerboard_item_real_get_name;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_membership_changed = checkerboard_item_real_notify_membership_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = checkerboard_item_real_notify_collection_property_set;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->exposed = checkerboard_item_real_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->unexposed = checkerboard_item_real_unexposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->is_exposed = checkerboard_item_real_is_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = checkerboard_item_real_paint_shadow;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_border = checkerboard_item_real_paint_border;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_image = checkerboard_item_real_paint_image;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_left_trinket = checkerboard_item_real_get_top_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = checkerboard_item_real_get_top_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = checkerboard_item_real_get_bottom_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_right_trinket = checkerboard_item_real_get_bottom_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataViewClass *) klass)->visibility_changed = checkerboard_item_real_visibility_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_checkerboard_item_get_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_checkerboard_item_set_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECKERBOARD_ITEM_HAS_TAGS, g_param_spec_boolean ("has-tags", "has-tags", "has-tags", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5631 "CheckerboardLayout.c"
}


static void checkerboard_item_instance_init (CheckerboardItem * self) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_GET_PRIVATE (self);
#line 119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->requisition, 0, 0);
#line 120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 122 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = TRUE;
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 126 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = TRUE;
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = FALSE;
#line 129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = FALSE;
#line 130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = PANGO_ALIGN_LEFT;
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
#line 137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = -1;
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = -1;
#line 139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = 0;
#line 5676 "CheckerboardLayout.c"
}


static void checkerboard_item_finalize (GObject* obj) {
	CheckerboardItem * self;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->tags);
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
#line 5702 "CheckerboardLayout.c"
}


GType checkerboard_item_get_type (void) {
	static volatile gsize checkerboard_item_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&checkerboard_item_type_id__volatile, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__volatile;
}


static void _vala_checkerboard_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_value_set_boolean (value, checkerboard_item_get_has_tags (self));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5729 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5735 "CheckerboardLayout.c"
	}
}


static void _vala_checkerboard_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_has_tags (self, g_value_get_boolean (value));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5751 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5757 "CheckerboardLayout.c"
	}
}


static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self) {
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
#line 5765 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
#line 5772 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self) {
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
#line 5779 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self) {
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
#line 5786 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self) {
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
#line 5793 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
#line 5800 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
#line 5807 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self) {
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5814 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self) {
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5821 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
#line 5828 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
#line 5835 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self) {
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_colors_changed ((CheckerboardLayout*) self);
#line 5842 "CheckerboardLayout.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? data_collection_ref (self) : NULL;
#line 5849 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view) {
	CheckerboardLayout * self = NULL;
	ViewCollection* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	ViewCollection* _tmp2_ = NULL;
	ViewCollection* _tmp3_ = NULL;
	ViewCollection* _tmp4_ = NULL;
	ViewCollection* _tmp5_ = NULL;
	ViewCollection* _tmp6_ = NULL;
	ViewCollection* _tmp7_ = NULL;
	ViewCollection* _tmp8_ = NULL;
	ViewCollection* _tmp9_ = NULL;
	ViewCollection* _tmp10_ = NULL;
	ConfigFacade* _tmp11_ = NULL;
	ConfigFacade* _tmp12_ = NULL;
	GdkRGBA _tmp13_ = {0};
	ConfigFacade* _tmp14_ = NULL;
	ConfigFacade* _tmp15_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (view), NULL);
#line 878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = view;
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->view = _tmp1_;
#line 881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = view;
#line 884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
#line 885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = view;
#line 885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
#line 886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = view;
#line 886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
#line 887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = view;
#line 887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
#line 888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = view;
#line 888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = view;
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp7_, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
#line 890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = view;
#line 890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp8_, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = view;
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp9_, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
#line 892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = view;
#line 892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp10_, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = config_facade_get_instance ();
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_;
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp12_, &_tmp13_);
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp12_);
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = config_facade_get_instance ();
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_;
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp15_, "colors-changed", (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self, 0);
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp15_);
#line 899 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 5943 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_new (ViewCollection* view) {
#line 878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
#line 5950 "CheckerboardLayout.c"
}


void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	GtkContainer* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (hadjustment));
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (vadjustment));
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = hadjustment;
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = _tmp1_;
#line 931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = vadjustment;
#line 931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = _tmp3_;
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = hadjustment;
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = vadjustment;
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_;
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
#line 5999 "CheckerboardLayout.c"
}


void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale) {
	gint _tmp0_ = 0;
#line 943 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 944 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 944 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = _tmp0_;
#line 6011 "CheckerboardLayout.c"
}


gint checkerboard_layout_get_scale (CheckerboardLayout* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 948 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->scale;
#line 948 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 948 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6026 "CheckerboardLayout.c"
}


void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 951 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 951 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp1_;
#line 6045 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self) {
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL, &_tmp0_);
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	req = _tmp0_;
#line 960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), &_tmp3_);
#line 960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	parent_allocation = _tmp3_;
#line 962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->message;
#line 962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ == NULL) {
#line 6076 "CheckerboardLayout.c"
		GtkRequisition _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = req;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.height;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != 0) {
#line 6085 "CheckerboardLayout.c"
			GtkAllocation _tmp7_ = {0};
			gint _tmp8_ = 0;
			GtkRequisition _tmp9_ = {0};
			gint _tmp10_ = 0;
#line 972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = parent_allocation;
#line 972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_.width;
#line 972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = req;
#line 972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp9_.height;
#line 972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_ - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp10_);
#line 6100 "CheckerboardLayout.c"
		}
	} else {
		GtkAllocation _tmp11_ = {0};
		gint _tmp12_ = 0;
		GtkAllocation _tmp13_ = {0};
		gint _tmp14_ = 0;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = parent_allocation;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.width;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = parent_allocation;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_.height;
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp12_, _tmp14_);
#line 6117 "CheckerboardLayout.c"
	}
#line 981 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->size_allocate_due_to_reflow;
#line 983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp15_) {
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_clear_anchor (self);
#line 6127 "CheckerboardLayout.c"
	} else {
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = FALSE;
#line 6131 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self) {
#line 989 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 991 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
#line 993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6145 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self) {
#line 996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6154 "CheckerboardLayout.c"
}


static void checkerboard_layout_clear_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
#line 1000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 1001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6168 "CheckerboardLayout.c"
	}
#line 1004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 1004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 6174 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp1_ = {0};
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAdjustment* _tmp21_ = NULL;
	gdouble _tmp22_ = 0.0;
	GeeList* _tmp23_ = NULL;
	GeeList* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gpointer _tmp27_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (!_tmp0_, "!in_center_on_anchor");
#line 1010 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->visible_page;
#line 1010 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_intersection (self, &_tmp1_);
#line 1010 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items_on_page = _tmp2_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = items_on_page;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_ == 0) {
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6221 "CheckerboardLayout.c"
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _item_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _item_index = 0;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = items_on_page;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp7_;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _item_list;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp10_;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6250 "CheckerboardLayout.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			CheckerboardItem* item = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			CheckerboardItem* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_index;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp11_ + 1;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _item_size;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 6272 "CheckerboardLayout.c"
			}
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = _item_list;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _item_index;
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp16_;
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_) {
#line 6288 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_ = NULL;
				CheckerboardItem* _tmp20_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (self->priv->anchor);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				self->priv->anchor = _tmp20_;
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_item_list);
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (items_on_page);
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 6307 "CheckerboardLayout.c"
			}
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 6311 "CheckerboardLayout.c"
		}
#line 1016 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 6315 "CheckerboardLayout.c"
	}
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 1023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp22_ == ((gdouble) 0)) {
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6331 "CheckerboardLayout.c"
	}
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = items_on_page;
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = items_on_page;
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_;
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = gee_list_get (_tmp23_, ((gint) _tmp26_) / 2);
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = (CheckerboardItem*) _tmp27_;
#line 1007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items_on_page);
#line 6349 "CheckerboardLayout.c"
}


static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper) {
	CheckerboardItem* _tmp0_ = NULL;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	CheckerboardItem* _tmp4_ = NULL;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkAdjustment* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GtkAdjustment* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	GtkAdjustment* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	GtkAdjustment* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	GtkAdjustment* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
#line 1033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->anchor;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 1035 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6381 "CheckerboardLayout.c"
	}
#line 1037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = TRUE;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->anchor;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_->allocation;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->anchor;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_->allocation;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->vadjustment;
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	anchor_pos = (_tmp3_ + (_tmp6_ / 2)) - (_tmp8_ / 2);
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = anchor_pos;
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->vadjustment;
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = gtk_adjustment_get_lower (_tmp11_);
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->vadjustment;
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_adjustment_get_upper (_tmp13_);
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->vadjustment;
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = gtk_adjustment_get_page_size (_tmp15_);
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = CLAMP (_tmp10_, _tmp12_, _tmp14_ - _tmp16_);
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_adjustment_set_value (_tmp9_, _tmp17_);
#line 1044 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 6425 "CheckerboardLayout.c"
}


void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item) {
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp0_ = NULL;
	CheckerboardItem* _tmp1_ = NULL;
	CheckerboardItem* _tmp8_ = NULL;
	CheckerboardItem* _tmp9_ = NULL;
	CheckerboardItem* _tmp10_ = NULL;
	GeeHashSet* _tmp11_ = NULL;
	CheckerboardItem* _tmp12_ = NULL;
	GeeHashSet* _tmp13_ = NULL;
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (item));
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	collection = _tmp0_;
#line 1049 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->cursor;
#line 1049 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6451 "CheckerboardLayout.c"
		CheckerboardItem* _tmp2_ = NULL;
		ViewCollection* _tmp3_ = NULL;
		CheckerboardItem* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1050 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->cursor;
#line 1050 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_is_cursor (_tmp2_, FALSE);
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->view;
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->cursor;
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp5_) {
#line 6468 "CheckerboardLayout.c"
			GeeHashSet* _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = collection;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = self->priv->cursor;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
#line 6477 "CheckerboardLayout.c"
		}
	}
#line 1056 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item;
#line 1056 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_is_cursor (_tmp8_, TRUE);
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = item;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = _tmp10_;
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = collection;
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = item;
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_VIEW, DataView));
#line 1059 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = collection;
#line 1059 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (collection);
#line 6504 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self) {
	CheckerboardItem* result = NULL;
	CheckerboardItem* _tmp0_ = NULL;
	CheckerboardItem* _tmp1_ = NULL;
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->cursor;
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1063 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6522 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed) {
	GeeIterable* _tmp0_ = NULL;
	GeeIterable* _tmp1_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = added;
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1070 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (self->priv->message);
#line 1070 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->message = NULL;
#line 6543 "CheckerboardLayout.c"
	}
#line 1072 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = removed;
#line 1072 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6549 "CheckerboardLayout.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp2_ = NULL;
			GeeIterator* _tmp3_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = removed;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_object_it = _tmp3_;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 6562 "CheckerboardLayout.c"
				GeeIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp6_ = NULL;
				gpointer _tmp7_ = NULL;
				GeeHashSet* _tmp8_ = NULL;
				DataObject* _tmp9_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = _object_it;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = gee_iterator_next (_tmp4_);
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp5_) {
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6578 "CheckerboardLayout.c"
				}
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _object_it;
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = gee_iterator_get (_tmp6_);
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				object = (DataObject*) _tmp7_;
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = self->priv->exposed_items;
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = object;
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (object);
#line 6594 "CheckerboardLayout.c"
			}
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_object_it);
#line 6598 "CheckerboardLayout.c"
		}
	}
#line 1079 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1079 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1079 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1079 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1081 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_contents_altered");
#line 6611 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_altered (CheckerboardLayout* self) {
#line 1084 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1085 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_altered");
#line 6620 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed) {
	GeeIterable* _tmp0_ = NULL;
#line 1088 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1088 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1089 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = changed;
#line 1089 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_items_state_changed", _tmp0_);
#line 6634 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed) {
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1093 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
#line 6645 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self) {
#line 1096 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
#line 6654 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered) {
	GeeCollection* _tmp0_ = NULL;
#line 1100 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1100 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_COLLECTION (altered));
#line 1101 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = altered;
#line 1101 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_views_altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 6668 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self) {
#line 1104 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1105 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
#line 6677 "CheckerboardLayout.c"
}


static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self) {
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
#line 1121 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6686 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1108 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1108 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1109 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->flow_scheduled;
#line 1109 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1110 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6703 "CheckerboardLayout.c"
	}
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->is_in_view;
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp1_) {
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->reflow_needed = TRUE;
#line 1114 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6713 "CheckerboardLayout.c"
	}
#line 1120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = TRUE;
#line 1121 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
#line 6719 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self) {
	gboolean result = FALSE;
#line 1124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_reflow (self, "do_reflow");
#line 1126 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "do_reflow");
#line 1128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 1130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6737 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller) {
#line 1133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 1138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 6750 "CheckerboardLayout.c"
}


void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6770 "CheckerboardLayout.c"
	}
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = text;
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = _tmp3_;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = text;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 6784 "CheckerboardLayout.c"
		GtkContainer* _tmp5_ = NULL;
		GtkContainer* _tmp6_ = NULL;
#line 1150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_;
#line 1150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != NULL) {
#line 6793 "CheckerboardLayout.c"
			GtkAllocation parent_allocation = {0};
			GtkContainer* _tmp7_ = NULL;
			GtkContainer* _tmp8_ = NULL;
			GtkAllocation _tmp9_ = {0};
			GtkAllocation _tmp10_ = {0};
			gint _tmp11_ = 0;
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_;
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), &_tmp9_);
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			parent_allocation = _tmp9_;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = parent_allocation;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _tmp10_.width;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = parent_allocation;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_.height;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_, _tmp13_);
#line 6820 "CheckerboardLayout.c"
		}
	} else {
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, "set_message");
#line 6825 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_unset_message (CheckerboardLayout* self) {
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_message (self, NULL);
#line 6835 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_visible_page (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_ = NULL;
#line 1166 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->hadjustment;
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6848 "CheckerboardLayout.c"
		GtkAdjustment* _tmp2_ = NULL;
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->vadjustment;
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 6854 "CheckerboardLayout.c"
	} else {
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 6858 "CheckerboardLayout.c"
	}
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 6862 "CheckerboardLayout.c"
		GtkAdjustment* _tmp3_ = NULL;
		GtkAdjustment* _tmp4_ = NULL;
		GdkRectangle _tmp5_ = {0};
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->hadjustment;
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->vadjustment;
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->visible_page = _tmp5_;
#line 6874 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = in_view;
#line 1172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = _tmp0_;
#line 1174 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = in_view;
#line 1174 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 6892 "CheckerboardLayout.c"
		gboolean _tmp2_ = FALSE;
#line 1175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->reflow_needed;
#line 1175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp2_) {
#line 1176 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
#line 6900 "CheckerboardLayout.c"
		} else {
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
#line 6904 "CheckerboardLayout.c"
		}
	} else {
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
#line 6909 "CheckerboardLayout.c"
	}
}


static gpointer _checkerboard_layout_layout_row_ref0 (gpointer self) {
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
#line 6917 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd) {
	CheckerboardItem* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gint x = 0;
	gdouble _tmp3_ = 0.0;
	gint y = 0;
	gdouble _tmp4_ = 0.0;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	CheckerboardLayoutLayoutRow* _tmp30_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp31_ = NULL;
	CheckerboardItem** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 6946 "CheckerboardLayout.c"
	} else {
		CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->item_rows;
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2__length1 = self->priv->item_rows_length1;
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 6956 "CheckerboardLayout.c"
	}
#line 1184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1185 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1185 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6964 "CheckerboardLayout.c"
	}
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = xd;
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = (gint) _tmp3_;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = yd;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = (gint) _tmp4_;
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	in_range = NULL;
#line 1192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	min = 0;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->item_rows;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5__length1 = self->priv->item_rows_length1;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max = _tmp5__length1;
#line 6984 "CheckerboardLayout.c"
	{
		gboolean _tmp6_ = FALSE;
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = TRUE;
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6991 "CheckerboardLayout.c"
			gint mid = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			CheckerboardLayoutLayoutRow* _tmp12_ = NULL;
			CheckerboardLayoutLayoutRow* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp15_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp6_) {
#line 7008 "CheckerboardLayout.c"
			}
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = FALSE;
#line 1195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = min;
#line 1195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = max;
#line 1195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = min;
#line 1195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			mid = _tmp7_ + ((_tmp8_ - _tmp9_) / 2);
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->item_rows;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10__length1 = self->priv->item_rows_length1;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = mid;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _tmp10_[_tmp11_];
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _checkerboard_layout_layout_row_ref0 (_tmp12_);
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp13_;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp15_ == NULL) {
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = TRUE;
#line 7038 "CheckerboardLayout.c"
			} else {
				gint _tmp16_ = 0;
				CheckerboardLayoutLayoutRow* _tmp17_ = NULL;
				gint _tmp18_ = 0;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = y;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp16_ < _tmp18_;
#line 7051 "CheckerboardLayout.c"
			}
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp14_) {
#line 7055 "CheckerboardLayout.c"
				gint _tmp19_ = 0;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = mid;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max = _tmp19_ - 1;
#line 7061 "CheckerboardLayout.c"
			} else {
				gint _tmp20_ = 0;
				CheckerboardLayoutLayoutRow* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				CheckerboardLayoutLayoutRow* _tmp23_ = NULL;
				gint _tmp24_ = 0;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = y;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->y;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = _tmp23_->height;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp20_ > (_tmp22_ + _tmp24_)) {
#line 7080 "CheckerboardLayout.c"
					gint _tmp25_ = 0;
#line 1204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = mid;
#line 1204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					min = _tmp25_ + 1;
#line 7086 "CheckerboardLayout.c"
				} else {
					CheckerboardLayoutLayoutRow* _tmp26_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp27_ = NULL;
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _checkerboard_layout_layout_row_ref0 (_tmp26_);
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					in_range = _tmp27_;
#line 1209 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1209 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7102 "CheckerboardLayout.c"
				}
			}
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = min;
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = max;
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp28_ > _tmp29_) {
#line 1213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 1213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 7115 "CheckerboardLayout.c"
			}
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_checkerboard_layout_layout_row_unref0 (row);
#line 7119 "CheckerboardLayout.c"
		}
	}
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = in_range;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp30_ == NULL) {
#line 1217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (in_range);
#line 1217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7132 "CheckerboardLayout.c"
	}
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = in_range;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_->items;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32__length1 = _tmp31_->items_length1;
#line 7140 "CheckerboardLayout.c"
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection = _tmp32_;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection_length1 = _tmp32__length1;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (item_it = 0; item_it < _tmp32__length1; item_it = item_it + 1) {
#line 7152 "CheckerboardLayout.c"
			CheckerboardItem* _tmp33_ = NULL;
			CheckerboardItem* item = NULL;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp33_ = _g_object_ref0 (item_collection[item_it]);
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp33_;
#line 7159 "CheckerboardLayout.c"
			{
				CheckerboardItem* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				CheckerboardItem* _tmp36_ = NULL;
				GdkRectangle _tmp37_ = {0};
				gint _tmp38_ = 0;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_ = 0;
				CheckerboardItem* _tmp42_ = NULL;
				GdkRectangle _tmp43_ = {0};
				gint _tmp44_ = 0;
				CheckerboardItem* _tmp45_ = NULL;
				GdkRectangle _tmp46_ = {0};
				gint _tmp47_ = 0;
#line 1223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp34_ = item;
#line 1223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp34_ == NULL) {
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 7183 "CheckerboardLayout.c"
				}
#line 1226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = x;
#line 1226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = item;
#line 1226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp37_ = _tmp36_->allocation;
#line 1226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp38_ = _tmp37_.x;
#line 1226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp35_ < _tmp38_) {
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7199 "CheckerboardLayout.c"
				}
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp41_ = x;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp42_ = item;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp43_ = _tmp42_->allocation;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp44_ = _tmp43_.x;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp45_ = item;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp46_ = _tmp45_->allocation;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp47_ = _tmp46_.width;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp41_ <= (_tmp44_ + _tmp47_)) {
#line 7217 "CheckerboardLayout.c"
					gint _tmp48_ = 0;
					CheckerboardItem* _tmp49_ = NULL;
					GdkRectangle _tmp50_ = {0};
					gint _tmp51_ = 0;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = y;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = item;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp50_ = _tmp49_->allocation;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp51_ = _tmp50_.y;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = _tmp48_ >= _tmp51_;
#line 7232 "CheckerboardLayout.c"
				} else {
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = FALSE;
#line 7236 "CheckerboardLayout.c"
				}
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp40_) {
#line 7240 "CheckerboardLayout.c"
					gint _tmp52_ = 0;
					CheckerboardItem* _tmp53_ = NULL;
					GdkRectangle _tmp54_ = {0};
					gint _tmp55_ = 0;
					CheckerboardItem* _tmp56_ = NULL;
					GdkRectangle _tmp57_ = {0};
					gint _tmp58_ = 0;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp52_ = y;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp53_ = item;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = _tmp53_->allocation;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = _tmp54_.y;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = item;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = _tmp56_->allocation;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = _tmp57_.height;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = _tmp52_ <= (_tmp55_ + _tmp58_);
#line 7264 "CheckerboardLayout.c"
				} else {
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = FALSE;
#line 7268 "CheckerboardLayout.c"
				}
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp39_) {
#line 1235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					result = item;
#line 1235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					return result;
#line 7278 "CheckerboardLayout.c"
				}
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 7282 "CheckerboardLayout.c"
			}
		}
	}
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (in_range);
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7292 "CheckerboardLayout.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 7310 "CheckerboardLayout.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 7333 "CheckerboardLayout.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 7341 "CheckerboardLayout.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 7353 "CheckerboardLayout.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 7377 "CheckerboardLayout.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 7383 "CheckerboardLayout.c"
	} else {
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 7387 "CheckerboardLayout.c"
	}
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 7391 "CheckerboardLayout.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 7403 "CheckerboardLayout.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 7413 "CheckerboardLayout.c"
	}
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 7419 "CheckerboardLayout.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 7433 "CheckerboardLayout.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 7443 "CheckerboardLayout.c"
	}
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 7449 "CheckerboardLayout.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 7458 "CheckerboardLayout.c"
	}
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 7478 "CheckerboardLayout.c"
}


gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list, gint pos) {
	gint result = 0;
	gint sep_len = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint len = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gint index = 0;
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (tag_list != NULL, 0);
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = strlen (TAG_TAG_LIST_SEPARATOR_STRING);
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	sep_len = _tmp1_;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = sep_len;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "sep_len > 0");
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = tag_list;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = strlen (_tmp3_);
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	len = _tmp5_;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = pos;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ < 0) {
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = TRUE;
#line 7521 "CheckerboardLayout.c"
	} else {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = pos;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = len;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp8_ >= _tmp9_;
#line 7531 "CheckerboardLayout.c"
	}
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7539 "CheckerboardLayout.c"
	}
	{
		gint i = 0;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7545 "CheckerboardLayout.c"
		{
			gboolean _tmp10_ = FALSE;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = TRUE;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7552 "CheckerboardLayout.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gchar _tmp17_ = '\0';
				gint _tmp18_ = 0;
				gchar _tmp19_ = '\0';
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp10_) {
#line 7563 "CheckerboardLayout.c"
					gint _tmp11_ = 0;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp11_ = i;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp11_ + 1;
#line 7569 "CheckerboardLayout.c"
				}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = FALSE;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = i;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = sep_len;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp12_ < _tmp13_)) {
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7581 "CheckerboardLayout.c"
				}
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = tag_list;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = pos;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = string_get (_tmp15_, (glong) _tmp16_);
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = i;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) _tmp18_);
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp17_ == _tmp19_) {
#line 7595 "CheckerboardLayout.c"
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = pos;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp21_ = i;
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp14_ = _tmp20_ >= _tmp21_;
#line 7604 "CheckerboardLayout.c"
				} else {
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp14_ = FALSE;
#line 7608 "CheckerboardLayout.c"
				}
#line 1250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp14_) {
#line 7612 "CheckerboardLayout.c"
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp22_ = tag_list;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = pos;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = i;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = sep_len;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = string_substring (_tmp22_, (glong) (_tmp23_ - _tmp24_), (glong) _tmp25_);
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = g_strcmp0 (_tmp27_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp27_);
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (_tmp28_) {
#line 1252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						result = -1;
#line 1252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						return result;
#line 7642 "CheckerboardLayout.c"
					}
				}
			}
		}
	}
#line 1259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = 0;
#line 7650 "CheckerboardLayout.c"
	{
		gint i = 0;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7655 "CheckerboardLayout.c"
		{
			gboolean _tmp29_ = FALSE;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = TRUE;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7662 "CheckerboardLayout.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gchar _tmp38_ = '\0';
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp29_) {
#line 7673 "CheckerboardLayout.c"
					gint _tmp30_ = 0;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp30_ = i;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp30_ + 1;
#line 7679 "CheckerboardLayout.c"
				}
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = FALSE;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = i;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = pos;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp31_ < _tmp32_)) {
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7691 "CheckerboardLayout.c"
				}
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = tag_list;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = i;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp38_ = string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) 0);
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp37_ == _tmp38_) {
#line 7703 "CheckerboardLayout.c"
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = i;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = sep_len;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = len;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp34_ = (_tmp39_ + _tmp40_) <= _tmp41_;
#line 7715 "CheckerboardLayout.c"
				} else {
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp34_ = FALSE;
#line 7719 "CheckerboardLayout.c"
				}
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp34_) {
#line 7723 "CheckerboardLayout.c"
					const gchar* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = tag_list;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = i;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = sep_len;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = string_substring (_tmp42_, (glong) _tmp43_, (glong) _tmp44_);
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = _tmp45_;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = g_strcmp0 (_tmp46_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp46_);
#line 7743 "CheckerboardLayout.c"
				} else {
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = FALSE;
#line 7747 "CheckerboardLayout.c"
				}
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp33_) {
#line 7751 "CheckerboardLayout.c"
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = index;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					index = _tmp47_ + 1;
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = i;
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = sep_len;
#line 1265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp48_ + (_tmp49_ - 1);
#line 7765 "CheckerboardLayout.c"
				}
			}
		}
	}
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = index;
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7774 "CheckerboardLayout.c"
}


static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y) {
	gint result = 0;
	PangoLayout* layout = NULL;
	CheckerboardItem* _tmp0_ = NULL;
	PangoLayout* _tmp1_ = NULL;
	PangoLayout* _tmp2_ = NULL;
	GdkRectangle rect = {0};
	CheckerboardItem* _tmp3_ = NULL;
	GdkRectangle _tmp4_ = {0};
	gint index = 0;
	gint trailing = 0;
	gint px = 0;
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint py = 0;
	gint _tmp8_ = 0;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	PangoLayout* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
#line 1271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 1271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), 0);
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = item;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_get_tag_list_layout (_tmp0_);
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	layout = _tmp1_;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = layout;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == NULL) {
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7823 "CheckerboardLayout.c"
	}
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = item;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_get_subtitle_allocation (_tmp3_, &_tmp4_);
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rect = _tmp4_;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = x;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = rect;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.x;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	px = (_tmp5_ - _tmp7_) * PANGO_SCALE;
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = y;
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = rect;
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _tmp9_.y;
#line 1278 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	py = (_tmp8_ - _tmp10_) * PANGO_SCALE;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = layout;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = px;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = py;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = pango_layout_xy_to_index (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_tmp15_);
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = _tmp14_;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trailing = _tmp15_;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_) {
#line 7861 "CheckerboardLayout.c"
		PangoLayout* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = layout;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = pango_layout_get_text (_tmp17_);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = index;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = checkerboard_layout_get_tag_index_at_pos (_tmp18_, _tmp19_);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp20_;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7880 "CheckerboardLayout.c"
	}
#line 1281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = -1;
#line 1281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (layout);
#line 1281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7888 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y, GdkModifierType mask) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	CheckerboardItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint tag_index = 0;
	CheckerboardItem* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	CheckerboardItem* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = item;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_item_get_has_tags (_tmp1_);
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 7920 "CheckerboardLayout.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = checkerboard_layout_is_drag_select_active (self);
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 7927 "CheckerboardLayout.c"
	}
#line 1285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7935 "CheckerboardLayout.c"
	}
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = item;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = x;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = y;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = checkerboard_layout_internal_handle_tag_mouse_event (self, _tmp5_, _tmp6_, _tmp7_);
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = _tmp8_;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = item;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = tag_index;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_highlight_user_visible_tag (_tmp9_, _tmp10_);
#line 1289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = tag_index;
#line 1289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp11_ >= 0;
#line 1289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7959 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self, CheckerboardItem* item, gdouble xd, gdouble yd, GdkModifierType mask) {
	gboolean result = FALSE;
	gint tag_index = 0;
	CheckerboardItem* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = item;
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = xd;
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = round (_tmp1_);
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = yd;
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = round (_tmp3_);
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_layout_internal_handle_tag_mouse_event (self, _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
#line 1293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = _tmp5_;
#line 1294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = tag_index;
#line 1294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ >= 0) {
#line 7995 "CheckerboardLayout.c"
		Tag* tag = NULL;
		CheckerboardItem* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		Tag* _tmp9_ = NULL;
		LibraryWindow* _tmp10_ = NULL;
		LibraryWindow* _tmp11_ = NULL;
		Tag* _tmp12_ = NULL;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = item;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = tag_index;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_get_user_visible_tag (_tmp7_, _tmp8_);
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		tag = _tmp9_;
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = library_window_get_app ();
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp10_;
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = tag;
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		library_window_switch_to_tag (_tmp11_, _tmp12_);
#line 1296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp11_);
#line 1297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = TRUE;
#line 1297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (tag);
#line 1297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8027 "CheckerboardLayout.c"
	}
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8033 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_ = {0};
	GeeList* _tmp1_ = NULL;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8051 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area) {
	GeeList* result = NULL;
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (area != NULL, NULL);
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	intersects = _tmp0_;
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&bitbucket, 0, sizeof (GdkRectangle));
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 8082 "CheckerboardLayout.c"
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection = _tmp2_;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection_length1 = _tmp2__length1;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (row_it = 0; row_it < _tmp2__length1; row_it = row_it + 1) {
#line 8094 "CheckerboardLayout.c"
			CheckerboardLayoutLayoutRow* _tmp3_ = NULL;
			CheckerboardLayoutLayoutRow* row = NULL;
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp3_;
#line 8101 "CheckerboardLayout.c"
			{
				CheckerboardLayoutLayoutRow* _tmp4_ = NULL;
				GdkRectangle _tmp5_ = {0};
				gint _tmp6_ = 0;
				GdkRectangle _tmp7_ = {0};
				gint _tmp8_ = 0;
				CheckerboardLayoutLayoutRow* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				CheckerboardLayoutLayoutRow* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				CheckerboardLayoutLayoutRow* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				GdkRectangle _tmp15_ = {0};
				gint _tmp16_ = 0;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GtkAllocation _tmp19_ = {0};
				gint _tmp20_ = 0;
				CheckerboardLayoutLayoutRow* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				GdkRectangle _tmp23_ = {0};
				GdkRectangle _tmp24_ = {0};
				gboolean _tmp25_ = FALSE;
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = row;
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp4_ == NULL) {
#line 1315 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1315 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 8134 "CheckerboardLayout.c"
				}
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *area;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _tmp5_.y;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = *area;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = _tmp7_.height;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = row;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = _tmp9_->y;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp6_ + _tmp8_) < _tmp10_) {
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 8154 "CheckerboardLayout.c"
				}
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp11_ = row;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = _tmp11_->y;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = row;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp13_->height;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = *area;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _tmp15_.y;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp12_ + _tmp14_) < _tmp16_) {
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 8174 "CheckerboardLayout.c"
				}
#line 1328 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				memset (&row_rect, 0, sizeof (GdkRectangle));
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.x = 0;
#line 1330 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1330 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1330 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.y = _tmp18_;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = allocation;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _tmp19_.width;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.width = _tmp20_;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->height;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.height = _tmp22_;
#line 1334 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row_rect;
#line 1334 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = gdk_rectangle_intersect (area, &_tmp23_, &_tmp24_);
#line 1334 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				bitbucket = _tmp24_;
#line 1334 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_) {
#line 8206 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp26_ = NULL;
					CheckerboardItem** _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_->items;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27__length1 = _tmp26_->items_length1;
#line 8216 "CheckerboardLayout.c"
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection = _tmp27_;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection_length1 = _tmp27__length1;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						for (item_it = 0; item_it < _tmp27__length1; item_it = item_it + 1) {
#line 8228 "CheckerboardLayout.c"
							CheckerboardItem* _tmp28_ = NULL;
							CheckerboardItem* item = NULL;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp28_ = _g_object_ref0 (item_collection[item_it]);
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							item = _tmp28_;
#line 8235 "CheckerboardLayout.c"
							{
								CheckerboardItem* _tmp29_ = NULL;
								CheckerboardItem* _tmp30_ = NULL;
								GdkRectangle _tmp31_ = {0};
								GdkRectangle _tmp32_ = {0};
								gboolean _tmp33_ = FALSE;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp29_ = item;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp29_ == NULL) {
#line 1338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_g_object_unref0 (item);
#line 1338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									continue;
#line 8250 "CheckerboardLayout.c"
								}
#line 1340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp30_ = item;
#line 1340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp31_ = _tmp30_->allocation;
#line 1340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp33_ = gdk_rectangle_intersect (area, &_tmp31_, &_tmp32_);
#line 1340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								bitbucket = _tmp32_;
#line 1340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp33_) {
#line 8262 "CheckerboardLayout.c"
									GeeArrayList* _tmp34_ = NULL;
									CheckerboardItem* _tmp35_ = NULL;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp34_ = intersects;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp35_ = item;
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp35_);
#line 8271 "CheckerboardLayout.c"
								}
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_g_object_unref0 (item);
#line 8275 "CheckerboardLayout.c"
							}
						}
					}
				}
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 8282 "CheckerboardLayout.c"
			}
		}
	}
#line 1346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (intersects, GEE_TYPE_LIST, GeeList);
#line 1346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8290 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point) {
	CheckerboardItem* result = NULL;
	ViewCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint col = 0;
	CheckerboardItem* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint row = 0;
	CheckerboardItem* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	CompassPoint _tmp14_ = 0;
	CheckerboardItem* new_item = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	CheckerboardItem* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	CheckerboardItem* _tmp39_ = NULL;
	CheckerboardItem* _tmp47_ = NULL;
	CheckerboardItem* _tmp48_ = NULL;
	CheckerboardItem* _tmp51_ = NULL;
#line 1349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), NULL);
#line 1350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 1350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == 0) {
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8332 "CheckerboardLayout.c"
	}
#line 1353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->columns;
#line 1353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "columns > 0");
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->rows;
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp3_ > 0, "rows > 0");
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_get_column (_tmp4_);
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = _tmp5_;
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item;
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = checkerboard_item_get_row (_tmp6_);
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = _tmp7_;
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = col;
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ < 0) {
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = TRUE;
#line 8360 "CheckerboardLayout.c"
	} else {
		gint _tmp10_ = 0;
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = row;
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_ < 0;
#line 8367 "CheckerboardLayout.c"
	}
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 8371 "CheckerboardLayout.c"
		CheckerboardItem* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = item;
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_get_title (_tmp11_);
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_critical ("CheckerboardLayout.vala:1360: Attempting to locate item not placed in " \
"layout: %s", _tmp13_);
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8389 "CheckerboardLayout.c"
	}
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = point;
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (_tmp14_) {
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_NORTH:
#line 8397 "CheckerboardLayout.c"
		{
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp15_ - 1;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = row;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ < 0) {
#line 1368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 8411 "CheckerboardLayout.c"
			}
#line 1369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8415 "CheckerboardLayout.c"
		}
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_SOUTH:
#line 8419 "CheckerboardLayout.c"
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = row;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp17_ + 1;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = row;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp19_ = self->priv->rows;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_ >= _tmp19_) {
#line 8434 "CheckerboardLayout.c"
				gint _tmp20_ = 0;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = self->priv->rows;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp20_ - 1;
#line 8440 "CheckerboardLayout.c"
			}
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8444 "CheckerboardLayout.c"
		}
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_EAST:
#line 8448 "CheckerboardLayout.c"
		{
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = col;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp21_ + 1;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = col;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = self->priv->columns;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp22_ >= _tmp23_) {
#line 8463 "CheckerboardLayout.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 1378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = row;
#line 1378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp24_ + 1;
#line 1378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = row;
#line 1378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = self->priv->rows;
#line 1378 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_ >= _tmp26_) {
#line 8477 "CheckerboardLayout.c"
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = self->priv->rows;
#line 1379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp27_ - 1;
#line 1380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = self->priv->columns;
#line 1380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp28_ - 1;
#line 8488 "CheckerboardLayout.c"
				} else {
#line 1382 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8492 "CheckerboardLayout.c"
				}
			}
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8497 "CheckerboardLayout.c"
		}
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_WEST:
#line 8501 "CheckerboardLayout.c"
		{
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = col;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp29_ - 1;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp30_ = col;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp30_ < 0) {
#line 8513 "CheckerboardLayout.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = row;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp31_ - 1;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = row;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp32_ < 0) {
#line 1390 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = 0;
#line 1391 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8528 "CheckerboardLayout.c"
				} else {
					gint _tmp33_ = 0;
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = self->priv->columns;
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp33_ - 1;
#line 8535 "CheckerboardLayout.c"
				}
			}
#line 1396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8540 "CheckerboardLayout.c"
		}
		default:
		{
			CompassPoint _tmp34_ = 0;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp34_ = point;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			g_error ("CheckerboardLayout.vala:1399: Bad compass point %d", (gint) _tmp34_);
#line 8549 "CheckerboardLayout.c"
		}
	}
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = col;
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = row;
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = checkerboard_layout_get_item_at_coordinate (self, _tmp35_, _tmp36_);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_item = _tmp37_;
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = new_item;
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp39_ == NULL) {
#line 8564 "CheckerboardLayout.c"
		CompassPoint _tmp40_ = 0;
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = point;
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = _tmp40_ == COMPASS_POINT_SOUTH;
#line 8570 "CheckerboardLayout.c"
	} else {
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = FALSE;
#line 8574 "CheckerboardLayout.c"
	}
#line 1404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp38_) {
#line 8578 "CheckerboardLayout.c"
		ViewCollection* _tmp41_ = NULL;
		DataView* _tmp42_ = NULL;
		CheckerboardItem* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		CheckerboardItem* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = self->priv->view;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = view_collection_get_last (_tmp41_);
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (new_item);
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = new_item;
#line 1407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = checkerboard_item_get_row (_tmp43_);
#line 1407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = item;
#line 1407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = checkerboard_item_get_row (_tmp45_);
#line 1407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp44_ <= _tmp46_) {
#line 1408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (new_item);
#line 1408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			new_item = NULL;
#line 8607 "CheckerboardLayout.c"
		}
	}
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = new_item;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp48_ != NULL) {
#line 8614 "CheckerboardLayout.c"
		CheckerboardItem* _tmp49_ = NULL;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = new_item;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp49_;
#line 8620 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp50_ = NULL;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = item;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp50_;
#line 8627 "CheckerboardLayout.c"
	}
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = _g_object_ref0 (_tmp47_);
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp51_;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_item);
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8637 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row) {
	CheckerboardItem* result = NULL;
	gint _tmp0_ = 0;
	CheckerboardLayoutLayoutRow** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	CheckerboardLayoutLayoutRow* _tmp4_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp5_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	CheckerboardLayoutLayoutRow* _tmp8_ = NULL;
	CheckerboardItem** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	CheckerboardLayoutLayoutRow* _tmp10_ = NULL;
	CheckerboardItem** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp12_ = 0;
	CheckerboardItem* _tmp13_ = NULL;
	CheckerboardItem* _tmp14_ = NULL;
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = row;
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->item_rows;
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1__length1 = self->priv->item_rows_length1;
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ >= _tmp1__length1) {
#line 1416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8677 "CheckerboardLayout.c"
	}
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = row;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _checkerboard_layout_layout_row_ref0 (_tmp4_);
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item_row = _tmp5_;
#line 1419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item_row;
#line 1419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8701 "CheckerboardLayout.c"
	}
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = col;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item_row;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_->items;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9__length1 = _tmp8_->items_length1;
#line 1422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ >= _tmp9__length1) {
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8719 "CheckerboardLayout.c"
	}
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = item_row;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_->items;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11__length1 = _tmp10_->items_length1;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = col;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp11_[_tmp12_];
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp14_;
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (item_row);
#line 1425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8739 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 1428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = _tmp4_;
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = _tmp8_;
#line 8782 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp9_ = {0};
	GdkPoint _tmp10_ = {0};
	GdkPoint _tmp11_ = {0};
	Box _tmp12_ = {0};
	GdkRectangle _tmp13_ = {0};
	GdkWindow* _tmp14_ = NULL;
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = _tmp4_;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = _tmp8_;
#line 1447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->selection_band;
#line 1447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_selection_band = _tmp9_;
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->drag_origin;
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->drag_endpoint;
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_from_points (&_tmp10_, &_tmp11_, &_tmp12_);
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_get_rectangle (&_tmp12_, &_tmp13_);
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selection_band = _tmp13_;
#line 1451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 8848 "CheckerboardLayout.c"
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp15_ = {0};
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		GdkRectangle _tmp19_ = {0};
		gint _tmp20_ = 0;
		GdkRectangle _tmp21_ = {0};
		gint _tmp22_ = 0;
		GdkRectangle _tmp23_ = {0};
		gint _tmp24_ = 0;
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = old_selection_band;
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_rectangle_union (&self->priv->selection_band, &_tmp15_, &_tmp16_);
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_union_ = _tmp16_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _union_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = _tmp17_.x;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _union_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.y;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = _union_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = _union_;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp18_, _tmp20_, _tmp22_, _tmp24_);
#line 8884 "CheckerboardLayout.c"
	}
}


GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_ = {0};
	GeeList* _tmp4_ = NULL;
#line 1459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->selection_band;
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = dimensions_has_area (&_tmp1_);
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp2_) {
#line 1461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8910 "CheckerboardLayout.c"
	}
#line 1463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->selection_band;
#line 1463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_layout_intersection (self, &_tmp3_);
#line 1463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 1463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8920 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
#line 1466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->drag_origin;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ >= 0) {
#line 8937 "CheckerboardLayout.c"
		GdkPoint _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->drag_origin;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.y;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ >= 0;
#line 8946 "CheckerboardLayout.c"
	} else {
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 8950 "CheckerboardLayout.c"
	}
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8956 "CheckerboardLayout.c"
}


void checkerboard_layout_clear_drag_select (CheckerboardLayout* self) {
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 1472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = -1;
#line 1473 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = -1;
#line 1474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = -1;
#line 1475 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = -1;
#line 1478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 8975 "CheckerboardLayout.c"
}


static void checkerboard_layout_viewport_resized (CheckerboardLayout* self) {
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 1486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 1486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->last_width;
#line 1486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != _tmp2_) {
#line 8995 "CheckerboardLayout.c"
		gint old_width = 0;
		gint _tmp3_ = 0;
		GdkRectangle _tmp4_ = {0};
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->last_width;
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		old_width = _tmp3_;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->visible_page;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_.width;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->last_width = _tmp5_;
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = old_width;
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->visible_page;
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = g_strdup_printf ("viewport_resized (%d -> %d)", _tmp6_, _tmp8_);
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, _tmp10_);
#line 1490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 9029 "CheckerboardLayout.c"
	} else {
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->last_width;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = g_strdup_printf ("viewport_resized (same width=%d)", _tmp11_);
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_exposure (self, _tmp13_);
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 9044 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller) {
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	GeeList* items = NULL;
	GeeList* _tmp2_ = NULL;
	GeeHashSet* _tmp27_ = NULL;
	GeeHashSet* _tmp28_ = NULL;
	ViewCollection* _tmp29_ = NULL;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_exposed_items = _tmp0_;
#line 1502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->view;
#line 1502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_visible_items (self);
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items = _tmp2_;
#line 9074 "CheckerboardLayout.c"
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_ = NULL;
		GeeList* _tmp4_ = NULL;
		gint _item_size = 0;
		GeeList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _item_index = 0;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = items;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp4_;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _item_list;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp7_;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9102 "CheckerboardLayout.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			GeeHashSet* _tmp14_ = NULL;
			CheckerboardItem* _tmp15_ = NULL;
			GeeHashSet* _tmp16_ = NULL;
			CheckerboardItem* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _item_index;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp8_ + 1;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = _item_index;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _item_size;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9127 "CheckerboardLayout.c"
			}
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp13_;
#line 1506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = new_exposed_items;
#line 1506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = item;
#line 1506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = self->priv->exposed_items;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp18_) {
#line 9151 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_ = NULL;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_exposed (_tmp19_);
#line 9157 "CheckerboardLayout.c"
			}
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9161 "CheckerboardLayout.c"
		}
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 9165 "CheckerboardLayout.c"
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp20_ = NULL;
		GeeIterator* _tmp21_ = NULL;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = self->priv->exposed_items;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp21_;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9179 "CheckerboardLayout.c"
			GeeIterator* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp24_ = NULL;
			gpointer _tmp25_ = NULL;
			CheckerboardItem* _tmp26_ = NULL;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = _item_it;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = gee_iterator_next (_tmp22_);
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp23_) {
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9194 "CheckerboardLayout.c"
			}
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _item_it;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp25_ = gee_iterator_get (_tmp24_);
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp25_;
#line 1515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = item;
#line 1515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp26_);
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9208 "CheckerboardLayout.c"
		}
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 9212 "CheckerboardLayout.c"
	}
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = new_exposed_items;
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp28_;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = self->priv->view;
#line 1524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_COLLECTION, DataCollection));
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items);
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_exposed_items);
#line 9232 "CheckerboardLayout.c"
}


static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller) {
	ViewCollection* _tmp0_ = NULL;
	GeeHashSet* _tmp8_ = NULL;
	ViewCollection* _tmp9_ = NULL;
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 9248 "CheckerboardLayout.c"
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->exposed_items;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp2_;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9261 "CheckerboardLayout.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _item_it;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp4_) {
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9276 "CheckerboardLayout.c"
			}
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = _item_it;
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp6_;
#line 1534 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = item;
#line 1534 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp7_);
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9290 "CheckerboardLayout.c"
		}
#line 1533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 9294 "CheckerboardLayout.c"
	}
#line 1536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->exposed_items;
#line 1536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->view;
#line 1542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection));
#line 9306 "CheckerboardLayout.c"
}


static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller) {
	const gchar* _tmp0_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint visible_width = 0;
	gint _tmp9_ = 0;
	gint total_items = 0;
	ViewCollection* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp15_ = FALSE;
	CheckerboardItem* _tmp16_ = NULL;
	gint max_cols = 0;
	gint _tmp19_ = 0;
	gint _tmp64_ = 0;
	gint max_rows = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint _tmp67_ = 0;
	gint* _tmp68_ = NULL;
	gint column_widths_length1 = 0;
	gint _column_widths_size_ = 0;
	gint* row_heights = NULL;
	gint _tmp69_ = 0;
	gint* _tmp70_ = NULL;
	gint row_heights_length1 = 0;
	gint _row_heights_size_ = 0;
	gint* alignment_points = NULL;
	gint _tmp71_ = 0;
	gint* _tmp72_ = NULL;
	gint alignment_points_length1 = 0;
	gint _alignment_points_size_ = 0;
	gint gutter = 0;
	gint _tmp183_ = 0;
	CheckerboardLayoutLayoutRow** _tmp184_ = NULL;
	gint x = 0;
	gint _tmp185_ = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp255_ = NULL;
	gint _tmp261_ = 0;
	gint _tmp262_ = 0;
	gint _tmp263_ = 0;
	gint _tmp264_ = 0;
	gint total_height = 0;
	gint _tmp265_ = 0;
	gint* _tmp266_ = NULL;
	gint _tmp266__length1 = 0;
	gint _tmp267_ = 0;
	gint _tmp268_ = 0;
	gboolean _tmp269_ = FALSE;
	gint _tmp270_ = 0;
	GtkAllocation _tmp271_ = {0};
	gint _tmp272_ = 0;
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1549 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 1552 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->message;
#line 1552 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9386 "CheckerboardLayout.c"
	}
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->visible_page;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ > 0) {
#line 9398 "CheckerboardLayout.c"
		GdkRectangle _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->visible_page;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.width;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp6_;
#line 9407 "CheckerboardLayout.c"
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = allocation;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp8_;
#line 9417 "CheckerboardLayout.c"
	}
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_width = _tmp2_;
#line 1566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = visible_width;
#line 1566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ <= 1) {
#line 1567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9427 "CheckerboardLayout.c"
	}
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_items = _tmp11_;
#line 1572 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = total_items;
#line 1572 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ == 0) {
#line 9439 "CheckerboardLayout.c"
		gint _tmp13_ = 0;
		CheckerboardLayoutLayoutRow** _tmp14_ = NULL;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = visible_width;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp13_, 0);
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = _tmp14_;
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows_length1 = 0;
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9458 "CheckerboardLayout.c"
	}
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->anchor;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_ == NULL) {
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = TRUE;
#line 9466 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->anchor;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = !_tmp18_;
#line 9476 "CheckerboardLayout.c"
	}
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_) {
#line 1585 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_update_anchor (self);
#line 9482 "CheckerboardLayout.c"
	}
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_cols = 0;
#line 1594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->scale;
#line 1594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_ > 0) {
#line 9498 "CheckerboardLayout.c"
		gint remaining_width = 0;
		gint _tmp20_ = 0;
		gint max_item_width = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 1596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = visible_width;
#line 1596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		remaining_width = _tmp20_ - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
#line 1597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->scale;
#line 1597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = checkerboard_item_get_max_width (_tmp21_);
#line 1597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_item_width = _tmp22_;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = remaining_width;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = max_item_width;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_cols = _tmp23_ / _tmp24_;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = max_cols;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp25_ <= 0) {
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = 1;
#line 9531 "CheckerboardLayout.c"
		}
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9535 "CheckerboardLayout.c"
			gboolean _tmp26_ = FALSE;
			gint _tmp27_ = 0;
			gint _tmp32_ = 0;
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp27_ = max_cols;
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_ > 1) {
#line 9543 "CheckerboardLayout.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = max_cols;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = max_item_width;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = max_cols;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = remaining_width;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ((_tmp28_ * _tmp29_) + ((_tmp30_ - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > _tmp31_;
#line 9558 "CheckerboardLayout.c"
			} else {
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = FALSE;
#line 9562 "CheckerboardLayout.c"
			}
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9568 "CheckerboardLayout.c"
			}
#line 1609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp32_ = max_cols;
#line 1609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp32_ - 1;
#line 9574 "CheckerboardLayout.c"
		}
#line 1613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = total_items;
#line 1613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = max_cols;
#line 1613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp33_ < _tmp34_) {
#line 9582 "CheckerboardLayout.c"
			gint _tmp35_ = 0;
#line 1614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp35_ = total_items;
#line 1614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp35_;
#line 9588 "CheckerboardLayout.c"
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		col = 0;
#line 1623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_width = 0;
#line 1624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		widest_row = 0;
#line 9605 "CheckerboardLayout.c"
		{
			gint ctr = 0;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			ctr = 0;
#line 9610 "CheckerboardLayout.c"
			{
				gboolean _tmp36_ = FALSE;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = TRUE;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				while (TRUE) {
#line 9617 "CheckerboardLayout.c"
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					DataObject* _tmp42_ = NULL;
					Dimensions req = {0};
					CheckerboardItem* _tmp43_ = NULL;
					Dimensions _tmp44_ = {0};
					gboolean _tmp45_ = FALSE;
					gint _tmp46_ = 0;
					Dimensions _tmp47_ = {0};
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp54_ = 0;
					Dimensions _tmp55_ = {0};
					gint _tmp56_ = 0;
					gint _tmp57_ = 0;
					Dimensions _tmp58_ = {0};
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!_tmp36_) {
#line 9641 "CheckerboardLayout.c"
						gint _tmp37_ = 0;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp37_ = ctr;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						ctr = _tmp37_ + 1;
#line 9647 "CheckerboardLayout.c"
					}
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp36_ = FALSE;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = ctr;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = total_items;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!(_tmp38_ < _tmp39_)) {
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						break;
#line 9659 "CheckerboardLayout.c"
					}
#line 1627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = self->priv->view;
#line 1627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = ctr;
#line 1627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_COLLECTION, DataCollection), _tmp41_);
#line 1627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = item;
#line 1628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = _tmp43_->requisition;
#line 1628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					req = _tmp44_;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = dimensions_has_area (&req);
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp45_, "req.has_area()");
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = x;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = req;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = _tmp47_.width;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = visible_width;
#line 1634 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (((_tmp46_ + _tmp48_) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > _tmp49_) {
#line 9689 "CheckerboardLayout.c"
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp50_ = row_width;
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp51_ = widest_row;
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp50_ > _tmp51_) {
#line 9698 "CheckerboardLayout.c"
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
#line 1636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp52_ = row_width;
#line 1636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest_row = _tmp52_;
#line 1637 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp53_ = col;
#line 1637 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							max_cols = _tmp53_;
#line 9709 "CheckerboardLayout.c"
						}
#line 1640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = 0;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						row_width = 0;
#line 9717 "CheckerboardLayout.c"
					}
#line 1645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = x;
#line 1645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = req;
#line 1645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = _tmp55_.width;
#line 1645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp54_ + (_tmp56_ + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING);
#line 1646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = row_width;
#line 1646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = req;
#line 1646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp59_ = _tmp58_.width;
#line 1646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row_width = _tmp57_ + _tmp59_;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp60_ = col;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp60_ + 1;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 9741 "CheckerboardLayout.c"
				}
			}
		}
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = row_width;
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = widest_row;
#line 1652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp61_ > _tmp62_) {
#line 9751 "CheckerboardLayout.c"
			gint _tmp63_ = 0;
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp63_ = col;
#line 1653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp63_;
#line 9757 "CheckerboardLayout.c"
		}
	}
#line 1661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = max_cols;
#line 1661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp64_ > 0, "max_cols > 0");
#line 1662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = total_items;
#line 1662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = max_cols;
#line 1662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_rows = (_tmp65_ / _tmp66_) + 1;
#line 1666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tallest = 0;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	widest = 0;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_alignment_point = 0;
#line 1670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_width = 0;
#line 1671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = max_cols;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = g_new0 (gint, _tmp67_);
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = _tmp68_;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths_length1 = _tmp67_;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_column_widths_size_ = column_widths_length1;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = max_rows;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = g_new0 (gint, _tmp69_);
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = _tmp70_;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights_length1 = _tmp69_;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_row_heights_size_ = row_heights_length1;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = max_rows;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = g_new0 (gint, _tmp71_);
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = _tmp72_;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points_length1 = _tmp71_;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_alignment_points_size_ = alignment_points_length1;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gutter = 0;
#line 9814 "CheckerboardLayout.c"
	{
		gboolean _tmp73_ = FALSE;
#line 1677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = TRUE;
#line 1677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9821 "CheckerboardLayout.c"
			gint _tmp129_ = 0;
			gint _tmp138_ = 0;
			gint _tmp139_ = 0;
			gint _tmp140_ = 0;
			gint _tmp141_ = 0;
			gint _tmp142_ = 0;
#line 1677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp73_) {
#line 9830 "CheckerboardLayout.c"
			}
#line 1677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp73_ = FALSE;
#line 9834 "CheckerboardLayout.c"
			{
				gint ctr = 0;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ctr = 0;
#line 9839 "CheckerboardLayout.c"
				{
					gboolean _tmp74_ = FALSE;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp74_ = TRUE;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					while (TRUE) {
#line 9846 "CheckerboardLayout.c"
						gint _tmp76_ = 0;
						gint _tmp77_ = 0;
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp78_ = NULL;
						gint _tmp79_ = 0;
						DataObject* _tmp80_ = NULL;
						Dimensions req = {0};
						CheckerboardItem* _tmp81_ = NULL;
						Dimensions _tmp82_ = {0};
						gint alignment_point = 0;
						CheckerboardItem* _tmp83_ = NULL;
						gint _tmp84_ = 0;
						gint _tmp85_ = 0;
						Dimensions _tmp86_ = {0};
						gint _tmp87_ = 0;
						Dimensions _tmp88_ = {0};
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						Dimensions _tmp93_ = {0};
						gint _tmp94_ = 0;
						gint _tmp95_ = 0;
						gint _tmp98_ = 0;
						gint _tmp99_ = 0;
						gint* _tmp101_ = NULL;
						gint _tmp101__length1 = 0;
						gint _tmp102_ = 0;
						gint _tmp103_ = 0;
						Dimensions _tmp104_ = {0};
						gint _tmp105_ = 0;
						gint _tmp118_ = 0;
						gint _tmp119_ = 0;
						gint _tmp120_ = 0;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!_tmp74_) {
#line 9881 "CheckerboardLayout.c"
							gint _tmp75_ = 0;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp75_ = ctr;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							ctr = _tmp75_ + 1;
#line 9887 "CheckerboardLayout.c"
						}
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp74_ = FALSE;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp76_ = ctr;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp77_ = total_items;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!(_tmp76_ < _tmp77_)) {
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							break;
#line 9899 "CheckerboardLayout.c"
						}
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp78_ = self->priv->view;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp79_ = ctr;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp80_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_DATA_COLLECTION, DataCollection), _tmp79_);
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp81_ = item;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp82_ = _tmp81_->requisition;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						req = _tmp82_;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp83_ = item;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp84_ = checkerboard_item_get_alignment_point (_tmp83_);
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						alignment_point = _tmp84_;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp85_ = alignment_point;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp86_ = req;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp87_ = _tmp86_.height;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_vala_assert (_tmp85_ < _tmp87_, "alignment_point < req.height");
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp88_ = req;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp89_ = _tmp88_.height;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp90_ = tallest;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp89_ > _tmp90_) {
#line 9937 "CheckerboardLayout.c"
							Dimensions _tmp91_ = {0};
							gint _tmp92_ = 0;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp91_ = req;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp92_ = _tmp91_.height;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = _tmp92_;
#line 9946 "CheckerboardLayout.c"
						}
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp93_ = req;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp94_ = _tmp93_.width;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp95_ = widest;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp94_ > _tmp95_) {
#line 9956 "CheckerboardLayout.c"
							Dimensions _tmp96_ = {0};
							gint _tmp97_ = 0;
#line 1690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp96_ = req;
#line 1690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp97_ = _tmp96_.width;
#line 1690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest = _tmp97_;
#line 9965 "CheckerboardLayout.c"
						}
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp98_ = alignment_point;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp99_ = row_alignment_point;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp98_ > _tmp99_) {
#line 9973 "CheckerboardLayout.c"
							gint _tmp100_ = 0;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp100_ = alignment_point;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = _tmp100_;
#line 9979 "CheckerboardLayout.c"
						}
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101_ = column_widths;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101__length1 = column_widths_length1;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp102_ = col;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp103_ = _tmp101_[_tmp102_];
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp104_ = req;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp105_ = _tmp104_.width;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp103_ < _tmp105_) {
#line 9995 "CheckerboardLayout.c"
							gint _tmp106_ = 0;
							gint* _tmp107_ = NULL;
							gint _tmp107__length1 = 0;
							gint _tmp108_ = 0;
							gint _tmp109_ = 0;
							gint* _tmp110_ = NULL;
							gint _tmp110__length1 = 0;
							gint _tmp111_ = 0;
							Dimensions _tmp112_ = {0};
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
							gint _tmp115_ = 0;
							Dimensions _tmp116_ = {0};
							gint _tmp117_ = 0;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp106_ = total_width;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107_ = column_widths;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107__length1 = column_widths_length1;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp108_ = col;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp109_ = _tmp107_[_tmp108_];
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp106_ - _tmp109_;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_ = column_widths;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110__length1 = column_widths_length1;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp111_ = col;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp112_ = req;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp113_ = _tmp112_.width;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_[_tmp111_] = _tmp113_;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp114_ = _tmp110_[_tmp111_];
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp115_ = total_width;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116_ = req;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp117_ = _tmp116_.width;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp115_ + _tmp117_;
#line 10044 "CheckerboardLayout.c"
						}
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp118_ = col;
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = _tmp118_ + 1;
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp119_ = col;
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp120_ = max_cols;
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp119_ >= _tmp120_) {
#line 10056 "CheckerboardLayout.c"
							gint* _tmp121_ = NULL;
							gint _tmp121__length1 = 0;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							gint* _tmp125_ = NULL;
							gint _tmp125__length1 = 0;
							gint _tmp126_ = 0;
							gint _tmp127_ = 0;
							gint _tmp128_ = 0;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_ = alignment_points;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121__length1 = alignment_points_length1;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp122_ = row;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp123_ = row_alignment_point;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_[_tmp122_] = _tmp123_;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp124_ = _tmp121_[_tmp122_];
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_ = row_heights;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125__length1 = row_heights_length1;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp126_ = row;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row = _tmp126_ + 1;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp127_ = tallest;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_[_tmp126_] = _tmp127_;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp128_ = _tmp125_[_tmp126_];
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							col = 0;
#line 1708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = 0;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = 0;
#line 10099 "CheckerboardLayout.c"
						}
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_g_object_unref0 (item);
#line 10103 "CheckerboardLayout.c"
					}
				}
			}
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp129_ = col;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp129_ != 0) {
#line 10111 "CheckerboardLayout.c"
				gint* _tmp130_ = NULL;
				gint _tmp130__length1 = 0;
				gint _tmp131_ = 0;
				gint _tmp132_ = 0;
				gint _tmp133_ = 0;
				gint* _tmp134_ = NULL;
				gint _tmp134__length1 = 0;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				gint _tmp137_ = 0;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_ = alignment_points;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130__length1 = alignment_points_length1;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp131_ = row;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp132_ = row_alignment_point;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_[_tmp131_] = _tmp132_;
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp133_ = _tmp130_[_tmp131_];
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_ = row_heights;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134__length1 = row_heights_length1;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp135_ = row;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp136_ = tallest;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_[_tmp135_] = _tmp136_;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp137_ = _tmp134_[_tmp135_];
#line 10146 "CheckerboardLayout.c"
			}
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp138_ = visible_width;
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp139_ = total_width;
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp140_ = max_cols;
#line 1721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gutter = (_tmp138_ - _tmp139_) / (_tmp140_ + 1);
#line 1724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp141_ = max_cols;
#line 1724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp141_ == 1) {
#line 1725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10162 "CheckerboardLayout.c"
			}
#line 1730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp142_ = gutter;
#line 1730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp142_ < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
#line 10168 "CheckerboardLayout.c"
				gint _tmp143_ = 0;
				gint _tmp144_ = 0;
				gint _tmp145_ = 0;
				gint _tmp146_ = 0;
				gint* _tmp147_ = NULL;
				gint _tmp148_ = 0;
				gint* _tmp149_ = NULL;
				gint _tmp150_ = 0;
				gint* _tmp151_ = NULL;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp143_ = max_cols;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_cols = _tmp143_ - 1;
#line 1732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp144_ = total_items;
#line 1732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp145_ = max_cols;
#line 1732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_rows = (_tmp144_ / _tmp145_) + 1;
#line 1739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = 0;
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				tallest = 0;
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				widest = 0;
#line 1743 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				total_width = 0;
#line 1744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_alignment_point = 0;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp146_ = max_cols;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp147_ = g_new0 (gint, _tmp146_);
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = (g_free (column_widths), NULL);
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = _tmp147_;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths_length1 = _tmp146_;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_column_widths_size_ = column_widths_length1;
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp148_ = max_rows;
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp149_ = g_new0 (gint, _tmp148_);
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = (g_free (row_heights), NULL);
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = _tmp149_;
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights_length1 = _tmp148_;
#line 1746 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_row_heights_size_ = row_heights_length1;
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp150_ = max_rows;
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp151_ = g_new0 (gint, _tmp150_);
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = (g_free (alignment_points), NULL);
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = _tmp151_;
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points_length1 = _tmp150_;
#line 1747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_alignment_points_size_ = alignment_points_length1;
#line 10236 "CheckerboardLayout.c"
			} else {
#line 1749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10240 "CheckerboardLayout.c"
			}
		}
	}
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 10248 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 10253 "CheckerboardLayout.c"
		{
			gboolean _tmp152_ = FALSE;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp152_ = TRUE;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10260 "CheckerboardLayout.c"
				gint _tmp154_ = 0;
				gint _tmp155_ = 0;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp156_ = NULL;
				gint _tmp157_ = 0;
				DataObject* _tmp158_ = NULL;
				Dimensions req = {0};
				CheckerboardItem* _tmp159_ = NULL;
				Dimensions _tmp160_ = {0};
				gint true_height = 0;
				Dimensions _tmp161_ = {0};
				gint _tmp162_ = 0;
				gint* _tmp163_ = NULL;
				gint _tmp163__length1 = 0;
				gint _tmp164_ = 0;
				gint _tmp165_ = 0;
				CheckerboardItem* _tmp166_ = NULL;
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
				Dimensions _tmp169_ = {0};
				gint _tmp170_ = 0;
				gint _tmp171_ = 0;
				gint* _tmp172_ = NULL;
				gint _tmp172__length1 = 0;
				gint _tmp173_ = 0;
				gint _tmp174_ = 0;
				gint _tmp179_ = 0;
				gint _tmp180_ = 0;
				gint _tmp181_ = 0;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp152_) {
#line 10292 "CheckerboardLayout.c"
					gint _tmp153_ = 0;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp153_ = ctr;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp153_ + 1;
#line 10298 "CheckerboardLayout.c"
				}
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp152_ = FALSE;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp154_ = ctr;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp155_ = total_items;
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp154_ < _tmp155_)) {
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10310 "CheckerboardLayout.c"
				}
#line 1765 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp156_ = self->priv->view;
#line 1765 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp157_ = ctr;
#line 1765 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp158_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, TYPE_DATA_COLLECTION, DataCollection), _tmp157_);
#line 1765 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp159_ = item;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp160_ = _tmp159_->requisition;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp160_;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp161_ = req;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp162_ = _tmp161_.height;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163_ = alignment_points;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163__length1 = alignment_points_length1;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp164_ = row;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp165_ = _tmp163_[_tmp164_];
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp166_ = item;
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp167_ = checkerboard_item_get_alignment_point (_tmp166_);
#line 1771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				true_height = _tmp162_ + (_tmp165_ - _tmp167_);
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp168_ = true_height;
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp169_ = req;
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp170_ = _tmp169_.height;
#line 1772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp168_ >= _tmp170_, "true_height >= req.height");
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp171_ = true_height;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172_ = row_heights;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172__length1 = row_heights_length1;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp173_ = row;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp174_ = _tmp172_[_tmp173_];
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp171_ > _tmp174_) {
#line 10364 "CheckerboardLayout.c"
					gint* _tmp175_ = NULL;
					gint _tmp175__length1 = 0;
					gint _tmp176_ = 0;
					gint _tmp177_ = 0;
					gint _tmp178_ = 0;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_ = row_heights;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175__length1 = row_heights_length1;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp176_ = row;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp177_ = true_height;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_[_tmp176_] = _tmp177_;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp178_ = _tmp175_[_tmp176_];
#line 10382 "CheckerboardLayout.c"
				}
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp179_ = col;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp179_ + 1;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp180_ = col;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp181_ = max_cols;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp180_ >= _tmp181_) {
#line 10394 "CheckerboardLayout.c"
					gint _tmp182_ = 0;
#line 1785 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp182_ = row;
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp182_ + 1;
#line 10402 "CheckerboardLayout.c"
				}
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10406 "CheckerboardLayout.c"
			}
		}
	}
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp183_ = max_rows;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp184_ = g_new0 (CheckerboardLayoutLayoutRow*, _tmp183_ + 1);
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = _tmp184_;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = _tmp183_;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp185_ = gutter;
#line 1794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = _tmp185_;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	current_row = NULL;
#line 10434 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 10439 "CheckerboardLayout.c"
		{
			gboolean _tmp186_ = FALSE;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp186_ = TRUE;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10446 "CheckerboardLayout.c"
				gint _tmp188_ = 0;
				gint _tmp189_ = 0;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp190_ = NULL;
				gint _tmp191_ = 0;
				DataObject* _tmp192_ = NULL;
				Dimensions req = {0};
				CheckerboardItem* _tmp193_ = NULL;
				Dimensions _tmp194_ = {0};
				gint xpadding = 0;
				gint* _tmp195_ = NULL;
				gint _tmp195__length1 = 0;
				gint _tmp196_ = 0;
				gint _tmp197_ = 0;
				Dimensions _tmp198_ = {0};
				gint _tmp199_ = 0;
				gint _tmp200_ = 0;
				gint ypadding = 0;
				gint* _tmp201_ = NULL;
				gint _tmp201__length1 = 0;
				gint _tmp202_ = 0;
				gint _tmp203_ = 0;
				CheckerboardItem* _tmp204_ = NULL;
				gint _tmp205_ = 0;
				gint _tmp206_ = 0;
				CheckerboardItem* _tmp207_ = NULL;
				gint _tmp208_ = 0;
				gint _tmp209_ = 0;
				CheckerboardItem* _tmp210_ = NULL;
				gint _tmp211_ = 0;
				gint _tmp212_ = 0;
				CheckerboardItem* _tmp213_ = NULL;
				Dimensions _tmp214_ = {0};
				gint _tmp215_ = 0;
				CheckerboardItem* _tmp216_ = NULL;
				Dimensions _tmp217_ = {0};
				gint _tmp218_ = 0;
				CheckerboardItem* _tmp219_ = NULL;
				gint _tmp220_ = 0;
				gint _tmp221_ = 0;
				CheckerboardLayoutLayoutRow* _tmp222_ = NULL;
				CheckerboardLayoutLayoutRow* _tmp229_ = NULL;
				CheckerboardItem** _tmp230_ = NULL;
				gint _tmp230__length1 = 0;
				gint _tmp231_ = 0;
				CheckerboardItem* _tmp232_ = NULL;
				CheckerboardItem* _tmp233_ = NULL;
				CheckerboardItem* _tmp234_ = NULL;
				gint _tmp235_ = 0;
				gint* _tmp236_ = NULL;
				gint _tmp236__length1 = 0;
				gint _tmp237_ = 0;
				gint _tmp238_ = 0;
				gint _tmp239_ = 0;
				gint _tmp240_ = 0;
				gint _tmp241_ = 0;
				gint _tmp242_ = 0;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp186_) {
#line 10506 "CheckerboardLayout.c"
					gint _tmp187_ = 0;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp187_ = ctr;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp187_ + 1;
#line 10512 "CheckerboardLayout.c"
				}
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp186_ = FALSE;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp188_ = ctr;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp189_ = total_items;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp188_ < _tmp189_)) {
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10524 "CheckerboardLayout.c"
				}
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp190_ = self->priv->view;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp191_ = ctr;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp192_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, TYPE_DATA_COLLECTION, DataCollection), _tmp191_);
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp193_ = item;
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp194_ = _tmp193_->requisition;
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp194_;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195_ = column_widths;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195__length1 = column_widths_length1;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp196_ = col;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp197_ = _tmp195_[_tmp196_];
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp198_ = req;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp199_ = _tmp198_.width;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				xpadding = (_tmp197_ - _tmp199_) / 2;
#line 1806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp200_ = xpadding;
#line 1806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp200_ >= 0, "xpadding >= 0");
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201_ = alignment_points;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201__length1 = alignment_points_length1;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp202_ = row;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp203_ = _tmp201_[_tmp202_];
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp204_ = item;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp205_ = checkerboard_item_get_alignment_point (_tmp204_);
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ypadding = _tmp203_ - _tmp205_;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp206_ = ypadding;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp206_ >= 0, "ypadding >= 0");
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_ = item;
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp208_ = x;
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp209_ = xpadding;
#line 1813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_->allocation.x = _tmp208_ + _tmp209_;
#line 1814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_ = item;
#line 1814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp211_ = y;
#line 1814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp212_ = ypadding;
#line 1814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_->allocation.y = _tmp211_ + _tmp212_;
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_ = item;
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp214_ = req;
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp215_ = _tmp214_.width;
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_->allocation.width = _tmp215_;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_ = item;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp217_ = req;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp218_ = _tmp217_.height;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_->allocation.height = _tmp218_;
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp219_ = item;
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp220_ = col;
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp221_ = row;
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_grid_coordinates (_tmp219_, _tmp220_, _tmp221_);
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp222_ = current_row;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp222_ == NULL) {
#line 10620 "CheckerboardLayout.c"
					gint _tmp223_ = 0;
					gint* _tmp224_ = NULL;
					gint _tmp224__length1 = 0;
					gint _tmp225_ = 0;
					gint _tmp226_ = 0;
					gint _tmp227_ = 0;
					CheckerboardLayoutLayoutRow* _tmp228_ = NULL;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp223_ = y;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224_ = row_heights;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224__length1 = row_heights_length1;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp225_ = row;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp226_ = _tmp224_[_tmp225_];
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp227_ = max_cols;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp228_ = checkerboard_layout_layout_row_new (_tmp223_, _tmp226_, _tmp227_);
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = _tmp228_;
#line 10646 "CheckerboardLayout.c"
				}
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp229_ = current_row;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_ = _tmp229_->items;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230__length1 = _tmp229_->items_length1;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp231_ = col;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp232_ = item;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp233_ = _g_object_ref0 (_tmp232_);
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_tmp230_[_tmp231_]);
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_[_tmp231_] = _tmp233_;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp234_ = _tmp230_[_tmp231_];
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp235_ = x;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236_ = column_widths;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236__length1 = column_widths_length1;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp237_ = col;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp238_ = _tmp236_[_tmp237_];
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp239_ = gutter;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				x = _tmp235_ + (_tmp238_ + _tmp239_);
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp240_ = col;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp240_ + 1;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp241_ = col;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp242_ = max_cols;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp241_ >= _tmp242_) {
#line 10690 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp243_ = NULL;
					CheckerboardLayoutLayoutRow** _tmp244_ = NULL;
					gint _tmp244__length1 = 0;
					gint _tmp245_ = 0;
					CheckerboardLayoutLayoutRow* _tmp246_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp247_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp248_ = NULL;
					gint _tmp249_ = 0;
					gint _tmp250_ = 0;
					gint* _tmp251_ = NULL;
					gint _tmp251__length1 = 0;
					gint _tmp252_ = 0;
					gint _tmp253_ = 0;
					gint _tmp254_ = 0;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp243_ = current_row;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp243_ != NULL, "current_row != null");
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_ = self->priv->item_rows;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244__length1 = self->priv->item_rows_length1;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp245_ = row;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp246_ = current_row;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp247_ = _checkerboard_layout_layout_row_ref0 (_tmp246_);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (_tmp244_[_tmp245_]);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_[_tmp245_] = _tmp247_;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp248_ = _tmp244_[_tmp245_];
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = NULL;
#line 1833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp249_ = gutter;
#line 1833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp249_;
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp250_ = y;
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251_ = row_heights;
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251__length1 = row_heights_length1;
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp252_ = row;
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp253_ = _tmp251_[_tmp252_];
#line 1834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					y = _tmp250_ + (_tmp253_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING);
#line 1835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp254_ = row;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp254_ + 1;
#line 10751 "CheckerboardLayout.c"
				}
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10755 "CheckerboardLayout.c"
			}
		}
	}
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp255_ = current_row;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp255_ != NULL) {
#line 10763 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow** _tmp256_ = NULL;
		gint _tmp256__length1 = 0;
		gint _tmp257_ = 0;
		CheckerboardLayoutLayoutRow* _tmp258_ = NULL;
		CheckerboardLayoutLayoutRow* _tmp259_ = NULL;
		CheckerboardLayoutLayoutRow* _tmp260_ = NULL;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = self->priv->item_rows;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256__length1 = self->priv->item_rows_length1;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = row;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = current_row;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = _checkerboard_layout_layout_row_ref0 (_tmp258_);
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (_tmp256_[_tmp257_]);
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_[_tmp257_] = _tmp259_;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = _tmp256_[_tmp257_];
#line 10786 "CheckerboardLayout.c"
	}
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp261_ = max_cols;
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = _tmp261_;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = row;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = _tmp262_ + 1;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = self->priv->rows;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp264_ = max_rows;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp263_ == _tmp264_, "rows == max_rows");
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp265_ = y;
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266_ = row_heights;
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266__length1 = row_heights_length1;
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp267_ = row;
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp268_ = _tmp266_[_tmp267_];
#line 1851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_height = (_tmp265_ + _tmp268_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp270_ = visible_width;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp271_ = allocation;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp272_ = _tmp271_.width;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp270_ != _tmp272_) {
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = TRUE;
#line 10824 "CheckerboardLayout.c"
	} else {
		gint _tmp273_ = 0;
		GtkAllocation _tmp274_ = {0};
		gint _tmp275_ = 0;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = total_height;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = allocation;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = _tmp273_ != _tmp275_;
#line 10837 "CheckerboardLayout.c"
	}
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp269_) {
#line 10841 "CheckerboardLayout.c"
		gint _tmp276_ = 0;
		gint _tmp277_ = 0;
		gint _tmp278_ = 0;
#line 1857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = visible_width;
#line 1857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = total_height;
#line 1857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp276_, _tmp277_);
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = TRUE;
#line 1861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = total_height;
#line 1861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_center_on_anchor (self, (gdouble) _tmp278_);
#line 10857 "CheckerboardLayout.c"
	}
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (current_row);
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = (g_free (alignment_points), NULL);
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = (g_free (row_heights), NULL);
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = (g_free (column_widths), NULL);
#line 10867 "CheckerboardLayout.c"
}


static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items) {
	GdkRectangle dirty = {0};
	gboolean _tmp35_ = FALSE;
	GdkRectangle _tmp36_ = {0};
	gint _tmp37_ = 0;
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (items));
#line 1866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&dirty, 0, sizeof (GdkRectangle));
#line 10884 "CheckerboardLayout.c"
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = items;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_data_view_it = _tmp1_;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 10897 "CheckerboardLayout.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataView* data_view = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			CheckerboardItem* item = NULL;
			DataView* _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
			CheckerboardItem* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			ViewCollection* _tmp10_ = NULL;
			CheckerboardItem* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			CheckerboardItem* _tmp14_ = NULL;
			GdkRectangle _tmp15_ = {0};
			gint _tmp16_ = 0;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp23_ = NULL;
			GdkRectangle _tmp24_ = {0};
			GdkRectangle _tmp25_ = {0};
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			GdkRectangle _tmp28_ = {0};
			gint _tmp29_ = 0;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = _data_view_it;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp3_) {
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10931 "CheckerboardLayout.c"
			}
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = _data_view_it;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			data_view = (DataView*) _tmp5_;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = data_view;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp7_;
#line 1870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = item;
#line 1870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
#line 1870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp9_) {
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 10957 "CheckerboardLayout.c"
			}
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->view;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = item;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_vala_assert (_tmp12_, "view.contains(item)");
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = item;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _tmp14_->allocation;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = _tmp15_.width;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ <= 0) {
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = TRUE;
#line 10977 "CheckerboardLayout.c"
			} else {
				CheckerboardItem* _tmp17_ = NULL;
				GdkRectangle _tmp18_ = {0};
				gint _tmp19_ = 0;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = item;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->allocation;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = _tmp18_.height;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = _tmp19_ <= 0;
#line 10990 "CheckerboardLayout.c"
			}
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp13_) {
#line 10994 "CheckerboardLayout.c"
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = reason;
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = g_strdup_printf ("items_dirty: %s", _tmp20_);
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_;
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_layout_need_reflow (self, _tmp22_);
#line 1878 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_free0 (_tmp22_);
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_data_view_it);
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 11016 "CheckerboardLayout.c"
			}
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			memset (&intersection, 0, sizeof (GdkRectangle));
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = item;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _tmp23_->allocation;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp24_, &_tmp25_);
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			intersection = _tmp25_;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 11036 "CheckerboardLayout.c"
			}
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = dirty;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = _tmp28_.width;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp29_ == 0) {
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = TRUE;
#line 11046 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp30_ = {0};
				gint _tmp31_ = 0;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = dirty;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = _tmp30_.height;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = _tmp31_ == 0;
#line 11056 "CheckerboardLayout.c"
			}
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_) {
#line 11060 "CheckerboardLayout.c"
				GdkRectangle _tmp32_ = {0};
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = intersection;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp32_;
#line 11066 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp33_ = {0};
				GdkRectangle _tmp34_ = {0};
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp33_ = intersection;
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gdk_rectangle_union (&dirty, &_tmp33_, &_tmp34_);
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp34_;
#line 11076 "CheckerboardLayout.c"
			}
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (data_view);
#line 11082 "CheckerboardLayout.c"
		}
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_data_view_it);
#line 11086 "CheckerboardLayout.c"
	}
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = _tmp36_.width;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp37_ > 0) {
#line 11094 "CheckerboardLayout.c"
		GdkRectangle _tmp38_ = {0};
		gint _tmp39_ = 0;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.height;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = _tmp39_ > 0;
#line 11103 "CheckerboardLayout.c"
	} else {
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = FALSE;
#line 11107 "CheckerboardLayout.c"
	}
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp35_) {
#line 11111 "CheckerboardLayout.c"
		GdkRectangle _tmp40_ = {0};
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		GdkRectangle _tmp44_ = {0};
		gint _tmp45_ = 0;
		GdkRectangle _tmp46_ = {0};
		gint _tmp47_ = 0;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = dirty;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.x;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = dirty;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.y;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = dirty;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = _tmp44_.width;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = dirty;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp46_.height;
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp41_, _tmp43_, _tmp45_, _tmp47_);
#line 11138 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_real_map (GtkWidget* base) {
	CheckerboardLayout * self;
#line 1904 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget));
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 11151 "CheckerboardLayout.c"
}


static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus) {
	ConfigFacade* _tmp0_ = NULL;
	ConfigFacade* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GdkRGBA _tmp3_ = {0};
	ConfigFacade* _tmp4_ = NULL;
	ConfigFacade* _tmp5_ = NULL;
	GdkRGBA _tmp6_ = {0};
	ConfigFacade* _tmp7_ = NULL;
	ConfigFacade* _tmp8_ = NULL;
	GdkRGBA _tmp9_ = {0};
	GtkStyleContext* _tmp10_ = NULL;
	GdkRGBA _tmp11_ = {0};
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = in_focus;
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_selected_color (_tmp1_, _tmp2_, &_tmp3_);
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selected_color = _tmp3_;
#line 1912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = config_facade_get_instance ();
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_unselected_color (_tmp5_, &_tmp6_);
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->unselected_color = _tmp6_;
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp5_);
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = config_facade_get_instance ();
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = _tmp7_;
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_border_color (_tmp8_, &_tmp9_);
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->border_color = _tmp9_;
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp8_);
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_style_context_get_background_color (_tmp10_, GTK_STATE_FLAG_NORMAL, &_tmp11_);
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->bg_color = _tmp11_;
#line 11208 "CheckerboardLayout.c"
}


static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	CheckerboardLayout * self;
	GtkAllocation _tmp0_ = {0};
#line 1918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (allocation != NULL);
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *allocation;
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 11225 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _result_ = FALSE;
	cairo_t* _tmp63_ = NULL;
#line 1924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 1933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = ctx;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = allocation;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = allocation;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_render_background (_tmp1_, _tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp4_, (gdouble) _tmp6_);
#line 1937 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->message;
#line 1937 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ == NULL) {
#line 11270 "CheckerboardLayout.c"
		gboolean _tmp8_ = FALSE;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = self->priv->exposure_dirty;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp8_) {
#line 1943 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_expose_items (self, "draw");
#line 11278 "CheckerboardLayout.c"
		}
		{
			GeeList* _item_list = NULL;
			GdkRectangle _tmp9_ = {0};
			GeeList* _tmp10_ = NULL;
			gint _item_size = 0;
			GeeList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _item_index = 0;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = self->priv->visible_page;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = checkerboard_layout_intersection (self, &_tmp9_);
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_list = _tmp10_;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_size = _tmp13_;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = -1;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 11307 "CheckerboardLayout.c"
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				CheckerboardItem* item = NULL;
				GeeList* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gpointer _tmp19_ = NULL;
				GdkRGBA _tmp20_ = {0};
				CheckerboardItem* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				CheckerboardItem* _tmp25_ = NULL;
				cairo_t* _tmp26_ = NULL;
				GdkRGBA _tmp27_ = {0};
				GdkRGBA _tmp28_ = {0};
				GdkRGBA _tmp29_ = {0};
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _item_index;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_item_index = _tmp14_ + 1;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = _item_index;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _item_size;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 11335 "CheckerboardLayout.c"
				}
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = _item_list;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _item_index;
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = (CheckerboardItem*) _tmp19_;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = item;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_VIEW, DataView));
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp22_) {
#line 11351 "CheckerboardLayout.c"
					GdkRGBA _tmp23_ = {0};
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = self->priv->selected_color;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp23_;
#line 11357 "CheckerboardLayout.c"
				} else {
					GdkRGBA _tmp24_ = {0};
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = self->priv->unselected_color;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp24_;
#line 11364 "CheckerboardLayout.c"
				}
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = item;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ctx;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = self->priv->bg_color;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = self->priv->unselected_color;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = self->priv->border_color;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_paint (_tmp25_, _tmp26_, &_tmp27_, &_tmp20_, &_tmp28_, &_tmp29_);
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 11380 "CheckerboardLayout.c"
			}
#line 1946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_item_list);
#line 11384 "CheckerboardLayout.c"
		}
	} else {
		PangoLayout* pango_layout = NULL;
		const gchar* _tmp30_ = NULL;
		PangoLayout* _tmp31_ = NULL;
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		GtkAllocation _tmp35_ = {0};
		gint x = 0;
		GtkAllocation _tmp36_ = {0};
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint y = 0;
		GtkAllocation _tmp42_ = {0};
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		cairo_t* _tmp48_ = NULL;
		GdkRGBA _tmp49_ = {0};
		gdouble _tmp50_ = 0.0;
		GdkRGBA _tmp51_ = {0};
		gdouble _tmp52_ = 0.0;
		GdkRGBA _tmp53_ = {0};
		gdouble _tmp54_ = 0.0;
		cairo_t* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		cairo_t* _tmp58_ = NULL;
		PangoLayout* _tmp59_ = NULL;
#line 1952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->message;
#line 1952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp30_);
#line 1952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout = _tmp31_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = pango_layout;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp32_, &_tmp33_, &_tmp34_);
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_width = _tmp33_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_height = _tmp34_;
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp35_);
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		allocation = _tmp35_;
#line 1958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = allocation;
#line 1958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = _tmp36_.width;
#line 1958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = text_width;
#line 1958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp37_ - _tmp38_;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = x;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp40_ > 0) {
#line 11450 "CheckerboardLayout.c"
			gint _tmp41_ = 0;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp41_ = x;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = _tmp41_ / 2;
#line 11456 "CheckerboardLayout.c"
		} else {
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = 0;
#line 11460 "CheckerboardLayout.c"
		}
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp39_;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = allocation;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.height;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = text_height;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp43_ - _tmp44_;
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = y;
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp46_ > 0) {
#line 11476 "CheckerboardLayout.c"
			gint _tmp47_ = 0;
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp47_ = y;
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = _tmp47_ / 2;
#line 11482 "CheckerboardLayout.c"
		} else {
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = 0;
#line 11486 "CheckerboardLayout.c"
		}
#line 1962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp45_;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = ctx;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = self->priv->unselected_color;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = _tmp49_.red;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = self->priv->unselected_color;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = _tmp51_.green;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = self->priv->unselected_color;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = _tmp53_.blue;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgb (_tmp48_, _tmp50_, _tmp52_, _tmp54_);
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = ctx;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = x;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp57_ = y;
#line 1965 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp55_, (gdouble) _tmp56_, (gdouble) _tmp57_);
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = pango_layout;
#line 1966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp58_, _tmp59_);
#line 1937 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (pango_layout);
#line 11522 "CheckerboardLayout.c"
	}
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
#line 11526 "CheckerboardLayout.c"
		cairo_t* _tmp61_ = NULL;
		gboolean _tmp62_ = FALSE;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = ctx;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp61_);
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = _tmp62_;
#line 11535 "CheckerboardLayout.c"
	} else {
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = TRUE;
#line 11539 "CheckerboardLayout.c"
	}
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_result_ = _tmp60_;
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = ctx;
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_draw_selection_band (self, _tmp63_);
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _result_;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11551 "CheckerboardLayout.c"
}


static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx) {
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	gboolean _tmp5_ = FALSE;
	GtkAdjustment* _tmp6_ = NULL;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp8_ = NULL;
	GtkAdjustment* _tmp9_ = NULL;
	GdkRectangle _tmp10_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp11_ = {0};
	GdkRectangle _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	GdkRGBA _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	GdkRGBA _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	GdkRGBA _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
	cairo_t* _tmp44_ = NULL;
	GdkRectangle _tmp45_ = {0};
	gint _tmp46_ = 0;
	GdkRectangle _tmp47_ = {0};
	gint _tmp48_ = 0;
	GdkRectangle _tmp49_ = {0};
	gint _tmp50_ = 0;
	GdkRectangle _tmp51_ = {0};
	gint _tmp52_ = 0;
	cairo_t* _tmp53_ = NULL;
#line 1977 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1977 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->selection_band;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ <= 1) {
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 11602 "CheckerboardLayout.c"
	} else {
		GdkRectangle _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->selection_band;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.height;
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 11612 "CheckerboardLayout.c"
	}
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11618 "CheckerboardLayout.c"
	}
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->hadjustment;
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = TRUE;
#line 11626 "CheckerboardLayout.c"
	} else {
		GtkAdjustment* _tmp7_ = NULL;
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->vadjustment;
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 11633 "CheckerboardLayout.c"
	}
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_) {
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11639 "CheckerboardLayout.c"
	}
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->hadjustment;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	get_adjustment_page (_tmp8_, _tmp9_, &_tmp10_);
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_page = _tmp10_;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&visible_band, 0, sizeof (GdkRectangle));
#line 1989 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->selection_band;
#line 1989 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_rectangle_intersect (&visible_page, &_tmp11_, &_tmp12_);
#line 1989 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_band = _tmp12_;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = visible_band;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.width;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ > 1) {
#line 11663 "CheckerboardLayout.c"
		GdkRectangle _tmp16_ = {0};
		gint _tmp17_ = 0;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = visible_band;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.height;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp17_ > 1;
#line 11672 "CheckerboardLayout.c"
	} else {
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 11676 "CheckerboardLayout.c"
	}
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 11680 "CheckerboardLayout.c"
		cairo_t* _tmp18_ = NULL;
		GdkRGBA _tmp19_ = {0};
		gdouble _tmp20_ = 0.0;
		GdkRGBA _tmp21_ = {0};
		gdouble _tmp22_ = 0.0;
		GdkRGBA _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
		cairo_t* _tmp25_ = NULL;
		GdkRectangle _tmp26_ = {0};
		gint _tmp27_ = 0;
		GdkRectangle _tmp28_ = {0};
		gint _tmp29_ = 0;
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		GdkRectangle _tmp32_ = {0};
		gint _tmp33_ = 0;
		cairo_t* _tmp34_ = NULL;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = ctx;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->selected_color;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.red;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->selected_color;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.green;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = self->priv->selected_color;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.blue;
#line 1993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp18_, _tmp20_, _tmp22_, _tmp24_, CHECKERBOARD_LAYOUT_SELECTION_ALPHA);
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = visible_band;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_.x;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = visible_band;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = _tmp28_.y;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = visible_band;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_.width;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = visible_band;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = _tmp32_.height;
#line 1995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp25_, (gdouble) _tmp27_, (gdouble) _tmp29_, (gdouble) _tmp31_, (gdouble) _tmp33_);
#line 1997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = ctx;
#line 1997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp34_);
#line 11738 "CheckerboardLayout.c"
	}
#line 2003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = ctx;
#line 2003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp35_, 1.0);
#line 2004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = ctx;
#line 2004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_cap (_tmp36_, CAIRO_LINE_CAP_SQUARE);
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = ctx;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = self->priv->selected_color;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = _tmp38_.red;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = self->priv->selected_color;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = _tmp40_.green;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = self->priv->selected_color;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = _tmp42_.blue;
#line 2005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgb (_tmp37_, _tmp39_, _tmp41_, _tmp43_);
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = ctx;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = self->priv->selection_band;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = _tmp45_.x;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = self->priv->selection_band;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = self->priv->selection_band;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.width;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = self->priv->selection_band;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.height;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp44_, ((gdouble) _tmp46_) + 0.5, ((gdouble) _tmp48_) + 0.5, ((gdouble) _tmp50_) - 1.0, ((gdouble) _tmp52_) - 1.0);
#line 2008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = ctx;
#line 2008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_stroke (_tmp53_);
#line 11788 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	CheckerboardItem* item = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CheckerboardItem* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	CheckerboardItem* _tmp4_ = NULL;
#line 2011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) _tmp0_, (gdouble) _tmp1_);
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item = _tmp2_;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 11817 "CheckerboardLayout.c"
		CheckerboardItem* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GtkTooltip* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = item;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = x;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = y;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = tooltip;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_query_tooltip (_tmp5_, _tmp6_, _tmp7_, _tmp8_);
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp9_;
#line 11835 "CheckerboardLayout.c"
	} else {
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = FALSE;
#line 11839 "CheckerboardLayout.c"
	}
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp3_;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (item);
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11847 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self) {
	ConfigFacade* _tmp0_ = NULL;
	ConfigFacade* _tmp1_ = NULL;
	GdkRGBA _tmp2_ = {0};
#line 2017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp1_, &_tmp2_);
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp2_);
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 2019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 11869 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GdkEventFocus* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2023 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_in_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11905 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GdkEventFocus* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, FALSE);
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_out_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2031 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 2033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 2033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 2033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11941 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row) {
	CheckerboardLayoutLayoutRow* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	CheckerboardItem** _tmp3_ = NULL;
#line 843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
#line 844 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = y;
#line 844 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->y = _tmp0_;
#line 845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = height;
#line 845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->height = _tmp1_;
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = num_in_row;
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (CheckerboardItem*, _tmp2_ + 1);
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = _tmp3_;
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items_length1 = _tmp2_;
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->_items_size_ = self->items_length1;
#line 843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 11975 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row) {
#line 843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
#line 11982 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_init (GValue* value) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 11989 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_free_value (GValue* value) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
#line 11998 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_layout_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
#line 12008 "CheckerboardLayout.c"
	} else {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 12012 "CheckerboardLayout.c"
	}
}


static gpointer checkerboard_layout_value_layout_row_peek_pointer (const GValue* value) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 12020 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 12027 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow* object;
		object = collect_values[0].v_pointer;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12034 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12038 "CheckerboardLayout.c"
		}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
#line 12042 "CheckerboardLayout.c"
	} else {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12046 "CheckerboardLayout.c"
	}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 12050 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardLayoutLayoutRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 12061 "CheckerboardLayout.c"
	}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 12067 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 12071 "CheckerboardLayout.c"
	} else {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 12075 "CheckerboardLayout.c"
	}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 12079 "CheckerboardLayout.c"
}


static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CheckerboardLayoutParamSpecLayoutRow* spec;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 12093 "CheckerboardLayout.c"
}


static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 12102 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow* old;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 12122 "CheckerboardLayout.c"
	} else {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12126 "CheckerboardLayout.c"
	}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 12132 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow* old;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 12151 "CheckerboardLayout.c"
	} else {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12155 "CheckerboardLayout.c"
	}
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 12161 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
#line 12171 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 12178 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow* obj) {
	CheckerboardLayoutLayoutRow * self;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 12190 "CheckerboardLayout.c"
}


static GType checkerboard_layout_layout_row_get_type (void) {
	static volatile gsize checkerboard_layout_layout_row_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__volatile, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__volatile;
}


static gpointer checkerboard_layout_layout_row_ref (gpointer instance) {
	CheckerboardLayoutLayoutRow* self;
	self = instance;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 12215 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_unref (gpointer instance) {
	CheckerboardLayoutLayoutRow* self;
	self = instance;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 12228 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_class_init (CheckerboardLayoutClass * klass) {
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardLayoutPrivate));
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->map = checkerboard_layout_real_map;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->size_allocate = checkerboard_layout_real_size_allocate;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->draw = checkerboard_layout_real_draw;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->query_tooltip = checkerboard_layout_real_query_tooltip;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_in_event = checkerboard_layout_real_focus_in_event;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_out_event = checkerboard_layout_real_focus_out_event;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
#line 12252 "CheckerboardLayout.c"
}


static void checkerboard_layout_instance_init (CheckerboardLayout * self) {
	gchar* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_LAYOUT_GET_PRIVATE (self);
#line 851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup ("");
#line 851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp0_;
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp1_;
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = NULL;
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = NULL;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = NULL;
#line 861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
#line 862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->last_width = 0;
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = 0;
#line 864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = 0;
#line 865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
#line 867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = 0;
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = NULL;
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->size_allocate_due_to_reflow = FALSE;
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = FALSE;
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 12313 "CheckerboardLayout.c"
}


static void checkerboard_layout_finalize (GObject* obj) {
	CheckerboardLayout * self;
	ViewCollection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	ViewCollection* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	ViewCollection* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	ViewCollection* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	ViewCollection* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	ViewCollection* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ViewCollection* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	ViewCollection* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	ViewCollection* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GtkAdjustment* _tmp18_ = NULL;
	GtkAdjustment* _tmp21_ = NULL;
	GtkContainer* _tmp24_ = NULL;
	GtkContainer* _tmp25_ = NULL;
	ConfigFacade* _tmp29_ = NULL;
	ConfigFacade* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->view;
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->view;
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->view;
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->view;
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
#line 911 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->view;
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->view;
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
#line 914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->view;
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->hadjustment;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_ != NULL) {
#line 12404 "CheckerboardLayout.c"
		GtkAdjustment* _tmp19_ = NULL;
		guint _tmp20_ = 0U;
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->hadjustment;
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12413 "CheckerboardLayout.c"
	}
#line 920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 920 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp21_ != NULL) {
#line 12419 "CheckerboardLayout.c"
		GtkAdjustment* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = self->priv->vadjustment;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12428 "CheckerboardLayout.c"
	}
#line 923 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 923 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = _tmp24_;
#line 923 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_ != NULL) {
#line 12436 "CheckerboardLayout.c"
		GtkContainer* _tmp26_ = NULL;
		GtkContainer* _tmp27_ = NULL;
		guint _tmp28_ = 0U;
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_;
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
#line 12448 "CheckerboardLayout.c"
	}
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = config_facade_get_instance ();
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_;
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp31_, NULL, FALSE);
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp30_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self);
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp30_);
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
#line 12480 "CheckerboardLayout.c"
}


GType checkerboard_layout_get_type (void) {
	static volatile gsize checkerboard_layout_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
		g_once_init_leave (&checkerboard_layout_type_id__volatile, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



