/* pkcs11-certificate.c generated by valac 0.22.1, the Vala compiler
 * generated from pkcs11-certificate.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-pkcs11.h"
#include <gck/gck.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <gcr/gcr-base.h>
#include <p11-kit/pkcs11.h>
#include <glib/gi18n-lib.h>

#define __vala_GckAttributes_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckAttributes_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_GckBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckBuilder_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _SeahorsePkcs11CertificatePrivate {
	GWeakRef _token;
	GckAttributes* _attributes;
	GckAttribute* _der;
	GWeakRef _private_key;
	GIcon* _icon;
	SeahorseFlags _flags;
};


static gpointer seahorse_pkcs11_certificate_parent_class = NULL;
static guint8* seahorse_pkcs11_certificate_EMPTY;
static gint seahorse_pkcs11_certificate_EMPTY_length1;
static guint8* seahorse_pkcs11_certificate_EMPTY = NULL;
static gint seahorse_pkcs11_certificate_EMPTY_length1 = 0;
static gint _seahorse_pkcs11_certificate_EMPTY_size_ = 0;
static GcrComparableIface* seahorse_pkcs11_certificate_gcr_comparable_parent_iface = NULL;
static GcrCertificateIface* seahorse_pkcs11_certificate_gcr_certificate_parent_iface = NULL;
static GckObjectCacheIface* seahorse_pkcs11_certificate_gck_object_cache_parent_iface = NULL;
static SeahorseDeletableIface* seahorse_pkcs11_certificate_seahorse_deletable_parent_iface = NULL;
static SeahorseExportableIface* seahorse_pkcs11_certificate_seahorse_exportable_parent_iface = NULL;
static SeahorseViewableIface* seahorse_pkcs11_certificate_seahorse_viewable_parent_iface = NULL;

#define SEAHORSE_PKCS11_CERTIFICATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11CertificatePrivate))
enum  {
	SEAHORSE_PKCS11_CERTIFICATE_DUMMY_PROPERTY,
	SEAHORSE_PKCS11_CERTIFICATE_PLACE,
	SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS,
	SEAHORSE_PKCS11_CERTIFICATE_ACTIONS,
	SEAHORSE_PKCS11_CERTIFICATE_PARTNER,
	SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES,
	SEAHORSE_PKCS11_CERTIFICATE_DELETABLE,
	SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE,
	SEAHORSE_PKCS11_CERTIFICATE_ICON,
	SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION,
	SEAHORSE_PKCS11_CERTIFICATE_LABEL,
	SEAHORSE_PKCS11_CERTIFICATE_SUBJECT,
	SEAHORSE_PKCS11_CERTIFICATE_MARKUP,
	SEAHORSE_PKCS11_CERTIFICATE_ISSUER,
	SEAHORSE_PKCS11_CERTIFICATE_EXPIRY
};
static void _vala_GckAttributes_free (GckAttributes* self);
static void seahorse_pkcs11_certificate_real_dispose (GObject* base);
static GtkWindow* seahorse_pkcs11_certificate_real_create_viewer (SeahorseViewable* base, GtkWindow* parent);
static SeahorseDeleter* seahorse_pkcs11_certificate_real_create_deleter (SeahorseDeletable* base);
static GList* seahorse_pkcs11_certificate_real_create_exporters (SeahorseExportable* base, SeahorseExporterType type);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_pkcs11_certificate_real_fill (GckObjectCache* base, GckAttributes* attributes);
static void _vala_GckBuilder_free (GckBuilder* self);
static guint8* seahorse_pkcs11_certificate_real_get_der_data (GcrCertificate* base, int* result_length1);
static gint seahorse_pkcs11_certificate_real_compare (GcrComparable* base, GcrComparable* other);
static SeahorseFlags seahorse_pkcs11_certificate_calc_is_personal_and_trusted (SeahorsePkcs11Certificate* self);
static void seahorse_pkcs11_certificate_ensure_flags (SeahorsePkcs11Certificate* self);
static GckAttributes* _vala_GckAttributes_copy (GckAttributes* self);
static GObject * seahorse_pkcs11_certificate_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_pkcs11_certificate___lambda9_ (SeahorsePkcs11Certificate* self, GParamSpec* pspec);
static void __seahorse_pkcs11_certificate___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void seahorse_pkcs11_certificate_finalize (GObject* obj);
static void _vala_seahorse_pkcs11_certificate_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_pkcs11_certificate_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GckAttributes_free (GckAttributes* self) {
	g_boxed_free (gck_attributes_get_type (), self);
}


static void seahorse_pkcs11_certificate_real_dispose (GObject* base) {
	SeahorsePkcs11Certificate * self;
	self = (SeahorsePkcs11Certificate*) base;
	seahorse_pkcs11_certificate_set_partner (self, NULL);
	G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gck_object_get_type (), GckObject));
}


static GtkWindow* seahorse_pkcs11_certificate_real_create_viewer (SeahorseViewable* base, GtkWindow* parent) {
	SeahorsePkcs11Certificate * self;
	GtkWindow* result = NULL;
	SeahorsePkcs11Properties* viewer = NULL;
	GtkWindow* _tmp0_ = NULL;
	SeahorsePkcs11Properties* _tmp1_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = parent;
	_tmp1_ = seahorse_pkcs11_properties_new ((GckObject*) self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	viewer = _tmp1_;
	gtk_widget_show ((GtkWidget*) viewer);
	result = (GtkWindow*) viewer;
	return result;
}


static SeahorseDeleter* seahorse_pkcs11_certificate_real_create_deleter (SeahorseDeletable* base) {
	SeahorsePkcs11Certificate * self;
	SeahorseDeleter* result = NULL;
	SeahorseDeleter* deleter = NULL;
	SeahorsePkcs11PrivateKey* key = NULL;
	SeahorsePkcs11PrivateKey* _tmp0_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp1_ = NULL;
	SeahorsePkcs11PrivateKey* _tmp2_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = seahorse_pkcs11_certificate_get_partner (self);
	_tmp1_ = _tmp0_;
	key = _tmp1_;
	_tmp2_ = key;
	if (_tmp2_ == NULL) {
		SeahorsePkcs11Deleter* _tmp3_ = NULL;
		_tmp3_ = seahorse_pkcs11_deleter_new ((GckObject*) self);
		_g_object_unref0 (deleter);
		deleter = (SeahorseDeleter*) _tmp3_;
	} else {
		SeahorsePkcs11PrivateKey* _tmp4_ = NULL;
		SeahorseDeleter* _tmp5_ = NULL;
		SeahorseDeleter* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = key;
		_tmp5_ = seahorse_deletable_create_deleter ((SeahorseDeletable*) _tmp4_);
		_g_object_unref0 (deleter);
		deleter = _tmp5_;
		_tmp6_ = deleter;
		_tmp7_ = seahorse_deleter_add_object (_tmp6_, (GObject*) self);
		if (!_tmp7_) {
			g_return_val_if_reached (NULL);
		}
	}
	result = deleter;
	_g_object_unref0 (key);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GList* seahorse_pkcs11_certificate_real_create_exporters (SeahorseExportable* base, SeahorseExporterType type) {
	SeahorsePkcs11Certificate * self;
	GList* result = NULL;
	GList* exporters = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (SeahorsePkcs11Certificate*) base;
	exporters = NULL;
	_tmp0_ = seahorse_exportable_get_exportable ((SeahorseExportable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		SeahorseCertificateDerExporter* exporter = NULL;
		SeahorseCertificateDerExporter* _tmp2_ = NULL;
		SeahorseCertificateDerExporter* _tmp3_ = NULL;
		SeahorseExporter* _tmp4_ = NULL;
		_tmp2_ = seahorse_certificate_der_exporter_new ((GcrCertificate*) self);
		exporter = _tmp2_;
		_tmp3_ = exporter;
		_tmp4_ = _g_object_ref0 ((SeahorseExporter*) _tmp3_);
		exporters = g_list_append (exporters, _tmp4_);
		_g_object_unref0 (exporter);
	}
	result = exporters;
	return result;
}


static void _vala_GckBuilder_free (GckBuilder* self) {
	g_boxed_free (gck_builder_get_type (), self);
}


static void seahorse_pkcs11_certificate_real_fill (GckObjectCache* base, GckAttributes* attributes) {
	SeahorsePkcs11Certificate * self;
	GckBuilder* builder = NULL;
	GckBuilder* _tmp0_ = NULL;
	GckAttributes* _tmp1_ = NULL;
	GckBuilder* _tmp4_ = NULL;
	GckAttributes* _tmp5_ = NULL;
	GckBuilder* _tmp6_ = NULL;
	GckAttributes* _tmp7_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	g_return_if_fail (attributes != NULL);
	_tmp0_ = gck_builder_new (GCK_BUILDER_NONE);
	builder = _tmp0_;
	_tmp1_ = self->priv->_attributes;
	if (_tmp1_ != NULL) {
		GckBuilder* _tmp2_ = NULL;
		GckAttributes* _tmp3_ = NULL;
		_tmp2_ = builder;
		_tmp3_ = self->priv->_attributes;
		gck_builder_add_all (_tmp2_, _tmp3_);
	}
	_tmp4_ = builder;
	_tmp5_ = attributes;
	gck_builder_set_all (_tmp4_, _tmp5_);
	_tmp6_ = builder;
	_tmp7_ = gck_builder_steal (_tmp6_);
	__vala_GckAttributes_free0 (self->priv->_attributes);
	self->priv->_attributes = _tmp7_;
	g_object_notify ((GObject*) self, "attributes");
	__vala_GckBuilder_free0 (builder);
}


static guint8* seahorse_pkcs11_certificate_real_get_der_data (GcrCertificate* base, int* result_length1) {
	SeahorsePkcs11Certificate * self;
	guint8* result = NULL;
	GckAttribute* _tmp0_ = NULL;
	GckAttribute* _tmp3_ = NULL;
	gsize _tmp4_;
	guint8* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_der;
	if (_tmp0_ == NULL) {
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		guint8* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp1_ = seahorse_pkcs11_certificate_EMPTY;
		_tmp1__length1 = seahorse_pkcs11_certificate_EMPTY_length1;
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _tmp1__length1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->_der;
	_tmp5_ = gck_attribute_get_data (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


static gint seahorse_pkcs11_certificate_real_compare (GcrComparable* base, GcrComparable* other) {
	SeahorsePkcs11Certificate * self;
	gint result = 0;
	GcrComparable* _tmp0_ = NULL;
	guint8* data1 = NULL;
	gsize _tmp1_;
	guint8* _tmp2_ = NULL;
	gint data1_length1 = 0;
	gint _data1_size_ = 0;
	guint8* data2 = NULL;
	GcrComparable* _tmp3_ = NULL;
	gsize _tmp4_;
	guint8* _tmp5_ = NULL;
	gint data2_length1 = 0;
	gint _data2_size_ = 0;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint8* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp8_ = 0;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = other;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	_tmp2_ = gcr_certificate_get_der_data ((GcrCertificate*) self, &_tmp1_);
	data1 = _tmp2_;
	data1_length1 = _tmp1_;
	_data1_size_ = data1_length1;
	_tmp3_ = other;
	_tmp5_ = gcr_certificate_get_der_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gcr_certificate_get_type (), GcrCertificate), &_tmp4_);
	data2 = _tmp5_;
	data2_length1 = _tmp4_;
	_data2_size_ = data2_length1;
	_tmp6_ = data1;
	_tmp6__length1 = data1_length1;
	_tmp7_ = data2;
	_tmp7__length1 = data2_length1;
	_tmp8_ = gcr_comparable_memcmp (_tmp6_, (gsize) _tmp6__length1, _tmp7_, (gsize) _tmp7__length1);
	result = _tmp8_;
	return result;
}


static SeahorseFlags seahorse_pkcs11_certificate_calc_is_personal_and_trusted (SeahorsePkcs11Certificate* self) {
	SeahorseFlags result = 0;
	gulong category = 0UL;
	gboolean is_ca = FALSE;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GckAttributes* _tmp4_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	category = (gulong) 0;
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = SEAHORSE_FLAG_PERSONAL | SEAHORSE_FLAG_TRUSTED;
		return result;
	}
	_tmp4_ = self->priv->_attributes;
	if (_tmp4_ != NULL) {
		GckAttributes* _tmp5_ = NULL;
		gulong _tmp6_ = 0UL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->_attributes;
		_tmp7_ = gck_attributes_find_ulong (_tmp5_, CKA_CERTIFICATE_CATEGORY, &_tmp6_);
		category = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		gulong _tmp9_ = 0UL;
		_tmp9_ = category;
		if (_tmp9_ == ((gulong) 2)) {
			result = 0;
			return result;
		} else {
			gulong _tmp10_ = 0UL;
			_tmp10_ = category;
			if (_tmp10_ == ((gulong) 1)) {
				result = SEAHORSE_FLAG_PERSONAL;
				return result;
			}
		}
	}
	_tmp12_ = gcr_certificate_get_basic_constraints ((GcrCertificate*) self, &_tmp11_, NULL);
	is_ca = _tmp11_;
	if (_tmp12_) {
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		_tmp14_ = is_ca;
		if (_tmp14_) {
			_tmp13_ = 0;
		} else {
			_tmp13_ = (gint) SEAHORSE_FLAG_PERSONAL;
		}
		_tmp15_ = _tmp13_;
		result = _tmp15_;
		return result;
	}
	result = SEAHORSE_FLAG_PERSONAL;
	return result;
}


static void seahorse_pkcs11_certificate_ensure_flags (SeahorsePkcs11Certificate* self) {
	SeahorseFlags _tmp0_ = 0;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_flags;
	_tmp1_ = G_MAXUINT;
	if (((guint) _tmp0_) == _tmp1_) {
		SeahorseFlags _tmp2_ = 0;
		_tmp2_ = seahorse_pkcs11_certificate_calc_is_personal_and_trusted (self);
		self->priv->_flags = SEAHORSE_FLAG_EXPORTABLE | _tmp2_;
	}
}


SeahorsePkcs11Certificate* seahorse_pkcs11_certificate_construct (GType object_type) {
	SeahorsePkcs11Certificate * self = NULL;
	self = (SeahorsePkcs11Certificate*) g_object_new (object_type, NULL);
	return self;
}


SeahorsePkcs11Certificate* seahorse_pkcs11_certificate_new (void) {
	return seahorse_pkcs11_certificate_construct (SEAHORSE_PKCS11_TYPE_CERTIFICATE);
}


SeahorsePkcs11Token* seahorse_pkcs11_certificate_get_place (SeahorsePkcs11Certificate* self) {
	SeahorsePkcs11Token* result;
	GObject* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_token);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	return result;
}


void seahorse_pkcs11_certificate_set_place (SeahorsePkcs11Certificate* self, SeahorsePkcs11Token* value) {
	SeahorsePkcs11Token* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_weak_ref_set (&self->priv->_token, (GObject*) _tmp0_);
	g_object_notify ((GObject *) self, "place");
}


SeahorseFlags seahorse_pkcs11_certificate_get_object_flags (SeahorsePkcs11Certificate* self) {
	SeahorseFlags result;
	SeahorseFlags _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	seahorse_pkcs11_certificate_ensure_flags (self);
	_tmp0_ = self->priv->_flags;
	result = _tmp0_;
	return result;
}


GtkActionGroup* seahorse_pkcs11_certificate_get_actions (SeahorsePkcs11Certificate* self) {
	GtkActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


SeahorsePkcs11PrivateKey* seahorse_pkcs11_certificate_get_partner (SeahorsePkcs11Certificate* self) {
	SeahorsePkcs11PrivateKey* result;
	GObject* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey);
	return result;
}


void seahorse_pkcs11_certificate_set_partner (SeahorsePkcs11Certificate* self, SeahorsePkcs11PrivateKey* value) {
	SeahorsePkcs11PrivateKey* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_weak_ref_set (&self->priv->_private_key, (GObject*) _tmp0_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = NULL;
	g_object_notify ((GObject*) self, "partner");
	g_object_notify ((GObject*) self, "icon");
	g_object_notify ((GObject*) self, "description");
	g_object_notify ((GObject *) self, "partner");
}


static GckAttributes* _vala_GckAttributes_copy (GckAttributes* self) {
	return g_boxed_copy (gck_attributes_get_type (), self);
}


static gpointer __vala_GckAttributes_copy0 (gpointer self) {
	return self ? _vala_GckAttributes_copy (self) : NULL;
}


static GckAttributes* seahorse_pkcs11_certificate_real_get_attributes (GckObjectCache* base) {
	GckAttributes* result;
	SeahorsePkcs11Certificate* self;
	GckAttributes* _tmp0_ = NULL;
	GckAttributes* _tmp1_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_attributes;
	_tmp1_ = __vala_GckAttributes_copy0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void seahorse_pkcs11_certificate_real_set_attributes (GckObjectCache* base, GckAttributes* value) {
	SeahorsePkcs11Certificate* self;
	GckAttributes* _tmp0_ = NULL;
	GckAttributes* _tmp1_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = value;
	_tmp1_ = __vala_GckAttributes_copy0 (_tmp0_);
	__vala_GckAttributes_free0 (self->priv->_attributes);
	self->priv->_attributes = _tmp1_;
	g_object_notify ((GObject*) self, "attributes");
	g_object_notify ((GObject *) self, "attributes");
}


static gboolean seahorse_pkcs11_certificate_real_get_deletable (SeahorseDeletable* base) {
	gboolean result;
	SeahorsePkcs11Certificate* self;
	SeahorsePkcs11Token* token = NULL;
	SeahorsePkcs11Token* _tmp0_ = NULL;
	SeahorsePkcs11Token* _tmp1_ = NULL;
	SeahorsePkcs11Token* _tmp2_ = NULL;
	SeahorsePkcs11Token* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = seahorse_pkcs11_certificate_get_place (self);
	_tmp1_ = _tmp0_;
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp3_ = token;
	_tmp4_ = seahorse_pkcs11_token_is_deletable (_tmp3_, (GckObject*) self);
	result = _tmp4_;
	_g_object_unref0 (token);
	return result;
}


static gboolean seahorse_pkcs11_certificate_real_get_exportable (SeahorseExportable* base) {
	gboolean result;
	SeahorsePkcs11Certificate* self;
	GckAttribute* _tmp0_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_der;
	result = _tmp0_ != NULL;
	return result;
}


static GIcon* seahorse_pkcs11_certificate_real_get_icon (GcrCertificate* base) {
	GIcon* result;
	SeahorsePkcs11Certificate* self;
	GIcon* _tmp0_ = NULL;
	GThemedIcon* icon = NULL;
	GThemedIcon* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GIcon* _tmp15_ = NULL;
	GIcon* _tmp16_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = self->priv->_icon;
	if (_tmp0_ != NULL) {
		GIcon* _tmp1_ = NULL;
		GIcon* _tmp2_ = NULL;
		_tmp1_ = self->priv->_icon;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_CERTIFICATE);
	icon = _tmp3_;
	_tmp4_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		GThemedIcon* eicon = NULL;
		GThemedIcon* _tmp7_ = NULL;
		GEmblem* emblem = NULL;
		GThemedIcon* _tmp8_ = NULL;
		GEmblem* _tmp9_ = NULL;
		GThemedIcon* _tmp10_ = NULL;
		GEmblem* _tmp11_ = NULL;
		GEmblemedIcon* _tmp12_ = NULL;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_KEY);
		eicon = _tmp7_;
		_tmp8_ = eicon;
		_tmp9_ = g_emblem_new ((GIcon*) _tmp8_);
		emblem = _tmp9_;
		_tmp10_ = icon;
		_tmp11_ = emblem;
		_tmp12_ = (GEmblemedIcon*) g_emblemed_icon_new ((GIcon*) _tmp10_, _tmp11_);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = (GIcon*) _tmp12_;
		_g_object_unref0 (emblem);
		_g_object_unref0 (eicon);
	} else {
		GThemedIcon* _tmp13_ = NULL;
		GIcon* _tmp14_ = NULL;
		_tmp13_ = icon;
		_tmp14_ = _g_object_ref0 ((GIcon*) _tmp13_);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp14_;
	}
	_tmp15_ = self->priv->_icon;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	_g_object_unref0 (icon);
	return result;
}


static gchar* seahorse_pkcs11_certificate_real_get_description (GcrCertificate* base) {
	gchar* result;
	SeahorsePkcs11Certificate* self;
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	SeahorseFlags _tmp5_ = 0;
	self = (SeahorsePkcs11Certificate*) base;
	seahorse_pkcs11_certificate_ensure_flags (self);
	_tmp0_ = g_weak_ref_get (&self->priv->_private_key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = _ ("Personal certificate and key");
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->_flags;
	if ((_tmp5_ & SEAHORSE_FLAG_PERSONAL) == SEAHORSE_FLAG_PERSONAL) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = _ ("Personal certificate");
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		return result;
	} else {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = _ ("Certificate");
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		return result;
	}
}


static gchar* seahorse_pkcs11_certificate_real_get_label (GcrCertificate* base) {
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_subject_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}


static gchar* seahorse_pkcs11_certificate_real_get_subject (GcrCertificate* base) {
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_subject_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}


static gchar* seahorse_pkcs11_certificate_real_get_markup (GcrCertificate* base) {
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_markup_text ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}


static gchar* seahorse_pkcs11_certificate_real_get_issuer (GcrCertificate* base) {
	gchar* result;
	SeahorsePkcs11Certificate* self;
	gchar* _tmp0_ = NULL;
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_issuer_name ((GcrCertificate*) self);
	result = _tmp0_;
	return result;
}


static void seahorse_pkcs11_certificate_real_get_expiry (GcrCertificate* base, GDate* result) {
	SeahorsePkcs11Certificate* self;
	GDate* _tmp0_ = NULL;
	GDate* _tmp1_ = NULL;
	GDate _tmp2_ = {0};
	self = (SeahorsePkcs11Certificate*) base;
	_tmp0_ = gcr_certificate_get_expiry_date ((GcrCertificate*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *_tmp1_;
	_g_free0 (_tmp1_);
	*result = _tmp2_;
	return;
}


static void _seahorse_pkcs11_certificate___lambda9_ (SeahorsePkcs11Certificate* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GckAttributes* _tmp2_ = NULL;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->name;
	if (g_strcmp0 (_tmp1_, "attributes") != 0) {
		return;
	}
	_tmp2_ = self->priv->_attributes;
	if (_tmp2_ != NULL) {
		GckAttributes* _tmp3_ = NULL;
		GckAttribute* _tmp4_ = NULL;
		_tmp3_ = self->priv->_attributes;
		_tmp4_ = gck_attributes_find (_tmp3_, CKA_VALUE);
		self->priv->_der = _tmp4_;
	}
	g_object_notify ((GObject*) self, "label");
	g_object_notify ((GObject*) self, "markup");
	g_object_notify ((GObject*) self, "subject");
	g_object_notify ((GObject*) self, "issuer");
	g_object_notify ((GObject*) self, "expiry");
}


static void __seahorse_pkcs11_certificate___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_seahorse_pkcs11_certificate___lambda9_ (self, pspec);
}


static GObject * seahorse_pkcs11_certificate_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Certificate * self;
	guint _tmp0_ = 0U;
	GckAttributes* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	_tmp0_ = G_MAXUINT;
	self->priv->_flags = (SeahorseFlags) _tmp0_;
	self->priv->_der = NULL;
	g_weak_ref_clear (&self->priv->_private_key);
	g_weak_ref_init (&self->priv->_private_key, NULL);
	g_weak_ref_clear (&self->priv->_token);
	g_weak_ref_init (&self->priv->_token, NULL);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __seahorse_pkcs11_certificate___lambda9__g_object_notify, self, 0);
	_tmp1_ = self->priv->_attributes;
	if (_tmp1_ != NULL) {
		GckAttributes* _tmp2_ = NULL;
		GckAttribute* _tmp3_ = NULL;
		_tmp2_ = self->priv->_attributes;
		_tmp3_ = gck_attributes_find (_tmp2_, CKA_VALUE);
		self->priv->_der = _tmp3_;
	}
	return obj;
}


static void seahorse_pkcs11_certificate_class_init (SeahorsePkcs11CertificateClass * klass) {
	guint8* _tmp0_ = NULL;
	seahorse_pkcs11_certificate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorsePkcs11CertificatePrivate));
	G_OBJECT_CLASS (klass)->dispose = seahorse_pkcs11_certificate_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_certificate_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_certificate_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_certificate_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_certificate_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_PLACE, g_param_spec_object ("place", "place", "place", SEAHORSE_PKCS11_TYPE_TOKEN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS, g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ACTIONS, g_param_spec_object ("actions", "actions", "actions", GTK_TYPE_ACTION_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_PARTNER, g_param_spec_object ("partner", "partner", "partner", SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES, g_param_spec_boxed ("attributes", "attributes", "attributes", gck_attributes_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_DELETABLE, g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE, g_param_spec_boolean ("exportable", "exportable", "exportable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_MARKUP, g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_ISSUER, g_param_spec_string ("issuer", "issuer", "issuer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_CERTIFICATE_EXPIRY, g_param_spec_boxed ("expiry", "expiry", "expiry", G_TYPE_DATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_new0 (guint8, 0);
	seahorse_pkcs11_certificate_EMPTY = _tmp0_;
	seahorse_pkcs11_certificate_EMPTY_length1 = 0;
}


static void seahorse_pkcs11_certificate_gcr_comparable_interface_init (GcrComparableIface * iface) {
	seahorse_pkcs11_certificate_gcr_comparable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare = (gint (*)(GcrComparable*, GcrComparable*)) seahorse_pkcs11_certificate_real_compare;
}


static void seahorse_pkcs11_certificate_gcr_certificate_interface_init (GcrCertificateIface * iface) {
	seahorse_pkcs11_certificate_gcr_certificate_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_der_data = (guint8* (*)(GcrCertificate*, gsize*)) seahorse_pkcs11_certificate_real_get_der_data;
}


static void seahorse_pkcs11_certificate_gck_object_cache_interface_init (GckObjectCacheIface * iface) {
	seahorse_pkcs11_certificate_gck_object_cache_parent_iface = g_type_interface_peek_parent (iface);
	iface->fill = (void (*)(GckObjectCache*, GckAttributes*)) seahorse_pkcs11_certificate_real_fill;
}


static void seahorse_pkcs11_certificate_seahorse_deletable_interface_init (SeahorseDeletableIface * iface) {
	seahorse_pkcs11_certificate_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*)(SeahorseDeletable*)) seahorse_pkcs11_certificate_real_create_deleter;
	iface->get_deletable = seahorse_pkcs11_certificate_real_get_deletable;
}


static void seahorse_pkcs11_certificate_seahorse_exportable_interface_init (SeahorseExportableIface * iface) {
	seahorse_pkcs11_certificate_seahorse_exportable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_exporters = (GList* (*)(SeahorseExportable*, SeahorseExporterType)) seahorse_pkcs11_certificate_real_create_exporters;
	iface->get_exportable = seahorse_pkcs11_certificate_real_get_exportable;
}


static void seahorse_pkcs11_certificate_seahorse_viewable_interface_init (SeahorseViewableIface * iface) {
	seahorse_pkcs11_certificate_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*)(SeahorseViewable*, GtkWindow*)) seahorse_pkcs11_certificate_real_create_viewer;
}


static void seahorse_pkcs11_certificate_instance_init (SeahorsePkcs11Certificate * self) {
	self->priv = SEAHORSE_PKCS11_CERTIFICATE_GET_PRIVATE (self);
}


static void seahorse_pkcs11_certificate_finalize (GObject* obj) {
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	g_weak_ref_clear (&self->priv->_token);
	__vala_GckAttributes_free0 (self->priv->_attributes);
	g_weak_ref_clear (&self->priv->_private_key);
	_g_object_unref0 (self->priv->_icon);
	G_OBJECT_CLASS (seahorse_pkcs11_certificate_parent_class)->finalize (obj);
}


GType seahorse_pkcs11_certificate_get_type (void) {
	static volatile gsize seahorse_pkcs11_certificate_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_pkcs11_certificate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11CertificateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_certificate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Certificate), 0, (GInstanceInitFunc) seahorse_pkcs11_certificate_instance_init, NULL };
		static const GInterfaceInfo gcr_comparable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gcr_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gcr_certificate_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gcr_certificate_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gck_object_cache_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_gck_object_cache_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_exportable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_exportable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_pkcs11_certificate_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_pkcs11_certificate_type_id;
		seahorse_pkcs11_certificate_type_id = g_type_register_static (gck_object_get_type (), "SeahorsePkcs11Certificate", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gcr_comparable_get_type (), &gcr_comparable_info);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gcr_certificate_get_type (), &gcr_certificate_info);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, gck_object_cache_get_type (), &gck_object_cache_info);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_EXPORTABLE, &seahorse_exportable_info);
		g_type_add_interface_static (seahorse_pkcs11_certificate_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
		g_once_init_leave (&seahorse_pkcs11_certificate_type_id__volatile, seahorse_pkcs11_certificate_type_id);
	}
	return seahorse_pkcs11_certificate_type_id__volatile;
}


static void _vala_seahorse_pkcs11_certificate_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	switch (property_id) {
		case SEAHORSE_PKCS11_CERTIFICATE_PLACE:
		g_value_take_object (value, seahorse_pkcs11_certificate_get_place (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_OBJECT_FLAGS:
		g_value_set_flags (value, seahorse_pkcs11_certificate_get_object_flags (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ACTIONS:
		g_value_set_object (value, seahorse_pkcs11_certificate_get_actions (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_PARTNER:
		g_value_take_object (value, seahorse_pkcs11_certificate_get_partner (self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES:
		g_value_take_boxed (value, seahorse_pkcs11_certificate_real_get_attributes ((GckObjectCache*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_DELETABLE:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_EXPORTABLE:
		g_value_set_boolean (value, seahorse_exportable_get_exportable ((SeahorseExportable*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ICON:
		g_value_take_object (value, seahorse_pkcs11_certificate_real_get_icon ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_DESCRIPTION:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_description ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_LABEL:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_label ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_SUBJECT:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_subject ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_MARKUP:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_markup ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ISSUER:
		g_value_take_string (value, seahorse_pkcs11_certificate_real_get_issuer ((GcrCertificate*) self));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_EXPIRY:
		{
			GDate boxed;
			seahorse_pkcs11_certificate_real_get_expiry ((GcrCertificate*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_pkcs11_certificate_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorsePkcs11Certificate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate);
	switch (property_id) {
		case SEAHORSE_PKCS11_CERTIFICATE_PLACE:
		seahorse_pkcs11_certificate_set_place (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_PARTNER:
		seahorse_pkcs11_certificate_set_partner (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_CERTIFICATE_ATTRIBUTES:
		seahorse_pkcs11_certificate_real_set_attributes ((GckObjectCache*) self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



