/* rygel-http-post-test.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-http-post-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_POST_TEST (rygel_http_post_test_get_type ())
#define RYGEL_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTest))
#define RYGEL_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))
#define RYGEL_IS_HTTP_POST_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_IS_HTTP_POST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST_TEST))
#define RYGEL_HTTP_POST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestClass))

typedef struct _RygelHTTPPostTest RygelHTTPPostTest;
typedef struct _RygelHTTPPostTestClass RygelHTTPPostTestClass;
typedef struct _RygelHTTPPostTestPrivate RygelHTTPPostTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpPostTestHandleClientMessageData RygelHttpPostTestHandleClientMessageData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpPostTestCheckAndExitData RygelHttpPostTestCheckAndExitData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _Block3Data Block3Data;
typedef struct _RygelMediaItemGetWritableData RygelMediaItemGetWritableData;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block4Data Block4Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemRemovalQueuePrivate RygelItemRemovalQueuePrivate;
typedef struct _RygelItemRemovalQueueRemoveNowData RygelItemRemovalQueueRemoveNowData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPPostTest {
	GObject parent_instance;
	RygelHTTPPostTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPPostTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPPostTest* self, GError** error);
};

struct _RygelHTTPPostTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpPostTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	SoupMessage* msg;
	RygelHTTPRequest* _tmp0_;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp1_;
	GError * _error_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gchar* id;
	RygelMediaItem* item;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	RygelMediaContainer* parent;
	gchar* id;
	glong size;
	glong duration;
	gboolean place_holder;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	guint8* content;
	gint content_length1;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpPostTestCheckAndExitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPPostTest* self;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* file;
	GFileInputStream* _tmp2_;
	GFileInputStream* stream;
	guint8* _tmp3_;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint i;
	gboolean _tmp4_;
	GError * _error_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
};

struct _RygelMediaContainerPrivate {
	GFileMonitor* monitor;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelMediaObject* _tmp0_;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaItem * self;
	GSourceFunc get_writable_continue;
	gpointer get_writable_continue_target;
	GDestroyNotify get_writable_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaItemGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaItem* self;
	GCancellable* cancellable;
	GFile* result;
	Block3Data* _data3_;
	GFile* _tmp0_;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block4Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block4Data* _data4_;
};

struct _RygelItemRemovalQueue {
	GObject parent_instance;
	RygelItemRemovalQueuePrivate * priv;
};

struct _RygelItemRemovalQueueClass {
	GObjectClass parent_class;
};

struct _RygelItemRemovalQueueRemoveNowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemRemovalQueue* self;
	RygelMediaItem* item;
	GCancellable* cancellable;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

static gpointer rygel_http_post_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_item_removal_queue_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_post_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_POST_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_POST_TEST, RygelHTTPPostTestPrivate))
enum  {
	RYGEL_HTTP_POST_TEST_DUMMY_PROPERTY
};
gint rygel_http_post_test_main (gchar** args, int args_length1);
RygelHTTPPostTest* rygel_http_post_test_new (GError** error);
RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error);
void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri);
static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error);
static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self);
static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client);
static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_);
static void rygel_http_post_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* data);
static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static void rygel_http_post_test_check_and_exit_data_free (gpointer _data);
static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* data);
static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_HTTP_CLIENT_LENGTH ((gsize) 1024)
static void rygel_http_post_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda2_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerPrivate))
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent);
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent);
void rygel_media_container_on_file_changed (RygelMediaContainer* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _rygel_media_container_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean _lambda1_ (Block2Data* _data2_);
static gboolean __lambda1__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__RYGEL_MEDIA_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_container_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_URI "file:///tmp/rygel-upload-test.wav"
static void rygel_media_item_get_writable_data_free (gpointer _data);
void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self);
static gboolean _lambda0_ (Block3Data* _data3_);
static gboolean __lambda0__gsource_func (gpointer self);
static void rygel_media_item_finalize (RygelMediaObject* obj);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean _lambda5_ (Block4Data* _data4_);
static gboolean __lambda5__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_ITEM_REMOVAL_QUEUE_DUMMY_PROPERTY
};
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
RygelItemRemovalQueue* rygel_item_removal_queue_new (void);
RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_item_removal_queue_remove_now_data_free (gpointer _data);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* data);
static gboolean _rygel_item_removal_queue_remove_now_co_gsource_func (gpointer self);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
GQuark rygel_content_directory_error_quark (void);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


gint rygel_http_post_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelHTTPPostTest* _tmp0_ = NULL;
	RygelHTTPPostTest* test;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_http_post_test_new (&_inner_error_);
	test = _tmp0_;
	if (_inner_error_ != NULL) {
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	rygel_http_post_test_run (test, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (test);
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	_g_object_unref0 (test);
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = _error_->code;
		_g_error_free0 (_error_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("rygel-http-post-test.vala:51: %s", _error_->message);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return rygel_http_post_test_main (argv, argc);
}


RygelHTTPPostTest* rygel_http_post_test_construct (GType object_type, GError** error) {
	RygelHTTPPostTest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelHTTPClient* _tmp5_ = NULL;
	RygelHTTPClient* _tmp6_;
	GMainLoop* _tmp7_ = NULL;
	GMainLoop* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPPostTest*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_http_server_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->server);
	self->server = _tmp2_;
	_tmp3_ = rygel_http_server_get_uri (self->server);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_http_client_new (self->server->context, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->client);
	self->client = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_tmp8_ = _tmp7_;
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp8_;
	return self;
}


RygelHTTPPostTest* rygel_http_post_test_new (GError** error) {
	return rygel_http_post_test_construct (RYGEL_TYPE_HTTP_POST_TEST, error);
}


static gboolean _rygel_http_post_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_post_test_on_timeout (self);
	return result;
}


static void _rygel_http_post_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
	rygel_http_post_test_on_message_received (self, _sender, message);
}


static void _rygel_http_post_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_post_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_http_post_test_real_run (RygelHTTPPostTest* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_post_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_post_test_on_message_received_rygel_http_server_message_received, self, 0);
	g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_post_test_on_client_completed_rygel_state_machine_completed, self, 0);
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
	g_main_loop_run (self->priv->main_loop);
	if (self->priv->error != NULL) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (self->priv->error);
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_http_post_test_run (RygelHTTPPostTest* self, GError** error) {
	RYGEL_HTTP_POST_TEST_GET_CLASS (self)->run (self, error);
}


static RygelHTTPRequest* rygel_http_post_test_create_request (RygelHTTPPostTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPRequest* result = NULL;
	SoupServer* _tmp0_ = NULL;
	RygelHTTPPost* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = gupnp_context_get_server (self->server->context);
	_tmp1_ = rygel_http_post_new (self->server, _tmp0_, msg);
	result = (RygelHTTPRequest*) _tmp1_;
	return result;
}


static void rygel_http_post_test_on_client_completed (RygelHTTPPostTest* self, RygelStateMachine* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	self->priv->client_done = TRUE;
	rygel_http_post_test_check_and_exit (self, NULL, NULL);
}


static void rygel_http_post_test_on_message_received (RygelHTTPPostTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	rygel_http_post_test_handle_client_message (self, msg, NULL, NULL);
}


static void rygel_http_post_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpPostTestHandleClientMessageData* data;
	data = _data;
	_g_object_unref0 (data->msg);
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostTestHandleClientMessageData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_post_test_handle_client_message (RygelHTTPPostTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostTestHandleClientMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_handle_client_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_handle_client_message_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->msg = _g_object_ref0 (msg);
	rygel_http_post_test_handle_client_message_co (_data_);
}


static void rygel_http_post_test_handle_client_message_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestHandleClientMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestHandleClientMessageData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_post_test_handle_client_message_co (data);
}


static gboolean rygel_http_post_test_handle_client_message_co (RygelHttpPostTestHandleClientMessageData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_http_post_test_create_request (data->self, data->msg, &data->_inner_error_);
	data->request = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	data->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) data->request, rygel_http_post_test_handle_client_message_ready, data);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) data->request, data->_res_);
	g_assert (((RygelHTTPRequest*) (data->_tmp1_ = data->request, RYGEL_IS_HTTP_POST (data->_tmp1_) ? ((RygelHTTPPost*) data->_tmp1_) : NULL))->item != NULL);
	data->self->priv->server_done = TRUE;
	rygel_http_post_test_check_and_exit (data->self, NULL, NULL);
	_g_object_unref0 (data->request);
	goto __finally1;
	__catch1_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = _g_error_copy0 (data->_error_);
		data->_tmp3_ = data->_tmp2_;
		_g_error_free0 (data->self->priv->error);
		data->self->priv->error = data->_tmp3_;
		g_main_loop_quit (data->self->priv->main_loop);
		_g_error_free0 (data->_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean rygel_http_post_test_on_timeout (RygelHTTPPostTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
	_tmp1_ = _tmp0_;
	_g_error_free0 (self->priv->error);
	self->priv->error = _tmp1_;
	g_main_loop_quit (self->priv->main_loop);
	result = FALSE;
	return result;
}


static void rygel_http_post_test_check_and_exit_data_free (gpointer _data) {
	RygelHttpPostTestCheckAndExitData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpPostTestCheckAndExitData, data);
}


static void rygel_http_post_test_check_and_exit (RygelHTTPPostTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* _data_;
	_data_ = g_slice_new0 (RygelHttpPostTestCheckAndExitData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_post_test_check_and_exit);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_post_test_check_and_exit_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_post_test_check_and_exit_co (_data_);
}


static void rygel_http_post_test_check_and_exit_finish (RygelHTTPPostTest* self, GAsyncResult* _res_) {
	RygelHttpPostTestCheckAndExitData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_post_test_check_and_exit_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpPostTestCheckAndExitData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_post_test_check_and_exit_co (data);
}


static gboolean rygel_http_post_test_check_and_exit_co (RygelHttpPostTestCheckAndExitData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->server_done) {
		data->_tmp0_ = data->self->priv->client_done;
	} else {
		data->_tmp0_ = FALSE;
	}
	if (!data->_tmp0_) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = _g_object_ref0 (data->self->server->root_container->item->file);
	data->file = data->_tmp1_;
	data->_state_ = 1;
	g_file_read_async (data->file, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
	data->stream = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		goto __catch2_g_error;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (guint8, RYGEL_HTTP_CLIENT_LENGTH);
	data->buffer = data->_tmp3_;
	data->buffer_length1 = RYGEL_HTTP_CLIENT_LENGTH;
	data->_buffer_size_ = RYGEL_HTTP_CLIENT_LENGTH;
	data->_state_ = 2;
	g_input_stream_read_async ((GInputStream*) data->stream, data->buffer, (gsize) data->buffer_length1, G_PRIORITY_HIGH, NULL, rygel_http_post_test_check_and_exit_ready, data);
	return FALSE;
	_state_2:
	g_input_stream_read_finish ((GInputStream*) data->stream, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		data->buffer = (g_free (data->buffer), NULL);
		_g_object_unref0 (data->stream);
		_g_object_unref0 (data->file);
		goto __catch2_g_error;
	}
	{
		data->i = 0;
		{
			data->_tmp4_ = TRUE;
			while (TRUE) {
				if (!data->_tmp4_) {
					data->i++;
				}
				data->_tmp4_ = FALSE;
				if (!(data->i < RYGEL_HTTP_CLIENT_LENGTH)) {
					break;
				}
				g_assert (data->buffer[data->i] == data->self->client->content[data->i]);
			}
		}
	}
	data->buffer = (g_free (data->buffer), NULL);
	_g_object_unref0 (data->stream);
	_g_object_unref0 (data->file);
	goto __finally2;
	__catch2_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp5_ = _g_error_copy0 (data->_error_);
		data->_tmp6_ = data->_tmp5_;
		_g_error_free0 (data->self->priv->error);
		data->self->priv->error = data->_tmp6_;
		_g_error_free0 (data->_error_);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_main_loop_quit (data->self->priv->main_loop);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_post_test_class_init (RygelHTTPPostTestClass * klass) {
	rygel_http_post_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPPostTestPrivate));
	RYGEL_HTTP_POST_TEST_CLASS (klass)->run = rygel_http_post_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_post_test_finalize;
}


static void rygel_http_post_test_instance_init (RygelHTTPPostTest * self) {
	self->priv = RYGEL_HTTP_POST_TEST_GET_PRIVATE (self);
}


static void rygel_http_post_test_finalize (GObject* obj) {
	RygelHTTPPostTest * self;
	self = RYGEL_HTTP_POST_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_post_test_parent_class)->finalize (obj);
}


GType rygel_http_post_test_get_type (void) {
	static volatile gsize rygel_http_post_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_post_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPostTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_post_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPostTest), 0, (GInstanceInitFunc) rygel_http_post_test_instance_init, NULL };
		GType rygel_http_post_test_type_id;
		rygel_http_post_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPPostTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_post_test_type_id__volatile, rygel_http_post_test_type_id);
	}
	return rygel_http_post_test_type_id__volatile;
}


static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
	rygel_http_server_on_request_started (self, _sender, msg, client);
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	const gchar* _tmp4_ = NULL;
	guint _tmp5_;
	SoupServer* _tmp6_ = NULL;
	RygelMediaContainer* _tmp7_ = NULL;
	RygelMediaContainer* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->context);
	self->context = _tmp2_;
	goto __finally3;
	__catch3_g_error:
	{
		GError * _error_;
		GError* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
		_inner_error_ = _tmp3_;
		_g_error_free0 (_error_);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_assert (self->context != NULL);
	_tmp4_ = gssdp_client_get_host_ip ((GSSDPClient*) self->context);
	g_assert (_tmp4_ != NULL);
	_tmp5_ = gupnp_context_get_port (self->context);
	g_assert (_tmp5_ > 0);
	_tmp6_ = gupnp_context_get_server (self->context);
	g_signal_connect_object (_tmp6_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, self, 0);
	_tmp7_ = rygel_media_container_new ();
	_tmp8_ = _tmp7_;
	_rygel_media_object_unref0 (self->root_container);
	self->root_container = _tmp8_;
	return self;
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
}


static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	rygel_http_server_on_got_headers (self, _sender);
}


static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, SoupClientContext* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (client != NULL);
	g_signal_connect_object (msg, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
}


static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_signal_emit_by_name (self, "message-received", msg);
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
	return result;
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	RygelHTTPItemURI* _tmp0_ = NULL;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
	item_uri = _tmp0_;
	_tmp1_ = rygel_http_item_uri_to_string (item_uri);
	result = _tmp1_;
	_g_object_unref0 (item_uri);
	return result;
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_rygel_media_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	guint8* _tmp2_ = NULL;
	guint8* _tmp3_;
	SoupMessage* _tmp4_ = NULL;
	SoupMessage* _tmp5_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->context);
	self->context = _tmp1_;
	_tmp2_ = g_new0 (guint8, 1024);
	_tmp3_ = _tmp2_;
	self->content = (g_free (self->content), NULL);
	self->content_length1 = 1024;
	self->content = _tmp3_;
	_tmp4_ = soup_message_new ("POST", uri);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->msg);
	self->msg = _tmp5_;
	g_assert (self->msg != NULL);
	return self;
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri) {
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


static void _lambda2_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
	RygelHTTPClient * self;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	g_return_if_fail (msg != NULL);
	_data1_->run_continue (_data1_->run_continue_target);
}


static void __lambda2__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	_lambda2_ (session, msg, self);
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
	data->_data1_->run_continue_target = data;
	data->_data1_->run_continue_target_destroy_notify = NULL;
	soup_message_body_append (data->self->msg->request_body, SOUP_MEMORY_COPY, (gconstpointer) data->self->content, (gsize) data->self->content_length1);
	data->_tmp0_ = NULL;
	data->_tmp0_ = gupnp_context_get_session (data->self->context);
	data->_tmp1_ = _g_object_ref0 (data->self->msg);
	soup_session_queue_message (data->_tmp0_, data->_tmp1_, __lambda2__soup_session_callback, data->_data1_);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPClient*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	self->content = (g_free (self->content), NULL);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _rygel_media_container_on_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_container_on_file_changed (self, _sender, file, other_file, event_type);
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	RygelMediaItem* _tmp1_;
	GFileMonitor* _tmp2_ = NULL;
	GFileMonitor* _tmp3_;
	GFileMonitor* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	_tmp0_ = rygel_media_item_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self);
	_tmp1_ = _tmp0_;
	_rygel_media_object_unref0 (self->item);
	self->item = _tmp1_;
	_tmp2_ = g_file_monitor_file (self->item->file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp4_;
	g_signal_connect (self->priv->monitor, "changed", (GCallback) _rygel_media_container_on_file_changed_g_file_monitor_changed, self);
	return self;
}


RygelMediaContainer* rygel_media_container_new (void) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->item_id);
	_g_object_unref0 (data->cancellable);
	_rygel_media_object_unref0 (data->result);
	_rygel_media_object_unref0 (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
	_data_->self = _rygel_media_object_ref0 (self);
	_data_->item_id = g_strdup (item_id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_find_object_co (_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_rygel_media_object_unref0 (_data2_->self);
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
		_data2_->find_object_continue = NULL;
		_data2_->find_object_continue_target = NULL;
		_data2_->find_object_continue_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
	return result;
}


static gboolean _lambda1_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	self = _data2_->self;
	_data2_->find_object_continue (_data2_->find_object_continue_target);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = rygel_media_object_ref (data->self);
	data->_data2_->_async_data_ = data;
	data->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
	data->_data2_->find_object_continue_target = data;
	data->_data2_->find_object_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, block2_data_ref (data->_data2_), block2_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (g_strcmp0 (data->item_id, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
		data->_tmp0_ = _rygel_media_object_ref0 ((RygelMediaObject*) data->self->item);
		data->result = data->_tmp0_;
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->result = NULL;
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_media_container_on_file_changed (RygelMediaContainer* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	g_signal_emit_by_name (self, "container-updated", self);
}


static void g_cclosure_user_marshal_VOID__RYGEL_MEDIA_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__RYGEL_MEDIA_OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__RYGEL_MEDIA_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__RYGEL_MEDIA_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, rygel_value_get_media_object (param_values + 1), data2);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_container_finalize;
	g_type_class_add_private (klass, sizeof (RygelMediaContainerPrivate));
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__RYGEL_MEDIA_OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_MEDIA_CONTAINER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("TesContainer");
	self->id = _tmp0_;
}


static void rygel_media_container_finalize (RygelMediaObject* obj) {
	RygelMediaContainer * self;
	self = RYGEL_MEDIA_CONTAINER (obj);
	_g_free0 (self->id);
	_rygel_media_object_unref0 (self->item);
	_g_object_unref0 (self->priv->monitor);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_container_parent_class)->finalize (obj);
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent) {
	RygelMediaItem* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	_tmp0_ = g_strdup (id);
	_tmp1_ = _tmp0_;
	_g_free0 (self->id);
	self->id = _tmp1_;
	self->parent = parent;
	_tmp2_ = g_file_new_for_uri (RYGEL_MEDIA_ITEM_URI);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->file);
	self->file = _tmp3_;
	return self;
}


RygelMediaItem* rygel_media_item_new (const gchar* id, RygelMediaContainer* parent) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM, id, parent);
}


static void rygel_media_item_get_writable_data_free (gpointer _data) {
	RygelMediaItemGetWritableData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_rygel_media_object_unref0 (data->self);
	g_slice_free (RygelMediaItemGetWritableData, data);
}


void rygel_media_item_get_writable (RygelMediaItem* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaItemGetWritableData* _data_;
	_data_ = g_slice_new0 (RygelMediaItemGetWritableData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_item_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_item_get_writable_data_free);
	_data_->self = _rygel_media_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_item_get_writable_co (_data_);
}


GFile* rygel_media_item_get_writable_finish (RygelMediaItem* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaItemGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_rygel_media_object_unref0 (_data3_->self);
		(_data3_->get_writable_continue_target_destroy_notify == NULL) ? NULL : (_data3_->get_writable_continue_target_destroy_notify (_data3_->get_writable_continue_target), NULL);
		_data3_->get_writable_continue = NULL;
		_data3_->get_writable_continue_target = NULL;
		_data3_->get_writable_continue_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _rygel_media_item_get_writable_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_item_get_writable_co (self);
	return result;
}


static gboolean _lambda0_ (Block3Data* _data3_) {
	RygelMediaItem * self;
	gboolean result = FALSE;
	self = _data3_->self;
	_data3_->get_writable_continue (_data3_->get_writable_continue_target);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static gboolean rygel_media_item_get_writable_co (RygelMediaItemGetWritableData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = rygel_media_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	data->_data3_->get_writable_continue = _rygel_media_item_get_writable_co_gsource_func;
	data->_data3_->get_writable_continue_target = data;
	data->_data3_->get_writable_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, block3_data_ref (data->_data3_), block3_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	data->_tmp0_ = _g_object_ref0 (data->self->file);
	data->result = data->_tmp0_;
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (glong) 1024;
	self->duration = (glong) 1024;
	self->place_holder = TRUE;
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	GError * _inner_error_ = NULL;
	self = RYGEL_MEDIA_ITEM (obj);
	g_file_delete (self->file, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_free0 (self->id);
	_g_object_unref0 (self->file);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPPost* get_request) {
	RygelHTTPResponse * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupServer* _tmp2_;
	SoupServer* _tmp3_;
	g_return_val_if_fail (get_request != NULL, NULL);
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->msg);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->msg);
	self->priv->msg = _tmp1_;
	_tmp2_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->server);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp3_;
	return self;
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPPost* get_request) {
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpResponseRunData, data);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		(_data4_->run_continue_target_destroy_notify == NULL) ? NULL : (_data4_->run_continue_target_destroy_notify (_data4_->run_continue_target), NULL);
		_data4_->run_continue = NULL;
		_data4_->run_continue_target = NULL;
		_data4_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


static gboolean _lambda5_ (Block4Data* _data4_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
	self = _data4_->self;
	_data4_->run_continue (_data4_->run_continue_target);
	result = FALSE;
	return result;
}


static gboolean __lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda5_ (self);
	return result;
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data4_ = g_slice_new0 (Block4Data);
	data->_data4_->_ref_count_ = 1;
	data->_data4_->self = g_object_ref (data->self);
	data->_data4_->_async_data_ = data;
	data->_data4_->run_continue = _rygel_http_response_real_run_co_gsource_func;
	data->_data4_->run_continue_target = data;
	data->_data4_->run_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda5__gsource_func, block4_data_ref (data->_data4_), block4_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	soup_message_set_status (data->self->priv->msg, (guint) SOUP_STATUS_OK);
	soup_server_unpause_message (data->self->priv->server, data->self->priv->msg);
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	block4_data_unref (data->_data4_);
	data->_data4_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	self = (RygelHTTPResponse*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (obj);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->msg);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void) {
	RygelItemRemovalQueue* result = NULL;
	RygelItemRemovalQueue* _tmp0_ = NULL;
	_tmp0_ = rygel_item_removal_queue_new ();
	result = _tmp0_;
	return result;
}


gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	result = TRUE;
	return result;
}


static void rygel_item_removal_queue_remove_now_data_free (gpointer _data) {
	RygelItemRemovalQueueRemoveNowData* data;
	data = _data;
	_rygel_media_object_unref0 (data->item);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemRemovalQueueRemoveNowData, data);
}


void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	_data_ = g_slice_new0 (RygelItemRemovalQueueRemoveNowData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_removal_queue_remove_now);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_removal_queue_remove_now_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->item = _rygel_media_object_ref0 (item);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_item_removal_queue_remove_now_co (_data_);
}


void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_) {
	RygelItemRemovalQueueRemoveNowData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_item_removal_queue_remove_now_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_item_removal_queue_remove_now_co (self);
	return result;
}


static gboolean rygel_item_removal_queue_remove_now_co (RygelItemRemovalQueueRemoveNowData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_item_removal_queue_remove_now_co_gsource_func, data, NULL);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


RygelItemRemovalQueue* rygel_item_removal_queue_construct (GType object_type) {
	RygelItemRemovalQueue * self = NULL;
	self = (RygelItemRemovalQueue*) g_object_new (object_type, NULL);
	return self;
}


RygelItemRemovalQueue* rygel_item_removal_queue_new (void) {
	return rygel_item_removal_queue_construct (RYGEL_TYPE_ITEM_REMOVAL_QUEUE);
}


static void rygel_item_removal_queue_class_init (RygelItemRemovalQueueClass * klass) {
	rygel_item_removal_queue_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_item_removal_queue_instance_init (RygelItemRemovalQueue * self) {
}


GType rygel_item_removal_queue_get_type (void) {
	static volatile gsize rygel_item_removal_queue_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_removal_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemRemovalQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_removal_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemRemovalQueue), 0, (GInstanceInitFunc) rygel_item_removal_queue_instance_init, NULL };
		GType rygel_item_removal_queue_type_id;
		rygel_item_removal_queue_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemRemovalQueue", &g_define_type_info, 0);
		g_once_init_leave (&rygel_item_removal_queue_type_id__volatile, rygel_item_removal_queue_type_id);
	}
	return rygel_item_removal_queue_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
	self = (RygelMediaObject*) g_type_create_instance (object_type);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_value_media_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_object_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->ref_count = 1;
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}



