/* rygel-media-item.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* date;
	char* mime_type;
	char* dlna_profile;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const char* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const char* uri, const char* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gint64 _size;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	char* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const char* transcode_target);
	char* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_SIZE
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const char* value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value);
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const char* uri);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
const char* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol);
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static void rygel_media_item_finalize (GObject* obj);
static void rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


#line 60 "rygel-media-item.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* upnp_class) {
#line 255 "rygel-media-item.c"
	RygelMediaItem * self;
	char* _tmp0_;
	char* _tmp1_;
#line 60 "rygel-media-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 60 "rygel-media-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 60 "rygel-media-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 60 "rygel-media-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 60 "rygel-media-item.vala"
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
#line 64 "rygel-media-item.vala"
	((RygelMediaObject*) self)->id = (_tmp0_ = g_strdup (id), _g_free0 (((RygelMediaObject*) self)->id), _tmp0_);
#line 65 "rygel-media-item.vala"
	((RygelMediaObject*) self)->parent = parent;
#line 66 "rygel-media-item.vala"
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
#line 67 "rygel-media-item.vala"
	((RygelMediaObject*) self)->upnp_class = (_tmp1_ = g_strdup (upnp_class), _g_free0 (((RygelMediaObject*) self)->upnp_class), _tmp1_);
#line 277 "rygel-media-item.c"
	return self;
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


#line 72 "rygel-media-item.vala"
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self) {
#line 294 "rygel-media-item.c"
	GstElement* result = NULL;
	GstElement* src;
#line 72 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "rygel-media-item.vala"
	src = NULL;
#line 75 "rygel-media-item.vala"
	if (gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) self)->uris) != 0) {
#line 303 "rygel-media-item.c"
		char* _tmp0_;
		GstElement* _tmp1_;
#line 76 "rygel-media-item.vala"
		src = (_tmp1_ = gst_element_make_from_uri (GST_URI_SRC, _tmp0_ = (char*) gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) self)->uris, 0), NULL), _gst_object_unref0 (src), _tmp1_);
#line 308 "rygel-media-item.c"
		_g_free0 (_tmp0_);
	}
#line 79 "rygel-media-item.vala"
	if (src != NULL) {
#line 80 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "blocksize") != NULL) {
#line 83 "rygel-media-item.vala"
			_dynamic_set_blocksize1 (src, (glong) 65536);
#line 317 "rygel-media-item.c"
		}
#line 86 "rygel-media-item.vala"
		if (g_object_class_find_property (G_OBJECT_GET_CLASS ((GObject*) src), "tcp-timeout") != NULL) {
#line 89 "rygel-media-item.vala"
			_dynamic_set_tcp_timeout2 (src, (gint64) 60000000);
#line 323 "rygel-media-item.c"
		}
	}
	result = src;
#line 93 "rygel-media-item.vala"
	return result;
#line 329 "rygel-media-item.c"
}


#line 60 "rygel-media-item.vala"
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
#line 60 "rygel-media-item.vala"
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self);
#line 337 "rygel-media-item.c"
}


#line 99 "rygel-media-item.vala"
gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
#line 343 "rygel-media-item.c"
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 99 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "rygel-media-item.vala"
	if (rygel_media_item_streamable (self)) {
#line 101 "rygel-media-item.vala"
		_tmp0_ = rygel_media_item_get_size (self) <= 0;
#line 352 "rygel-media-item.c"
	} else {
#line 101 "rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 356 "rygel-media-item.c"
	}
	result = _tmp0_;
#line 101 "rygel-media-item.vala"
	return result;
#line 361 "rygel-media-item.c"
}


#line 104 "rygel-media-item.vala"
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
#line 367 "rygel-media-item.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
}


#line 106 "rygel-media-item.vala"
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const char* uri) {
#line 106 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 106 "rygel-media-item.vala"
	g_return_if_fail (uri != NULL);
#line 107 "rygel-media-item.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
#line 387 "rygel-media-item.c"
}


void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 110 "rygel-media-item.vala"
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, void* a, void* b) {
#line 403 "rygel-media-item.c"
	gint result = 0;
	RygelTranscoder* transcoder1;
	RygelTranscoder* transcoder2;
#line 110 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 111 "rygel-media-item.vala"
	transcoder1 = _g_object_ref0 (RYGEL_TRANSCODER (a));
#line 112 "rygel-media-item.vala"
	transcoder2 = _g_object_ref0 (RYGEL_TRANSCODER (b));
#line 413 "rygel-media-item.c"
	result = ((gint) rygel_transcoder_get_distance (transcoder1, self)) - ((gint) rygel_transcoder_get_distance (transcoder2, self));
	_g_object_unref0 (transcoder2);
	_g_object_unref0 (transcoder1);
#line 114 "rygel-media-item.vala"
	return result;
#line 419 "rygel-media-item.c"
}


#line 118 "rygel-media-item.vala"
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
#line 425 "rygel-media-item.c"
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* res;
	gboolean _tmp0_ = FALSE;
	GUPnPProtocolInfo* _tmp1_;
#line 118 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "rygel-media-item.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 118 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 124 "rygel-media-item.vala"
	res = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) didl_item);
#line 126 "rygel-media-item.vala"
	if (uri != NULL) {
#line 126 "rygel-media-item.vala"
		_tmp0_ = !self->place_holder;
#line 442 "rygel-media-item.c"
	} else {
#line 126 "rygel-media-item.vala"
		_tmp0_ = FALSE;
#line 446 "rygel-media-item.c"
	}
#line 126 "rygel-media-item.vala"
	if (_tmp0_) {
#line 127 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, uri);
#line 452 "rygel-media-item.c"
	} else {
#line 132 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_uri (res, "");
#line 456 "rygel-media-item.c"
	}
#line 135 "rygel-media-item.vala"
	if (import_uri != NULL) {
#line 136 "rygel-media-item.vala"
		gupnp_didl_lite_resource_set_import_uri (res, import_uri);
#line 462 "rygel-media-item.c"
	}
#line 139 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_size64 (res, rygel_media_item_get_size (self));
#line 142 "rygel-media-item.vala"
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp1_ = rygel_media_item_get_protocol_info (self, uri, protocol));
#line 468 "rygel-media-item.c"
	_g_object_unref0 (_tmp1_);
	result = res;
#line 144 "rygel-media-item.vala"
	return result;
#line 473 "rygel-media-item.c"
}


GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resource (self, didl_item, uri, protocol, import_uri, error);
}


#line 147 "rygel-media-item.vala"
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const char* property) {
#line 484 "rygel-media-item.c"
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaItem* item;
	const char* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	self = (RygelMediaItem*) base;
#line 147 "rygel-media-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 147 "rygel-media-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 149 "rygel-media-item.vala"
	if (!RYGEL_IS_MEDIA_ITEM (media_object)) {
#line 499 "rygel-media-item.c"
		result = 1;
#line 150 "rygel-media-item.vala"
		return result;
#line 503 "rygel-media-item.c"
	}
#line 153 "rygel-media-item.vala"
	item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
#line 507 "rygel-media-item.c"
	_tmp1_ = property;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("dc:date"))))
	switch (0) {
		default:
		{
			result = rygel_media_item_compare_by_date (self, item);
			_g_object_unref0 (item);
#line 157 "rygel-media-item.vala"
			return result;
#line 518 "rygel-media-item.c"
		}
	} else
	switch (0) {
		default:
		{
			result = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (RYGEL_MEDIA_OBJECT (self), (RygelMediaObject*) item, property);
			_g_object_unref0 (item);
#line 159 "rygel-media-item.vala"
			return result;
#line 528 "rygel-media-item.c"
		}
	}
	_g_object_unref0 (item);
}


#line 163 "rygel-media-item.vala"
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
#line 537 "rygel-media-item.c"
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* didl_item;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
#line 163 "rygel-media-item.vala"
	g_return_val_if_fail (writer != NULL, NULL);
#line 163 "rygel-media-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 166 "rygel-media-item.vala"
	didl_item = gupnp_didl_lite_writer_add_item (writer);
#line 168 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->id);
#line 169 "rygel-media-item.vala"
	if (((RygelMediaObject*) self)->parent != NULL) {
#line 170 "rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) ((RygelMediaObject*) self)->parent)->id);
#line 555 "rygel-media-item.c"
	} else {
#line 172 "rygel-media-item.vala"
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, "0");
#line 559 "rygel-media-item.c"
	}
#line 175 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_item, FALSE);
#line 176 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) didl_item, rygel_media_object_get_title ((RygelMediaObject*) self));
#line 177 "rygel-media-item.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->upnp_class);
#line 184 "rygel-media-item.vala"
	rygel_media_item_add_proxy_resources (self, http_server, didl_item, &_inner_error_);
#line 569 "rygel-media-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_item);
		return NULL;
	}
#line 185 "rygel-media-item.vala"
	if (!self->place_holder) {
#line 577 "rygel-media-item.c"
		gboolean internal_allowed = FALSE;
		gboolean _tmp0_ = FALSE;
#line 188 "rygel-media-item.vala"
		if (_vala_strcmp0 (gssdp_client_get_interface ((GSSDPClient*) http_server->context), "lo") == 0) {
#line 188 "rygel-media-item.vala"
			_tmp0_ = TRUE;
#line 584 "rygel-media-item.c"
		} else {
#line 189 "rygel-media-item.vala"
			_tmp0_ = _vala_strcmp0 (gssdp_client_get_host_ip ((GSSDPClient*) http_server->context), "127.0.0.1") == 0;
#line 588 "rygel-media-item.c"
		}
#line 188 "rygel-media-item.vala"
		internal_allowed = _tmp0_;
#line 190 "rygel-media-item.vala"
		rygel_media_item_add_resources (self, didl_item, internal_allowed, &_inner_error_);
#line 594 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (didl_item);
			return NULL;
		}
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
#line 193 "rygel-media-item.vala"
	return result;
#line 604 "rygel-media-item.c"
}


#line 196 "rygel-media-item.vala"
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
#line 610 "rygel-media-item.c"
	GError * _inner_error_ = NULL;
#line 196 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 196 "rygel-media-item.vala"
	g_return_if_fail (server != NULL);
#line 196 "rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 200 "rygel-media-item.vala"
	rygel_http_server_add_proxy_resource (server, didl_item, self, &_inner_error_);
#line 620 "rygel-media-item.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
#line 202 "rygel-media-item.vala"
	if (!self->place_holder) {
#line 204 "rygel-media-item.vala"
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) server, didl_item, self, &_inner_error_);
#line 629 "rygel-media-item.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
}


#line 208 "rygel-media-item.vala"
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol) {
#line 645 "rygel-media-item.c"
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* protocol_info;
#line 208 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "rygel-media-item.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 210 "rygel-media-item.vala"
	protocol_info = gupnp_protocol_info_new ();
#line 212 "rygel-media-item.vala"
	gupnp_protocol_info_set_mime_type (protocol_info, self->mime_type);
#line 213 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_profile (protocol_info, self->dlna_profile);
#line 214 "rygel-media-item.vala"
	gupnp_protocol_info_set_protocol (protocol_info, protocol);
#line 215 "rygel-media-item.vala"
	gupnp_protocol_info_set_dlna_flags (protocol_info, GUPNP_DLNA_FLAGS_DLNA_V15);
#line 217 "rygel-media-item.vala"
	if (rygel_media_item_streamable (self)) {
#line 218 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 666 "rygel-media-item.c"
	}
#line 221 "rygel-media-item.vala"
	if (!rygel_media_item_should_stream (self)) {
#line 222 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_RANGE);
#line 223 "rygel-media-item.vala"
		gupnp_protocol_info_set_dlna_flags (protocol_info, gupnp_protocol_info_get_dlna_flags (protocol_info) | (GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE | GUPNP_DLNA_FLAGS_CONNECTION_STALL));
#line 674 "rygel-media-item.c"
	}
	result = protocol_info;
#line 227 "rygel-media-item.vala"
	return result;
#line 679 "rygel-media-item.c"
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const char* uri, const char* protocol) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
}


#line 230 "rygel-media-item.vala"
char* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const char* uri, GError** error) {
#line 690 "rygel-media-item.c"
	char* result = NULL;
	char* scheme;
	GError * _inner_error_ = NULL;
#line 230 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 230 "rygel-media-item.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 231 "rygel-media-item.vala"
	scheme = g_uri_parse_scheme (uri);
#line 232 "rygel-media-item.vala"
	if (scheme == NULL) {
#line 702 "rygel-media-item.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _ ("Bad URI: %s"), uri);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (scheme);
			return NULL;
		}
	}
#line 236 "rygel-media-item.vala"
	if (_vala_strcmp0 (scheme, "http") == 0) {
#line 712 "rygel-media-item.c"
		result = g_strdup ("http-get");
		_g_free0 (scheme);
#line 237 "rygel-media-item.vala"
		return result;
#line 717 "rygel-media-item.c"
	} else {
#line 238 "rygel-media-item.vala"
		if (_vala_strcmp0 (scheme, "file") == 0) {
#line 721 "rygel-media-item.c"
			result = g_strdup ("internal");
			_g_free0 (scheme);
#line 239 "rygel-media-item.vala"
			return result;
#line 726 "rygel-media-item.c"
		} else {
#line 240 "rygel-media-item.vala"
			if (_vala_strcmp0 (scheme, "rtsp") == 0) {
#line 730 "rygel-media-item.c"
				result = g_strdup ("rtsp-rtp-udp");
				_g_free0 (scheme);
#line 242 "rygel-media-item.vala"
				return result;
#line 735 "rygel-media-item.c"
			} else {
#line 245 "rygel-media-item.vala"
				g_warning (_ ("Failed to probe protocol for URI %s. Assuming '%s'"), uri, scheme);
#line 739 "rygel-media-item.c"
				result = scheme;
#line 249 "rygel-media-item.vala"
				return result;
#line 743 "rygel-media-item.c"
			}
		}
	}
	_g_free0 (scheme);
}


#line 253 "rygel-media-item.vala"
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
#line 753 "rygel-media-item.c"
	GError * _inner_error_ = NULL;
#line 253 "rygel-media-item.vala"
	g_return_if_fail (self != NULL);
#line 253 "rygel-media-item.vala"
	g_return_if_fail (didl_item != NULL);
#line 759 "rygel-media-item.c"
	{
		GeeIterator* _uri_it;
#line 256 "rygel-media-item.vala"
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris);
#line 256 "rygel-media-item.vala"
		while (TRUE) {
#line 766 "rygel-media-item.c"
			char* uri;
			char* protocol;
			gboolean _tmp0_ = FALSE;
#line 256 "rygel-media-item.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 256 "rygel-media-item.vala"
				break;
#line 774 "rygel-media-item.c"
			}
#line 256 "rygel-media-item.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 257 "rygel-media-item.vala"
			protocol = rygel_media_item_get_protocol_for_uri (self, uri, &_inner_error_);
#line 780 "rygel-media-item.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_it);
				return;
			}
#line 259 "rygel-media-item.vala"
			if (allow_internal) {
#line 259 "rygel-media-item.vala"
				_tmp0_ = TRUE;
#line 791 "rygel-media-item.c"
			} else {
#line 259 "rygel-media-item.vala"
				_tmp0_ = _vala_strcmp0 (protocol, "internal") != 0;
#line 795 "rygel-media-item.c"
			}
#line 259 "rygel-media-item.vala"
			if (_tmp0_) {
#line 799 "rygel-media-item.c"
				GUPnPDIDLLiteResource* _tmp1_;
#line 260 "rygel-media-item.vala"
				_tmp1_ = rygel_media_item_add_resource (self, didl_item, uri, protocol, NULL, &_inner_error_);
#line 803 "rygel-media-item.c"
				_g_object_unref0 (_tmp1_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_it);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
}


#line 265 "rygel-media-item.vala"
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
#line 828 "rygel-media-item.c"
	gint result = 0;
#line 265 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 265 "rygel-media-item.vala"
	g_return_val_if_fail (item != NULL, 0);
#line 266 "rygel-media-item.vala"
	if (self->date == NULL) {
#line 836 "rygel-media-item.c"
		result = -1;
#line 267 "rygel-media-item.vala"
		return result;
#line 840 "rygel-media-item.c"
	} else {
#line 268 "rygel-media-item.vala"
		if (item->date == NULL) {
#line 844 "rygel-media-item.c"
			result = 1;
#line 269 "rygel-media-item.vala"
			return result;
#line 848 "rygel-media-item.c"
		} else {
			GTimeVal tv1 = {0};
			GTimeVal tv2 = {0};
			gint ret;
			g_get_current_time (&tv1);
#line 272 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (self->date, &tv1));
#line 856 "rygel-media-item.c"
			g_get_current_time (&tv2);
#line 275 "rygel-media-item.vala"
			g_assert (g_time_val_from_iso8601 (item->date, &tv2));
#line 277 "rygel-media-item.vala"
			ret = rygel_media_item_compare_long (self, tv1.tv_sec, tv2.tv_sec);
#line 278 "rygel-media-item.vala"
			if (ret == 0) {
#line 279 "rygel-media-item.vala"
				ret = rygel_media_item_compare_long (self, tv1.tv_usec, tv2.tv_usec);
#line 866 "rygel-media-item.c"
			}
			result = ret;
#line 282 "rygel-media-item.vala"
			return result;
#line 871 "rygel-media-item.c"
		}
	}
}


#line 286 "rygel-media-item.vala"
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
#line 879 "rygel-media-item.c"
	gint result = 0;
#line 286 "rygel-media-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 287 "rygel-media-item.vala"
	if (a < b) {
#line 885 "rygel-media-item.c"
		result = -1;
#line 288 "rygel-media-item.vala"
		return result;
#line 889 "rygel-media-item.c"
	} else {
#line 289 "rygel-media-item.vala"
		if (a > b) {
#line 893 "rygel-media-item.c"
			result = 1;
#line 290 "rygel-media-item.vala"
			return result;
#line 897 "rygel-media-item.c"
		} else {
			result = 0;
#line 292 "rygel-media-item.vala"
			return result;
#line 902 "rygel-media-item.c"
		}
	}
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_size;
#line 46 "rygel-media-item.vala"
	return result;
#line 914 "rygel-media-item.c"
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	g_return_if_fail (self != NULL);
#line 50 "rygel-media-item.vala"
	if (value == 0) {
#line 51 "rygel-media-item.vala"
		self->place_holder = TRUE;
#line 924 "rygel-media-item.c"
	}
#line 54 "rygel-media-item.vala"
	self->priv->_size = value;
#line 928 "rygel-media-item.c"
	g_object_notify ((GObject *) self, "size");
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
	G_OBJECT_CLASS (klass)->get_property = rygel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
	self->priv->_size = (gint64) (-1);
	self->place_holder = FALSE;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_free0 (self->date);
	_g_free0 (self->mime_type);
	_g_free0 (self->dlna_profile);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (object);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		g_value_set_int64 (value, rygel_media_item_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (object);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		rygel_media_item_set_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




