/* rygel-external-plugin-factory.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-external-plugin-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY (rygel_external_plugin_factory_get_type ())
#define RYGEL_EXTERNAL_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactory))
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactoryClass))
#define RYGEL_EXTERNAL_IS_PLUGIN_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY))
#define RYGEL_EXTERNAL_IS_PLUGIN_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY))
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactoryClass))

typedef struct _RygelExternalPluginFactory RygelExternalPluginFactory;
typedef struct _RygelExternalPluginFactoryClass RygelExternalPluginFactoryClass;
#define _rygel_external_plugin_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_plugin_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelExternalPluginFactoryPrivate RygelExternalPluginFactoryPrivate;

#define RYGEL_EXTERNAL_TYPE_ICON_FACTORY (rygel_external_icon_factory_get_type ())
#define RYGEL_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactory))
#define RYGEL_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))

typedef struct _RygelExternalIconFactory RygelExternalIconFactory;
typedef struct _RygelExternalIconFactoryClass RygelExternalIconFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_external_icon_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_icon_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelExternalPluginFactoryLoadPluginsData RygelExternalPluginFactoryLoadPluginsData;
typedef struct _RygelExternalPluginFactoryLoadActivatablePluginsData RygelExternalPluginFactoryLoadActivatablePluginsData;
typedef struct _RygelExternalPluginFactoryLoadPluginNHandleErrorData RygelExternalPluginFactoryLoadPluginNHandleErrorData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_EXTERNAL_TYPE_PLUGIN (rygel_external_plugin_get_type ())
#define RYGEL_EXTERNAL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPlugin))
#define RYGEL_EXTERNAL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))
#define RYGEL_EXTERNAL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_PLUGIN))
#define RYGEL_EXTERNAL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_PLUGIN, RygelExternalPluginClass))

typedef struct _RygelExternalPlugin RygelExternalPlugin;
typedef struct _RygelExternalPluginClass RygelExternalPluginClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelExternalPluginFactoryLoadPluginData RygelExternalPluginFactoryLoadPluginData;
typedef struct _RygelExternalParamSpecPluginFactory RygelExternalParamSpecPluginFactory;

struct _RygelExternalPluginFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalPluginFactoryPrivate * priv;
};

struct _RygelExternalPluginFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalPluginFactory *self);
};

struct _RygelExternalPluginFactoryPrivate {
	FreeDesktopDBusObject* dbus_obj;
	RygelPluginLoader* loader;
	RygelExternalIconFactory* icon_factory;
};

struct _RygelExternalPluginFactoryLoadPluginsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalPluginFactory* self;
	char** services;
	gint _tmp0_;
	gint services_length1;
	gint _services_size_;
	char** _tmp1_;
	gboolean _tmp2_;
	RygelPlugin* _tmp3_;
	char** service_collection;
	int service_collection_length1;
	int service_it;
	char* service;
	GError * _inner_error_;
};

struct _RygelExternalPluginFactoryLoadActivatablePluginsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalPluginFactory* self;
	char** services;
	gint _tmp0_;
	gint services_length1;
	gint _services_size_;
	char** _tmp1_;
	gboolean _tmp2_;
	RygelPlugin* _tmp3_;
	char** service_collection;
	int service_collection_length1;
	int service_it;
	char* service;
	GError * _inner_error_;
};

struct _RygelExternalPluginFactoryLoadPluginNHandleErrorData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalPluginFactory* self;
	char* service_name;
	GError * _error_;
	GError * _inner_error_;
};

struct _RygelExternalPluginFactoryLoadPluginData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalPluginFactory* self;
	char* service_name;
	char* root_object;
	char* _tmp0_;
	char* _tmp1_;
	FreeDesktopProperties* props;
	GHashTable* object_props;
	GHashTable* container_props;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	RygelIconInfo* icon;
	char* title;
	GVariant* value;
	char* _tmp6_;
	char* _tmp7_;
	guint child_count;
	gboolean searchable;
	RygelExternalPlugin* plugin;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecPluginFactory {
	GParamSpec parent_instance;
};


extern RygelExternalPluginFactory* plugin_factory;
RygelExternalPluginFactory* plugin_factory = NULL;
static gpointer rygel_external_plugin_factory_parent_class = NULL;

gpointer rygel_external_plugin_factory_ref (gpointer instance);
void rygel_external_plugin_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_plugin_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_plugin_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_plugin_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_plugin_factory (const GValue* value);
GType rygel_external_plugin_factory_get_type (void) G_GNUC_CONST;
void module_init (RygelPluginLoader* loader);
RygelExternalPluginFactory* rygel_external_plugin_factory_new (RygelPluginLoader* loader, GError** error);
RygelExternalPluginFactory* rygel_external_plugin_factory_construct (GType object_type, RygelPluginLoader* loader, GError** error);
gpointer rygel_external_icon_factory_ref (gpointer instance);
void rygel_external_icon_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_icon_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_icon_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_icon_factory (const GValue* value);
GType rygel_external_icon_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, RygelExternalPluginFactoryPrivate))
enum  {
	RYGEL_EXTERNAL_PLUGIN_FACTORY_DUMMY_PROPERTY
};
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX "org.gnome.UPnP.MediaServer2."
#define RYGEL_EXTERNAL_PLUGIN_FACTORY_GRILO_UPNP_PREFIX RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX "grl_upnp"
RygelExternalIconFactory* rygel_external_icon_factory_new (void);
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type);
static void rygel_external_plugin_factory_load_plugins (RygelExternalPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugins_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_plugin_factory_load_plugins_data_free (gpointer _data);
static void rygel_external_plugin_factory_load_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_plugin_factory_load_plugins_co (RygelExternalPluginFactoryLoadPluginsData* data);
static void rygel_external_plugin_factory_load_plugin_n_handle_error (RygelExternalPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_);
static void rygel_external_plugin_factory_load_activatable_plugins (RygelExternalPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_plugin_factory_load_activatable_plugins_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_plugin_factory_load_activatable_plugins_data_free (gpointer _data);
static void rygel_external_plugin_factory_load_activatable_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_plugin_factory_load_activatable_plugins_co (RygelExternalPluginFactoryLoadActivatablePluginsData* data);
static void rygel_external_plugin_factory_name_owner_changed (RygelExternalPluginFactory* self, FreeDesktopDBusObject* dbus_obj, const char* name, const char* old_owner, const char* new_owner);
static void _rygel_external_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer self);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data);
static void rygel_external_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_plugin_factory_load_plugin_n_handle_error_co (RygelExternalPluginFactoryLoadPluginNHandleErrorData* data);
static void rygel_external_plugin_factory_load_plugin (RygelExternalPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_external_plugin_factory_load_plugin_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error);
static void rygel_external_plugin_factory_load_plugin_data_free (gpointer _data);
static void rygel_external_plugin_factory_load_plugin_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_external_plugin_factory_load_plugin_co (RygelExternalPluginFactoryLoadPluginData* data);
#define RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE "org.gnome.UPnP.MediaObject2"
#define RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE "org.gnome.UPnP.MediaContainer2"
void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const char* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_, GError** error);
static const char* _variant_get23 (GVariant* value);
static guint _variant_get24 (GVariant* value);
static gboolean _variant_get25 (GVariant* value);
RygelExternalPlugin* rygel_external_plugin_new (const char* service_name, const char* title, guint child_count, gboolean searchable, const char* root_object, RygelIconInfo* icon);
RygelExternalPlugin* rygel_external_plugin_construct (GType object_type, const char* service_name, const char* title, guint child_count, gboolean searchable, const char* root_object, RygelIconInfo* icon);
GType rygel_external_plugin_get_type (void) G_GNUC_CONST;
static void rygel_external_plugin_factory_finalize (RygelExternalPluginFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



#line 31 "rygel-external-plugin-factory.vala"
void module_init (RygelPluginLoader* loader) {
#line 250 "rygel-external-plugin-factory.c"
	GError * _inner_error_ = NULL;
#line 31 "rygel-external-plugin-factory.vala"
	g_return_if_fail (loader != NULL);
#line 254 "rygel-external-plugin-factory.c"
	{
		RygelExternalPluginFactory* _tmp0_;
		RygelExternalPluginFactory* _tmp1_;
#line 33 "rygel-external-plugin-factory.vala"
		_tmp0_ = rygel_external_plugin_factory_new (loader, &_inner_error_);
#line 260 "rygel-external-plugin-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 33 "rygel-external-plugin-factory.vala"
		plugin_factory = (_tmp1_ = _tmp0_, _rygel_external_plugin_factory_unref0 (plugin_factory), _tmp1_);
#line 271 "rygel-external-plugin-factory.c"
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 35 "rygel-external-plugin-factory.vala"
			g_critical ("rygel-external-plugin-factory.vala:35: Failed to fetch list of externa" \
"l services: %s\n", _error_->message);
#line 282 "rygel-external-plugin-factory.c"
			_g_error_free0 (_error_);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 48 "rygel-external-plugin-factory.vala"
RygelExternalPluginFactory* rygel_external_plugin_factory_construct (GType object_type, RygelPluginLoader* loader, GError** error) {
#line 302 "rygel-external-plugin-factory.c"
	RygelExternalPluginFactory* self;
	RygelExternalIconFactory* _tmp0_;
	FreeDesktopDBusObject* _tmp1_;
	FreeDesktopDBusObject* _tmp2_;
	RygelPluginLoader* _tmp3_;
	GError * _inner_error_ = NULL;
#line 48 "rygel-external-plugin-factory.vala"
	g_return_val_if_fail (loader != NULL, NULL);
#line 311 "rygel-external-plugin-factory.c"
	self = (RygelExternalPluginFactory*) g_type_create_instance (object_type);
#line 49 "rygel-external-plugin-factory.vala"
	self->priv->icon_factory = (_tmp0_ = rygel_external_icon_factory_new (), _rygel_external_icon_factory_unref0 (self->priv->icon_factory), _tmp0_);
#line 51 "rygel-external-plugin-factory.vala"
	_tmp1_ = (FreeDesktopDBusObject*) g_initable_new (FREE_DESKTOP_TYPE_DBUS_OBJECT_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", FREE_DESKTOP_DBUS_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FREE_DESKTOP_DBUS_OBJECT, "g-interface-name", "org.freedesktop.DBus", NULL);
#line 317 "rygel-external-plugin-factory.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_rygel_external_plugin_factory_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 51 "rygel-external-plugin-factory.vala"
	self->priv->dbus_obj = (_tmp2_ = _tmp1_, _g_object_unref0 (self->priv->dbus_obj), _tmp2_);
#line 54 "rygel-external-plugin-factory.vala"
	self->priv->loader = (_tmp3_ = _g_object_ref0 (loader), _g_object_unref0 (self->priv->loader), _tmp3_);
#line 56 "rygel-external-plugin-factory.vala"
	rygel_external_plugin_factory_load_plugins (self, NULL, NULL);
#line 335 "rygel-external-plugin-factory.c"
	return self;
}


#line 48 "rygel-external-plugin-factory.vala"
RygelExternalPluginFactory* rygel_external_plugin_factory_new (RygelPluginLoader* loader, GError** error) {
#line 48 "rygel-external-plugin-factory.vala"
	return rygel_external_plugin_factory_construct (RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY, loader, error);
#line 344 "rygel-external-plugin-factory.c"
}


static void rygel_external_plugin_factory_load_plugins_data_free (gpointer _data) {
	RygelExternalPluginFactoryLoadPluginsData* data;
	data = _data;
	rygel_external_plugin_factory_unref (data->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginsData, data);
}


static void rygel_external_plugin_factory_load_plugins (RygelExternalPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_plugin_factory_load_plugins);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugins_data_free);
	_data_->self = rygel_external_plugin_factory_ref (self);
	rygel_external_plugin_factory_load_plugins_co (_data_);
}


static void rygel_external_plugin_factory_load_plugins_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalPluginFactoryLoadPluginsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_plugin_factory_load_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_plugin_factory_load_plugins_co (data);
}


static gboolean rygel_external_plugin_factory_load_plugins_co (RygelExternalPluginFactoryLoadPluginsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 20:
		goto _state_20;
		case 21:
		goto _state_21;
		case 22:
		goto _state_22;
	}
	_state_0:
	data->_state_ = 20;
	free_desktop_dbus_object_list_names (data->self->priv->dbus_obj, rygel_external_plugin_factory_load_plugins_ready, data);
	return FALSE;
	_state_20:
	data->services = (data->_tmp1_ = free_desktop_dbus_object_list_names_finish (data->self->priv->dbus_obj, data->_res_, &data->_tmp0_, &data->_inner_error_), data->services_length1 = data->_tmp0_, data->_services_size_ = data->services_length1, data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->service_collection = data->services;
		data->service_collection_length1 = data->services_length1;
		for (data->service_it = 0; data->service_it < data->services_length1; data->service_it = data->service_it + 1) {
			data->service = g_strdup (data->service_collection[data->service_it]);
			{
#line 63 "rygel-external-plugin-factory.vala"
				if (g_str_has_prefix (data->service, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 64 "rygel-external-plugin-factory.vala"
					data->_tmp2_ = (data->_tmp3_ = rygel_plugin_loader_get_plugin_by_name (data->self->priv->loader, data->service)) == NULL;
#line 431 "rygel-external-plugin-factory.c"
					_g_object_unref0 (data->_tmp3_);
				} else {
#line 63 "rygel-external-plugin-factory.vala"
					data->_tmp2_ = FALSE;
#line 436 "rygel-external-plugin-factory.c"
				}
#line 63 "rygel-external-plugin-factory.vala"
				if (data->_tmp2_) {
#line 440 "rygel-external-plugin-factory.c"
					data->_state_ = 21;
					rygel_external_plugin_factory_load_plugin_n_handle_error (data->self, data->service, rygel_external_plugin_factory_load_plugins_ready, data);
					return FALSE;
					_state_21:
#line 65 "rygel-external-plugin-factory.vala"
					rygel_external_plugin_factory_load_plugin_n_handle_error_finish (data->self, data->_res_);
#line 447 "rygel-external-plugin-factory.c"
				}
				_g_free0 (data->service);
			}
		}
	}
	data->_state_ = 22;
	rygel_external_plugin_factory_load_activatable_plugins (data->self, rygel_external_plugin_factory_load_plugins_ready, data);
	return FALSE;
	_state_22:
#line 69 "rygel-external-plugin-factory.vala"
	rygel_external_plugin_factory_load_activatable_plugins_finish (data->self, data->_res_, &data->_inner_error_);
#line 459 "rygel-external-plugin-factory.c"
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_plugin_factory_load_activatable_plugins_data_free (gpointer _data) {
	RygelExternalPluginFactoryLoadActivatablePluginsData* data;
	data = _data;
	rygel_external_plugin_factory_unref (data->self);
	g_slice_free (RygelExternalPluginFactoryLoadActivatablePluginsData, data);
}


static void rygel_external_plugin_factory_load_activatable_plugins (RygelExternalPluginFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadActivatablePluginsData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_plugin_factory_load_activatable_plugins);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_plugin_factory_load_activatable_plugins_data_free);
	_data_->self = rygel_external_plugin_factory_ref (self);
	rygel_external_plugin_factory_load_activatable_plugins_co (_data_);
}


static void rygel_external_plugin_factory_load_activatable_plugins_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalPluginFactoryLoadActivatablePluginsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_plugin_factory_load_activatable_plugins_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadActivatablePluginsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_plugin_factory_load_activatable_plugins_co (data);
}


#line 85 "rygel-external-plugin-factory.vala"
static void _rygel_external_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed (FreeDesktopDBusObject* _sender, const char* name, const char* old_owner, const char* new_owner, gpointer self) {
#line 531 "rygel-external-plugin-factory.c"
	rygel_external_plugin_factory_name_owner_changed (self, _sender, name, old_owner, new_owner);
}


static gboolean rygel_external_plugin_factory_load_activatable_plugins_co (RygelExternalPluginFactoryLoadActivatablePluginsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 23:
		goto _state_23;
		case 24:
		goto _state_24;
	}
	_state_0:
	data->_state_ = 23;
	free_desktop_dbus_object_list_activatable_names (data->self->priv->dbus_obj, rygel_external_plugin_factory_load_activatable_plugins_ready, data);
	return FALSE;
	_state_23:
	data->services = (data->_tmp1_ = free_desktop_dbus_object_list_activatable_names_finish (data->self->priv->dbus_obj, data->_res_, &data->_tmp0_, &data->_inner_error_), data->services_length1 = data->_tmp0_, data->_services_size_ = data->services_length1, data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->service_collection = data->services;
		data->service_collection_length1 = data->services_length1;
		for (data->service_it = 0; data->service_it < data->services_length1; data->service_it = data->service_it + 1) {
			data->service = g_strdup (data->service_collection[data->service_it]);
			{
#line 76 "rygel-external-plugin-factory.vala"
				if (g_str_has_prefix (data->service, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 77 "rygel-external-plugin-factory.vala"
					data->_tmp2_ = (data->_tmp3_ = rygel_plugin_loader_get_plugin_by_name (data->self->priv->loader, data->service)) == NULL;
#line 582 "rygel-external-plugin-factory.c"
					_g_object_unref0 (data->_tmp3_);
				} else {
#line 76 "rygel-external-plugin-factory.vala"
					data->_tmp2_ = FALSE;
#line 587 "rygel-external-plugin-factory.c"
				}
#line 76 "rygel-external-plugin-factory.vala"
				if (data->_tmp2_) {
#line 591 "rygel-external-plugin-factory.c"
					data->_state_ = 24;
					rygel_external_plugin_factory_load_plugin_n_handle_error (data->self, data->service, rygel_external_plugin_factory_load_activatable_plugins_ready, data);
					return FALSE;
					_state_24:
#line 78 "rygel-external-plugin-factory.vala"
					rygel_external_plugin_factory_load_plugin_n_handle_error_finish (data->self, data->_res_);
#line 598 "rygel-external-plugin-factory.c"
				}
				_g_free0 (data->service);
			}
		}
	}
#line 82 "rygel-external-plugin-factory.vala"
	g_signal_connect (data->self->priv->dbus_obj, "name-owner-changed", (GCallback) _rygel_external_plugin_factory_name_owner_changed_free_desktop_dbus_object_name_owner_changed, data->self);
#line 606 "rygel-external-plugin-factory.c"
	data->services = (_vala_array_free (data->services, data->services_length1, (GDestroyNotify) g_free), NULL);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 85 "rygel-external-plugin-factory.vala"
static void rygel_external_plugin_factory_name_owner_changed (RygelExternalPluginFactory* self, FreeDesktopDBusObject* dbus_obj, const char* name, const char* old_owner, const char* new_owner) {
#line 622 "rygel-external-plugin-factory.c"
	RygelPlugin* plugin;
#line 85 "rygel-external-plugin-factory.vala"
	g_return_if_fail (self != NULL);
#line 85 "rygel-external-plugin-factory.vala"
	g_return_if_fail (dbus_obj != NULL);
#line 85 "rygel-external-plugin-factory.vala"
	g_return_if_fail (name != NULL);
#line 85 "rygel-external-plugin-factory.vala"
	g_return_if_fail (old_owner != NULL);
#line 85 "rygel-external-plugin-factory.vala"
	g_return_if_fail (new_owner != NULL);
#line 89 "rygel-external-plugin-factory.vala"
	plugin = rygel_plugin_loader_get_plugin_by_name (self->priv->loader, name);
#line 91 "rygel-external-plugin-factory.vala"
	if (plugin != NULL) {
#line 638 "rygel-external-plugin-factory.c"
		gboolean _tmp0_ = FALSE;
#line 92 "rygel-external-plugin-factory.vala"
		if (_vala_strcmp0 (old_owner, "") != 0) {
#line 92 "rygel-external-plugin-factory.vala"
			_tmp0_ = _vala_strcmp0 (new_owner, "") == 0;
#line 644 "rygel-external-plugin-factory.c"
		} else {
#line 92 "rygel-external-plugin-factory.vala"
			_tmp0_ = FALSE;
#line 648 "rygel-external-plugin-factory.c"
		}
#line 92 "rygel-external-plugin-factory.vala"
		if (_tmp0_) {
#line 93 "rygel-external-plugin-factory.vala"
			g_debug ("rygel-external-plugin-factory.vala:93: Service '%s' going down, markin" \
"g it as unavailable", name);
#line 95 "rygel-external-plugin-factory.vala"
			rygel_plugin_set_available (plugin, FALSE);
#line 656 "rygel-external-plugin-factory.c"
		} else {
			gboolean _tmp1_ = FALSE;
#line 96 "rygel-external-plugin-factory.vala"
			if (_vala_strcmp0 (old_owner, "") == 0) {
#line 96 "rygel-external-plugin-factory.vala"
				_tmp1_ = _vala_strcmp0 (new_owner, "") != 0;
#line 663 "rygel-external-plugin-factory.c"
			} else {
#line 96 "rygel-external-plugin-factory.vala"
				_tmp1_ = FALSE;
#line 667 "rygel-external-plugin-factory.c"
			}
#line 96 "rygel-external-plugin-factory.vala"
			if (_tmp1_) {
#line 97 "rygel-external-plugin-factory.vala"
				g_debug ("rygel-external-plugin-factory.vala:97: Service '%s' up again, marking " \
"it as available", name);
#line 98 "rygel-external-plugin-factory.vala"
				rygel_plugin_set_available (plugin, TRUE);
#line 675 "rygel-external-plugin-factory.c"
			}
		}
	} else {
#line 100 "rygel-external-plugin-factory.vala"
		if (g_str_has_prefix (name, RYGEL_EXTERNAL_PLUGIN_FACTORY_SERVICE_PREFIX)) {
#line 102 "rygel-external-plugin-factory.vala"
			rygel_external_plugin_factory_load_plugin_n_handle_error (self, name, NULL, NULL);
#line 683 "rygel-external-plugin-factory.c"
		}
	}
	_g_object_unref0 (plugin);
}


static void rygel_external_plugin_factory_load_plugin_n_handle_error_data_free (gpointer _data) {
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* data;
	data = _data;
	_g_free0 (data->service_name);
	rygel_external_plugin_factory_unref (data->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginNHandleErrorData, data);
}


static void rygel_external_plugin_factory_load_plugin_n_handle_error (RygelExternalPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginNHandleErrorData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_plugin_factory_load_plugin_n_handle_error);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugin_n_handle_error_data_free);
	_data_->self = rygel_external_plugin_factory_ref (self);
	_data_->service_name = g_strdup (service_name);
	rygel_external_plugin_factory_load_plugin_n_handle_error_co (_data_);
}


static void rygel_external_plugin_factory_load_plugin_n_handle_error_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_) {
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_plugin_factory_load_plugin_n_handle_error_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginNHandleErrorData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_plugin_factory_load_plugin_n_handle_error_co (data);
}


static gboolean rygel_external_plugin_factory_load_plugin_n_handle_error_co (RygelExternalPluginFactoryLoadPluginNHandleErrorData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 25:
		goto _state_25;
	}
	_state_0:
	{
		data->_state_ = 25;
		rygel_external_plugin_factory_load_plugin (data->self, data->service_name, rygel_external_plugin_factory_load_plugin_n_handle_error_ready, data);
		return FALSE;
		_state_25:
#line 108 "rygel-external-plugin-factory.vala"
		rygel_external_plugin_factory_load_plugin_finish (data->self, data->_res_, &data->_inner_error_);
#line 741 "rygel-external-plugin-factory.c"
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
#line 110 "rygel-external-plugin-factory.vala"
			g_warning ("rygel-external-plugin-factory.vala:110: Failed to load external plugin" \
" '%s': %s", data->service_name, data->_error_->message);
#line 759 "rygel-external-plugin-factory.c"
			_g_error_free0 (data->_error_);
		}
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_plugin_factory_load_plugin_data_free (gpointer _data) {
	RygelExternalPluginFactoryLoadPluginData* data;
	data = _data;
	_g_free0 (data->service_name);
	rygel_external_plugin_factory_unref (data->self);
	g_slice_free (RygelExternalPluginFactoryLoadPluginData, data);
}


static void rygel_external_plugin_factory_load_plugin (RygelExternalPluginFactory* self, const char* service_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginData* _data_;
	_data_ = g_slice_new0 (RygelExternalPluginFactoryLoadPluginData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_plugin_factory_load_plugin);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_plugin_factory_load_plugin_data_free);
	_data_->self = rygel_external_plugin_factory_ref (self);
	_data_->service_name = g_strdup (service_name);
	rygel_external_plugin_factory_load_plugin_co (_data_);
}


static void rygel_external_plugin_factory_load_plugin_finish (RygelExternalPluginFactory* self, GAsyncResult* _res_, GError** error) {
	RygelExternalPluginFactoryLoadPluginData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_external_plugin_factory_load_plugin_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalPluginFactoryLoadPluginData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_plugin_factory_load_plugin_co (data);
}


#line 1177 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 820 "rygel-external-plugin-factory.c"
	char* result = NULL;
	GError * _inner_error_ = NULL;
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1177 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 829 "rygel-external-plugin-factory.c"
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1179 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 837 "rygel-external-plugin-factory.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1180 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 848 "rygel-external-plugin-factory.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1180 "glib-2.0.vapi"
		return result;
#line 863 "rygel-external-plugin-factory.c"
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1182 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 874 "rygel-external-plugin-factory.c"
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const char* _variant_get23 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static guint _variant_get24 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static gboolean _variant_get25 (GVariant* value) {
	return g_variant_get_boolean (value);
}


static gboolean rygel_external_plugin_factory_load_plugin_co (RygelExternalPluginFactoryLoadPluginData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 26:
		goto _state_26;
		case 27:
		goto _state_27;
		case 28:
		goto _state_28;
	}
	_state_0:
#line 117 "rygel-external-plugin-factory.vala"
	if (g_str_has_prefix (data->service_name, RYGEL_EXTERNAL_PLUGIN_FACTORY_GRILO_UPNP_PREFIX)) {
#line 923 "rygel-external-plugin-factory.c"
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->root_object = (data->_tmp1_ = g_strconcat ("/", data->_tmp0_ = string_replace (data->service_name, ".", "/"), NULL), _g_free0 (data->_tmp0_), data->_tmp1_);
	data->props = (FreeDesktopProperties*) g_initable_new (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, NULL, &data->_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->root_object, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->root_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_free0 (data->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 26;
	free_desktop_properties_get_all (data->props, RYGEL_EXTERNAL_MEDIA_OBJECT_PROXY_IFACE, rygel_external_plugin_factory_load_plugin_ready, data);
	return FALSE;
	_state_26:
	data->_tmp2_ = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
#line 133 "rygel-external-plugin-factory.vala"
	data->object_props = (data->_tmp3_ = data->_tmp2_, _g_hash_table_unref0 (data->object_props), data->_tmp3_);
#line 991 "rygel-external-plugin-factory.c"
	data->_state_ = 27;
	free_desktop_properties_get_all (data->props, RYGEL_EXTERNAL_MEDIA_CONTAINER_PROXY_IFACE, rygel_external_plugin_factory_load_plugin_ready, data);
	return FALSE;
	_state_27:
	data->_tmp4_ = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
#line 134 "rygel-external-plugin-factory.vala"
	data->container_props = (data->_tmp5_ = data->_tmp4_, _g_hash_table_unref0 (data->container_props), data->_tmp5_);
#line 1026 "rygel-external-plugin-factory.c"
	data->_state_ = 28;
	rygel_external_icon_factory_create (data->self->priv->icon_factory, data->service_name, data->container_props, rygel_external_plugin_factory_load_plugin_ready, data);
	return FALSE;
	_state_28:
	data->icon = rygel_external_icon_factory_create_finish (data->self->priv->icon_factory, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			_g_hash_table_unref0 (data->container_props);
			_g_hash_table_unref0 (data->object_props);
			_g_object_unref0 (data->props);
			_g_free0 (data->root_object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->value = _g_variant_ref0 ((GVariant*) g_hash_table_lookup (data->object_props, "DisplayName"));
#line 141 "rygel-external-plugin-factory.vala"
	if (data->value != NULL) {
#line 142 "rygel-external-plugin-factory.vala"
		data->title = (data->_tmp6_ = g_strdup (_variant_get23 (data->value)), _g_free0 (data->title), data->_tmp6_);
#line 1064 "rygel-external-plugin-factory.c"
	} else {
#line 144 "rygel-external-plugin-factory.vala"
		data->title = (data->_tmp7_ = g_strdup (data->service_name), _g_free0 (data->title), data->_tmp7_);
#line 1068 "rygel-external-plugin-factory.c"
	}
	data->child_count = _variant_get24 ((GVariant*) g_hash_table_lookup (data->container_props, "ChildCount"));
	data->searchable = _variant_get25 ((GVariant*) g_hash_table_lookup (data->container_props, "Searchable"));
	data->plugin = rygel_external_plugin_new (data->service_name, data->title, data->child_count, data->searchable, data->root_object, data->icon);
#line 157 "rygel-external-plugin-factory.vala"
	rygel_plugin_loader_add_plugin (data->self->priv->loader, (RygelPlugin*) data->plugin);
#line 1075 "rygel-external-plugin-factory.c"
	_g_object_unref0 (data->plugin);
	_g_variant_unref0 (data->value);
	_g_free0 (data->title);
	_rygel_icon_info_unref0 (data->icon);
	_g_hash_table_unref0 (data->container_props);
	_g_hash_table_unref0 (data->object_props);
	_g_object_unref0 (data->props);
	_g_free0 (data->root_object);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_external_value_plugin_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_external_value_plugin_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_plugin_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_external_value_plugin_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_plugin_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_external_value_plugin_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_external_value_plugin_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalPluginFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_plugin_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_external_value_plugin_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalPluginFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_plugin_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_external_param_spec_plugin_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelExternalParamSpecPluginFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_external_value_get_plugin_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_external_value_set_plugin_factory (GValue* value, gpointer v_object) {
	RygelExternalPluginFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_plugin_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_plugin_factory_unref (old);
	}
}


void rygel_external_value_take_plugin_factory (GValue* value, gpointer v_object) {
	RygelExternalPluginFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_PLUGIN_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_plugin_factory_unref (old);
	}
}


static void rygel_external_plugin_factory_class_init (RygelExternalPluginFactoryClass * klass) {
	rygel_external_plugin_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_PLUGIN_FACTORY_CLASS (klass)->finalize = rygel_external_plugin_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelExternalPluginFactoryPrivate));
}


static void rygel_external_plugin_factory_instance_init (RygelExternalPluginFactory * self) {
	self->priv = RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_external_plugin_factory_finalize (RygelExternalPluginFactory* obj) {
	RygelExternalPluginFactory * self;
	self = RYGEL_EXTERNAL_PLUGIN_FACTORY (obj);
	_g_object_unref0 (self->priv->dbus_obj);
	_g_object_unref0 (self->priv->loader);
	_rygel_external_icon_factory_unref0 (self->priv->icon_factory);
}


GType rygel_external_plugin_factory_get_type (void) {
	static volatile gsize rygel_external_plugin_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_plugin_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_plugin_factory_init, rygel_external_value_plugin_factory_free_value, rygel_external_value_plugin_factory_copy_value, rygel_external_value_plugin_factory_peek_pointer, "p", rygel_external_value_plugin_factory_collect_value, "p", rygel_external_value_plugin_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalPluginFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_plugin_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalPluginFactory), 0, (GInstanceInitFunc) rygel_external_plugin_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_plugin_factory_type_id;
		rygel_external_plugin_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalPluginFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_plugin_factory_type_id__volatile, rygel_external_plugin_factory_type_id);
	}
	return rygel_external_plugin_factory_type_id__volatile;
}


gpointer rygel_external_plugin_factory_ref (gpointer instance) {
	RygelExternalPluginFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_plugin_factory_unref (gpointer instance) {
	RygelExternalPluginFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_PLUGIN_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




