/* rygel-media-export-metadata-extractor.c generated by valac 0.29.2, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gunixoutputstream.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <fcntl.h>
#include <gio/gunixinputstream.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportMetadataExtractorRunData RygelMediaExportMetadataExtractorRunData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL,
	METADATA_EXTRACTOR_ERROR_BLACKLIST
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	gboolean extract_metadata;
	GUnixOutputStream* input_stream;
	GDataInputStream* output_stream;
	GDataInputStream* error_stream;
	GCancellable* child_io_cancellable;
	GSubprocessLauncher* launcher;
	gchar* error_uri;
	gchar** MX_EXTRACT_ARGV;
	gint MX_EXTRACT_ARGV_length1;
	gint _MX_EXTRACT_ARGV_size_;
};

struct _RygelMediaExportMetadataExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportMetadataExtractor* self;
	gint* pipe_in;
	gint* _tmp0_;
	gint pipe_in_length1;
	gint _pipe_in_size_;
	gint* pipe_out;
	gint* _tmp1_;
	gint pipe_out_length1;
	gint _pipe_out_size_;
	gint* pipe_err;
	gint* _tmp2_;
	gint pipe_err_length1;
	gint _pipe_err_size_;
	gboolean restart;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint* _tmp7_;
	gint _tmp7__length1;
	GSubprocessLauncher* _tmp8_;
	GSubprocessLauncher* _tmp9_;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	GSubprocessLauncher* _tmp12_;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GSubprocessLauncher* _tmp15_;
	gint* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gint* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	GUnixOutputStream* _tmp20_;
	gint* _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_;
	GUnixInputStream* _tmp23_;
	GUnixInputStream* _tmp24_;
	GDataInputStream* _tmp25_;
	gint* _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	GUnixInputStream* _tmp28_;
	GUnixInputStream* _tmp29_;
	GDataInputStream* _tmp30_;
	GCancellable* _tmp31_;
	GDataInputStream* _tmp32_;
	GCancellable* _tmp33_;
	GDataInputStream* _tmp34_;
	GCancellable* _tmp35_;
	gboolean _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	GSubprocess* subprocess;
	GSubprocessLauncher* _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	GSubprocess* _tmp44_;
	GSubprocess* _tmp45_;
	GError* _error_;
	const gchar* _tmp46_;
	GError* _tmp47_;
	const gchar* _tmp48_;
	GCancellable* _tmp49_;
	gchar* msg;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	GFile* _tmp53_;
	GFile* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	GError* _tmp57_;
	GError* _tmp58_;
	GError* _vala1__error_;
	const gchar* _tmp59_;
	GError* _tmp60_;
	const gchar* _tmp61_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportMetadataExtractor* self;
	GFile* file;
	gchar* content_type;
};


static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;
static GVariantType* rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE;
static GVariantType* rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE = NULL;

GQuark metadata_extractor_error_quark (void);
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
gboolean g_unix_open_pipe (gint* fds, gint flags, GError** error);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
static void rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self, RygelConfiguration* config, const gchar* section, const gchar* key);
static void _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
void rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_run_data_free (gpointer _data);
void rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self, GAsyncResult* _res_);
static gboolean rygel_media_export_metadata_extractor_run_co (RygelMediaExportMetadataExtractorRunData* _data_);
static void rygel_media_export_metadata_extractor_on_input (RygelMediaExportMetadataExtractor* self, GObject* object, GAsyncResult* _result_);
static void _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_media_export_metadata_extractor_on_child_error (RygelMediaExportMetadataExtractor* self, GObject* object, GAsyncResult* _result_);
static void _rygel_media_export_metadata_extractor_on_child_error_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rygel_media_export_metadata_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block5Data* _data5_);
static gboolean ____lambda7__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark metadata_extractor_error_quark (void) {
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


static void _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
	rygel_media_export_metadata_extractor_on_config_changed ((RygelMediaExportMetadataExtractor*) self, _sender, section, key);
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
	RygelMediaExportMetadataExtractor * self = NULL;
	GCancellable* _tmp0_ = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->child_io_cancellable);
	self->priv->child_io_cancellable = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	g_signal_connect_object ((RygelConfiguration*) config, "setting-changed", (GCallback) _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed, self, 0);
	rygel_media_export_metadata_extractor_on_config_changed (self, (RygelConfiguration*) config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata");
	_g_object_unref0 (config);
	return self;
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self) {
	GCancellable* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child_io_cancellable;
	g_cancellable_cancel (_tmp0_);
	{
		gchar* s = NULL;
		gchar* _tmp1_ = NULL;
		GUnixOutputStream* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		guint8* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		GUnixOutputStream* _tmp6_ = NULL;
		_tmp1_ = g_strdup ("QUIT\n");
		s = _tmp1_;
		_tmp2_ = self->priv->input_stream;
		_tmp3_ = s;
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp2_, _tmp5_, (gsize) _tmp5__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (s);
			goto __catch25_g_error;
		}
		_tmp6_ = self->priv->input_stream;
		g_output_stream_flush ((GOutputStream*) _tmp6_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (s);
			goto __catch25_g_error;
		}
		_g_free0 (s);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp7_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Failed to gracefully stop the process. Using KILL");
		g_warning ("rygel-media-export-metadata-extractor.vala:108: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_metadata_extractor_run_data_free (gpointer _data) {
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportMetadataExtractorRunData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportMetadataExtractorRunData* _data_;
	RygelMediaExportMetadataExtractor* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelMediaExportMetadataExtractorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_metadata_extractor_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_metadata_extractor_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_metadata_extractor_run_co (_data_);
}


void rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self, GAsyncResult* _res_) {
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	rygel_media_export_metadata_extractor_on_input ((RygelMediaExportMetadataExtractor*) self, source_object, res);
	g_object_unref (self);
}


static void _rygel_media_export_metadata_extractor_on_child_error_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	rygel_media_export_metadata_extractor_on_child_error ((RygelMediaExportMetadataExtractor*) self, source_object, res);
	g_object_unref (self);
}


static void rygel_media_export_metadata_extractor_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_metadata_extractor_run_co (_data_);
}


static gboolean rygel_media_export_metadata_extractor_run_co (RygelMediaExportMetadataExtractorRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (gint, 2);
	_data_->_tmp0_[0] = 0;
	_data_->_tmp0_[1] = 0;
	_data_->pipe_in_length1 = 0;
	_data_->_pipe_in_size_ = 0;
	_data_->pipe_in = _data_->_tmp0_;
	_data_->pipe_in_length1 = 2;
	_data_->_pipe_in_size_ = _data_->pipe_in_length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_new0 (gint, 2);
	_data_->_tmp1_[0] = 0;
	_data_->_tmp1_[1] = 0;
	_data_->pipe_out_length1 = 0;
	_data_->_pipe_out_size_ = 0;
	_data_->pipe_out = _data_->_tmp1_;
	_data_->pipe_out_length1 = 2;
	_data_->_pipe_out_size_ = _data_->pipe_out_length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_new0 (gint, 2);
	_data_->_tmp2_[0] = 0;
	_data_->_tmp2_[1] = 0;
	_data_->pipe_err_length1 = 0;
	_data_->_pipe_err_size_ = 0;
	_data_->pipe_err = _data_->_tmp2_;
	_data_->pipe_err_length1 = 2;
	_data_->_pipe_err_size_ = _data_->pipe_err_length1;
	_data_->restart = FALSE;
	{
		_data_->_tmp3_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp3_) {
				_data_->_tmp4_ = FALSE;
				_data_->_tmp4_ = _data_->restart;
				if (!_data_->_tmp4_) {
					break;
				}
			}
			_data_->_tmp3_ = FALSE;
			_data_->restart = FALSE;
			{
				_data_->_tmp5_ = NULL;
				_data_->_tmp5__length1 = 0;
				_data_->_tmp5_ = _data_->pipe_in;
				_data_->_tmp5__length1 = _data_->pipe_in_length1;
				g_unix_open_pipe (_data_->_tmp5_, FD_CLOEXEC, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				_data_->_tmp6_ = NULL;
				_data_->_tmp6__length1 = 0;
				_data_->_tmp6_ = _data_->pipe_out;
				_data_->_tmp6__length1 = _data_->pipe_out_length1;
				g_unix_open_pipe (_data_->_tmp6_, FD_CLOEXEC, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				_data_->_tmp7_ = NULL;
				_data_->_tmp7__length1 = 0;
				_data_->_tmp7_ = _data_->pipe_err;
				_data_->_tmp7__length1 = _data_->pipe_err_length1;
				g_unix_open_pipe (_data_->_tmp7_, FD_CLOEXEC, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_NONE);
				_g_object_unref0 (_data_->self->priv->launcher);
				_data_->self->priv->launcher = _data_->_tmp8_;
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = _data_->self->priv->launcher;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10__length1 = 0;
				_data_->_tmp10_ = _data_->pipe_in;
				_data_->_tmp10__length1 = _data_->pipe_in_length1;
				_data_->_tmp11_ = 0;
				_data_->_tmp11_ = _data_->_tmp10_[0];
				g_subprocess_launcher_take_fd (_data_->_tmp9_, _data_->_tmp11_, 3);
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->self->priv->launcher;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13__length1 = 0;
				_data_->_tmp13_ = _data_->pipe_out;
				_data_->_tmp13__length1 = _data_->pipe_out_length1;
				_data_->_tmp14_ = 0;
				_data_->_tmp14_ = _data_->_tmp13_[1];
				g_subprocess_launcher_take_fd (_data_->_tmp12_, _data_->_tmp14_, 4);
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = _data_->self->priv->launcher;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16__length1 = 0;
				_data_->_tmp16_ = _data_->pipe_err;
				_data_->_tmp16__length1 = _data_->pipe_err_length1;
				_data_->_tmp17_ = 0;
				_data_->_tmp17_ = _data_->_tmp16_[1];
				g_subprocess_launcher_take_fd (_data_->_tmp15_, _data_->_tmp17_, 5);
				_data_->_tmp18_ = NULL;
				_data_->_tmp18__length1 = 0;
				_data_->_tmp18_ = _data_->pipe_in;
				_data_->_tmp18__length1 = _data_->pipe_in_length1;
				_data_->_tmp19_ = 0;
				_data_->_tmp19_ = _data_->_tmp18_[1];
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp19_, TRUE);
				_g_object_unref0 (_data_->self->priv->input_stream);
				_data_->self->priv->input_stream = _data_->_tmp20_;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21__length1 = 0;
				_data_->_tmp21_ = _data_->pipe_out;
				_data_->_tmp21__length1 = _data_->pipe_out_length1;
				_data_->_tmp22_ = 0;
				_data_->_tmp22_ = _data_->_tmp21_[0];
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->_tmp22_, TRUE);
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp24_);
				_g_object_unref0 (_data_->self->priv->output_stream);
				_data_->self->priv->output_stream = _data_->_tmp25_;
				_g_object_unref0 (_data_->_tmp24_);
				_data_->_tmp26_ = NULL;
				_data_->_tmp26__length1 = 0;
				_data_->_tmp26_ = _data_->pipe_err;
				_data_->_tmp26__length1 = _data_->pipe_err_length1;
				_data_->_tmp27_ = 0;
				_data_->_tmp27_ = _data_->_tmp26_[0];
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->_tmp27_, TRUE);
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp29_);
				_g_object_unref0 (_data_->self->priv->error_stream);
				_data_->self->priv->error_stream = _data_->_tmp30_;
				_g_object_unref0 (_data_->_tmp29_);
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = g_cancellable_new ();
				_g_object_unref0 (_data_->self->priv->child_io_cancellable);
				_data_->self->priv->child_io_cancellable = _data_->_tmp31_;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->self->priv->output_stream;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = _data_->self->priv->child_io_cancellable;
				g_data_input_stream_read_line_async (_data_->_tmp32_, G_PRIORITY_DEFAULT, _data_->_tmp33_, _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback, g_object_ref (_data_->self));
				_g_free0 (_data_->self->priv->error_uri);
				_data_->self->priv->error_uri = NULL;
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->self->priv->error_stream;
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = _data_->self->priv->child_io_cancellable;
				g_data_input_stream_read_line_async (_data_->_tmp34_, G_PRIORITY_DEFAULT, _data_->_tmp35_, _rygel_media_export_metadata_extractor_on_child_error_gasync_ready_callback, g_object_ref (_data_->self));
				_data_->_tmp36_ = FALSE;
				_data_->_tmp36_ = _data_->self->priv->extract_metadata;
				if (_data_->_tmp36_) {
					_data_->_tmp37_ = NULL;
					_data_->_tmp37__length1 = 0;
					_data_->_tmp37_ = _data_->self->priv->MX_EXTRACT_ARGV;
					_data_->_tmp37__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = g_strdup ("--extract-metadata");
					_g_free0 (_data_->_tmp37_[4]);
					_data_->_tmp37_[4] = _data_->_tmp38_;
					_data_->_tmp39_ = NULL;
					_data_->_tmp39_ = _data_->_tmp37_[4];
				} else {
					_data_->_tmp40_ = NULL;
					_data_->_tmp40__length1 = 0;
					_data_->_tmp40_ = _data_->self->priv->MX_EXTRACT_ARGV;
					_data_->_tmp40__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
					_g_free0 (_data_->_tmp40_[4]);
					_data_->_tmp40_[4] = NULL;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = _data_->_tmp40_[4];
				}
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = _data_->self->priv->launcher;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43__length1 = 0;
				_data_->_tmp43_ = _data_->self->priv->MX_EXTRACT_ARGV;
				_data_->_tmp43__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = g_subprocess_launcher_spawnv (_data_->_tmp42_, _data_->_tmp43_, &_data_->_inner_error_);
				_data_->subprocess = _data_->_tmp44_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				{
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = _data_->subprocess;
					_data_->_state_ = 1;
					g_subprocess_wait_check_async (_data_->_tmp45_, NULL, rygel_media_export_metadata_extractor_run_ready, _data_);
					return FALSE;
					_state_1:
					g_subprocess_wait_check_finish (_data_->_tmp45_, _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch27_g_error;
					}
				}
				goto __finally27;
				__catch27_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _ ("Process check_async failed: %s");
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = _data_->_error_;
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->_tmp47_->message;
					g_warning (_data_->_tmp46_, _data_->_tmp48_);
					_data_->restart = TRUE;
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = _data_->self->priv->child_io_cancellable;
					g_cancellable_cancel (_data_->_tmp49_);
					_data_->_tmp50_ = NULL;
					_data_->_tmp50_ = _ ("Process died while handling URI %s");
					_data_->_tmp51_ = NULL;
					_data_->_tmp51_ = g_strdup (_data_->_tmp50_);
					_data_->msg = _data_->_tmp51_;
					_data_->_tmp52_ = NULL;
					_data_->_tmp52_ = _data_->self->priv->error_uri;
					_data_->_tmp53_ = NULL;
					_data_->_tmp53_ = g_file_new_for_uri (_data_->_tmp52_);
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = _data_->_tmp53_;
					_data_->_tmp55_ = NULL;
					_data_->_tmp55_ = _data_->msg;
					_data_->_tmp56_ = NULL;
					_data_->_tmp56_ = _data_->self->priv->error_uri;
					_data_->_tmp57_ = NULL;
					_data_->_tmp57_ = g_error_new (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_BLACKLIST, _data_->_tmp55_, _data_->_tmp56_);
					_data_->_tmp58_ = NULL;
					_data_->_tmp58_ = _data_->_tmp57_;
					g_signal_emit_by_name (_data_->self, "error", _data_->_tmp54_, _data_->_tmp58_);
					_g_error_free0 (_data_->_tmp58_);
					_g_object_unref0 (_data_->_tmp54_);
					_g_free0 (_data_->msg);
					_g_error_free0 (_data_->_error_);
				}
				__finally27:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->subprocess);
					goto __catch26_g_error;
				}
				_g_object_unref0 (_data_->subprocess);
			}
			goto __finally26;
			__catch26_g_error:
			{
				_data_->_vala1__error_ = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = _ ("Setting up extraction subprocess failed: %s");
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = _data_->_vala1__error_;
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = _data_->_tmp60_->message;
				g_warning (_data_->_tmp59_, _data_->_tmp61_);
				_g_error_free0 (_data_->_vala1__error_);
			}
			__finally26:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_data_->pipe_err = (g_free (_data_->pipe_err), NULL);
				_data_->pipe_out = (g_free (_data_->pipe_out), NULL);
				_data_->pipe_in = (g_free (_data_->pipe_in), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	g_debug ("rygel-media-export-metadata-extractor.vala:183: Metadata extractor fin" \
"ished.");
	_data_->pipe_err = (g_free (_data_->pipe_err), NULL);
	_data_->pipe_out = (g_free (_data_->pipe_out), NULL);
	_data_->pipe_in = (g_free (_data_->pipe_in), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_metadata_extractor_on_child_error (RygelMediaExportMetadataExtractor* self, GObject* object, GAsyncResult* _result_) {
	GDataInputStream* stream = NULL;
	GObject* _tmp0_ = NULL;
	GDataInputStream* _tmp1_ = NULL;
	GDataInputStream* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_DATA_INPUT_STREAM) ? ((GDataInputStream*) _tmp0_) : NULL);
	stream = _tmp1_;
	_tmp2_ = stream;
	if (_tmp2_ != NULL) {
		{
			gchar* _tmp3_ = NULL;
			GDataInputStream* _tmp4_ = NULL;
			GAsyncResult* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp4_ = stream;
			_tmp5_ = _result_;
			_tmp6_ = g_data_input_stream_read_line_finish (_tmp4_, _tmp5_, NULL, &_inner_error_);
			_tmp3_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch28_g_error;
			}
			_tmp7_ = _tmp3_;
			_tmp3_ = NULL;
			_g_free0 (self->priv->error_uri);
			self->priv->error_uri = _tmp7_;
			_tmp8_ = _ ("Child failed fatally. Last uri was %s");
			_tmp9_ = self->priv->error_uri;
			g_warning (_tmp8_, _tmp9_);
			_g_free0 (_tmp3_);
		}
		goto __finally28;
		__catch28_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp10_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = _error_;
			if (g_error_matches (_tmp10_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				g_debug ("rygel-media-export-metadata-extractor.vala:195: Reading was cancelled." \
"..");
			} else {
				const gchar* _tmp11_ = NULL;
				GError* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				_tmp11_ = _ ("Reading from child's error stream failed: %s");
				_tmp12_ = _error_;
				_tmp13_ = _tmp12_->message;
				g_warning (_tmp11_, _tmp13_);
			}
			_g_error_free0 (_error_);
		}
		__finally28:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (stream);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void rygel_media_export_metadata_extractor_on_input (RygelMediaExportMetadataExtractor* self, GObject* object, GAsyncResult* _result_) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	{
		GDataInputStream* stream = NULL;
		GObject* _tmp0_ = NULL;
		GDataInputStream* _tmp1_ = NULL;
		gchar* str = NULL;
		GDataInputStream* _tmp2_ = NULL;
		GAsyncResult* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GDataInputStream* _tmp52_ = NULL;
		GCancellable* _tmp53_ = NULL;
		_tmp0_ = object;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_DATA_INPUT_STREAM) ? ((GDataInputStream*) _tmp0_) : NULL);
		stream = _tmp1_;
		_tmp2_ = stream;
		_tmp3_ = _result_;
		_tmp4_ = g_data_input_stream_read_line_finish (_tmp2_, _tmp3_, NULL, &_inner_error_);
		str = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch29_g_error;
		}
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				gchar** parts = NULL;
				const gchar* _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				const gchar* _tmp21_ = NULL;
				gchar* uri = NULL;
				gchar** _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				guint64 length = 0ULL;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				const gchar* _tmp34_ = NULL;
				guint64 _tmp35_ = 0ULL;
				const gchar* _tmp36_ = NULL;
				guint8* buf = NULL;
				guint64 _tmp37_ = 0ULL;
				guint8* _tmp38_ = NULL;
				gint buf_length1 = 0;
				gint _buf_size_ = 0;
				gsize bytes = 0UL;
				GDataInputStream* _tmp39_ = NULL;
				guint8* _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				GCancellable* _tmp41_ = NULL;
				gsize _tmp42_ = 0UL;
				guint64 _tmp43_ = 0ULL;
				gsize _tmp44_ = 0UL;
				GVariant* v = NULL;
				const GVariantType* _tmp45_ = NULL;
				guint8* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				GVariant* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				GFile* _tmp49_ = NULL;
				GFile* _tmp50_ = NULL;
				GVariant* _tmp51_ = NULL;
				if (!_tmp5_) {
					if (!FALSE) {
						break;
					}
				}
				_tmp5_ = FALSE;
				_tmp6_ = str;
				if (_tmp6_ == NULL) {
					break;
				}
				_tmp8_ = str;
				_tmp9_ = g_str_has_prefix (_tmp8_, "RESULT|");
				if (!_tmp9_) {
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp10_ = str;
					_tmp11_ = g_str_has_prefix (_tmp10_, "ERROR|");
					_tmp7_ = !_tmp11_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp12_ = _ ("Received invalid string from child: %s");
					_tmp13_ = str;
					g_warning (_tmp12_, _tmp13_);
					break;
				}
				_tmp14_ = str;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "|", 0);
				parts = _tmp16_;
				parts_length1 = _vala_array_length (_tmp15_);
				_parts_size_ = parts_length1;
				_tmp17_ = parts;
				_tmp17__length1 = parts_length1;
				if (_tmp17__length1 != 4) {
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					_tmp18_ = _ ("Received ill-formed response string %s from child…");
					_tmp19_ = str;
					g_warning (_tmp18_, _tmp19_);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp20_ = parts;
				_tmp20__length1 = parts_length1;
				_tmp21_ = _tmp20_[0];
				if (g_strcmp0 (_tmp21_, "ERROR") == 0) {
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					const gchar* _tmp23_ = NULL;
					GFile* _tmp24_ = NULL;
					GFile* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					const gchar* _tmp27_ = NULL;
					GError* _tmp28_ = NULL;
					GError* _tmp29_ = NULL;
					_tmp22_ = parts;
					_tmp22__length1 = parts_length1;
					_tmp23_ = _tmp22_[1];
					_tmp24_ = g_file_new_for_uri (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = parts;
					_tmp26__length1 = parts_length1;
					_tmp27_ = _tmp26_[3];
					_tmp28_ = g_error_new_literal (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_GENERAL, _tmp27_);
					_tmp29_ = _tmp28_;
					g_signal_emit_by_name (self, "error", _tmp25_, _tmp29_);
					_g_error_free0 (_tmp29_);
					_g_object_unref0 (_tmp25_);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp30_ = parts;
				_tmp30__length1 = parts_length1;
				_tmp31_ = _tmp30_[1];
				_tmp32_ = g_strdup (_tmp31_);
				uri = _tmp32_;
				_tmp33_ = parts;
				_tmp33__length1 = parts_length1;
				_tmp34_ = _tmp33_[2];
				_tmp35_ = uint64_parse (_tmp34_);
				length = _tmp35_;
				_tmp36_ = uri;
				g_debug ("rygel-media-export-metadata-extractor.vala:240: Found serialized data " \
"for uri %s", _tmp36_);
				_tmp37_ = length;
				_tmp38_ = g_new0 (guint8, _tmp37_);
				buf = _tmp38_;
				buf_length1 = _tmp37_;
				_buf_size_ = buf_length1;
				_tmp39_ = self->priv->output_stream;
				_tmp40_ = buf;
				_tmp40__length1 = buf_length1;
				_tmp41_ = self->priv->child_io_cancellable;
				g_input_stream_read_all ((GInputStream*) _tmp39_, _tmp40_, (gsize) _tmp40__length1, &_tmp42_, _tmp41_, &_inner_error_);
				bytes = _tmp42_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					buf = (g_free (buf), NULL);
					_g_free0 (uri);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (str);
					_g_object_unref0 (stream);
					goto __catch29_g_error;
				}
				_tmp43_ = length;
				_tmp44_ = bytes;
				g_debug ("Expected %" G_GSIZE_FORMAT " bytes, got %" G_GSIZE_FORMAT, _tmp43_, _tmp44_);
				_tmp45_ = rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE;
				_tmp46_ = buf;
				_tmp46__length1 = buf_length1;
				_tmp47_ = g_variant_new_from_data (_tmp45_, (guchar*) _tmp46_, (_tmp46__length1 * sizeof (guint8)) / sizeof (guchar), TRUE, NULL, NULL);
				g_variant_ref_sink (_tmp47_);
				v = _tmp47_;
				_tmp48_ = uri;
				_tmp49_ = g_file_new_for_uri (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = v;
				g_signal_emit_by_name (self, "extraction-done", _tmp50_, _tmp51_);
				_g_object_unref0 (_tmp50_);
				_g_variant_unref0 (v);
				buf = (g_free (buf), NULL);
				_g_free0 (uri);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp52_ = self->priv->output_stream;
		_tmp53_ = self->priv->child_io_cancellable;
		g_data_input_stream_read_line_async (_tmp52_, G_PRIORITY_DEFAULT, _tmp53_, _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback, g_object_ref (self));
		_g_free0 (str);
		_g_object_unref0 (stream);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp54_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp54_ = _error_;
		if (g_error_matches (_tmp54_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			g_debug ("rygel-media-export-metadata-extractor.vala:262: Read was cancelled, pr" \
"ocess probably died…");
		} else {
			const gchar* _tmp55_ = NULL;
			GError* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GFile* _tmp59_ = NULL;
			GFile* _tmp60_ = NULL;
			GError* _tmp61_ = NULL;
			GError* _tmp62_ = NULL;
			_tmp55_ = _ ("Read from child failed: %s");
			_tmp56_ = _error_;
			_tmp57_ = _tmp56_->message;
			g_warning (_tmp55_, _tmp57_);
			_tmp58_ = self->priv->error_uri;
			_tmp59_ = g_file_new_for_uri (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_error_new_literal (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_GENERAL, "Failed");
			_tmp62_ = _tmp61_;
			g_signal_emit_by_name (self, "error", _tmp60_, _tmp62_);
			_g_error_free0 (_tmp62_);
			_g_object_unref0 (_tmp60_);
		}
		_g_error_free0 (_error_);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelMediaExportMetadataExtractor* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->file);
		_g_free0 (_data5_->content_type);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean ___lambda7_ (Block5Data* _data5_) {
	RygelMediaExportMetadataExtractor* self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->file;
	_tmp1_ = _data5_->content_type;
	rygel_media_export_metadata_extractor_extract (self, _tmp0_, _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}


void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file, const gchar* content_type) {
	Block5Data* _data5_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* s = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (content_type != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->file);
	_data5_->file = _tmp1_;
	_tmp2_ = content_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data5_->content_type);
	_data5_->content_type = _tmp3_;
	_tmp4_ = self->priv->child_io_cancellable;
	_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
	if (_tmp5_) {
		g_debug ("rygel-media-export-metadata-extractor.vala:276: Child apparently alrea" \
"dy died, scheduling command for later");
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda7__gsource_func, block5_data_ref (_data5_), block5_data_unref);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp6_ = _data5_->file;
	_tmp7_ = g_file_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _data5_->content_type;
	_tmp10_ = g_strdup_printf ("EXTRACT %s|%s\n", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	s = _tmp11_;
	{
		GUnixOutputStream* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		guint8* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		GCancellable* _tmp16_ = NULL;
		GUnixOutputStream* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp12_ = self->priv->input_stream;
		_tmp13_ = s;
		_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp14__length1;
		_tmp16_ = self->priv->child_io_cancellable;
		g_output_stream_write_all ((GOutputStream*) _tmp12_, _tmp15_, (gsize) _tmp15__length1, NULL, _tmp16_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_tmp17_ = self->priv->input_stream;
		g_output_stream_flush ((GOutputStream*) _tmp17_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_tmp18_ = s;
		g_debug ("rygel-media-export-metadata-extractor.vala:290: Sent command to extrac" \
"tor process: %s", _tmp18_);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _ ("Failed to send command to child: %s");
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		g_warning (_tmp19_, _tmp21_);
		_g_error_free0 (_error_);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (s);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (s);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self, RygelConfiguration* config, const gchar* section, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp6_ = FALSE;
	GUnixOutputStream* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = key;
		_tmp0_ = g_strcmp0 (_tmp2_, "extract-metadata") != 0;
	}
	if (_tmp0_) {
		return;
	}
	{
		gboolean _tmp3_ = FALSE;
		RygelConfiguration* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = config;
		_tmp5_ = rygel_configuration_get_bool (_tmp4_, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata", &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch31_g_error;
		}
		self->priv->extract_metadata = _tmp3_;
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->extract_metadata = TRUE;
		_g_error_free0 (_error_);
	}
	__finally31:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->input_stream;
	if (_tmp7_ != NULL) {
		GCancellable* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->child_io_cancellable;
		_tmp9_ = g_cancellable_is_cancelled (_tmp8_);
		_tmp6_ = !_tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		{
			gchar* s = NULL;
			gboolean _tmp10_ = FALSE;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			GUnixOutputStream* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			guint8* _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			guint8* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			GUnixOutputStream* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			_tmp10_ = self->priv->extract_metadata;
			_tmp11_ = bool_to_string (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("METADATA %s\n", _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			s = _tmp14_;
			_tmp15_ = self->priv->input_stream;
			_tmp16_ = s;
			_tmp17_ = string_get_data (_tmp16_, &_tmp17__length1);
			_tmp18_ = _tmp17_;
			_tmp18__length1 = _tmp17__length1;
			g_output_stream_write_all ((GOutputStream*) _tmp15_, _tmp18_, (gsize) _tmp18__length1, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (s);
				goto __catch32_g_error;
			}
			_tmp19_ = self->priv->input_stream;
			g_output_stream_flush ((GOutputStream*) _tmp19_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (s);
				goto __catch32_g_error;
			}
			_tmp20_ = s;
			g_debug ("rygel-media-export-metadata-extractor.vala:320: Sent config change to " \
"child: %s", _tmp20_);
			_g_free0 (s);
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = _error_;
			_tmp22_ = _tmp21_->message;
			g_debug ("rygel-media-export-metadata-extractor.vala:322: Failed to set meta-dat" \
"a extraction state: %s", _tmp22_);
			_g_error_free0 (_error_);
		}
		__finally32:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_VARIANT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_variant (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	GVariantType* _tmp0_ = NULL;
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_VARIANT, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_VARIANT);
	/**
	     * Signalize that an error occured during metadata extraction
	     */
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
	_tmp0_ = g_variant_type_new ("(smvmvmvmvmvmv)");
	_g_variant_type_free0 (rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE);
	rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE = _tmp0_;
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
	self->priv->error_uri = NULL;
	_tmp0_ = g_strdup (MX_EXTRACT_PATH);
	_tmp1_ = g_strdup ("--input-fd=3");
	_tmp2_ = g_strdup ("--output-fd=4");
	_tmp3_ = g_strdup ("--error-fd=5");
	_tmp4_ = g_strdup ("--extract-metadata");
	_tmp5_ = g_new0 (gchar*, 6 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	_tmp5_[5] = NULL;
	self->priv->MX_EXTRACT_ARGV = _tmp5_;
	self->priv->MX_EXTRACT_ARGV_length1 = 6;
	self->priv->_MX_EXTRACT_ARGV_size_ = self->priv->MX_EXTRACT_ARGV_length1;
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor);
	_g_object_unref0 (self->priv->input_stream);
	_g_object_unref0 (self->priv->output_stream);
	_g_object_unref0 (self->priv->error_stream);
	_g_object_unref0 (self->priv->child_io_cancellable);
	_g_object_unref0 (self->priv->launcher);
	_g_free0 (self->priv->error_uri);
	self->priv->MX_EXTRACT_ARGV = (_vala_array_free (self->priv->MX_EXTRACT_ARGV, self->priv->MX_EXTRACT_ARGV_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



