/* example-player-vala.c generated by valac 0.29.2, the Vala compiler
 * generated from example-player-vala.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define RYGEL_EXAMPLE_TYPE_PLAYER_VALA (rygel_example_player_vala_get_type ())
#define RYGEL_EXAMPLE_PLAYER_VALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerVala))
#define RYGEL_EXAMPLE_PLAYER_VALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerValaClass))
#define RYGEL_EXAMPLE_IS_PLAYER_VALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXAMPLE_TYPE_PLAYER_VALA))
#define RYGEL_EXAMPLE_IS_PLAYER_VALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXAMPLE_TYPE_PLAYER_VALA))
#define RYGEL_EXAMPLE_PLAYER_VALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerValaClass))

typedef struct _RygelExamplePlayerVala RygelExamplePlayerVala;
typedef struct _RygelExamplePlayerValaClass RygelExamplePlayerValaClass;
typedef struct _RygelExamplePlayerValaPrivate RygelExamplePlayerValaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelExamplePlayerVala {
	GObject parent_instance;
	RygelExamplePlayerValaPrivate * priv;
};

struct _RygelExamplePlayerValaClass {
	GObjectClass parent_class;
};

struct _RygelExamplePlayerValaPrivate {
	gchar* _user_agent;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _playback_speed;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
	gdouble _volume;
	gint64 _duration;
	gint64 _position;
};


static gpointer rygel_example_player_vala_parent_class = NULL;
static RygelExamplePlayerVala* rygel_example_player_vala_player;
static RygelExamplePlayerVala* rygel_example_player_vala_player = NULL;
static RygelMediaPlayerIface* rygel_example_player_vala_rygel_media_player_parent_iface = NULL;

GType rygel_example_player_vala_get_type (void) G_GNUC_CONST;
#define RYGEL_EXAMPLE_PLAYER_VALA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerValaPrivate))
enum  {
	RYGEL_EXAMPLE_PLAYER_VALA_DUMMY_PROPERTY,
	RYGEL_EXAMPLE_PLAYER_VALA_USER_AGENT,
	RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_STATE,
	RYGEL_EXAMPLE_PLAYER_VALA_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_SPEED,
	RYGEL_EXAMPLE_PLAYER_VALA_URI,
	RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPE,
	RYGEL_EXAMPLE_PLAYER_VALA_METADATA,
	RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK,
	RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK_BYTES,
	RYGEL_EXAMPLE_PLAYER_VALA_CONTENT_FEATURES,
	RYGEL_EXAMPLE_PLAYER_VALA_VOLUME,
	RYGEL_EXAMPLE_PLAYER_VALA_DURATION,
	RYGEL_EXAMPLE_PLAYER_VALA_SIZE,
	RYGEL_EXAMPLE_PLAYER_VALA_POSITION,
	RYGEL_EXAMPLE_PLAYER_VALA_BYTE_POSITION
};
RygelExamplePlayerVala* rygel_example_player_vala_get_default (void);
RygelExamplePlayerVala* rygel_example_player_vala_new (void);
RygelExamplePlayerVala* rygel_example_player_vala_construct (GType object_type);
static gboolean rygel_example_player_vala_real_seek (RygelMediaPlayer* base, gint64 time);
static gboolean rygel_example_player_vala_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes);
static gchar** rygel_example_player_vala_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_example_player_vala_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean _rygel_example_player_vala_playback_state____lambda4_ (RygelExamplePlayerVala* self);
static gboolean __lambda5_ (RygelExamplePlayerVala* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __rygel_example_player_vala_playback_state____lambda4__gsource_func (gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void rygel_example_player_vala_finalize (GObject* obj);
static void _vala_rygel_example_player_vala_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_example_player_vala_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS[1] = {"http-get"};
static const gchar* RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES[2] = {"image/jpeg", "image/png"};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelExamplePlayerVala* rygel_example_player_vala_get_default (void) {
	RygelExamplePlayerVala* result = NULL;
	RygelExamplePlayerVala* _tmp0_ = NULL;
	RygelExamplePlayerVala* _tmp2_ = NULL;
	RygelExamplePlayerVala* _tmp3_ = NULL;
	_tmp0_ = rygel_example_player_vala_player;
	if (_tmp0_ == NULL) {
		RygelExamplePlayerVala* _tmp1_ = NULL;
		_tmp1_ = rygel_example_player_vala_new ();
		_g_object_unref0 (rygel_example_player_vala_player);
		rygel_example_player_vala_player = _tmp1_;
	}
	_tmp2_ = rygel_example_player_vala_player;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean rygel_example_player_vala_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelExamplePlayerVala * self;
	gboolean result = FALSE;
	self = (RygelExamplePlayerVala*) base;
	result = FALSE;
	return result;
}


static gboolean rygel_example_player_vala_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes) {
	RygelExamplePlayerVala * self;
	gboolean result = FALSE;
	self = (RygelExamplePlayerVala*) base;
	result = FALSE;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_example_player_vala_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelExamplePlayerVala * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = (RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS != NULL) ? _vala_array_dup1 (RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS, G_N_ELEMENTS (RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS)) : ((gpointer) RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_EXAMPLE_PLAYER_VALA_PROTOCOLS);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_example_player_vala_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelExamplePlayerVala * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = (RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES != NULL) ? _vala_array_dup2 (RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES, G_N_ELEMENTS (RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES)) : ((gpointer) RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES);
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPES);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


RygelExamplePlayerVala* rygel_example_player_vala_construct (GType object_type) {
	RygelExamplePlayerVala * self = NULL;
	self = (RygelExamplePlayerVala*) g_object_new (object_type, NULL);
	return self;
}


RygelExamplePlayerVala* rygel_example_player_vala_new (void) {
	return rygel_example_player_vala_construct (RYGEL_EXAMPLE_TYPE_PLAYER_VALA);
}


static gchar* rygel_example_player_vala_real_get_user_agent (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_user_agent;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_user_agent (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_user_agent);
	self->priv->_user_agent = _tmp1_;
	g_object_notify ((GObject *) self, "user-agent");
}


static gchar* rygel_example_player_vala_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_playback_state;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean __lambda5_ (RygelExamplePlayerVala* self) {
	gboolean result = FALSE;
	rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelExamplePlayerVala*) self);
	return result;
}


static gboolean _rygel_example_player_vala_playback_state____lambda4_ (RygelExamplePlayerVala* self) {
	gboolean result = FALSE;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	GError * _inner_error_ = NULL;
	{
		GFile* f = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		guint8* _tmp5_ = NULL;
		gsize _tmp6_;
		_tmp0_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_new_for_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		f = _tmp4_;
		g_file_load_contents (f, NULL, &_tmp5_, &_tmp6_, NULL, &_inner_error_);
		data = (g_free (data), NULL);
		data = _tmp5_;
		data_length1 = _tmp6_;
		_data_size_ = data_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (f);
			goto __catch0_g_error;
		}
		_g_object_unref0 (f);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("example-player-vala.vala:64: Failed: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		data = (g_free (data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 60, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	data = (g_free (data), NULL);
	return result;
}


static gboolean __rygel_example_player_vala_playback_state____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _rygel_example_player_vala_playback_state____lambda4_ ((RygelExamplePlayerVala*) self);
	return result;
}


static void rygel_example_player_vala_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_playback_state);
	self->priv->_playback_state = _tmp1_;
	_tmp2_ = self->priv->_playback_state;
	if (g_strcmp0 (_tmp2_, "PLAYING") == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __rygel_example_player_vala_playback_state____lambda4__gsource_func, g_object_ref (self), g_object_unref);
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** rygel_example_player_vala_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelExamplePlayerVala* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_allowed_playback_speeds;
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static gchar* rygel_example_player_vala_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_playback_speed;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_playback_speed);
	self->priv->_playback_speed = _tmp1_;
	g_object_notify ((GObject *) self, "playback-speed");
}


static gchar* rygel_example_player_vala_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	_tmp2_ = value;
	g_debug ("example-player-vala.vala:113: URI set to %s.", _tmp2_);
	_tmp3_ = self->priv->_playback_state;
	if (g_strcmp0 (_tmp3_, "EOS") == 0) {
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
	}
	g_object_notify ((GObject *) self, "uri");
}


static gchar* rygel_example_player_vala_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_mime_type;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mime_type);
	self->priv->_mime_type = _tmp1_;
	g_object_notify ((GObject *) self, "mime-type");
}


static gchar* rygel_example_player_vala_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


static gboolean rygel_example_player_vala_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelExamplePlayerVala* self;
	self = (RygelExamplePlayerVala*) base;
	result = FALSE;
	return result;
}


static gboolean rygel_example_player_vala_real_get_can_seek_bytes (RygelMediaPlayer* base) {
	gboolean result;
	RygelExamplePlayerVala* self;
	self = (RygelExamplePlayerVala*) base;
	result = FALSE;
	return result;
}


static gchar* rygel_example_player_vala_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_content_features;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_example_player_vala_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelExamplePlayerVala* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_content_features);
	self->priv->_content_features = _tmp1_;
	g_object_notify ((GObject *) self, "content-features");
}


static gdouble rygel_example_player_vala_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelExamplePlayerVala* self;
	gdouble _tmp0_ = 0.0;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


static void rygel_example_player_vala_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelExamplePlayerVala* self;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = value;
	self->priv->_volume = _tmp0_;
	_tmp1_ = value;
	g_debug ("example-player-vala.vala:164: volume set to %f.", _tmp1_);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 rygel_example_player_vala_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelExamplePlayerVala* self;
	gint64 _tmp0_ = 0LL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_duration;
	result = _tmp0_;
	return result;
}


static gint64 rygel_example_player_vala_real_get_size (RygelMediaPlayer* base) {
	gint64 result;
	RygelExamplePlayerVala* self;
	self = (RygelExamplePlayerVala*) base;
	result = (gint64) 0;
	return result;
}


static gint64 rygel_example_player_vala_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelExamplePlayerVala* self;
	gint64 _tmp0_ = 0LL;
	self = (RygelExamplePlayerVala*) base;
	_tmp0_ = self->priv->_position;
	result = _tmp0_;
	return result;
}


static gint64 rygel_example_player_vala_real_get_byte_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelExamplePlayerVala* self;
	self = (RygelExamplePlayerVala*) base;
	result = (gint64) 0;
	return result;
}


static void rygel_example_player_vala_class_init (RygelExamplePlayerValaClass * klass) {
	rygel_example_player_vala_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelExamplePlayerValaPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_example_player_vala_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_example_player_vala_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_example_player_vala_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_USER_AGENT, g_param_spec_string ("user-agent", "user-agent", "user-agent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK_BYTES, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_EXAMPLE_PLAYER_VALA_BYTE_POSITION, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_example_player_vala_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_example_player_vala_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_example_player_vala_real_seek;
	iface->seek_bytes = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_example_player_vala_real_seek_bytes;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_example_player_vala_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_example_player_vala_real_get_mime_types;
	iface->get_user_agent = rygel_example_player_vala_real_get_user_agent;
	iface->set_user_agent = rygel_example_player_vala_real_set_user_agent;
	iface->get_playback_state = rygel_example_player_vala_real_get_playback_state;
	iface->set_playback_state = rygel_example_player_vala_real_set_playback_state;
	iface->get_allowed_playback_speeds = rygel_example_player_vala_real_get_allowed_playback_speeds;
	iface->get_playback_speed = rygel_example_player_vala_real_get_playback_speed;
	iface->set_playback_speed = rygel_example_player_vala_real_set_playback_speed;
	iface->get_uri = rygel_example_player_vala_real_get_uri;
	iface->set_uri = rygel_example_player_vala_real_set_uri;
	iface->get_mime_type = rygel_example_player_vala_real_get_mime_type;
	iface->set_mime_type = rygel_example_player_vala_real_set_mime_type;
	iface->get_metadata = rygel_example_player_vala_real_get_metadata;
	iface->set_metadata = rygel_example_player_vala_real_set_metadata;
	iface->get_can_seek = rygel_example_player_vala_real_get_can_seek;
	iface->get_can_seek_bytes = rygel_example_player_vala_real_get_can_seek_bytes;
	iface->get_content_features = rygel_example_player_vala_real_get_content_features;
	iface->set_content_features = rygel_example_player_vala_real_set_content_features;
	iface->get_volume = rygel_example_player_vala_real_get_volume;
	iface->set_volume = rygel_example_player_vala_real_set_volume;
	iface->get_duration = rygel_example_player_vala_real_get_duration;
	iface->get_size = rygel_example_player_vala_real_get_size;
	iface->get_position = rygel_example_player_vala_real_get_position;
	iface->get_byte_position = rygel_example_player_vala_real_get_byte_position;
}


static void rygel_example_player_vala_instance_init (RygelExamplePlayerVala * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	self->priv = RYGEL_EXAMPLE_PLAYER_VALA_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
	self->priv->_playback_state = _tmp0_;
	_tmp1_ = g_strdup ("1/2");
	_tmp2_ = g_strdup ("1");
	_tmp3_ = g_strdup ("2");
	_tmp4_ = g_new0 (gchar*, 3 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp2_;
	_tmp4_[2] = _tmp3_;
	self->priv->_allowed_playback_speeds = _tmp4_;
	self->priv->_allowed_playback_speeds_length1 = 3;
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
	_tmp5_ = g_strdup ("1");
	self->priv->_playback_speed = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_uri = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_mime_type = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_metadata = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->priv->_content_features = _tmp9_;
	self->priv->_volume = (gdouble) 0;
	self->priv->_duration = (gint64) 0;
	self->priv->_position = (gint64) 0;
}


static void rygel_example_player_vala_finalize (GObject* obj) {
	RygelExamplePlayerVala * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerVala);
	_g_free0 (self->priv->_user_agent);
	_g_free0 (self->priv->_playback_state);
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_playback_speed);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_metadata);
	_g_free0 (self->priv->_content_features);
	G_OBJECT_CLASS (rygel_example_player_vala_parent_class)->finalize (obj);
}


/**
 * Implementation of RygelMediaPlayer.
 *
 * This is an incredibly simple example that does no real rendering,
 * and does not attempt to support audio or video formats. It just prints out
 * the URI that is received from the UPnP control point.
 *
 * RygelPlaybinPlayer, from librygel-renderer-gst, is a more complete example.
 */
GType rygel_example_player_vala_get_type (void) {
	static volatile gsize rygel_example_player_vala_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_example_player_vala_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelExamplePlayerValaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_example_player_vala_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExamplePlayerVala), 0, (GInstanceInitFunc) rygel_example_player_vala_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_example_player_vala_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_example_player_vala_type_id;
		rygel_example_player_vala_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelExamplePlayerVala", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_example_player_vala_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_example_player_vala_type_id__volatile, rygel_example_player_vala_type_id);
	}
	return rygel_example_player_vala_type_id__volatile;
}


static void _vala_rygel_example_player_vala_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelExamplePlayerVala * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerVala);
	switch (property_id) {
		case RYGEL_EXAMPLE_PLAYER_VALA_USER_AGENT:
		g_value_take_string (value, rygel_media_player_get_user_agent ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_ALLOWED_PLAYBACK_SPEEDS:
		{
			int length;
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
		}
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_SPEED:
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPE:
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_METADATA:
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK:
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_CAN_SEEK_BYTES:
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_CONTENT_FEATURES:
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_SIZE:
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_BYTE_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_example_player_vala_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelExamplePlayerVala * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_EXAMPLE_TYPE_PLAYER_VALA, RygelExamplePlayerVala);
	switch (property_id) {
		case RYGEL_EXAMPLE_PLAYER_VALA_USER_AGENT:
		rygel_media_player_set_user_agent ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_PLAYBACK_SPEED:
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_MIME_TYPE:
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_METADATA:
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_CONTENT_FEATURES:
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_EXAMPLE_PLAYER_VALA_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



