# -*- coding: utf-8 -*-

# Copyright (C) 2004-2006 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import dbus
import dbus.service
import dbus.glib

class DBus(object):
    """Singleton representing the session DBus"""

    instance = None

    def __new__(type, *args):
        if DBus.instance is None:
            DBus.instance = object.__new__(type)
            DBus.instance.__init(*args)
        return DBus.instance

    def __init(self, *args):
        self.bus = None

    def get_interface(self, interface, path):
        if self.bus is None:
            try:
                self.bus = dbus.SessionBus()
            except dbus.dbus_bindings.DBusException:
                self.bus = None
                return None

        object = self.bus.get_object("org.freedesktop.DBus",
                                     "/org/freedesktop/DBus")
        dbus_iface = dbus.Interface(object, "org.freedesktop.DBus")
        running_services = dbus_iface.ListNames()
        started = True
        if interface not in running_services:
            if dbus_iface.StartServiceByName(interface, dbus.UInt32(0)) == 1:
                started = True
            else:
                started = False
        if not started:
            return None
        object = self.bus.get_object(interface, path)
        return dbus.Interface(object, interface)

    def get_notifications_interface(self):
        return self.get_interface("org.freedesktop.Notifications",
                                  "/org/freedesktop/Notifications")

# vim: set sw=4 et sts=4 tw=79 fo+=l:
