/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.gdk.EventConfigure;
import org.gnu.gdk.Window;
import org.gnu.glib.EventType;

/**
 * This event is used to identify a Configure event on a Widget.
 * 
 * @see ConfigureListener
 */

public class ConfigureEvent extends GtkEvent {

    private int x;

    private int y;

    private int width;

    private int height;

    private Window window;

    private boolean sendEvent;

    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        /**
         */
        public static final Type CONFIGURE = new Type(1, "CONFIGURE");

    }

    /**
     * Constructor for ConfigureEvent.
     * 
     * @param source
     * @param type
     */
    public ConfigureEvent(Object source, EventType type, EventConfigure event) {
        super(source, type);
        this.x = event.getX();
        this.y = event.getY();
        this.width = event.getWidth();
        this.height = event.getHeight();
        this.window = event.getWindow();
        this.sendEvent = event.getSendEvent();
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(ConfigureEvent.Type aType) {
        return (type.getID() == aType.getID());
    }

    /**
     * @return Returns the height.
     */
    public int getHeight() {
        return height;
    }

    /**
     * @return Returns the width.
     */
    public int getWidth() {
        return width;
    }

    /**
     * @return Returns the x.
     */
    public int getX() {
        return x;
    }

    /**
     * @return Returns the y.
     */
    public int getY() {
        return y;
    }

    /**
     * @return Returns the window
     */
    public Window getWindow() {
        return window;
    }
}
