/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * HBox is a container widget that organizes its contained widgets
 * horizontally side by side. Most manipulation options are methods of the
 * superclass, Box.
 * @see Box
 * @see VBox
 */
public class HBox extends Box 
{
	/**
	 * Constructs a new HBox widget.
	 * @param homogenous TRUE if all children are to be given equal space allotments.
	 * @param spacing The number of pixels to place by default between children.
	 */
	public HBox(boolean homogenous, int spacing){
		super(gtk_hbox_new (homogenous, spacing));
	}
	
	public HBox(Handle handle) {
	    super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static HBox getHBox(Handle handle) {
        if (handle == null)
            return null;
        
        HBox obj = (HBox) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new HBox(handle);
        
        return obj;
    }

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hbox_get_type());
	}


    native static final protected int gtk_hbox_get_type ();
    native static final protected Handle gtk_hbox_new (boolean homogenous, int spacing);

}

