/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 * Interface used as a callback when links (URLs or email) are activated in the
 * authors, documenters or artists sections of an {@link AboutDialog}.
 */
public interface AboutDialogActivateLinkMethod {
    /**
     * Method called when a URL or email link is activated in an
     * <tt>AboutDialog</tt>.
     */
    public void linkActivated( AboutDialog dialog, String link );
}
