/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;


/**
 * Attributed text is used in a number of places in Pango. It is used as the
 * input to the itemization process and also when creating a {@link Layout}. The
 * data types and functions in this section are used to represent and manipulate
 * sets of attributes applied to a portion of text.
 */
public class Attribute extends Boxed 
{

	/**
	 * Returns the start index of the range
	 */
	public int getStartIndex(){
		return getStartIndex(handle);
	}

	/**
	 * Returns end index of the range. The character at this index is not
	 * included in the range.
	 */
	public int getEndIndex(){
		return getEndIndex(handle);
	}

	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getStartIndex (Handle obj);
    native static final protected int getEndIndex (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

