/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * Contains information about an image format of a Pixbuf.
 */
public class PixbufFormat extends Boxed {
	
	PixbufFormat(Handle handle) {
		super(handle);
	}

	public String getName() {
		return gdk_pixbuf_format_get_name(getHandle());
	}
	
	public String getDescription() {
		return gdk_pixbuf_format_get_description(getHandle());
	}
	
	public String[] getMimeTypes(){
		return gdk_pixbuf_format_get_mime_types(getHandle());
	}
	
	public String[] getExtensions() {
		return gdk_pixbuf_format_get_extensions(getHandle());
	}
	
	public boolean isWritable() {
		return gdk_pixbuf_format_is_writable(getHandle());
	}
	

    native static final protected String gdk_pixbuf_format_get_name(Handle format);
    native static final protected String gdk_pixbuf_format_get_description(Handle format);
    native static final protected String[] gdk_pixbuf_format_get_mime_types(Handle format);
    native static final protected String[] gdk_pixbuf_format_get_extensions(Handle format);
    native static final protected boolean gdk_pixbuf_format_is_writable(Handle format);

}
