#!/bin/sh
#
# A small script to help run example apps
#

GTK_LIB=../../gtk/lib/
GTK_JAR=../../gtk/lib/gtk2.4.jar
GNOME_LIB=#../../gnome/lib/
GNOME_JAR=#../../gnome/lib/gnome2.6.jar
GLADE_LIB=#../../glade/lib/
GLADE_JAR=#../../glade/lib/glade2.6.jar

JAVAC=javac
JAVA=java

# You should not need to modify anything below here

NEED_LIB="$GTK_LIB $GNOME_LIB $GLADE_LIB "
NEED_JAR="$GTK_JAR $GNOME_JAR $GLADE_JAR"

echo "Java-Gnome Example Application Launcher"
echo

echo "Checking library paths exist.."

ERROR=0

for NEEDLIB in $NEED_LIB; do
	if test -e $NEEDLIB; then echo "	$NEEDLIB - appears to be ok"; fi;
	if ! test -e $NEEDLIB; then echo "	$NEEDLIB - DOES NOT EXIST" && 		ERROR=1; fi;
done;

echo
echo "Testing JAR archives"
for JAR in $NEED_JAR; do
	if test -e $JAR; then
		echo "	$JAR - appears to be ok";
	else
		echo "	$JAR - DOES NOT EXIST";
		ERROR=1
	fi;
done;

echo

if ! test -e $@.java ; then
	echo "Error: unexpected example app";
	echo
	ERROR=1
fi

export CLASSPATH=$CLASSPATH:$1:$GTK_JAR:$GNOME_JAR:$GLADE_JAR
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$GNOME_LIB:$GTK_LIB:$GLADE_LIB
if test "$ERROR" == "0"; then
	($JAVAC $@.java && echo "Compilation successful") || (echo "Compilation failed"; ERROR=1)
fi;

if test $ERROR == "0"; then
	($JAVA $@ && echo "Application successfully terminated") || (echo
	"Application terminated abnormally"; ERROR=1)
fi;

if test $ERROR == "1"; then
	echo
	echo "Usage:"
	echo "Please first ensure you have compiled java-gnome then edit this file and set
	the paths at the top of the file to point to installation
	directories"
	echo
	echo "Run an application by passing it's classname to this file, e.g."
	echo "	./$0 progressbar/ProgressBarTest"
	echo
	exit 1;
fi;

