/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The DrawingArea widget is used for creating custom user interface elements.
 * It's essentially a blank widget you can draw on.
 */
public class DrawingArea extends Widget 
{
	public DrawingArea() {
		noopInit();
	}
	
	/**
	 * Construct a DrawingArea using a handle to a native resource.
	 */
	public DrawingArea(int handle) {
	    setHandle(handle);
	    initializeEventHandlers();
	}

	protected void noopInit() {
		if (-1 == getHandle()) {
			setHandle(gtk_drawing_area_new());
			initializeEventHandlers();
		}
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_drawing_area_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_drawing_area_get_type ();
    native static final protected int gtk_drawing_area_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

