/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:32 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.pango.Language
     * Method:    pango_language_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Language_pango_1language_1get_1type (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)pango_language_get_type ();
        }
    }

    /*
     * Class:     org.gnu.pango.Language
     * Method:    pango_language_from_string
     * Signature: (java.lang.String;)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_pango_Language_pango_1language_1from_1string (JNIEnv *env, 
        jclass cls, jstring language) 
    {
        const gchar* language_g = (*env)->GetStringUTFChars(env, language, 0);
        jint result = (jint)pango_language_from_string (language_g);
        (*env)->ReleaseStringUTFChars(env, language, language_g);
    }

    /*
     * Class:     org.gnu.pango.Language
     * Method:    pango_language_to_string
     * Signature: (I)java.lang.String
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_pango_Language_pango_1language_1to_1string (JNIEnv 
        *env, jclass cls, jint language) 
    {
        gchar *result_g = (gchar *)pango_language_to_string ((PangoLanguage *)language);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.pango.Language
     * Method:    pango_language_matches
     * Signature: (Ijava.lang.String;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_pango_Language_pango_1language_1matches (JNIEnv *env, 
        jclass cls, jint language, jstring rangeList) 
    {
        const gchar* rangeList_g = (*env)->GetStringUTFChars(env, rangeList, 0);
        jboolean result_j = (jboolean) (pango_language_matches ((PangoLanguage *)language, rangeList_g));
        (*env)->ReleaseStringUTFChars(env, rangeList, rangeList_g);
        return result_j;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
