/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This event is used to identify life cycle events that effect a
 * widget.
 * @see LifeCycleListener
 */
public class LifeCycleEvent extends GtkEvent {

	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}
		/**
		 * This event indicates that a widget has been realized.
		 */
		public static final Type REALIZE = new Type(1, "REALIZE");

		/**
		 * This event indicates that a widget has been unrealized
		 */	
		public static final Type UNREALIZE = new Type(2, "UNREALIZE");

		/**
		 * This event indicates that a widget has been deleted
		 */	
		public static final Type DELETE = new Type(3, "DELETE");

		/**
		 * This event indicates that a widget has been destroyed
		 */	
		public static final Type DESTROY = new Type(4, "DESTROY");

		/**
		 * This event indicates that a widget has become visible.
		 */	
		public static final Type SHOW = new Type(5, "SHOW");

		/**
		 * This event indicates that a widget has become invisible.
		 */	
		public static final Type HIDE = new Type(6, "HIDE");
	}

	/**
	 * Construct a LifeCycleEvent object.
	 */
	public LifeCycleEvent(Object source, LifeCycleEvent.Type type) {
		super(source, type);
	}

	/**
	 */
	public boolean isOfType(LifeCycleEvent.Type test) {
		return type.getID() == test.getID();
	}
}
