#include "jg_jnu.h"
#include <sys/types.h>
#include <glib.h>
#include <glib-object.h>

#ifdef __cplusplus
extern "C" {
#endif


static volatile GSource *source;
static volatile GMainContext *context;
static volatile jclass class;
static volatile jmethodID mid;
static volatile int signalPipe[2];
static volatile GIOChannel* gio;

gboolean function( gpointer data ){
    JNIEnv *env = JNU_GetEnv();
    jboolean exceptionThrown;
	char dummy;

	read( signalPipe[0], &dummy, 1 );
    
    (*env)->CallStaticVoidMethod(env, class, mid);

    exceptionThrown = (*env)->ExceptionCheck(env);
    if (exceptionThrown) {
		// We cannot throw this exception, since this timer was called by GLib.
		(*env)->ExceptionDescribe(env);  // ExceptionDescribe clears exception
    }
	return TRUE;
}

JNIEXPORT void JNICALL Java_org_gnu_glib_CustomEvents_init (
    JNIEnv *env, jclass cls)
{	
	pipe(signalPipe);
	gio = g_io_channel_unix_new(signalPipe[0]);
	
	class = (jclass) (*env)->NewGlobalRef(env, cls);
    mid = (*env)->GetStaticMethodID(env, cls, "runEvents", "()V");
	source = g_io_create_watch( gio, G_IO_IN );
	context = g_main_context_default();
	g_source_set_can_recurse( source, FALSE );
	g_source_set_callback( source, (GSourceFunc) function, NULL, NULL );
	g_source_attach( source, context );
}

JNIEXPORT void JNICALL Java_org_gnu_glib_CustomEvents_setEventsPending( JNIEnv *env, jclass cls, jboolean pending ){
	if(pending) {
		write( signalPipe[1], "", 1 );
	}
}


JNIEXPORT void JNICALL Java_org_gnu_glib_CustomEvents_cleanup( JNIEnv *env, jclass cls ){
	g_source_destroy( source );	
	g_io_channel_close( gio );
	(*env)->DeleteGlobalRef(env, class);
}

#ifdef __cplusplus
}
#endif
