/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:30 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A CheckButton widget displays a small button with a label next to
 * it. The button can be toggled on or off by the mouse, and will
 * retain its state until it is toggled again.
 */
public class CheckButton extends ToggleButton 
{
	/**
	 * Creates a new CheckButton
	 */
	public CheckButton(){
		noopInit();
	}
	
	/**
	 * Construct a check button using a handle to a native resource.
	 */
	public CheckButton(int handle) {
	    super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = gtk_check_button_new ();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Creates a new Checkbutton with a label. If hasMnemonic is true, any mnemonic
	 * characters in the {@link Label} will be interpreted. See the description
	 * of the {@link Label} class for more details of mnemonic characters.
	 *
	 * @param label Text to be displayed in a label next to the check box.
	 * @param hasMnemonic. Determines whether to interpret Mnemonic characters
	 */
	public CheckButton(String label, boolean hasMnemonic){
		if (hasMnemonic) {
			handle = gtk_check_button_new_with_mnemonic(label);
		} else {
			handle = gtk_check_button_new_with_label(label);
		}
		initializeEventHandlers();
	}

	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_check_button_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_check_button_get_type ();
    native static final protected int gtk_check_button_new ();
    native static final protected int gtk_check_button_new_with_label (String label);
    native static final protected int gtk_check_button_new_with_mnemonic (String label);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

