/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_RadioAction
#define _Included_org_gnu_gtk_RadioAction
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_radio_action_get_type();
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_group
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1group
  (JNIEnv *env, jclass cls, jint action)
{
	GSList *list = gtk_radio_action_get_group((GtkRadioAction*)action);
	guint len;
	jintArray ar;
	int i = 0;
 	if (NULL == list)
		return NULL;
	 len = g_slist_length(list);
	 ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		GSList *item = g_slist_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_set_group
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1set_1group
  (JNIEnv *env, jclass cls, jint action, jintArray group)
{
	jsize len;
	int index;
	jint* g;
	GSList *list;
	GtkRadioAction* act;

	list = g_slist_alloc();
	len = (*env)->GetArrayLength(env, group);
	g = (*env)->GetIntArrayElements(env, group, NULL);
	for (index = 0; index < len; index++) {
		act = (GtkRadioAction*)g[index];
		list = g_slist_append(list, act);
	}
	gtk_radio_action_set_group((GtkRadioAction*)action, list);
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_current_value
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1current_1value
  (JNIEnv *env, jclass cls, jint action)
{
	return (jint)gtk_radio_action_get_current_value((GtkRadioAction*)action);
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    allocate
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_allocate
  (JNIEnv *env, jclass cls)
{
	return (jint)g_object_new(GTK_TYPE_RADIO_ACTION, NULL);
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioAction_free
  (JNIEnv *env, jclass cls, jint action)
{
	g_object_unref((GtkRadioAction*)action);
}

#ifdef __cplusplus
}
#endif
#endif
