/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This is the listener interface for receiving dialog events.
 * 
 * @see DialogEvent
 */
public interface DialogListener {
	
	/**
	 * Indicates that the <code>Dialog</code> has fired an event.
	 * 
	 * @param event The event that identifies the details of the event
	 */	
	public boolean dialogEvent(DialogEvent event);
	
}
