/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This is an event for the toggling of {@link org.gnu.gtk.ToggleButton}
 * widgets.
 * To use events, you must use the {@link ToggleListener} class in combination
 * with the addListener methods of the ToggeButton widget.
 */
public class ToggleEvent extends GtkEvent {

	public static class Type extends GtkEventType {
	    private Type(int id, String name){
		super(id, name);
	    }

	    /**
	     * This event indicates that the menu item has been activated.
	     */
	    public static final Type TOGGLED = 
		new Type(1, "TOGGLED");
	}

	/**
	 * Creates a new toggle event
	 * @param source The object which produced the event
	 */
	public ToggleEvent(Object source) {
		super(source, Type.TOGGLED);
	}
}
