package org.gnu.gtk.event;

/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

/**
 * An event represeting action by a {@link org.gnu.gtk.Notebook} widget.
 * @see NotebookListener
 * @see org.gnu.gtk.Notebook
 */

public class NotebookEvent extends GtkEvent {

	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}
		/**
		 */
		public static final Type SELECT_PAGE = new Type(1, "SELECT_PAGE");
		
		/**
		 */
		public static final Type SWITCH_PAGE = new Type(2, "SWITCH_PAGE");
	}
	
	protected int pageNumber = -1;

	/**
	 * Creates a new Notebook Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public NotebookEvent(Object source, Type type) {
		super(source, type);
	}
	
	/**
	 * Creates a new Notebook Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public NotebookEvent(Object source, Type type, int pageNumber) {
		super(source, type);
		this.pageNumber = pageNumber;
	}
	
	/**
	 * Return the page number on which this event occurred.
	 */
	public int getPageNumber() {
		return pageNumber;
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(NotebookEvent.Type aType){
		return ( type.getID() == aType.getID());
	}
}
