/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-19 17:24:52 CDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gnome_appbar_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_new
     * Signature: (ZZI)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1new (JNIEnv *env, jclass cls, 
        jboolean hasProgress, jboolean hasStatus, jint interactivity) 
    {
        gboolean hasProgress_g = (gboolean) hasProgress;
        gboolean hasStatus_g = (gboolean) hasStatus;
        GnomePreferencesType interactivity_g = (GnomePreferencesType) interactivity;
        {
            return (jint)gnome_appbar_new (hasProgress_g, hasStatus_g, interactivity_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_set_status
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1set_1status (JNIEnv *env, 
        jclass cls, jint appbar, jstring status) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        const gchar* status_g = (*env)->GetStringUTFChars(env, status, NULL);
		gnome_appbar_set_status (appbar_g, status_g);
		(*env)->ReleaseStringUTFChars( env, status, status_g );
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_get_status
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1get_1status (JNIEnv *env, 
        jclass cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            return (jint)gnome_appbar_get_status (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_set_default
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1set_1default (JNIEnv *env, 
        jclass cls, jint appbar, jstring defaultStatus) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        const gchar* defaultStatus_g = (*env)->GetStringUTFChars(env, defaultStatus, NULL);
		gnome_appbar_set_default (appbar_g, defaultStatus_g);
		(*env)->ReleaseStringUTFChars( env, defaultStatus, defaultStatus_g );
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_push
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1push (JNIEnv *env, jclass cls, 
        jint appbar, jstring status) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        const gchar* status_g = (*env)->GetStringUTFChars(env, status, NULL);
		gnome_appbar_push (appbar_g, status_g);
		(*env)->ReleaseStringUTFChars( env, status, status_g );
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_pop
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1pop (JNIEnv *env, jclass cls, 
        jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            gnome_appbar_pop (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_clear_stack
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1clear_1stack (JNIEnv *env, 
        jclass cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            gnome_appbar_clear_stack (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_set_progress_percentage
     * Signature: (ID)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1set_1progress_1percentage (
        JNIEnv *env, jclass cls, jint appbar, jdouble percentage) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        gdouble percentage_g = (gdouble) percentage;
        {
            gnome_appbar_set_progress_percentage (appbar_g, percentage_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_get_progress
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1get_1progress (JNIEnv *env, 
        jclass cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            return (jint)gnome_appbar_get_progress (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_refresh
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1refresh (JNIEnv *env, jclass 
        cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            gnome_appbar_refresh (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_set_prompt
     * Signature: (I[BZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1set_1prompt (JNIEnv *env, 
        jclass cls, jint appbar, jstring prompt, jboolean modal) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        gboolean modal_g = (gboolean) modal;
        const gchar* prompt_g = (*env)->GetStringUTFChars(env, prompt, NULL);
		gnome_appbar_set_prompt (appbar_g, prompt_g, modal_g);
		(*env)->ReleaseStringUTFChars( env, prompt, prompt_g );
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_clear_prompt
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1clear_1prompt (JNIEnv *env, 
        jclass cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        {
            gnome_appbar_clear_prompt (appbar_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.AppBar
     * Method:    gnome_appbar_get_response
     * Signature: (I)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_AppBar_gnome_1appbar_1get_1response (JNIEnv 
        *env, jclass cls, jint appbar) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
		return (*env)->NewStringUTF( env, (gchar*)gnome_appbar_get_response (appbar_g) );
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
