/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gnome.IconEntry}widget.
 */
public class IconEntryEvent extends GtkEvent {
	public static class Type extends GtkEventType {
		private Type(int id, String name) {
			super(id, name);
		}
		/**
		 */
		public static final Type CHANGED = new Type(1, "CHANGED");
		public static final Type BROWSE = new Type(2, "BROWSE");
	}

	/**
	 * Creates a new IconEntryrEvent. This is used internally by java-gnome.
	 * Users only have to deal with listeners.
	 */
	public IconEntryEvent(Object source, IconEntryEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(IconEntryEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
