/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * 
 */
public class CanvasBpath extends CanvasShape {

    public CanvasBpath(CanvasGroup group) {
        super(group, gnome_canvas_bpath_get_type());
    }

    /**
     * Constructs an instance of CanvasBpath from a native widget resource.
     * 
     * @param handle
     *            The handle to the native widget.
     */
    CanvasBpath(Handle handle) {
        super(handle);
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gnome_canvas_bpath_get_type());
    }

    native static final protected int gnome_canvas_bpath_get_type();

}
