package radiomenu;

import org.gnu.gnome.App;
import org.gnu.gnome.Program;
import org.gnu.gnome.UIInfo;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.event.MenuItemEvent;
import org.gnu.gtk.event.MenuItemListener;

public class RadioMenu implements MenuItemListener {

    protected App app;

    protected boolean radioOneEnabled = true;

    protected boolean radioTwoEnabled = false;

    protected boolean radioThreeEnabled = false;

    protected boolean toggleOneEnabled = false;

    protected boolean toggleTwoEnabled = false;

    protected boolean toggleThreeEnabled = false;

    public RadioMenu() {

        app = new App("radiomenu", "Radio Menu");
        app.setMinimumSize(200, 100);
        app.addListener(new LifeCycleListener() {
            public void lifeCycleEvent(LifeCycleEvent event) {
            }

            public boolean lifeCycleQuery(LifeCycleEvent event) {
                if (event.isOfType(LifeCycleEvent.Type.DELETE)
                        || event.isOfType(LifeCycleEvent.Type.DESTROY))
                    Gtk.mainQuit();
                return false;
            }
        });

        UIInfo menuInfo[] = buildMyMenus();
        app.createMenus(menuInfo);

        app.showAll();
    }

    public void menuItemEvent(MenuItemEvent event) {
        app.message("Not implemented...");
    }

    public void radioOne() {
        radioOneEnabled = !radioOneEnabled;
        if (radioOneEnabled)
            app.message("Radio One Enabled");
    }

    public void radioTwo() {
        radioTwoEnabled = !radioTwoEnabled;
        if (radioTwoEnabled)
            app.message("Radio Two Enabled");
    }

    public void radioThree() {
        radioThreeEnabled = !radioThreeEnabled;
        if (radioThreeEnabled)
            app.message("Radio Three Enabled");
    }

    public void toggleOne() {
        toggleOneEnabled = !toggleOneEnabled;
        if (toggleOneEnabled)
            app.message("Toggle One Enabled");
        else
            app.message("Toggle One Disabled");
    }

    public void toggleTwo() {
        toggleTwoEnabled = !toggleTwoEnabled;
        if (toggleTwoEnabled)
            app.message("Toggle Two Enabled");
        else
            app.message("Toggle Two Disabled");
    }

    public void toggleThree() {
        toggleThreeEnabled = !toggleThreeEnabled;
        if (toggleThreeEnabled)
            app.message("Toggle Three Enabled");
        else
            app.message("Toggle Three Disabled");
    }

    protected UIInfo[] buildMyMenus() {
        UIInfo radioListMenu[] = {
                UIInfo.radioItem("Radio One", "The first radio button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                radioOne();
                            }
                        }),
                UIInfo.radioItem("Radio Two", "The second radio button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                radioTwo();
                            }
                        }),
                UIInfo.radioItem("Radio Three", "The third radio button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                radioThree();
                            }
                        }), UIInfo.end() };

        UIInfo radioMenu[] = { UIInfo.redoItem(this), UIInfo.separator(),
                UIInfo.radioList(radioListMenu), UIInfo.separator(),
                UIInfo.cutItem(this), UIInfo.end() };

        UIInfo toggleMenu[] = {
                UIInfo.newGameItem(this),
                UIInfo.separator(),
                UIInfo.toggleItem("Toggle One", "The first toggle button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                toggleOne();
                            }
                        }),
                UIInfo.toggleItem("Toggle Two", "The second toggle button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                toggleTwo();
                            }
                        }),
                UIInfo.toggleItem("Toggle Three", "The third toggle button",
                        new MenuItemListener() {
                            public void menuItemEvent(MenuItemEvent event) {
                                toggleThree();
                            }
                        }), UIInfo.separator(), UIInfo.pauseGameItem(this),
                UIInfo.end() };

        UIInfo mainMenu[] = { UIInfo.subtree("Radio Buttons", radioMenu),
                UIInfo.subtree("Toggle Buttons", toggleMenu), UIInfo.end() };

        return mainMenu;
    }

    public static void main(String[] args) {

        Program.initGnomeUI("RadioMenu", "1.0", args);

        RadioMenu rm = new RadioMenu();

        Gtk.main();
    }
}
